 /*------------------------------------------------------------------------------*
 * File Name:Operation.c	 													*
 * Creation: CPY 																*
 * Purpose: utility functions that are needed to compile operation.h			*
 * Copyright (c) Originla Corp.	2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 7/27/2004 QA70-6667 RESULTS_LOG_AS_GRID									*
 *	ML 8/17/2004 QA70-6825 RLOG_QUERY											*
 *  Forest 09/09/04 QA70-6682 SAVE_SETTING_ON_ALL_LEVELS                        *
 *  Iris 9/10/04 OUTPUT_ADD_2ND_GRAPH											*
 *	ML 9/14/2004 QA70-6825 ESCAPED_OP_STRING_CONVERSION_OC						*
 *	Frank 9/15/04 QA70-6903	ADD_OUTPUT_TREE_TO_TABLE_STRING						*
 *  Forest 9/15/04 QA70-6682 SETTINGS_THEME_FILE_SAVE_LOAD						*
 *	CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH								*
 *	CPY 9/24/04 FACTORY_DEFAULT_SAVE_CLASS_NAME_ONLY							*
 *	ML 10/7/2004 MULTIPLE_DATASET_OPER_TREATMENT								*
 *	CPY 10/7/04 COMBO_BRANCH_FOR_MULTIPLE_RANGE_MODE							*
 *	CPY 10/9/04 MOVE_THEME_SAVING_CODES_TO_EDIT									*
 *	ML 10/20/2004 QA70-7075 MASKED_DATA_REPORTING								*
 *	CPY 11/3/04	QA70-7122 ADD_BOX_CHART_TO_DESC_STATS							*
 *	ML 11/23/2004 QA70-6845 LINKS_CLIPBOARD_WORK								*
 *	CPY 11/26/04, DESC_STATS_NO_CURVE_OUTPUT									*
 *	CPY 11/29/04 DESC_STATS_ROWS_LOST_OUTPUT_TO_SOURCE							*
 *  Iris 11/30/04 QA70-7139 IMPROVE_BOOK_SHEET_OPTIONS							*
 *	CPY 12/6/04 SHOW_RANGE_TO_LABEL_FOR_MULTIPLE_RANGE_ON_SAME_DATA				*
 *	CPY 12/13/04 KEEP_SESSION_TEMP_GRAPH_WHEN_FIT_FROM_WKS						*
 *	ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS						*
 *  Iris 12/16/04 QA70-7139 CURVE_OUTPUT_AUTO_UPDATE_IF_REPORT_IS_NONE			*
 *  Iris 12/23/04 QA70-7135 INSERT_FORMULA_TO_SOURCE_GRAPH						*
 *  Iris 12/27/04 IMPROVE_ACCESS_ADVAN_IDS_THEME_FILE							*
 *	CPY 12/31/04 PICTURE_IN_REPORT_IN_BASE_CLASS								*
 *  Iris 01/03/05 SET_GRAPH_HIDDEN_FOR_STRDUMP									*	
 *	Frank 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE								*
 *	ML 1/26/2005 CUSTOM_TABLE_TO_GRAPH											*
 *	DSC 2/4/05 PASTE_FORMULA_TO_GRAPH											*
 *	DSC 2/4/05 NLFIT_THEME_DROP_LIST											*
 *  Iris 3/23/05 QA70-7493 BUILD_XVAR_DATA_BRANCH								*
 *  Iris 3/23/05 QA70-7478 MAKE_EXISTING_WORK_FOR_VAR_DATA						*
 *  Iris 4/01/05 CENTRALIZE_GET_SEL_STR_FROM_COMBOLIST							*
 *  Iris 4/01/05 ADD_GRAPH_INDEX												*
 *  Frank 4/2/05 NEW_METHOD_CHECK_NODE_EMPTY									*
 *  Iris 4/05/05 CLEANUP_GETTING_GRAPH_NODE										*
 *  Frank 4/5/05 GUI_ADVANCED_SETTING_FROM_FILE									*
 *	Frank 4/8/05 GET_BOOK_SHEET_NAME_OF_XVAR_CLASS								*
 *  Iris 4/12/05 MOVE_CURVE_OPTION_TO_EACH_GRAPH								*
 *	EJP 2005-04-13 v8.0222 QA70-7615 XFUNC_TREEVIEW_SHOW_WRONG_DATA_BOOK_AND_SHEET
 *  Iris 4/14/05 UPDATE_GRAPH_LEGEND											*
 *	ML 4/14/2005 DATARANGE_GETTING_FACTORS_VALUES								*
 *	CPY 4/16/05 ACTIVE_BOOK_SHEET_AS_DEFAULT_FOR_XF								*
 *  Iris 5/16/05 EXISTING_BOOK_NEED_INCLUDE_HIDDEN_BOOK							*
 *  Iris 5/16/05 GUI_GRAPH_NODE_IF_NEED_PLOTINFO								*
 *  Iris 5/19/05 QA70-6365 NO_CUSTOM_TABLE_IF_NO_REPORT_SHEET					*
 *  Iris 5/19/05 QA70-6365 SETUP_FITY_CONFID_PRODI_LINE_COLOR					*
 *  Iris 6/04/05 MOVE_FITTED_CURVES_TO_ROOT_LEVEL								*
 *	ML 6/9/2005 REPEATITIVE_STYLES_IN_GRID_THEMES								*
 *	ML 6/27/2005 STYLE_LINKS_WITH_OFFSETS										*
 *  Iris 7/06/05 FOR_MR_ONE_GROUP_DATA_HAS_MULTI_PARTIAL_PLOTS					*
 *	DSC 6/19/05 PREPARE_INPUT_WHEN_FROM_MENU_CMD								*
 *  Iris 8/25/05 CAN_CHOOSE_PASTE_RESULT_TABLE_OR_NOT_WHEN_FIT_FROM_GRAPH		*
 *  Iris 8/25/05 SHOW_PASTE_RESULT_TABLE_BOX_IN_LR_PR							*
 *	Kevin 08/29/05	ADD_GETCOLUMNDESIGNATION									*
 *	Kevin 08/31/05 REMOVE_CUSTOM_TABLE_FROM_DEFAULT_REPORT_TABLE				*
 *  Iris 9/09/05 REMOVE_PLOTS_FROM_HIDDEN_WKS									*
 *	DSC 9/20/05 QA70-8113 NEED_REPEAT_ID_GREATER_THAN_ONE						*
 *	RVD 9/21/2005 QA70-8105 v8.0310 REPLACE_REPORT_COMPLETELY					*
 *  Iris 9/29/05 REMOVE_SOURCE_FROM_OUTPUT_SHEET								*
 *  Iris 9/29/05 CHECK_CREATE_THIS_GRAPH_OR_NOT									*
 *	CPY 10/2/05 DESC_STATS_ON_ROWS_NEED_REPORT_TO_SOURCE						*
 *	ML 10/7/2005 NO_IMAGE_NODE_PRESENT											*
 *  Iris 10/08/05 ADD_OUT_GRAPH_WHEN_PREPARE_GRAPH_NODES						*
 *	Jasmine 10/11/05 v8.0316 SAVE_LAST_USED_FOR_CHANGE_PARAMS					*
 *	ML 10/13/2005 QA70-8157 SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS					*
 *  Iris 10/19/05 NOT_RETURN_FALSE_WHEN_RESULT_GRAPH_NODE_MISS					*
 *	ML 10/19/2005 STATS_ON_ROWS_REPLACE											*
 *	ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE									*
 *	ML 10/26/2005 QA70-8225 ESCAPED_OPER_STRINGS_ANOVAS							*
 *  Iris 11/03/05 QA70-7105-P3 FIX_NO_AXIS_IN_FITTED_CURVE_FOR_PR				*
 *	ML 11/10/2005 QA70-7039 P1-L3 CORRECT_NUM_DATA_WHEN_COMBINED				*
 *  Iris 11/11/05 QA70-8116-P14 REMOVE_NONE_FOR_CURVE_BOOK_LIST					*
 *  Iris 11/21/05 SAVE_RESULT_CURVE_DATAS_IN_SAME_PAGE_MULTI_LAYER				*
 *	Kevin 11/22/05	OPEN_PROJECT_BROWSER_WHEN_SELECT_EXSITING					*
 *  Jim/Kevin 12/02/05 	COMPUTE_NEW_NODES_MODIFICATION							*
 *  Iris 12/22/05 ONLY_PREPARE_THE_SPECIAL_GRAPH								*
 *  Iris 12/22/05 THE_SAME_FORMAT_FOR_ONE_DATA_AND_MULTIP_DATA					*
 *  Iris 1/12/06 QA70-6581 SUPPORT_PLOT_ERR_BAR									*
 *  Iris 1/26/06 QA70-8388 INDEP_DATA_CONSOLID_OR_SEP_REPORT					*
 *	ML 1/31/2006 QA70-8141 UPDATING_TABLE_OBJECTS_IN_GRAPHS_FOR_ANALYSIS		*
 *  Iris 2/20/06 CHANGE_NAME_TO_FOLLOW_EASWAR_SUGGESTION						*
 *  Thomas 03/21/2006 CHECK_MASKED_DATA_AND_MISSING_VALUE_OPTIONS				*
 *  Alex 03/27/06 QA70-8551 DEL_ERR_COL_IN_REPORT_TABLE_IF_NOT_INPUT_ERR        *
 *  Iris 3/31/06 COMMENTED_NO_USEFUL_FILTER_FOR_STR_DUMP_CODES					*
 *  Iris 4/08/06 REPORT_CURVE_TABLE_BAD_APPEAR_IN_HIDDEN_WKS_PAGE				*
 *  Iris 4/24/06 NEED_OVERLOAD_GETNUMDATA_FOR_ROC								*
 *  Thomas 4/25/06 CHECK_MASKEDDATA_AND_MISSINGDATA_NODE_VALID					*
 *	ML 4/28/2006 FRIENDLY_CUSTOM_TABLE_THEME_GENERATION							*
 *	ML 5/15/2006 SPECIAL_NLFITS_CUSTOM_TABLE									*
 *  Iris 5/16/06 MISS_TABLE_NOT_WORK_IF_INCLUDE_GROUP_DATA						*
 *	Thomas 06/07/06 GET_MASKED_AND_MISSING_INDEP_DATA_FOR_MLR					*
 *	ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY								*
 *  Alex 06/13/06 SET_OPTIONAL_REPORT_TABLE_OPEN                                *
 *  Alex 06/13/06 SET_RESULT_CURVES_BRANCH_OPEN                                 *
 *  Alex 06/13/06 SET_REPORT_CUSTOM_TABLE_CLOSE                                 *
 *  Iris 06/29/06 QA70-8678-P4 MUST_KEEP_RESULT_SHEET_IS_ACTIVED_SHEET			*
 *	ML 6/30/2006 QA70-8768 BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS				*
 *  Iris 7/10/06 v8.0440 QA70-7001-P14 NOT_CREATE_RESULT_CURVE_SHEET_IF_NO_REPORT_GRAPH
 *	ML 7/10/2006 QA70-8768 KEEPING_TRACK_OF_GRAPHS_CREATED_FROM_OPERATION		*
 *	CPY QA70-8615-5 7/12/06 REMOVE_COMMENTS_COL_FROM_REPORT						*
 *  Iris 7/13/06 QA70-8678-5 PAST_CUSTOM_TABLE_AFTER_UPDATED_LAST_SOURCE		*
 *  Joe  7/17/06 HIDE_EMPTY_TABLE                                               *
 *  Hong 7/18/06 FIX_RETURN_ERROR 												*
 *	CPY 7/18/06 TREE_SET_ATTRIB_BITS_CLEANUP									*
 *	ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
 *	ML 7/25/2006 NEW_TABLE_ON_AUTOUPDATE_BUG									*
 *	ML 7/26/2006 QA70-8856 PASTING_THEME_WITH_LINKS_OUTSIDE_OF_REPORT			*
 *	ML 8/4/2006 REMOVING_CUSTOM_TABLE											*
 *	ML 8/7/2006 INTERMEDIATE_BOOK_BETTER_CREATION								*
 *	ML 8/10/2006 REMOVING_CUSTOM_TABLE_FROM_GUI									*
 *	ML 8/15/2006 ATTACHING_GRAPHS_TO_CELLS_IN_OPERATION							*
 *  Joe 8/28/06  MOVE_GET_X_FROM_Y_OR_GET_Y_FROM_X_TO_CALIBRATION				*	
 *	ML 9/1/2006 NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL							*
 *  Iris 9/11/06 QA70-8926-5 v8.0478 REMOVE_1_FROM_CUSTOM_TABLE_ROW_COL_NUM		*
 *  Iris 9/12/06 QA70-8593-13 v8.0479 PAST_CUSTOM_TABLE_AFTER_UPDATED_LAST_SOURCE*
 *  Iris 9/13/06 QA8811-P11 USING_VECTOR_POINTER_HERE_CAUSE_CRASH				*
 *  Joseph 09/15/06  HIDE_THE_CALIBRATION_TABLE									*	
 *  Joseph 09/18/06  MOVE_CALIBRATION_TABLE_OUT_OUTPUT							*
 *	Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH						*
 *	Cheney 2006-9-24 IF_RECACULATE_SHOULD_PLOT_GRAPH_AGAIN_ALTHOUGH_PAGE_EXIST	*
 *  Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK			*
 *  Arvin 10/13/06 MOVE_FUNCTIONS_FROM_STATSOPBASE_TO_WKSREPORTOPERATION		*
 * 	Arvin 10/16/06 MOVE_TO_OPERATION_FILE										*
 *	Arvin 10/16/06 MOVE_TO_SUBCLASS												*
 *	Arvin 10/16/06 SEPARATE_OUT_OPERATION_BASE_INTO_SEPARATE_HEADER				*
 *	Arvin 10/20/06 INPUT_DATA_TABLE_GIBBERISH_WHEN_RECALCULATION_IS_NONE		*
 *	Arvin 10/24/06 FITTING_RESIDUALS_HISTOGRAM_PLOT								*
 *  Iris 10/30/06 STATS_ON_ROWS_FAIL_TO_REPORT_INTP_SOURCE						*
 *	Cheney 2006-11-7 DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST					*		
 *  Iris 11/10/06 REMOVE_TRY_BUTTON_FOR_ANALYSIS_STATS_DLG						*
 *	ML 11/13/2006 ESCAPED_STRRINGS_TRANSLATED_FOR_AU_NONE_ONLY					*
 *	ML 11/13/2006 THEME_DIGITS_PARAMETERS_TBL									*
 *	ML 11/14/2006 OLD_GRAPH_PAGES_MUST_BE_PRESERVED								*
 *  Joseph	11/17/06 FIX_BUG_FINDXY_SHEET_ON_FITCURVE_BOOK						*
 *	Cheney 2006-11-21 IF_CONCATENATE_SHOULD_SET_PLOTUID_AS_0_WHEN_DATA_FROM_GRAPH
 *	Cheney 2006-11-21 SHOULD_REPLOT_SOURCE_CURVE_WHEN_CHANGE_PARAMETER			*
 *  Iris 11/23/06 FIX_IF_NOT_REPORT_WKS_RESULT_FAIL_OUTPUT_IN_LOG				*
 *	ML 11/27/2006 ADDITIONAL_LABEL_ROWS_IN_CURVE_SHEETS							*
 *  Iris 12/04/2006 v8.0518 FIX_RUNTIME_ERR_IN_SURFACE_FIT_RECALCULATION		*
 *  Iris 12/12/2006 v8.0523 ASK_USER_IF_ACTIVE_REPORT_SHEET						*
 *	Joseph 12/19/06 SET_THEME_DEFAULT_TO_FACTORY_DEFAULT						*
 *  Iris 12/25/2006 v8.0532 CORRECT_BOOK_OPTION_IF_BOOK_NAME_IS_NOT_EXISTED_AFTER_THEME*
 *	ML 1/9/2007 INPUT_DATA_TBL_MR_MULTI_INDEPS									*
 *	RVD 1/11/2007 SHOULD_USE_FRAME_NOT_CLENTEDGE								*
 *	CPY 1/15/07 FIT_GRAPH_KEEP_ACTIVE_LEAD_TO_WKBOOK_WRONG_ACTIVE_TAB			*
 *  Arvin 01/23/06 MASKED_OR_MISSING_DATA_TABLE_INCOMPLETE_CONCATENATE			*
 *	ML 1/31/2007 QA70-6367 P17 NO_Y_IN_ESCAPED_STRINGS_IF_NO_X					*
 *	Arvin 02/05/07 SET_BIN_DATA_WITH_SAME_MIN_MAX_AND_BINSIZE_WHEN_PLOT_ALL_HISTOGRAM_IN_ONE_GRAPH
 *	Arvin 02/09/07 SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
 *  Iris 02/13/2007 v8.0560 NEED_TO_REMOVE_THIS_NODE_AFTER_CREATE_REPORT		*
 *  Iris 02/13/2007 v8.0560 SHOULD_SUPPORT_AUTOUPDATE_WHEN_SELECT_THEME_FROM_MENU*
 *	ML 2/14/2007 QA70-9374 BAD_EVENT_HANDLER_DWORDS_IN_TREENODES				*
 *	ML 3/1/2007 QA70-9421 UPDATE_TRGUI_TO_CURRENT_BEFORE_RUNNING				*
 *	Arvin 03/07/07 USE_SAME_TEMPLATE_FOR_ALL_PLOTS_IN_ONE_GRAPH					*
 *	ML 3/15/2007 PROPER_CALLING_TO_UPDATE_EXE_INFO								*
 *	ML 3/16/2007 WRONG_ORDER_OF_ARGS											*
 *	ML 3/30/2007 NO_LABELS_IN_PARAMETERS_TABLE_WHEN_EXECUTE_SIMPLE_OC			*
 *	Cheney 2007-3-29 SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG							*
 *	Cheney 2007-4-2 FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING
 *	Cheney 2007-4-2 ADD_HINTS_IN_FOOTNOTE_WHEN_EXISTS_MISSING_OR_MASKED_DATA	*
 *	YuI 04/02/07 DATA_MODE_MUST_BE_DISABLED_IN_CHANGE_PARAM						*
 *	Cheney 2007-4-3 REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX					*
 *  Iris 04/05/2007 v8.0596 FIX_ONLY_ONE_BOX_CHART_EVEN_CHECK_PLOT_ALL_PLOTS_IN_ONE_GRAPH
 *	Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH						*
 *	Cheney 2007-4-12 ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA*
 *	Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE			*
 *	YuI 04/17/07 QA70-4589 IMPROVED_ANALYSIS_MARKERS							*
 *  Iris 4/18/2007 v8.0603 ADD_OUTPUT_DEST_COL_OPTION_STATS_ON_ROWS				*
 *	Cheney 2007-4-19 CHANGE_PARAMS_SHOULD_APLLY_LAST_PARAMS_SETTING				*
 *	Cheney 2007-4-20 OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN		*
 *	Cheney 2007-4-28 AFTER_REMOVE_PLOT_WILL_OUT_OF_INDEX_IF_MULTI_DATASET_AND_CHANGE_PARAM
 *	CPY 5/2/07 QA70-9687 TEMPLATE_FOR_TABLE_INSERT_TO_GRAPH						*
 *	Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT	*
 *	CPY 5/8/2007 QA70-9740 GETN_EVENT_NEED_TO_KNOW_DLG_OPEN_MODE				*
 *	ML 5/10/2007 MUST_PRESERVE_NEW_STR_ATTRIB_HANDLER_RC_IN_INPUT_DATA			*
 *	Cheney 2007-5-23 QA70-9805 SPEED_UP_STATISTIC_ON_ROW						*
 *	ML 6/5/2007 QA70-9869 SPECIAL_GUI_TREE_UPDATE_BEFORE_RERUNNING				*
 *	Cheney 2007-6-6 SHOULD_LOAD_FACTORY_DEFAULT_THEME_FOR_OPERATION_TOOLS_WHEN_OPEN_DLG
 *	Arvin 06/20/07 v8.0645 WRONG_NUMBER_X_CELL_IN_INPUT_DATA_TABLE_FOR_SURFACE_FIT
 *  Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING					*
 *	Arvin 07/09/07 v8.0655 FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
 *	CPY 7/17/2007 QA70-10010-P3 LAST_USED_THEME_WHEN_NOT_FOUND_BREAK_UPDATE_INPUT_TREE
 *	Arvin 07/18/07 v8.0662 FIT_COMPARISION_OF_DATASETS_INCONSISTENT_BETWEEN_NLFIT_AND_LR
 *  Iris 07/31/2007 QA70-10133 CHECK_DO_RESCALE_IF_DATA_OUTSIDE					*
 *  Iris 08/02/2007 v8.0672 FIX_PLOT_ALL_PLOTS_IN_ONE_GRAPH_FAIL_PLOT_ALL_PLOTS	*
 *	ML 8/2/2007 COMPLAINT_ABOUT_TO_LONG_FITTING_FUNCTION_FORMULA_MAKING_COLUMN_TOO_WIDE
 *  Iris 08/06/2007 v8.0674 ALWAYS_COPY_SOURCE_GRAPH_AXIS_TYPE					*
 *	Arvin 08/06/07 QA70-10024 ADD_EMPTY_LABEL_ROW_FOR_PLOT_ALL_IN_ONE_GRAPH		*
 *	Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME								*
 *	ML 8/6/2007 SEEMS_LEGAL														*
 *	Jasmine 08/07/07 SET_LEGEND_MODE_FROM_SOURCE_GRAPH							*
 *  Iris 08/07/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH*
 *	Jasmine 08/07/07 #10175 USE_LNAME_AS_FIT_CURVE_LEGEND						*
 *	Arvin 08/09/07 SHOULD_NOT_REMOVE_SHOW_ATTRIB								*
 *  Iris 08/13/2007 v8.0680 QA70-10212-P2 FAIL_TO_REMOVE_ORIGINAL_SOURCE_DATAPLOT*
 *	Arvin 08/14/07 v8.0681 RUNTIME_ERROR_IN_ANOVA_ONE_WAY						*
 *	Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
 *	Arvin 08/24/07 REPORT_BOOK_DEFAULT_VALUE_SHOULD_NOT_BE_EMPTY_IN_STATS_ON_ROWS
 * 	Arvin 08/28/07 QA70-10073 ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID
 *	Jasmine 08/29/07 FIT_MAT_ALSO_NEED_GET_FITCURVE_OUTPUT						*
 *	Cheney 2007-8-31 QA70-10330 CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
 *	Cheney 2007-9-3 QA70-10331 SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
 *	Arvin 09/03/07 INPUT_TABLE_ROW_LABEL_WRONG_AFTER_CREATE_COPY				*
 *	Cheney 2007-9-7 SHOULD_JUST_SET_SHOW_AS_FALSE_IF_NOT_CHECK_PLOT_FIT_CURVE	*
 *	YuI 09/10/07 QA70-10358 ANOVA_RECALCULATE_FAILS_AFTER_RENAME				*
 *	ML 9/11/2007 BAD_USE_TEST													*
 *	Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT*
 *	Echo 9/26/07 V8.0709 REPLACE_NOT_WORK_FOR_RESET_TREENODE					*
 *	ML 10/1/2007 QA70-10452 NO_COLUMN_SET_AS_CATEG_OPTIONALLY_OC				*
 *	ML 10/2/2007 QA70-10428 UPDATING_GUI_TREE_ANOVA_RM_PROPERLY					*
 *	CPY 10/12/07 10522-P3 CLEANUP_IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
 *	Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
 *	Arvin 10/22/07 ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR	*
 *	Arvin 10/23/07 QA70-10559-P3 SHOULD_NOT_CREATE_EMPTY_SHEET_WHEN_UNCHECK_FITTED_CURVES_PLOT
 *	Arvin 10/26/07 RUNTIME_ERROR_WHEN_COLUMN_TYPE_IS_NOT_DOUBLE					*
 *	Sim 11-05-2007 CLEAN_LOCALIZATION_CODE										*
 * 	Arvin 11/09/07 KEEP_USER_INSERTED_LAYER_IN_REPORT_GRAPH_IN_FITTING			*
 * 	Arvin 11/09/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
 *	Folger 11/14/07 MAP_OPERATION_DIALOG_HELP									*
 *	Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO*
 *	YuI 11/19/07 QA70-10716 GUI_LOCALIZATION_ON_CHANGE_PARAM					*
 *	Arvin 11/20/07 QA70-10708 CHECK_AND_CONVERT_DOUBLE_VALUES_FROM_GERMAN_TO_ENGLISH
 *	ML 11/20/2007 QA70-10716 INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER	*
 *	Folger 11/26/07 SHOW_LABEL_FIT_DATA_WHEN_COME_FROM_PFW						*
 *	Echo 07/11/30 QA70-10589-P3 v8.0757	FITCMP_SUPPORT_POLY_ORDER				*
 *	Folger 12/03/07 LOCALIZE_GRAPH_TYPE_STRING									*
 *	Folger 12/05/07 LOCALIZE_UPDATE_TABLE_GRAPH_OBJECT							*
 *	ML 12/5/2007 QA70-10780 DBG_TREES_IN_RELEASE								*
 *	ML 12/7/2007 QA70-10780 MORE_DEBUGGING_REPORT_FILTERING						*
 *	Arvin 12/11/07 SHOULD_DEL_OLD_TABLE_AND_PASTE_NEW_TABLE_WHEN_CHANGE_PARAM	*
 *	Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said			*
 *	Arvin 01/29/08 GENERATE_REPORT_FOR_LT_NLFit									*
 *	Arvin  01/31/08 ANOVA_REPORT_DATA_SHOULD_NOT_OUTPUT_TO_SOURCE				*
 *	Arvin 02/03/08 QA70-10970 ERORR_BAR_LOST_WHEN_FIT_FROM_GRAPH				*
 *	Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
 *	YuI 02/28/08 QA70-11145 NEED_OPTION_NOT_TO_SWITCH_TO_REPORT_EVEN_IN_WORKSHEET*
 *	Folger 03/12/08 QA80-11244 SURFACE_FIT_REPORT_SHOULD_USE_CONTOUR_PLOTS		*
 *	Folger 03/19/08 QA80-10598 NEW_GETN_LOCALIZAED_CHECK_MACRO					*
 *	Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS								*
 *	Hong 04/10/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
 *	Hong 04/15/08 v8.0843 REMOVE_POINTER_IN_OPERATION_GUI_AVOID_ACCIDENT_CRASH	*
 *	Hong 04/15/08 v8.0843 FIX_AUTO_FAIL_GET_CORRECT_BOOKNAME					*
 *  Iris 4/16/2008 QA80-11282 FIX_ANOVA_ONE_WAY_REPORT_EMPTY_CURVE_SHEET		*
 *	Jasmine 04/16/08 MOVE_UPDATE_MODEL_CODES_IN_FITNL_CLASS						*
 *	CPY 4/24/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET				*
 *	Folger 05/07/08 SHOULD_NOT_GENERATE_OPERATION_THEME_WHEN_RUN_FROM_PA		*
 *	Folger 05/22/08 QA80-11574 SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
 *	CPY 5/29/08 FIX_RUNTIME_ERR_WHEN_CAST_DWORD_TO_OPERATION_POINTER_FOR_GRID	*
 *	Max 6/4/08 v8.0877 THIS_BRANCH_SHOULD_CLOSE_BY_DEFAULT						*
 *	Folger 06/20/08 QA80-11749 REMOVE_UNWANTED_SUBNODES_FOR_GENERAL_XY_FITTING	*
 *	Hong 06/20/08 QA8011751 FIX_OLD_TABLE_FAIL_DEL_WHEN_NAME_ENUMERATED			*
 *  Iris 7/17/2008 v8.0902 QA80-11856 FAIL_SET_REPORT_SHEET_NAME_TO_SHEET1		*
 *	Hong 07/21/08 QA80-11606 FIX_RECALCULATE_LOST_NEW_ADDED_LAYER_IN_FITTED_CURVE
 *	Hong 08/12/08 QA80-11986 FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
 *	Folger 08/18/08 QA80-11303 ADD_PERCENTAGE_PREFIX_FOR_LCL_UCL_IN_SUMMARY_TABLE
 *	Sim 09-03-2008 QA80-12137 NEW_OPERATION_MECHANISM							*
 *	Sim 09-05-2008 QA80-12151 NLFIT_TOO_SLOW_TO_OPEN							*
 *	Kyle 09/24/08 SET_NO_NEED_TO_LOCALIZE										*
 *	Sophy 10/17/2008 QA80-12397 FIX_SET_THEME_ERROR_FITTING_FROM_GRAPH			*
 *	Sophy 10/17/2008 QA80-12000 SHOULD_UPDATE_MASKED_AND_MISSING_DATA_STATS_ON_RECALCULATE
 *	Hong 10/17/08 QA80-10624 NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT				*
 *	CPY 11/02/08 QA70-12480-P4 STATS_ON_ROWS_PUT_LN_INTO_1ST_LABEL_ROW_WHICH_COULD_BE_UNITS
 *  Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP*
 *	Kyle 11/13/2008 KEEP_TREE_DATA_ID_SAME_AS_THE_OLD_XF						*
 *	Folger 11/13/08 QA80-12488 v8.970 PA_FITTING_AUTO_UPDATE_SUPPORT_USE_VECTOR_FOR_UIDS_STORAGE 
 *	Hong 11/15/08 QA80-12584 v8.0972 SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
 *	Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET	*
 *	Hong 11/18/08 QA80-12584 v8.0974 PLOT_BASELINE_IN_SRC_GRAPH_IF_ADD_BACK		*
 *	Sophy 11/28/2008 v8.980d CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
 *	Hong QA80-11606 FIX_LAYER_ARRAMGEMENT_CHANGED_WHEN_RECALCULATE_IF_USER_ADD_NEW_LAYER
 *  Iris 12/08/2008 V8.0982 QA80-12737 FIX_STATS_ON_COL_BOX_PLOT_ALL_IN_ONE_GRAPH_LEGEND_NOT_LIST_ALL_PLOTS*
 *	Folger 12/09/08 v8.0984 SHOULD_ONLY_RESET_REPORT_GRAPH_PAGE_WHEN_PLOT_FIRST_LAYER
 *	Sophy 12/18/2008 v8.0988 QA80-12798 CHANGE_PARAMETERS_SHOULD_SHOW_THEME_MENU*
 *	Sophy 12/19/2008 v8.0988c FIX_POLYNOMIAL_FIT_CAN_NOT_LOAD_DEFAULT_THEME_SETTINGS
 *	Sophy 12/23/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
 *	Sophy 12/29/2008 v8.0991b QA80-12832 SUPPORT_PLOT_CONFIDENCE_AND_PREDICTION_BANDS_FOR_MULTI_INDEPS_AND_DEPS
 *	Sophy 1/5/2009 v8.0993d QA80-12858 GIVE_USEFUL_INFO_ON_REPORT_GRAPH_WITH_FACTOR_VALUE_FOR_STATS_COLUMN
 *	Folger 01/06/09 QA80-12878-P1 v8.0993e NLFIT_FAILS_TO_GET_ALL_DATAPLOTS_FROM_GRAPH
 *	Sophy 1/19/2009 v8.0959 FIX_FITTED_CURVE_HAS_NO_CORRECT_COLOR_INCREMENT		*
 *	Sophy 1/21/2009 v8.0962b FIX_FAIL_TO_GET_RESIDUAL_OUTPUT_WHEN_REPORT_TO_FITTEDCURVE_SHEET
 *	Folger 01/22/09 NLGUI_TREE_LT_ACCESS_CAUSED_RUNTIME_ERROR					*
 *	Sophy 1/23/2009 v8.0964b CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE	*
 *	Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5				*
 *	Sophy 2/2/2009 v8.0969 CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
 *  Iris 2/04/2009 QA80-12937 FIX_FAIL_GET_OUTPUT_SUBNODES_IN_NLGUI_TREE		*
 *	YuI 02/10/09 QA70-13062 NEED_TO_KEEP_DATA_MARKERS_IF_NO_ANALYSIS_MARKERS_CREATED*
 *	Sophy 3/5/2009 QA80-12584 v8.0992 FIX_LOSE_SOURCE_CURVE_WHEN_FIT_FROM_GRAPH_ARRANGE_SAME_PLOTS_ON_ONE_GRAPH
 *	YuI 03/05/09 QA70-13220 WHOLE_WORKSHEET_INPUT_XYRANGE						*
 *	YuI 03/13/09 QA70-13281 TAGGING_AVECURVES_RESULTS_TO_EXCLUDE_THEM_FROM_FUTURE_AVERAGING*
 *	Folger 03/16/09 QA80-13279 REMINDER_MESSAGE_FOR_SWITCH_TO_REPORT_SHEET_SHOULD_NOT_BE_SHOWN_DURING_AUTO_UPDATE
 *  Iris 3/18/2009 FIX_STATS_ON_ROW_INPUT_DATA_GIBBERISH_IN_SCRIPT_WND			*
 *  Iris 3/18/2009 QA80-13304 FIX_MR_RESIDUAL_PLOTS_ALL_PLOTTED_ON_FIRST_X_WITH_RESIDUAL
 *  Iris 3/20/2009 QA80-13285-P2 WANT_MERGE_PARAMETERS_LABEL_IN_REPORT_SHEET	*
 *	Hong 03/20/09 QA80-13327 FIX_GUI_TREENODE_SHOW_AND_ENALBE_STATUS_LOST_WHEN_RECALCULATE_OR_CHANGE_PARAMETER
 *  Iris 3/23/2009 QA80-13331-P1 CENTRILIZE_REPORT_COL_LABEL_CODES				*
 *  Iris 3/24/2009 FIX_CREATE_NEW_NLFIT_FINDXY_REPORT_WHEN_RECALCULATE			*
 *	Folger 03/24/09 QA80-13331-P1 CUSTOMIZED_OUTPUT_COLUMN_LONGNAME_FORMAT_SUPPORT
 *	Hong 03/25/09 QA80-12551 RESET_PLOT_ROW_RANGE_IF_USER_UPDATE_INPUT_DATARANGE_WHEN_CHANGE_PARAMETER
 *	Sophy 3/26/2009 QA80-13351 SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU
 *	Folger 03/26/09 ANALYSIS_OUTPUT_REPORT_SHEET_NAME_SHOULD_BE_EXCLAMATION_CHAR_ENDING
 *	Folger 03/26/09 QA80-13350 RUN_WKS_SCRIPT_AFTER_COLUMNS_STRUCTURE_CHANGED	*
 *	Kyle 03/31/2009 QA80-3224 NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR	*
 *  Iris 04/02/2009 FIX_1ST_COL_EMPTY_IF_CREATE_COPY_INPUT_DATA_TABLE_AS_NEW_SHEET_IN_TWO_WAY_ANOVA_RAW_DATA_TYPE
 *	Sim 04-02-2009 QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE	*
 *	Folger 04/07/09 F1_MAPPING_NOT_WORKING_IN_STATS_XF_ON_G						*
 *	Kyle 04/27/2009 QA80-13488 KEEP_CUSTOMIZE_COLOR_WHEN_CHANGE_PARAMETER_IN_SURFACE_FIT
 *	Hong 05/07/09 QA80-11726 TRY_NOT_TO_REPLACE_TABLE_ALWAYS					*
 *	Hong 05/31/09 QA80-13647-P2A FIX_PASTED_TABLE_FAIL_REFRESH_WHEN_AUTO_UPDATE_FROM_EXCEL_DATA
 *	Sim 06-17-2009 QA80-13786-P2-P4 SPEEP_UP_LINEAR_FIT_WITHOUT_REPORT_TABLE	*
 *	Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
 *	YuI 06/23/09 QA70-13835 ORIGIN_FREEZE_AFTER_DESCRIPTIVE_STATISTICS			*
 *	Folger 07/01/09 QA80-13774-P1 COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
 *	Sophy 7/6/2009 SUPPORT_NANOSIZER_OUTPUTGUIMANAGER							*
 *  Iris 7/23/2009 QA80-14000-P3 FAIL_ADD_RESIDUAL_PLOT_IN_2D_FIT_CHANGE_PARAMETER
 *	TD ML 07-24-2008 QA80-14008 SR6_FIX_CRASH_ON_SHRINKING_SERIES_WITH_LINKS	*
 *  Iris 7/29/2009 QA80-14029 FAIL_CHANGE_INNER_OUTTER_RESIDUAL_LIMIT_ON_CHANGE_PARAM
 *	Folger 08/07/09 QA80-13998-P2 BASELINE_DATA_OUTPUT_LT_STRING_NOT_UPDATED_AFTER_DOING_PA_FITTING
 *	Hong 08/13/09 QA80-14138 REDUCE_OPERATION_SIZE_OF_STATS_ON_COLS				*
 *	Jasmine 08/24/09 QA81-14194 AUTO_SIZE_TO_FIT_DADA							*
 *  Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED	*
 *  Iris 9/3/2009 QA80-14209 ADD_LIMITION_FOR_LARGER_DATA_IN_MASKED_MISSING_DATA_TABLE
 *	Hong 09/04/09 QA80-14258 HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING	*
 *  Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
 *  Iris 9/14/2009 QA80-11710-S1 PUT_REPORT_GRAPH_LABEL_AS_Y_AXES_TITLE			*
 *  Iris 9/14/2009 QA80-14279 ADD_NOTES_TEXT_FOR_EMPTY_MISSING_MASKED_DATA_TABLE*
 *  Iris 9/18/2009 REMOVE_LEGEND_FOR_REPORT_BOX_PLOT							*
 *  Iris 9/18/2009 QA80-11710-P2 IMPROVE_HISTOGRAM_PLOT_IN_ONE_GRAPH			*
 *  Iris 9/21/2009 QA80-14279 KEEP_EMPTY_MASKED_MISSING_TABLE_CLOSE				*
 *	Folger 09/23/09 PATH_INFO_OUTPUT_TO_SCRIPT_WINDOW_WHEN_DO_FITNL_ON_EXCEL_DATA_PLOT
 *  Iris 9/22/2009 STATS_ON_COLS_REPORT_GRAPH_BAD_Y_AXIS_LABEL_WHEN_ONE_DATA_NOT_GROUPING_DATA
 *  Iris 9/27/2009 FIX_RESET_ALL_GRAPHS_WORK_FAILED								*
 *  Iris 10/16/2009 QA80-14482 FIX_TICK_LABEL_OVERLAPPED_WHEN_PLOT_MULTI_IN_ONE_GRAPH
 *  Iris 10/16/2009 QA80-14484 BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION
 *	Folger 10/28/09 QA81-14552 WRONG_REPORT_STATUS_WHEN_CHANGE_PARAM_IN_PA		*
 *	Hong 11/05/09 QA80-14547 DUMP_RESULT_TABLE_DEFAULT_USE_LEFT_JUSTIFIED		*
 *  Iris 11/05/2009 QA81-14599 FIX_STATS_ON_COLS_PLOT_REPORT_GRAPHS_VERY_SLOW	*
 *  Iris 11/09/2009 QA81-14599 IMPROVE_STATS_ON_COLS_CALCULATION_SPEED			*
 *  Iris 11/10/2009 QA81-14482-P2 SET_BOX_PLOT_TICK_LABEL_POSITION_BY_CODE_REPLACE_TEMPLATE*
 *	Sophy 11/10/2009 IMPROVE_CODE_TO_GET_OP_GUI_OUTPUT_NODE						*
 *  Iris 12/08/2009 QA81-14813 RECALCULATE_NOT_UPDATE_REPORT_DATA_LABEL			*
 *  Iris 12/09/2009 QA81-3224-P6 FIX_NOT_PLOT_ERR_COL_IN_LRXERR_REPORT_GRAPH_WHEN_OPEN_DLG_FROM_GRAPH
 *	Hong 12/11/09 QA80-14138-P2 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
 *	Folger 12/14/09 PAMULTIY_FAILS_TO_REMOVE_PEAK_PROPERTIES_SHEET_IF_ONLY_HAS_ONE_COLUMN_OUTPUT
 *	Folger 12/18/09 QA81-14860 NLFIT_RECALCULATE_FAIL_TO_GET_SOURCE_GRAPH		*
 *	Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
 *	Hong 01/04/10 QA80-14907 FITTING_VARIABLE_BETTER_SCOPE						*
 *	Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU				*
 *	Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN			*
 *	Hong 01/19/10 QA80-14988-P1 FIX_EMPTY_TABLE_SHOWN_WHEN_EXPAND_REPORT_SHEET	*
 *  Iris 2/02/2010 QA81-14994 FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET*
 *	Hong 02/02/10 QA80-14801 FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION*
 *	Hong 02/03/10 QA80-15016 FIX_X_DATA_TYPE_CHANGE_WHEN_RECALCUTE				*
 *	CPY 2010-0208 QA81-14801 OC_NEEDS_ARG_CPY_WITH_PAGE_CONTEXT_OPTN			*
 *  Iris 2/12/2010 TO_FIX_PEARSONS_R_VALUE_APPEAR_IN_REPORT_TABLE_IN_PR_AS_DEFAULT
 *	Hong 02/22/10 QA80-15137 FIX_FAIL_PLOT_ALL_FITTEDCURVE_TO_SOURCE_GRAPH_WHEN_PLOT_ALL_IN_ONE_GRAPH
 *	Hong 03/01/10 QA80-10136 GROUP_FITTED_CURVE_IN_SRC_GRAPH_AS_SRC_PLOT		*
 *	Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT			*
 *  Iris 7/12/2010 ORG-300-P2 FIX_LCL_UCL_PLOT_COLOR_NOT_SAME_BUG				*
 *	Folger 08/27/2010 ORG-922 SCRIPT_AFTER_FIT_FAIL_WHEN_LAST_STATEMENT_IS_COMMENT
 *	Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
 *------------------------------------------------------------------------------*/

#include <origin.h> // main Origin C header that is precompiled and already include most headers 

#pragma labtalk(0) //--- CPY 7/26/05 hide all functions in this file from LT access, as XF should be used instead

#include <Operation.h>        // Operation class

#include "wksOperation.h" ///Arvin 10/16/06 SEPARATE_OUT_OPERATION_BASE_INTO_SEPARATE_HEADER
#include "stats_guis.h"

///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
//#define STR_ALLOW_REPORT_TO_SOURCE_SHEET_ATTRIB	"ReportToSrcSheet" //--- CPY 10/2/05 DESC_STATS_ON_ROWS_NEED_REPORT_TO_SOURCE
///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK

#include <oErrMsg.h>	///Echo 7/7/06
#include "XFunctionEx.h"
/// YuI 06/07/06 INPUT_DATA_HAS_TO_BE_RESOLVED_BEFORE_USE
#include <xfutils.h>
/// end INPUT_DATA_HAS_TO_BE_RESOLVED_BEFORE_USE
/// end VECTORIAL_NUMERIC_FUNCTIONS

//#include <OCTreeUtils2.h> //---------- CPY 7/18/06 TREE_SET_ATTRIB_BITS_CLEANUP
#include <OCTreeUtils.h>	// Hong 7/26/06 REMOVE_TEMP_HEADER

/// ML 8/7/2006 INTERMEDIATE_BOOK_BETTER_CREATION
#include <okocUtils.h>
/// end INTERMEDIATE_BOOK_BETTER_CREATION
#include <event_utils.h> ///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
#ifdef BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION
#include "graph_utils.h"
#endif //BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION

#define _DBMGS(_STR)		//out_str(_STR);
#define HOUR_GLASS			waitCursor junk;

#ifdef _MEASUER_GRID_RESIZE_TIME
	#include <Profiler.h>
	#define PROFILE_HRGLASS		Profiler junk; //HOUR_GLASS	//
#else
	#define PROFILE_HRGLASS		HOUR_GLASS
#endif

//---- CPY 12/12/05 MOVE_NLF_TO_UTILS_FILE, no need to include this as op_is_3d_function is no longer called
//#include "nlsf_utils.h"	///Iris 12/12/05 MOVE_NLF_TO_UTILS_FILE
//----

/// YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT
// moved to theme_utils.h
//	#define STR_SHOW_ADVANCED "ShowAdvanced" //--- CPY 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE 
/// end XF_THEME_SUPPORT

//--- CPY 4/16/05 ACTIVE_BOOK_SHEET_AS_DEFAULT_FOR_XF 
//#define STR_XF_DEFAULT_BOOK_NAME	"XFBook"   ///Iris 3/23/05 QA70-7493 BUILD_XVAR_DATA_BRANCH
//#define STR_XF_DEFAULT_SHEET_NAME	"XFSheet"
#define STR_XF_DEFAULT_BOOK_NAME	STR_ACTIVE
#define STR_XF_DEFAULT_SHEET_NAME	STR_ACTIVE
//---
#define GETN_BEGIN_BRANCH_L(_NODE_NAME, _NODE_LABEL) 	_tmpSubNode = _tmpNode.AddNode(cvt_str_to_tag_name(_NODE_NAME), TRGP_BRANCH);TREE_ADD_LABEL(_NODE_LABEL);\
TreeNode _tmSave_##_NODE_NAME = _tmpNode; _tmpNode = _tmpSubNode;
#define GETN_END_BRANCH_L(_NODE_NAME)					_tmpNode = _tmSave_##_NODE_NAME;

#define GETN_CHECK_L(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL)  _tmpSubNode = _tmpNode.AddNumericNode((int)_DEFAULT_VAL, _NODE_NAME, TRGP_CHECK);TREE_ADD_LABEL(_NODE_LABEL);  ///Iris 5/16/05 GUI_GRAPH_NODE_IF_NEED_PLOTINFO

///Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
//int	plot_data_range(DataRange& dr, GraphLayer& gl, int nPlotType, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL);
/// Iris 08/06/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
//int	plot_data_range(DataRange& dr, GraphLayer& gl, int nPlotType, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL, int* pDelCol = NULL);
///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPHs
///end FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
/////Cheney 2006-11-7 DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
//#define STR_ATTRIB_OLD_COMBO_VAL "old_combo_val"
/////end DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
//typedef void (*FUNC_BUILD_OUTPUT_BOOK_SHEET_OPTION) (TreeNode& trGUI, int nReportBookType, int nCurveBookType, bool bAllowReportToSourceSheet = false, bool bAllowReportToSrcBook = true, LPCSTR lpcszBook = NULL);
//typedef void (*FUNC_CHECK_ASK_CUSTOM_BOOK_SHEET_NAME) (TreeNode& trGUI, TreeNode& trReport, const string& str2ndPart, const string& strReportBook, bool bSheet = true, int nDBTY = DBTY_CURVE_OUTPUT, int nSheetType = WKS_ALL, int nBookSheetType = 0);
//typedef void (*FUNC_GET_PROJECT_PAGE_NAMES) (vector<string> &vsPagesName, uint nPageType  = EXIST_WKS);
//typedef void (*FUNC_SHOW_REPORT_COLUMN_OPTION) (TreeNode& trGUI);
//typedef string (*FUNC_GET_SHEETS_IN_BOOK) (const Page& pg, int nSheetType = WKS_ALL);
//typedef bool (*FUNC_UPDATE_OUTPUT_CURVE_BOOK_SETTING) (TreeNode& trRootNode, TreeNode& trData, int& nCurveBookType, string& str2ndPart, LPCSTR lpcszBook = NULL);
//typedef string (*FUNC_GET_SOURCE_PAGE_NAME) (TreeNode& trOperation, string *pstrLayerName = NULL);
//typedef bool (*FUNC_UPDATE_OUTPUT_CURVE_BOOK_OPTION) (TreeNode& trGUI, string& str2ndPart, int nCurveBookType, LPCSTR lpcszBook = NULL);
//typedef bool (*FUNC_OUTPUT_REPORT_BOOK_EVENT) (TreeNode& trGUI, LPCSTR lpcszBook = NULL);
////--------- CPY 10/15/07 QA70-10536 POST_SR0_725_OUTPUT_LOCATION_CLEANUP
////typedef bool (*FUNC_BUILD_REPORT_BOOK_OPTION) (TreeNode& trBook, bool bAllowToSource = true, LPCSTR lpcszBook = NULL);
////---------
/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING

#define		STR_OP_RESULT_PLOT_STORAGE		"OPUID" //---- Iris 11/10/06 PLOT_MORE_ONE_RESULT_PLOTS_AFTER_CHANGE_PARAMS

#define		MASKED_MISSING_DATA_TABLE_MAX_ROW_NUM			1000 /// Iris 9/3/2009 QA80-14209 ADD_LIMITION_FOR_LARGER_DATA_IN_MASKED_MISSING_DATA_TABLE

////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
#define CONST_ROW_SIZE 8   ///Joseph 09/27/06 FINDXY_TO_SEPERATE_SHEET
//#define _SHOW_DEBUG_MSG

#ifdef _SHOW_DEBUG_MSG
	#define _DEBUG_PLOT_UID(_str, _uid)	_show_plot_uid(_str, _uid);
	#define _DEBUG_STR2(_S, _S1, _S2) {string str;str.Format(_S, _S1, _S2);str.WriteLine(WRITE_COMPILER_OUTPUT);}
	#define _DBINT(_STR, _INT)			out_int(_STR, _INT);
	
	void _show_plot_uid(LPCSTR lpcszMsg, DWORD dwPlotUID)
	{
		string str = " found invalid PlotUID";
		string strMsg = (string) "-----> " + lpcszMsg;
		if(dwPlotUID == 0)
		{
			str = " dwPlotUID = 0";
		}
		else
		{
			DataPlot dp;
			dp = (DataPlot)Project.GetObject(dwPlotUID);
			if(dp)
			{
				GraphLayer gl;
				dp.GetParent(gl);
				if(gl)
				{
					str = " found Plot " + ((int)dwPlotUID) + " from " + gl.GetPage().GetName();
				}
			}
		}
		strMsg += str + "\n";
		strMsg.WriteLine(WRITE_COMPILER_OUTPUT);
	}
#else
	#define _DEBUG_PLOT_UID(_str, _uid)	
	#define _DEBUG_STR2(_S, _S1, _S2)
	#define _DBINT(_STR, _INT)
#endif
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////




///////////////////////////////////////////////
// Operation class implementations moved away from operation.h
// CPY 6/11/04
//
	//virtual

// end Operation class implementations
////////////////////////////////////////////////

//----- Iris 06/01/2007 v8.0631 want to use them in xf, so move to tree_utils.c
/*
void	tree_add_more_labels(TreeNode &trParent, vector<string> &vstrFactors, int nStartIndex, LPCSTR lpcszLastLabel) //=0,NULL
{
	string		strAttName;
	int			nNumFactors = vstrFactors.GetSize();
	for (int ifct = nStartIndex; ifct < nNumFactors; ifct++)
	{
		strAttName.Format(STR_SUB_HEADER_ATTRIB_PREFIX "%d", ifct);
		trParent.SetAttribute(strAttName, vstrFactors[ifct]);
	}
	
	if(lpcszLastLabel) //CPY 6/8/04 
	{
		strAttName.Format(STR_SUB_HEADER_ATTRIB_PREFIX "%d", ifct);
		trParent.SetAttribute(strAttName, lpcszLastLabel);
	}
}

// This function can set both STR_LABEL_ATTRIB (if index < 0) and DATAFACT_ATTRIBUTE_PREFIX<index> 
// attributes which are used for column/row headings
void	tree_add_one_label(TreeNode &trParent, LPCTSTR lpcszLabel, int index)
{
	string		strAttName;
	if (index < 0)
		strAttName = STR_LABEL_ATTRIB;
	else
		strAttName.Format(STR_SUB_HEADER_ATTRIB_PREFIX "%d", index);
	
	trParent.SetAttribute(strAttName, lpcszLabel);
}
*/
//-----

///Arvin 11/15/07 ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
bool  get_graph_page_names_by_plot_id(const vector<uint>& vPlotUID, vector<string>& vGPNames)
{
	vector<uint> vUID;
	vUID = vPlotUID;
	int nSize = vUID.GetSize();
	if(nSize < 1)
		return false;
	
	vUID.Sort();
	for(int ii = nSize-1; ii > 0; ii--)
	{
		if(vUID[ii] == vUID[ii-1])
			vUID.RemoveAt(ii);
	}

	for(int iPlot = 0; iPlot < vUID.GetSize(); iPlot++)
	{
		DataPlot	dp;
		dp = (DataPlot)Project.GetObject(vPlotUID[iPlot]);
		if(dp)
		{
			GraphLayer gl;
			dp.GetParent(gl);
			if(gl)
			{
				GraphPage gp;
				gl.GetParent(gp);
				string strName = "";
				if(gp)
					gp.GetName(strName);
				
				if(!strName.IsEmpty())
					vGPNames.Add(strName);
			}
		}			
	}
	
	return true;
}
	
bool has_two_same_strings(const vector<string>& vString, bool bCaseSensitive)
{
	int nSize  = vString.GetSize();
	if(nSize < 2)
		return false;
	for(int ii = 0; ii < nSize-1; ii++)
	{
		string str = vString[ii];
		int nFind = vString.Find(str, ii+1, bCaseSensitive);
		if(nFind >= 0 && nFind < nSize)
			return true;
	}
	
	return false;
}
///end ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR

int GetTableStringGraphs(bool bTranspose, bool bHideRowLabel, bool bHideColLabel)// = false, = true, = true
{
	/// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT, need row label Report Graphs in MR
	//uint nn = GETNBRANCH_OPEN | GETNBRANCH_HIDE_ROW_LABELS | GETNBRANCH_ROW_HEADINGS_SPECIAL;
	uint nn = GETNBRANCH_OPEN;
	nn |= COMMON_TABLE_STR_BITS;	/// RVD 1/11/2007 SHOULD_USE_FRAME_NOT_CLENTEDGE
	if(bHideRowLabel)
		nn |= GETNBRANCH_HIDE_ROW_LABELS | GETNBRANCH_ROW_HEADINGS_SPECIAL;
	if(bHideColLabel)
		nn |= GETNBRANCH_HIDE_COL_LABELS;
	///end REPORT_GRAPHS_ARRANGEMENT
	if(bTranspose)
		nn |=GETNBRANCH_TRANSPOSE ;
	
	nn |= GETNBRANCH_FIT_ROW_HEIGHT|GETNBRANCH_FIT_COL_WIDTH;
	
	nn |= GETNBRANCH_HIDE_COL_HEADINGS | GETNBRANCH_HIDE_ROW_HEADINGS; /// Iris 8/03/06 from Max's suggestion
	
	return nn;		
}


///Arvin 02/05/07 SET_BIN_DATA_WITH_SAME_MIN_MAX_AND_BINSIZE_WHEN_PLOT_ALL_HISTOGRAM_IN_ONE_GRAPH
static bool _link_x_to_base_layer(GraphPage& gp, int nLayers, int nBaseLayer)
{
	GraphLayer gl;
	for(int ii = nBaseLayer + 1; ii < nBaseLayer + nLayers; ii++)
	{
		gl = gp.Layers(ii);
		if(!gl)
			return false;
		
			Tree tr;
			tr.Root.Link.LinkTo.nVal = nBaseLayer + 1;
			tr.Root.Link.XAxisLink.nVal = 1;
			tr.Root.Link.YAxisLink.nVal = 0;
			int nErr = gl.UpdateThemeIDs(tr.Root);
			if(nErr == 0)
			{
				nErr = gl.ApplyFormat(tr, true, true);
			}
		}
	
	return true;
}
///end SET_BIN_DATA_WITH_SAME_MIN_MAX_AND_BINSIZE_WHEN_PLOT_ALL_HISTOGRAM_IN_ONE_GRAPH

///Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
static bool _get_all_layers_X_min_max(GraphPage& gp, int nNumLayers, double& dMin, double& dMax)
{
	GraphLayer gl;
	for(int ii = 0; ii < nNumLayers; ii++)
	{
		gl = gp.Layers(ii);
		if(!gl)
			return false;
		double dFrom = gl.X.From;
		double dTo =  gl.X.To;
		if(ii == 0)
		{
			dMin = dFrom;
			dMax = dTo;
		}
		else
		{
			if(dFrom < dMin)
				dMin = dFrom;
			if(dMax < dTo)
				dMax = dTo;
		}
	}
	
	return true;
}
///end SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL

//----- CPY 10/12/07 10522-P3 CLEANUP_IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
/*
///Arvin 07/09/07 v8.0655 FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
bool WksReportOperation::IsInputDataFromExcel(const TreeNode& trGUI)
{
	DataRange		rngInput;
	TreeNode trInputData = trGUI.InputData;
	if(trInputData)
		rngInput.Create(trInputData, FALSE);
	if(rngInput)
	{
		Datasheet		dsInput; 
		WorksheetPage	pgInput;
		rngInput.GetParent(dsInput); 
		if (dsInput)
		{
			dsInput.GetParent(pgInput);
			if(pgInput)
				return pgInput.m_bIsExcel;
		}
		
		return false;
	}
	
	return false;
}*/
///end FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE

///------ Folger 03/26/09 QA80-13350 RUN_WKS_SCRIPT_AFTER_COLUMNS_STRUCTURE_CHANGED
class	MessageQueueExecutePauser
{
public:
	MessageQueueExecutePauser(bool bPause)
	{
		double	rr;
		LT_get_var("@QPT", &rr);
		bPreValQPT = (bool)rr;
		LT_get_var("@QPM", &rr);
		bPreValQPM = (bool)rr;
		
		rr = bPause;
		LT_set_var("@QPT", rr);
		LT_set_var("@QPM", rr);
	}
	~MessageQueueExecutePauser()
	{
		double	rr = bPreValQPT;
		LT_set_var("@QPT", bPreValQPT);
		rr = bPreValQPM;
		LT_set_var("@QPM", bPreValQPM);
	}
	
private:
	bool		bPreValQPT;
	bool		bPreValQPM;
};
///------ End RUN_WKS_SCRIPT_AFTER_COLUMNS_STRUCTURE_CHANGED

//virtual
BOOL	WksReportOperation::Execute(int nExeMode, DWORD dwExecCntrl)	//CPY 2/24/08 SPFW_NEED_BETTER_OP_EXEC_CNTRL, added dwExecCntrl
{
	///------ Folger 03/26/09 QA80-13350 RUN_WKS_SCRIPT_AFTER_COLUMNS_STRUCTURE_CHANGED
	MessageQueueExecutePauser		clPauser(true);	
	///------ End RUN_WKS_SCRIPT_AFTER_COLUMNS_STRUCTURE_CHANGED
	
	/// ML 3/18/2008 QA70-10598 FORCE_REPORT_TO_ENGLISH
	///// ML 3/1/2007 QA70-9421 UPDATE_TRGUI_TO_CURRENT_BEFORE_RUNNING
	//if (OEXEM_ON_AUTOUPDATE_MANUAL == nExeMode || OEXEM_ON_AUTOUPDATE_TASK == nExeMode)
	//	updateTreeBeforeRunning();
	///// end UPDATE_TRGUI_TO_CURRENT_BEFORE_RUNNING
	//
	int				nLanguageSwitchMsg  = LANGSWITCH_BEFORE_RUN_FIRST_TIME;
	if (OEXEM_ON_AUTOUPDATE_MANUAL == nExeMode || OEXEM_ON_AUTOUPDATE_TASK == nExeMode)
	{
		updateTreeBeforeRunning();
		nLanguageSwitchMsg = LANGSWITCH_BEFORE_RECALC;
	}
	int				nLangSwitch = LanguageSwitch(nLanguageSwitchMsg, 0);
	/// end FORCE_REPORT_TO_ENGLISH
	
	/// ML 11/10/2006 NLFIT_MODAL_CLEANUP
	//return executeWithRange(nExeMode); 
	//---------- CPY 2/24/08 SPFW_NEED_BETTER_OP_EXEC_CNTRL
	//BOOL	bExeRet = executeWithRange(nExeMode);
	BOOL	bExeRet = executeWithRange(nExeMode, dwExecCntrl);
	//----------
	/// ML 3/13/2007 QA70-9477 PROPER_OCOPERATION_CLEANUP_AFTER_EXEC
	//return PostExecute(nExeMode, bExeRet);
	BOOL	bb = PostExecute(nExeMode, bExeRet);
	// This doesn't really fix the bug, but I see it should not be called from within
	// executeWithRange().
	
	/// ML 3/18/2008 QA70-10598 FORCE_REPORT_TO_ENGLISH
	LanguageSwitch(LANGSWITCH_RESTORE, nLangSwitch);
	/// end FORCE_REPORT_TO_ENGLISH
	
	return bb;
	/// end PROPER_OCOPERATION_CLEANUP_AFTER_EXEC
	/// end NLFIT_MODAL_CLEANUP
}

//------ Folger 01/04/08 QA70-10890 ALWAYS_RUN_AFTER_FIT_SCRIPT_AFTER_EXECUTE
//virtual
/// YuI 11/12/08 ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
//	BOOL	WksReportOperation::OnAfterExecute()
BOOL	WksReportOperation::OnAfterExecute(int nExeMode)
/// end ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
{
	/// YuI 11/12/08 ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
	//	BOOL bRet = OperationBase::OnAfterExecute();
	BOOL bRet = OperationBase::OnAfterExecute(nExeMode);
	/// end ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
	Tree trOp;
	GetTree(trOp);
	TreeNode trAfterFit = tree_get_node_by_tagname(trOp, "AfterFit", true);
	if ( trAfterFit )
	{
		string str = trAfterFit.strVal;
		if ( !str.IsEmpty() )
		{
			/// Hong 01/04/10 QA80-14907 FITTING_VARIABLE_BETTER_SCOPE
			//LT_execute(str);
			string		strSrciptInLocalScope;
			///------ Folger 08/27/2010 ORG-922 SCRIPT_AFTER_FIT_FAIL_WHEN_LAST_STATEMENT_IS_COMMENT
			//strSrciptInLocalScope.Format("{%s}", str);
			strSrciptInLocalScope.Format("{\n%s\n}", str);
			///------ End SCRIPT_AFTER_FIT_FAIL_WHEN_LAST_STATEMENT_IS_COMMENT
			LT_execute(strSrciptInLocalScope);
			/// end FITTING_VARIABLE_BETTER_SCOPE
		}
	}
	return bRet;
}
//------

///Arvin 06/29/07 v8.652 XOP_NEED_SUPPORT_NLFIT
//virtual
int	WksReportOperation::OnInitOperationTreeFromOCLT(TreeNode &trOp, TreeNode& trOCLT,  bool bInitTree )
{
	TreeNode trOutGUI = trOCLT.GetNode("GUI");
	TreeNode trInputData = trOutGUI.InputData;
	if(!trInputData)
		return OP_INVALID_INPUT_DATA_NODE;
	
	init_input_data_branch_from_selection(trOp.GUI.InputData, GetDataRules(trOp));	
	trInputData.Replace(trOp.GUI.InputData.Clone());
	return OP_NOERROR;
}
///end XOP_NEED_SUPPORT_NLFIT
///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
string WksReportOperation::GetSourcePageName(TreeNode& trOp, Datasheet& ds)
{
	///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
	//string strBook;
	//Page pg;
	//if(ds)
		//pg = ds.GetPage();
	//else
		//pg = Project.Pages();
	//if(!ds)
		//strBook = "";
	//else
		//strBook = page_get_display_name(pg, true);
	//return strBook;
	/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	//return get_source_page_name(trOp);
	return get_source_page_name(trOp.GUI);
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
}
///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK

///Arvin  01/31/08 ANOVA_REPORT_DATA_SHOULD_NOT_OUTPUT_TO_SOURCE
//virtual 
bool WksReportOperation::IsAllowReportToSource(TreeNode& trGUI)
{
	return is_range_from_normal_book(trGUI.InputData);
}
///end ANOVA_REPORT_DATA_SHOULD_NOT_OUTPUT_TO_SOURCE

bool WksReportOperation::GUIPrepareOutputBranch(TreeNode& trGUI, Worksheet& wksReport)// = NULL
{
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	/*
	TreeNode trOutputBook = trGUI.Output.Report.Book;
	TreeNode trOutputSheet = trGUI.Output.Report.Sheet;
	if(!trOutputSheet)
		return error_report("Operation GUI tree lack proper output sheet node");
	if(!trOutputBook)
		return error_report("Operation GUI tree lack proper output book node");
	*/
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	
//----- CPY 10/12/07 10522-P3 CLEANUP_IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
/*		
	///Cheney 2007-10-12 IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
#ifdef NLFIT_CHECK_LOOSE_DATASET
	bool bLooseDataset = false;
	FUNC_IS_LOOSE_DATASET pfn = Project.FindFunction("is_loose_dataset", "OriginLab\\Event_utils", true);
	if(pfn)
		bLooseDataset = pfn(trGUI.InputData.Range1); 

	bool bAllowToSource = IsInputDataFromExcel(trGUI) ||  bLooseDataset? false : true;
#else 
	///end IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
	///Arvin 07/09/07 v8.0655 FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
	bool bAllowToSource = IsInputDataFromExcel(trGUI) ? false : true;
	///end FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
#endif//NLFIT_CHECK_LOOSE_DATASET ///Cheney 2007-10-12 IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE	
*/
	///Arvin  01/31/08 ANOVA_REPORT_DATA_SHOULD_NOT_OUTPUT_TO_SOURCE
	//bool bAllowToSource = is_range_from_normal_book(trGUI.InputData);
	bool bAllowToSource = IsAllowReportToSource(trGUI);
	///end ANOVA_REPORT_SHOULD_NOT_OUTPUT_TO_SOURCE
//----- end ANOVA_REPORT_DATA_SHOULD_NOT_OUTPUT_TO_SOURCE
	
	///Cheney 2006-11-7 DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
	//int nChoice = 0;
	//string strSheets;
	//string strBook;
	//WorksheetPage wp = Project.Pages();
	//string strCurrentBookName;
	//if(wp)
		//strCurrentBookName = wp.GetName();
	//
	////string strSheetListTopPart = STR_TOKEN_SEP;  ///Iris 11/22/04 UPDATE_DROPLIST_TO_DROPDOWN
	//string strSheetListTopPart;
	//strSheetListTopPart += STR_NEW + STR_TOKEN_SEP;
	//if(wksReport) // given, no need to specifiy
	//{
		//WorksheetPage wpReport = wksReport.GetPage();
		//string strReportBookName = wpReport.GetName();
		//strSheets = wksReport.GetName();
		//strBook = page_get_display_name(wpReport, true);
		//if(strCurrentBookName == strReportBookName) // same book
		//{
			//// not sure what needed to be done
		//}
	//}
	//else if(!wp) // starting GetN from Graph, then we have to make use of trGUI's inputData 
		//strSheets = strSheetListTopPart + GetReportSheetsFromInputData(trGUI);
	//else
	//{
		//strBook = page_get_display_name(wp, true);
		//strSheets = strSheetListTopPart + get_report_sheets_in_book(wp, nChoice);
	//}
	////--- CPY 10/8/04 QA70-7025 v8.0147 REPORT_BOOK_INDICATE_SOURCE_BOOK 
	////if(trOutputBook.strVal.IsEmpty())
	////	trOutputBook.strVal = strBook;
	//setReportOutputBookName(trOutputBook, strBook);
	////---
	//strSheets += STR_CUSTOM + STR_THREE_DOTS;  ///Iris 11/12/04 QA70-7139 FIX_CURVE_SHEET_ALWAYS_SAME_AS_REPORT_SHEET
	string strBook;
	WorksheetPage wp = Project.Pages();
	string strCurrentBookName;
	if(wp)
		strCurrentBookName = wp.GetName();
	
	if(wksReport) // given, no need to specifiy
	{
		WorksheetPage wpReport = wksReport.GetPage();
		string strReportBookName = wpReport.GetName();
		strBook = page_get_display_name(wpReport, true);
		if(strCurrentBookName == strReportBookName) // same book
		{
			// not sure what needed to be done
		}
	}
	///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	//else if(!wp)
	//	strBook = "";
	//else
	//	strBook = page_get_display_name(wp, true);
	else
		strBook = GetSourcePageName(trGUI.Parent());	
	///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	/*
	///Arvin 07/09/07 v8.0655 FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
	//setReportOutputBookName(trOutputBook, strBook);
	/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME, changed to the proper function name
	//setReportOutputBookName(trOutputBook, strBook, bAllowToSource);
	setReportOutputBook(trOutputBook, strBook, bAllowToSource);
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	///end FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
	
	///Arvin 07/09/07 v8.0655 FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
	//string strSheets = STR_NEW + STR_TOKEN_SEP + STR_SOURCE_BOOK;
	string strSheets = STR_NEW + STR_TOKEN_SEP;
	///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	//if(bAllowToSource)
	//	strSheets += STR_SOURCE_BOOK;
	///CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	///end FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
	///end DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
	///Cheney 2007-10-16 QA70-10536-p16 STATS_ON_ROW_REPORT_TABLE_SHEET_LEVEL_CANNOT_WORK_FINE
	if(bAllowToSource)
		strSheets += STR_SOURCE_BOOK;
	///end STATS_ON_ROW_REPORT_TABLE_SHEET_LEVEL_CANNOT_WORK_FINE
	trOutputSheet.SetAttribute(STR_COMBO_ATTRIB, strSheets);
	///Frank 4/2/05		NEW_METHOD_CHECK_NODE_EMPTY
	//if(trOutputSheet.strVal.IsEmpty())
	if(trOutputSheet.IsEmpty())
	///End		NEW_METHOD_CHECK_NODE_EMPTY
		trOutputSheet.strVal = STR_NEW;
	
	set_report_output_book_sheet_name_by_type(trGUI); /// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME

	
	//--- CPY 9/2/04, Notes window drop down
	TreeNode trNotes = trGUI.Output.Report.DumpNotesWindow;
	if(!trNotes)
		return error_report("Operation GUI tree lack proper output Notes node");
	string strNotesList = STR_TOKEN_SEP;
	strNotesList += STR_NONE + STR_TOKEN_SEP + STR_NEW;
	trNotes.SetAttribute(STR_COMBO_ATTRIB, strNotesList);
	//---
	
	if(trGUI.Output.Data) //CPY 10/18/04
		///Arvin 07/09/07 v8.0655 FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
		//setCurvesOutputBookSheet(trGUI);
		///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		//setCurvesOutputBookSheet(trGUI, bAllowToSource);
		setCurvesOutputBookSheet(trGUI, bAllowToSource, strBook);
		///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		///end FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
	return true;
	*/
	SetOutputBookSheetDefaultName(trGUI);
	
	bool 	bRet;
	if( InitOutputGUIManagerPointer(trGUI) )
	{
		DWORD dw = (DWORD)m_pOutputManager;
		/// Hong 04/15/08 v8.0843 REMOVE_POINTER_IN_OPERATION_GUI_AVOID_ACCIDENT_CRASH
		/*
		///Iris 4/10/2008 PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
		//trGUI.Output.SetAttribute(STR_OUTPUT_MANAGER_POINTER, (int)dw);
		trGUI.Output.OutManagerPointer.nVal = (int)dw;
		trGUI.Output.OutManagerPointer.Show = false;
		trGUI.Output.OutManagerPointer.DataID = IDE_OUTPUT_MANAGER_POINTER; /// Iris 4/14/2008 FAIL_TO_GET_OUTPUT_POINTER_IN_PA_FIT
		///end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
		
		/// Iris 4/14/2008 GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE			
		trGUI.Output.OperationPointer.nVal = (int)this;
		trGUI.Output.OperationPointer.Show = false;
		trGUI.Output.OperationPointer.DataID = IDE_OPERATION_POINTER;						
		///end GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
		*/		
		TreeNode	trOuputMngrPtr = tree_check_get_node(trGUI.Output, "OutManagerPointer"); 
		trOuputMngrPtr.SetAttribute(STR_DATAID_ATTRIB, IDE_OUTPUT_MANAGER_POINTER);
		trOuputMngrPtr.nVal = (int)dw;
		trOuputMngrPtr.Show = false;
		trOuputMngrPtr.SetAttribute(STR_XVARIABLE_THEME_APPLICABILITY_ATTRIB, XVTA_DO_NOT_APPLY_VALUE | XVTA_DO_NOT_APPLY_ATTRIBUTES);
		
		//----- CPY 5/29/08 FIX_RUNTIME_ERR_WHEN_CAST_DWORD_TO_OPERATION_POINTER_FOR_GRID
		/*
		TreeNode	trOperationPtr = tree_check_get_node(trGUI.Output, "OperationPointer"); 
		trOperationPtr.SetAttribute(STR_DATAID_ATTRIB, IDE_OPERATION_POINTER);
		trOperationPtr.nVal = (int)this;
		trOperationPtr.Show = false;
		trOperationPtr.SetAttribute(STR_XVARIABLE_THEME_APPLICABILITY_ATTRIB, XVTA_DO_NOT_APPLY_VALUE | XVTA_DO_NOT_APPLY_ATTRIBUTES);
		*/
		set_operation_pointer(trGUI, this);
		//----- end FIX_RUNTIME_ERR_WHEN_CAST_DWORD_TO_OPERATION_POINTER_FOR_GRID
		// end REMOVE_POINTER_IN_OPERATION_GUI_AVOID_ACCIDENT_CRASH
		
		///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//bRet = m_pOutputManager->ConstructOptions(trGUI, bAllowToSource, strBook);
		bRet = m_pOutputManager->ConstructOptions(trGUI);
		///End NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		
		/// Iris 4/17/2008 SPECIAL_REPORT_TABLE_NAME_FOR_DIFF_TOOLS
		if(bRet)
		{
			if(trGUI.Output.Report)
				trGUI.Output.Report.SetAttribute(STR_LABEL_ATTRIB, GetReportTableGUIName(trGUI));
			/// Iris 5/30/2008 CENTRALIZE_SET_RESULT_CURVE_BRANCH_NAME_CODES
			
			///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
			//if(trGUI.Output.Data)
				//trGUI.Output.Data.SetAttribute(STR_LABEL_ATTRIB, GetResultCurveGUIName(trGUI));
			TreeNode trData = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
			if ( trData )
				trData.SetAttribute(STR_LABEL_ATTRIB, GetResultCurveGUIName(trGUI));
			///end OP_DLG_NEW_STRUCTURE
			///end CENTRALIZE_SET_RESULT_CURVE_BRANCH_NAME_CODES
		}
		///END SPECIAL_REPORT_TABLE_NAME_FOR_DIFF_TOOLS
	}
	else
		return error_report("Fail to init OutputGUIManager pointer in WksReportOperation");
	
	return bRet;
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
}

/// Iris 4/17/2008 SPECIAL_REPORT_TABLE_NAME_FOR_DIFF_TOOLS
//virtual	
string	WksReportOperation::GetReportTableGUIName(TreeNode& trGUI)
{ 
	return STR_OUTPUT_REPORT_TABLES;
}
///end SPECIAL_REPORT_TABLE_NAME_FOR_DIFF_TOOLS
string	WksReportOperation::GetResultCurveGUIName(TreeNode& trGUI)
{
	return STR_OUTPUT_STATS_RESULT_CURVE_TABLES;
}

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
//virtual
bool	WksReportOperation::InitOutputGUIManagerPointer(const TreeNode& trGUI)
{
	if(m_pOutputManager)//already init
		return true;
	
	m_pOutputManager = new OutputGUIManagerBase;	
	if(NULL == m_pOutputManager)
		return false;
	
	return true;
}
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

//virtual 
BOOL	WksReportOperation::Construct(TreeNode& trOperation, int nOption)
{
	// CPY 8/11/04 we dont need to do much inside in VC anymore
	//if( OperationBase::Construct(trOperation, nOption) )
	trOperation.Calculation.ID = IDST_CALCULATION_RESULTS;
	//---- CPY 6/18/04 MULTIPLE_REPORTS_IN_SHEET
	//trOperation.Calculation.Title.ID = IDE_TITLE;
	//----
	trOperation.Calculation.Notes.ID = IDST_REPORT_NOTES;
	trOperation.Calculation.Notes.Description.ID = IDE_NOTES_DESCRIPTION;
	trOperation.Calculation.Notes.UserName.ID = IDE_NOTES_USERNAME;
	trOperation.Calculation.Notes.Time.ID = IDE_NOTES_CREATION_TIME;
	//UpdateReportingTables(trOperation, true);
	///Arvin 10/27/06 FITTING_FUNCTION_MODEL_IN_REPORT
	trOperation.Calculation.Notes.Model.ID = IDE_NOTES_MODEL;
	///end FITTING_FUNCTION_MODEL_IN_REPORT
	
	/// Iris 8/14/2008 QA80-12017-S2 ADD_PARAM_NUM_DATA_NUM_TO_NOTE_TABLE
	trOperation.Calculation.Notes.NumFuncParams.ID = IDE_NOTES_NUM_PARAMS;
	trOperation.Calculation.Notes.NumDerivParams.ID = IDE_NOTES_NUM_DERIVED_PARAMS;
	trOperation.Calculation.Notes.NumDataSets.ID = IDE_NOTES_NUM_DATASET;
	///END ADD_PARAM_NUM_DATA_NUM_TO_NOTE_TABLE	
	
	trOperation.Calculation.Notes.AutoUpdateMode.ID = IDE_NODES_AUTOUPDATE_MODE;
	
	/// Iris 3/12/2009 QA80-13268 NOTES_TABLE_ADD_SPECIAL_INPUT_HANDLING
	trOperation.Calculation.Notes.Weight.ID = IDE_NOTES_WEIGHT;
	trOperation.Calculation.Notes.Weight.Show = false;
	
	trOperation.Calculation.Notes.DataMode.ID = IDE_NOTES_DATA_MODE;
	trOperation.Calculation.Notes.DataMode.Show = false;
	
	trOperation.Calculation.Notes.SpecialInputHandling.ID = IDE_NOTES_SPECIAL_INPUT_HANDLING;	
	///end NOTES_TABLE_ADD_SPECIAL_INPUT_HANDLING	
	
	//--- CPY 6/8/04 ADD_INPUT_TABLE
	trOperation.Calculation.Input.ID = IDST_REPORT_INPUT_TABLE;
	//---
	trOperation.Calculation.MaskedData.ID = IDST_REPORT_MASKED_DATA_TABLE;		/// ML 10/20/2004 QA70-7075 MASKED_DATA_REPORTING
	/// ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS
	trOperation.Calculation.MissingData.ID = IDST_REPORT_MISSING_DATA_TABLE;
	/// end GETTING_MISSING_VALUES_AND_ROWS
	
	
	//---- CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
	#ifdef SEPARATE_RESULT_CURVES_FROM_CALCULATION_BRANCH
		trOperation.ResultCurves.ID = IDST_RESULT_CURVES;			
		trOperation.ResidualCurves.ID = IDST_RESIDUAL_CURVES; /// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
		/// Joesph/Iris 9/26/06 QA70-7120 MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
		trOperation.Calibration1.ID = make_one_set_ID(IDST_REPORT_CUSTOM_ONE_SET, 1); 
		trOperation.Calibration2.ID = make_one_set_ID(IDST_REPORT_CUSTOM_ONE_SET, 2);
		///end MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
	#endif
	//----
	
	//----- CPY 11/19/2007 QA70-10708 OPERATION_NEED_VERSIONING_TO_FIX_BUGS_IN_OUR_CODE
	int nCurrentOperationVersion = CURRENT_OPERATION_VERSION;
	trOperation.SetAttribute(STR_OP_VERSION, nCurrentOperationVersion);
	//-----
	return TRUE;
}



void tree_construct_add_input_branch(TreeNode& trGUI, int nDataMode)
{
	if( !trGUI.InputData )
	{
		GETN_USE(trGUI)
		GETN_BEGIN_BRANCH(InputData, STR_INPUT_DATA)  GETN_ID_BRANCH(IDST_INPUT_DATA_OPTIONS) 
			GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_END_BRANCH(InputData)
		trGUI.InputData.SetAttribute(STR_INPUT_DATA_MODE_ATTRIB, nDataMode);  /// Iris 2/06/06 QA70-8388 INDEP_DATA_CONSOLID_OR_SEP_REPORT
	}
	
	//--- CPY 10/7/04 COMBO_BRANCH_FOR_MULTIPLE_RANGE_MODE
	if(nDataMode >= INPUTDATA_RANGES_CAN_COMBINE)
	{
		trGUI.InputData.Use = MDINPUT_DEFAULT; 
		//trGUI.InputData.SetAttribute(STR_ATTRIB_BRANCH_COMBO, "Consolidated|Combined|Separate");
		
		/// Iris 2/25/2007 v8.0570 SUPPORT_INDEP_FIT_MODE
		/*
		///Cheney 2006-9-4 REMOVE_LAST_TWO_OPTIONS
		/// Iris 2/20/06 CHANGE_NAME_TO_FOLLOW_EASWAR_SUGGESTION
		///// Iris 1/26/06 QA70-8388 INDEP_DATA_CONSOLID_OR_SEP_REPORT
		////string strCombo = _L("Independent|Combined Simple|Ave SE|Ave SD");
		//string strCombo = _L("Independent - Consolidated Report|Independent - Separate Reports|Concatenate|Ave SE|Ave SD");
		//string strCombo = _L("Independent - Consolidated Report|Independent - Separate Reports|Concatenate|Mean with Std. Error|Mean with Std. Dev");
		string strCombo = _L("Independent - Consolidated Report|Independent - Separate Reports|Concatenate");
		/////End INDEP_DATA_CONSOLID_OR_SEP_REPORT
		/// End CHANGE_NAME_TO_FOLLOW_EASWAR_SUGGESTION
		///end REMOVE_LAST_TWO_OPTIONS
		*/
		string strCombo = L_STR_FIT_MODES_COMBO;//_L("Independent Fit - Consolidated Report|Independent Fit - Separate Report|Concatenate Fit|Global Fit");
		///end SUPPORT_INDEP_FIT_MODE
		
		if(INPUTDATA_RANGES_CAN_COMBINE == nDataMode)
			strCombo = L_STR_INDEP_COL_COMBINED;//_L("Independent Columns|Combined as Single Dataset");
			
		trGUI.InputData.SetAttribute(STR_ATTRIB_BRANCH_COMBO, strCombo);
		/// TD 5-10-06 QA70-8664 DATASET_OBJECT_CLASS_IN_OC
		//trGUI.InputData.SetAttribute(STR_ACTION_FILTER_TAGS, _L(STR_DATASETOBJ_FITCURVE));
		trGUI.InputData.SetAttribute(STR_ACTION_FILTER_TAGS, GetLocalized(STR_DATASETOBJ_FITCURVE)); /// Hong 11/07/07 v.8.0742 FIX_ERROR_LOCALIZED
		/// end DATASET_OBJECT_CLASS_IN_OC
	}
	//---

}

/// Iris 11/03/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
void tree_construct_add_common_report_table_options(TreeNode& trBranch, DWORD dwOptions)
{
	GETN_USE(trBranch)
	if ( dwOptions & REPORT_NOTES )
	{
		GETN_CHECK(Notes, STR_NOTES_TABLE, true) GETN_ID(IDE_REPORT_NOTES)
	}
	if ( dwOptions & REPORT_INPUT )
	{
		GETN_CHECK(InputData, STR_INPUT_DATA, true) GETN_ID(IDE_REPORT_INPUT_TABLE)
	}
	if ( dwOptions & REPORT_MASKED_DATA )
	{
		GETN_CHECK(MaskedData, STR_MASKED_DATA, false) GETN_ID(IDE_REPORT_MASKED_DATA_TABLE)
	}
	if ( dwOptions & REPORT_MISSING_DATA )
	{
		GETN_CHECK(MissingData, STR_MISSING_DATA, false) GETN_ID(IDE_REPORT_MISSING_DATA_TABLE)
	}
	if ( dwOptions & REPORT_ANOVA_TABLE )
	{
		GETN_CHECK(ANOVAtable, STR_ANOVA_TABLE, true) GETN_ID(IDE_ANOVA_TABLE)
	}	
}

void tree_construct_add_graph_options(TreeNode& trBranch, int nNumGraphs, DWORD dwOptions)
{
	GETN_USE(trBranch)

	for ( int index=0; index < nNumGraphs; index++ )
	{
		string strName = op_get_graph_tag_name(index);
		if(dwOptions & REPORT_GRAPH_PLOT_INFO)
		{										
			///DSC 9/20/05 QA70-8113 NEED_REPEAT_ID_GREATER_THAN_ONE
			// //GETN_BEGIN_BRANCH_L(strName, _L("Graphs"))	GETN_ID(IDST_RESULT_GRAPHS + index)	 GETN_CHECKBOX_BRANCH(1)  GETN_ID_REPEAT_BRANCH(index)  ///Iris 8/17/05 MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
			// GETN_BEGIN_BRANCH_L(strName, _L("Graphs"))	GETN_ID(IDE_RESULT_GRAPHS + index)	 GETN_CHECKBOX_BRANCH(1)  GETN_ID_REPEAT_BRANCH(index)
			GETN_BEGIN_BRANCH_L(strName, _L("Graphs"))	GETN_ID(IDE_RESULT_GRAPHS + index)	 GETN_CHECKBOX_BRANCH(1)  GETN_ID_REPEAT_BRANCH(index+1)
			///end NEED_REPEAT_ID_GREATER_THAN_ONE
				
			GETN_END_BRANCH_L(strName)
		}
		else
		{
			//GETN_CHECK_L(strName, _L("Graphs"), true) 	GETN_ID(IDST_RESULT_GRAPHS + index)  ///Iris 8/17/05 MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
			GETN_CHECK_L(strName, _L("Graphs"), true) 	GETN_ID(IDE_RESULT_GRAPHS + index)
		}
		
	}	

}

void tree_construct_add_plot_settings(TreeNode trBranch, DWORD dwOptions)
{
	GETN_USE(trBranch)
		if(dwOptions & REPORT_PASTE_RESULT_TABLES_TO_GRAPH)
		{
			///Cheney 2007-8-31 QA70-10330 CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
			//GETN_CHECK(PasteResultTable, _L("Paste Result Tables to Graph"), true) GETN_ID(IDE_PASTE_RESULT_TABLES_TO_GRAPH)
			GETN_BEGIN_BRANCH(PasteResultTable, _L("Paste Result Tables to Source Graph") ) GETN_CHECKBOX_BRANCH(1) GETN_ID(IDE_PASTE_RESULT_TABLES_TO_GRAPH)
			///end CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
			//-------------------- CPY 5/2/07 QA70-9687 TEMPLATE_FOR_TABLE_INSERT_TO_GRAPH
			GETN_STR(TableTemplate, _L("Template to Create Table"), "") GETN_ID(IDE_REOPRT_TABLE_TEMPLATE)
			//--------------------
			GETN_STR(ThemeRsltTable, _L("Graph Table Theme"), "") GETN_ID(IDST_THEME_FOR_TABLE_IN_GRAPH)
			GETN_END_BRANCH(PasteResultTable)	///Cheney 2007-8-31 QA70-10330 CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
		}
		if(dwOptions & REPORT_ARRANGE_GRAPHS_TO_COLS)
		{
			///Cheney 2007-8-31 QA70-10330 CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
			//GETN_COMBO(GraphNumCols, _L("Arrange Graphs into Columns"), 1, "|1|2|3|4|5|6|7|8|9")  GETN_ID(IDE_REPORT_GRAPH_NUM_COLS)
			GETN_NUM(GraphNumCols, _L("Arrange Graphs into Columns"), 1) GETN_ID(IDE_REPORT_GRAPH_NUM_COLS)
					TreeNode trGraphNumCols = trBranch.GraphNumCols;
			if(trGraphNumCols)
				octree_set_auto_support(&trGraphNumCols);
			///end CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
		}
		if(dwOptions & REPORT_PLOT_ALL_PLOTS_IN_ONE_GRAPH)
		{
			///Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
			//GETN_CHECK(PlotInOneGraph, _L("Plot All Plots in One Graph"), 0) 	GETN_ID(IDE_REPORT_PLOTS_IN_ONE_GRAPH)
			GETN_CHECK(PlotInOneGraph, _L("Arrange Plots of Same Type in One Graph"), 0) 	GETN_ID(IDE_REPORT_PLOTS_IN_ONE_GRAPH)
			///end SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
		}

}
///end OP_DLG_NEW_STRUCTURE

// set nOutMode to MDOUT_INVALID to remove
void	tree_output_branch_mode(TreeNode& trGUI, int nOutMode)
{
	if( nOutMode == MDOUT_INVALID )
	{
		//trGUI.Output.Use = -1;// to remove attribute ///Arvin 11/10/06 STATS_ON_ROW_NO_NEED_CHECKBOX
		trGUI.Output.RemoveAttribute(STR_ATTRIB_BRANCH_COMBO);
	}
	else
	{
		trGUI.Output.Use = nOutMode; 
		trGUI.Output.SetAttribute(STR_ATTRIB_BRANCH_COMBO, _L("Consolidated|Separate"));
	}
}

///Iris 11/30/04 QA70-7139 IMPROVE_BOOK_SHEET_OPTIONS
/*
///Iris 11/12/04 QA70-7139 IMPROVE_RESULT_BOOK_EVENT
//static void _build_curve_ouput_book_sheet_option(TreeNode& trGUI, bool& bNoReport=NULL, int nCurveBookType = -1)
static void _build_curve_ouput_book_sheet_option(TreeNode& trGUI, int nType)
{
	//if(!trCurves)
	//	return;

	string strBook, strSheet;
	bool bNoReport = PDS_NONE == nType? true:false;
	bool bSource = PDS_SOURCE == nType? true:false;
	if(bNoReport)
	{
		//strBook = STR_TOKEN_SEP + STR_NONE + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;  ///Iris 11/22/04 UPDATE_DROPLIST_TO_DROPDOWN
		//strSheet = STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		strBook = STR_NONE + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		strSheet = STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		//trCurves.Book.strVal = STR_NEW;   ///Iris 11/25/04, remove to setCurvesOutputBookSheet
		//trCurves.Sheet.strVal = STR_NEW;
	}
	else 
	{
		//strBook = STR_TOKEN_SEP + STR_NONE + STR_TOKEN_SEP + STR_REPORT + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;  ///Iris 11/22/04 UPDATE_DROPLIST_TO_DROPDOWN
		//strSheet = STR_TOKEN_SEP + STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		if(bSource)
			strBook = STR_NONE + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		else
			strBook = STR_NONE + STR_TOKEN_SEP + STR_REPORT + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;			
		strSheet = STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
	}
		
	//switch(nCurveBookType)
	//{
	//case PDS_NEW:
	//case PDS_USER:
	//case PDS_CUSTOM:
		//strSheet = STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		//break;
	//case PDS_SOURCE:
		//strSheet = STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		//if( PDS_REPORT == str_to_predefined_type(trCurves.Sheet.strVal))
			//trCurves.Sheet.strVal = STR_SOURCE_BOOK;
		//break;
	//case PDS_REPORT:
		//strSheet = STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		//if( PDS_SOURCE == str_to_predefined_type(trCurves.Sheet.strVal))
			//trCurves.Sheet.strVal = STR_REPORT;		
		//break;
	//case PDS_NONE:
	//default:
		//break;
	//}
	//--- CPY 11/29/04 DESC_STATS_ROWS_LOST_OUTPUT_TO_SOURCE
	TreeNode trCurves = trGUI.Output.Data;
	if(trCurves)
	{
		trCurves.Book.SetAttribute(STR_COMBO_ATTRIB, strBook);
		trCurves.Sheet.SetAttribute(STR_COMBO_ATTRIB, strSheet);	
	}
	else // if no Curve output, then only update Sheet from Book
	{
		if(bSource)
			strSheet = STR_NEW + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		else
			strSheet = STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		trGUI.Output.Report.Sheet.SetAttribute(STR_COMBO_ATTRIB, strSheet);
	}
	//--- end DESC_STATS_ROWS_LOST_OUTPUT_TO_SOURCE
		
	
	return;
}
*/

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
/*
/// EJP 2005-04-13 v8.0222 QA70-7615 XFUNC_TREEVIEW_SHOW_WRONG_DATA_BOOK_AND_SHEET
static BOOL _is_str_token(LPCSTR lpcszFind, LPCSTR lpcszTokens, char chDelimiter = 0)
{
	if( lpcszFind == NULL || *lpcszFind == 0 )
		return FALSE;

	string strTokens = lpcszTokens;

	///int n = strTokens.Find(lpcszFind);
	///if( -1 == n || (n > 0 && chDelimiter != strTokens[n - 1] )
	///	return FALSE;

	int nTokens = strTokens.GetNumTokens(chDelimiter);
	string strToken;
	for( int nToken = 0; nToken < nTokens; nToken++ )
	{
		strToken = strTokens.GetToken(nToken, chDelimiter);
		if( 0 == strToken.Find(lpcszFind) )
			return TRUE;
	}
	return FALSE;
}

// Return: TRUE if value ok or value set to default, FALSE if could not check
static BOOL _check_node_strval_with_combo_items(TreeNode& tn, LPCSTR lpcszDefault)
{
	// Tree node is required
	if( !tn.IsValid() )
		return FALSE; // invalid tree node

	// Tree node must have the Combo attribute
	string strCombo;
	if( !tn.GetAttribute(STR_COMBO_ATTRIB, strCombo) )
		return FALSE; // no Combo attribute

	// Default string must be a Combo item
	if( !_is_str_token(lpcszDefault, strCombo, '|') )
	//---- CPY 4/16/05 ACTIVE_BOOK_SHEET_AS_DEFAULT_FOR_XF
	//		return FALSE;
	{
		error_report("_check_node_strval_with_combo_items found default not in combo list");
		strCombo += (string)STR_TOKEN_SEP + lpcszDefault;
		tn.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	}
	//----
	
	// If value is not a Combo item then set value to default
	if( !_is_str_token(tn.strVal, strCombo, '|') )
		tn.strVal = lpcszDefault;
	
	return TRUE;
}
/// end XFUNC_TREEVIEW_SHOW_WRONG_DATA_BOOK_AND_SHEET
*/
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS


/*
/// ML 3/3/2005 XFUNCTION_OUTPUT_VARIABLES_DATA_ASSOC
static	void	_xvars_build_data_branch(TreeNode &trData, int nBookType)
{
	string			strBook, strSheet;
	trData.Book.GetAttribute(STR_COMBO_ATTRIB, strBook); 
	//trData.Sheet.GetAttribute(STR_COMBO_ATTRIB, strSheet);
	
	if(strBook.IsEmpty())
	{
		///Iris 3/23/05 QA70-7493 BUILD_XVAR_DATA_BRANCH
		//strBook = STR_NEW + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_EXISTING + STR_THREE_DOTS;
		strBook = STR_XF_DEFAULT_BOOK_NAME + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_EXISTING + STR_THREE_DOTS;
		trData.Book.SetAttribute(STR_COMBO_ATTRIB, strBook);
		
		/// EJP 2005-04-13 v8.0222 QA70-7615 XFUNC_TREEVIEW_SHOW_WRONG_DATA_BOOK_AND_SHEET
		///	///Iris 3/23/05 QA70-7493 BUILD_XVAR_DATA_BRANCH
		///	//trData.Book.strVal = STR_NEW;
		///	trData.Book.strVal = STR_XF_DEFAULT_BOOK_NAME;
		_check_node_strval_with_combo_items(trData.Book, STR_XF_DEFAULT_BOOK_NAME);//STR_SOURCE_BOOK);
		/// end XFUNC_TREEVIEW_SHOW_WRONG_DATA_BOOK_AND_SHEET
	}
	
	///Iris 3/23/05 QA70-7493 BUILD_XVAR_DATA_BRANCH
	//strSheet = STR_NEW;
	bool bDefaultSourceSheet = false;//CPY 4/16/05 ACTIVE_BOOK_SHEET_AS_DEFAULT_FOR_XF
	strSheet = STR_XF_DEFAULT_SHEET_NAME + STR_TOKEN_SEP + STR_NEW;
	if (PDS_SOURCE == nBookType)
	{
		strSheet += STR_TOKEN_SEP + STR_INSERT_SOURCE_SHEET;
		bDefaultSourceSheet = true;
	}
	
	if (PDS_NEW != nBookType)
		strSheet += STR_TOKEN_SEP + STR_EXISTING + STR_THREE_DOTS;
	
	trData.Sheet.SetAttribute(STR_COMBO_ATTRIB, strSheet);

	/// EJP 2005-04-13 v8.0222 QA70-7615 XFUNC_TREEVIEW_SHOW_WRONG_DATA_BOOK_AND_SHEET
	///	///Iris 3/23/05 QA70-7493 BUILD_XVAR_DATA_BRANCH
	///	//trData.Sheet.strVal = STR_NEW;
	///	trData.Sheet.strVal = STR_XF_DEFAULT_SHEET_NAME;
	_check_node_strval_with_combo_items(trData.Sheet, bDefaultSourceSheet? STR_SOURCE_BOOK : STR_XF_DEFAULT_BOOK_NAME);
	/// end XFUNC_TREEVIEW_SHOW_WRONG_DATA_BOOK_AND_SHEET
}
/// end XFUNCTION_OUTPUT_VARIABLES_DATA_ASSOC
*/


/// YuI 05/17/05: 
/// there is some corrupt logic in the function
/// Book may become <source> inside function body
/// however nBookType passed into the function as parameter and being compared with PDS_SOURCE
/// this function gets called from one place only for XVariable so I am changhing its prototype
/*
static	void	_xvars_build_data_branch(TreeNode &trData, int nBookType, string &strSourcePage, string &strSourceLayer)
{
	string			strBook, strSheet;
	trData.Book.GetAttribute(STR_COMBO_ATTRIB, strBook); 
	//trData.Sheet.GetAttribute(STR_COMBO_ATTRIB, strSheet);

	string strSeletedPage = trData.Book.strVal;
	
	strBook = _build_page_context_list(strSourcePage, EXIST_WKS);
	
	trData.Book.SetAttribute(STR_COMBO_ATTRIB, strBook);

	if(strSeletedPage.IsEmpty() || strSeletedPage.Compare(STR_SOURCE_BOOK))
		_check_node_strval_with_combo_items(trData.Book, strSourcePage.IsEmpty() ? STR_NEW : STR_SOURCE_BOOK);
		
	bool bDefaultSourceSheet = false;//CPY 4/16/05 ACTIVE_BOOK_SHEET_AS_DEFAULT_FOR_XF

	string strSeletedBook ;
	
	if (PDS_SOURCE == nBookType )
	{		
		strSeletedBook = strSourcePage;
		
		if(!strSourceLayer.IsEmpty())
			bDefaultSourceSheet = true;
	}
	else
		strSeletedBook  = trData.Book.strVal;
	
	strSheet = _build_layer_context_list(strSourceLayer, strSeletedBook, nBookType);
	trData.Sheet.strVal =  STR_SOURCE_BOOK;
	///----
	
	trData.Sheet.SetAttribute(STR_COMBO_ATTRIB, strSheet);
	
	_check_node_strval_with_combo_items(trData.Sheet, bDefaultSourceSheet? STR_SOURCE_BOOK : STR_NEW);
}
*/

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
/*
static	void	_xvars_build_data_branch(TreeNode &trData, string &strSourcePage, string &strSourceLayer)
{
	string strCurrentlySelectedPage = trData.Book.strVal;
	string strBook = _build_page_context_list(strSourcePage, EXIST_WKS);
	trData.Book.SetAttribute(STR_COMBO_ATTRIB, strBook);

	///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
	//if( strCurrentlySelectedPage.IsEmpty() || strCurrentlySelectedPage.Compare(STR_SOURCE_BOOK) )
	if ( PDS_SOURCE != cvt_str_to_predefined_type(strCurrentlySelectedPage) )
	///---END CLEAN_LOCALIZATION_CODE
		_check_node_strval_with_combo_items(trData.Book, STR_SAME);
		/// end XVARIABLE_SAME_IMPLEMENTATION
		
	strCurrentlySelectedPage = trData.Book.strVal;
	int nBookType = str_to_predefined_type(strCurrentlySelectedPage);	
	
	bool bDefaultSourceSheet = false;
	
	string strSeletedBook;
	if( PDS_SOURCE == nBookType )
	{		
		strSeletedBook = strSourcePage;
		if(!strSourceLayer.IsEmpty())
			bDefaultSourceSheet = true;
	}
	else
		strSeletedBook  = trData.Book.strVal;
	
	string strSheet = _build_layer_context_list(strSourceLayer, strSeletedBook, nBookType);

	//	trData.Sheet.strVal =  STR_SOURCE_BOOK;
	int nSheetType = str_to_predefined_type(trData.Sheet.strVal);	
	trData.Sheet.SetAttribute(STR_COMBO_ATTRIB, strSheet);
	
	if( nSheetType == PDS_SAME )
		_check_node_strval_with_combo_items(trData.Sheet, STR_SAME);
	else
		_check_node_strval_with_combo_items(trData.Sheet, bDefaultSourceSheet? STR_SOURCE_BOOK : STR_SAME);
}
/// end YuI

static string _build_page_context_list( LPCSTR lpcszSource, uint nPageType  = EXIST_WKS, int nBookType = PDS_NEW)
{
	string strList;
	
	vector<string> vsList;
	
	///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	//_get_project_pages_name(vsList, nPageType);
	///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
	//FUNC_GET_PROJECT_PAGE_NAMES pfn = Project.FindFunction("get_project_pages_name", "OriginLab\\Event_utils", true);
	//if(pfn)
	//	pfn(vsList, nPageType);
	get_project_pages_name(vsList, nPageType);
	///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	
	strList = _build_context_list(vsList, lpcszSource, nBookType);
	
	return strList;
}

static string _build_layer_context_list( LPCSTR lpcszSource,LPCSTR lpcszPageName , int nBookType = PDS_NEW)
{
	string strList;
	
	vector<string> vsList;
	
	_get_layer_name_from_page(vsList, lpcszPageName);
	
	strList = _build_context_list(vsList, lpcszSource, nBookType, false);
	
	return strList;
}

static string _build_context_list(vector<string> vsList, LPCSTR lpcszSource = NULL, int nBookType = PDS_NEW, bool bIsPageList = true)
{
	string strList;
	
	bool bInsertSource = true;
	
	if(!bIsPageList && PDS_SOURCE != nBookType)
		bInsertSource = false;
	
	if(bInsertSource)
	{
		int nSourceIndex = vsList.Find(lpcszSource);
		
		if(nSourceIndex >= 0)
		{
			vsList.RemoveAt(nSourceIndex);
			///Insert the source book to first of the vector
			vsList.InsertAt(0, lpcszSource);
			
			///<source> item should in second of the list.
			vsList.InsertAt(0, STR_SOURCE_BOOK);
		}
	}
	
	///<New> item should in the first of the list
	vsList.InsertAt(0, STR_NEW);
	
	/// YuI 05/23/05 XVARIABLE_SAME_IMPLEMENTATION
	// later will add some logic when <same> is appropriate entry
	// for now insert always
	vsList.InsertAt(1, STR_SAME);
	/// end XVARIABLE_SAME_IMPLEMENTATION
	char	chToken = '|';
	int nListItemCount = strList.SetTokens(vsList,chToken );
	
	return strList;
}
*/
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS


///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
//static void _get_project_pages_name(vector<string> &vsPagesName, uint nPageType  = EXIST_WKS)
//{
	//vsPagesName.RemoveAll();
	//foreach(PageBase pg in Project.Pages)
	//{
		//if(pg.GetType() == nPageType)
			//vsPagesName.Add(pg.GetName());
		//
		////out_str(pg.GetName());
	//}	
//}
///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
/*
static void _get_layer_name_from_page(vector<string> &vsLayerList, string &strPageName)
{
	Page pg(strPageName);
	vsLayerList.RemoveAll();
	if(!pg)
		return ;
	foreach(Layer lay in pg.Layers)
		vsLayerList.Add(lay.GetName());
}
*/
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

//--- CPY 10/2/05 DESC_STATS_ON_ROWS_NEED_REPORT_TO_SOURCE
// modify bReportSource related to code by Iris 9/29/05 REMOVE_SOURCE_FROM_OUTPUT_SHEET
// added bAllowReportToSourceSheet
///Arvin 07/09/07 v8.0655 FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
//static void _build_output_book_sheet_option(TreeNode& trGUI, int nReportBookType, int nCurveBookType, bool bAllowReportToSourceSheet = false)
///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
////static void _build_output_book_sheet_option(TreeNode& trGUI, int nReportBookType, int nCurveBookType, bool bAllowReportToSourceSheet = false, bool bAllowReportToSrcBook = true)
//static void _build_output_book_sheet_option(TreeNode& trGUI, int nReportBookType, int nCurveBookType, bool bAllowReportToSourceSheet = false, bool bAllowReportToSrcBook = true, LPCSTR lpcszBook = NULL)
/////end FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
//{
	//string strBook, strSheet;
	//
	//bool bNoReport = PDS_NONE == nReportBookType? true:false;
	//bool bReportSource = PDS_SOURCE == nReportBookType? true:false;
	//bool bCurveSource = PDS_SOURCE == nCurveBookType? true:false;
//
	////--- CPY 10/2/05 DESC_STATS_ON_ROWS_NEED_REPORT_TO_SOURCE
	//if(!bAllowReportToSourceSheet)
		//bReportSource = false;
	////---
//
	///// Iris 12/03/04 INSERT_REMOVED_STR_IN_STRLIST
	//TreeNode trCurves = trGUI.Output.Data;
	//if(trCurves)
	//{
		//trCurves.Book.GetAttribute(STR_COMBO_ATTRIB, strBook); 
		//trCurves.Sheet.GetAttribute(STR_COMBO_ATTRIB, strSheet);
		//
		//if(strBook.IsEmpty())
			///// Iris 11/11/05 QA70-8116-P14 REMOVE_NONE_FOR_CURVE_BOOK_LIST
			////strBook = STR_NONE + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
			//strBook = STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		/////Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
		////add <source> and remove <report>( <report> : report table sheet)
		////Fit Book:<report>      Fit Sheet:<new>
		///*
		//if(strSheet.IsEmpty())
			///// Iris 9/29/05 REMOVE_SOURCE_FROM_OUTPUT_SHEET
			////strSheet = STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
			//strSheet = STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
			/////End REMOVE_SOURCE_FROM_OUTPUT_SHEET
		/////End INSERT_REMOVED_STR_IN_STRLIST
		//*/
		//if(strSheet.IsEmpty())
			//strSheet = STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		/////End MODIFICATION_OUTPUT_BRANCH
		//
		//if(bNoReport)
		//{
			//remove_str_from_str_list(STR_REPORT, strBook);
			//remove_str_from_str_list(STR_REPORT, strSheet);		
		//}
		//else 
		//{
			//insert_str_to_str_list(STR_REPORT, strBook, STR_NEW);
			////insert_str_to_str_list(STR_REPORT, strSheet, STR_NEW);	///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH, shouldn't add to report sheet
		//}
		//
		//if(bCurveSource)
		//{
			//insert_str_to_str_list(STR_SOURCE_BOOK, strSheet, STR_NEW);
		//}
		//else
		//{
			//remove_str_from_str_list(STR_SOURCE_BOOK, strSheet);
		//}
		//
		//int		nOutputToMatrix = 0;
		//if( trCurves.GetAttribute(STR_REPORT_MATRIX_DATA, nOutputToMatrix))
		//{
			/////Arvin 04/27/07 v8.0609 UPDATE_OUTPUT_DESTINATION_FOR_SURFACE_FITTING as max's suggestion
			////remove_str_from_str_list(STR_SOURCE_BOOK, strBook);
			////remove_str_from_str_list(STR_REPORT, strBook);
			////
			////remove_str_from_str_list(STR_REPORT, strSheet);
			//if(nOutputToMatrix == 1) //surface fitting, = 2 matrix Fitting
			//{
				//remove_str_from_str_list(STR_SOURCE_BOOK, strBook);
			//}
			//remove_str_from_str_list(STR_REPORT, strBook);
			//remove_str_from_str_list(STR_REPORT, strSheet);
			//remove_str_from_str_list(STR_SOURCE_BOOK, strSheet);
			//remove_str_from_str_list(STR_CUSTOM, strSheet);
			//if(trCurves.Book.strVal.IsEmpty())
			//{
				//if(nOutputToMatrix == 1)
					//trCurves.Book.strVal = STR_NEW;
				//else
					//trCurves.Book.strVal = STR_SOURCE_BOOK;
			//}
				//
			//if(trCurves.Sheet.strVal.IsEmpty())
				//trCurves.Sheet.strVal = STR_NEW;
			/////end UPDATE_OUTPUT_DESTINATION_FOR_SURFACE_FITTING
		//}
		//
		/////Arvin 07/09/07 v8.0655 FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
		//if(!bAllowReportToSrcBook)
		//{
			//remove_str_from_str_list(STR_SOURCE_BOOK, strBook);
			//remove_str_from_str_list(STR_SOURCE_BOOK, strSheet);
		//}
		/////end FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
		//
		////--- CPY 11/29/04 DESC_STATS_ROWS_LOST_OUTPUT_TO_SOURCE
		////TreeNode trCurves = trGUI.Output.Data;
		////if(trCurves)
		////{
			//trCurves.Book.SetAttribute(STR_COMBO_ATTRIB, strBook);  
			//
			/////Iris 12/16/04 QA70-7139 CURVE_OUTPUT_AUTO_UPDATE_IF_REPORT_IS_NONE
			////_check_output_option(trCurves.Book);
			//_check_correct_output_option(trCurves.Book, STR_NEW);
			/////End CURVE_OUTPUT_AUTO_UPDATE_IF_REPORT_IS_NONE
			//
			//trCurves.Sheet.SetAttribute(STR_COMBO_ATTRIB, strSheet);
			//
			/////Iris 12/16/04 QA70-7139 CURVE_OUTPUT_AUTO_UPDATE_IF_REPORT_IS_NONE
			////_check_output_option(trCurves.Sheet);
			//_check_correct_output_option(trCurves.Sheet, STR_NEW);
			/////End CURVE_OUTPUT_AUTO_UPDATE_IF_REPORT_IS_NONE
	//}
	//else // if no Curve output, then only update Sheet from Book
	//{
		/////Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
		////remove <source>, for report table shouldn't add to datasheet
		///*
		//if(bReportSource)
			//strSheet = STR_NEW + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		//else
		//*/
		/////End MODIFICATION_OUTPUT_BRANCH
		/////2006-11-7 Cheney DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
		//////---- Iris 10/30/06 STATS_ON_ROWS_FAIL_TO_REPORT_INTP_SOURCE
		////if(bReportSource)
			////strSheet = STR_NEW + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		////else
		//////----
			////strSheet = STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		//strSheet = STR_NEW + STR_TOKEN_SEP;
		//if(bReportSource)
			//strSheet += STR_SOURCE_BOOK;
		/////end DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
	//
		///// Iris 4/18/2007 v8.0603 ADD_OUTPUT_DEST_COL_OPTION_STATS_ON_ROWS
		//// should include <existing...> option for Sheet for Stats on Rows when Book is <existing...>
		//if(trGUI.StatsOnRows && trGUI.StatsOnRows.nVal && PDS_CUSTOM == nReportBookType && trGUI.Output.Report.Sheet.Enable)// stats on rows
		//{
			//strSheet = STR_NEW + "|" + STR_CUSTOM;
		//}
		/////end ADD_OUTPUT_DEST_COL_OPTION_STATS_ON_ROWS
//
		//trGUI.Output.Report.Sheet.SetAttribute(STR_COMBO_ATTRIB, strSheet);
		//
		/////Iris 12/16/04 QA70-7139 CURVE_OUTPUT_AUTO_UPDATE_IF_REPORT_IS_NONE
		////_check_output_option(trGUI.Output.Report.Sheet);
		////---- Iris 10/30/06 STATS_ON_ROWS_FAIL_TO_REPORT_INTP_SOURCE
		////_check_correct_output_option(trGUI.Output.Report.Sheet, STR_NEW);
		//string strDefault = bReportSource? STR_SOURCE_BOOK : STR_NEW;
		//_check_correct_output_option(trGUI.Output.Report.Sheet, strDefault);
		////---- 
		/////End CURVE_OUTPUT_AUTO_UPDATE_IF_REPORT_IS_NONE
	//}
	////--- end DESC_STATS_ROWS_LOST_OUTPUT_TO_SOURCE			
//
//}
///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK

///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
/////Iris 12/16/04 QA70-7139 CURVE_OUTPUT_AUTO_UPDATE_IF_REPORT_IS_NONE
////static void _check_output_option(TreeNode& trOutput)
//static void _check_correct_output_option(TreeNode& trOutput, LPCSTR lpcszCorrect = NULL)
//{
	//if(!trOutput)
		//return;
	//
	//string strOptions;
	//trOutput.GetAttribute(STR_COMBO_ATTRIB, strOptions);
	//
	/////Iris 12/16/04 QA70-7139 CURVE_OUTPUT_AUTO_UPDATE_IF_REPORT_IS_NONE
	////vector<string> vTemp;
	////strOptions.GetTokens(vTemp, '|');
	/////End CURVE_OUTPUT_AUTO_UPDATE_IF_REPORT_IS_NONE
	//
	//string strVal = trOutput.strVal;
	//string str2ndPart;
	//int nType = str_to_predefined_type(strVal, str2ndPart);
	//if( 0 != str2ndPart.Compare(strVal) && !str2ndPart.IsEmpty())
		//return;
	//
	/////Iris 12/16/04 QA70-7139 CURVE_OUTPUT_AUTO_UPDATE_IF_REPORT_IS_NONE
	////if(-1 == vTemp.Find(strVal))
		////trOutput.strVal = vTemp[0];
	//if(-1 == strOptions.Find(strVal))
		//trOutput.strVal = (NULL == lpcszCorrect)? strOptions.GetToken(0) : lpcszCorrect;
	/////End CURVE_OUTPUT_AUTO_UPDATE_IF_REPORT_IS_NONE
		//
//}
/////End IMPROVE_BOOK_SHEET_OPTIONS
///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
/*
///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
static bool _is_nlfit_output_event(const TreeNode& tr)
{
	int nNLFitOutputEvent = 0;
	tr.GetAttribute(STR_NLFIT_OUTPUT_NODE_EVENT_ATTRIB, nNLFitOutputEvent);
	if(nNLFitOutputEvent == NLFIT_OUTPUT_NODE_EVENT)
		return true;
	
	return false;	
}

static TreeNode _get_GUI_tree_for_nlfit_event(const TreeNode& tr)
{
	TreeNode trNFO = tr.Parent(); 
	return trNFO.OpGUI;
}

static TreeNode _get_GUI_tree(TreeNode& tr)
{
	TreeNode trGUI;
	bool bIsNLFitOutputEvent = _is_nlfit_output_event(tr);
	if(bIsNLFitOutputEvent)
		trGUI = _get_GUI_tree_for_nlfit_event(tr);
	else
		trGUI = tr;
	
	return trGUI;	
}
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
*/
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

bool operation_output_report_book_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	//TreeNode trReport = tr.Output.Report;
	//if(!trReport)
		//return error_report("trGUI.Output.Report missing");
//
	//string strReportBook = trReport.Book.strVal;
	//
	//int 	nReportBookType;
	//string 	str2ndPart;
	//if( !strReportBook.IsEmpty() )
		//nReportBookType = str_to_predefined_type(strReportBook, str2ndPart);
	//
	/////Iris 12/25/2006 v8.0532 CORRECT_BOOK_OPTION_IF_BOOK_NAME_IS_NOT_EXISTED_AFTER_THEME
	//if( !str2ndPart.IsEmpty() && PDS_THREE_DOTS != str_to_predefined_type(str2ndPart) ) //Iris 01/26/2007 v8.0548 ONLY to check when specified page name with <Source> or Existing...
	//{
		//Page 	pg(str2ndPart);
		//bool	bInvalidPage = false;
		//if(	PDS_SOURCE == nReportBookType || PDS_EXISTING == nReportBookType)
			//bInvalidPage = !pg.IsValid();
		//if( PDS_INVALID == nReportBookType || bInvalidPage)
		//{
			//string 	strOldVal;
			//if( trReport.Book.GetAttribute(STR_ATTRIB_OLD_COMBO_VAL, strOldVal) )
			//{
				//strReportBook = strOldVal;
				//nReportBookType = str_to_predefined_type(strReportBook, str2ndPart);
			//}
			//else
			//{
				//strReportBook = STR_SOURCE_BOOK;
				//nReportBookType = PDS_SOURCE;
			//}
		//}
		//trReport.Book.strVal = strReportBook;
	//}
	/////end CORRECT_BOOK_OPTION_IF_BOOK_NAME_IS_NOT_EXISTED_AFTER_THEME
	//
	//bool 	bNoReport = false;
	//bool	bSheetEnable = true;
	//switch(nReportBookType)
	//{
	//case PDS_NONE:
		//bSheetEnable = false;
		//bNoReport = true;
		//break;
	//case PDS_SOURCE:
		////bNoReport = true;
		////---- Iris 10/30/06 STATS_ON_ROWS_FAIL_TO_REPORT_INTP_SOURCE
		///*
		/////Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
		////check existing report sheet
		//Page pg(get_source_page_name(tr));
		//if(!pg)
			//return false;
		//if(!lstrlen( get_sheets_in_book(pg, WKS_REPORT_TABLE) ))
		//{
			//trReport.Sheet.strVal = STR_NEW;
			//bSheetEnable = false;
		//}
		/////End MODIFICATION_OUTPUT_BRANCH
		//*/
		////----
		//break;
	//case PDS_NEW:
		//trReport.Sheet.strVal = STR_NEW;
		//bSheetEnable = false;
		//break;
	//case PDS_CUSTOM:
		//bool bIsCustom = (PDS_CUSTOM == str_to_predefined_type(strReportBook, str2ndPart))? true:false;
		////--- CPY 11/26/04, DESC_STATS_NO_CURVE_OUTPUT
		////bIsCustom = (0 == str2ndPart.Compare(STR_THREE_DOTS))? true: false;
		////if(bIsCustom)
		////	trReport.Book.strVal = get_custom_name_str_input_box(tr, strReportBook, false);
		/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		////_check_ask_custom_book_sheet_name(tr, trReport.Book, str2ndPart, strReportBook, false);
		//check_ask_custom_book_sheet_name(tr, trReport.Book, str2ndPart, strReportBook, false);
		/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		////---
		/////Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
		////check existing report sheet
		//Page pg( trReport.Book.strVal.GetToken(1,'>') );
		//if(!pg)
		//{//select default value
			/////Cheney 2006-11-7 DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
			////trReport.Book.strVal = STR_SOURCE_BOOK;
			/////end DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
			//Page pgSource(get_source_page_name(tr));
			/////Cheney 2006-11-7 DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
			////if(!pg)
			//if(!pgSource)
			/////end DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
				//return false;
			//pg = pgSource;
		//}
		///// Iris 4/18/2007 v8.0603 ADD_OUTPUT_DEST_COL_OPTION_STATS_ON_ROWS
		//if(tr.StatsOnRows && tr.StatsOnRows.nVal)// stats on rows
		//{
			//if(!lstrlen( get_sheets_in_book(pg, WKS_DATA_SHEET) ))
			//{
				//trReport.Sheet.strVal = STR_NEW;
				//bSheetEnable = false;
			//}
			//else
			//{
				//bSheetEnable = true;
			//}
		//}
		/////end ADD_OUTPUT_DEST_COL_OPTION_STATS_ON_ROWS
		//else
		//{
			//if(!lstrlen( get_sheets_in_book(pg, WKS_REPORT_TABLE) ))
			//{
				//trReport.Sheet.strVal = STR_NEW;
				////bSheetEnable = false; ///Cheney 2006-11-7 DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
			//}
			/////End MODIFICATION_OUTPUT_BRANCH
			//bSheetEnable = false; ///Cheney 2006-11-7 DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
		//}
		//break;
	//default:
		//break;
	//}
	//trReport.Sheet.Enable = bSheetEnable;
	////if(tr.Output.Data) //CPY 11/26/04, DESC_STATS_NO_CURVE_OUTPUT
	////_build_curve_ouput_book_sheet_option(tr, nType);  ///Iris 11/12/04 QA70-7139 IMPROVE_RESULT_BOOK_EVENT  
	///// Iris 11/30/04 QA70-7139 IMPROVE_BOOK_SHEET_OPTIONS
	//int nCurveBookType = PDS_USER;
	//if(tr.Output.Data)
		//nCurveBookType = str_to_predefined_type(tr.Output.Data.Book.strVal, str2ndPart);
	//
	////---- CPY 10/2/05 DESC_STATS_ON_ROWS_NEED_REPORT_TO_SOURCE
	//bool bAllowReportToSrcSheet = false;
	//int nn;
	//if(tr.GetAttribute(STR_ALLOW_REPORT_TO_SOURCE_SHEET_ATTRIB, nn) && nn > 0)
		//bAllowReportToSrcSheet = true;
	////----
	//
	/////Cheney 2006-11-7 DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
	////_build_output_book_sheet_option(tr, nReportBookType, nCurveBookType, bAllowReportToSrcSheet);
	//_build_output_book_sheet_option(tr, nReportBookType, nCurveBookType, bAllowReportToSrcSheet);
	//if(PDS_SOURCE == nReportBookType)
		//bSheetEnable = bAllowReportToSrcSheet ? true:false;
	//
	//trReport.Sheet.Enable = bSheetEnable;
	//
	//trReport.Book.SetAttribute(STR_ATTRIB_OLD_COMBO_VAL, trReport.Book.strVal);
	/////end DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
//
	///// Iris 4/18/2007 v8.0603 ADD_OUTPUT_DEST_COL_OPTION_STATS_ON_ROWS
	//_show_report_column_option(tr);
	/////end ADD_OUTPUT_DEST_COL_OPTION_STATS_ON_ROWS
	//
	//return true;
	///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
	//FUNC_OUTPUT_REPORT_BOOK_EVENT pfn = Project.FindFunction("output_report_book_event", "OriginLab\\Event_utils", true);
	//if(pfn)
		//return pfn(tr);
	//return false;
	
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//return output_report_book_event(tr);
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	/*
	bool bIsNLFitOutputEvent = _is_nlfit_output_event(tr);
	TreeNode trGUI = _get_GUI_tree(tr);
	
	/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	//return output_report_book_event(trGUI, NULL, bIsNLFitOutputEvent);
	bool bRet = output_report_book_event(trGUI, NULL, bIsNLFitOutputEvent);
	if(bRet)
	{
		set_report_output_book_name_by_type(trGUI, bIsNLFitOutputEvent);
	}
	return bRet;
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	
	///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	*/
	OutputGUIManagerBase*	pOutputGUIObj = get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnReportBookChanged(tr);
	return false;
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS	
}

///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
bool operation_output_report_book_name_changed(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	operation_output_book_sheet_name_changed(tr, nRow, nCol, trNode, dwCntrl, nType, theDlg);//keep previous logic
	
	OutputGUIManagerBase*	pOutputGUIObj = get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnReportBookNameChanged(tr);
	return false;
}

bool operation_output_curve_book_name_changed(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	operation_output_book_sheet_name_changed(tr, nRow, nCol, trNode, dwCntrl, nType, theDlg);//keep previous logic
	
	OutputGUIManagerBase*	pOutputGUIObj = get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnCurveBookNameChanged(tr, trNode, nRow );
	return false;	
}

bool operation_output_curve_sheet_name_changed(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	operation_output_book_sheet_name_changed(tr, nRow, nCol, trNode, dwCntrl, nType, theDlg);//keep previous logic
	
	OutputGUIManagerBase*	pOutputGUIObj = get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnCurveSheetNameChanged(tr, trNode, nRow);
	return false;	

}
///end UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE

/// Sophy 4/15/2008 FITTED_RESULTS_SHEET_ARRANGEMENT_CHANGED
bool operation_output_fitted_results_sheet_arrangement_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	OutputGUIManagerBase* pOutputGUIObj = get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj )
		return pOutputGUIObj->OnFittedResultSheetArrangementChanged( tr );
	return false;

}
/// end FITTED_RESULTS_SHEET_ARRANGEMENT_CHANGED

/// Iris 4/01/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
/*
bool operation_output_book_sheet_name_changed(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trCurrentNode = tree_get_node(tr, nRow);
	
	OutputGUIManagerBase*	pOutputGUIObj = get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnBookSheetNameChanged(trCurrentNode);
	return false;
}
*/
bool operation_output_book_sheet_name_changed(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{	
	if( !(dwCntrl & GETNEVENT_ON_INIT) || dwCntrl & GETNEVENT_ON_THEME )
	{	
		OutputGUIManagerBase*	pOutputGUIObj = get_output_GUI_manager_pointer(tr);
		if( NULL != pOutputGUIObj)
			return pOutputGUIObj->OnBookSheetNameChanged(trNode);
	}
	return false;
}
///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
OutputGUIManagerBase*	get_output_GUI_manager_pointer(const TreeNode& trGUI)
{	
	TreeNode 	trOutput = tree_get_node_by_tagname(trGUI, "Output", true);
	if( !trOutput )
		trOutput = tree_get_node_by_tagname(trGUI.Parent(), "Output", true);
	
	OutputGUIManagerBase*	pOutputGUIObj = NULL;
	///Iris 4/10/2008 PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET, fail to copy attribute when clone GUI tree in PeakFitHelper
	//int		nn;
	//if( trOutput && trOutput.GetAttribute(STR_OUTPUT_MANAGER_POINTER, nn) )
	if( trOutput && trOutput.OutManagerPointer && !trOutput.OutManagerPointer.IsEmpty() )	
	///end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	{
		int 	nn = trOutput.OutManagerPointer.nVal;
		pOutputGUIObj = (OutputGUIManagerBase*)nn;
	}
	return pOutputGUIObj;
}
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

//----- CPY 5/29/08 FIX_RUNTIME_ERR_WHEN_CAST_DWORD_TO_OPERATION_POINTER_FOR_GRID
/*
/// Iris 4/14/2008 GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
OperationBase*	get_operation_pointer(const TreeNode& trGUI)
{
	TreeNode 	trOutput = tree_get_node_by_tagname(trGUI, "Output", true);
	if( !trOutput )
		trOutput = tree_get_node_by_tagname(trGUI.Parent(), "Output", true);
	
	
	/// YuI 04/14/08
	/// Hong 04/15/08 v8.0843 FAIL_GET_OPERATION_POINTER
	OperationBase*	pOpeartion = NULL;
	//Operation*	pOpeartion = NULL;
	/// end FAIL_GET_OPERATION_POINTER
	/// end YuI 
	if( trOutput && trOutput.OperationPointer && !trOutput.OperationPointer.IsEmpty() )	
	{
		/// YuI 04/1408
		//	int 	nn = trOutput.OperationPointer.nVal;
		//	pOpeartion = (OperationBase*)nn;
		DWORD dwOp = (DWORD)trOutput.OperationPointer.nVal;
		/// Hong 04/15/08 v8.0843 FAIL_GET_OPERATION_POINTER
		//pOpeartion = (Operation*)dwOp;
		pOpeartion = (OperationBase*)dwOp;
		/// end FAIL_GET_OPERATION_POINTER
		/// end YuI
	}
	return pOpeartion;	
}
///end GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
*/
bool set_operation_pointer(TreeNode& trGUI, WksReportOperation* pOp)
{
	ASSERT(trGUI.Output);
	if(!trGUI.Output)
		return false;
	TreeNode	trOperationPtr = tree_check_get_node(trGUI.Output, "OperationPointer"); 
	trOperationPtr.SetAttribute(STR_DATAID_ATTRIB, IDE_OPERATION_POINTER);
	
	/// Iris 5/30/2008 FAIL_TO_GET_OPERATION_POINTER_IN_OUT_GUI_MANAGER
	//DWORD dwOpPtr = (DWORD)(Operation*)pOp;
	DWORD dwOpPtr = (DWORD)(OperationBase*)pOp;
	///end FAIL_TO_GET_OPERATION_POINTER_IN_OUT_GUI_MANAGER
	trOperationPtr.nVal = dwOpPtr;
	trOperationPtr.Show = false;
	trOperationPtr.SetAttribute(STR_XVARIABLE_THEME_APPLICABILITY_ATTRIB, XVTA_DO_NOT_APPLY_VALUE | XVTA_DO_NOT_APPLY_ATTRIBUTES);
	return true;
}
// using Operation instead of OperationBase to allow OC internal validation of dw to pointer cast
WksReportOperation*	get_operation_pointer(const TreeNode& trGUI)
{
	TreeNode 	trOutput = tree_get_node_by_tagname(trGUI, "Output", true);
	if( !trOutput )
		trOutput = tree_get_node_by_tagname(trGUI.Parent(), "Output", true);
	
	Operation*	pOpeartion = NULL;
	if( trOutput && trOutput.OperationPointer && !trOutput.OperationPointer.IsEmpty() )	
	{
		DWORD dwOp = (DWORD)trOutput.OperationPointer.nVal;
		/// Iris 5/30/2008 FAIL_TO_GET_OPERATION_POINTER_IN_OUT_GUI_MANAGER
		//pOpeartion = (Operation*)dwOp;
		pOpeartion = (OperationBase*)dwOp;
		///end FAIL_TO_GET_OPERATION_POINTER_IN_OUT_GUI_MANAGER
	}
	return pOpeartion;	
}
//----- end FIX_RUNTIME_ERR_WHEN_CAST_DWORD_TO_OPERATION_POINTER_FOR_GRID
	
/// Hong 04/15/08 v8.0843 REMOVE_POINTER_IN_OPERATION_GUI_AVOID_ACCIDENT_CRASH
///Kyle 11/13/2008 KEEP_TREE_DATA_ID_SAME_AS_THE_OLD_XF
//void	remove_pointers_node_in_output(TreeNode& trOutput, bool bOperationPointer = true, bool bGUIMngrPointer = true)
void	reset_pointers_in_output(TreeNode& trOutput, bool bOperationPointer = true, bool bGUIMngrPointer = true)
///End KEEP_TREE_DATA_ID_SAME_AS_THE_OLD_XF
{
	if ( !trOutput )
		return ;
	
	if ( bOperationPointer )
	{
		TreeNode	trOperationPtr = trOutput.OperationPointer;
		if ( trOperationPtr )
			///Kyle 11/13/2008 KEEP_TREE_DATA_ID_SAME_AS_THE_OLD_XF
			//trOperationPtr.Remove();
			trOperationPtr.Reset(true);
			///End KEEP_TREE_DATA_ID_SAME_AS_THE_OLD_XF
	}
	
	if ( bGUIMngrPointer )
	{
		TreeNode	trGUIMngrPtr = trOutput.OutManagerPointer;
		if ( trGUIMngrPtr )
			///Kyle 11/13/2008 KEEP_TREE_DATA_ID_SAME_AS_THE_OLD_XF
			//trGUIMngrPtr.Remove();
			trGUIMngrPtr.Reset(true);
			///End KEEP_TREE_DATA_ID_SAME_AS_THE_OLD_XF
	}
}
/// end REMOVE_POINTER_IN_OPERATION_GUI_AVOID_ACCIDENT_CRASH
///Sophy 7/9/2008 CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
TreeNode	get_inputdata_node( const TreeNode& trGUI )
{
	///------ Folger 01/22/09 NLGUI_TREE_LT_ACCESS_CAUSED_RUNTIME_ERROR
	/// never make assumption on TreeNode
	if ( !trGUI )
	{
		TreeNode junk;
		return junk;
	}
	///------ End NLGUI_TREE_LT_ACCESS_CAUSED_RUNTIME_ERROR
	
	WksReportOperation	*pWksRptOp = get_operation_pointer(trGUI);
	ASSERT( pWksRptOp );
	
	TreeNode trInput = trGUI.InputData;//might be NULL
	if( trInput.IsValid() )
		return trInput;
	if( !pWksRptOp )
		///Sophy 9/22/2008 FIX_PA_FAIL_TO_GET_INPUTOUTPUT_NODE temp solution
		//return trInput;
		return tree_get_node_by_tagname( trGUI, "InputData", true );
		///end FIX_PA_FAIL_TO_GET_INPUTOUTPUT_NODE
	
	trInput = pWksRptOp->GetInputDataNode( trGUI );
	return trInput;
}

TreeNode	get_outputdata_node( const TreeNode& trGUI )
{
	WksReportOperation	*pWksRptOp = get_operation_pointer(trGUI);
	ASSERT( pWksRptOp );
	
	TreeNode trOutput = trGUI.Output;//might be NULL
	///Sophy 11/10/2009 IMPROVE_CODE_TO_GET_OP_GUI_OUTPUT_NODE
	//if( !pWksRptOp )
		/////Sophy 9/22/2008 FIX_PA_FAIL_TO_GET_INPUTOUTPUT_NODE temp solution
		////return trOutput;
		//return tree_get_node_by_tagname( trGUI, "Output", true );
		/////end FIX_PA_FAIL_TO_GET_OUTPUT_NODE
	//
	//trOutput = pWksRptOp->GetOutputNode( trGUI );
	if ( trOutput )
		return trOutput;
	if ( pWksRptOp )
		trOutput = pWksRptOp->GetOutputNode(trGUI);
	else
		trOutput = tree_get_node_by_tagname(trGUI, "Output", true);
	///end IMPROVE_CODE_TO_GET_OP_GUI_OUTPUT_NODE
	return trOutput;
}
///end CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER

///Sophy 11/27/2008 v8.980d CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
bool	has_output_one_range_been_reported(const TreeNode& trGUI, const int nOutputRangeIndex, const int nDatasetIndex = 0)
{
	WksReportOperation	*pWksRptOp = get_operation_pointer(trGUI);
	ASSERT(pWksRptOp);
	
	if( pWksRptOp )
	{
		return pWksRptOp->HasOutput(nOutputRangeIndex, nDatasetIndex);
	}
	return false;
}
///end CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE

/// Hong 04/14/08 v8.0842 GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
int	get_report_output_destination(const TreeNode& trGUI, const TreeNode& trBookSheetBranch)
{	
	int		nReportType = PDS_INVALID;
	if ( !trGUI || !trBookSheetBranch )
		return nReportType;
	
	WksReportOperation* 	pWksRptOp = get_operation_pointer(trGUI);
	if ( pWksRptOp )
	{
		int		nDataID = 0, nBackUpID = 0;
		trBookSheetBranch.GetAttribute(STR_DATAID_ATTRIB, nDataID);
		trBookSheetBranch.GetAttribute(STR_BACKUP_ID_ATTRIB, nBackUpID);	
		
		///Sophy 7/6/2009 SUPPORT_NANOSIZER_OUTPUTGUIMANAGER
		//TreeNode	trInput = tree_get_node_by_tagname(trGUI, "InputData", true);
		TreeNode	trInput = pWksRptOp->GetInputDataNode(trGUI);
		///end SUPPORT_NANOSIZER_OUTPUTGUIMANAGER
		///Sophy 7/7/2008 FIX_FAIL_TO_GET_INPUTDATA_NODE_ON_CHANGE_INPUT_DATA
		if( ! trInput )//when change inputdata trGUI is from m_trNFO.OpGUI,which doesn't contain InputData
		{
			trInput = tree_get_node_by_tagname( trGUI.Parent(), "InputData", true );// get InputData from m_trNFO.DataSelection.InputData
		}
		///end FIX_FAIL_TO_GET_INPUTDATA_NODE_ON_CHANGE_INPUT_DATA
		ASSERT(trInput); //Iris ask for this assert to quickly find out error
		if ( IDST_REPORT_SHEET_OPTIONS == nDataID || IDST_REPORT_SHEET_OPTIONS == nBackUpID )
		{
			/// Hong 04/15/08 v8.0843 FIX_AUTO_FAIL_GET_CORRECT_BOOKNAME
			//nReportType = pWksRptOp->GetReportOutPutDestination(trGUI.InputData);			
			if ( trInput )
			{
				nReportType = pWksRptOp->GetReportOutPutDestination(trInput);
			}
			/// end FIX_AUTO_FAIL_GET_CORRECT_BOOKNAME
		}
		else if ( IDST_REPORT_CURVE_OPTIONS == nDataID || IDST_REPORT_CURVE_OPTIONS == nBackUpID )
		{
			string		strBookName;
			/// Hong 04/15/08 v8.0843 FIX_AUTO_FAIL_GET_CORRECT_BOOKNAME
			//nReportType = pWksRptOp->GetDataOutPutDestination(trGUI.Output, strBookName, NULL);
			TreeNode	trOuput = tree_get_node_by_tagname(trGUI, "Output", true);
			if ( trOuput )
			{
				/// Hong 04/15/08 v8.0843 FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
				//nReportType = pWksRptOp->GetDataOutPutDestination(trOuput, strBookName, NULL);
				///Sophy 6/2/2008 ADD_SOURCE_BOOK_FOR_PLOT_DATA_REDISUAL_ON_MATRIX_FIT
				//nReportType = pWksRptOp->GetDataOutPutDestination(trOuput, trInput, strBookName, NULL);
				nReportType = pWksRptOp->GetDataOutPutDestination( trGUI.Parent(), trOuput, trInput, strBookName, NULL);
				///end ADD_SOURCE_BOOK_FOR_PLOT_DATA_REDISUAL_ON_MATRIX_FIT
				/// end FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
			}
			/// end FIX_AUTO_FAIL_GET_CORRECT_BOOKNAME
		}		
	}
	return nReportType;
}
/// end GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE

///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
///// Iris 4/18/2007 v8.0603 ADD_OUTPUT_DEST_COL_OPTION_STATS_ON_ROWS
//static void _show_report_column_option(TreeNode& trGUI)
//{
	//bool 		bStatsOnRows = (trGUI.StatsOnRows && trGUI.StatsOnRows.nVal)? true : false;
	//TreeNode 	trReport = trGUI.Output.Report;
	//TreeNode	trCol = trReport.Column;
	//if(bStatsOnRows && trCol)
	//{		
		//int		nReportBookType = str_to_predefined_type(trReport.Book.strVal);
		//int		nReportSheetType = str_to_predefined_type(trReport.Sheet.strVal);
		//bool	bShowColumnOption = false;
		//if(PDS_SOURCE == nReportBookType && PDS_SOURCE == nReportSheetType ||
			//PDS_CUSTOM == nReportBookType && PDS_CUSTOM == nReportSheetType )
			//bShowColumnOption = true;
			//
		//trCol.Show = bShowColumnOption;
	//}
//}
/////END ADD_OUTPUT_DEST_COL_OPTION_STATS_ON_ROWS
///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK

///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
/////Iris 11/25/04
////string get_source_page_name(TreeNode& trOperation)
//string get_source_page_name(TreeNode& trOperation, string *pstrLayerName = NULL)
//{	
	//string	strName;
	/////Iris 3/17/05 QA70-7478 MAKE_EXISTING_WORK_FOR_VAR_DATA
	////TreeNode trFirstNode = 	trOperation.InputData.Range1.FirstNode;
	////if(trFirstNode)
	//if(trOperation.InputData)
	/////end MAKE_EXISTING_WORK_FOR_VAR_DATA
	//{
		/////Arvin 08/14/07 v8.0681 RUNTIME_ERROR_IN_ANOVA_ONE_WAY
		////TreeNode trFirstNode = 	trOperation.InputData.Range1.FirstNode;
		//TreeNode trFirstNode;
		//TreeNode trRange1 = trOperation.InputData.Range1;
		//if(trRange1)
			//trFirstNode = trRange1.FirstNode;
		//else
			//trFirstNode = trOperation.InputData.FirstNode;
		/////end RUNTIME_ERROR_IN_ANOVA_ONE_WAY
		//string strVal = trFirstNode.strVal;
		//strVal.Delete(0);
		//strName = strVal.GetToken(0, ']');		
	//}
	/////Iris 3/17/05 QA70-7478 MAKE_EXISTING_WORK_FOR_VAR_DATA
	//else  //is XF variable
	//{
		////TreeNode tr = trOperation.Parent;
		//XFunction xf;//(trOperation, false);
		//string strBookName, strSheetName;
		//if( xf.GetSourceBookSheet(strBookName, strSheetName) )
			//strName = strBookName;
		/////End GET_BOOK_SHEET_NAME_OF_XVAR_CLASS
		//
		/////----Frank 5/13/05 
		//if( pstrLayerName != NULL)
			//*pstrLayerName = strSheetName;
		/////----	
	//}
	/////end MAKE_EXISTING_WORK_FOR_VAR_DATA
	//return strName;	
//}
///FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK

///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
//string get_report_page_name(TreeNode& trOperation)
//{
	//string strName;
	//TreeNode trReportBook = trOperation.Output.Report.Book;
	//if(trReportBook)
	//{
		//int nType;
		//string str2ndPart;
		//nType = str_to_predefined_type(trReportBook.strVal, str2ndPart);
		//if(!str2ndPart.IsEmpty())
		//{
			//if(str2ndPart.Compare(STR_THREE_DOTS))
				//strName = str2ndPart;
		//}
		//else if(PDS_SOURCE == nType)
			//strName = get_source_page_name(trOperation);						
	//}	
	//return strName;
//}
//
/////Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH 
//string get_fitcurve_page_name(TreeNode& trOperation)
//{
	//string strName;
	//
	//TreeNode trGUI = tree_get_node_by_tagname(trOperation, "GUI", true);
	//TreeNode trBook = trGUI.Output.Data.Book;
	//if(trBook)
	//{
		//int nType;
		//string str2ndPart;
		//nType = str_to_predefined_type(trBook.strVal, str2ndPart);
		//if(!str2ndPart.IsEmpty())
		//{
			//if(str2ndPart.Compare(STR_THREE_DOTS))
				//strName = str2ndPart;
		//}
		//if(PDS_REPORT == nType)
			//strName = get_report_page_name(trGUI);
		//if(PDS_SOURCE == nType)
			//strName = get_source_page_name(trGUI);						
	//}	
	//return strName;
//}
/////End MODIFICATION_OUTPUT_BRANCH
///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK


///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
/////Iris 11/12/04 QA70-7139 ADD_CUSTOM_OPTION_TO_REPORT
//static bool _open_custom_input_box(TreeNode& trGUI, string strBook, string& strOutput, bool bSheet = true, int nDBTY = DBTY_CURVE_OUTPUT, int nSheetType = WKS_ALL)  ///Iris 11/23/04 CHANGED_RETURN_VAL
//{	
	//string 	strPageName;
	//string 	strRealSourcePage = get_source_page_name(trGUI);
	//
	////when selection of Report Book is "<Source>  book1" or "<custom> book1", need convert to real page name
	////else if it is "<custom>...", the default of input box should be empty
	//int nType;
	//string str2ndPart;	
	//str2ndPart = page_short_name_from_display_name(strBook, nType);
	///// Iris 11/27/04, add a case when Curve Book is <Report>
	////if(PDS_SOURCE == nType || PDS_CUSTOM == nType)
	////{
		////if(strTemp.IsEmpty())
		////{
			////strPageName = strRealSourcePage;
		////}
		////else if(0 != strTemp.Compare(STR_THREE_DOTS))
			////strPageName = strTemp;
		////else
			////strPageName.Empty();
	////}	
	//switch(nType)
	//{
	/////Iris 3/23/05 QA70-7478 MAKE_EXISTING_WORK_FOR_VAR_DATA
	//case PDS_USER:
		//strPageName = str2ndPart;
		//break;
	/////end MAKE_EXISTING_WORK_FOR_VAR_DATA
	//case PDS_SOURCE:
	//case PDS_CUSTOM:
		//if(str2ndPart.IsEmpty())
			//strPageName = strRealSourcePage;
		//else
			//if(str2ndPart.Compare(STR_THREE_DOTS))
				//strPageName = str2ndPart;
		//break;
	//case PDS_FIT_CURVE:
		//strPageName = get_fitcurve_page_name(trGUI);
			//break;
	//case PDS_REPORT:
		//strPageName = get_report_page_name(trGUI);
			//break;
	//default:
		//break;
	//}
	//
	//string strNameList;
	//if(!bSheet)
	//{
		/////Iris 4/16/05 EXISTING_BOOK_NEED_INCLUDE_HIDDEN_BOOK
		////strNameList = get_show_books_in_project(strRealSourcePage);
		//vector<string> vsPages;
		//char chToken = '|';
		//_get_project_pages_name(vsPages);
		//strNameList.SetTokens(vsPages, chToken);
		/////end EXISTING_BOOK_NEED_INCLUDE_HIDDEN_BOOK
	//}
	//else
	//{			
		//int nSheet=0;
		///// Iris 9/06/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
		////WorksheetPage wp(strPageName);
		///////Iris 3/17/05 QA70-7478 MAKE_EXISTING_WORK_FOR_VAR_DATA
		//////if(wp)
		//////	strNameList = get_report_sheets_in_book(wp, nSheet);
		////if(!wp)
			////return false;
		//Page pg(strPageName);
		//if(!pg)
			//return false;
		/////End SURFACE_FIT_REPORT_MAT_FIT_DATA
		/////Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
		///*
		//if(nDBTY == DBTY_CURVE_OUTPUT)
			//strNameList = get_report_sheets_in_book(pg, nSheet);
		//else
			//strNameList = page_get_layer_names(pg);
		//*/
		/////Iris 10/12/06 v8.0494c CAN_DECIDE_TO_DATA_SHEET_OR_REPORT_SHEET_OR_ALL
		////strNameList = get_sheets_in_book(pg, nDBTY != DBTY_CURVE_OUTPUT);
		//strNameList = get_sheets_in_book(pg, nSheetType);
		/////end CAN_DECIDE_TO_DATA_SHEET_OR_REPORT_SHEET_OR_ALL
		/////End MODIFICATION_OUTPUT_BRANCH
		/////end MAKE_EXISTING_WORK_FOR_VAR_DATA
	//}	
//
	/////Iris 3/23/05 QA70-7478 MAKE_EXISTING_WORK_FOR_VAR_DATA
	///*
	//vector<string> vsOptions;
	//strNameList.GetTokens(vsOptions, '|');
	//try 
	//{
		//strOutput = ComboInputBox(&vsOptions, "", _L("Input name"), _L("Customize Name..."));
	//}
	//catch(int nErr)
	//{
		//return false;
	//}
	//*/
	/////Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
	//if(!lstrlen(strNameList))
		//return false;
	/////End MODIFICATION_OUTPUT_BRANCH
	//GETN_TREE(tr)
	//GETN_LIST(list, "Existing name", 0, strNameList)
	/////Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING
	////if(GetNBox(tr, _L("Select Name..."), _L("  ") ))
	//if(GetNBox(tr, _L("Select Name..."), "  " ))
	/////end REMOVE_SPACE_FOR_LOCATION_STRING
	//{
		/////Iris 4/01/05 CENTRALIZE_GET_SEL_STR_FROM_COMBOLIST
		////int 			nChoose = tr.list.nVal;
		////vector<string> 	vsNames;
		////strNameList.GetTokens(vsNames, '|');
		////strOutput = nChoose < vsNames.GetSize()? vsNames[nChoose] : "";
		//strOutput = get_selected_string_from_combolist(tr.list);
		/////end CENTRALIZE_GET_SEL_STR_FROM_COMBOLIST
	//}
	/////end MAKE_EXISTING_WORK_FOR_VAR_DATA
	//
	//if(!strOutput.IsEmpty())
	//{
		//strOutput = STR_CUSTOM + " " + strOutput;   ///Iris 11/23/04 		
		//return true;	
	//}
	//return false;///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
//}
///FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK

///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
/////Arvin 04/30/07 v8.0610 FILTER_EXISTING_FOR_SURFACE_FITTING
//static void _check_wks_or_matrix_book_sheet(int nReportMatrix, int nID, bool& bWks = true)
//{
	//if(nReportMatrix == 0)
	//{
		//bWks = true;
		//return;
	//}
	//
	//switch(nID)
	//{
	//case IDE_RESIDUAL_CURVE_BOOK:
	//case IDE_RESIDUAL_CURVE_SHEET:
		//if(nReportMatrix == 1) //Surface fitting
			//bWks = true;
		//else
			//bWks = false; //Matrix fitting
		//break;
		//
	//case IDE_RESULT_CURVE_BOOK:
	//case IDE_RESULT_CURVE_SHEET:
		//bWks = false;
		//break;
			//
	//default:
		//bWks = true;
		//break;
	//}	
//}
/////end FILTER_EXISTING_FOR_SURFACE_FITTING
////---- CPY 11/26/04, DESC_STATS_NO_CURVE_OUTPUT
//// I found Iris's code with custom not working at all, so I have centralized the code here
//// not sure if the rest if working fully yet
/////Arvin 04/30/07 v8.0610 FILTER_EXISTING_FOR_SURFACE_FITTING
////static void _check_ask_custom_book_sheet_name(TreeNode& trGUI, TreeNode& trReport, const string& str2ndPart, const string& strReportBook, bool bSheet = true, int nDBTY = DBTY_CURVE_OUTPUT, int nSheetType = WKS_ALL)
//static void _check_ask_custom_book_sheet_name(TreeNode& trGUI, TreeNode& trReport, const string& str2ndPart, const string& strReportBook, bool bSheet = true, int nDBTY = DBTY_CURVE_OUTPUT, int nSheetType = WKS_ALL, int nBookSheetType = 0)
/////end FILTER_EXISTING_FOR_SURFACE_FITTING
//{
	//if(str2ndPart.Compare(STR_THREE_DOTS))
		//return;
	//
	//string strOutput;
//
	/////Kevin 11/23/05	OPEN_PROJECT_BROWSER_WHEN_SELECT_EXSITING
	///*
	//if(_open_custom_input_box(trGUI, strReportBook, strOutput, bSheet, nDBTY))
	//{
		//trReport.strVal = strOutput;
		////insert custom string to drop down string list
		//string strAttri;
		//trReport.GetAttribute(STR_COMBO_ATTRIB, strAttri);
		//insert_str_to_str_list(strOutput, strAttri, STR_CUSTOM + STR_THREE_DOTS, STR_TOKEN_SEP);
		//trReport.SetAttribute(STR_COMBO_ATTRIB, strAttri);		
	//}
	//else
		//trReport.strVal.Empty();   ///Iris 11/27/04, cannot allow <custom>... show, so let it empty if returns false.
	//*/
	//if (!bSheet) 
	//{
		///// Iris 9/06/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
		//int		nReportMatrix = 0;
		//if(trGUI.Output.Data)///Cheneny 2006-11-7 IF_trGUI.Output.Data_NOT_EXIST_CAUSE_RUN_TIME_ERROR
			//trGUI.Output.Data.GetAttribute(STR_REPORT_MATRIX_DATA, nReportMatrix);
		/////end SURFACE_FIT_REPORT_MAT_FIT_DATA
		//
		/////Arvin 04/30/07 v8.0610 FILTER_EXISTING_FOR_SURFACE_FITTING
		//bool bWks;
		//_check_wks_or_matrix_book_sheet(nReportMatrix, nBookSheetType, bWks);
		/////end FILTER_EXISTING_FOR_SURFACE_FITTING
		//
		//string 	strPath = "Originlab\\ProjectBrowser.c";
		//FUNC_STR_DWORD_HWND_BOOL pfn;
		//pfn = Project.FindFunction("ProjectBrowseBook", strPath);
//
		//string 	strSelectedName;
		////if( pfn && pfn(strSelectedName, 0, GetWindow()) && !strSelectedName.IsEmpty())
		/////Arvin 04/30/07 v8.0610 FILTER_EXISTING_FOR_SURFACE_FITTING
		////if( pfn && pfn(strSelectedName, 0, GetWindow(), !nReportMatrix) && !strSelectedName.IsEmpty())
		//if( pfn && pfn(strSelectedName, 0, GetWindow(), bWks) && !strSelectedName.IsEmpty())
		/////end FILTER_EXISTING_FOR_SURFACE_FITTING
		//{
			//strSelectedName = STR_CUSTOM + strSelectedName;
			////--- CPY 11/24/05 QA70-8363 COMBO_CHANGE_IN_EVENT_NOT_PROPER_UPDATED
			///*
			//trReport.strVal = strSelectedName;
			//string strAttri;
			//trReport.GetAttribute(STR_COMBO_ATTRIB, strAttri);
			//
			//insert_str_to_str_list(strSelectedName, strAttri, STR_CUSTOM + STR_THREE_DOTS, STR_TOKEN_SEP);
			//trReport.SetAttribute(STR_COMBO_ATTRIB, strAttri);	
			//*/
			//set_str_insert_combo(trReport, strSelectedName, STR_CUSTOM + STR_THREE_DOTS);
			////----
		//}
		/////Cheney 2006-11-7 DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
		//else
		//{
			//string strOldComboVal;
			//trReport.GetAttribute(STR_ATTRIB_OLD_COMBO_VAL, strOldComboVal);
			//trReport.strVal = strOldComboVal;
		//}
		/////end DEL_PSD_CUSTOM_IN_SHEET_NODE_COMBO_LIST
	//}	
	//else
	//{
		/////Iris 10/12/06 v8.0494c CAN_DECIDE_TO_DATA_SHEET_OR_REPORT_SHEET_OR_ALL
		////if(_open_custom_input_box(trGUI, strReportBook, strOutput, bSheet, nDBTY))
		//if(_open_custom_input_box(trGUI, strReportBook, strOutput, bSheet, nDBTY, nSheetType))
		//{
			//trReport.strVal = strOutput;
			////insert custom string to drop down string list
			//string strAttri;
			//trReport.GetAttribute(STR_COMBO_ATTRIB, strAttri);
			//insert_str_to_str_list(strOutput, strAttri, STR_CUSTOM + STR_THREE_DOTS, STR_TOKEN_SEP);
			//trReport.SetAttribute(STR_COMBO_ATTRIB, strAttri);		
		//}
		/////Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
		//else
			//trReport.strVal = STR_NEW;
		/////End MODIFICATION_OUTPUT_BRANCH
	//}
	/////End	OPEN_PROJECT_BROWSER_WHEN_SELECT_EXSITING
//}
////----
///FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK

///Iris 11/12/04 QA70-7139 ADD_CUSTOM_OPTION_TO_REPORT
bool operation_output_report_sheet_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//bool bIsNLFitOutputEvent = _is_nlfit_output_event(tr);
	//TreeNode trGUI = _get_GUI_tree(tr);
	/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL	
	
	//TreeNode 	trReport = tr.Output.Report;
	//if(trReport)
	//{
		//string 	strReportSheet = trReport.Sheet.strVal;		
		//string 	strReportBook = trReport.Book.strVal;
		//
		//int nType;
		//string str2ndPart;
		//nType = str_to_predefined_type(strReportSheet, str2ndPart);	
		//switch(nType)
		//{
		//case PDS_CUSTOM:		
			////if(0 == str2ndPart.Compare(STR_THREE_DOTS))
			////	trReport.Sheet.strVal = get_custom_name_str_input_box(tr, strReportBook);
			/////Iris 10/12/06 v8.0494c CAN_DECIDE_TO_DATA_SHEET_OR_REPORT_SHEET_OR_ALL
			////_check_ask_custom_book_sheet_name(tr, trReport.Sheet, str2ndPart, strReportBook);
			/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
			////_check_ask_custom_book_sheet_name(tr, trReport.Sheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, WKS_REPORT_TABLE);
			/////Arvin 08/31/07 PDS_CUSTOM_CAN_NOT_WORK_IN_STATS_ON_ROWS
			//int nWksType = WKS_REPORT_TABLE;
			//if(tr.StatsOnRows && tr.StatsOnRows.nVal)
				//nWksType = WKS_DATA_SHEET;
			/////end 	PDS_CUSTOM_CAN_NOT_WORK_IN_STATS_ON_ROWS
			/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
			////FUNC_CHECK_ASK_CUSTOM_BOOK_SHEET_NAME pfn = Project.FindFunction("check_ask_custom_book_sheet_name", "OriginLab\\Event_utils", true);
			////if(pfn)
			////	///Arvin 08/31/07 PDS_CUSTOM_CAN_NOT_WORK_IN_STATS_ON_ROWS
			////	//pfn(tr, trReport.Sheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, WKS_REPORT_TABLE);
			////	pfn(tr, trReport.Sheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, nWksType);
			////	///end PDS_CUSTOM_CAN_NOT_WORK_IN_STATS_ON_ROWS
			/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
			////check_ask_custom_book_sheet_name(tr, trReport.Sheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, nWksType);
			//check_ask_custom_book_sheet_name(trGUI, trReport.Sheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, nWksType, 0, bIsNLFitOutputEvent);
			/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
			/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
			/////end CAN_DECIDE_TO_DATA_SHEET_OR_REPORT_SHEET_OR_ALL
			//
			/////Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
			//string strSheet = trReport.Sheet.strVal;
			/////---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
			////if(!strSheet.CompareNoCase(STR_CUSTOM + STR_THREE_DOTS))
			//if ( compare_string_localization(strSheet, STR_CUSTOM_E + STR_THREE_DOTS, true) )
			/////---END CLEAN_LOCALIZATION_CODE
				//trReport.Sheet.strVal = STR_NEW;
			/////End MODIFICATION_OUTPUT_BRANCH
			//break;
		//default:
			//break;
		//}
		//
		///// Iris 4/18/2007 v8.0603 ADD_OUTPUT_DEST_COL_OPTION_STATS_ON_ROWS
		/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		////_show_report_column_option(tr);
		/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
		////FUNC_SHOW_REPORT_COLUMN_OPTION pfn = Project.FindFunction("show_report_column_option", "OriginLab\\Event_utils", true);
		////if(pfn)
		////	pfn(tr);
		/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		////show_report_column_option(tr);
		//show_report_column_option(trGUI, bIsNLFitOutputEvent);
		/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		/////end ADD_OUTPUT_DEST_COL_OPTION_STATS_ON_ROWS
//
		//return true;
	//}	
	//return false;	
	OutputGUIManagerBase*	pOutputGUIObj = get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnReportSheetChanged(tr);
	return false;
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
}

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
/*
/// YuI 05/23/05
static TreeNode _get_xfunction_tree_node_from_data_node(TreeNode& trData)
{
	TreeNode trReturn;
	if( !trData )
		return trReturn;
	TreeNode trVar = trData.Parent();
	if( !trVar )
		return trReturn;
	TreeNode trVars = trVar.Parent();
	if( !trVars )
		return trReturn;
	trReturn = trVars.Parent();
	return trReturn;
}
/// end YuI 05/23/05

///Iris 3/17/05 QA70-7493 BUILD_XVAR_DATA_BRANCH
static bool _check_get_xf_data_branch(TreeNode &trGUI, TreeNode& trNode, TreeNode &trData, int nRow)
{
	if(!trData)
	{
		if(trNode)
		{
			trData = trNode.Parent();
			if(trData)
				return true;
		}
	}
		
	return false;
}
///end BUILD_XVAR_DATA_BRANCH
*/
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS


///Iris 11/11/04 QA70-7139 IMPROVE_CURVE_BOOK_EVENT
//bool operation_output_curve_book_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
bool operation_output_curve_book_event(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nType, WndContainer& getNContainer) //--- CPY 5/20/05 QA70-7744 NEW_GETN_EVENT
{
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//bool bIsNLFitOutputEvent = _is_nlfit_output_event(tr);
	//TreeNode trGUI = _get_GUI_tree(tr);
	/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	//
	//TreeNode trOutput = tr.Output;
	//if(!trOutput)
		//trOutput = tree_get_node_by_tagname(tr, "Output", true);
	//TreeNode trData = trOutput.Data;
	//int			nDBTY;
	//if(_check_get_xf_data_branch(tr, trNode, trData, nRow))
		//nDBTY = DBTY_X_FUNC_VAR;
	//else
		//nDBTY = DBTY_CURVE_OUTPUT;
	//if(!trData)
		//return error_report("Data node cannot be found!");
	/////end BUILD_XVAR_DATA_BRANCH
	//
	///// YuI 05/23/05
	//TreeNode trRootNode;
	//if( nDBTY == DBTY_X_FUNC_VAR )
		//trRootNode = _get_xfunction_tree_node_from_data_node(trData);
	//else
		/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		////trRootNode = tr;
		//trRootNode = trGUI;
		/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	//
	//if( !trRootNode )
	//{
		///// YuI 10/03/05 XVARIABLE_GETN_TRANSLATION_IMPROVEMENT
		////	return error_report("Root node cannot be found!");
		//// even though tree is not complete XFunctiuon tree (GetN tree for instance)
		//// we still need to provide basic support for <new> and <same> for book sheet
		//if( DBTY_X_FUNC_VAR == nDBTY )
		//{
			//string strTemp1;
			//string strTemp2;
			//_xvars_build_data_branch(trData, strTemp1, strTemp2);
			//return true;
		//}
		//else
			//return error_report("Root node cannot be found!");
		///// end XVARIABLE_GETN_TRANSLATION_IMPROVEMENT
	//}
	///// end YuI 05/23/05
	//
	/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	////string strCurveBook = trData.Book.strVal;
	////
	////int nCurveBookType;
	////string str2ndPart;
	////nCurveBookType = str_to_predefined_type(strCurveBook, str2ndPart);		
////
	////bool	bSheetEnable = true;
	////switch(nCurveBookType)
	////{
	////case PDS_NONE:
		////bSheetEnable = false;
		////break;
	///////Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
	////case PDS_REPORT:
	////case PDS_NEW:
		////trData.Sheet.strVal = STR_NEW;
		////bSheetEnable = false;
		////break;
	///////End MODIFICATION_OUTPUT_BRANCH
	////case PDS_CUSTOM: ///Iris 11/12/04 QA70-7139 ADD_CUSTOM_OPTION_TO_REPORT		
		//////if(0 == str2ndPart.Compare(STR_THREE_DOTS))
		//////	trData.Book.strVal = open_custom_input_box(tr, strCurveBook, false);
		////
		/////// YuI 05/23/05
		//////	_check_ask_custom_book_sheet_name(tr, trData.Book, str2ndPart, strCurveBook, false);
		///////Arvin 04/30/07 v8.0610 FILTER_EXISTING_FOR_SURFACE_FITTING
		//////_check_ask_custom_book_sheet_name(trRootNode, trData.Book, str2ndPart, strCurveBook, false);
		///////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		//////_check_ask_custom_book_sheet_name(trRootNode, trData.Book, str2ndPart, strCurveBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_RESULT_CURVE_BOOK);
		////check_ask_custom_book_sheet_name(trRootNode, trData.Book, str2ndPart, strCurveBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_RESULT_CURVE_BOOK);
		///////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		///////end FILTER_EXISTING_FOR_SURFACE_FITTING
		/////// end YuI 05/23/05
		///////Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
		////Page pg( trData.Book.strVal.GetToken(1,'>') );
		////if(!pg)
		////{//select default value
			////trData.Book.strVal = STR_NEW;
			////trData.Sheet.strVal = STR_NEW;
			////bSheetEnable = false;
		////}
		///////End MODIFICATION_OUTPUT_BRANCH
		////break;
	////default:
		////break;
	////}	
	////if(trData.Book.Enable)//Iris 02/05/2007 click Change Parameter to open dialog, Book and Sheet both should disabled.
		////trData.Sheet.Enable = bSheetEnable;
	//int nCurveBookType;
	//string str2ndPart;
	/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
	////FUNC_UPDATE_OUTPUT_CURVE_BOOK_SETTING pfn1 = Project.FindFunction("update_output_curve_book_setting", "OriginLab\\Event_utils", true);
	////if(pfn1)
	////	pfn1(trRootNode, trData, nCurveBookType, str2ndPart);
	/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	////update_output_curve_book_setting(trRootNode, trData, nCurveBookType, str2ndPart);	
	//update_output_curve_book_setting(trRootNode, trData, nCurveBookType, str2ndPart, NULL, bIsNLFitOutputEvent);	
	/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	//
	///// ML 3/3/2005 XFUNCTION_OUTPUT_VARIABLES_DATA_ASSOC
	//if (DBTY_X_FUNC_VAR == nDBTY)
	//{
		/////-----Frank 5/14/05	QA70
		////_xvars_build_data_branch(trData, nCurveBookType);
		//string	strSourceSheet; 
		/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		////string strSourceBook = get_source_page_name(trRootNode, &strSourceSheet);
		//string strSourceBook;
		/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
		////FUNC_GET_SOURCE_PAGE_NAME pfn = Project.FindFunction("get_source_page_name", "OriginLab\\Event_utils", true);
		////if(pfn)
		////	strSourceBook = pfn(trRootNode, &strSourceSheet);
		//strSourceBook = get_source_page_name(trRootNode, &strSourceSheet);
		/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		//
		///// YuI 05/17/05
		////_xvars_build_data_branch(trData, nCurveBookType, strSourceBook, strSourceSheet);
		//_xvars_build_data_branch(trData, strSourceBook, strSourceSheet);
		///// end YuI 05/17/05
		/////-----
		//return true;
	//}
	///// end XFUNCTION_OUTPUT_VARIABLES_DATA_ASSOC
//
	/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	//////_build_curve_ouput_book_sheet_option(tr, NULL, nBookType);  ///Iris 11/25/04, Update Curve sheet options following Curve page selection
	/////// Iris 11/30/04 QA70-7139 IMPROVE_BOOK_SHEET_OPTIONS
	////int nReportBookType = str_to_predefined_type(tr.Output.Report.Book.strVal, str2ndPart);
	////_build_output_book_sheet_option(tr, nReportBookType, nCurveBookType);
	/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
	////FUNC_UPDATE_OUTPUT_CURVE_BOOK_OPTION pfn2 = Project.FindFunction("update_output_curve_book_option", "OriginLab\\Event_utils", true);
	////if(pfn2)
	////	pfn2(tr, str2ndPart, nCurveBookType);
	/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	////update_output_curve_book_option(tr, str2ndPart, nCurveBookType);
	//update_output_curve_book_option(tr, str2ndPart, nCurveBookType, NULL, bIsNLFitOutputEvent);
	/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	//return true;	
	OutputGUIManagerBase*	pOutputGUIObj = get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnCurveBookChanged(tr, trNode, nRow);
	return false;
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS	
}


///Iris 11/12/04 QA70-7139 ADD_CUSTOM_OPTION_TO_REPORT
//bool operation_output_curve_sheet_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
bool operation_output_curve_sheet_event(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nType, WndContainer& getNContainer) //--- CPY 5/20/05 QA70-7744 NEW_GETN_EVENT
{	
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//bool bIsNLFitOutputEvent = _is_nlfit_output_event(tr);
	//TreeNode trGUI = _get_GUI_tree(tr);
	/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	//
	//TreeNode trOutput = tr.Output;
	//if(!trOutput)
		//trOutput = tree_get_node_by_tagname(tr, "Output", true);
	//TreeNode trData = trOutput.Data;
	//
	/////Iris 3/17/05 QA70-7493 BUILD_XVAR_DATA_BRANCH
	//int		nDBTY;
	//if(_check_get_xf_data_branch(tr, trNode, trData, nRow))
		//nDBTY = DBTY_X_FUNC_VAR;
	//else
		//nDBTY = DBTY_CURVE_OUTPUT;
	/////end BUILD_XVAR_DATA_BRANCH	
	//
	//// YuI 05/23/05
	//TreeNode trRootNode;
	//if( nDBTY == DBTY_X_FUNC_VAR )
		//trRootNode = _get_xfunction_tree_node_from_data_node(trData);
	//else
		/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		////trRootNode = tr;
		//trRootNode = trGUI;
		/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	//
	//if( !trRootNode )
		///// YuI 10/03/05 XVARIABLE_GETN_TRANSLATION_IMPROVEMENT
		////	return error_report("Root node cannot be found!");
		//// no need to report error here
		//// this can happen for GetNBox based invocation of XFunction
		//return true;
		///// end XVARIABLE_GETN_TRANSLATION_IMPROVEMENT
	///// end YuI 05/23/05
	//
	//if(trData)
	//{		
		//string strCurveSheet = trData.Sheet.strVal;
		//string strCurveBook = trData.Book.strVal;
		//
		//int nType;
		//string str2ndPart;
		//nType = str_to_predefined_type(strCurveSheet, str2ndPart);		
		//switch(nType)
		//{
		//case PDS_CUSTOM:		
			////_check_ask_custom_book_sheet_name(tr, trData.Sheet, str2ndPart, strCurveBook, true);
			////_check_ask_custom_book_sheet_name(tr, trData.Sheet, str2ndPart, strCurveBook, true, nDBTY);  ///Iris 3/17/05 QA70-7493 BUILD_XVAR_DATA_BRANCH
			////_check_ask_custom_book_sheet_name(trRootNode, trData.Sheet, str2ndPart, strCurveBook, true, nDBTY);  ///Iris 3/17/05 QA70-7493 BUILD_XVAR_DATA_BRANCH
			/////Iris 10/12/06 v8.0494c CAN_DECIDE_TO_DATA_SHEET_OR_REPORT_SHEET_OR_ALL
			////_check_ask_custom_book_sheet_name(trRootNode, trData.Sheet, str2ndPart, strCurveBook, true, DBTY_X_FUNC_VAR);///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH, for no report sheet
			/////Arvin 04/30/07 v8.0610 FILTER_EXISTING_FOR_SURFACE_FITTING
			////_check_ask_custom_book_sheet_name(trRootNode, trData.Sheet, str2ndPart, strCurveBook, true, nDBTY, WKS_DATA_SHEET); 
			/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
			////_check_ask_custom_book_sheet_name(trRootNode, trData.Sheet, str2ndPart, strCurveBook, true, nDBTY, WKS_DATA_SHEET, IDE_RESULT_CURVE_SHEET); 
			/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
			////FUNC_CHECK_ASK_CUSTOM_BOOK_SHEET_NAME pfn = Project.FindFunction("check_ask_custom_book_sheet_name", "OriginLab\\Event_utils", true);
			////if(pfn)
			////	pfn(trRootNode, trData.Sheet, str2ndPart, strCurveBook, true, nDBTY, WKS_DATA_SHEET, IDE_RESULT_CURVE_SHEET); 
			/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
			////check_ask_custom_book_sheet_name(trRootNode, trData.Sheet, str2ndPart, strCurveBook, true, nDBTY, WKS_DATA_SHEET, IDE_RESULT_CURVE_SHEET); 
			//check_ask_custom_book_sheet_name(trRootNode, trData.Sheet, str2ndPart, strCurveBook, true, nDBTY, WKS_DATA_SHEET, IDE_RESULT_CURVE_SHEET, bIsNLFitOutputEvent); 
			/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
			/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
			/////end FILTER_EXISTING_FOR_SURFACE_FITTING
			/////end CAN_DECIDE_TO_DATA_SHEET_OR_REPORT_SHEET_OR_ALL
			//
			/////Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH  
			//string strSheet = trData.Sheet.strVal;
			/////---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
			////if(!strSheet.CompareNoCase(STR_CUSTOM + STR_THREE_DOTS))
			//if ( compare_string_localization(strSheet, STR_CUSTOM_E + STR_THREE_DOTS, true) )
			/////---END CLEAN_LOCALIZATION_CODE
				//trData.Sheet.strVal = STR_NEW;
			/////End MODIFICATION_OUTPUT_BRANCH
			//break;
		//default:
			//break;
		//}
	//}	
	//else
		//error_report("trGUI.Output.Data or trGUI.Data missing");
	//
	//return true;		
	OutputGUIManagerBase*	pOutputGUIObj = get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnCurveSheetChanged(tr, trNode, nRow);
	return false;
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
}	
///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH 
//bool operation_output_book_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
bool operation_output_residual_book_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//bool bIsNLFitOutputEvent = _is_nlfit_output_event(tr);
	//TreeNode trGUI = _get_GUI_tree(tr);
	/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	//
	/////Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
	////can not get right node by this way, very strange
	////TreeNode trCurrent = tree_get_node(tr, nRow).Parent();
	//TreeNode trCurrent = tr.Output.Residual;
	/////end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
	//if(!trCurrent)
		//return error_report("TreeNode missing");
	//
	//string strCombo = STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
	//string strBook = trCurrent.Book.strVal, str2ndPart;
	//int nBookType = str_to_predefined_type(strBook, str2ndPart);		
	//bool	bSheetEnable = true;
	//switch(nBookType)
	//{
	///// Iris 02/01/2007 SAME_DESIGN_WITH_OUTPUT_RESIDUALS_TO
	///*
	//case PDS_SOURCE:
		//strCombo = STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		//trCurrent.Sheet.strVal = STR_SOURCE_BOOK;
		//break;
	//case PDS_FIT_CURVE:
		//strCombo = STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW;
		//trCurrent.Sheet.strVal = STR_FIT_CURVE;
		//break;
	//case PDS_REPORT:
	//*/
	//case PDS_FIT_CURVE:
		//strCombo = STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW;
		//break;
	//case PDS_NEW:
		//trCurrent.Sheet.strVal = STR_NEW;
		//bSheetEnable = false;
		//break;
	//case PDS_CUSTOM:
		//bool bIsCustom = (PDS_CUSTOM == str_to_predefined_type(strBook, str2ndPart))? true:false;
		/////Arvin 04/30/07 v8.0610 FILTER_EXISTING_FOR_SURFACE_FITTING
		////_check_ask_custom_book_sheet_name(tr, trCurrent.Book, str2ndPart, strBook, false);
		/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		////_check_ask_custom_book_sheet_name(tr, trCurrent.Book, str2ndPart, strBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_RESIDUAL_CURVE_BOOK);
		/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
		////FUNC_CHECK_ASK_CUSTOM_BOOK_SHEET_NAME pfn = Project.FindFunction("check_ask_custom_book_sheet_name", "OriginLab\\Event_utils", true);
		////if(pfn)
		////	pfn(tr, trCurrent.Book, str2ndPart, strBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_RESIDUAL_CURVE_BOOK);
		/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		////check_ask_custom_book_sheet_name(tr, trCurrent.Book, str2ndPart, strBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_RESIDUAL_CURVE_BOOK);
		//check_ask_custom_book_sheet_name(trGUI, trCurrent.Book, str2ndPart, strBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_RESIDUAL_CURVE_BOOK, bIsNLFitOutputEvent);
		/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		/////end FILTER_EXISTING_FOR_SURFACE_FITTING
		////check existing data sheet
		//Page pg( trCurrent.Book.strVal.GetToken(1,'>') );
		//if(!pg)
		//{//select default value
			//trCurrent.Book.strVal = STR_FIT_CURVE;
			//strCombo = STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW;
			//trCurrent.Sheet.strVal = STR_FIT_CURVE;
		//}
		//else
		//{
			//trCurrent.Sheet.strVal = STR_NEW;
			/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
			////if(!lstrlen( get_sheets_in_book(pg, WKS_DATA_SHEET) ))
			////	bSheetEnable = false;
			/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
			////FUNC_GET_SHEETS_IN_BOOK pfn = Project.FindFunction("get_sheets_in_book", "OriginLab\\Event_utils", true);
			////string strtemp;
			////if(pfn)
			////	strtemp = pfn(pg, WKS_DATA_SHEET);
			//string strtemp = get_sheets_in_book(pg, WKS_DATA_SHEET);			
			/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			//if(!lstrlen( strtemp) )
				//bSheetEnable = false;
			/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		//}
		//break;
	/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	//case PDS_REPORT:
		//strCombo = STR_NEW + STR_TOKEN_SEP;
		//trCurrent.Sheet.strVal = STR_NEW;
		//break;
	/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	//default:
		//break;
	//}
	/////Cheney 2007-11-7 10536 p14-p16 FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
	//int nOutputType = 0;
	//TreeNode trFittedCurve = tr.Output.Data;
	///// Iris 3/15/2008 QA80-11244 SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING
	////if( trFittedCurve && trFittedCurve.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType) && nOutputType > OPERATION_OUTPUT_GENERAL )
	//if( trFittedCurve && trFittedCurve.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType) && nOutputType > OPERATION_OUTPUT_XYZ_FITTING )	
	/////end SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING
	/////Cheney 2007-11-9 QA70-10536 FIX_SOME_NEW_BUGS_OF_OUTPUT_DESTNATION
		////remove_str_from_str_list(STR_FIT_CURVE, strCombo);
	//{
		//remove_str_from_str_list(STR_FIT_CURVE, strCombo);
		//remove_str_from_str_list(STR_CUSTOM + STR_THREE_DOTS, strCombo);
	//}
	/////end FIX_SOME_NEW_BUGS_OF_OUTPUT_DESTNATION
	/////end FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
	//trCurrent.Sheet.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	//if(trCurrent.Book.Enable) //Iris 02/05/2007 click Change Parameter to open dialog, Book and Sheet both should disabled.
		//trCurrent.Sheet.Enable = bSheetEnable;	
	FitOutputGUIManager*	pOutputGUIObj = (FitOutputGUIManager*)get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnResidualBookChanged(tr);
	return false;

	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
}

///Sophy 5/28/2008 QA80-10934-P8 FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
bool operation_output_partialcurves_book_event( TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	MROutputGUIManager*	pOutputGUIObj = (MROutputGUIManager*)get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnPartialCurvesBookChanged(tr);
	return false;
}
///end FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE

///Arvin 04/30/07 v8.0610 FILTER_EXISTING_FOR_SURFACE_FITTING
bool operation_output_residual_sheet_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//bool bIsNLFitOutputEvent = _is_nlfit_output_event(tr);
	//TreeNode trGUI = _get_GUI_tree(tr);
	/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	//
	/////Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
	////can not get right node by this way, very strange
	////TreeNode trCurrentSheet = tree_get_node(tr, nRow);
	//TreeNode trCurrentSheet = tr.Output.Residual.Sheet;
	/////end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
	//if(!trCurrentSheet)
		//return error_report("TreeNode missing");
	//string 	strReportBook = trCurrentSheet.Parent().Book.strVal;
	//string 	strReportSheet = trCurrentSheet.strVal, str2ndPart;	
	//int nSheetType = str_to_predefined_type(strReportSheet, str2ndPart);		
	//switch(nSheetType)
	//{
	//case PDS_CUSTOM:		
		////_check_ask_custom_book_sheet_name(tr, trCurrentSheet, str2ndPart, strReportBook, true, DBTY_X_FUNC_VAR);//DBTY_X_FUNC_VAR for no report sheet
		/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		////_check_ask_custom_book_sheet_name(tr, trCurrentSheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, WKS_DATA_SHEET, IDE_RESIDUAL_CURVE_SHEET);
		/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
		////FUNC_CHECK_ASK_CUSTOM_BOOK_SHEET_NAME pfn = Project.FindFunction("check_ask_custom_book_sheet_name", "OriginLab\\Event_utils", true);
		////if(pfn)
		////	pfn(tr, trCurrentSheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, WKS_DATA_SHEET, IDE_RESIDUAL_CURVE_SHEET);
		/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		////check_ask_custom_book_sheet_name(tr, trCurrentSheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, WKS_DATA_SHEET, IDE_RESIDUAL_CURVE_SHEET);
		//check_ask_custom_book_sheet_name(trGUI, trCurrentSheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, WKS_DATA_SHEET, IDE_RESIDUAL_CURVE_SHEET, bIsNLFitOutputEvent);
		/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		//string strSheet = trCurrentSheet.strVal;
		/////---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
		////if(!strSheet.CompareNoCase(STR_CUSTOM + STR_THREE_DOTS))
		//if ( compare_string_localization(strSheet, STR_CUSTOM_E + STR_THREE_DOTS, true) )
		/////---END CLEAN_LOCALIZATION_CODE
			//trCurrentSheet.strVal = STR_NEW;
		//break;
	//}	
	//return true;
	FitOutputGUIManager*	pOutputGUIObj = (FitOutputGUIManager*)get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnResidualSheetChanged(tr);	
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	
}
///end FILTER_EXISTING_FOR_SURFACE_FITTING

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
bool operation_output_findxy_branch_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	/*
	TreeNode trCalibration =  tree_get_node_by_tagname(tr, "Calibration", true);
	if(!trCalibration)
	{
		TreeNode trRoot = tr.Parent();
		if(trRoot)
			trCalibration =  tree_get_node_by_tagname(trRoot, "Calibration", true);
	}
	
	if(!trCalibration)
		return false;
	
	TreeNode trFindXYOutput = tree_get_node(tr, nRow);
	if(!trFindXYOutput)
		return false;
	
	TreeNode trBranch1 = trCalibration.Custom2;
	TreeNode trBranch2 = trCalibration.Custom3;

	//When current operation is "Find Z from X Y", trBranch1 and trBranch2 are NULL,
	//trCalibration has not sub-branch trBranch1 and trBranch2.  
	if(!trBranch1 && !trBranch2)
	{
		if(trCalibration.Use && trFindXYOutput)
		{
			trFindXYOutput.Enable = true;
			trFindXYOutput.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
		}
		else
		{
			trFindXYOutput.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_KEEP_SIZE_ON_COLLAPSE);
			trFindXYOutput.Enable = false;	
		}
		return true;
	}

	if(trBranch1.Use + trBranch2.Use && trFindXYOutput)
	{
		trFindXYOutput.Enable = true;
		trFindXYOutput.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
	}
	if(!(trBranch1.Use + trBranch2.Use) && trFindXYOutput)
	{
		trFindXYOutput.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_KEEP_SIZE_ON_COLLAPSE);
		trFindXYOutput.Enable = false;
	}
	return true;
	*/
	//return m_outputManager.OnFindXYBranchChanged(tr, nRow);
	FitOutputGUIManager*	pOutputGUIObj = (FitOutputGUIManager*)get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnFindXYBranchChanged(tr, nRow);
	return false;
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
}
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL

/// Iris 02/01/2007 SAME_DESIGN_WITH_OUTPUT_RESIDUALS_TO
bool operation_output_findxy_book_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//bool bIsNLFitOutputEvent = _is_nlfit_output_event(tr);
	//TreeNode trGUI = _get_GUI_tree(tr);
	/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	//
	/////Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
	////can not get right node by this way, very strange
	////TreeNode trCurrent = tree_get_node(tr, nRow).Parent();
	//TreeNode trCurrent = tr.Output.FindXY;
	/////end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
	//if(!trCurrent)
		//return error_report("TreeNode missing");	
	//string 	strBook = trCurrent.Book.strVal, str2ndPart;
	//int 	nBookType = str_to_predefined_type(strBook, str2ndPart);
	//
	//switch(nBookType)
	//{
	//case PDS_CUSTOM:
		//bool bIsCustom = (PDS_CUSTOM == str_to_predefined_type(strBook, str2ndPart))? true:false;
		/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		////_check_ask_custom_book_sheet_name(tr, trCurrent.Book, str2ndPart, strBook, false);
		/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
		////FUNC_CHECK_ASK_CUSTOM_BOOK_SHEET_NAME pfn = Project.FindFunction("check_ask_custom_book_sheet_name", "OriginLab\\Event_utils", true);
		////if(pfn)
		////	pfn(tr, trCurrent.Book, str2ndPart, strBook, false);
		/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		////check_ask_custom_book_sheet_name(tr, trCurrent.Book, str2ndPart, strBook, false);
		//check_ask_custom_book_sheet_name(trGUI, trCurrent.Book, str2ndPart, strBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, 0, bIsNLFitOutputEvent);
		/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		////check existing data sheet
		//Page pg( trCurrent.Book.strVal.GetToken(1,'>') );
		//if(!pg)
			//trCurrent.Book.strVal = STR_FIT_CURVE;//select default value
		//break;
	//case PDS_SOURCE:
	//case PDS_FIT_CURVE:
	//case PDS_REPORT:
		//trCurrent.Sheet.Enable = true;
		//break;
	//case PDS_NEW:
		//trCurrent.Sheet.strVal = STR_NEW;
		//trCurrent.Sheet.Enable = false;
		//break;
	//default:
		//break;
	//}
	//return true;	
	//return m_outputManager.OnFindXYBookChanged(tr);
	FitOutputGUIManager*	pOutputGUIObj = (FitOutputGUIManager*)get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnFindXYBookChanged(tr);
	return false;
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS	
}
///end SAME_DESIGN_WITH_OUTPUT_RESIDUALS_TO
///Sophy 5/28/2008 QA80-10934-P8 FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
//bool operation_output_sheet_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
bool operation_output_findxy_sheet_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
///end FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
{
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//bool bIsNLFitOutputEvent = _is_nlfit_output_event(tr);
	//TreeNode trGUI = _get_GUI_tree(tr);
	/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	//
	/////Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
	////can not get right node by this way, very strange
	////TreeNode trCurrentSheet = tree_get_node(tr, nRow);
	//TreeNode trCurrentSheet = tr.Output.FindXY.Sheet;
	/////end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
	//if(!trCurrentSheet)
		//return error_report("TreeNode missing");
	//string 	strReportBook = trCurrentSheet.Parent().Book.strVal;
	//string 	strReportSheet = trCurrentSheet.strVal, str2ndPart;	
	//int nSheetType = str_to_predefined_type(strReportSheet, str2ndPart);		
	//switch(nSheetType)
	//{
	//case PDS_CUSTOM:		
		////_check_ask_custom_book_sheet_name(tr, trCurrentSheet, str2ndPart, strReportBook, true, DBTY_X_FUNC_VAR);//DBTY_X_FUNC_VAR for no report sheet
		/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		////_check_ask_custom_book_sheet_name(tr, trCurrentSheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, WKS_DATA_SHEET);
		/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
		////FUNC_CHECK_ASK_CUSTOM_BOOK_SHEET_NAME pfn = Project.FindFunction("check_ask_custom_book_sheet_name", "OriginLab\\Event_utils", true);
		////if(pfn)
		////	pfn(tr, trCurrentSheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, WKS_DATA_SHEET);
		/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		////check_ask_custom_book_sheet_name(tr, trCurrentSheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, WKS_DATA_SHEET);
		//check_ask_custom_book_sheet_name(trGUI, trCurrentSheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, WKS_DATA_SHEET, 0, bIsNLFitOutputEvent);
		/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		//string strSheet = trCurrentSheet.strVal;
		/////---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
		////if(!strSheet.CompareNoCase(STR_CUSTOM + STR_THREE_DOTS))
		//if ( compare_string_localization(strSheet, STR_CUSTOM_E + STR_THREE_DOTS, true) )
		/////---END CLEAN_LOCALIZATION_CODE
			//trCurrentSheet.strVal = STR_NEW;
		//break;
	//}	
	//return true;
	//return m_outputManager.OnFindXYSheetChanged(tr);
	FitOutputGUIManager*	pOutputGUIObj = (FitOutputGUIManager*)get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnFindXYSheetChanged(tr);
	return false;
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS	
}
///End MODIFICATION_OUTPUT_BRANCH
///Sophy 5/28/2008 QA80-10934-P8 FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
bool operation_output_partialcurves_sheet_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	MROutputGUIManager*	pOutputGUIObj = (MROutputGUIManager*)get_output_GUI_manager_pointer(tr);
	if( NULL != pOutputGUIObj)
		return pOutputGUIObj->OnPartialCurvesSheetChanged(tr);
	return false;
}
///end FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE

///Joe 8/28/06  MOVE_GET_X_FROM_Y_OR_GET_Y_FROM_X_TO_CALIBRATION
//bool operation_report_calibration_table_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	/////
	////TreeNode trCalibration = tr.Output.Report.Create.Calibration;
	//TreeNode trCalibration = op_get_optional_tables(tr).Calibration;
	//if(!trCalibration)
		//return false;
	//
	//int 	nSel = trCalibration.For.nVal;
	//bool 	bIsVal = false;
	//if(0 == nSel)
	//{
		//bIsVal = true;
	//}
	//
	//trCalibration.Values.Enable = bIsVal;
	//trCalibration.Start.Enable = !bIsVal;
	//trCalibration.Stop.Enable = !bIsVal;
	//trCalibration.Step.Enable = !bIsVal;		
//
	//return true;	
//}
///End MOVE_GET_X_FROM_Y_OR_GET_Y_FROM_X_TO_CALIBRATION
//------ CPY 12/13/04 KEEP_SESSION_TEMP_GRAPH_WHEN_FIT_FROM_WKS
// this should not be decided on construct, as any such assumption construct about page etc is not reliable
/*
void _addSourceGraphCheckBox(TreeNode& trGUI)
{
	TreeNode trOutput = trGUI.Output;
	if(!trOutput)
		return;
	
	GETN_USE(trOutput)
	
	GETN_CHECK(SourceGraph, _L("Output to Source"), true)
	Layer layer = Project.ActiveLayer();
	if(layer)
		trGUI.Output.SourceGraph.Enable = 0;//= EXIST_WKS == layer.GetPage().GetType()? 1:0;
}
*/





/// ML 6/27/2005 STYLE_LINKS_WITH_OFFSETS
static	TreeNode	get_custom_table_themes(TreeNode& trGUI)
{
	TreeNode		tr = trGUI.Output.Create.Custom1;
	if (!tr)
		return tr;
	
	tr = tr.Theme;
	
	return tr;
}

static	void	make_reporttable_classname(string &strClassName, TreeNode& trGUI, int nTableId)
{
	string			strBaseName;	
	bool			bHasClassOption = theme_get_class_option(trGUI, strBaseName);
	ASSERT(bHasClassOption);
	strClassName.Format("%s__%d", strBaseName, nTableId);
}

static	bool operation_output_report_custom_table_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	/// ML 4/28/2006 FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
	/*
	TreeNode		trCustomTableThemes = get_custom_table_themes(tr);
	if (!trCustomTableThemes)
		return true;

	string			strCombo;
	trCustomTableThemes.GetAttribute(STR_COMBO_ATTRIB, strCombo);
	if (!strCombo.IsEmpty())
		return true;
	
	vector<string>	vstrCustomTableThemes;
	vector<string>	vsFilenames;
	

	//////////////////////////////////////////////////////////////////////////////////////
	string			strThClassName;
	make_reporttable_classname(strThClassName, tr, IDST_REPORT_CUSTOM_TABLE1);
	
	int				iThemes = okutil_theme_get_class_settings(strThClassName, &vsFilenames, &vstrCustomTableThemes, THTYPE_REPORT_TABLE, true, false);
	strCombo.SetTokens(vstrCustomTableThemes, '|');
	//////////////////////////////////////////////////////////////////////////////////////

	string			strDefault;
	if (0 < vstrCustomTableThemes.GetSize())
		strDefault = vstrCustomTableThemes[0];
	
	trCustomTableThemes.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	trCustomTableThemes.strVal = strDefault;
	*/
	/// end FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
	
	return true;
}
/// end STYLE_LINKS_WITH_OFFSETS

/// Iris 8/16/05 QA70-7889 CONTROL_IF_ADD_RESULT_TABLE
static	bool operation_output_keep_session_graph_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trKeepGraph = tr.Output.KeepSessionGraph;
	///Sophy 1/23/2009 v8.0964b CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
	//TreeNode trPasteResultTable = tr.Output.PasteResultTable;
	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trPasteResultTable = tr.Output.PlotSettings.PasteResultTable;
	TreeNode trPasteResultTable = OP_GUI_GRAPH_ARRANGEMENT_NODE(tr).PasteResultTable;
	///end OP_DLG_NEW_STRUCTURE	
	///end CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
	if(!trPasteResultTable)
		return false;
	
	/// Iris 8/25/05 SHOW_PASTE_RESULT_TABLE_BOX_IN_LR_PR, in LR and PR, there is no Keep Session Graph checkbox
	//if(!trKeepGraph || !trKeepGraph.Show)
	//{
		//trPasteResultTable.Show = false;
		//trPasteResultTable.nVal = 0;
		//return true;
	//}
	//else
		//trPasteResultTable.Show = true;
	if(!trKeepGraph || !trKeepGraph.Show)
		return false;		
	///End SHOW_PASTE_RESULT_TABLE_BOX_IN_LR_PR
	
	if(!trKeepGraph.nVal)
	{
		trPasteResultTable.Enable = false;
		trPasteResultTable.nVal = 0;		
	}
	else
		trPasteResultTable.Enable = true;
		
	return true;
}
///end CONTROL_IF_ADD_RESULT_TABLE

/// ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
static	void	tree_construct_gui_custom_table_branch(TreeNode &trTbl, int nRows, int nCols, bool bThemeName, bool bTableLabel, LPCSTR lpcz = NULL)
{
	GETN_USE(trTbl)
	/// Iris 9/11/06 QA70-8926-5 v8.0478 REMOVE_1_FROM_CUSTOM_TABLE_ROW_COL_NUM
	//GETN_COMBO(Rows, "Number of Rows", nRows, "|1|2|3|4|5|6|7|8|9") GETN_ID(IDE_REPORT_CUSTOM_TABLE_ROWS) GETN_OPTION_NUM_FORMAT( "%d" )
	//GETN_COMBO(Cols, "Number of Columns", nCols, "|1|2|3|4|5|6|7|8|9") GETN_ID(IDE_REPORT_CUSTOM_TABLE_COLS) GETN_OPTION_NUM_FORMAT( "%d" )
	GETN_COMBO(Rows, _L("Number of Rows"), nRows, "|2|3|4|5|6|7|8|9") GETN_ID(IDE_REPORT_CUSTOM_TABLE_ROWS) GETN_OPTION_NUM_FORMAT( "%d" )
	GETN_COMBO(Cols, _L("Number of Columns"), nCols, "|2|3|4|5|6|7|8|9") GETN_ID(IDE_REPORT_CUSTOM_TABLE_COLS) GETN_OPTION_NUM_FORMAT( "%d" )
	///End REMOVE_1_FROM_CUSTOM_TABLE_ROW_COL_NUM
	
	if ( bThemeName )
	{
		GETN_STR(Theme, _L("Theme"), "") GETN_ID(IDST_REPORT_CUSTOM_TABLE_THEME)
	}
	
	///Joseph 09/27/06 FINDXY_TO_SEPERATE_SHEET
	//if ( bTableLabel )
	//{
		//GETN_STR(TblTitle, _L("Table title"), lpcz) GETN_ID(IDE_REPORT_CUSTOM_TABLE_TITLE)
	//}
	///End FINDXY_TO_SEPERATE_SHEET
}
/// end CUSTOM_TABLES_FOR_FIND_XY

// if nReportBranchID > 0, then we assume it will be used to Save Settings as well
//void tree_construct_add_report_branch(TreeNode& trGUI, DWORD dwOptions, int nReportBranchID, int nCurveBranchID, int nGraphNum)
///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH, add FindXY output branch 
//static void _tree_construct_add_report_branch(TreeNode& trGUI, DWORD dwOptions, int nReportBranchID, int nCurveBranchID, int nResidualBranchID, int nGraphNum)
static void _tree_construct_add_report_branch(TreeNode& trGUI, DWORD dwOptions, int nReportBranchID, int nCurveBranchID, int nResidualBranchID, int nPartialBranchID, int nFinXYBranchID, int nGraphNum)
///End MODIFICATION_OUTPUT_BRANCH
{	
	GETN_USE(trGUI)
	
	GETN_BEGIN_BRANCH(Output, STR_OUTPUT_BRANCH)
		if(nReportBranchID)
		{
			GETN_ID_BRANCH(nReportBranchID) GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS)
		}
		if(dwOptions & REPORT_KEEP_SESSION_GRAPH)
		{
			///Iris 6/06/05 move it to fitted curve options table
			//GETN_CHECK(Formula, _L("Paste Formula to Graph"), true) GETN_ID(IDE_PASTE_FORMULA_TO_GRAPH) 

			/// Iris 5/11/06 CANCEL_FIT_PREVIEW_GRAPH
			//GETN_CHECK(KeepSessionGraph, _L("Keep Session Graph"), false) GETN_ID(IDE_KEEP_SESSION_GRAPH)  GETN_CURRENT_SUBNODE.Show = false;  GETN_OPTION_EVENT(operation_output_keep_session_graph_event)
		}
		
		/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
		/*
		/// Iris 8/16/05 QA70-7889 CONTROL_IF_ADD_RESULT_TABLE
		if(dwOptions & REPORT_PASTE_RESULT_TABLES_TO_GRAPH)
		{
			GETN_CHECK(PasteResultTable, _L("Paste Result Tables to Graph"), true) GETN_ID(IDE_PASTE_RESULT_TABLES_TO_GRAPH)
			/// ML 8/10/2006 REMOVING_CUSTOM_TABLE_FROM_GUI
			GETN_STR(ThemeRsltTable, _L("Graph Table Theme"), "") GETN_ID(IDST_THEME_FOR_TABLE_IN_GRAPH)
			/// end REMOVING_CUSTOM_TABLE_FROM_GUI
		}
		///end CONTROL_IF_ADD_RESULT_TABLE
		
		/// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT
		if(0 != nGraphNum)
		{
			GETN_COMBO(GraphNumCols, _L("Arrange Graphs into Columns"), 1, "|1|2|3|4|5|6|7|8|9") 
		}
		///end REPORT_GRAPHS_ARRANGEMENT
		*/
#ifdef OP_DLG_TOTALLY_NEW_STRUCTURE
		GETN_CHECK(AddReportToResultsLog, _L("Results Log"), false) GETN_ID(IDE_REPORT_ADD_TO_RESULTS_LOG)
		GETN_CHECK(DumpScriptWindow, _L("Script Window"), false) GETN_ID(IDE_REPORT_DUMP_SCRIPTWIN)
		GETN_STR(DumpNotesWindow, _L("Notes Window"), STR_NONE) GETN_ID(IDE_REPORT_DUMP_NOTESWIN)
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE
			
#ifndef OP_DLG_TOTALLY_NEW_STRUCTURE
		/// Max 6/4/08 v8.0877 THIS_BRANCH_SHOULD_CLOSE_BY_DEFAULT
		//GETN_BEGIN_BRANCH(PlotSettings, STR_OUTPUT_GRAPH_ARRANGMENT) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_BEGIN_BRANCH(PlotSettings, STR_OUTPUT_GRAPH_ARRANGMENT)
		/// END THIS_BRANCH_SHOULD_CLOSE_BY_DEFAULT
		///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
			if(dwOptions & REPORT_PASTE_RESULT_TABLES_TO_GRAPH)
			{
				///Cheney 2007-8-31 QA70-10330 CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
				//GETN_CHECK(PasteResultTable, _L("Paste Result Tables to Graph"), true) GETN_ID(IDE_PASTE_RESULT_TABLES_TO_GRAPH)
				GETN_BEGIN_BRANCH(PasteResultTable, _L("Paste Result Tables to Source Graph") ) GETN_CHECKBOX_BRANCH(1) GETN_ID(IDE_PASTE_RESULT_TABLES_TO_GRAPH)
				///end CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
				//-------------------- CPY 5/2/07 QA70-9687 TEMPLATE_FOR_TABLE_INSERT_TO_GRAPH
				GETN_STR(TableTemplate, _L("Template to Create Table"), "") GETN_ID(IDE_REOPRT_TABLE_TEMPLATE)
				//--------------------
				GETN_STR(ThemeRsltTable, _L("Graph Table Theme"), "") GETN_ID(IDST_THEME_FOR_TABLE_IN_GRAPH)
				GETN_END_BRANCH(PasteResultTable)	///Cheney 2007-8-31 QA70-10330 CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
			}
			if(dwOptions & REPORT_ARRANGE_GRAPHS_TO_COLS)
			{
				///Cheney 2007-8-31 QA70-10330 CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
				//GETN_COMBO(GraphNumCols, _L("Arrange Graphs into Columns"), 1, "|1|2|3|4|5|6|7|8|9")  GETN_ID(IDE_REPORT_GRAPH_NUM_COLS)
				GETN_NUM(GraphNumCols, _L("Arrange Graphs into Columns"), 1) GETN_ID(IDE_REPORT_GRAPH_NUM_COLS)
				TreeNode trGraphNumCols = trGUI.Output.PlotSettings.GraphNumCols;
				if(trGraphNumCols)
					octree_set_auto_support(&trGraphNumCols);
				///end CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
			}
			if(dwOptions & REPORT_PLOT_ALL_PLOTS_IN_ONE_GRAPH)
			{
				///Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
				//GETN_CHECK(PlotInOneGraph, _L("Plot All Plots in One Graph"), 0) 	GETN_ID(IDE_REPORT_PLOTS_IN_ONE_GRAPH)
				GETN_CHECK(PlotInOneGraph, _L("Arrange Plots of Same Type in One Graph"), 0) 	GETN_ID(IDE_REPORT_PLOTS_IN_ONE_GRAPH)
				///end SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
			}
		*/
		tree_construct_add_plot_settings(_tmpSubNode, dwOptions);
		///end OP_DLG_NEW_STRUCTURE
		GETN_END_BRANCH(PlotSettings)
		if(trGUI.Output.PlotSettings.GetNodeCount() == 0)
			trGUI.Output.PlotSettings.Remove();
		///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE

		
		/// Iris 01/19/2007 v8.0544 OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT
		if(dwOptions & REPORT_RESULT_CURVE_OPTION)
		{
			///Sophy 4/15/2008 FITTED_RESULTS_SHEET_ARRANGEMENT_CHANGED
			//GETN_LIST(RCSheet, _L("Fitted Results Sheet Arrangement"), 0, _L("Combined|Separate")) GETN_ID(IDST_SEPARATE_RESULT_CURVE_SHEET)
			GETN_LIST(RCSheet, _L("Fitted Results Sheet Arrangement"), 0, _L("Combined|Separate")) GETN_ID(IDST_SEPARATE_RESULT_CURVE_SHEET) GETN_OPTION_EVENT(operation_output_fitted_results_sheet_arrangement_event)
			///end FITTED_RESULTS_SHEET_ARRANGEMENT_CHANGED
		}
		///end OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT
		
		///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		GETN_BEGIN_BRANCH(Report, STR_OUTPUT_REPORT_TABLES) GETN_ID_BRANCH(IDST_REPORT_SHEET_OPTIONS) GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS)
			#ifdef OP_DLG_TOTALLY_NEW_STRUCTURE
				GETN_CHECKBOX_BRANCH(1)
			#endif //OP_DLG_TOTALLY_NEW_STRUCTURE
		
			GETN_STRLIST(Book, _L("Book"), _L(""),  _L("")) GETN_ID(IDE_REOPRT_BOOK) GETN_OPTION_EVENT(operation_output_report_book_event)			
			///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
			//GETN_STR(BookName, _L("BookName"), _L("")) GETN_ID(IDE_REOPRT_BOOK_NAME) GETN_OPTION_EVENT_EX(operation_output_book_sheet_name_changed)/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
			GETN_STR(BookName, _L("BookName"), _L("")) GETN_ID(IDE_REOPRT_BOOK_NAME) GETN_OPTION_EVENT_EX(operation_output_report_book_name_changed)/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
			///end UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
			GETN_STR(NameForNew, _L(""), _L("")) GETN_ID(IDE_REOPRT_BOOK_OLD_NAME) GETN_CURRENT_SUBNODE.Show = false;
			
			GETN_STRLIST(Sheet, _L("Sheet"),  _L(""),  _L("")) GETN_ID(IDE_REPORT_SHEET) GETN_OPTION_EVENT(operation_output_report_sheet_event)  ///Iris 11/12/04 QA70-7139 ADD_CUSTOM_OPTION_TO_REPORT					
			GETN_STR(SheetName, _L("SheetName"), _L("")) GETN_ID(IDE_REPORT_SHEET_NAME)	GETN_OPTION_EVENT_EX(operation_output_book_sheet_name_changed)/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
			GETN_STR(NameForNew, _L(""), _L("")) GETN_ID(IDE_REOPRT_SHEET_OLD_NAME) GETN_CURRENT_SUBNODE.Show = false;
			
#ifndef OP_DLG_TOTALLY_NEW_STRUCTURE
			GETN_CHECK(AddReportToResultsLog, _L("Results Log"), false) GETN_ID(IDE_REPORT_ADD_TO_RESULTS_LOG)
			GETN_CHECK(DumpScriptWindow, _L("Script Window"), false) GETN_ID(IDE_REPORT_DUMP_SCRIPTWIN)
			GETN_STR(DumpNotesWindow, _L("Notes Window"), STR_NONE) GETN_ID(IDE_REPORT_DUMP_NOTESWIN)
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE
		GETN_END_BRANCH(Report)
		///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		
		if(nCurveBranchID)
		{
			okutil_vars_tree_construct_add_create_data_branch(&_tmpNode, DBTY_CURVE_OUTPUT, nCurveBranchID);
			///Alex 06/13/06 SET_RESULT_CURVES_BRANCH_OPEN
			///default GUI:Result Curves branch should open
			GETN_BEGIN_USE_BRANCH(Data)
				/// Max 6/4/08 v8.0877 THIS_BRANCH_SHOULD_CLOSE_BY_DEFAULT
				//GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS | GETNBRANCH_OPEN)
				GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS)
				/// END THIS_BRANCH_SHOULD_CLOSE_BY_DEFAULT
			GETN_END_USE_BRANCH(Data)
			//End SET_RESULT_CURVES_BRANCH_OPEN	
			
			/// Iris 5/30/2008 CENTRALIZE_SET_RESULT_CURVE_BRANCH_NAME_CODES
			//_tmpNode.Data.SetAttribute(STR_LABEL_ATTRIB, STR_OUTPUT_FIT_RESULT_CURVE_TABLES);  /// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
			///end CENTRALIZE_SET_RESULT_CURVE_BRANCH_NAME_CODES
		}
		
		/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
		if(nResidualBranchID)
		{
			GETN_BEGIN_BRANCH(Residual, STR_OUTPUT_RESIDUAL_CURVES_TABLES) GETN_ID_BRANCH(nResidualBranchID)				
				///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
				/*
				GETN_STRLIST(Book, _L("Output to Report Book"), _L("<new>"),  _L("<fittedcurve>|<new>|<existing...>")) GETN_ID(IDE_RESIDUAL_CURVE_BOOK)
				GETN_STRLIST(Sheet, _L("Output to Report Sheet"), _L("<new>"),  _L("<new>|<existing...>")) GETN_ID(IDE_RESIDUAL_CURVE_SHEET)
				*/
				GETN_STRLIST(Book, _L("Book"), STR_FIT_CURVE,  STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS) GETN_ID(IDE_RESIDUAL_CURVE_BOOK) GETN_OPTION_EVENT(operation_output_residual_book_event)
				GETN_STR(BookName, _L("BookName"), _L("")) GETN_ID(IDE_RESIDUAL_CURVE_BOOK_NAME) GETN_OPTION_EVENT_EX(operation_output_book_sheet_name_changed)/// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
				GETN_STR(NameForNew, _L(""), _L("")) GETN_ID(IDE_RESIDUAL_CURVE_BOOK_OLD_NAME) GETN_CURRENT_SUBNODE.Show = false;
				
				//GETN_STRLIST(Sheet, _L("Sheet"), STR_FIT_CURVE,  STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS) GETN_ID(IDE_RESIDUAL_CURVE_SHEET) GETN_OPTION_EVENT(operation_output_sheet_event)
				///Arvin 04/30/07 v8.0610 FILTER_EXISTING_FOR_SURFACE_FITTING
				//GETN_STRLIST(Sheet, _L("Sheet"), STR_FIT_CURVE,  STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW) GETN_ID(IDE_RESIDUAL_CURVE_SHEET) GETN_OPTION_EVENT(operation_output_sheet_event)
				///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
				//GETN_STRLIST(Sheet, _L("Sheet"), STR_FIT_CURVE,  STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW) GETN_ID(IDE_RESIDUAL_CURVE_SHEET) GETN_OPTION_EVENT(operation_output_residual_sheet_event)
				GETN_STRLIST(Sheet, _L("Sheet"), STR_FIT_CURVE,  STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS) GETN_ID(IDE_RESIDUAL_CURVE_SHEET) GETN_OPTION_EVENT(operation_output_residual_sheet_event)
				///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
				///end FILTER_EXISTING_FOR_SURFACE_FITTING
				///End MODIFICATION_OUTPUT_BRANCH
				GETN_STR(SheetName, _L("SheetName"), _L("")) GETN_ID(IDE_RESIDUAL_CURVE_SHEET_NAME) GETN_OPTION_EVENT_EX(operation_output_book_sheet_name_changed)/// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
				GETN_STR(NameForNew, _L(""), _L("")) GETN_ID(IDE_RESIDUAL_CURVE_SHEET_OLD_NAME) GETN_CURRENT_SUBNODE.Show = false;
			GETN_END_BRANCH(Residual)
		}
		///end REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
		
		if(nPartialBranchID)
		{
			GETN_BEGIN_BRANCH(PartialCurves, STR_OUTPUT_MR_PARTIAL_LEVERAGE_CURVE_TABLES) GETN_ID_BRANCH(IDST_PARTIAL_CURVE_OPTIONS)
				///Sophy 5/28/2008 QA80-10934-P8 FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
				//GETN_STRLIST(Book, _L("Book"), STR_FIT_CURVE,  STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS) GETN_ID(IDE_PARTIAL_CURVE_BOOK) GETN_OPTION_EVENT(operation_output_residual_book_event)
				GETN_STRLIST(Book, _L("Book"), STR_FIT_CURVE,  STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS) GETN_ID(IDE_PARTIAL_CURVE_BOOK) GETN_OPTION_EVENT(operation_output_partialcurves_book_event)
				///end FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
				GETN_STR(BookName, _L("BookName"), _L("")) GETN_ID(IDE_PARTIAL_BOOK_NAME) GETN_OPTION_EVENT_EX(operation_output_book_sheet_name_changed)/// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
				GETN_STR(NameForNew, _L(""), _L("")) GETN_ID(IDE_PARTIAL_BOOK_OLD_NAME) GETN_CURRENT_SUBNODE.Show = false;
				///Sophy 5/28/2008 QA80-10934-P8 FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
				//GETN_STRLIST(Sheet, _L("Sheet"), STR_NEW,  STR_NEW + STR_TOKEN_SEP + STR_FIT_CURVE) GETN_ID(IDE_PARTIAL_CURVE_SHEET) GETN_OPTION_EVENT(operation_output_sheet_event)
				GETN_STRLIST(Sheet, _L("Sheet"), STR_NEW,  STR_NEW + STR_TOKEN_SEP + STR_FIT_CURVE + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS) GETN_ID(IDE_PARTIAL_CURVE_SHEET) GETN_OPTION_EVENT(operation_output_partialcurves_sheet_event)
				///end FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
				GETN_STR(SheetName, _L("SheetName"), _L("")) GETN_ID(IDE_PARTIAL_SHEET_NAME) GETN_OPTION_EVENT_EX(operation_output_book_sheet_name_changed)/// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
				GETN_STR(NameForNew, _L(""), _L("")) GETN_ID(IDE_PARTIAL_SHEET_OLD_NAME) GETN_CURRENT_SUBNODE.Show = false;
			GETN_END_BRANCH(PartialCurves)			
		}
		
		///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
		//add FindXY output branch
		if(nFinXYBranchID)
		{
			///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
			//GETN_BEGIN_BRANCH(FindXY, _L("Output Find Specific X/Y Tables")) GETN_ID_BRANCH(nFinXYBranchID) ///Arvin 12/29/06 MODIFY_BY_MAX_SUGGESTION
			GETN_BEGIN_BRANCH(FindXY, STR_OUTPUT_FINDXY_TABLES) GETN_ID_BRANCH(nFinXYBranchID) GETN_OPTION_EVENT(operation_output_findxy_branch_event)
			///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
				/// Iris 02/01/2007 SAME_DESIGN_WITH_OUTPUT_RESIDUALS_TO
				//GETN_STRLIST(Book, _L("Book"), STR_FIT_CURVE,  STR_FIT_CURVE + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS) GETN_ID(IDE_FIND_XY_BOOK) GETN_OPTION_EVENT(operation_output_findxy_book_event)
				//GETN_STRLIST(Sheet, _L("Sheet"), STR_NEW,  STR_FIT_CURVE + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS) GETN_ID(IDE_FIND_XY_SHEET) GETN_OPTION_EVENT(operation_output_sheet_event)
				//GETN_READ_ONLY
				///Arvin 04/30/07 v8.0610 FILTER_EXISTING_FOR_SURFACE_FITTING
				//GETN_STRLIST(Book, _L("Book"), STR_FIT_CURVE,  STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS) GETN_ID(IDE_FIND_XY_BOOK) GETN_OPTION_EVENT(operation_output_residual_book_event)
				GETN_STRLIST(Book, _L("Book"), STR_FIT_CURVE,  STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS) GETN_ID(IDE_FIND_XY_BOOK) GETN_OPTION_EVENT(operation_output_findxy_book_event)
				///end FILTER_EXISTING_FOR_SURFACE_FITTING
				GETN_STR(BookName, _L("BookName"), _L("")) GETN_ID(IDE_FIND_XY_BOOK_NAME) GETN_OPTION_EVENT_EX(operation_output_book_sheet_name_changed)/// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
				GETN_STR(NameForNew, _L(""), _L("")) GETN_ID(IDE_FIND_XY_BOOK_OLD_NAME) GETN_CURRENT_SUBNODE.Show = false;
				
				///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
				//GETN_STRLIST(Sheet, _L("Sheet"), STR_NEW,  STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW) GETN_ID(IDE_FIND_XY_SHEET) GETN_OPTION_EVENT(operation_output_sheet_event)
				///Sophy 5/28/2008 QA80-10934-P8 FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
				//GETN_STRLIST(Sheet, _L("Sheet"), STR_NEW,  STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS) GETN_ID(IDE_FIND_XY_SHEET) GETN_OPTION_EVENT(operation_output_sheet_event)
				GETN_STRLIST(Sheet, _L("Sheet"), STR_NEW,  STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS) GETN_ID(IDE_FIND_XY_SHEET) GETN_OPTION_EVENT(operation_output_findxy_sheet_event)
				///end FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
				///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
				///end SAME_DESIGN_WITH_OUTPUT_RESIDUALS_TO
				/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
				//GETN_STR(SheetName, _L("SheetName"), _L("")) GETN_ID(IDE_FIND_XY_SHEET_NAME) GETN_OPTION_EVENT_EX(operation_output_book_sheet_name_changed)/// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
				GETN_STR(SheetName, _L("FindX SheetName"), _L("")) GETN_ID(IDE_FIND_XY_SHEET_NAME) GETN_OPTION_EVENT_EX(operation_output_book_sheet_name_changed)/// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
				GETN_STR(NameForNew, _L(""), _L("")) GETN_ID(IDE_FIND_XY_SHEET_OLD_NAME) GETN_CURRENT_SUBNODE.Show = false;
				GETN_STR(SheetName2, _L("FindY SheetName"), _L("")) GETN_ID(IDE_FIND_XY_SHEET_NAME2) GETN_OPTION_EVENT_EX(operation_output_book_sheet_name_changed)
				GETN_STR(NameForNew, _L(""), _L("")) GETN_ID(IDE_FIND_XY_SHEET_OLD_NAME2) GETN_CURRENT_SUBNODE.Show = false;
				/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
			GETN_END_BRANCH(FindXY)
		}
		///End MODIFICATION_OUTPUT_BRANCH

		 ///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		////GETN_BEGIN_BRANCH(Report, _L("Result Tables")) GETN_ID_BRANCH(IDST_REPORT_SHEET_OPTIONS) GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS)
		///// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
		////GETN_BEGIN_BRANCH(Report, _L("Output Results To")) GETN_ID_BRANCH(IDST_REPORT_SHEET_OPTIONS) GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS)
		//GETN_BEGIN_BRANCH(Report, _L("Output Report Tables To")) GETN_ID_BRANCH(IDST_REPORT_SHEET_OPTIONS) GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS)
		/////end REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
			////GETN_CHECK(InsertColsDataSheet, _L("Insert as Columns to Source Data Sheet"), false) GETN_ID(IDE_REPORT_INSERT_COLUMNS)	///Forest 09/11/04 QA70-6682 SETTINGS_THEME_FILE_SAVE_LOAD
			////GETN_BEGIN_BRANCH(CreateReportSheet, _L("Output to Report Sheet")) GETN_ID_BRANCH(IDST_REPORT_SHEET_OPTIONS) GETN_CHECKBOX_BRANCH(1) GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS) ///Forest 09/09/04 QA70-6682 SAVE_SETTING_ON_ALL_LEVELS 
			//
			//GETN_STRLIST(Book, _L("Book"), _L(""),  _L("")) GETN_ID(IDE_REOPRT_BOOK) GETN_OPTION_EVENT(operation_output_report_book_event)
			//GETN_STRLIST(Sheet, _L("Sheet"),  _L(""),  _L("")) GETN_ID(IDE_REPORT_SHEET) GETN_OPTION_EVENT(operation_output_report_sheet_event)  ///Iris 11/12/04 QA70-7139 ADD_CUSTOM_OPTION_TO_REPORT
			//
			////---- Iris 08/10/2007 v8.0679 design changed
			////GETN_CHECK(AddReportToResultsLog, _L("Results Log"), true) GETN_ID(IDE_REPORT_ADD_TO_RESULTS_LOG)
			//GETN_CHECK(AddReportToResultsLog, _L("Results Log"), false) GETN_ID(IDE_REPORT_ADD_TO_RESULTS_LOG)
			////----
			//GETN_CHECK(DumpScriptWindow, _L("Script Window"), false) GETN_ID(IDE_REPORT_DUMP_SCRIPTWIN)
			//GETN_STR(DumpNotesWindow, _L("Notes Window"), STR_NONE) GETN_ID(IDE_REPORT_DUMP_NOTESWIN)
		//GETN_END_BRANCH(Report)
		///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
		///Joseph 09/18/06  MOVE_CALIBRATION_TABLE_OUT_OUTPUT
		/////Joe 8/28/06  MOVE_GET_X_FROM_Y_OR_GET_Y_FROM_X_TO_CALIBRATION
		//if(dwOptions & (REPORT_CUSTOM_TABLE2 | REPORT_CUSTOM_TABLE3))
		//{
			//
			//GETN_BEGIN_BRANCH(Calibration, _L("Calibration Tables"))
			//GETN_ID_BRANCH(IDST_REPORT_CALIBRATION_TABLE)  ///Joseph 09/15/06  HIDE_THE_CALIBRATION_TABLE
			//
			//GETN_BEGIN_BRANCH(Custom2, _L("Find X from Y")) GETN_ID_BRANCH(IDST_REPORT_CUSTOM_TABLE2_BEGIN) GETN_CHECKBOX_BRANCH(0) GETN_ID_REPEAT_BRANCH(2) 
				//tree_construct_gui_custom_table_branch(GETN_CURRENT_NODE, 5, 2, false, true);
			//GETN_END_BRANCH(Custom2)
//
			//GETN_BEGIN_BRANCH(Custom3, _L("Find Y from X")) GETN_ID_BRANCH(IDST_REPORT_CUSTOM_TABLE3_BEGIN) GETN_CHECKBOX_BRANCH(0) GETN_ID_REPEAT_BRANCH(3) 
				//tree_construct_gui_custom_table_branch(GETN_CURRENT_NODE, 5, 2, false, true);
			//GETN_END_BRANCH(Custom3)
			//
			//GETN_END_BRANCH(Calibration)
		//}		
		/////End MOVE_GET_X_FROM_Y_OR_GET_Y_FROM_X_TO_CALIBRATION
		///End MOVE_CALIBRATION_TABLE_OUT_OUTPUT

#ifndef OP_DLG_TOTALLY_NEW_STRUCTURE
		///Iris 6/06/05 MOVE_OPTIONAL_TABLES_OUTSDIE_REPORT
		if(dwOptions)
		{
			//GETN_BEGIN_BRANCH(Create, _L("Optional Tables")) GETN_ID_BRANCH(IDE_REPORT_CREATE_OPTION)  GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS) ///Forest 09/09/04 QA70-6682 SAVE_SETTING_ON_ALL_LEVELS 
			//GETN_BEGIN_BRANCH(Create, _L("Optional Report Tables")) GETN_ID_BRANCH(IDE_REPORT_CREATE_OPTION)  GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS ) ///Forest 09/09/04 QA70-6682 SAVE_SETTING_ON_ALL_LEVELS 
			GETN_BEGIN_BRANCH(Create, STR_OUTPUT_OPTIONAL_TABLES) GETN_ID_BRANCH(IDE_REPORT_CREATE_OPTION)  GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS | GETNBRANCH_OPEN) ///Alex 06/13/06 SET_OPTIONAL_REPORT_TABLE_OPEN
			///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
			/*
			if(dwOptions & REPORT_NOTES)
			{	
				///Iris 8/17/05 MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
				//GETN_CHECK(Notes, STR_NOTES_TABLE, true) GETN_ID(IDST_REPORT_NOTES)
				GETN_CHECK(Notes, STR_NOTES_TABLE, true) GETN_ID(IDE_REPORT_NOTES)
				///END MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
			}
			if(dwOptions & REPORT_INPUT)
			{	
				///Iris 8/17/05 MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
				//GETN_CHECK(InputData, STR_INPUT_DATA, true) GETN_ID(IDST_REPORT_INPUT_TABLE)
				GETN_CHECK(InputData, STR_INPUT_DATA, true) GETN_ID(IDE_REPORT_INPUT_TABLE)
				///END MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
			}
			if(dwOptions & REPORT_MASKED_DATA)
			{
				///Iris 8/17/05 MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
				//GETN_CHECK(MaskedData, STR_MASKED_DATA, true) GETN_ID(IDST_REPORT_MASKED_DATA_TABLE)
				///Sophy 8/12/2008 QA80-12000-S3 DEFAULT_TURN_OFF_REPORT_MASKED_DATA_FOR_STATS_TOOL
				//GETN_CHECK(MaskedData, STR_MASKED_DATA, true) GETN_ID(IDE_REPORT_MASKED_DATA_TABLE)
				GETN_CHECK(MaskedData, STR_MASKED_DATA, false) GETN_ID(IDE_REPORT_MASKED_DATA_TABLE)
				///end DEFAULT_TURN_OFF_REPORT_MASKED_DATA_FOR_STATS_TOOL
				///END MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
			}
			if(dwOptions & REPORT_MISSING_DATA)
			{
				///Iris 8/17/05 MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
				//GETN_CHECK(MissingData, STR_MISSING_DATA, true) GETN_ID(IDST_REPORT_MISSING_DATA_TABLE)
				///Sophy 8/12/2008 QA80-12000-S1 DEFAULT_TURN_OFF_REPORT_MISSING_DATA_FOR_STATS_TOOL
				//GETN_CHECK(MissingData, STR_MISSING_DATA, true) GETN_ID(IDE_REPORT_MISSING_DATA_TABLE)
				GETN_CHECK(MissingData, STR_MISSING_DATA, false) GETN_ID(IDE_REPORT_MISSING_DATA_TABLE)
				///end DEFAULT_TURN_OFF_REPORT_MISSING_DATA_FOR_STATS_TOOL
				///END MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
			}			
			if(dwOptions & REPORT_ANOVA_TABLE)
			{	
				///Iris 8/17/05 MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
				//GETN_CHECK(ANOVAtable, STR_ANOVA_TABLE, true) GETN_ID(IDST_ANOVA_TABLE)
				GETN_CHECK(ANOVAtable, STR_ANOVA_TABLE, true) GETN_ID(IDE_ANOVA_TABLE)
				///END MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
			}
			*/
			/// Iris 11/03/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
			//ConstructAddCommonReportTables(_tmpSubNode, dwOptions);
			tree_construct_add_common_report_table_options(_tmpSubNode, dwOptions);
			///end OP_DLG_NEW_STRUCTURE
			///end OP_DLG_NEW_STRUCTURE
			/// Iris 07/04/05 REMOVE_RESIDUAL_DATA_GUI
			//if(dwOptions & REPORT_RESIDUAL_TABLE)
			//{
				//GETN_CHECK(ResidualTable, STR_RESIDUAL_TABLE, true) GETN_ID(IDST_RESIDUAL_DATA_TABLE)
			//}
			///end REMOVE_RESIDUAL_DATA_GUI
			///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
			/*
			for(int index=0; index<nGraphNum; index++)
			{
				string strName = op_get_graph_tag_name(index);
				if(dwOptions & REPORT_GRAPH_PLOT_INFO)
				{										
					///DSC 9/20/05 QA70-8113 NEED_REPEAT_ID_GREATER_THAN_ONE
					// //GETN_BEGIN_BRANCH_L(strName, _L("Graphs"))	GETN_ID(IDST_RESULT_GRAPHS + index)	 GETN_CHECKBOX_BRANCH(1)  GETN_ID_REPEAT_BRANCH(index)  ///Iris 8/17/05 MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
					// GETN_BEGIN_BRANCH_L(strName, _L("Graphs"))	GETN_ID(IDE_RESULT_GRAPHS + index)	 GETN_CHECKBOX_BRANCH(1)  GETN_ID_REPEAT_BRANCH(index)
					GETN_BEGIN_BRANCH_L(strName, _L("Graphs"))	GETN_ID(IDE_RESULT_GRAPHS + index)	 GETN_CHECKBOX_BRANCH(1)  GETN_ID_REPEAT_BRANCH(index+1)
					///end NEED_REPEAT_ID_GREATER_THAN_ONE
						
					GETN_END_BRANCH_L(strName)
				}
				else
				{
					//GETN_CHECK_L(strName, _L("Graphs"), true) 	GETN_ID(IDST_RESULT_GRAPHS + index)  ///Iris 8/17/05 MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
					GETN_CHECK_L(strName, _L("Graphs"), true) 	GETN_ID(IDE_RESULT_GRAPHS + index)
				}
				
			}			
			*/
			tree_construct_add_graph_options(_tmpSubNode, nGraphNum, dwOptions);
			///end OP_DLG_NEW_STRUCTURE
			if(dwOptions & REPORT_CUSTOM_TABLE1) //CPY 11/10/04 QA70-7121 CUSTOM_REPORT_TABLES
			{
				/// ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
				/*
				GETN_BEGIN_BRANCH(Custom1, _L("Custom Table")) GETN_ID_BRANCH(IDST_REPORT_CUSTOM_TABLE1) GETN_CHECKBOX_BRANCH(1) 
				///Iris 8/17/05 MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
					
					//GETN_COMBO(Rows, "Number of Rows", 8, "|1|2|3|4|5|6|7|8|9") GETN_ID(IDST_REPORT_CUSTOM_TABLE_ROWS) GETN_OPTION_NUM_FORMAT( "%d" )
					//GETN_COMBO(Cols, "Number of Columns", 4, "|1|2|3|4|5|6|7|8|9") GETN_ID(IDST_REPORT_CUSTOM_TABLE_COLS) GETN_OPTION_NUM_FORMAT( "%d" )
					GETN_COMBO(Rows, "Number of Rows", 8, "|1|2|3|4|5|6|7|8|9") GETN_ID(IDE_REPORT_CUSTOM_TABLE_ROWS) GETN_OPTION_NUM_FORMAT( "%d" )
					GETN_COMBO(Cols, "Number of Columns", 4, "|1|2|3|4|5|6|7|8|9") GETN_ID(IDE_REPORT_CUSTOM_TABLE_COLS) GETN_OPTION_NUM_FORMAT( "%d" )
					///END MAKE_LASTUSE_WORK_FOR_ID_LARGER_THAN_BRANCH_MASK
					
					/// ML 4/28/2006 FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
					///// ML 6/27/2005 STYLE_LINKS_WITH_OFFSETS
					//GETN_STRLIST(Theme, _L("Theme"), "", "") GETN_ID(IDST_REPORT_CUSTOM_TABLE_THEME) GETN_OPTION_EVENT(operation_output_report_custom_table_event)
					///// end STYLE_LINKS_WITH_OFFSETS
					GETN_STR(Theme, _L("Theme"), "") GETN_ID(IDST_REPORT_CUSTOM_TABLE_THEME)
					/// end CUSTOM_TABLES_FOR_FIND_XY
				GETN_END_BRANCH(Custom1)
				*/
				
				GETN_BEGIN_BRANCH(Custom1, _L("Custom Table")) GETN_ID_BRANCH(IDST_REPORT_CUSTOM_TABLE1) GETN_CHECKBOX_BRANCH(1) GETN_ID_REPEAT_BRANCH(1) GETN_OPTION_BRANCH(GETNBRANCH_KEEP_SIZE_ON_COLLAPSE)
					//tree_construct_gui_custom_table_branch(GETN_CURRENT_NODE, 8, 4, true, false);
					tree_construct_gui_custom_table_branch(GETN_CURRENT_NODE, 1, 1, true, false);		/// ML 6/30/2006 per CP's request.
				GETN_END_BRANCH(Custom1)
				/// end FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
			}
			
			///Joe 8/28/06  MOVE_GET_X_FROM_Y_OR_GET_Y_FROM_X_TO_CALIBRATION
			/// ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
			//if(dwOptions & REPORT_CUSTOM_TABLE2)
			//{
				//// The label should be in sync with FitterOperation::addFindXYorYXTable()
				///// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
				////GETN_BEGIN_BRANCH(Custom2, _L("Find X from Y")) GETN_ID_BRANCH(IDST_REPORT_CUSTOM_TABLE2) GETN_CHECKBOX_BRANCH(0) GETN_ID_REPEAT_BRANCH(2) 
				//GETN_BEGIN_BRANCH(Custom2, _L("Find X from Y")) GETN_ID_BRANCH(IDST_REPORT_CUSTOM_TABLE2_BEGIN) GETN_CHECKBOX_BRANCH(0) GETN_ID_REPEAT_BRANCH(2) 
				///// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
					//tree_construct_gui_custom_table_branch(GETN_CURRENT_NODE, 5, 2, false, true);
				//GETN_END_BRANCH(Custom2)
			//}
//
			//if(dwOptions & REPORT_CUSTOM_TABLE3)
			//{
				//// The label should be in sync with FitterOperation::addFindXYorYXTable()
				///// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
				////GETN_BEGIN_BRANCH(Custom3, _L("Find Y from X")) GETN_ID_BRANCH(IDST_REPORT_CUSTOM_TABLE3) GETN_CHECKBOX_BRANCH(0) GETN_ID_REPEAT_BRANCH(3) 
				//GETN_BEGIN_BRANCH(Custom3, _L("Find Y from X")) GETN_ID_BRANCH(IDST_REPORT_CUSTOM_TABLE3_BEGIN) GETN_CHECKBOX_BRANCH(0) GETN_ID_REPEAT_BRANCH(3) 
				///// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
					//tree_construct_gui_custom_table_branch(GETN_CURRENT_NODE, 5, 2, false, true);
				//GETN_END_BRANCH(Custom3)
			//}
//
			///// end CUSTOM_TABLES_FOR_FIND_XY
//
			//
			//if(dwOptions & REPORT_CALIBRATION_TABLE) ///Iris 11/15/04 QA70-7120 CALIBRATION_REPORT_TABLE
			//{
				//GETN_BEGIN_BRANCH(Calibration, _L("Calibration Table")) GETN_ID_BRANCH(IDST_REPORT_CALIBRATION_TABLE) GETN_CHECKBOX_BRANCH(0)
					//GETN_LIST(Find, "Find", 0, "Y from X|X from Y")   
					//GETN_LIST(For, "For", 0, "Specific Values|Table of Values")  GETN_OPTION_EVENT(operation_report_calibration_table_event)
					//GETN_STR(Values, "Values", " ")
					//GETN_NUM(Start, "Start", NANUM) GETN_READ_ONLY
					//GETN_NUM(Stop, "Stop", NANUM) GETN_READ_ONLY
					//GETN_NUM(Step, "Step", NANUM) GETN_READ_ONLY
				//GETN_END_BRANCH(Calibration)					
			//}
			///End MOVE_GET_X_FROM_Y_OR_GET_Y_FROM_X_TO_CALIBRATION

			GETN_END_BRANCH(Create)
		}
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE
		///end MOVE_OPTIONAL_TABLES_OUTSDIE_REPORT		
	GETN_END_BRANCH(Output)		
}

bool tree_check_set_hidden(TreeNode& tr, bool bMakeHidden)// = true)
{
	if(!tr)
		//return error_report("tree_check_set_hidden found invalid tree node");
		return false; /// Iris 7/28/06 no need show err message here since sometimes the tree node is invalid 
	
	if(bMakeHidden)
		tr.Show = false;
	else
	///Arvin 08/09/07 SHOULD_NOT_REMOVE_SHOW_ATTRIB
	//If has "Show" attribute, set it as true, or else do nothing
	//tr.RemoveAttribute(STR_SHOW_ATTRIB);
	{
		string str;
		if(tr.GetAttribute(STR_SHOW_ATTRIB, str))
			tr.Show = true;	
	}
	///end SHOULD_NOT_REMOVE_SHOW_ATTRIB
	
	return true;
}

int tree_get_plot_UIDs(const TreeNode& trInputData, vector<uint>& vPlotUIDs)
{
	vPlotUIDs.SetSize(0);
	DataRange drTemp;
	drTemp.Create(trInputData, FALSE);
	drTemp.GetPlots(vPlotUIDs);
	drTemp.Destroy();
	return vPlotUIDs.GetSize();
}

/// if there is unused data range on the plot - description of datarange would be used
int get_layer_plots(vector<int>& PlotIndexList, vector<string>& vsDescriptions, vector<uint>& PlotUIDsToExclude, bool bRemoveHiddenPlots) // =NULL, = NULL, = true;
{
	PlotIndexList.SetSize(0);
	GraphLayer gl = Project.ActiveLayer();
	if(!gl)
		return 0;
	
	int nPlot = -1;
	foreach(DataPlot dp in gl.DataPlots )
	{
		uint unUID = dp.GetUID();
		
		/// YuI 6/16/04 v7.5891 QA70-6556 DATA_RANGE_MARKERS
		/*
		//--- check plot type might be needed
		DataPlotStrings dps;
		int nType = dp.GetType(&dps);
		//---
		*/
		/// end DATA_RANGE_MARKERS	
	
		nPlot++;
		if(unUID && PlotUIDsToExclude)
		{
			BOOL bPresent = FALSE;
			for( int ii = 0; ii < PlotUIDsToExclude.GetSize(); ii++ )
			{
				if( unUID == PlotUIDsToExclude[ii] )
				{
					bPresent = TRUE;
					break;
				}
			}
			if(bPresent)
				continue;
		}
		
		/// Iris 9/09/05 REMOVE_PLOTS_FROM_HIDDEN_WKS
		if( bRemoveHiddenPlots )
		{
			string strName = dp.GetDatasetName();
			string strWksName = strName.GetToken(0, '_');
			WorksheetPage wksPg(strWksName);
			if( PAGE_HIDDEN == wksPg.GetShow())
				continue;
		}
		///End REMOVE_PLOTS_FROM_HIDDEN_WKS	
		
		PlotIndexList.Add(nPlot);
		
		

		/// YuI 6/16/04 v7.5891 QA70-6556 DATA_RANGE_MARKERS
		//	if( vsDescriptions )
		//		vsDescriptions.Add(dps.szPlotDesigDescription);
		if( vsDescriptions )
		{
			// YuI  this part will be implemented later
			/*
			DataRange dr;
			//dr = dp.GetDataSelectorDataRange();
			if( dr )
			{
				string strDesc = dr.GetDescription();
				vsDescriptions.Add(strDesc);
			}
			else
			*/
			
			{
				DataPlotStrings dps;
				int nType = dp.GetPlotType(&dps);
				vsDescriptions.Add(dps.szPlotDesigDescription);
			}
		}
		/// end DATA_RANGE_MARKERS
	}
	return PlotIndexList.GetSize();
}

// nData = 0 will assume InputData is already a subbranch
/// YuI 8/13/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
// this function is moved to analysis_tuils
/*
static TreeNode tree_check_add_input_data_branch(TreeNode& trInputData, const vector<string>& vsKeys, 
	vector<string>& vsLabels, int nBranchType, int nData = 1, int nType = -1, LPCSTR lpcszDefaultVal = NULL)// = 1,= -1, = NULL
{
	ASSERT(vsKeys.GetSize() == vsLabels.GetSize());
	TreeNode tr = trInputData;
	if(nData > 0)
	{
		string strName;
		strName.Format("%s%d", PREFIX_FOR_DATA_RANGE_DATA, nData); 
		tr = tree_check_get_node(trInputData, strName, nBranchType, STR_LABEL_ATTRIB, strName);
	}
		
	for(int ii = 0; ii < vsKeys.GetSize(); ii++)
	{
		TreeNode trTemp = tree_check_get_node(tr, vsKeys[ii], TRGP_INTERACTIVE, STR_LABEL_ATTRIB, vsLabels[ii]);

		if(lpcszDefaultVal && (nType < 0 || nType == ii))
		{
			trTemp.strVal = lpcszDefaultVal;
			ASSERT(nType >= 0);
		}
	}
	return tr;
}
*/
/// end NLFITTER_OPERATION_IMPLEMENTATION


#ifdef _INTERACTIVE_CNTRL_IN_FLEX_GRID 
/// CPY 8/3/04 merge YuI 6/16/04 v7.5891 QA70-6556 DATA_RANGE_MARKERS into this function
		/// YuI 6/16/04 v7.5891 QA70-6556 DATA_RANGE_MARKERS
		// if there is unused data range available on active plot we want to use it
bool tree_check_add_input_data_branch_active_layer(TreeNode& trInputData, int nPlot, bool bAdd1st) // = FALSE
{
	GraphLayer gl = Project.ActiveLayer();
	if(!gl)
		return false;
	
	DataPlot dp = gl.DataPlots(nPlot);
	if(!dp)
		return false;
	
	int nData = 1;
	if(!bAdd1st)
	{
		nData =tree_get_next_enum_tag_name(trInputData);
		if(nData < 0)
			return false;
	}	
	TreeNode tr = tree_check_add_input_data_branch(trInputData, dp, nData);
	return true;
}
#endif

/// Iris 10/17/06 move to analysis_utils.c
/*
/// ML 8/17/2004 QA70-6825 RLOG_QUERY
// The function ignores the high word of idBase. 
int		make_one_set_ID(int idBase, int nDataIndex)
{
	//++nDataIndex;
	int			nId = nDataIndex << 16;
	idBase &= 0xffff;
	nId |= idBase;
	nId |= IDST_MASK_ONE_SET;
	return nId;
}
/// end RLOG_QUERY
*/

//------ CPY 8/3/04 merge YuI 6/16/04 v7.5891 QA70-6556 DATA_RANGE_MARKERS into this function
/*
/// YuI 6/16/04 v7.5891 QA70-6556 DATA_RANGE_MARKERS
// this function add input bracn based on unused datarange on plot
// and returns this unused datarange
bool tree_check_add_input_data_branch_unused_datarange(TreeNode& trInputData, int nPlot, bool bAdd1st)
{
	DataRange dr;
	GraphLayer gl = Project.ActiveLayer();
	if( !gl )
		return false;
	
	DataPlot dp = gl.DataPlots(nPlot);
	if(!dp)
		return false;
	
	dr = dp.GetDataSelectorDataRange();
	if( dr )
	{
		int nData = 1;
		if(!bAdd1st)
		{
			nData =tree_get_next_enum_tag_name(trInputData);
			if(nData < 0)
				return false;
		}

		// prepare branch without values
		tree_check_add_input_data_branch(trInputData, NULL, nData, dp.GetUID(true));
						
		// and then pass it to data range to fill it up
		string strTemp;
		strTemp.Format("%s%d", PREFIX_FOR_DATA_RANGE_DATA, nData); 
		TreeNode trTemp = trInputData.GetNode(strTemp);
		if( trTemp )
		{
			dr.GetTree(trTemp, true);
			return true;
		}
	}
	
	return false;
}
/// end DATA_RANGE_MARKERS
*/
//------

uint tree_get_plot_uid(const TreeNode& trInputDataSub)
{
	/*
	string strPlotUID;
	if(!trInputDataSub.GetAttribute(STR_PLOTOBJ_UID_ATTRIB, strPlotUID) || strPlotUID.IsEmpty())
		return 0;
	return atoi(strPlotUID);
	*/
	int nPlotUID;
	if( get_plot_uid_from_tree(trInputDataSub, nPlotUID) )
		return nPlotUID;
	
	return 0;
}

#define	DATA_SELECTOR_NAME_BASE			"_DRSel_"

// assume active layer is a graphic layer, otherwise returns NULL dataselector
// assume to be InputData.Data1 branch on input
/// YuI 6/16/04 v7.5891 QA70-6556 DATA_RANGE_MARKERS

/*
DataSelector get_data_selector(const TreeNode& trInputDataSub, bool bCreate) // = false
{
	DataSelector ds;
	uint uID = tree_get_plot_uid(trInputDataSub);
	if(0 == uID )
		return ds;
	DataPlot dp;
	dp = Project.GetObject(uID);
	if(!dp)
		return ds;
	string strName = DATA_SELECTOR_NAME_BASE;
	strName += uID;
	
	GraphLayer gl = Project.ActiveLayer();
	if( !gl )
		return ds;
	ds = gl.GraphObjects(strName);
	if(!ds.IsValid() && bCreate)
		ds = gl.CreateGraphObject(GROT_DATASELECTOR, strName, DST_STANDARD);
	
	/*
	if(!ds)
		return ds;
	ds.AttachDataObject(dp, TRUE);
	
	
	if(bCreate)
	{
		DataRange dr;
		dr.Create(trInputDataSub);
		ds.SetDataRange(dr);
		dr.Destroy();
	}
	*/
	/*
	ds.SetTree(trInputDataSub);
	return ds;
}
*/

/// YuI 7/15/04 v7.5909 QA70-6688 OC_TOOLS_IMPLEMENTATION
/*
DataSelector get_data_selector(DataRange& dr, int nSubRange, bool bCreate) // = false
{
	DataSelector ds;
	
	if( !dr || nSubRange < 0 )
		return ds;
	
	vector<uint> uidPlots;
	dr.GetPlots(uidPlots);
	if( nSubRange >= uidPlots.GetSize() )
		return ds;
	
	uint uID = uidPlots[nSubRange];
	if( 0 == uID )
		return ds;

	string strName = DATA_SELECTOR_NAME_BASE;
	strName += uID;
	
	GraphLayer gl = Project.ActiveLayer();
	if( !gl )
		return ds;
	
	ds = gl.GraphObjects(strName);
	if( !ds.IsValid() && bCreate )
		ds = gl.CreateGraphObject(GROT_DATASELECTOR, strName, DST_STANDARD);
	
	ds.SetDataRange(dr, nSubRange);
	return ds;
}
*/
/// end OC_TOOLS_IMPLEMENTATION
/// end DATA_RANGE_MARKERS	
//----- end MOVE_REPORT_BRANCH_TO_BASE_CLASS



/**#
		It adds or just retrieves a column from the DataRange according to the slot index indexInRange inside the DataRange.
		A column is added to the worksheet as needed. The function decides on whether it considers the column to already exist
		based on the presence of the range inside the provided DataRange at the required slot.
	Paramaters:
		wks=the worksheet hosting the column
		rngInsertedColumns=the DataRange object holding the information about the column at the slot indexInRange. If the
							information is absent, it will be added as the column is added to the worksheet.
		lpcszName = the unique named DataRange inside rngInsertedColumns
		col=the column to be retrieved.
		nDesiredColumnPosition=the desired position of the column if the column is to be added. If less than 0,
								the column will be appended. If >= 0, but the current total number of
								columns in wks is less than nDesiredColumnPosition, the column will still be appended.
		r1=the starting row of the range to add or update
		r2=the ending row of the range to add or update
	Returns:
		the index of the column inside the worksheet
							
*/
int check_insert_output_column(Worksheet &wks, DataRange &rngInsertedColumns, LPCTSTR lpcszName, Column &col, int nDesiredColumnPosition, int r1, int r2)//=-1=0=-1)
{
	// range name for this index:
	string		str;
	str.Format("__InsCol__%s", lpcszName);
	// Check existence in range:
	int			r1Rng, c1, r2Rng, c2;
	Worksheet	wksInRange;
	int			nIndex = rngInsertedColumns.GetRange(str, r1Rng, c1, r2Rng, c2, wksInRange);
	int			colindex = -1;
	if (0 <= nIndex)		// it already exists
	{
		ASSERT( worksheets_are_same(wksInRange, wks) );
		
		ASSERT(c1 == c2);
		
		col = wks.Columns(c1);
		if (!col)		// the range says the column should be there, but no column can be found
		{
			// Must add column (it's been deleted?):
			colindex = wks_insert_column(wks, nDesiredColumnPosition, col);
		}
		else
			colindex = c1;
		
		// Update the range:
		rngInsertedColumns.SetRange(nIndex, wks, r1, colindex, r2, colindex);
	}
	else		// must add
	{
		colindex = wks_insert_column(wks, nDesiredColumnPosition, col);
		// Add a range:
		rngInsertedColumns.Add(str, wks, r1, colindex, r2, colindex);
	}
	
	
	return colindex;
}
//-------

/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME, no place used this funciton, so comment out
/*
//virtual 
string	WksReportOperation::GetResultBookName(TreeNode& trOperation, int nDataIndex)				
{
	string 	strData;
	GetEscapedMainDataString(trOperation, strData, nDataIndex+1); //+1 mean LT index, offset is 1
	ConvertEscapedString(strData);
	
	string strBookName = "Analysis Report";
	if(!strData.IsEmpty())
		strBookName += " - " + strData;
	return strBookName;
}	
*/
///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME

/// ML 6/9/2005 REPEATITIVE_STYLES_IN_GRID_THEMES
bool	WksReportOperation::SetTablePeriodicity(TreeNode &trTable, int nDim, int nPeriod, int nSize, int nOffset)
{
	if (nSize <= 0)
		nSize = nPeriod;		// by default the same as the period
	
	return okutil_repetitive_style_string(&trTable, nDim, true, &nPeriod, &nOffset, &nSize);
}
/// end REPEATITIVE_STYLES_IN_GRID_THEMES


/// Iris 9/30/04 BASE_CLASS_CHECK_INPUT_DATA
/// YuI 06/07/06 INPUT_DATA_HAS_TO_BE_RESOLVED_BEFORE_USE
/*
virtual bool	WksReportOperation::CheckInputData(TreeNode& trGUI)
{
	return true;
}
*/

/// YuI 07/10/08 this function is not needed. 
//	bool	WksReportOperation::checkResolveInputData(TreeNode& trGUI)
//	{
//	/*
//		TreeNode trInputData = trGUI.InputData;
//		TreeNode trResolvedData;
//		if( okxf_resolve_composite_range_tree(&trResolvedData, &trInputData) )
//		{
//			trInputData.Replace(trResolvedData, TRUE, TRUE, TRUE);
//			return true;
//		}
//		*/
//		return true;
//	}
/// end YuI
/// end INPUT_DATA_HAS_TO_BE_RESOLVED_BEFORE_USE
virtual int		WksReportOperation::GetNumData(TreeNode& trOp, DataRange& dr, TreeNode &trAdditionalData, Worksheet *pwksFirstRange, vector<int> *pvFactorSizes, int *pnNumSubRanges)
{
	DWORD	dwRules = GetDataRules(trOp);
	
	int 	nNumData = dr.GetNumData(dwRules, trAdditionalData, pwksFirstRange, pvFactorSizes, pnNumSubRanges);
	
	return nNumData;
}
			
///Sophy 7/9/2008 CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
//virtual
TreeNode	WksReportOperation::GetInputDataNode( const TreeNode& trGUI )
{
	TreeNode	trInputData = tree_get_node_by_dataid( trGUI, IDST_INPUT_DATA_OPTIONS, true ); //find InputData node recursively
	return		trInputData;
}

//virtual
TreeNode	WksReportOperation::GetOutputNode( const TreeNode& trGUI )
{
	///Sophy 11/10/2009 IMPROVE_CODE_TO_GET_OP_GUI_OUTPUT_NODE
	//TreeNode	trOutput = tree_get_node_by_dataid( trGUI, IDST_OUTPUT_RESULTS_OPTIONS, true ); //find Output treenode recursively
	TreeNode	trOutput = trGUI.Output;
	///end IMPROVE_CODE_TO_GET_OP_GUI_OUTPUT_NODE
	/// Iris 2/04/2009 QA80-12937 FIX_FAIL_GET_OUTPUT_SUBNODES_IN_NLGUI_TREE
	if(!trOutput)
	{
		TreeNode trReport = tree_get_node_by_dataid( trGUI, IDST_REPORT_SHEET_OPTIONS, true );
		if(trReport)
			trOutput = trReport.Parent();
	}
	///end FIX_FAIL_GET_OUTPUT_SUBNODES_IN_NLGUI_TREE
	return		trOutput;
}
///end CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
/// YuI 8/13/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
bool	WksReportOperation::CalcMultiData(TreeNode& trOp, DataRange& dr, int &nNumData, int nExecMode, DWORD dwExecCntrl)//= 0
{	
	vector<int>		vFactorSizes;
	TreeNode		trAdditionalData = tree_check_get_node(trOp,TREE_INPUTRANGE_ADDITIONAL_DATA_NODE_NAME); 
	DWORD			dwRules = GetDataRules(trOp);
	//int				nNumData = dr.GetNumData(dwRules, trAdditionalData, NULL, &vFactorSizes);
	int				numSubRanges = 0;
	/// Iris 4/24/06 NEED_OVERLOAD_GETNUMDATA_FOR_ROC
	//nNumData = dr.GetNumData(dwRules, trAdditionalData, NULL, &vFactorSizes, &numSubRanges);
	nNumData = GetNumData(trOp, dr, trAdditionalData, NULL, &vFactorSizes, &numSubRanges);
	/// End NEED_OVERLOAD_GETNUMDATA_FOR_ROC
	
	if(!OnBeforeCalcMultiDataLoop(trOp, dr, nNumData, vFactorSizes))
		return error_report("OnBeforeCalcMultiDataLoop failed");

	SetTree(trOp);

	/////Jim/Kevin 12/02/05 	COMPUTE_NEW_NODES_MODIFICATION
	//if(trOp.Calculation.Statistics.IsValid())
		//trOp.Calculation.Statistics.Reset();
	////END COMPUTE_NEW_NODES_MODIFICATION

	vector<string>	vstrFactors;
	Worksheet		wksData;
	for (int ii = 0; ii < nNumData; ii++)
	{
		vector			vY, vX, vWeights;
		matrix			mXs;
		DWORD			dwPlotUID;
		/// Iris 05/17/2007 v8.0619 GET_ROW_INDEX_FOR_STATS_EXTREME_VAL_TABLE
		vector<int> 	vintRowsInSource;
		//int				nColOrRowIndex = dr.GetData(dwRules, ii, &dwPlotUID, NULL, &vY, &vX, &mXs, &vstrFactors, &vWeights, NULL, NULL, &wksData);
		int				nColOrRowIndex = dr.GetData(dwRules, ii, &dwPlotUID, NULL, &vY, &vX, &mXs, &vstrFactors, &vWeights, NULL, NULL, &wksData, NULL, SourceRowIndicesNeeded()? &vintRowsInSource : NULL);
		///end GET_ROW_INDEX_FOR_STATS_EXTREME_VAL_TABLE
		if ( 0 <= nColOrRowIndex )
		{
			_DEBUG_PLOT_UID("CalcMultiData ", dwPlotUID)
			
			///Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
			/////Cheney 2006-11-21 IF_CONCATENATE_SHOULD_SET_PLOTUID_AS_0_WHEN_DATA_FROM_GRAPH
			////so fit and average curve will not plot in source graph
			//TreeNode trInput = trOp.GUI.InputData;
			//if(!trInput)
				//return false;
			//
			//dwPlotUID = trInput.Use == DATA_MODE_CONCATENATE ? 0 : dwPlotUID;
			/////end IF_CONCATENATE_SHOULD_SET_PLOTUID_AS_0_WHEN_DATA_FROM_GRAPH
			///end FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
			
			/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
			//	CalcOneData is too operation specific while dwPlotUID is not really realted to operation but rather to input data
			// that is why I am moving source plot UID and source plot range from fitcurve branch to
			// temp branch wich will get cleaned up after calculation
			SetSourceDataPlot(trOp, vY, vX, ii, nNumData, dwPlotUID);
			/// end PICTURE_IN_REPORT_IMPROVEMENT
			
			/// Iris 05/17/2007 v8.0619 GET_ROW_INDEX_FOR_STATS_EXTREME_VAL_TABLE
			//if ( FALSE == CalcOneData(trOp, ii, nNumData, vFactorSizes, vstrFactors, vY, vX, mXs, vWeights, dwPlotUID, nColOrRowIndex) )
			if ( FALSE == CalcOneData(trOp, ii, nNumData, vFactorSizes, vstrFactors, vY, vX, mXs, vWeights, dwPlotUID, nColOrRowIndex, vintRowsInSource) )
			///end GET_ROW_INDEX_FOR_STATS_EXTREME_VAL_TABLE
			{
				return error_report("One data calculation failed");
			}
		}
		else
			return error_report("failed to GetData from input");
		
		/// Joesph/Iris 9/26/06 QA70-7120 MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
		if(IsReportCalibrationTable())			
			addAdditionalCustomTables(trOp, ii, nNumData);
		///end MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
	}
	//--- CPY 2/11/05 COMBINED_FOR_DESC_STATS_AND_OTHER_FOR_MULTIPLE_COLS
	// input data and other data related tables should not considered the combined bits
	dwRules = GetDataRules(trOp, true);
	
	if( !(DRR_BY_ROWS & dwRules))
	{
		/// ML 11/10/2005 QA70-7039 P1-L3 CORRECT_NUM_DATA_WHEN_COMBINED
		//nNumData = dr.GetNumData(dwRules, trAdditionalData, NULL, &vFactorSizes, &numSubRanges);
		//
		// nNumData (passed to the function by ref) must remain what it was set to at the top of this
		// function (i.e. when taking ointo account combine bits).
		// So, here just introduce another scoped variable with the same name to hold the value on stack
		// for the case when combine bits are ignored.
		/// Iris 4/24/06 NEED_OVERLOAD_GETNUMDATA_FOR_ROC
		//int		nNumData = dr.GetNumData(dwRules, trAdditionalData, NULL, &vFactorSizes, &numSubRanges);
		int		nNumData = GetNumData(trOp, dr, trAdditionalData, NULL, &vFactorSizes, &numSubRanges);
		/// End NEED_OVERLOAD_GETNUMDATA_FOR_ROC
		/// end CORRECT_NUM_DATA_WHEN_COMBINED
		for(ii = 0; ii < nNumData; ii++)
		{
			/// ML 4/14/2005 DATARANGE_GETTING_FACTORS_VALUES
			dr.GetFactorsValues(dwRules, ii, &vstrFactors);
			/// end DATARANGE_GETTING_FACTORS_VALUES			
			UpdateDataSourceInReportingHeader(trOp, vstrFactors, wksData, ii, numSubRanges, dwRules);
			///Arvin 12/07/06 ROCCURVE_NEED_MASKED_AND_MISSING_DATA_TABLE
			//TreeNode tnCreate = trOp.GUI.Output.Create;
			//if(tnCreate)
			//{
			//	if(tnCreate.MaskedData /*&& tnCreate.MaskedData.nVal*/)///Arvin 11/08/06 MASKEDDATA_AND_MISSINGDATA_TABLES_SHOULD_ALWAYS_HAVE_ATTRIBUTE
			//		UpdateMaskedOrMissingDataTables(trOp, dr, vstrFactors, ii, nNumData, numSubRanges, dwRules, false);
			//	if(tnCreate.MissingData /*&& tnCreate.MissingData.nVal*/)///Arvin 11/08/06 MASKEDDATA_AND_MISSINGDATA_TABLES_SHOULD_ALWAYS_HAVE_ATTRIBUTE
			//		UpdateMaskedOrMissingDataTables(trOp, dr, vstrFactors, ii, nNumData, numSubRanges, dwRules, true);
			//}
			///------
		}
///---Sim 06-17-2009 QA80-13786-P2-P4 SPEEP_UP_LINEAR_FIT_WITHOUT_REPORT_TABLE
#ifdef __SPEED_UP_FIT_WITHOUT_REPORT_TABLE__
		if ( IsNeedReportTable(trOp) )
#endif // __SPEED_UP_FIT_WITHOUT_REPORT_TABLE__
///---END QA80-13786-P2-P4 SPEEP_UP_LINEAR_FIT_WITHOUT_REPORT_TABLE
			///Arvin 12/07/06 ROCCURVE_NEED_MASKED_AND_MISSING_DATA_TABLE
			{
				/// Iris 11/09/2009 QA81-14599 IMPROVE_STATS_ON_COLS_CALCULATION_SPEED
				if( 0 != OP_GUI_OUTPUT_TABLES_BRANCH(trOp.GUI).MissingData.nVal + OP_GUI_OUTPUT_TABLES_BRANCH(trOp.GUI).MaskedData.nVal )
				///end IMPROVE_STATS_ON_COLS_CALCULATION_SPEED
				{
					UpdateMaskedAndMissingDataTables(trOp, trAdditionalData, dr, vFactorSizes, vstrFactors, numSubRanges, dwRules);
				}
			}
			///end ROCCURVE_NEED_MASKED_AND_MISSING_DATA_TABLE
	}
	//---
	return true;
}
/// end NLFITTER_OPERATION_IMPLEMENTATION

///Arvin 12/07/06 ROCCURVE_NEED_MASKED_AND_MISSING_DATA_TABLE
void WksReportOperation::UpdateMaskedAndMissingDataTables(TreeNode& trOp, TreeNode&	trAdditionalData, DataRange& dr, vector<int>& vFactorSizes, vector<string> &vstrFactors, int numSubRanges, DWORD dwRules)
{
	int		nNumData = GetNumData(trOp, dr, trAdditionalData, NULL, &vFactorSizes, &numSubRanges);
	///Arvin 01/23/06 MASKED_OR_MISSING_DATA_TABLE_INCOMPLETE_CONCATENATE
	///Arvin 08/27/07 MASKED_AND_MISSING_DATA_TABLE_INCOMPLETE_CONSOLIDATED
	//int nDataMode = trOp.GUI.InputData.Use;
	//if(nDataMode == DATA_MODE_CONCATENATE)
	if(tree_get_oper_multidata_modes(trOp.GUI) == MDINPUT_CMBND_SIMPLE)
	///end 	MASKED_AND_MISSING_DATA_TABLE_INCOMPLETE_CONSOLIDATED
		nNumData = numSubRanges;
	///end MASKED_OR_MISSING_DATA_TABLE_INCOMPLETE_CONCATENATE
	
	///Sophy 10/17/2008 QA80-12000 SHOULD_UPDATE_MASKED_AND_MISSING_DATA_STATS_ON_RECALCULATE
	SetHasMissingData( false ); //reset status before detecting missing and masked data
	SetHasMaskedData( false );
	///end SHOULD_UPDATE_MASKED_AND_MISSING_DATA_STATS_ON_RECALCULATE
	for(int ii = 0; ii < nNumData; ii++)
	{
		string		strDataLabel;
		GetEscapedMainDataString(trOp, strDataLabel, ii+1, true);
		dr.GetFactorsValues(dwRules, ii, &vstrFactors);
		/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//TreeNode tnCreate = trOp.GUI.Output.Create;
		TreeNode tnCreate = OP_GUI_OUTPUT_TABLES_BRANCH(trOp.GUI);
		///end OP_DLG_NEW_STRUCTURE
		if(tnCreate)
		{
			if(tnCreate.MaskedData /*&& tnCreate.MaskedData.nVal*/)///Arvin 11/08/06 MASKEDDATA_AND_MISSINGDATA_TABLES_SHOULD_ALWAYS_HAVE_ATTRIBUTE
			{
				///Cheney 2007-4-12 ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA
				//UpdateMaskedOrMissingDataTables(trOp, dr, vstrFactors, ii, nNumData, numSubRanges, dwRules, strDataLabel, false);
				bool bHasMasked = false;
				UpdateMaskedOrMissingDataTables(trOp, dr, vstrFactors, ii, nNumData, numSubRanges, dwRules, strDataLabel, false, bHasMasked);
				if(bHasMasked)
					SetHasMaskedData(true);
				///end ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA
			}
			if(tnCreate.MissingData /*&& tnCreate.MissingData.nVal*/)///Arvin 11/08/06 MASKEDDATA_AND_MISSINGDATA_TABLES_SHOULD_ALWAYS_HAVE_ATTRIBUTE
			{
				///Cheney 2007-4-12 ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA
				//UpdateMaskedOrMissingDataTables(trOp, dr, vstrFactors, ii, nNumData, numSubRanges, dwRules, strDataLabel, true);
				bool bHasMissing = false;
				UpdateMaskedOrMissingDataTables(trOp, dr, vstrFactors, ii, nNumData, numSubRanges, dwRules, strDataLabel, true, bHasMissing);
				if(bHasMissing)
					SetHasMissingData(true);
				///end ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA
			}
		}	
	}
}
///end ROCCURVE_NEED_MASKED_AND_MISSING_DATA_TABLE

static void _hide_empty_node(TreeNode tr)
{
	if(tr)
	{
		tr.Show = 0;
		octree_set_attribute_bit_if_not_empty(&tr, STR_SHOW_ATTRIB, 1);
		if(tr.Show)
			tr.RemoveAttribute(STR_SHOW_ATTRIB);
	}
}
//----- CPY 7/18/06 TREE_SET_ATTRIB_BITS_CLEANUP
void hide_empty_table(TreeNode &tr)
{
	foreach(TreeNode trTable in tr.Children)
	{
		if(trTable.Show == 0)// if table already hidden, don't touch it
			continue;
		_hide_empty_node(trTable);
	}
}
//----- end TREE_SET_ATTRIB_BITS_CLEANUP

//---- CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
/// YuI 10/11/06 USE_CLONE_OF_CALCULATIONS_TO_GENERATE_REPORT
/*
void Operation::FilterReport(TreeNode& trOp)		
{
	foreach(TreeNode trSubNode in trOp.Calculation.Children)
	{
		if(is_in_ids_range(trSubNode, IDST_FIT_CURVES, IDST_FIT_CURVES_END))
			trSubNode.Show = false;
	}
	///Joe  7/17/06 HIDE_EMPTY_TABLE 
	//_hide_empty_node(trOp.Calculation.MissingData);
	//_hide_empty_node(trOp.Calculation.MaskedData);
	hide_empty_table(trOp.Calculation);//----- CPY 7/18/06 TREE_SET_ATTRIB_BITS_CLEANUP
	///End HIDE_EMPTY_TABLE 
	
	// del all hidden, as Roman change to support update by complete del of old tables 
	TreeNode trCalc = trOp.Calculation;
	octree_delete_nodes_by_attribute(&trCalc, STR_SHOW_ATTRIB, false);

}
*/

///----- CPY 3/31/2007 NLFIT_REPORT_FROM_OC
static void _hide_table_in_id_range(TreeNode& tr, int n1, int n2, bool bRecursive = true)
{
	foreach(TreeNode trSubNode in tr.Children)
	{
		if(trSubNode.GetNodeCount() == 0)
			continue;
		if(is_in_ids_range(trSubNode, n1, n2))
			trSubNode.Show = false;
		
		_hide_table_in_id_range(trSubNode, n1, n2);
	}
}

void WksReportOperation::FilterReportForExternal(TreeNode& trOp)
{
	TreeNode		trCalc = trOp.Calculation;
	trCalc.RemoveAttribute(TREE_REPLACE);
	//trCalc.RemoveChild("GraphInfo");	// need to talk to Iris to see why is this in this place, as it should not be in calculation branch since it is a control branch
	// remove all the fit curves
	_hide_table_in_id_range(trCalc, IDST_FIT_CURVES, IDST_FIT_CURVES_END);
	// remove all the graphs
	_hide_table_in_id_range(trCalc, IDST_RESULT_GRAPHS, IDST_RESULT_GRAPHS + GetNumGraphs()); 
	hide_empty_table(trCalc);
	octree_delete_nodes_by_attribute(&trCalc, STR_SHOW_ATTRIB, false);
}

/// YuI 10/11/06 USE_CLONE_OF_CALCULATIONS_TO_GENERATE_REPORT
//	void WksReportOperation::FilterReport(TreeNode& trCalc)	
/// Iris 9/10/2009 QA80-14279 KEEP_MISSING_DATA_TABLE_EVENT_EMPTY
//void WksReportOperation::filterReport(TreeNode& trCalc, BOOL bCheckIDRange)
/// Hong 12/11/09 QA80-14138-P2 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
//void WksReportOperation::filterReport(TreeNode& trCalc, BOOL bCheckIDRange, BOOL bHierarchy)		
void WksReportOperation::filterReport(TreeNode& trCalc, BOOL bCheckIDRange, BOOL bHierarchy, bool bReservedTableNode/* = false*/)
/// end FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
///end KEEP_MISSING_DATA_TABLE_EVENT_EMPTY
/// end USE_CLONE_OF_CALCULATIONS_TO_GENERATE_REPORT
{
	if( bCheckIDRange )
	{
		if( !bHierarchy ) /// Iris 9/10/2009 QA80-14279 KEEP_MISSING_DATA_TABLE_EVENT_EMPTY
		{
			foreach(TreeNode trSubNode in trCalc.Children)
			{
				if(is_in_ids_range(trSubNode, IDST_FIT_CURVES, IDST_FIT_CURVES_END))
					trSubNode.Show = false;
			}
			hide_empty_table(trCalc);
		}
	}
	
	/// ML 12/7/2007 QA70-10780 MORE_DEBUGGING_REPORT_FILTERING
	//octree_delete_nodes_by_attribute(&trCalc, STR_SHOW_ATTRIB, false);
	/// Hong 12/11/09 QA80-14138-P2 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
	//int			nn = octree_delete_nodes_by_attribute(&trCalc, STR_SHOW_ATTRIB, false);
	LPCSTR		lpcsz = NULL;
	if ( bReservedTableNode )
		lpcsz = TREE_Table;
	int			nn = octree_delete_nodes_by_attribute(&trCalc, STR_SHOW_ATTRIB, false, true, lpcsz);
	/// end FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
	// nn contains the total number of removed nodes. It is negative if failure
	if (nn < 0)
	{
		string		strErr;
		strErr.Format("FilterReport err = %d", nn);
		error_report(strErr);
	}
	/// end MORE_DEBUGGING_REPORT_FILTERING
	
	/// Iris 4/16/2008 QA80-11282 FIX_ANOVA_ONE_WAY_REPORT_EMPTY_CURVE_SHEET
	// In anova one way if only plot Box Chart, trResultCurve's sub nodes are hidden and will be remove above, now need to hide empty Data1, Data2... nodes and then delete
	/// Iris 9/10/2009 QA80-14279 KEEP_MISSING_DATA_TABLE_EVENT_EMPTY
	//if( !AllowReportEmptyResultCurve() ) /// Iris 4/23/2008 FIX_NO_FIND_XY_REPORT
	if( !bHierarchy && !AllowReportEmptyResultCurve() )
	///end KEEP_MISSING_DATA_TABLE_EVENT_EMPTY
	{
		hide_empty_table(trCalc); 
		octree_delete_nodes_by_attribute(&trCalc, STR_SHOW_ATTRIB, false);
	}
	///end FIX_ANOVA_ONE_WAY_REPORT_EMPTY_CURVE_SHEET
	
}
/// end YuI 10/11/06
#define MAX_GRAPH_NODES_IN_REPORT 12 //--- CPY 10/19/05 TEMP_SOLUTION_TO_FIX_RESULTS_LOG_JUNK


//-----
//virtual 
//void WksReportOperation::FilterReportForStrDump(TreeNode& trOp) //CPY 9/2/04
void WksReportOperation::filterReportForStrDump(TreeNode& trOp, int nTotalNumData) ///Iris 4/14/05
{
	/// Iris 3/31/06 COMMENTED_NO_USEFUL_FILTER_FOR_STR_DUMP_CODES
	/////Iris 01/03/05 SET_GRAPH_HIDDEN_FOR_STRDUMP
	//int index = 0;
	//while(1)
	//{
		//TreeNode trGraph = trOp.Calculation.GetNode(op_get_graph_tag_name(index++));
		//if(trGraph)
			//trGraph.Show = false;
		//else
			//break;
	//}
	/////end SET_GRAPH_HIDDEN_FOR_STRDUMP
	/// End COMMENTED_NO_USEFUL_FILTER_FOR_STR_DUMP_CODES
	
	//------ CPY 10/19/05 TEMP_SOLUTION_TO_FIX_RESULTS_LOG_JUNK
	for(int ii = 0; ii < MAX_GRAPH_NODES_IN_REPORT; ii++)
	{
		TreeNode trGraph = trOp.Calculation.GetNode(op_get_graph_tag_name(ii));
		if(trGraph)
		{
			/// Iris 3/31/06 COMMENTED_NO_USEFUL_FILTER_FOR_STR_DUMP_CODES
			//if(trGraph.Show != 0)
			//{
				/// Iris 3/31/06 COMMENTED_NO_USEFUL_CODES
				//string strErr;
				//strErr.Format("FilterReportForStrDump found node %s not set to hidden", trGraph.tagName);
				//error_report(strErr);
				//trGraph.Show = false;
			//}
			trGraph.Show = false;
			/// End COMMENTED_NO_USEFUL_FILTER_FOR_STR_DUMP_CODES
		}
	}
	//------ end TEMP_SOLUTION_TO_FIX_RESULTS_LOG_JUNK
	
	if(trOp.Calculation.BinWks)
		trOp.Calculation.BinWks.Show = false;
	
	///Kevin 10/09/05 REMOVE_CUSTOM_TABLE_FROM_RESULT_LOG
	if(trOp.Calculation.Custom1)
		trOp.Calculation.Custom1.Show = false;
	///End REMOVE_CUSTOM_TABLE_FROM_RESULT_LOG
	
	
	/// Iris 3/31/06 COMMENTED_NO_USEFUL_FILTER_FOR_STR_DUMP_CODES
	/////Iris 4/07/05 FIT_REGRESSION_PLOTS
	///*
	//if(trOp.Calculation.FitCurves)
		//trOp.Calculation.FitCurves.Show = false;
	//if(trOp.Calculation.Residuals)
		//trOp.Calculation.Residuals.Show = false;
	//if(trOp.Calculation.ResidualsFit)
		//trOp.Calculation.ResidualsFit.Show = false;
	//if(trOp.Calculation.ResidualsOrder)
		//trOp.Calculation.ResidualsOrder.Show = false;	
	//*/
	//foreach(TreeNode trSubNode in trOp.Calculation.Children)
	//{		
		//if(is_in_ids_range(trSubNode, IDST_FIT_CURVES, IDST_FIT_CURVES_END, nTotalNumData))
			//trSubNode.Show = false;
	//}	
	/////end FIT_REGRESSION_PLOTS
	///End COMMENTED_NO_USEFUL_FILTER_FOR_STR_DUMP_CODES
	
	//---CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
	// we will always do this
	//
	//_hide_empty_node(trOp.Calculation.MissingData);
	//_hide_empty_node(trOp.Calculation.MaskedData);
	//---
	///Arvin 10/20/06 INPUT_DATA_TABLE_GIBBERISH_WHEN_RECALCULATION_IS_NONE 
	/*	
	/// ML 9/14/2004 QA70-6825 ESCAPED_OP_STRING_CONVERSION_OC
	ConvertEscapedStrings(trOp.Calculation);
	/// end ESCAPED_OP_STRING_CONVERSION_OC
	*/
	TreeNode trAutoUpdate = trOp.Operation.AutoUpdate;
	if(trAutoUpdate)
	{
		if(trAutoUpdate.nVal != AU_NONE)
			ConvertEscapedStrings(trOp.Calculation);
	}
	///END INPUT_DATA_TABLE_GIBBERISH_WHEN_RECALCULATION_IS_NONE
}

//virtual 
void WksReportOperation::filterReportForResultsLog(TreeNode& trOp) //CPY 8/4/04
{
	trOp.Calculation.SetAttribute(TREE_Table, GetTableStringMainResultsLog());
	///Iris 4/05/05 CLEANUP_GETTING_GRAPH_NODE
	//---- CPY 11/3/04	QA70-7122 ADD_BOX_CHART_TO_DESC_STATS
	//TreeNode trGraph = trOp.Calculation.Graphs;
	//TreeNode trGraph = trOp.Calculation.Graph;
	TreeNodeCollection trColl(trOp.Calculation, "Graph");
	//----
	///end CLEANUP_GETTING_GRAPH_NODE
	
	///Iris 4/05/05 CLEANUP_GETTING_GRAPH_NODE
	//if(trGraph)
	if( trColl.Count() ) ///---
	{
		// Marko said ok to show graph
		//trGraph.Show = false;
	}
	else
		error_report("filterReportForResultsLog found no graph branch");
}

/// ML 1/9/2007 INPUT_DATA_TBL_MR_MULTI_INDEPS
///// ML 10/26/2005 QA70-8225 ESCAPED_OPER_STRINGS_ANOVAS
////TreeNode	WksReportOperation::AddOneInputDataTableCell(TreeNode &trRow, LPCSTR lpcszLabel, int indexLT, BOOL bSubRange, char cType, char cXYW)
//TreeNode	WksReportOperation::AddOneInputDataTableCell(TreeNode &trRow, LPCSTR lpcszLabel, int indexLT, BOOL bSubRange, char cType, char cXYW, char chDataFactSubj)
///// end ESCAPED_OPER_STRINGS_ANOVAS
TreeNode	WksReportOperation::AddOneInputDataTableCell(TreeNode &trRow, LPCSTR lpcszLabel, int indexLT, BOOL bSubRange, char cType, char cXYW, char chDataFactSubj, int nSecondNum)
/// end INPUT_DATA_TBL_MR_MULTI_INDEPS
{
	string		strTagName;
	//------- CPY 10/27/04 DESC_STATS_AND_LR_SEE_INPUT_DATA_NODE_WITHOUT_ID
	//	//	strTagName.Format("%c", cXYW);
	//	if( cType == 'R' )
	//		strTagName.Format("%c_Excel", cXYW);
	//	else
	//		strTagName.Format("%c", cXYW);
	int ncMain = cXYW> 0? cXYW : 'D'; // Data Table tagName for Col in table
	if( cType == 'R' )
		strTagName.Format("%c_Excel", ncMain);
	else
		strTagName.Format("%c", ncMain);
	//------- end 
	/// ML 1/9/2007 INPUT_DATA_TBL_MR_MULTI_INDEPS
	if (1 < nSecondNum)
		strTagName += nSecondNum;
	/// end INPUT_DATA_TBL_MR_MULTI_INDEPS
	
	int			nNodeID = 0;
	switch (cXYW)
	{
	case 'X':
		/// ML 1/9/2007 INPUT_DATA_TBL_MR_MULTI_INDEPS
		//if( cType == 'P' )
		//	nNodeID = IDE_INPUT_X;
		//else
		//	nNodeID = IDE_INPUT_X_EXCEL;
		if (nSecondNum <= 1)
		{
		if( cType == 'P' )
			nNodeID = IDE_INPUT_X;
		else
			nNodeID = IDE_INPUT_X_EXCEL;
		}
		else
		{
			if( cType == 'P' )
				nNodeID = IDST_REPORT_INPUT_DATA_MULTIX_BEGIN + nSecondNum - 2;
			else
				nNodeID = IDST_REPORT_INPUT_DATA_MULTIX_EXCEL_BEGIN + nSecondNum - 2;
		}
		/// end INPUT_DATA_TBL_MR_MULTI_INDEPS
		break;
		
	case 'R':
		nNodeID = IDE_INPUT_RANGE;
		break;
		
	case 'Y':
		/// ML 11/8/2005 QA70-8135 Z_IN_REPORT_TABELS
		//// fall through
		if( cType == 'P' )
			nNodeID = IDE_INPUT_YINDEP;
		else
			nNodeID = IDE_INPUT_YINDEP_EXCEL;
		break;
		/// end Z_IN_REPORT_TABELS
	///Arvin 08/17/07 ADD_WEIGHT_DATA_TABLE_IN_INPUT_DATA_TABLE
	case 'W':
		nNodeID = IDE_INPUT_WEIGHT;
		break;
	///end 	ADD_WEIGHT_DATA_TABLE_IN_INPUT_DATA_TABLE
	///Kyle 03/31/2009 QA80-3224 NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR
	case 'T':
		nNodeID = IDE_INPUT_X_ERROR;
		break;
	///End NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR
	default:
		/// ML 11/8/2005 QA70-8135 Z_IN_REPORT_TABELS
		//if( cType == 'P' )
		//	nNodeID = IDE_INPUT_Y;
		//else
		//	nNodeID = IDE_INPUT_Y_EXCEL;
		if( cType == 'P' )
			nNodeID = IDE_INPUT_MAIN;
		else
			nNodeID = IDE_INPUT_MAIN_EXCEL;
		/// end Z_IN_REPORT_TABELS
	}
	
	/// ML 11/8/2005 QA70-8135 Z_IN_REPORT_TABELS
	//if ('X' != cXYW)
	///Arvin 08/17/07 ADD_WEIGHT_DATA_TABLE_IN_INPUT_DATA_TABLE
	//if ('X' != cXYW && 'Y' != cXYW)
	///Kyle 03/31/2009 QA80-3224 NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR
	//if ('X' != cXYW && 'Y' != cXYW && 'W' != cXYW)
	if ('X' != cXYW && 'Y' != cXYW && 'W' != cXYW && 'T' != cXYW)	// 'T' for X Error
	///End NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR
	///end 	ADD_WEIGHT_DATA_TABLE_IN_INPUT_DATA_TABLE
	/// end Z_IN_REPORT_TABELS
		cXYW = 0;
	
	string		strValue;
	/// ML 1/9/2007 INPUT_DATA_TBL_MR_MULTI_INDEPS
	///// ML 10/26/2005 QA70-8225 ESCAPED_OPER_STRINGS_ANOVAS
	////getEscapedDataString(strValue, indexLT, bSubRange, cType, cXYW);
	//getEscapedDataString(strValue, indexLT, bSubRange, cType, cXYW, ESC_LABEL_ADD_NONE, chDataFactSubj);
	///// end ESCAPED_OPER_STRINGS_ANOVAS
	///Cheney 2007-1-30 MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC
	//getEscapedDataString(strValue, indexLT, bSubRange, cType, cXYW, ESC_LABEL_ADD_NONE, chDataFactSubj, nSecondNum);
	report_get_escaped_data_string(&strValue, indexLT, bSubRange, cType, cXYW, ESC_LABEL_ADD_NONE, chDataFactSubj, nSecondNum);
	///end MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC
	/// end INPUT_DATA_TBL_MR_MULTI_INDEPS
	
	TreeNode	trCol = tree_check_get_node(trRow, strTagName, nNodeID,  STR_LABEL_ATTRIB, lpcszLabel);
	trCol.strVal = strValue;
	
	//------- CPY 10/27/04 DESC_STATS_AND_LR_SEE_INPUT_DATA_NODE_WITHOUT_ID
	//return TRUE;
	return trCol;
	//-------
}

void	WksReportOperation::GetEscapedMainDataString(TreeNode &trOp, string &str, int indexLT, bool bInputTable, char cType, char cXYW)// = false  = 0  = 0
{
	DWORD			dwRules = GetDataRules(trOp);
	dwRules &= DRR_COMBINED_MASK;		// is it combined?
	if (dwRules)
	{
		getCombinedString(str, dwRules);
		return;
	}
	int nAddtional =  ESC_LABEL_ADD_NONE;//ESC_LABEL_ADD_INDEX;
	if(trOp.MultiRanges)
	{
		int nIndex = indexLT - 1;
		vector<int> vnMRindeces;
		vnMRindeces = trOp.MultiRanges.nVals;
		if(vnMRindeces[nIndex] > 0)
			nAddtional = MAKELONG(ESC_LABEL_ADD_INDEX, vnMRindeces[nIndex]);
	}
	///Cheney 2007-1-30 MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC		
	//getEscapedDataString(str, indexLT, FALSE, cType, cXYW, nAddtional);
	report_get_escaped_data_string(&str, indexLT, FALSE, cType, cXYW, nAddtional);
	///end MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC
}

//virtual 
bool	WksReportOperation::OnBeforeCalcMultiDataLoop(TreeNode& trOp, const DataRange& drInput, int nTotalNumData, vector<int>& vFactorSizes)
{
	//--- CPY 8/5/05 FITNL_LAST_USED
	if(nTotalNumData <1)
		return error_report("OnBeforeCalcMultiDataLoop found no input data");
	//---
	if(trOp.MultiRanges)
		trOp.MultiRanges.Remove();
	
	if(nTotalNumData > 1 && vFactorSizes.GetSize() == 0)
	{
		vector<string> vs;
		DWORD dwRules = GetDataRules(trOp);
		///Arvin 11/10/06 STATS_ON_ROWS_FAILED_WHEN_COL_NUMBER_LESS_THAN_ROW_NUMBER
		if(DRR_BY_ROWS & dwRules)
		{
			dwRules &= ~DRR_BY_ROWS;
			nTotalNumData = drInput.GetNumData(dwRules);
		}
		///END STATS_ON_ROWS_FAILED_WHEN_COL_NUMBER_LESS_THAN_ROW_NUMBER	
		for(int ii = 0; ii < nTotalNumData; ii++)
		{
			string str;
			int	nRet = drInput.GetData(dwRules, ii, &str);
			vs.Add(str);
		}
		vector<int> vnCounts;
		if(count_list(vs, vnCounts))
		{
			trOp.MultiRanges.nVals = vnCounts;
		}
		
	}
	return true;
}
//	virtual 
void	WksReportOperation::OnAfterCalculations(TreeNode& trOp)
{
	if(trOp.MultiRanges)
		trOp.MultiRanges.Remove();

	/// YuI 10/12/07 QA70-10529 DATA_MARKERS_REVAMP
	/*
	/// YuI 04/17/07 QA70-4589 IMPROVED_ANALYSIS_MARKERS
	DataRange drTempInput;
	if( GetInput(drTempInput) )
		okutil_destroy_data_markers(&drTempInput);
	/// end IMPROVED_ANALYSIS_MARKERS
	*/
	
	TreeNode trInputData = trOp.GUI.InputData;
	if( trInputData )
	{
		/// YuI 02/10/09 QA70-13062 NEED_TO_KEEP_DATA_MARKERS_IF_NO_ANALYSIS_MARKERS_CREATED
		//	okutil_destroy_input_data_markers(&trInputData);
		okutil_destroy_input_data_markers(&trInputData, TRUE);
		/// end NEED_TO_KEEP_DATA_MARKERS_IF_NO_ANALYSIS_MARKERS_CREATED
	}
	/// end DATA_MARKERS_REVAMP	
}

///Cheney 2007-4-3 REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
TreeNode WksReportOperation::AddReportInputTable(TreeNode &trInputTable, const vector<string> &vstrFactors, int index)
{
	int		indexLT = index + 1;
	//string	strDataLabel, strRange;
	string	strDataLabel;
	TreeNode	trCalc = trInputTable.Parent();
	TreeNode	trOp = trCalc.Parent();
	//set numX to m_nNumberDepVariables
	int			numX = GetNumX(trOp);
	GetEscapedMainDataString(trOp, strDataLabel, indexLT, true);
	//GetEscapedMainDataString(strRange, indexLT, 'P', cXYMain);
	//---------- CPY ML 8/18/2004 QA70-6825 RLOG_QUERY
	//TreeNode trInput = check_add_enumerated_node(trInputTable, "C", indexLT, IDST_REPORT_INPUT_ONE_SET + index, STR_LABEL_ATTRIB, strDataLabel);
	/// Iris 04/02/2009 FIX_1ST_COL_EMPTY_IF_CREATE_COPY_INPUT_DATA_TABLE_AS_NEW_SHEET_IN_TWO_WAY_ANOVA_RAW_DATA_TYPE
	//TreeNode trInput = check_add_enumerated_node(trInputTable, "C", indexLT, make_one_set_ID(IDST_REPORT_INPUT_ONE_SET, index), STR_LABEL_ATTRIB, /*strDataLabel*/NULL); ///Arvin 01/11/06 WRONG_DATA_LABEL changed by Max's suggestion
	string strLabel;
	if(vstrFactors.GetSize())
	{
		strLabel = vstrFactors[0];
		vstrFactors.RemoveAt(0);
	}
	TreeNode trInput = check_add_enumerated_node(trInputTable, "C", indexLT, make_one_set_ID(IDST_REPORT_INPUT_ONE_SET, index), STR_LABEL_ATTRIB, strLabel);
	///end FIX_1ST_COL_EMPTY_IF_CREATE_COPY_INPUT_DATA_TABLE_AS_NEW_SHEET_IN_TWO_WAY_ANOVA_RAW_DATA_TYPE
	//----------
	tree_add_more_labels(trInput, vstrFactors);

	return trInput;
}
///end REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX

///Cheney 2007-4-3 REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
//TreeNode WksReportOperation::AddXDataSourceToReportInputTable(TreeNode &trInputTable, const vector<string> &vstrFactors, int index, LPCSTR lpcszXLabel, char cXYMain, int numSubRanges, DWORD dwRules)// = NUL = 0L = 0 = 0
TreeNode WksReportOperation::AddXDataSourceToReportInputTable(TreeNode &trInputTable, int index, LPCSTR lpcszXLabel, char cXYMain, int numSubRanges, DWORD dwRules)// = NUL = 0L = 0 = 0
///end REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
{
	int		indexLT = index + 1;
	///Cheney 2007-4-3 REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
	////string	strDataLabel, strRange;
	//string	strDataLabel;
	///end REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
	///Arvin 06/20/07 v8.0645 WRONG_NUMBER_X_CELL_IN_INPUT_DATA_TABLE_FOR_SURFACE_FIT
	//Chenny has changed trInputTable to subnode of original node
	//TreeNode	trCalc = trInputTable.Parent();
	//TreeNode	trOp = trCalc.Parent();
	TreeNode	trInput = trInputTable.Parent();
	TreeNode	trCalc = trInput.Parent();
	TreeNode	trOp = trCalc.Parent();
	///end WRONG_NUMBER_X_CELL_IN_INPUT_DATA_TABLE_FOR_SURFACE_FIT
	///Cheney 2007-4-3 REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
	//GetEscapedMainDataString(trOp, strDataLabel, indexLT, true);
	////GetEscapedMainDataString(strRange, indexLT, 'P', cXYMain);
	////---------- CPY ML 8/18/2004 QA70-6825 RLOG_QUERY
	////TreeNode trInput = check_add_enumerated_node(trInputTable, "C", indexLT, IDST_REPORT_INPUT_ONE_SET + index, STR_LABEL_ATTRIB, strDataLabel);
	//TreeNode trInput = check_add_enumerated_node(trInputTable, "C", indexLT, make_one_set_ID(IDST_REPORT_INPUT_ONE_SET, index), STR_LABEL_ATTRIB, /*strDataLabel*/NULL); ///Arvin 01/11/06 WRONG_DATA_LABEL changed by Max's suggestion
	////----------
	//tree_add_more_labels(trInput, vstrFactors);
	///end REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
	string strXLabel = lpcszXLabel;
	if(strXLabel.IsEmpty())
		///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS
		//strXLabel = "Data Range";
		strXLabel = _LE("Data Range");
		///end CLEAN_UP_LOCALIZATION_THINGS
	//TreeNode trX = tree_check_get_node(trInput, "X", IDE_INPUT_X,  STR_LABEL_ATTRIB, strXLabel); 
	//trX.strVal = strRange;
	
	/// ML 1/9/2007 INPUT_DATA_TBL_MR_MULTI_INDEPS
	//AddOneInputDataTableCell(trInput, strXLabel, indexLT, FALSE, 'P', cXYMain);
	//
	//// X excel formatted string
	//TreeNode trCol = AddOneInputDataTableCell(trInput, strXLabel, indexLT, FALSE, 'R', cXYMain);
	//if(trCol)
	//	trCol.Show = false;
	//
	//
	/// Iris 01/17/2007 v8.0543 FIX_SURFACE_FIT_RUNTIME_ERR
	//int			numX = GetNumX(NULL);
	//Cheney add comment: m_nNumberDepVariables already set in WksReportOperation::AddReportInputTable
	//here to get
	int			numX = GetNumX(trOp);
	///Arvin 06/20/07 v8.0645 WRONG_NUMBER_X_CELL_IN_INPUT_DATA_TABLE_FOR_SURFACE_FIT
	//Surface fit only has one X, but GetNumX returns its independent variable number
	if(HasZ(trOp))
		numX = 1;
	///end WRONG_NUMBER_X_CELL_IN_INPUT_DATA_TABLE_FOR_SURFACE_FIT
	///end FIX_SURFACE_FIT_RUNTIME_ERR
	string		strXLabelUse;
	for (int iX = 0; iX < numX; iX++)
	{
		if (1 < numX)
			strXLabelUse.Format("%s %u", strXLabel, iX + 1);
		else
			strXLabelUse = strXLabel;
		///Cheney 2007-4-3 REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
		//AddOneInputDataTableCell(trInput, strXLabelUse, indexLT, FALSE, 'P', cXYMain, 0, iX + 1);
		//
		//// X excel formatted string
		//TreeNode trCol = AddOneInputDataTableCell(trInput, strXLabelUse, indexLT, FALSE, 'R', cXYMain, 0, iX + 1);
		AddOneInputDataTableCell(trInputTable, strXLabelUse, indexLT, FALSE, 'P', cXYMain, 0, iX + 1);
		
		// X excel formatted string
		TreeNode trCol = AddOneInputDataTableCell(trInputTable, strXLabelUse, indexLT, FALSE, 'R', cXYMain, 0, iX + 1);

		///end REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
		if(trCol)
			trCol.Show = false;	
	}
	/// end INPUT_DATA_TBL_MR_MULTI_INDEPS
	///Cheney 2007-4-3 REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
	//return trInput;
	return trInputTable;
	///end REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
}

//---
///Cheney 2007-1-30 MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC
///// ML 10/26/2005 QA70-8225 ESCAPED_OPER_STRINGS_ANOVAS
////void	Operation::getEscapedDataString(string &str, int nIndexLT, BOOL bSubRange, char cType, char cXYW, int nAddtional) // = FALSE, = 'A', = 0,  = ESC_LABEL_ADD_NONE
///// ML 9/1/2006 NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL
////void	Operation::getEscapedDataString(string &str, int nIndexLT, BOOL bSubRange, char cType, char cXYW, int nAddtional, char chDataFactSubj) // = FALSE, = 'A', = 0,  = ESC_LABEL_ADD_NONE, =0
//void	WksReportOperation::getEscapedDataString(string &str, int nIndexLT, BOOL bSubRange, char cType, char cXYW, int nAddtional, char chDataFactSubj, int nSecondNum) // = FALSE, = 'A', = 0,  = ESC_LABEL_ADD_NONE, =0, =0
///// end NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL
///// end ESCAPED_OPER_STRINGS_ANOVAS
//{
	//string strMainkey;
	//if(cType)
		//strMainkey = cType;
	//else
		//strMainkey = "A"; // auto
		//
	//if(nAddtional > ESC_LABEL_ADD_NONE)
	//{
		//switch(LOWORD(nAddtional))
		//{
		//case ESC_LABEL_ADD_RANGE:
			//strMainkey += " G";
			//break;
		//case ESC_LABEL_ADD_INDEX:
			//strMainkey += " (" + (string)HIWORD(nAddtional) + ")";
			//break;
		//}
	//}
		//
	///// ML 10/26/2005 QA70-8225 ESCAPED_OPER_STRINGS_ANOVAS
	//if (chDataFactSubj)
		//str.Format("%s%s=%c%d", OPERATION_ESCAPE_STRING_PREFIX, strMainkey, chDataFactSubj, nIndexLT);
	//else
	///// end ESCAPED_OPER_STRINGS_ANOVAS
	//if ( bSubRange )
		//str.Format("%s%s=.%d", OPERATION_ESCAPE_STRING_PREFIX, strMainkey, nIndexLT);
	//else
		//str.Format("%s%s=%d", OPERATION_ESCAPE_STRING_PREFIX, strMainkey, nIndexLT);
	//
	//if(cXYW)
	//{
		//string strTemp(cXYW);
		//str += strTemp;
		//
		///// ML 9/1/2006 NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL
		//if (0 < nSecondNum)
			//str += nSecondNum;
		///// end NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL
	//}
//}
///end MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC


// virtual
BOOL	WksReportOperation::GetCustomTableThemeClassName(string &strThemeClassName, int nCustomIndex)
{
	strThemeClassName.Format("%s__%d", GetClassName(), GetCustomTableID(nCustomIndex));
	return TRUE;
}


/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
//int		Operation::getCustomTableID(int nCustomIndex)
//{
//	return IDST_REPORT_CUSTOM_TABLE1 + nCustomIndex;
//}
int		WksReportOperation::GetCustomTableID(int nCustomIndex, int nAuxIndex)
{
	if (1 == nCustomIndex || 2 == nCustomIndex)		// indices 1 and 2 are reserved for variable numbers of custom tables
	{
		ASSERT(0 <= nAuxIndex);
		return 1 == nCustomIndex ? (IDST_REPORT_CUSTOM_TABLE2_BEGIN + nAuxIndex) : (IDST_REPORT_CUSTOM_TABLE3_BEGIN + nAuxIndex);
	}

	return IDST_REPORT_CUSTOM_TABLE1 + nCustomIndex;
}
/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA




BOOL	WksReportOperation::getCombinedString(string &str, DWORD dwCombined)
{
	switch (dwCombined)
	{
	case DRR_COMBINED_SIMPLE:
		str = _L("Concatenate");
		break;
		
	case DRR_COMBINED_AVE_SE:
		str = _L("Combined Ave. SE");
		break;
		
	case DRR_COMBINED_AVE_SD:
		str = _L("Combined Ave. SD");
		break;
	default:
		return error_report("getCombinedString found invalid value");
	}
	
	return TRUE;
}

BOOL	WksReportOperation::AddCombinedDataSourcesToReportInputTable(TreeNode &trInputTable, const vector<string> &vstrFactors, int index, LPCSTR lpcszLabel, int numSubRanges, DWORD dwRules, LPCSTR lpcszXLabel)
{
	ASSERT(0 == index);			// always 1 if combined
	ASSERT ( 1 < numSubRanges );		// it can happen only for combined
	DWORD		dwCombinedRule = dwRules & DRR_COMBINED_MASK;
	string		strAdditonalLabel;
	getCombinedString(strAdditonalLabel, dwCombinedRule);
	//int nLabelAdditional = ESC_LABEL_ADD_INDEX;//--- CPY 12/6/04 SHOW_RANGE_TO_LABEL_FOR_MULTIPLE_RANGE_ON_SAME_DATA

	for (int ii = 0; ii < numSubRanges; ii++)
	{
		int			indexLT = ii + 1;
		string		strDataLabel;
		//GetEscapedMainDataString(strDataLabel, 1);
		///Cheney 2007-1-30 MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC
		//getEscapedDataString(strDataLabel, indexLT, TRUE);
		report_get_escaped_data_string(&strDataLabel, indexLT, TRUE);
		///end MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC
		
		int			nRowID = make_one_set_ID(IDST_REPORT_INPUT_ONE_SET, ii);	// this will need to be fixed for queries since
																				// this entire loop actually represents one set, but
																				// I ahve to have different IDs to make the table construction work
		TreeNode	trOneSubRange = check_add_enumerated_node(trInputTable, "C", indexLT, nRowID, STR_LABEL_ATTRIB, strAdditonalLabel);
		
		// Append the subrange row label:
		///Arvin 09/03/07 INPUT_TABLE_ROW_LABEL_WRONG_AFTER_CREATE_COPY
		//tree_add_one_label(trOneSubRange, strDataLabel, 0);
		tree_add_one_label(trOneSubRange, strDataLabel);
		///END INPUT_TABLE_ROW_LABEL_WRONG_AFTER_CREATE_COPY

		/// ML 1/31/2007 QA70-6367 P17 NO_Y_IN_ESCAPED_STRINGS_IF_NO_X
		char		chMain = 'Y';
		/// end NO_Y_IN_ESCAPED_STRINGS_IF_NO_X
		TreeNode trCol;
		// First add X, if any:
		if ( lpcszXLabel )
		{
			AddOneInputDataTableCell(trOneSubRange, lpcszXLabel, indexLT, TRUE, 'P', 'X');
			
			// X excel
			trCol = AddOneInputDataTableCell(trOneSubRange, lpcszXLabel, indexLT, TRUE, 'R', 'X');
			if(trCol)
				trCol.Show = false;
		}
		/// ML 1/31/2007 QA70-6367 P17 NO_Y_IN_ESCAPED_STRINGS_IF_NO_X
		else
			chMain = 0;		// 0 forces it to be treated as main, which is what it ought to be if not XY(Z)
		/// end NO_Y_IN_ESCAPED_STRINGS_IF_NO_X
		
		/// ML 1/31/2007 QA70-6367 P17 NO_Y_IN_ESCAPED_STRINGS_IF_NO_X
		//// Main:
		//AddOneInputDataTableCell(trOneSubRange, lpcszLabel, indexLT, TRUE, 'P', 'Y');
		//
		//// Y excel
		//trCol = AddOneInputDataTableCell(trOneSubRange, lpcszXLabel, indexLT, TRUE, 'R', 'Y');
		// Main:
		AddOneInputDataTableCell(trOneSubRange, lpcszLabel, indexLT, TRUE, 'P', chMain);
		
		// Y excel
		trCol = AddOneInputDataTableCell(trOneSubRange, lpcszXLabel, indexLT, TRUE, 'R', chMain);
		/// end NO_Y_IN_ESCAPED_STRINGS_IF_NO_X
		if(trCol)
			trCol.Show = false;
		
		// The range cell:
		//TreeNode		trRange = tree_check_get_node(trOneSubRange, "R", IDE_INPUT_RANGE,  STR_LABEL_ATTRIB, WKSH_OPERATION_INFO_DATA_SOURCE_RANGE);
		//trRange.strVal = "Not done yet";
		AddOneInputDataTableCell(trOneSubRange, WKSH_OPERATION_INFO_DATA_SOURCE_RANGE, indexLT, TRUE, 'G', 'R');
		
		
	}
	
	return TRUE;
}
//		int    GetTableStringDatasets(bool bColHeadings = true, bool bAutoWidth = true, bool bChangeColLabelsInFlatSheet = true);
int Operation::GetTableStringDatasets(bool bColHeadings, bool bAutoWidth, bool bChangeColLabelsInFlatSheet)// = true = true = true
{
	//---- CPY 12/17/04
	//uint nn = GETNBRANCH_HIDE_ROW_HEADINGS | GETNBRANCH_RESIZE;
	uint nn = GETNBRANCH_RESIZE;
	//----
	
	//--- CPY 10/3/05
	if(bChangeColLabelsInFlatSheet)
		nn |= GETNBRANCH_CHANGE_LABEL_TYPES_IN_FLAT;
	//---
		
	return addTableStringCommonBits(nn, true, bColHeadings, bAutoWidth);
}
	
//--- CPY 10/22/04 QA70-7075 ED_DATA_REPORTING
/// ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS
//string	Operation::GetTableStringMaskedData(bool bSubLevel)
int	Operation::GetTableStringMaskedOrMissingData(bool bSubLevel)
/// end GETTING_MISSING_VALUES_AND_ROWS
{
	if(bSubLevel)
	{	// must not be transposed since
		// it only holds subtables (otherwise
		// there is some problem in internal code)
		return GetTableStringSupport(false);
	}
	else
		//return GetTableStringSupport(true, false, true, true, GETNBRANCH_HIDE_COL_LABELS); ///Iris 11/11/04
		/// Iris 01/15/2007 v8.0541 REMOVE_SUB_TABLE_FROM_ANOVE_MISS_MASK_DATA_TABLE
		//return GetTableStringSupport(true, false, true, GETNBRANCH_HIDE_COL_LABELS);
		return GetTableStringSupport(true, false, true);
		///end REMOVE_SUB_TABLE_FROM_ANOVE_MISS_MASK_DATA_TABLE
}
//---

///Cheney 2007-3-29 SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG	
bool	WksReportOperation::IsAddMaskedOrMissingDataTableForMultiIndep(vector& vX, matrix& mMultiIndep)
{
	//I don't know if only MR need mMultiIndep, so just move it
	if(!vX.GetSize() && mMultiIndep.GetNumCols() && mMultiIndep.GetNumRows())
		return true;
	
	return false;
}
///end SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG

///Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
void	WksReportOperation::PrepareMissingOrMaskedTable(TreeNode& trTable, TreeNode& trRows, 
			LPCSTR lpcszTagRows, int idRows, TreeNode& trMain, LPCSTR lpcszTagMain, int idMain,
			LPCSTR lpcszTableLabel, TreeNode& trCols, LPCSTR lpcszTagCols, int idCols)
{
	trRows = tree_check_get_node(trTable, lpcszTagRows, idRows, STR_LABEL_ATTRIB, _L("Rows"));
	trMain = tree_check_get_node(trTable, lpcszTagMain, idMain, STR_LABEL_ATTRIB, lpcszTableLabel);
}

int	WksReportOperation::GetMissingDataAndIndex(const DataRange& dr, LPCSTR lpcszXDataLabel, DWORD dwRules, int index,
				vector<int>& vintRows, vector& vMain, vector& vX, matrix& mMultiIndep, vector& vWeight, 
				vector& vYIndep, vector<int>& vintCols)
{
	int nRet = -1;
	if ( lpcszXDataLabel )
		nRet = dr.GetMissingData(dwRules, index, &vintRows, &vMain, &vX, &mMultiIndep, &vWeight, &vYIndep);		
	else
		nRet = dr.GetMissingData(dwRules, index, &vintRows, &vMain, NULL, NULL, &vWeight);
	
	return nRet;
}
///end MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT

/// ML 10/20/2004 QA70-7075 MASKED_DATA_REPORTING
/// ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS
	/// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
//bool	Operation::SetMaskedOrMissingDataTable(DataRange &dr, TreeNode &trTable, LPCSTR lpcszDataLabel, LPCSTR lpcszXDataLabel, LPCSTR lpcszWeightLabel,
//												int index, DWORD dwRules, bool bMissingData)
/// Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
//bool	WksReportOperation::setMaskedOrMissingDataTable(DataRange &dr, TreeNode &trTable, LPCSTR lpcszTableLabel, LPCSTR lpcszXDataLabel, LPCSTR lpcszWeightLabel,
												//int index, DWORD dwRules, bool bMissingData, LPCSTR lpcszYIndepDataLabel, LPCSTR lpcszDataLabel)
bool	WksReportOperation::setMaskedOrMissingDataTable(bool bCreateTable, DataRange &dr, TreeNode &trTable, LPCSTR lpcszTableLabel, LPCSTR lpcszXDataLabel, LPCSTR lpcszWeightLabel,
												int index, DWORD dwRules, bool bMissingData, LPCSTR lpcszYIndepDataLabel, LPCSTR lpcszDataLabel)
///End IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
/// end Z_IN_REPORT_TABELS
{
	/// Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	// moved from below to check if existed missing data or masked data at the beginning, if not create report table then directly return value, 
	// true for return value means eixsted missing data or masked data.
	int nn = -1;
	matrix 			mMultiIndep; /// Thomas 06/07/06 GET_MASKED_AND_MISSING_INDEP_DATA_FOR_MLR
	vector			vMain, vX, vWeight, vYIndep;
	vector<int>		vintRows, vintCols;
	if ( bMissingData )
	{	
		///Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
		//if ( lpcszXDataLabel )
			///// Iris 9/13/06 QA8811-P11 USING_VECTOR_POINTER_HERE_CAUSE_CRASH
			///*
			///// Thomas 06/07/06 GET_MASKED_AND_MISSING_INDEP_DATA_FOR_MLR
			////nn = dr.GetMissingData(dwRules, index, &vintRows, &vMain, &vX, NULL, &vWeight, pvYIndep);
			//nn = dr.GetMissingData(dwRules, index, &vintRows, &vMain, &vX, &mMultiIndep, &vWeight, pvYIndep);		
			///// End GET_MASKED_AND_MISSING_INDEP_DATA_FOR_MLR
			//*/
			//nn = dr.GetMissingData(dwRules, index, &vintRows, &vMain, &vX, &mMultiIndep, &vWeight, &vYIndep);		
			/////end USING_VECTOR_POINTER_HERE_CAUSE_CRASH
		//else
			//nn = dr.GetMissingData(dwRules, index, &vintRows, &vMain, NULL, NULL, &vWeight);
		nn = GetMissingDataAndIndex(dr, lpcszXDataLabel, dwRules, index, vintRows, vMain, vX, mMultiIndep, vWeight, vYIndep, vintCols);
		///end MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
	}
	else
	{
		if ( lpcszXDataLabel )
			/// Iris 9/13/06 QA8811-P11 USING_VECTOR_POINTER_HERE_CAUSE_CRASH			
			///// Thomas 06/07/06 GET_MASKED_AND_MISSING_INDEP_DATA_FOR_MLR
			////nn = dr.GetMaskedData(dwRules, index, &vintRows, &vMain, &vX, NULL, &vWeight, pvYIndep);
			//nn = dr.GetMaskedData(dwRules, index, &vintRows, &vMain, &vX, &mMultiIndep, &vWeight, pvYIndep);		
			///// End GET_MASKED_AND_MISSING_INDEP_DATA_FOR_MLR				
			nn = dr.GetMaskedData(dwRules, index, &vintRows, &vMain, &vX, &mMultiIndep, &vWeight, &vYIndep);
			///end USING_VECTOR_POINTER_HERE_CAUSE_CRASH
		else
			nn = dr.GetMaskedData(dwRules, index, &vintRows, &vMain, NULL, NULL, &vWeight);
	}
	
	bool			bReturn = true;
	if ( nn < 0 )
	{
		ASSERT(FALSE);		// failed
		vMain.SetSize(0);
		vX.SetSize(0);
		/// ML 11/8/2005 QA70-8135 Z_IN_REPORT_TABELS
		vYIndep.SetSize(0);
		/// end Z_IN_REPORT_TABELS
		vWeight.SetSize(0);
		vintRows.SetSize(0);
		
		bReturn = false;
	}
	else if ( 0 == vintRows.GetSize() )
		bReturn = false;		// to indicate that there are no pts
	
	if( !bCreateTable )
		return bReturn;
	///end IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	
	/// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
	/*
	vector			vMain, vX, vWeight;
	vector<int>		vintRows;
	
	string			strTagRows, strTagY, strTagX, strTagWeight;
	int				idRows, idY, idX, idWeight;
	if ( bMissingData )
	{
		strTagRows = "MissingRows";
		strTagY = "MissingY";
		strTagX = "MissingX";
		strTagWeight = "MissingWeight";
		idRows = IDE_MISSING_ROWS;
		idY = IDE_MISSING_Y;
		idX = IDE_MISSING_X;
		idWeight = IDE_MISSING_WEIGHT;
	}
	else
	{
		strTagRows = "MaskedRows";
		strTagY = "MaskedY";
		strTagX = "MaskedX";
		strTagWeight = "MaskedWeight";
		idRows = IDE_MASKED_ROWS;
		idY = IDE_MASKED_Y;
		idX = IDE_MASKED_X;
		idWeight = IDE_MASKED_WEIGHT;
	}
	*/
	/////////////////
	
	/// Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	/*
	vector			vMain, vX, vWeight, vYIndep;
	//vector			*pvYIndep = (NULL != lpcszYIndepDataLabel) ? &vYIndep : NULL;  /// Iris 9/13/06 QA8811-P11 USING_VECTOR_POINTER_HERE_CAUSE_CRASH
	vector<int>		vintRows;
	*/
	///end IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	string			strTagRows, strTagMain, strTagYIndep, strTagX, strTagWeight;
	int				idRows, idMain, idYIndep, idX, idWeight, idRow;
	///Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
	string 			strTagCols; 
	int				idCols;
	//vector<int>		vintCols; /// Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	///end MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
	if ( bMissingData )
	{
		strTagRows = "MissingRows";
		strTagCols = "MissingCols"; ///Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
		strTagMain = "MissingMain";
		strTagYIndep = "MissingYIndep";
		strTagX = "MissingX";
		strTagWeight = "MissingWeight";
		idRows = IDE_MISSING_ROWS;
		idCols = IDE_MISSING_COLS; ///Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
		idMain = IDE_MISSING_MAIN;
		idYIndep = IDE_MISSING_YINDEP;
		idX = IDE_MISSING_X;
		idWeight = IDE_MISSING_WEIGHT;
		idRow = IDE_MISSING_ROW;
	}
	else
	{
		strTagRows = "MaskedRows";
		strTagMain = "MaskedMain";
		strTagYIndep = "MaskedYIndep";
		strTagX = "MaskedX";
		strTagWeight = "MaskedWeight";
		idRows = IDE_MASKED_ROWS;
		idMain = IDE_MASKED_MAIN;
		idYIndep = IDE_MASKED_YINDEP;
		idX = IDE_MASKED_X;
		idWeight = IDE_MASKED_WEIGHT;
		idRow = IDE_MASKED_ROW;
	}

	/// end Z_IN_REPORT_TABELS

	//int				nn = -1; /// Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	///Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
	//TreeNode		trRows = tree_check_get_node(trTable, strTagRows, idRows, STR_LABEL_ATTRIB, _L("Rows"));
	///// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
	////TreeNode		trMain = tree_check_get_node(trTable, strTagY, idY, STR_LABEL_ATTRIB, lpcszTableLabel);
	//TreeNode		trMain = tree_check_get_node(trTable, strTagMain, idMain, STR_LABEL_ATTRIB, lpcszTableLabel);
	///// end Z_IN_REPORT_TABELS
	TreeNode trRows, trMain, trCols;
	PrepareMissingOrMaskedTable(trTable, trRows, strTagRows, idRows, trMain, strTagMain, idMain,lpcszTableLabel, trCols, strTagCols, idCols);
	///end MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT	

	///Arvin 12/05/06 MR_MASKED_AND_MISSING_DATA_HAVE_MULTI_X_DATA
	/*
	TreeNode		trX;
	if ( lpcszXDataLabel )
		trX = tree_check_get_node(trTable, strTagX, idX, STR_LABEL_ATTRIB, lpcszXDataLabel);
	
	/// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
	TreeNode		trYIndep;
	if ( lpcszYIndepDataLabel )
		trYIndep = tree_check_get_node(trTable, strTagYIndep, idYIndep, STR_LABEL_ATTRIB, lpcszYIndepDataLabel);
	/// end Z_IN_REPORT_TABELS
	
	TreeNode		trWeight;
	///Alex 03/27/06 QA70-8551 DEL_ERR_COL_IN_REPORT_TABLE_IF_NOT_INPUT_ERR
	//if ( lpcszWeightLabel )	
	if ( lpcszWeightLabel  && (is_include_special_subrange(dr,"ED") || is_include_special_subrange(dr,"W")))
	///End DEL_ERR_COL_IN_REPORT_TABLE_IF_NOT_INPUT_ERR
		trWeight = tree_check_get_node(trTable, strTagWeight, idWeight, STR_LABEL_ATTRIB, lpcszWeightLabel);
	*/
	///end MR_MASKED_AND_MISSING_DATA_HAVE_MULTI_X_DATA
	
	/// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
	//if ( bMissingData )
	//{
	//	if ( lpcszXDataLabel )
	//		nn = dr.GetMissingData(dwRules, index, &vintRows, &vMain, &vX, NULL, &vWeight);
	//	else
	//		nn = dr.GetMissingData(dwRules, index, &vintRows, &vMain, NULL, NULL, &vWeight);
	//}
	//else
	//{
	//	if ( lpcszXDataLabel )
	//		nn = dr.GetMaskedData(dwRules, index, &vintRows, &vMain, &vX, NULL, &vWeight);
	//	else
	//		nn = dr.GetMaskedData(dwRules, index, &vintRows, &vMain, NULL, NULL, &vWeight);
	//}
	
	/// Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	/*
	matrix mMultiIndep; /// Thomas 06/07/06 GET_MASKED_AND_MISSING_INDEP_DATA_FOR_MLR
	
	if ( bMissingData )
	{	
		///Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
		//if ( lpcszXDataLabel )
			///// Iris 9/13/06 QA8811-P11 USING_VECTOR_POINTER_HERE_CAUSE_CRASH			
			/////// Thomas 06/07/06 GET_MASKED_AND_MISSING_INDEP_DATA_FOR_MLR
			//////nn = dr.GetMissingData(dwRules, index, &vintRows, &vMain, &vX, NULL, &vWeight, pvYIndep);
			////nn = dr.GetMissingData(dwRules, index, &vintRows, &vMain, &vX, &mMultiIndep, &vWeight, pvYIndep);		
			/////// End GET_MASKED_AND_MISSING_INDEP_DATA_FOR_MLR			
			//nn = dr.GetMissingData(dwRules, index, &vintRows, &vMain, &vX, &mMultiIndep, &vWeight, &vYIndep);		
			/////end USING_VECTOR_POINTER_HERE_CAUSE_CRASH
		//else
			//nn = dr.GetMissingData(dwRules, index, &vintRows, &vMain, NULL, NULL, &vWeight);
		nn = GetMissingDataAndIndex(dr, lpcszXDataLabel, dwRules, index, vintRows, vMain, vX, mMultiIndep, vWeight, vYIndep, vintCols);
		///end MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
	}
	else
	{
		if ( lpcszXDataLabel )
			/// Iris 9/13/06 QA8811-P11 USING_VECTOR_POINTER_HERE_CAUSE_CRASH			
			///// Thomas 06/07/06 GET_MASKED_AND_MISSING_INDEP_DATA_FOR_MLR
			////nn = dr.GetMaskedData(dwRules, index, &vintRows, &vMain, &vX, NULL, &vWeight, pvYIndep);
			//nn = dr.GetMaskedData(dwRules, index, &vintRows, &vMain, &vX, &mMultiIndep, &vWeight, pvYIndep);		
			///// End GET_MASKED_AND_MISSING_INDEP_DATA_FOR_MLR				
			nn = dr.GetMaskedData(dwRules, index, &vintRows, &vMain, &vX, &mMultiIndep, &vWeight, &vYIndep);
			///end USING_VECTOR_POINTER_HERE_CAUSE_CRASH
		else
			nn = dr.GetMaskedData(dwRules, index, &vintRows, &vMain, NULL, NULL, &vWeight);
	}
	*/
	///end IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	
	/// Thomas 06/07/06 GET_MASKED_AND_MISSING_INDEP_DATA_FOR_MLR
	///Cheney 2007-3-29 SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG	
	if(IsAddMaskedOrMissingDataTableForMultiIndep(vX, mMultiIndep))
	//if(!vX.GetSize() && mMultiIndep.GetNumCols() && mMultiIndep.GetNumRows())
	///end SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG
	///Arvin 12/05/06 MR_MASKED_AND_MISSING_DATA_HAVE_MULTI_X_DATA
		//mMultiIndep.GetColumn(vX, 0);
	{
		for(int ncol = 0; ncol < mMultiIndep.GetNumCols(); ncol++)
		{
			mMultiIndep.GetColumn(vX, ncol);
			int	nID = make_one_set_ID(idX, ncol+1);
			TreeNode		trMoreX;
			strTagX = strTagX + ftoa(ncol+1);
			if ( lpcszXDataLabel )
				trMoreX = tree_check_get_node(trTable, strTagX, nID, STR_LABEL_ATTRIB, lpcszXDataLabel);
		
			if ( trMoreX )
				///Arvin 01/18/06 SHOW_MASKED_AND_MISSING_DATA_IN_REPORT_LOG
				//trMoreX.dVals = vX;
				AddRowsToMaskedOrMissingDataTable(trMoreX, vX, idRow, lpcszXDataLabel);
				///---
		}
	}
	else
	{
		TreeNode		trX;
		if ( lpcszXDataLabel )
			trX = tree_check_get_node(trTable, strTagX, idX, STR_LABEL_ATTRIB, lpcszXDataLabel);
		if ( trX )
			///Arvin 01/18/06 SHOW_MASKED_AND_MISSING_DATA_IN_REPORT_LOG
			//trX.dVals = vX;
			AddRowsToMaskedOrMissingDataTable(trX, vX, idRow, lpcszXDataLabel);
			///END SHOW_MASKED_AND_MISSING_DATA_IN_REPORT_LOG
		
	}
	
	/// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
	TreeNode		trYIndep;
	if ( lpcszYIndepDataLabel )
		trYIndep = tree_check_get_node(trTable, strTagYIndep, idYIndep, STR_LABEL_ATTRIB, lpcszYIndepDataLabel);
	/// end Z_IN_REPORT_TABELS
	
	TreeNode		trWeight;
	///Alex 03/27/06 QA70-8551 DEL_ERR_COL_IN_REPORT_TABLE_IF_NOT_INPUT_ERR
	//if ( lpcszWeightLabel )	
	if ( lpcszWeightLabel  && (is_include_special_subrange(dr,"ED") || is_include_special_subrange(dr,"W")))
	///End DEL_ERR_COL_IN_REPORT_TABLE_IF_NOT_INPUT_ERR
		trWeight = tree_check_get_node(trTable, strTagWeight, idWeight, STR_LABEL_ATTRIB, lpcszWeightLabel);
	///end 	MR_MASKED_AND_MISSING_DATA_HAVE_MULTI_X_DATA	
		/// End GET_MASKED_AND_MISSING_INDEP_DATA_FOR_MLR	
	/// end Z_IN_REPORT_TABELS

	/// Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	// moved to the beginning of this function
	/*
	bool			bReturn = true;
	if ( nn < 0 )
	{
		ASSERT(FALSE);		// failed
		vMain.SetSize(0);
		vX.SetSize(0);
		/// ML 11/8/2005 QA70-8135 Z_IN_REPORT_TABELS
		vYIndep.SetSize(0);
		/// end Z_IN_REPORT_TABELS
		vWeight.SetSize(0);
		vintRows.SetSize(0);
		
		bReturn = false;
	}
	else if ( 0 == vintRows.GetSize() )
		bReturn = false;		// to indicate that there are no pts
	*/
	///end IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	
	/// Iris 01/15/2007 v8.0541 REMOVE_SUB_TABLE_FROM_ANOVE_MISS_MASK_DATA_TABLE
	//trMain.dVals = vMain;
	//trRows.nVals = vintRows;
	AddRowsToMaskedOrMissingDataTable(trMain, vMain, idRow, lpcszDataLabel);
	AddRowsToMaskedOrMissingDataTable(trRows, vintRows, idRow, lpcszDataLabel);
	/// end REMOVE_SUB_TABLE_FROM_ANOVE_MISS_MASK_DATA_TABLE
	AddColsIndexToMissingDataTable(trCols, vintCols, idRow, lpcszDataLabel); ///Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
	///Arvin 12/05/06 MR_MASKED_AND_MISSING_DATA_HAVE_MULTI_X_DATA
	/*
	if ( trX )
		trX.dVals = vX;
	*/
	///end MR_MASKED_AND_MISSING_DATA_HAVE_MULTI_X_DATA
	
	/// Iris 01/15/2007 v8.0541 REMOVE_SUB_TABLE_FROM_ANOVE_MISS_MASK_DATA_TABLE
	/*
	/// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
	if ( trYIndep )
		trYIndep.dVals = vYIndep;
	/// end Z_IN_REPORT_TABELS
	if ( trWeight )
		trWeight.dVals = vWeight;
	*/
	if ( trYIndep )
		AddRowsToMaskedOrMissingDataTable(trYIndep, vYIndep, idRow, lpcszDataLabel);
	if ( trWeight )
		AddRowsToMaskedOrMissingDataTable(trWeight, vWeight, idRow, lpcszDataLabel);
	///end REMOVE_SUB_TABLE_FROM_ANOVE_MISS_MASK_DATA_TABLE
	
	/// Iris 9/3/2009 QA80-14209 ADD_LIMITION_FOR_LARGER_DATA_IN_MASKED_MISSING_DATA_TABLE
	int nRows = vintRows.GetSize();
	if( isAddRowNumberLimitionForMaskedMissingTable( &nRows ) )
	{		
		string 		str, strFootNote;
		ocu_load_err_msg_str(MASKED_MISSING_DATA_TABLE_MAX_ROW_NUM_LIMITION, &str);
		strFootNote.Format(str, MASKED_MISSING_DATA_TABLE_MAX_ROW_NUM);
		
		TreeNode 	trFootnote = tree_check_get_node(trTable, "Footnote", IDE_FOOTNOTE_BEGIN, TREE_Footnote, "1"); 
		trFootnote.strVal = strFootNote;
	}
	///end ADD_LIMITION_FOR_LARGER_DATA_IN_MASKED_MISSING_DATA_TABLE
	return bReturn;
}
/// end GETTING_MISSING_VALUES_AND_ROWS

bool	WksReportOperation::isAddRowNumberLimitionForMaskedMissingTable(int *pnMaskedMissingDataSize)
{
	Tree trOp;
	GetTree(trOp);
	
	if( (NULL == pnMaskedMissingDataSize || pnMaskedMissingDataSize && *pnMaskedMissingDataSize > MASKED_MISSING_DATA_TABLE_MAX_ROW_NUM)
		&& PDS_NONE != okutil_cvt_str_to_predefined_type(trOp.GUI.Output.Report.Book.strVal) )
		return true;
	return false;	
}

/// Iris 01/15/2007 v8.0541 REMOVE_SUB_TABLE_FROM_ANOVE_MISS_MASK_DATA_TABLE
///Cheney 2007-4-2 FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING_
//bool	AddRowsToMaskedOrMissingDataTable(TreeNode& trCol, const vectorbase& vData, int nBaseID, LPCSTR lpcszRowLabel);
bool	WksReportOperation::AddRowsToMaskedOrMissingDataTable(TreeNode& trCol, const vectorbase& vData, int nBaseID, LPCSTR lpcszRowLabel, int* pRowStart)
///end FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING_
{
	/// Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	// move to vc level to improve speed.
	/*
	if(0 == vData.GetSize())
		return false;
	
	///Cheney 2007-4-2 FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING_
	//int		nRowStart = trCol.GetNodeCount();
	int		nRowStart = pRowStart == NULL? trCol.GetNodeCount() : *pRowStart;
	///end FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING_
	for(int nRow=nRowStart, nSize = 0; nSize<vData.GetSize(); nRow++, nSize++)
	{
		int 		ID = make_one_set_ID(nBaseID, nRow+1);
		TreeNode 	trRow = check_add_enumerated_node(trCol, CALCULATION_REPORT_TABLE_ROW_PREFIX, nRow + 1, ID, STR_LABEL_ATTRIB, lpcszRowLabel);	
		trRow.dVal = (double)vData[nSize];
	}
	///Cheney 2007-4-2 FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING_
	if(pRowStart != NULL)
		*pRowStart = nRowStart + vData.GetSize();
	///end FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING_
	return true;
	*/	
	vector vDoubleData;
	vDoubleData = vData;	
	/// Iris 9/3/2009 QA80-14209 ADD_LIMITION_FOR_LARGER_DATA_IN_MASKED_MISSING_DATA_TABLE
	// The speed will be very slow when the number of masked data or missing data very large, so add a limit.
	//return octree_check_add_all_enumerated_nodes(&trCol, CALCULATION_REPORT_TABLE_ROW_PREFIX, &vDoubleData, nBaseID, lpcszRowLabel, pRowStart);
	int nMaxLimition = MASKED_MISSING_DATA_TABLE_MAX_ROW_NUM;
	int *pnMax = NULL;
	if( isAddRowNumberLimitionForMaskedMissingTable() )
		pnMax = &nMaxLimition;
	return octree_check_add_all_enumerated_nodes(&trCol, CALCULATION_REPORT_TABLE_ROW_PREFIX, &vDoubleData, nBaseID, lpcszRowLabel, pRowStart, pnMax);
	///end ADD_LIMITION_FOR_LARGER_DATA_IN_MASKED_MISSING_DATA_TABLE
	///end IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
}
///end REMOVE_SUB_TABLE_FROM_ANOVE_MISS_MASK_DATA_TABLE

/// ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS
/*
bool	Operation::SetMaskedDataTable(DataRange &dr, TreeNode &trTable, LPCSTR lpcszDataLabel, LPCSTR lpcszXDataLabel, LPCSTR lpcszWeightLabel, int index, DWORD dwRules)
{
	//TreeNode	trData = check_add_enumerated_node(trTable, "C", index + 1, nRowID, STR_LABEL_ATTRIB, lpcszDataLabel);
	
	vector			vMainMasked, vXMasked, vWeightMasked;
	vector<int>		vintRows;
	
	int				nn = -1;
	TreeNode		trRows = tree_check_get_node(trTable, "MaskedRows", IDE_MASKED_ROWS, STR_LABEL_ATTRIB, _L("Rows"));
	TreeNode		trMain = tree_check_get_node(trTable, "MaskedY", IDE_MASKED_Y, STR_LABEL_ATTRIB, lpcszDataLabel);
	TreeNode		trX;
	if ( lpcszXDataLabel )
		trX = tree_check_get_node(trTable, "MaskedX", IDE_MASKED_X, STR_LABEL_ATTRIB, lpcszXDataLabel);
	
	TreeNode		trWeight;
	if ( lpcszWeightLabel )
		trWeight = tree_check_get_node(trTable, "MaskedWeight", IDE_MASKED_WEIGHT, STR_LABEL_ATTRIB, lpcszWeightLabel);
	
	if ( lpcszXDataLabel )
		nn = dr.GetMaskedData(dwRules, index, &vintRows, &vMainMasked, &vXMasked, NULL, &vWeightMasked);
	else
		nn = dr.GetMaskedData(dwRules, index, &vintRows, &vMainMasked, NULL, NULL, &vWeightMasked);
	bool			bReturn = true;
	if ( nn < 0 )
	{
		ASSERT(FALSE);		// failed
		vMainMasked.SetSize(0);
		vXMasked.SetSize(0);
		vWeightMasked.SetSize(0);
		vintRows.SetSize(0);
		
		bReturn = false;
	}
	else if ( 0 == vintRows.GetSize() )
		bReturn = false;		// to indicate that there are no pts
	
	trMain.dVals = vMainMasked;
	trRows.nVals = vintRows;
	if ( trX )
		trX.dVals = vXMasked;
	if ( trWeight )
		trWeight.dVals = vWeightMasked;

	return bReturn;
}
*/
/// end GETTING_MISSING_VALUES_AND_ROWS


DWORD Operation::CheckDataRules(TreeNode& trOp, DWORD dwRules, bool bIgnoreCombineInfo)
{
	DWORD dwRet = dwRules;
	if(!bIgnoreCombineInfo)
	{
		/// Iris 4/28/2009 QA80-12784-P4 FIX_HITOGRAM_BIN_INFO_NOT_UPDATE_WHEN_CHANGE_DATA_MODE
		//tree_oper_multidata_mode_update_rules(dwRet, trOp);
		tree_oper_multidata_mode_update_rules(dwRet, trOp.GUI);
		///end FIX_HITOGRAM_BIN_INFO_NOT_UPDATE_WHEN_CHANGE_DATA_MODE
	}
	return dwRet;// | DRR_ADD_TO_PROJECT; //CPY 5/15/05 CONSOLIDATE_INIT_INPUT_DATA_RANGE, need to wait for Yuri to clean, for now need to always add data range to project CPY 5/19/05, remove DRR_ADD_TO_PROJECT
}

///Arvin 12/05/06 ROCCURVE_SHOULD_HAVE_SPECIAL_DATA_LABEL
virtual void WksReportOperation::GetMaskedOrMissingDataLabel(const TreeNode& trOp, LPCSTR &lpcszDataXLabel, LPCSTR &lpcszMainLabel, LPCSTR &lpcszDataYIndepLabel)
{
	if ( HasZ(trOp) )		// if XYZ
	{
		lpcszDataXLabel = WKSH_OPERATION_INFO_DATA_X;
		lpcszDataYIndepLabel = WKSH_OPERATION_INFO_DATA_Y;
		lpcszMainLabel = WKSH_OPERATION_INFO_DATA_Z;
	}
	else
	/// end Z_IN_REPORT_TABELS
	if ( HasX() )
	{
		lpcszDataXLabel = WKSH_OPERATION_INFO_DATA_X;
		lpcszMainLabel = WKSH_OPERATION_INFO_DATA_Y;
	}
	else
	{
		lpcszDataXLabel = NULL;
		lpcszMainLabel = WKSH_OPERATION_INFO_DATA;
	}
}
/// ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS
///Cheney 2007-4-2 ADD_HINTS_IN_FOOTNOTE_WHEN_EXISTS_MISSING_OR_MASKED_DATA
//bool	WksReportOperation::UpdateMaskedOrMissingDataTables(TreeNode& trOp, DataRange& dr, vector<string> &vstrFactors, int index,
													//int nNumData, int numSubRanges, DWORD dwRules, LPCSTR lpcszDataLabel, bool bMissingData)
bool	WksReportOperation::UpdateMaskedOrMissingDataTables(TreeNode& trOp, DataRange& dr, vector<string> &vstrFactors, int index,
													int nNumData, int numSubRanges, DWORD dwRules, LPCSTR lpcszDataLabel, bool bMissingData, bool& bHas)

///end ADD_HINTS_IN_FOOTNOTE_WHEN_EXISTS_MISSING_OR_MASKED_DATA
{
	BOOL			bSubRange = 1 < numSubRanges;
	bool			bUseSubLevels = 1 < nNumData || bSubRange;
	TreeNode		trCalc = trOp.Calculation;
	TreeNode		trTable;
	LPCSTR			lpcszDataXLabel;
	LPCSTR			lpcszMainLabel;
	BOOL			bHasAny = FALSE;
	///Arvin 09/03/07 WRONG_WEIGHT_LABEL_IN_MASK_AND_MISSING_DATA_TABLE
	//string			strError = GetMaskedOrMissingDataTableErrorColumnName();
	string				strError = GetMaskedOrMissingDataTableErrorWeightColumnName();
	///end WRONG_WEIGHT_LABEL_IN_MASK_AND_MISSING_DATA_TABLE

	/// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
	LPCSTR			lpcszDataYIndepLabel = NULL;		// used only if XYZ
	///Arvin 12/05/06 ROCCURVE_SHOULD_HAVE_SPECIAL_DATA_LABEL
	/*
	if ( HasZ(trOp) )		// if XYZ
	{
		lpcszDataXLabel = WKSH_OPERATION_INFO_DATA_X;
		lpcszDataYIndepLabel = WKSH_OPERATION_INFO_DATA_Y;
		lpcszMainLabel = WKSH_OPERATION_INFO_DATA_Z;
	}
	else
	/// end Z_IN_REPORT_TABELS
	if ( HasX() )
	{
		lpcszDataXLabel = WKSH_OPERATION_INFO_DATA_X;
		lpcszMainLabel = WKSH_OPERATION_INFO_DATA_Y;
	}
	else
	{
		lpcszDataXLabel = NULL;
		lpcszMainLabel = WKSH_OPERATION_INFO_DATA;
	}
	*/
	GetMaskedOrMissingDataLabel(trOp, lpcszDataXLabel, lpcszMainLabel, lpcszDataYIndepLabel);
	///end ROCCURVE_SHOULD_HAVE_SPECIAL_DATA_LABEL
	TreeNode		trTheTable;
	int				idOneSet;
	bool			bCreateTable; /// Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	if ( bMissingData )
	{
		idOneSet = IDST_REPORT_MISSING_DATA_TABLES;
		trTheTable = trCalc.MissingData;
		/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//bCreateTable = trOp.GUI.Output.Create.MissingData.nVal; /// Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
		bCreateTable = OP_GUI_OUTPUT_TABLES_BRANCH(trOp.GUI).MissingData.nVal;
		///end OP_DLG_NEW_STRUCTURE
	}
	else
	{
		idOneSet = IDST_REPORT_MASKED_DATA_TABLES;
		trTheTable = trCalc.MaskedData;
		/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//bCreateTable = trOp.GUI.Output.Create.MaskedData.nVal; /// Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
		bCreateTable = OP_GUI_OUTPUT_TABLES_BRANCH(trOp.GUI).MaskedData.nVal;
		///end OP_DLG_NEW_STRUCTURE
	}
	
	/// RVD 9/21/2005 QA70-8105 v8.0310 REPLACE_REPORT_COMPLETELY
	if( !trTheTable )
		return false;
	/// end REPLACE_REPORT_COMPLETELY

	/// Iris 01/15/2007 v8.0541 REMOVE_SUB_TABLE_FROM_ANOVE_MISS_MASK_DATA_TABLE
	/*
	if ( bUseSubLevels )
	{
		trTheTable.SetAttribute(TREE_Table, GetTableStringMaskedOrMissingData(true));	
		
		int			nLoopUpperLimit = 1 < numSubRanges ? numSubRanges : index + 1;
		if ( bSubRange )
			ASSERT(0 == index);
		for (int ii = index; ii < nLoopUpperLimit; ii++)
		{
			int			nID = make_one_set_ID(idOneSet, index);
			string		strTableLabel;
			//GetEscapedMainDataString(trOp, strTableLabel, ii + 1);
			getEscapedDataString(strTableLabel, ii + 1, bSubRange);
			/// Iris 5/16/06 MISS_TABLE_NOT_WORK_IF_INCLUDE_GROUP_DATA
			//int			nNumFactors = vstrFactors.GetSize();
			//for (int jj = 0; jj < nNumFactors; jj++)
			//{
				//strTableLabel += " : ";
				//strTableLabel += vstrFactors[jj];
			//}
			int		nNumFactors = vstrFactors.GetSize();
			if(nNumFactors > 0)
			{
				strTableLabel = vstrFactors[0];
				for (int jj = 1; jj < nNumFactors; jj++)
				{
					strTableLabel += " - ";
					strTableLabel += vstrFactors[jj];
				}
			}
			///End MISS_TABLE_NOT_WORK_IF_INCLUDE_GROUP_DATA
			
			trTable = check_add_enumerated_node(trTheTable, "M", ii + 1, nID, STR_LABEL_ATTRIB, strTableLabel);
			trTable.SetAttribute(TREE_Table, GetTableStringSupport());	// must be transposed
			/// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
			//if ( SetMaskedOrMissingDataTable(dr, trTable, lpcszMainLabel, lpcszDataXLabel, strError, ii, dwRules, bMissingData) )
			if ( SetMaskedOrMissingDataTable(dr, trTable, lpcszMainLabel, lpcszDataXLabel, strError, ii, dwRules, bMissingData, lpcszDataYIndepLabel) )
			/// end Z_IN_REPORT_TABELS
				bHasAny = TRUE;
		}
	}
	else
	{
		trTable = trTheTable;
		trTable.SetAttribute(TREE_Table, GetTableStringMaskedOrMissingData(false));
		/// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
		//if ( SetMaskedOrMissingDataTable(dr, trTable, lpcszMainLabel, lpcszDataXLabel, strError, index, dwRules, bMissingData) )
		if ( SetMaskedOrMissingDataTable(dr, trTable, lpcszMainLabel, lpcszDataXLabel, strError, index, dwRules, bMissingData, lpcszDataYIndepLabel) )
		/// end Z_IN_REPORT_TABELS
			bHasAny = TRUE;
	}
	*/
	///end REMOVE_SUB_TABLE_FROM_ANOVE_MISS_MASK_DATA_TABLE
	
	trTheTable.SetAttribute(TREE_Table, GetTableStringMaskedOrMissingData(false));
	///Cheney 2007-4-2 ADD_HINTS_IN_FOOTNOTE_WHEN_EXISTS_MISSING_OR_MASKED_DATA
	//SetMaskedOrMissingDataTable(dr, trTheTable, lpcszMainLabel, lpcszDataXLabel, strError, index, dwRules, bMissingData, lpcszDataYIndepLabel, lpcszDataLabel);
	/// Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	//bool bRet = setMaskedOrMissingDataTable(dr, trTheTable, lpcszMainLabel, lpcszDataXLabel, strError, index, dwRules, bMissingData, lpcszDataYIndepLabel, lpcszDataLabel);
	bool bRet = setMaskedOrMissingDataTable(bCreateTable, dr, trTheTable, lpcszMainLabel, lpcszDataXLabel, strError, index, dwRules, bMissingData, lpcszDataYIndepLabel, lpcszDataLabel);
	///end IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	if(bHas != NULL)
		bHas = bRet;
	///end ADD_HINTS_IN_FOOTNOTE_WHEN_EXISTS_MISSING_OR_MASKED_DATA
	
	/// Iris 9/14/2009 QA80-14279 ADD_NOTES_TEXT_FOR_EMPTY_MISSING_MASKED_DATA_TABLE
	if( bCreateTable )
	{
		UpdateNotesTextOnEmptyMaskedOrMissingDataTable(trTheTable, bMissingData, index, nNumData, bHas);
	}
	///end ADD_NOTES_TEXT_FOR_EMPTY_MISSING_MASKED_DATA_TABLE	
	
	///Hong 7/18/06 FIX_RETURN_ERROR
	//tree_set_attribute_bit_if_not_empty(trTheTable, TREE_Table, GETNBRANCH_OPEN);	//---- CPY 12/17/04 SHOW_MISSING_MASED_TABLES_IF_NOT_EMPTY
//	int nCount;
//	tree_set_attribute_bit_if_not_empty(trTheTable, TREE_Table, GETNBRANCH_OPEN, true, nCount);
	if( bHas ) /// Iris 9/21/2009 QA80-14279 KEEP_EMPTY_MASKED_MISSING_TABLE_CLOSE
	{
		octree_set_attribute_bit_if_not_empty(&trTheTable, TREE_Table, GETNBRANCH_OPEN); //CPY 7/18/06 TREE_SET_ATTRIB_BITS_CLEANUP 
	}
	///end FIX_RETURN_ERROR
	return true;
}
/// end GETTING_MISSING_VALUES_AND_ROWS

/// Iris 9/14/2009 QA80-14279 ADD_NOTES_TEXT_FOR_EMPTY_MISSING_MASKED_DATA_TABLE
void WksReportOperation::UpdateNotesTextOnEmptyMaskedOrMissingDataTable(TreeNode& trTheTable, bool bMissingData, int index, int nNumData, bool bHas)
{
	bool bHasMaskedOrMissingData = bMissingData? IsHasMissingData() || bHas :  IsHasMaskedData() || bHas;
	if( !bHasMaskedOrMissingData && index == nNumData-1 )
	{
		while( trTheTable.Children.Count() > 1 ) // remove all columns except first column in table
			trTheTable.LastNode.Remove();
		
		ASSERT(trTheTable.FirstNode);
		if( trTheTable.FirstNode )
		{	
			trTheTable.FirstNode.Reset(true); // to remove all sub nodes but keep attributes	
			trTheTable.FirstNode.SetAttribute(STR_LABEL_ATTRIB, STR_NOTES);
			trTheTable.FirstNode.strVal = bMissingData? STR_NO_MISSING_DATA : STR_NO_MASKED_DATA;	
		}
	}	
}
///end ADD_NOTES_TEXT_FOR_EMPTY_MISSING_MASKED_DATA_TABLE

/// ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS
/*
bool	Operation::UpdateMaskedDataTables(TreeNode& trOp, DataRange& dr, vector<string> &vstrFactors, int index, int nNumData, int numSubRanges, DWORD dwRules)
{
	BOOL			bSubRange = 1 < numSubRanges;
	bool			bUseSubLevels = 1 < nNumData || bSubRange;
	TreeNode		trCalc = trOp.Calculation;
	TreeNode		trTable;
	LPCSTR			lpcszDataXLabel;
	LPCSTR			lpcszDataLabel;
	BOOL			bHasAnyMasked = FALSE;
	string			strError = GetMaskedDataTableErrorColumnName();
	
	if ( HasX() )
	{
		lpcszDataXLabel = WKSH_OPERATION_INFO_DATA_X;
		lpcszDataLabel = WKSH_OPERATION_INFO_DATA_Y;
	}
	else
	{
		lpcszDataXLabel = NULL;
		lpcszDataLabel = WKSH_OPERATION_INFO_DATA;
	}
	
	if ( bUseSubLevels )
	{
		trCalc.MaskedData.SetAttribute(TREE_Table, GetTableStringMaskedData(true));	
		
		int			nLoopUpperLimit = 1 < numSubRanges ? numSubRanges : index + 1;
		if ( bSubRange )
			ASSERT(0 == index);
		for (int ii = index; ii < nLoopUpperLimit; ii++)
		{
			int			nID = make_one_set_ID(IDST_REPORT_MASKED_DATA_TABLES, index);
			string		strTableLabel;
			//GetEscapedMainDataString(trOp, strTableLabel, ii + 1);
			getEscapedDataString(strTableLabel, ii + 1, bSubRange);
			int			nNumFactors = vstrFactors.GetSize();
			for (int jj = 0; jj < nNumFactors; jj++)
			{
				strTableLabel += " : ";
				strTableLabel += vstrFactors[jj];
			}
			
			trTable = check_add_enumerated_node(trCalc.MaskedData, "M", ii + 1, nID, STR_LABEL_ATTRIB, strTableLabel);
			trTable.SetAttribute(TREE_Table, GetTableStringSupport());	// must be transposed
			if ( SetMaskedDataTable(dr, trTable, lpcszDataLabel, lpcszDataXLabel, strError, ii, dwRules) )
				bHasAnyMasked = TRUE;
		}
	}
	else
	{
		trTable = trCalc.MaskedData;
		trTable.SetAttribute(TREE_Table, GetTableStringMaskedData(false));
		if ( SetMaskedDataTable(dr, trTable, lpcszDataLabel, lpcszDataXLabel, strError, index, dwRules) )
			bHasAnyMasked = TRUE;
	}
	
	return true;
}
*/
/// end GETTING_MISSING_VALUES_AND_ROWS

/// end MASKED_DATA_REPORTING



//------------------------------------------------------------------------------
//------------CPY 8/2/04 REDO_COL_FORMULAR_EX_BASED_ON_COMMON_OPERATION_WKS_BASE
//
//virtual 
/// Hong 09/04/09 QA80-14258 HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING
//bool Operation::InitFromSelection(TreeNode &trOperation)
int		Operation::InitFromSelection(TreeNode &trOperation)
/// end HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING
{
	TreeNode				trInputData = trOperation.GUI.InputData;
	
	///Kevin 11/21/05	SET_EVENT_FOR_INPUT_DATA
	//return init_input_data_branch_from_selection(trInputData, GetDataRules(trOperation));	
	bool bRet =  init_input_data_branch_from_selection(trInputData, GetDataRules(trOperation));	
	OnInputDataSelectionChange(trOperation);	
	return bRet;
	///End SET_EVENT_FOR_INPUT_DATA
}

//------------ end CPY 8/2/04 REDO_COL_FORMULAR_EX_BASED_ON_COMMON_OPERATION_WKS_BASE

/// Iris 1/26/06 QA70-8388 INDEP_DATA_CONSOLID_OR_SEP_REPORT
//Set event for input data sub node temporarily, will move into vc level octree_tree_check_add_input_data_branch later
//So now, this is not worked as expected
//virtual
bool Operation::OnInputDataSelectionChange(TreeNode& trOperation)
{
	/// YuI 11/20/06 INPUT_DATA_MODE_NOT_UPDATED_FROM_THEME
	// this code appears to be obsolete
	// and call to event handler would reset "Use" attribute
	/*
	TreeNode 	trInputData = trOperation.GUI.InputData;
	foreach(TreeNode trRanges in trInputData.Children)
	{
		foreach(TreeNode trN in trRanges.Children)
		{
			GETN_SET_EVENT_EX_HANDLER(trN, UpdateInputDataBranchCombo);
		}
	}
	*/
	/// end INPUT_DATA_MODE_NOT_UPDATED_FROM_THEME
	return true;
}

/// YuI 11/20/06 INPUT_DATA_MODE_NOT_UPDATED_FROM_THEME
/*
bool UpdateInputDataBranchCombo(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	TreeNode 	trInputData = tr.InputData;

	DWORD		dwRules = DRR_GET_DEPENDENT | DRR_NO_FACTORS | DRR_RAW_ERR_WEIGHT; //just for Fit tools now, will update this later.
	bool 		bComboShow = op_get_input_data_number(tr, dwRules) > 1? true : false;
	if(bComboShow)
	{
		int	nDataMode;
		if( trInputData.GetAttribute(STR_INPUT_DATA_MODE_ATTRIB, nDataMode) )
		{
			tree_construct_add_input_branch(tr, nDataMode);
		}
		else
			return false;
	}
	else
	{
		trInputData.RemoveAttribute(STR_ATTRIB_BRANCH_COMBO);
		trInputData.RemoveAttribute(STR_USE_ATTRIB);
	}				
	return true;
}
*/
/// end INPUT_DATA_MODE_NOT_UPDATED_FROM_THEME
/// End INDEP_DATA_CONSOLID_OR_SEP_REPORT


//virtual
///Cheney 2007-4-20 OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
//bool Operation::ShowDlg(TreeNode& trOperation, BOOL bChangeParams) //, bool bIsModeless = false, DWORD* pDlgPtr = NULL)
bool WksReportOperation::ShowDlg(TreeNode& trOperation, BOOL bChangeParams) //, bool bIsModeless = false, DWORD* pDlgPtr = NULL)
///end OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
{
	///Joseph 01/29/07	ADD_OPERATION_ERRMSG_LINE
	//PEVENT_FUNC		pfnEvent = GetEventFunction();
	//
	//PAPPLY_FUNC 	pfnApply = GetApplyEventFunction();
	
	PEVENT_GETN	pfnGetNEvent = GetNewEventFunction();
	///End ADD_OPERATION_ERRMSG_LINE
	
	tree_set_advanced_settings_file(trOperation.GUI, GetAdvanSettingsFileName()); /// Frank 4/5/05 GUI_ADVANCED_SETTING_FROM_FILE
	
	//---- CPY 5/8/2007 QA70-9740 GETN_EVENT_NEED_TO_KNOW_DLG_OPEN_MODE
	int nExecMode = bChangeParams?OEXEM_ON_CHANGEPARAM:OEXEM_ON_CREATE;
	trOperation.GUI.SetAttribute(STR_EXEC_MODE_ATTRIB, nExecMode);
	//----
	
	///Joseph 01/29/07	ADD_OPERATION_ERRMSG_LINE
	//use the new GetNBox function
	/*
	//---- Iris 11/10/06 REMOVE_TRY_BUTTON_FOR_ANALYSIS_STATS_DLG from Snow's suggestion
	//return GetNBox(trOperation.GUI, GetDlgTitle(trOperation), getAnalysisName(trOperation, false), GetNBox_on_try_operation, pfnEvent, GetWindow());
	return GetNBox(trOperation.GUI, GetDlgTitle(trOperation), getAnalysisName(trOperation, false), pfnApply, pfnEvent, GetWindow());
	//----
	*/
	///Cheney 2007-4-20 OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
	//return GetNBox(trOperation.GUI, pfnGetNEvent, GetDlgTitle(trOperation), getAnalysisName(trOperation, false), GetWindow());	
	///------ Folger 04/07/09 F1_MAPPING_NOT_WORKING_IN_STATS_XF_ON_G
	/// Since Echo said that G and E version should use Origin.chm similarly, as well as J ( except Stats' XFs,
	/// which is considered in DynaDlg::OnHelp ), so simply remove the constraint here.
	//if(is_use_origin_chm())
	///------ End F1_MAPPING_NOT_WORKING_IN_STATS_XF_ON_G
		trOperation.GUI.SetAttribute(STR_HELPID_ATTRIB, GetHelpID());		//------ Folger 11/14/07 MAP_OPERATION_DIALOG_HELP
	
	return GetNBox(trOperation.GUI, pfnGetNEvent, GetDlgTitle(trOperation), GetAnalysisName(trOperation, false), GetWindow());	
	///end OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
	///End ADD_OPERATION_ERRMSG_LINE
	/// Iris 10/14/04 SHOW_MODELESS_GETNBOX
	/*
	if( !bIsModeless )
		return GetNBox(trOperation.GUI, GetDlgTitle(trOperation), getAnalysisName(trOperation, false), GetNBox_on_try_operation, pfnEvent, GetWindow());
	else
	{
		CreateGetNBox(pDlgPtr, trOperation.GUI, GetDlgTitle(trOperation), getAnalysisName(trOperation, false), GetNBox_on_try_operation, pfnEvent, GetWindow())
		return true;
	}
	*/
	///End SHOW_MODELESS_GETNBOX
}

//virtual
//BOOL	Operation::ChangeParam()
void Operation::doChangeParam()// CPY 9/24/04, there is some bug, we cannot call from VC to an OC function that is implememted in separate .c file yet
{
	//bool bAutoUpdate = true;
	int nAutoUpdate = AU_ON_COMMAND;
	bool bOK = Edit(true, nAutoUpdate, NULL);
	if(bOK)
		Execute(OEXEM_ON_CHANGEPARAM);
	
	//return true;
}
//----- CPY 3/28/07 MOVE_ON_NO_EDIT_TO_AVOID_ADDING_WKS_OP_FOR_OC_CALL
/*	
//virtual
void	Operation::OnNoEdit(int nOption, int& nAutoUpdate, LPCSTR lpcszTheme, bool bSetDefaultInput, DWORD dwAuxData) // if no GUI open and proceed directly to execute
{
	Tree trOperation;
	GetTree(trOperation);
	int nWasAutoUpdateInGui = trOperation.GUI.AutoUpdate.nVal; 
	int nNewOPMode;
	if(lpcszTheme)
	{
		string strSelTheme = lpcszTheme;
		OperationtoGUI(trOperation, true, &strSelTheme, bSetDefaultInput);
		nNewOPMode = GUI_OP_NEW_NO_EDIT;
	}
	else
	{
					//--- CPY 8/17/05 NLFIT_SEL_PARTIAL_RANGE_OK_BUTTON_BECOMES_FULL_RANGE, added bSetDefaultInput to pass through into OperationtoGUI
		OperationtoGUI(trOperation, true, NULL, bSetDefaultInput); // do not load anything or update anything related to theme
		nNewOPMode = GUI_OP_NEW;// edit was done outside, theme info already in tree
	}
	
	//---- CPY 12/2/04 AUTO_UPDATE_ALLOW_THEME_CONTROL,
	//if(lpcszTheme)
	//	trOperation.GUI.AutoUpdate.nVal = nWasAutoUpdateInGui;
	//---
	
	/// Iris 02/13/2007 v8.0560 SHOULD_SUPPORT_AUTOUPDATE_WHEN_SELECT_THEME_FROM_MENU, by Max's design
	///end SHOULD_SUPPORT_AUTOUPDATE_WHEN_SELECT_THEME_FROM_MENU
	
	nAutoUpdate = trOperation.GUI.AutoUpdate.nVal;
		
	if(GUItoOperation(trOperation, nNewOPMode))
		SetTree(trOperation);
	else
		error_report("GUItoOperation failed");
}
*/

/// YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT
BOOL	Operation::GetRegistrySettings(DWORD& dwVal, LPCSTR lpcszKey = NULL)
{
	Tree	mytree;
	GetTree(mytree);
	string strClassName = GetClassOptionName(mytree);
	
	return theme_get_registry_settings(strClassName, lpcszKey, dwVal);
}

BOOL	Operation::GetRegistrySettings(string& strVal, LPCSTR lpcszKey)
{
	Tree	mytree;
	GetTree(mytree);
	string strClassName = GetClassOptionName(mytree);
	
	return theme_get_registry_settings(strClassName, lpcszKey, strVal);
}

void	Operation::SetRegistrySettings(const string& strVal, LPCSTR lpcszKey)
{
		Tree	mytree;
		GetTree(mytree);
		string strClassName = GetClassOptionName(mytree);
		theme_set_registry_settings(strClassName, lpcszKey, strVal);	
}
/// end XF_THEME_SUPPORT



//virtual 
BOOL WksReportOperation::GUItoOperation(TreeNode& trOperation, int nFrom)// = GUI_OP_NEW);
{
	TreeNode		trGUI = trOperation.GUI;
	if(!trGUI)
		return error_report("GUItoOperation error, Operation has No GUI branch");
	
	/// Iris 11/16/06 ADD_PARAMETER_SETTING_TO_THEME
	ParamsFromGUItoOperation(trOperation);
	//end ADD_PARAMETER_SETTING_TO_THEME
	
	/// ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE
	int				nDRTreeOption = GetDRTreeOption(trOperation);
	/// end ANOVA_INPUT_DATA_TO_DATARANGE
	
	///Joseph 04/03/07 CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
	//if there is no theme control, should not update last use theme
	/*
	///Jasmine 10/11/05 v8.0316 SAVE_LAST_USED_FOR_CHANGE_PARAMS  Change Parameters should also save Last Used
	//if(GUI_OP_NEW == nFrom) // need to check saving into Last Used from GUI new
	if(GUI_OP_NEW == nFrom || GUI_OP_CHANGE_PARAMS == nFrom)
	///End SAVE_LAST_USE_FOR_CHANGE_PARAMS
	*/
	if(is_theme_dialog(trGUI) && GUI_OP_NEW == nFrom	)
	///End CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
	{
		/// ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE
		//prepare_input_data_for_operation(trOperation.GUI.InputData); //CPY 5/19/05 XF_RUN_OP, MOVE_DR_UID_AWAY_FROM_INIT_FROM_SEL
		prepare_input_data_for_operation(trOperation.GUI.InputData, true, nDRTreeOption);
		/// end ANOVA_INPUT_DATA_TO_DATARANGE
		
		/// YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT
		/*
		string strThemeFile, strFullpathFile;
		tree_get_file_name(trGUI, strThemeFile);///Frank 1/24/05 v8.0185 CENTRALIZE_CODE_OF_FILE_NAME_ATTRIB
		//theme_get_file_info(trGUI, strThemeFile);
		//trGUI.GetAttribute(STR_THEME_FILE_ATTRIB, strThemeFile);
		///Iris 3/09/05 QA70-7345 ADD_FB_FILTER_THEME	
		//string	strThemeFileLastUsed = theme_get_settings_file(NULL, GetThemeFilePrefix(trOperation));
		string	strThemeFileLastUsed = theme_get_settings_file(NULL, GetThemeFilePrefix(trOperation), tree_get_theme_type(trGUI));
		if(strThemeFile.IsEmpty())
			strThemeFile = strThemeFileLastUsed;
		
		string strThemeName = okutil_theme_file_to_display_name(strThemeFile);
		SetRegistrySettings(strThemeName);
		///Frank 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE
		string strShowAdvanced;
		trGUI.GetAttribute(STR_SHOW_ADVANCED_ATTRIB, strShowAdvanced);
		SetRegistrySettings(strShowAdvanced, STR_SHOW_ADVANCED);
		///End	GETN_DLG_ADVANCED_CHECK_SAVE
		
		//save current settings into "Last Used" theme file
		tree_set_file_name(trGUI, strThemeFileLastUsed);///Frank 1/24/05 v8.0185 CENTRALIZE_CODE_OF_FILE_NAME_ATTRIB
		//theme_set_file_info(trGUI, strThemeFileLastUsed);
		//trGUI.SetAttribute(STR_THEME_FILE_ATTRIB, strThemeFileLastUsed);
		if(!theme_save_settings(trGUI))
			error_report("saving to Last Used settings file failed");
		*/
		
		//------ Folger 05/07/08 SHOULD_NOT_GENERATE_OPERATION_THEME_WHEN_RUN_FROM_PA
		int nNoOperationTheme = 0;
		if ( !trOperation.GetAttribute(STR_NO_OPERATION_THEME_ATTRIB, nNoOperationTheme) || nNoOperationTheme == 0 )
		{
		//------
		string strClassName = GetClassOptionName(trOperation);
		///Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME
		//theme_update_last_used(strClassName, trGUI);
		ThemeUpdateLastUsed(strClassName, trGUI);
		///end CORRECT_LOGIC_OF_LOADING_THEME
		/// end XF_THEME_SUPPORT
		//------ Folger 05/07/08 SHOULD_NOT_GENERATE_OPERATION_THEME_WHEN_RUN_FROM_PA
		}
		//------
		
		//not used now, will delect this later.
		//separate_output_for_multiple_data(trOperation);  /// Iris 2/06/06 QA70-8388 INDEP_DATA_CONSOLID_OR_SEP_REPORT
		
	}
	///DSC 6/19/05 PREPARE_INPUT_WHEN_FROM_MENU_CMD Fit Linear menu was failing
	else if(GUI_OP_NEW_NO_EDIT == nFrom)
	{
		/// ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE
		//prepare_input_data_for_operation(trOperation.GUI.InputData); //CPY 5/19/05 XF_RUN_OP, MOVE_DR_UID_AWAY_FROM_INIT_FROM_SEL
		prepare_input_data_for_operation(trOperation.GUI.InputData, true, nDRTreeOption);
		/// end ANOVA_INPUT_DATA_TO_DATARANGE
	}
	///end PREPARE_INPUT_WHEN_FROM_MENU_CMD
	
	trOperation.Operation.AutoUpdate.nVal = trGUI.AutoUpdate.nVal;
	return true;
}

//virtual
void WksReportOperation::FilterTreeForGUI(TreeNode& trOp) //CPY 1/3/04 NLSF_ALWAYS_SHOW_ADVANCED_GUI
{
	//--- CPY 1/28/05 this is now done inside GetNBox.c, so remove from here, there might be other 
	// reason to filter things though
	//update_param_tree_advanced_ids(trOp.GUI);
	//---
	
	//---- Iris 8/25/05 CAN_CHOOSE_PASTE_RESULT_TABLE_OR_NOT_WHEN_FIT_FROM_GRAPH
	///Sophy 1/23/2009 v8.0964b CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
	//TreeNode trPasteCustomTable = trOp.GUI.Output.PasteResultTable;
	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trPasteCustomTable = trOp.GUI.Output.PlotSettings.PasteResultTable;
	TreeNode trPasteCustomTable	= OP_GUI_GRAPH_ARRANGEMENT_NODE(trOp.GUI).PasteResultTable;
	///end OP_DLG_NEW_STRUCTURE
	///end CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
	if(trPasteCustomTable)
	{
		GraphLayer gl = Project.ActiveLayer();
		trPasteCustomTable.Show = gl.IsValid()? true : false;
	}
	//----
}

///Arvin 10/22/07 ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
bool WksReportOperation::isMultiPlotFit(TreeNode trGUI)
{
	TreeNode trInput = trGUI.InputData;
	DataRange drInput;
	drInput.Create();
	drInput.SetTree(trInput);
	if(!drInput)
		return false;
	
	vector<uint> vPlotUID;
	drInput.GetPlots(vPlotUID);
	vector<string> vGPNames;
	get_graph_page_names_by_plot_id(vPlotUID, vGPNames);
	return has_two_same_strings(vGPNames);
}
///end ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR

///Arvin 11/20/07 QA70-10708 CHECK_AND_CONVERT_DOUBLE_VALUES_FROM_GERMAN_TO_ENGLISH
static bool _is_currrent_operation_version(const TreeNode& trOperation)
{
	int nCurrentOperationVersion = 0;
	trOperation.GetAttribute(STR_OP_VERSION, nCurrentOperationVersion);
	if(CURRENT_OPERATION_VERSION == nCurrentOperationVersion)
		return true;
	
	return false;
}
///end CHECK_AND_CONVERT_DOUBLE_VALUES_FROM_GERMAN_TO_ENGLISH

//virtual
/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
//BOOL	WksReportOperation::OperationtoGUI(TreeNode& trOperation, bool bInit, string* pstrSelectedTheme, bool bSetDefaultInputOnInit) //=NULL, = true
///Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
//BOOL	WksReportOperation::OperationtoGUI(TreeNode& trOperation, bool bInit, string* pstrSelectedTheme, bool bSetDefaultInputOnInit, bool bFromHotkey/* = false*/) //=NULL, = true
BOOL	WksReportOperation::OperationtoGUI(TreeNode& trOperation, bool bInit, string* pstrSelectedTheme, bool bSetDefaultInputOnInit, DWORD dwExeCtrl/* = 0*/, DWORD dwParam/* = 0*/) //=NULL, = true
///end SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
{
	TreeNode		trGUI = trOperation.GUI;
	if(!trGUI)
		return error_report("OperationtoGUI error, Operation has No GUI branch");
	
	trGUI.AutoUpdate.nVal = tree_node_get_int(trOperation.Operation.AutoUpdate, AU_ON_COMMAND); ///CPY 12/2/04 AUTO_UPDATE_ALLOW_THEME_CONTROL, moved up here so theme can modify this as well
	///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	TreeNode trOutput = trGUI.FindNodeByAttribute(STR_BACKUP_ID_ATTRIB,IDST_OUTPUT_RESULTS_OPTIONS);//find by backup ID
	if( !trOutput )
	{
		trOutput = tree_get_node_by_dataid( trGUI,IDST_OUTPUT_RESULTS_OPTIONS,true );//find by ID recursively,need to do this when constructing GUI tree
	}
	if( trOutput )
		trOutput.SetAttribute(STR_CHANGE_PARAM_ATTRIB, bInit?0:1);
	///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	if(bInit)
	{
		/// YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT
		/*
		if(pstrSelectedTheme) // load theme only if this is provided
		{
			if(pstrSelectedTheme->IsEmpty())
				GetRegistrySettings(*pstrSelectedTheme);
			///Frank 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE
			string strShowAdvanced;
			GetRegistrySettings(strShowAdvanced, STR_SHOW_ADVANCED);
			theme_apply_and_set_attribute(trOperation.GUI, *pstrSelectedTheme, GetThemeFilePrefix(trOperation), strShowAdvanced.IsEmpty()? false:true); 
			//_theme_apply_and_set_attribute(trOperation.GUI, *pstrSelectedTheme, GetThemeFilePrefix(trOperation)); 
			///End	GETN_DLG_ADVANCED_CHECK_SAVE
		}
		*/
		if(pstrSelectedTheme)
		{
			string strTemp = *pstrSelectedTheme;
			string strClassName = GetClassOptionName(trOperation);
			///Cheney 2007-6-6 SHOULD_LOAD_FACTORY_DEFAULT_THEME_FOR_OPERATION_TOOLS_WHEN_OPEN_DLG
			//as Easwar and Max's suggestion
			//theme_apply_analysis_theme(strClassName, trOperation.GUI, strTemp);
			//----- CPY 7/17/2007 QA70-10010-P3 LAST_USED_THEME_WHEN_NOT_FOUND_BREAK_UPDATE_INPUT_TREE
			//theme_apply_analysis_theme(strClassName, trOperation.GUI, pstrSelectedTheme->IsEmpty()? THEME_FILENAME_FACTORY_DEFAULT : strTemp);
			///Arvin 02/25/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION	
			//BOOL bThemeApplied = theme_apply_analysis_theme(strClassName, trOperation.GUI, pstrSelectedTheme->IsEmpty()? THEME_FILENAME_FACTORY_DEFAULT : strTemp);
#ifdef SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
			///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
			/*
			Tree trTheme;  
			BOOL bThemeApplied = v(strClassName, trOperation.GUI, pstrSelectedTheme->IsEmpty()? THEME_FILENAME_FACTORY_DEFAULT : strTemp, true, trTheme);
			if(trTheme)
				ConstructParamBranchByThemeTree(trTheme, trOperation, pstrSelectedTheme->IsEmpty()? THEME_FILENAME_FACTORY_DEFAULT : strTemp);
			*/
			///---Sim 09-05-2008 QA80-12151 NLFIT_TOO_SLOW_TO_OPEN
			//BOOL bThemeApplied = ApplyTheme(strClassName, trOperation.GUI, pstrSelectedTheme->IsEmpty()? THEME_FILENAME_FACTORY_DEFAULT : strTemp, true);
			//no need to set factory default, as here GUI is initialized.
			///Sophy 12/19/2008 v8.0988c FIX_POLYNOMIAL_FIT_CAN_NOT_LOAD_DEFAULT_THEME_SETTINGS when fit from "Open Dialog..."
			if ( strTemp.IsEmpty() && theme_get_default_settings(strClassName) )
				strTemp = STR_DEFAULT_E;
			///end FIX_POLYNOMIAL_FIT_CAN_NOT_LOAD_DEFAULT_THEME_SETTINGS
			BOOL bThemeApplied = false;
			//if ( !theme_is_factory_default(strTemp) ) // must entry to apply theme, that will construct parameter treenode
				bThemeApplied = ApplyTheme(strClassName, trOperation.GUI, strTemp, false);
			///---END QA80-12151 NLFIT_TOO_SLOW_TO_OPEN
			///---END QA80-11371 THEME_SAVING_OPTIONS
#else
			BOOL bThemeApplied = theme_apply_analysis_theme(strClassName, trOperation.GUI, pstrSelectedTheme->IsEmpty()? THEME_FILENAME_FACTORY_DEFAULT : strTemp);
#endif //SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION		
			if(!bThemeApplied)
				pstrSelectedTheme = NULL;
			//-----
			///end SHOULD_LOAD_FACTORY_DEFAULT_THEME_FOR_OPERATION_TOOLS_WHEN_OPEN_DLG
		}
		/// end XF_THEME_SUPPORT
		
		AddClassInfo(trOperation);
		//--- CPY 11/2/04 INIT_FROM_SEL_MOVED_TO_OPERATION_TO_GUI
		/// Hong 09/04/09 QA80-14258 HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING
		//if(bSetDefaultInputOnInit && !InitFromSelection(trOperation))
		int		nInitRet = 1;
		if ( bSetDefaultInputOnInit )
			nInitRet = InitFromSelection(trOperation);
		if ( 0 > nInitRet )
			return false;
		if ( 0 == nInitRet )
		/// end HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING
		{
			error_report("OperationtoGUI failed to init default Input Data");
		}
		///Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
		//if select from theme, update input branch here, instead of FitNL::doOneFit
		///Cheney 2007-4-28 IF_NOT_XY_FITTING_SHOULD_NOT_REINIT_INPUT_BRANCH
		//if(pstrSelectedTheme && !pstrSelectedTheme->IsEmpty())
		///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
		//if(pstrSelectedTheme && !pstrSelectedTheme->IsEmpty() && !HasZ(trOperation))
		///------ Folger 01/06/09 QA80-12878-P1 v8.0993e NLFIT_FAILS_TO_GET_ALL_DATAPLOTS_FROM_GRAPH
		//if( pstrSelectedTheme && !theme_is_factory_default(*pstrSelectedTheme) && !HasZ(trOperation))
		if( pstrSelectedTheme && !HasZ(trOperation))
		///------ End NLFIT_FAILS_TO_GET_ALL_DATAPLOTS_FROM_GRAPH
		///---END CLEAN_DEFAULT_THEME
		///end IF_NOT_XY_FITTING_SHOULD_NOT_REINIT_INPUT_BRANCH
			UpdateInputBranch(trOperation);
		///end CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
		//---
		///Iris 12/3104 IMPROVE_ACCESS_ADVANCED_IDS_FUNC
		///Iris 12/27/04 IMPROVE_ACCESS_ADVAN_IDS_THEME_FILE
		//_theme_apply_and_set_advanced_ids_attribute(trOperation.GUI, GetThemeFilePrefix(trOperation), BUILD_IN_ADVANCED_IDS_THEME_FILENAME);
		//_theme_apply_and_set_advanced_ids_attribute(trOperation.GUI);
		FilterTreeForGUI(trOperation);
		///end IMPROVE_ACCESS_ADVANCED_IDS_FUNC
		
		ASSERT(_is_currrent_operation_version(trOperation));	///Arvin 11/20/07 QA70-10708 CHECK_AND_CONVERT_DOUBLE_VALUES_FROM_GERMAN_TO_ENGLISH

	}
	//trGUI.AutoUpdate.nVal = tree_node_get_int(trOperation.Operation.AutoUpdate, 1);
	///Arvin 11/20/07 QA70-10708 CHECK_AND_CONVERT_DOUBLE_VALUES_FROM_GERMAN_TO_ENGLISH
	else
	{
		int nCurrentOperationVersion = -1;
		trOperation.GetAttribute(STR_OP_VERSION, nCurrentOperationVersion);
		CheckLoadOperation(trOperation, nCurrentOperationVersion);
	}
	///end CHECK_AND_CONVERT_DOUBLE_VALUES_FROM_GERMAN_TO_ENGLISH
	
	if(bInit)
	{
		trGUI.AutoUpdate.Enable = true;
		GUIPrepareOutputBranch(trGUI);
	}
	else
	{
		string strReportSheetName;
		DataRange rgOut;
		Worksheet wksOut;
		if(GetOutput(rgOut, wksOut))
			GUIPrepareOutputBranch(trGUI, wksOut);
		else
			GUIPrepareOutputBranch(trGUI);
		
		//Joseph 04/03/07 if dialog from change parameter, Autoupdate and the theme both can't be changed.
		trGUI.AutoUpdate.Enable = false;  
	}
	
	/// YuI 04/02/07 DATA_MODE_MUST_BE_DISABLED_IN_CHANGE_PARAM
	if( trGUI.InputData )
	{
		BOOL bChangeParam = !bInit;
		trGUI.InputData.SetAttribute(STR_CHANGE_PARAM_ATTRIB, bChangeParam);
	}
	/// end DATA_MODE_MUST_BE_DISABLED_IN_CHANGE_PARAM

	///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	/*
	if(trGUI.Output.Report)
	{
		trGUI.Output.Report.Sheet.Enable = bInit;
		trGUI.Output.Report.Book.Enable = bInit;
	}
	if(trGUI.Output.Data)
	{
		trGUI.Output.Data.Sheet.Enable = bInit;
		trGUI.Output.Data.Book.Enable = bInit;
	}
	
	if(trGUI.Output.Residual)
	{
		trGUI.Output.Residual.Sheet.Enable = bInit;
		trGUI.Output.Residual.Book.Enable = bInit;
	}
	
	if(trGUI.Output.FindXY)
	{
		trGUI.Output.FindXY.Sheet.Enable = bInit;
		trGUI.Output.FindXY.Book.Enable = bInit;
	}
	*/
	///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	
	///Arvin 10/22/07 ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
	TreeNode trSetColor = trGUI.Graph1.SetColor;
	if(trSetColor && trSetColor.Show)
	{
		//TreeNode trReplicaNum = trGUI.Fit.Replica.Number;
		//if(trReplicaNum && trReplicaNum.nVal > 0)
		//	trGUI.Graph1.SetColor.Enable = false;
		//else
		bool bMultiPlotFit = isMultiPlotFit(trGUI);
		trSetColor.Enable = bMultiPlotFit&&bInit;
		if(!trSetColor.Enable)
			trSetColor.nVal = 0;
	}
	///end ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
	
	///Arvin 02/20/08 QA70-11094-P4 DISABLE_PLOT_ALL_IN_ONE_CHECKBOX_WHEN_CHANGE_PARAM
	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trPlotInOne = trGUI.Output.PlotSettings.PlotInOneGraph;
	TreeNode trPlotInOne = OP_GUI_GRAPH_ARRANGEMENT_NODE(trGUI).PlotInOneGraph;
	///end OP_DLG_NEW_STRUCTURE
	if(trPlotInOne && trPlotInOne.Show)
	{
		trPlotInOne.Enable = bInit; 
	}
	///end DISABLE_PLOT_ALL_IN_ONE_CHECKBOX
	///--- DSC 2/4/05 NLFIT_THEME_DROP_LIST moved following from inside ShowDlg
	//Frank 01/22/05 v8.0185b THEME_CENTERZIER_CODE
	trOperation.GUI.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, GetThemeFilePrefix(trOperation));
	///End THEME_CENTERZIER_CODE
	//----

	/// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS
	////----- CPY 10/2/05 DESC_STATS_ON_ROWS_NEED_REPORT_TO_SOURCE
	//int	nOption = GetOptionIndex(trGUI);
	//if(IsEnableInsertResultColumnsToSourceData(nOption))
		//trOperation.GUI.SetAttribute(STR_ALLOW_REPORT_TO_SOURCE_SHEET_ATTRIB, 1);
	//else
		//trOperation.GUI.RemoveAttribute(STR_ALLOW_REPORT_TO_SOURCE_SHEET_ATTRIB);
	////-----
	///end ADD_DescStats_OUTPUT_CLASS
	
	return true;
}

/// ML 6/5/2007 QA70-9869 SPECIAL_GUI_TREE_UPDATE_BEFORE_RERUNNING
// virtual
/// YuI 06/06/08 QA70-11619 MORE_CLEAR_WORKSHEET_PROBLEM
//	void	WksReportOperation::GUIOnUpdateTreeBeforeRunning(TreeNode &trGUINew, TreeNode &trGUIOriginal)
///---Sim 04-02-2009 QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE
//void	WksReportOperation::GUIOnUpdateTreeBeforeRunning(TreeNode &trGUINew, TreeNode &trGUIOriginal, TreeNode& trOperation)
void	WksReportOperation::GUIOnUpdateTreeBeforeRunning(const MultipleVersion& mvOld, TreeNode &trGUINew, TreeNode &trGUIOriginal, TreeNode& trOperation)
///---END QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE
/// end MORE_CLEAR_WORKSHEET_PROBLEM
{
	return;
}
/// end SPECIAL_GUI_TREE_UPDATE_BEFORE_RERUNNING

/// ML 11/20/2007 QA70-10716 INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER
// virtual
bool	WksReportOperation::customLocUpdateInputDataStrings(TreeNode &trInputDataConstructed, TreeNode &trInputDataLoaded)
{
	return false;
}



// virtual
int		WksReportOperation::getLocUpdateInputDataStringsMode()
{
	return LUIDMODE_DEFAULT;
}

bool	WksReportOperation::onLocUpdateInputDataStrings(TreeNode &trInputDataConstructed, TreeNode &trInputDataLoaded, TreeNode &trOp)
{
	int			mode = getLocUpdateInputDataStringsMode();
	switch (mode)
	{
	case LUIDMODE_DEFAULT:
		// nothing
		break;
		
	case LUIDMODE_FIXED_STRUCTURE:
		//	octree_copy_atts(&trInputDataConstructed, &trInputDataLoaded, STR_LABEL_ATTRIB);
		okutil_localize_input_data_node_labels(&trInputDataLoaded, GetDataRules(trOp));
		break;
		
	case LUIDMODE_CUSTOM:
		return customLocUpdateInputDataStrings(trInputDataConstructed, trInputDataLoaded);
	}
	
	return true;
}
/// end INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER

/// ML 3/1/2007 QA70-9421 UPDATE_TRGUI_TO_CURRENT_BEFORE_RUNNING
/// YuI 11/19/07 QA70-10716 GUI_LOCALIZATION_ON_CHANGE_PARAM
//	bool	WksReportOperation::updateTreeBeforeRunning(TreeNode &trOp)
bool	WksReportOperation::updateTreeBeforeRunning(TreeNode &trOp, BOOL bLocalize)
/// end GUI_LOCALIZATION_ON_CHANGE_PARAM
{
	Tree		tr;
	TreeNode	trOpLoc;
	if (trOp.IsValid())
		trOpLoc = trOp;
	else
	{
		GetTree(tr);
		trOpLoc = tr;
	}
	TreeNode	trGUI = trOpLoc.GUI;
	///Cheney 2007-4-19 CHANGE_PARAMS_SHOULD_APLLY_LAST_PARAMS_SETTING	
	TreeNode trParameters = trOpLoc.GUI.Parameters;
	///end CHANGE_PARAMS_SHOULD_APLLY_LAST_PARAMS_SETTING
	int			nOption = GetOptionIndex(trGUI);

	Tree		trOperTemp;
	BOOL		bDisableSetTreeCache = m_bDisableSetTree;
	m_bDisableSetTree = TRUE;		// it will ASSERT in VC if SetTree() called from within Construct().  
	
	//------ Folger 06/20/08 QA80-11749 REMOVE_UNWANTED_SUBNODES_FOR_GENERAL_XY_FITTING
	// need to pass fitting info into Construct()
	if ( trOpLoc.SpecInfo )
		trOperTemp.AddNode(trOpLoc.SpecInfo.Clone());
	//------
	
	bool		bb = Construct(trOperTemp, nOption);
	m_bDisableSetTree = bDisableSetTreeCache;	
	if (!bb)
		///Cheney 2007-7-18 CLEAN_UP_ERR_HANDLING
		//return false;
		return error_report("Construct trOperTemp failed before running");
		///end CLEAN_UP_ERR_HANDLING
		
	///Cheney 2007-9-6 FINDZ_NODE_SHOULD_PREPARED_WHEN_CHANGE_PARAM
	if(HasZ(trOpLoc))
		UpdateCalibrationBranch(trOperTemp);
	///end FINDZ_NODE_SHOULD_PREPARED_WHEN_CHANGE_PARAM
	
	TreeNode	trGUINew = trOperTemp.GUI;
	
	TreeNode	trInputData = trGUI.InputData;
	TreeNode	trInputDataNew = trGUINew.InputData;
	/// ML 5/10/2007 MUST_PRESERVE_NEW_STR_ATTRIB_HANDLER_RC_IN_INPUT_DATA
	string		strEventHandler;
	BOOL		bHasEventHandler = trInputDataNew.GetAttribute(STR_ATTRIB_HANDLER_RC, strEventHandler);
	/// end MUST_PRESERVE_NEW_STR_ATTRIB_HANDLER_RC_IN_INPUT_DATA
	if (trInputData.IsValid() && trInputDataNew.IsValid())
	{
		/// ML 11/20/2007 QA70-10716 INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER
		if ( bLocalize )
			onLocUpdateInputDataStrings(trInputDataNew, trInputData, trOp);
		/// end INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER
		// This has to be done because the input data structure from the default Construct() above is no good
		trInputDataNew.Replace(trInputData, TRUE);
		/// ML 5/10/2007 MUST_PRESERVE_NEW_STR_ATTRIB_HANDLER_RC_IN_INPUT_DATA
		if ( bHasEventHandler )
			trInputDataNew.SetAttribute(STR_ATTRIB_HANDLER_RC, strEventHandler);
		/// end MUST_PRESERVE_NEW_STR_ATTRIB_HANDLER_RC_IN_INPUT_DATA
	}
	
	int			nn = tree_copy_values_by_id(trGUI, trGUINew);
	/// Hong 03/20/09 QA80-13327 FIX_GUI_TREENODE_SHOW_AND_ENALBE_STATUS_LOST_WHEN_RECALCULATE_OR_CHANGE_PARAMETER
	octree_copy_atts_by_id(&trGUI, &trGUINew, STR_SHOW_ATTRIB, NULL, NULL, STR_ENABLE_ATTRIB);
	/// end FIX_GUI_TREENODE_SHOW_AND_ENALBE_STATUS_LOST_WHEN_RECALCULATE_OR_CHANGE_PARAMETER
	
	/// ML 6/5/2007 QA70-9869 SPECIAL_GUI_TREE_UPDATE_BEFORE_RERUNNING
	/// YuI 06/06/08 QA70-11619 MORE_CLEAR_WORKSHEET_PROBLEM
	//	GUIOnUpdateTreeBeforeRunning(trGUINew, trGUI);
	///---Sim 04-02-2009 QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE
	//GUIOnUpdateTreeBeforeRunning(trGUINew, trGUI, trOpLoc);
	MultipleVersion mvOld;
	GetIndividualVersion(trOpLoc, mvOld);
	
	GUIOnUpdateTreeBeforeRunning(mvOld, trGUINew, trGUI, trOpLoc);
	///---END QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE
	/// end MORE_CLEAR_WORKSHEET_PROBLEM
	/// end SPECIAL_GUI_TREE_UPDATE_BEFORE_RERUNNING
	
	/// Hong 06/20/08 QA8011751 FIX_OLD_TABLE_FAIL_DEL_WHEN_NAME_ENUMERATED
	// i can't find any way to keep my attribute when Change Parameter without this dirty fix.(refer to addResultsTblToSourceGraph)
	// Hong, to do, this reconstruction mechanism is reasonable somehow, but the evil copy value only
	// for treenode leads to problem once operation depends on treenode attribute which we really do.
	// So, when rewrite code, need to think whether improve code here avoid missing attributes,
	// or, we need to clear code of operation, and proudly say, we depend on nothing except values in operation tree.
	if ( trGUI.Output && trGUINew.Output )
	{
		/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//TreeNode	trPlotSettings = trGUI.Output.PlotSettings;
		//TreeNode	trPlotSettingsNew = trGUINew.Output.PlotSettings;
		TreeNode	trPlotSettings = OP_GUI_GRAPH_ARRANGEMENT_NODE(trGUI);
		TreeNode	trPlotSettingsNew = OP_GUI_GRAPH_ARRANGEMENT_NODE(trGUINew);
		///end OP_DLG_NEW_STRUCTURE
		if ( trPlotSettings && trPlotSettingsNew )
		{
			TreeNode	trReport = trPlotSettings.PasteResultTable;
			TreeNode	trReportNew = trPlotSettingsNew.PasteResultTable;
			if ( trReport && trReportNew )
			{
				int 	nUID;
				if ( trReport.GetAttribute(TREE_UID, nUID) )
					trReportNew.SetAttribute(TREE_UID, nUID);
			}
		}
	}
	/// end FIX_OLD_TABLE_FAIL_DEL_WHEN_NAME_ENUMERATED
#ifdef		_CHANGE_PARAMS_SUPPORT_LAODING_THEME_AND_COMPARING_THEME /// Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5
	///Sophy 12/18/2008 v8.0988 QA80-12798 CHANGE_PARAMETERS_SHOULD_SHOW_THEME_MENU keep useful settings before replaced
	octree_copy_atts(&trGUI, &trGUINew, STR_THEME_NAME_ATTRIB);
	///end CHANGE_PARAMETERS_SHOULD_SHOW_THEME_MENU
#endif		//_CHANGE_PARAMS_SUPPORT_LAODING_THEME_AND_COMPARING_THEME /// Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5
	trGUI.Reset();
	trGUI.Replace(trGUINew, TRUE);
	
	/// Hong 02/03/10 QA80-15016 FIX_X_DATA_TYPE_CHANGE_WHEN_RECALCUTE
	///Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
	//change_indep_data_type_combo_on_source_page_type(trGUI, trGUI.InputData);
	change_indep_data_type_combo_on_source_page_type(trGUI, trGUI.InputData, _get_fit_type(trOpLoc));
	///End ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
	/// end FIX_X_DATA_TYPE_CHANGE_WHEN_RECALCUTE
	
	///Cheney 2007-4-19 CHANGE_PARAMS_SHOULD_APLLY_LAST_PARAMS_SETTING
	if(trParameters)
		trGUI.AddNode(trParameters.Clone());
	///end CHANGE_PARAMS_SHOULD_APLLY_LAST_PARAMS_SETTING
	
	if (!trOp.IsValid())
		SetTree(tr);
	
	return true;
}
/// end UPDATE_TRGUI_TO_CURRENT_BEFORE_RUNNING

///Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
//base on FitNL::GetFitType
static int 	_get_fit_type(TreeNode& trOp)
{
	TreeNode		trSpec = trOp.SpecInfo;
	if(!trSpec)
	{		
		if(trOp.FitType && !trOp.FitType.IsEmpty())
			return trOp.FitType.nVal;
		return -1;
	}
	
	return trSpec.FitType.nVal;
}
///End ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT

/// ML 2/14/2007 QA70-9374 BAD_EVENT_HANDLER_DWORDS_IN_TREENODES
// virtual
bool	WksReportOperation::updateEventHandlers(TreeNode &trOp)
{
	TreeNode	trGUI = trOp.GUI;
	if (!trGUI)
		return false;
	
	int			nOption = GetOptionIndex(trGUI);
	Tree		trOperTemp;
	BOOL		bDisableSetTreeCache = m_bDisableSetTree;
	m_bDisableSetTree = TRUE;		// it will ASSERT in VC if SetTree() called from within Construct().  
	bool		bb = Construct(trOperTemp, nOption);
	m_bDisableSetTree = bDisableSetTreeCache;	
	if (!bb)
		return false;
	
	TreeNode	trGUITemp = trOperTemp.GUI;
	octree_copy_atts_by_id(&trGUITemp, &trGUI, STR_ATTRIB_HANDLER, NULL, NULL, STR_ATTRIB_HANDLER_RC);
	
	return true;
}
/// end BAD_EVENT_HANDLER_DWORDS_IN_TREENODES


/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
//bool WksReportOperation::Edit(bool bChangeParams, int& nAutoUpdate, LPCSTR lpcszTheme, bool bSetDefaultInput)
///Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
//bool WksReportOperation::Edit(bool bChangeParams, int& nAutoUpdate, LPCSTR lpcszTheme, bool bSetDefaultInput, bool bFromHotkey/* = false*/)
bool WksReportOperation::Edit(bool bChangeParams, int& nAutoUpdate, LPCSTR lpcszTheme, bool bSetDefaultInput, DWORD dwExeCtrl/* = 0*/, DWORD dwParam/* = 0*/)
///end SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
{
	Tree trOperation;
	GetTree(trOperation);
	
	if (bChangeParams)
		updateTreeBeforeRunning(trOperation, TRUE);
	
	string strSelectedThemeName = lpcszTheme;
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	//if(!OperationtoGUI(trOperation, bChangeParams?false:true, &strSelectedThemeName, bSetDefaultInput))
	///Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
	//if(!OperationtoGUI(trOperation, bChangeParams?false:true, &strSelectedThemeName, bSetDefaultInput, bFromHotkey))
	if(!OperationtoGUI(trOperation, bChangeParams?false:true, &strSelectedThemeName, bSetDefaultInput, dwExeCtrl, dwParam))
	///end SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
		return false;
		
	/// Iris 01/19/2007 v8.0544 OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT
	//from Max, the option should be disenable when open dialog from Change Parameters
	TreeNode trRC = trOperation.GUI.Output.RCSheet;
	if(trRC)
		trRC.Enable = !bChangeParams;
	///end OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT	

	BOOL	bOK = ShowDlg(trOperation, bChangeParams);
	
	/// YuI 04/17/07 QA70-4589 IMPROVED_ANALYSIS_MARKERS
	DataRange drTempInput;
	if( GetInput(drTempInput) )
		okutil_destroy_data_markers(&drTempInput);
	/// end IMPROVED_ANALYSIS_MARKERS
	
	nAutoUpdate = AU_ON_COMMAND;
	if( bOK )
	{
		if(GUItoOperation(trOperation, bChangeParams ? GUI_OP_CHANGE_PARAMS : GUI_OP_NEW))
		{
			SetTree(trOperation);
		}
		
		nAutoUpdate = trOperation.Operation.AutoUpdate.nVal;
	}
	if( !bChangeParams )
		return bOK; // Must return TRUE; otherwise Execute never gets called.
	return bOK;
}

/// Iris 2/02/2010 QA81-14994 FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
bool WksReportOperation::checkIfNoReportTable(TreeNode& trOperation)
{	
	// use temp calculation treenode since cannot really remove hidden treenode here, for example, GraphInfo node is hidden but it will be used in report graph plotting.
	TreeNode trCalcTemp = trOperation.Calculation.Clone(); 
	
	TreeNode trClone;
	filterReportEx(trCalcTemp, trClone, TRUE, TRUE);
	bool bNoReportTable = (!trClone.IsValid() || !trClone.FirstNode.IsValid());
	return bNoReportTable;
}
///End FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET

bool WksReportOperation::isOutputReportSheet(const TreeNode& trGUI)
{
	/// Iris 2/02/2010 QA81-14994 FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
	if( m_bNoReportTable )
		return false;
	///End FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
	
#ifndef OP_DLG_TOTALLY_NEW_STRUCTURE
	TreeNode tr = trGUI.Output.Report.Book;
	if(!tr)
		return error_report("trGUI.Output.Report.Book invalid");	

	string strReportBook = tr.strVal;
	//printf("trGUI.Output.Report.Book = %s\n", strReportBook );
	if(str_to_predefined_type(strReportBook) == PDS_NONE)
		return false;
	return true;
	
#else //OP_DLG_TOTALLY_NEW_STRUCTURE

	ASSERT(trGUI.Output.Report);
	int nUse;
	bool bb = trGUI.Output.Report.GetAttribute(STR_USE_ATTRIB, nUse);
	ASSERT(bb);
	return 1 == nUse;	
	
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE
}

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
///// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME, changed to the proper function name
////bool WksReportOperation::setReportOutputBookName(TreeNode& trBook, const string& strBook, bool bAllowToSource)
//bool WksReportOperation::setReportOutputBook(TreeNode& trBook, const string& strBook, bool bAllowToSource)
/////end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
//{
	//trBook.SetAttribute( STR_ALLOW_REPORT_TO_SOURCE_BOOK_ATTRIB, bAllowToSource);
	////--------- CPY 10/15/07 QA70-10536 POST_SR0_725_OUTPUT_LOCATION_CLEANUP
	///*	
	//FUNC_BUILD_REPORT_BOOK_OPTION pfn = Project.FindFunction("build_report_book_option", "OriginLab\\Event_utils", true);
	//if(pfn)
		//return pfn(trBook, bAllowToSource, strBook);
	//return false;
	//*/
	//return build_report_book_option(trBook, bAllowToSource, strBook);
	////--------- end POST_SR0_725_OUTPUT_LOCATION_CLEANUP
//}
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS


/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
////CPY 10/18/04
/////Arvin 07/09/07 v8.0655 FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
////bool WksReportOperation::setCurvesOutputBookSheet(TreeNode& trGUI)
/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
////bool WksReportOperation::setCurvesOutputBookSheet(TreeNode& trGUI, bool bAllowToSource)
//bool WksReportOperation::setCurvesOutputBookSheet(TreeNode& trGUI, bool bAllowToSource, LPCSTR lpcszBook)
/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
/////end FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
//{
	////TreeNode trOutputBook = trGUI.Output.Report.Book;  ///Iris 11/12/04 not needed codes
	////TreeNode trOutputSheet = trGUI.Output.Report.Sheet;
	//TreeNode trCurves = trGUI.Output.Data;
	//int nSpecialType;
	/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	//string strReportBook = STR_SOURCE_BOOK;
	//if(lpcszBook)
	//{
		//string strBook(lpcszBook);
		//strReportBook += " " + strBook;
	//}
	/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	////---- CPY 11/26/04 CURVE_OUTPUT_THEME_SUPPORT_NEEDED
	///*
	//if(trCurves.Book.strVal.IsEmpty())
	//{
		//trCurves.Book.strVal = STR_REPORT;
	//}
	//if(trCurves.Sheet.strVal.IsEmpty())
	//{
		//trCurves.Sheet.strVal = STR_REPORT;
	//}
	//*/
	////----
	/////Iris 11/12/04 QA70-7139 IMPROVE_RESULT_BOOK_EVENT
	///*
	//string str = STR_TOKEN_SEP + STR_NONE + STR_TOKEN_SEP + STR_REPORT + STR_TOKEN_SEP + STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_NEW;
	//trCurves.Book.SetAttribute(STR_COMBO_ATTRIB, str);
	//str = STR_TOKEN_SEP + STR_REPORT + STR_TOKEN_SEP + STR_NEW;
	//trCurves.Sheet.SetAttribute(STR_COMBO_ATTRIB, str);	
	//*/
	//bool bNoReport = (nSpecialType==PDS_NONE || nSpecialType==PDS_SOURCE)? true:false;
	////_build_curve_ouput_book_sheet_option(trGUI,  bNoReport);	
	////_build_curve_ouput_book_sheet_option(trGUI,  nSpecialType);  /// Iris 11/30/04 QA70-7139 IMPROVE_BOOK_SHEET_OPTIONS
	////---- CPY 11/26/04 CURVE_OUTPUT_THEME_SUPPORT_NEEDED
	////trCurves.Book.strVal = STR_NEW;
	////trCurves.Sheet.strVal = STR_NEW;
	/////Frank 4/2/05		NEW_METHOD_CHECK_NODE_EMPTY
	////if(trCurves.Book.strVal.IsEmpty())
	//if(trCurves.Book.IsEmpty())
	/////End		NEW_METHOD_CHECK_NODE_EMPTY
	//{
		//trCurves.Book.strVal = STR_AUTO;	///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
		//if(bNoReport)
		//{
			/////Arvin 12/14/06 SET_DEFAULT_AS_SOURCE_BOOK by Max's suggestion
			////trCurves.Book.strVal = STR_NEW;
			/////Arvin 07/09/07 v8.0655 FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
			////trCurves.Book.strVal = STR_SOURCE_BOOK;
			/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
			////trCurves.Book.strVal = bAllowToSource ? STR_SOURCE_BOOK : STR_NEW;
			////trCurves.Book.strVal = bAllowToSource ? strReportBook : STR_NEW; 	///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
			/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
			/////end FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
			/////end SET_DEFAULT_AS_SOURCE_BOOK
			//trCurves.Sheet.strVal = STR_NEW;
		//}
		//else
		//{
			////trCurves.Book.strVal = STR_REPORT;	///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
			//trCurves.Sheet.strVal = STR_NEW;//STR_REPORT;///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH, shouldn't add to report sheet
		//}
	//}
	//else if(trCurves.Sheet.strVal.IsEmpty())
	//{
		//trCurves.Sheet.strVal = STR_NEW;
	//}
	////----
	///// Iris 11/30/04 QA70-7139 IMPROVE_BOOK_SHEET_OPTIONS
	//string str2ndPart;
	//int nCurveBookType = str_to_predefined_type(trCurves.Book.strVal, str2ndPart);
	//
	/////Cheney 2007-8-30 QA70-10290-sug4 FIX_STH_ABOUT_OUTPUT_SETTING_FOR_3D_FIT
	////theme will remember souce book name, so should correct here
	//if(PDS_SOURCE == nCurveBookType)
		//trCurves.Book.strVal = strReportBook; 
	/////end FIX_STH_ABOUT_OUTPUT_SETTING_FOR_3D_FIT
	//
	/////Iris 12/12/05 MOVE_NLF_TO_UTILS_FILE, FunctionList is empty now, so cannot use op_is_3d_function to check here.
	/////// Iris 6/14/05 NLSF_SUPPORT_XYZ_DATA, 3D function will output fitted data into matrix, so need remove <report> and <source> from list
	//////_build_output_book_sheet_option(trGUI, nSpecialType, nCurveBookType);
	////_build_output_book_sheet_option(trGUI, nSpecialType, nCurveBookType, op_is_3d_function(trGUI.Parent()));
	/////Arvin 07/09/07 v8.0655 FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
	////_build_output_book_sheet_option(trGUI, nSpecialType, nCurveBookType); 
	/////Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	////_build_output_book_sheet_option(trGUI, nSpecialType, nCurveBookType, false, bAllowToSource); 
	/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
	////FUNC_BUILD_OUTPUT_BOOK_SHEET_OPTION pfn = Project.FindFunction("build_output_book_sheet_option", "OriginLab\\Event_utils", true);
	////if(pfn)
	////	pfn(trGUI, nSpecialType, nCurveBookType, false, bAllowToSource, lpcszBook); 
	//build_output_book_sheet_option(trGUI, nSpecialType, nCurveBookType, false, bAllowToSource, lpcszBook); 
	/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	/////end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	/////end FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
	/////End MOVE_NLF_TO_UTILS_FILE
	//
	//return true;
//}
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

string WksReportOperation::getStrCheckSpecialType(LPCSTR lpcstr, int* pnSpecialType)// = NULL)
{
	string str; 
	int nType = str_to_predefined_type(lpcstr, &str);
	if(pnSpecialType)
	{
		*pnSpecialType = nType;
	}
	///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
	//if(PDS_NEW == nType || PDS_NONE == nType || PDS_REPORT == nType)
	if(PDS_NEW == nType || PDS_NONE == nType || PDS_REPORT == nType || PDS_AUTO == nType)
	///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
		str.Empty();

 	return str;
}
string WksReportOperation::getReportOutputSheetName(const TreeNode& trGUI, int* pnSpecialType)// = NULL)
{
	string str;
	TreeNode trReportSheet = trGUI.Output.Report.Sheet;
	if(trReportSheet)
	 	str = getStrCheckSpecialType(trReportSheet.strVal, pnSpecialType);
	else
		error_report("getReportOutputSheetName failed to find valid trGUI.Output.Report.Sheet"); 
	return str;
}
string WksReportOperation::getReportOutputBookName(const TreeNode& trGUI, int* pnSpecialType)// = NULL)
{
	string str;
	TreeNode trReportBook = trGUI.Output.Report.Book;
	if(trReportBook)
	 	str = getStrCheckSpecialType(trReportBook.strVal, pnSpecialType);
	else
		error_report("getReportOutputBookName failed to find valid trGUI.Output.Report.Book");
	
	return str;
}
///////////////////////////////////////////////////////////////////////////
/// Iris 7/10/06 v8.0440 QA70-7001-P14 NOT_CREATE_RESULT_CURVE_SHEET_IF_NO_REPORT_GRAPH 
//bool Operation::IsOutputSeparateResultCurveSheet(const TreeNode& trGUI) 
bool WksReportOperation::IsOutputSeparateResultCurveSheet(const TreeNode& trOp) 
{
	TreeNode trGUI = trOp.GUI;/// Iris 7/10/06 v8.0440 QA70-7001-P14 NOT_CREATE_RESULT_CURVE_SHEET_IF_NO_REPORT_GRAPH
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trCurves = trGUI.Output.Data;
	TreeNode trCurves = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	if(!trCurves || !trCurves.Show || !trCurves.Enable)
		return false;
	int nBookTye = str_to_predefined_type(trCurves.Book.strVal);
	int nSheetType = str_to_predefined_type(trCurves.Sheet.strVal);
	if(PDS_NONE == nBookTye || PDS_NONE == nSheetType)
		return false;
	if(PDS_REPORT == nBookTye && PDS_REPORT == nSheetType)
		return false;
	if(PDS_SOURCE == nSheetType)
		return false;
	
	/// Iris 7/10/06 v8.0440 QA70-7001-P14 NOT_CREATE_RESULT_CURVE_SHEET_IF_NO_REPORT_GRAPH
	///Arvin 10/23/07 QA70-10559-P3 SHOULD_NOT_CREATE_EMPTY_SHEET_WHEN_UNCHECK_FITTED_CURVES_PLOT
	//TreeNode trResultCurve = RESULT_CURVE_BRANCH(trOp);
	//if( !trResultCurve || trResultCurve.GetNodeCount() == 0 )
	//	return error_report("Found error Result Curve nodes in IsOutputSeparateResultCurveSheet");;	
	/// Iris 5/26/2008 QA80-11607-P2 FAIL_TO_REPORT_RESIDUAL_DATA_IF_UNCHECK_FITTED_CURVES_PLOT
	// !CANNOT ONLY check Graph1.Use is checked or not since can put residual data in ResultCurve tree to report together with fitted data.
	//if(!trOp.GUI.Graph1.Use)
	//	return false;
	TreeNode trResultCurve = RESULT_CURVE_BRANCH(trOp);
	if( !trResultCurve )
		return false;
	else
	{
		int 	nTables = _count_curve_tables_without_hidden_tables(trResultCurve);
		if( nTables <= 0 ) // not table or all are hidden tables
			return false; 
	}
	///end FAIL_TO_REPORT_RESIDUAL_DATA_IF_UNCHECK_FITTED_CURVES_PLOT
	///end SHOULD_NOT_CREATE_EMPTY_SHEET_WHEN_UNCHECK_FITTED_CURVES_PLOT
	///End NOT_CREATE_RESULT_CURVE_SHEET_IF_NO_REPORT_GRAPH
	return true;
}

/// Iris 5/26/2008 QA80-11607-P2 FAIL_TO_REPORT_RESIDUAL_DATA_IF_UNCHECK_FITTED_CURVES_PLOT
static int	_count_curve_tables_without_hidden_tables(const TreeNode& trResultCurve)
{
	int 	nTables = 0;
	foreach(TreeNode trOneData in trResultCurve.Children)
	{
		if( trOneData.Show )
		{
			int		nHiddenTables = tree_count_items_by_attribute(trOneData, STR_SHOW_ATTRIB, "0", false, false);
			nTables += trOneData.Children.Count() - nHiddenTables;
		}
	}
	return nTables;
}
///end FAIL_TO_REPORT_RESIDUAL_DATA_IF_UNCHECK_FITTED_CURVES_PLOT

bool WksReportOperation::isOutputInsertColsToDataSheet(const TreeNode& trGUI, bool& bInsertCurves, int nOutputIndex)
{
	bInsertCurves = false;
	TreeNode tr = trGUI.Output.Report.Sheet;
	if(tr)
	{
		string str = tr.strVal;
		///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
		//if(str == STR_INSERT_SOURCE_SHEET)
		//--------- CPY 4/24/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
		//if( PDS_SOURCE == cvt_str_to_predefined_type(str) )
		if(PDS_SOURCE == str_to_predefined_type(str))
		//---------
		///---END CLEAN_LOCALIZATION_CODE
			return true;
		
		/// Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
		///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//TreeNode trCurves = trGUI.Output.Data;
		TreeNode trCurves = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
		///end OP_DLG_NEW_STRUCTURE
		if(trCurves)
		{
			int nBookTye = str_to_predefined_type(trCurves.Book.strVal);
			int nSheetType = str_to_predefined_type(trCurves.Sheet.strVal);
			if(PDS_SOURCE == nBookTye && PDS_SOURCE == nSheetType)
			{
				bInsertCurves = true;
				//return true; //---- Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
			}
		}
		//---- Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
		if(bInsertCurves)
		{
			if(OUTPUT_RESULT_CURVE_RESIDUAL_SHEET == nOutputIndex)
			{
				///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
				//TreeNode trResidualCurves = trGUI.Output.Residual;
				TreeNode trResidualCurves = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trGUI);
				///end OP_DLG_NEW_STRUCTURE
				if(trResidualCurves)
				{	
					int nBookTye = str_to_predefined_type(trResidualCurves.Book.strVal);
					int nSheetType = str_to_predefined_type(trResidualCurves.Sheet.strVal);
					///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
					//if(PDS_FIT_CURVE == nBookTye && PDS_FIT_CURVE == nSheetType)
					if(PDS_FIT_CURVE == nBookTye && PDS_FIT_CURVE == nSheetType || PDS_SOURCE == nBookTye && PDS_SOURCE == nSheetType )
					///end WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
					{
						bInsertCurves = true;
						return true;
					}
				}					
			}
			else
			{
				return true;
			}
		}
		//----
		
		return false;
	}
	return error_report("trGUI.Output.Report.Sheet missing");
}

/// Iris 10/13/06 USE_CENTRILIZE_CODE_TO_GET_RESULT_CURVE_NODE
void WksReportOperation::getGUIResultCurveNode(const TreeNode& trGUI, TreeNode& trResultCurve, int nOutputIndex)
{
	switch(nOutputIndex)
	{
	case OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET:
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//trResultCurve = trGUI.Output.Data;
		trResultCurve = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
		///end OP_DLG_NEW_STRUCTURE
		break;
	case OUTPUT_RESULT_CURVE_RESIDUAL_SHEET:
		//trResultCurve = trGUI.Output.Residual;
		trResultCurve = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trGUI);
		///end OP_DLG_NEW_STRUCTURE
		break;
	case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET:
	case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET:
		//trResultCurve = trGUI.Output.FindXY;
		trResultCurve = OP_GUI_OUTPUT_TO_FINDXY_BRANCH(trGUI);
		///end OP_DLG_NEW_STRUCTURE
		break;
	/// Hong 04/10/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	case OUTPUT_RESULT_PEAK_CHARACTER_SHEET:
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//ResultCurve = trGUI.Output.PeakCharacter;
		trResultCurve = OP_GUI_OUTPUT_TO_PEAKCHARACTER_BRANCH(trGUI);
		///end OP_DLG_NEW_STRUCTURE
		break;
	///Sophy 5/28/2008 QA80-10934-P8 FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
	case OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET:
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//trResultCurve = trGUI.Output.PartialCurves;
		trResultCurve = OP_GUI_OUTPUT_TO_PARTIALCURVE_BRANCH(trGUI);
		///end OP_DLG_NEW_STRUCTURE
		break;
		
	///end FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
	/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	case OUTPUT_RESULT_SUBTRACTED_DATA_SHEET:
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//trResultCurve = trGUI.Output.SubtractedData;
		trResultCurve = OP_GUI_OUTPUT_TO_SUBTRACTEDDATA_BRANCH(trGUI);
		///end OP_DLG_NEW_STRUCTURE
		break;
	case OUTPUT_RESULT_BASELINE_DATA_SHEET:
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//trResultCurve = trGUI.Output.BaselineData;
		trResultCurve = OP_GUI_OUTPUT_TO_BASELINEDATA_BRANCH(trGUI);
		///end OP_DLG_NEW_STRUCTURE
		break;
	///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	default:
		ASSERT(FALSE);
		return ;
	/// end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	}
}
///end USE_CENTRILIZE_CODE_TO_GET_RESULT_CURVE_NODE

///Jasmine 09/27/06 PREPARE_OUTPUT_FOR_RESIDUAL
//string Operation::GetCurveOutputSheetName(const TreeNode& trGUI, int* pnSpecialType)// = NULL)
string WksReportOperation::getCurveOutputSheetName(const TreeNode& trGUI, int nOutputIndex, int* pnSpecialType)// = NULL)
{
	string str;
	TreeNode trCurves;// = trGUI.Output.Data;
	/// Iris 10/13/06 USE_CENTRILIZE_CODE_TO_GET_RESULT_CURVE_NODE
	/*
	switch(nOutputIndex)
	{
	case OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET:		
		trCurves = trGUI.Output.Data;
		break;
	case OUTPUT_RESULT_CURVE_RESIDUAL_SHEET:
		trCurves = trGUI.Output.Residual;
		break;
	case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET:
	case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET:
		trCurves = trGUI.Output.FindXY;
		break;
	}*/
	getGUIResultCurveNode(trGUI, trCurves, nOutputIndex);
	///end USE_CENTRILIZE_CODE_TO_GET_RESULT_CURVE_NODE
	if(trCurves)
	 	str = getStrCheckSpecialType(trCurves.Sheet.strVal, pnSpecialType);
	else
		error_report("getCurveOutputSheetName failed to find valid special Output Curve tree node"); 
	return str;
}

//string Operation::GetCurveOutputBookName(const TreeNode& trGUI, int* pnSpecialType, Worksheet* pwksReport)// = NULL)
string WksReportOperation::GetCurveOutputBookName(const TreeNode& trGUI, int nOutputIndex, int* pnSpecialType, Worksheet* pwksReport)// = NULL
{
	string str;
	TreeNode trCurves;// = trGUI.Output.Data;
	/// Iris 10/13/06 USE_CENTRILIZE_CODE_TO_GET_RESULT_CURVE_NODE
	/*
	switch(nOutputIndex)
	{
	case OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET:		
		trCurves = trGUI.Output.Data;
		break;
	case OUTPUT_RESULT_CURVE_RESIDUAL_SHEET:
		trCurves = trGUI.Output.Residual;
		break;
	case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET:
	case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET:
		trCurves = trGUI.Output.FindXY;
		break;
	}
	*/
	getGUIResultCurveNode(trGUI, trCurves, nOutputIndex);
	///end USE_CENTRILIZE_CODE_TO_GET_RESULT_CURVE_NODE
	if(trCurves)
	 	str = getStrCheckSpecialType(trCurves.Book.strVal, pnSpecialType);
	else
		error_report("GetCurveOutputBookName failed to find valid trGUI.Output.Report.Book");
	
	//if( NULL != pwksReport && PDS_REPORT == *pnSpecialType)  ///Iris 11/12/04 QA70-7139 FIX_CURVE_SHEET_ALWAYS_SAME_AS_REPORT_SHEET
	if( NULL != pwksReport && pwksReport->IsValid() && PDS_REPORT == *pnSpecialType)  ///Jasmine 02/21/08 pwksReport may point to an invalid sheet
		str = pwksReport->GetPage().GetName();
	
	//--- Iris 9/30/06 can put two calibration tables into separate book
	///Iris 9/29/06 put two calibration tables FindX/FindY into the same Book even though choose Report Book is <new>
	//if(nOutputIndex == OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET || nOutputIndex == OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET)
	//{
		//if( NULL != lpcszDefaultBookName && PDS_NEW == *pnSpecialType)
			//str = lpcszDefaultBookName;
	//}
	//---
	
	return str;
}
///End PREPARE_OUTPUT_FOR_RESIDUAL
/////////////////////////////////////////////////////////////////////////////////////
//--- end REPORT_BOOK_INDICATE_SOURCE_BOOK 


//----------- CPY 11/25/04 ADDING_AUTOUPDATE_REASON_TO_NOTE_IN_REPORT
static string _get_auto_update_type(int nExecMode)
{
	string str;
	switch(nExecMode)
	{
	case OEXEM_ON_CREATE_OPEN_GUI:
	case OEXEM_ON_CREATE:
		str = _L("New Analysis Report");
		break;
	case OEXEM_ON_AUTOUPDATE_MANUAL:
	case OEXEM_ON_AUTOUPDATE_TASK:
		str = _L("Report generated from Data Changed");
		break;
	case OEXEM_ON_CHANGEPARAM:
		str = _L("Report generated from Parameters Changed");
		break;
	default:
		str = _L("Unknown");
	}
	return str;
}

static string _get_special_input_handling_type(TreeNode& trOp, bool& bSupportSpecial)
{
	TreeNode trInput = trOp.GUI.InputData;
	int nRet = octree_composite_range_get_entire_worksheet_support(&trInput);	
	bSupportSpecial = (0 != nRet); // ==0 means not supported
	
	string str;
	switch(nRet)
	{		
	case 1:
		str = _L("All Columns");
		break;
		
	default:
		break;
	}
	return str;
}

//virtual 
void WksReportOperation::UpdateReportingTables(TreeNode &trOperation, int nTotalNumData, int nExecMode)
{
	/////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////
	// common report regions
	/////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////
	TreeNode		trTable = GetTreeNode_Notes(trOperation);
	string strReportTitle = _L("No title");
	if(trTable)
	{
		trTable.SetAttribute(TREE_Table, GetTableStringSupport(false));
		///Arvin 11/05/07 LOCALIZE_STRINGS
		//trTable.SetAttribute(STR_LABEL_ATTRIB, trTable.tagName);
		trTable.SetAttribute(STR_LABEL_ATTRIB, _L("Notes"));
		///END LOCALIZE_STRINGS
		
		string	strExecutorName;
		string	strExecutorCompanyName;
		double	dExecuteTime;
		DWORD	dwDuration;
		GetExecutionInfo(dExecuteTime, strExecutorName, strExecutorCompanyName, dwDuration);
		
		//Description
		///Arvin 10/27/06 FITTING_FUNCTION_MODEL_IN_REPORT
		//trTable.Description.strVal = GetResultDescription(trOperation);
		trTable.Description.strVal = GetResultDescription(trOperation, false);
		///end FITTING_FUNCTION_MODEL_IN_REPORT
		trTable.Description.SetAttribute(STR_LABEL_ATTRIB, WKSH_OPERATION_INFO_OPERATION_DESCRIPTION);
		// User name:
		trTable.UserName.strVal = strExecutorName;
		trTable.UserName.SetAttribute(STR_LABEL_ATTRIB, WKSH_OPERATION_INFO_USER_NAME);
		// Time:
		trTable.Time.strVal = get_date_str(dExecuteTime);
		trTable.Time.SetAttribute(STR_LABEL_ATTRIB, WKSH_OPERATION_INFO_EXECUTION_TIME);
		
		///Iris 6/06/05 CENTRALIZE_GUI_STRUCTURE
		//bool bShowNotes = trOperation.GUI.Output.Report.Create.Notes.nVal;
		/// Iris 5/29/2008 QA80-11620 v8.0873 FIX_NO_RECALCULATE_ON_OUTPUT_MATRIX
		//bool bShowNotes = op_get_optional_tables(trOperation.GUI).Notes.nVal;
		bool bShowNotes = op_get_optional_tables(trOperation.GUI)? op_get_optional_tables(trOperation.GUI).Notes.nVal : false;
		///end FIX_NO_RECALCULATE_ON_OUTPUT_MATRIX
		tree_check_set_hidden(trTable, bShowNotes? false:true);
		
		strReportTitle = GetReportTitle(trOperation);// title needs to get info from notes, so must call this later
		
		UpdateModelNote(trTable, trOperation);		///Jasmine 04/16/08 MOVE_UPDATE_MODEL_CODES_IN_FITNL_CLASS
		
		UpdateNumParamsDatasetsNote(trTable, nTotalNumData, trOperation); /// Iris 8/14/2008 QA80-12017-S2 ADD_PARAM_NUM_DATA_NUM_TO_NOTE_TABLE
		
		///------ Folger 10/28/09 QA81-14552 WRONG_REPORT_STATUS_WHEN_CHANGE_PARAM_IN_PA
		//trTable.AutoUpdateMode.strVal = _get_auto_update_type(nExecMode);		//----------- CPY 11/25/04 ADDING_AUTOUPDATE_REASON_TO_NOTE_IN_REPORT
		trTable.AutoUpdateMode.strVal = GetAutoUpdateType(nExecMode);
		///------ End WRONG_REPORT_STATUS_WHEN_CHANGE_PARAM_IN_PA
		///Arvin 10/27/06 FITTING_FUNCTION_MODEL_IN_REPORT
		/// Iris 03/28/2007 CHECK_CORRECT_LOCATION
		//trTable.AutoUpdateMode.SetAttribute(STR_LABEL_ATTRIB, "Report Status");
		trTable.AutoUpdateMode.SetAttribute(STR_LABEL_ATTRIB, _L("Report Status"));
		///end CHECK_CORRECT_LOCATION
		
		/// Iris 3/12/2009 QA80-13268 NOTES_TABLE_ADD_SPECIAL_INPUT_HANDLING		
		trTable.SpecialInputHandling.SetAttribute(STR_LABEL_ATTRIB, _L("Special Input Handling"));
		bool bShow;
		trTable.SpecialInputHandling.strVal = _get_special_input_handling_type(trOperation, bShow);
		trTable.SpecialInputHandling.Show = bShow;
		///end NOTES_TABLE_ADD_SPECIAL_INPUT_HANDLING
	}
	else
		error_report("report Notes branch missing");
	
	///Iris 6/06/05 CENTRALIZE_GUI_STRUCTURE	
	trTable = trOperation.Calculation.Input;
	if(trTable)
	{
		trTable.SetAttribute(TREE_Table, GetTableStringSupport(false));
		//------ Folger 11/26/07 SHOW_LABEL_FIT_DATA_WHEN_COME_FROM_PFW
		//trTable.SetAttribute(STR_LABEL_ATTRIB, STR_INPUT_DATA);
		string strTmp;
		if (!trTable.GetAttribute(STR_LABEL_ATTRIB, strTmp)
			|| !compare_string_localization(strTmp, "Fit Data") )		//hard code for PA, need improve later
			trTable.SetAttribute(STR_LABEL_ATTRIB, STR_INPUT_DATA);
		//------
		
		///Iris 6/06/05 CENTRALIZE_GUI_STRUCTURE
		//bool bShowInput = trOperation.GUI.Output.Report.Create.InputData.nVal;
		/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//bool bShowInput = op_get_optional_tables(trOperation.GUI).InputData.nVal;
		TreeNode trInputData = OP_GUI_OUTPUT_TABLES_BRANCH(trOperation.GUI).InputData;
		bool bShowInput = trInputData ? trInputData.nVal : false;
		tree_check_set_hidden(trTable, bShowInput? false:true);
		
		///----- CPY RVD 6/13/2006 QA70-8615 ADD_HEADER_TO_INPUT_TABLE
		// DataID = 1 for now, might change later
//		TreeNode trHeader = tree_check_get_node(trTable, "Header", 1, TREE_Header, "1");
//		trHeader.strVal = "Double-click to edit this line";
		/// end ADD_HEADER_TO_INPUT_TABLE
	
	}
	
	/// ML 10/20/2004 QA70-7075 MASKED_DATA_REPORTING
	TreeNode	trMaskedData = trOperation.Calculation.MaskedData; 
	if(trMaskedData)
	{
		// Transposition cannot be done here because only UpdateMaskedDataTables() knows whether
		// to transpose or not.
		//trMaskedData.SetAttribute(TREE_Table, GetTableStringSupport(false));
		trMaskedData.SetAttribute(STR_LABEL_ATTRIB, STR_MASKED_DATA_LONG);
		///Iris 6/06/05 CENTRALIZE_GUI_STRUCTURE
		//bool	bShowMaskedData = trOperation.GUI.Output.Report.Create.MaskedData.nVal;
		
		//CPY 7/18/06 MORE_CLEANUP_ON_THOMAS_CODE /// Thomas 04/25/06 CHECK_MASKEDDATA_AND_MISSINGDATA_NODE_VALID
		//bool	bShowMaskedData = op_get_optional_tables(trOperation.GUI).MaskedData.nVal;
		TreeNode tnCreate = op_get_optional_tables(trOperation.GUI);
		bool bShowMaskedData = false;
		if(tnCreate) 	 
		{
			if(tnCreate.MaskedData && /*tnCreate.MissingData.nVal*/ tnCreate.MaskedData.nVal) ///Arvin MASKED_DATA_TABLE_UNSHOW_WHEN_UNCHECK_MISSING_DATA_TABLE
				bShowMaskedData = true;
		}
		/// End MORE_CLEANUP_ON_THOMAS_CODE CHECK_MASKEDDATA_AND_MISSINGDATA_NODE_VALID 
		
		tree_check_set_hidden(trMaskedData, bShowMaskedData? false:true);
		/// Hong 12/11/09 QA80-14138-P2 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
		trMaskedData.SetAttribute(TREE_Table, GetTableStringMaskedOrMissingData(false));
		/// end FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
	}
	/// end MASKED_DATA_REPORTING
	/// ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS
	TreeNode	trMissingData = trOperation.Calculation.MissingData; 
	if(trMissingData)
	{
		trMissingData.SetAttribute(STR_LABEL_ATTRIB, STR_MISSING_DATA_LONG);
		///Iris 6/06/05 CENTRALIZE_GUI_STRUCTURE
		//bool	bShowMissingData = trOperation.GUI.Output.Report.Create.MissingData.nVal;
		
		//CPY 7/18/06 MORE_CLEANUP_ON_THOMAS_CODE/// Thomas 04/25/06 CHECK_MASKEDDATA_AND_MISSINGDATA_NODE_VALID
		//bool	bShowMissingData = op_get_optional_tables(trOperation.GUI).MissingData.nVal;
		TreeNode tnCreate = op_get_optional_tables(trOperation.GUI);
		bool bShowMissingData = false;
		if(tnCreate) 
		{
			if(tnCreate.MissingData && tnCreate.MissingData.nVal)
				bShowMissingData = true;	
		}
		/// End MORE_CLEANUP_ON_THOMAS_CODE CHECK_MASKEDDATA_AND_MISSINGDATA_NODE_VALID
		
		tree_check_set_hidden(trMissingData, bShowMissingData? false:true);
		/// Hong 12/11/09 QA80-14138-P2 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
		trMissingData.SetAttribute(TREE_Table, GetTableStringMaskedOrMissingData(false));
		/// end FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
	}
	/// end GETTING_MISSING_VALUES_AND_ROWS

	/// Iris 01/08/2007 v8.0538 NEED_GET_ANALYSIS_NAME_FOR_REPORT_TREE_BROWSER
	//trOperation.Calculation.SetAttribute(STR_ANALYSIS_ATTRIB, GetResultDescription(trOperation, false));
	trOperation.Calculation.SetAttribute(STR_ANALYSIS_ATTRIB, GetClassName());
	/// end NEED_GET_ANALYSIS_NAME_FOR_REPORT_TREE_BROWSER
	
	//---- CPY 6/18/04 MULTIPLE_REPORTS_IN_SHEET
	//trOperation.Calculation.Title.strVal = strReportTitle;
	//trOperation.Calculation.Title.SetAttribute(TREE_Header, GetTableStringSupport(false, false, false));
	//----
	trOperation.Calculation.SetAttribute(TREE_Table, GetTableStringMain(false));
	//----
	trOperation.Calculation.SetAttribute(STR_LABEL_ATTRIB, strReportTitle);
	//---- CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
	#ifdef SEPARATE_RESULT_CURVES_FROM_CALCULATION_BRANCH
	trOperation.ResultCurves.SetAttribute(TREE_Table, GetTableStringMain(false));
	trOperation.ResultCurves.SetAttribute(STR_LABEL_ATTRIB, strReportTitle);		
	#endif
	//----
}
//-----------

///end CENTRALIZE_GUI_STRUCTURE
//----- CPY 11/3/04	QA70-7122 ADD_BOX_CHART_TO_DESC_STATS
///Iris 6/04/05 move to analysis_utils
/*
static string _get_graph_tag_name(int nGraph = -1)
{
	string str = "Graph";
	if(nGraph < 0)
		return str; ////-------- CPY 12/31/04 PICTURE_IN_REPORT_IN_BASE_CLASS, use -1 to just get the tagName prefix
	
	//if(nGraph > 0)	///Iris 11/12/04 UPDATE_GRAPH_TAG_NAME
	str += ++nGraph;
	return str;
}
*/
/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
//static string _get_custom_table_tag_name(int nCustom)
//{
//	string str = "Custom";
//	str += ++nCustom;
//	return str;
//}
static string _get_custom_table_tag_name(int nCustom, int nAuxIndex = -1)
{
	
	string	str;
	if (nAuxIndex < 0)
	{
		str = "Custom";
		str += nCustom + 1;
	}
	else
		str.Format("Custom%u_%u", nCustom + 1, nAuxIndex + 1);

	return str;
}
/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
//virtual 
string WksReportOperation::GetGraphName(int nGraphIndex, bool bLongName)// = 0);// { string str = GetResultSheetName(); if(nGraphIndex) str += nGraphIndex; return str;}
{
	/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	//string str = GetResultSheetName(); 	
	Tree trOp;
	GetTree(trOp);
	string str = GetResultSheetName(trOp.GUI); 	
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	
	if(nGraphIndex) 
		str += nGraphIndex;
	int nPlotType = ReportGetPlotTypeFromGraphIndex(nGraphIndex);
	switch(nPlotType)
	{
	case IDM_PLOT_BOX:
		///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS
		//str = "Box";
		str = _LE("Box");
		///end CLEAN_UP_LOCALIZATION_THINGS
		break;
	case IDM_PLOT_HISTOGRAM_TYPE:
		///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS
		//str = "Histogram";
		str = _LE("Histogram");
		///end CLEAN_UP_LOCALIZATION_THINGS
		break;
	}
	return str;
}

//virtual
string WksReportOperation::GetGraphTemplate(int nGraphIndex)
{
	string str;
	switch(ReportGetPlotTypeFromGraphIndex(nGraphIndex))
	{
	case IDM_PLOT_BOX:
		//--- Iris 8/22/06 keep the template of report box same as box plot
		//str = "ReportBox";
		/// Iris 9/18/2009 REMOVE_LEGEND_FOR_REPORT_BOX_PLOT
		//str = "Box";
		str = "ReportBox";
		///end REMOVE_LEGEND_FOR_REPORT_BOX_PLOT
		//---
		break;
	case IDM_PLOT_HISTOGRAM_TYPE:
		str = "ReportHistogram";
		break;
	}
	if(str.IsEmpty())
		str = "Origin";
	
	return str;
	
}

//-------- CPY 12/31/04 PICTURE_IN_REPORT_IN_BASE_CLASS
//virtual 
///Iris 6/04/05 MOVE_FITTED_CURVES_TO_ROOT_LEVEL
/*
int WksReportOperation::GetNumGraphs(TreeNode& trOp)
{
	TreeNode trCreate = trOp.GUI.Output.Report.Create;
	if(trCreate)
	{
		string strName = op_get_graph_tag_name();
		TreeNodeCollection tnc(trCreate, strName);
		return tnc.Count();
	}
	return 0;	
}
*/
int WksReportOperation::GetNumGraphs()
{
	return ConstructGraphNumber();	
}
///end MOVE_FITTED_CURVES_TO_ROOT_LEVEL
//-------- end PICTURE_IN_REPORT_IN_BASE_CLASS

#define	STR_DATA_INDEX_RANGE_PICUTRE_ATTRIBUTE	"DataIndexRange"
int WksReportOperation::cleanUpTempWksGraphs(TreeNode& trOp)
{
	if(!trOp.Temp) ///Iris 11/10/04, if not graph trOp.Temp.GetNode will cause crash then directly return
		return 0; 
		
	if(trOp.Temp.wks)
	{
		Worksheet wks(trOp.Temp.wks.strVal);
		if(wks)
			wks.GetPage().Destroy();
	}
	double vv = 0;
	LT_get_var("@B",&vv);
	int nGraphsDeleted = 0;
	if(vv <= 0)
	{
		for(int nGraph = 0; nGraph<5; nGraph++)
		{
			TreeNode trTempGraph = trOp.Temp.GetNode(op_get_graph_tag_name(nGraph));
			if(trTempGraph)
			{
				/// Iris 07/04/05 UPDATE_DESTROY_GRAPH_NODE_FOR_MR
				//GraphPage gp(trTempGraph.Graph.strVal);
				TreeNodeCollection trColl(trTempGraph, CALCULATION_GRAPH_NODE_PREIX);
				foreach(TreeNode trN in trColl)
				{
					GraphPage gp(trN.strVal);
				////end UPDATE_DESTROY_GRAPH_NODE_FOR_MR
					if(gp)
					{
						gp.Destroy();
						nGraphsDeleted++;
					}
				}
			}
			// else keep the graphs around, this a temp solution, we need better system level control later
		}
	}
	return nGraphsDeleted;
}

/*
// YuI 12/03/04 v7.5170 QA70-7226 MULTIPLE_PLOTS_OF_SAME_SERIES_IN_SAME_FRAME
//	ReportCreateGraphHelper::ReportCreateGraphHelper(int nCreateType, TreeNode& trOp, int index, int nGraphIndex, LPCSTR lpcszDataLabel, const vector<string> *pvstrFactors)
ReportCreateGraphHelper::ReportCreateGraphHelper(int nCreateType, TreeNode& trOp, int nDataPlotIndex, int nGraphIndex, LPCSTR lpcszDataLabel, const vector<string> *pvstrFactors, int nPictureIndex)
/// end MULTIPLE_PLOTS_OF_SAME_SERIES_IN_SAME_FRAME
{
	/// YuI 12/03/04 v7.5170 QA70-7226 MULTIPLE_PLOTS_OF_SAME_SERIES_IN_SAME_FRAME
	if( nPictureIndex < 0 )
		nPictureIndex = nDataPlotIndex;
	/// end MULTIPLE_PLOTS_OF_SAME_SERIES_IN_SAME_FRAME

	m_strGraphNodeName = op_get_graph_tag_name(nGraphIndex);
	m_bIsCreateGraph = trOp.GUI.Output.Report.Create.GetNode(m_strGraphNodeName).nVal;
	m_trOp = trOp;
	
	/// YuI 12/03/04 v7.5170 QA70-7226 MULTIPLE_PLOTS_OF_SAME_SERIES_IN_SAME_FRAME
	//	m_strPictNodeName.Format("%s%d", CALCULATION_GRAPH_NODE_PREIX, index + 1);		
	m_strPictNodeName.Format("%s%d", CALCULATION_GRAPH_NODE_PREIX, nPictureIndex + 1);
	/// end MULTIPLE_PLOTS_OF_SAME_SERIES_IN_SAME_FRAME
	
	/// Iris 9/13/04 OUTPUT_ADD_2ND_GRAPH
	//TreeNode trGraphs = tree_check_get_node(trOp.Calculation, "Graphs", IDST_RESULT_GRAPHS);
	TreeNode trGraph = tree_check_get_node(trOp.Calculation, m_strGraphNodeName, IDST_RESULT_GRAPHS + nGraphIndex);
	
	if(CREATE_GRAPH_PREPARE_TREE == nCreateType)
	{
		tree_check_set_hidden(trGraph, m_bIsCreateGraph?false:true);
		trGraph.SetAttribute(TREE_Table, GetTableStringGraphs());
	}
	
	TreeNode trTable;

	
	/// YuI 12/03/04 v7.5170 QA70-7226 MULTIPLE_PLOTS_OF_SAME_SERIES_IN_SAME_FRAME
	//	m_trImage = tree_check_get_node(trGraph.Image, m_strPictNodeName, index + 1, STR_LABEL_ATTRIB, lpcszDataLabel);
	m_trImage = tree_check_get_node(trGraph.Image, m_strPictNodeName, nPictureIndex + 1, STR_LABEL_ATTRIB, lpcszDataLabel);
	/// end MULTIPLE_PLOTS_OF_SAME_SERIES_IN_SAME_FRAME
	
	if( CREATE_GRAPH_PREPARE_TREE == nCreateType )
	{
		int nMinDataIndex = -1;
		int nMaxDataIndex = -1;
		string strDataIndexRange;
		m_trImage.GetAttribute(STR_DATA_INDEX_RANGE_PICUTRE_ATTRIBUTE, strDataIndexRange);
		if( !strDataIndexRange.IsEmpty() )
		{
			string strTemp = strDataIndexRange.GetToken(0);
			nMinDataIndex = atoi(strTemp);
			strTemp = strDataIndexRange.GetToken(1);
			nMaxDataIndex = atoi(strTemp);
		}
		
		if( nMinDataIndex < 0 || nMinDataIndex >= nDataPlotIndex )
			nMinDataIndex = nDataPlotIndex;
		if( nMaxDataIndex < 0 || nMaxDataIndex <= nDataPlotIndex )
			nMaxDataIndex = nDataPlotIndex;
		
		strDataIndexRange  = nMinDataIndex;
		strDataIndexRange += " ";
		strDataIndexRange += nMaxDataIndex;
		m_trImage.SetAttribute(STR_DATA_INDEX_RANGE_PICUTRE_ATTRIBUTE, strDataIndexRange);
	}
	
	if ( pvstrFactors )
	{
		vector<string>	&vstr = *pvstrFactors;
		tree_add_more_labels(m_trImage, vstr);
	}

	//m_wksTemp.Attach(trOp.Temp.wks.strVal);
	if(CREATE_GRAPH_CREATE_FOR_REPORT == nCreateType)
	{
		trOp.Temp.ID = 1;
		TreeNode trTempGraph = tree_check_get_node(trOp.Temp, m_strGraphNodeName);
		trTempGraph.Graph.ID = 1;
		GraphPage gp(trTempGraph.Graph.strVal);
		m_gpTemp = gp;
	}			
		
	m_nCreateType = nCreateType;
	
}
ReportCreateGraphHelper::~ReportCreateGraphHelper()
{
	if(CREATE_GRAPH_CREATE_FOR_REPORT == m_nCreateType)
	{
		TreeNode trTempGraph = tree_check_get_node(m_trOp.Temp, m_strGraphNodeName);
		if(m_gpTemp.IsValid())
			trTempGraph.Graph.strVal = m_gpTemp.GetName();
		else
			trTempGraph.Graph.strVal = "";
	}
	/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
	else if( m_gpTemp.IsValid() )
	{
		m_gpTemp.SetShow();
	}
	/// end PICTURE_IN_REPORT_IMPROVEMENT
}
bool ReportCreateGraphHelper::AddGraphToTreeNode()
{
	if(!m_trImage)
		return error_report("no image node in Operation tree");
	
	if(m_bIsCreateGraph && CREATE_GRAPH_CREATE_FOR_REPORT == m_nCreateType)
	{
		PictureHolder pictHolder;
		if(!page_get_picture(m_gpTemp, pictHolder, "EMF", 72, false))
			return error_report("failed to create EMF from graph");
		
		m_trImage.pict = pictHolder;
	}
	else
		m_trImage.strVal = "";// empty graph
		
	m_trImage.SetAttribute(TREE_Key, m_strPictNodeName);
	return true;

}
GraphPage ReportCreateGraphHelper::GetTempGraph(LPCSTR lpcszGraphName, LPCSTR lpcszTemplate)// = NULL)
{
	if(!m_gpTemp)
	{
		/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
		/*
		if(CREATE_GRAPH_CREATE_FOR_REPORT == m_nCreateType)
			m_gpTemp.Create(lpcszTemplate, CREATE_HIDDEN);
		else
			m_gpTemp.Create(lpcszTemplate);
		*/
		/*	
		// always create and prepare hidden and then show in destructor
		m_gpTemp.Create(lpcszTemplate, CREATE_HIDDEN);
		/// end PICTURE_IN_REPORT_IMPROVEMENT

		m_gpTemp.Rename(lpcszGraphName, false, true);
	}
	else // empty all graph layers if existing graph
	{
		GraphLayer gl = m_gpTemp.Layers(0);
		
		while(gl.DataPlots.Count())
			gl.RemovePlot(0);
	}

	return m_gpTemp;
}
*/


///Iris 01/20/05 CLEANUP_CONSTRUCT_ADD_GRAPH
/*
void Operation::ConstructAddGraph(TreeNode& trOp, int nGraphIndex)// = 0)
{
	//trOut.Graphs.ID = IDST_RESULT_GRAPHS; /// Iris 9/13/04 OUTPUT_ADD_2ND_GRAPH
	//TreeNode trGraph = trOut.AddNode(op_get_graph_tag_name(nIndex), IDST_RESULT_GRAPHS + nIndex);
	TreeNode trGraph = tree_check_get_node(trOp.Calculation, op_get_graph_tag_name(nGraphIndex), IDST_RESULT_GRAPHS + nGraphIndex);

	string strName;
	/// Iris 9/13/04 OUTPUT_ADD_2ND_GRAPH
	//if(GetCustomGraphTypeName(strName)) 
		//trOut.Graphs.SetAttribute(STR_LABEL_ATTRIB, strName);
	if(GetCustomGraphTypeName(strName, nGraphIndex))
		trGraph.SetAttribute(STR_LABEL_ATTRIB, strName);
	/// End 

	//trOut.Graphs.Heading.ID = IDE_HEADING1;
	//trOut.Graphs.Image.ID = IDE_IMAGE;  /// Iris 9/13/04 OUTPUT_ADD_2ND_GRAPH
	//trGraph.Image.ID = IDE_IMAGE + nIndex;
	trGraph.Image.ID = IDE_IMAGE;///----- CPY 11/3/04	QA70-7122 ADD_BOX_CHART_TO_DESC_STATS
}
*/
void WksReportOperation::constructAddOutputGraph(TreeNode& trOp, int nGraphIndex)// = 0
{
	TreeNode trGraph = tree_check_get_node(trOp.Calculation, op_get_graph_tag_name(nGraphIndex), IDST_RESULT_GRAPHS + nGraphIndex);

	/// Iris 03/12/2007 v8.0579 NOT_CREATE_IMAGE_SUB_NODES_IF_NOT_OUTPUT_THIS_GRAPH
	//moved from WksReportOperation::CheckCreateImagSubNodes
	bool 	bCreateGraph = IsCreateReportGraph(trOp, nGraphIndex);
	tree_check_set_hidden(trGraph, !bCreateGraph);	
	trGraph.SetAttribute(TREE_Table, GetTableStringGraphs());
	///end NOT_CREATE_IMAGE_SUB_NODES_IF_NOT_OUTPUT_THIS_GRAPH
	
	string strName;
	if(GetCustomGraphTypeName(strName, nGraphIndex))
		trGraph.SetAttribute(STR_LABEL_ATTRIB, strName);
	//trGraph.Image.ID = IDE_IMAGE;	
}
///end CLEANUP_CONSTRUCT_ADD_GRAPH


//--- CPY 11/19/04 QA70-7121 CUSTOM_REPORT_TABLES
/// ML 1/26/2005 CUSTOM_TABLE_TO_GRAPH
/// ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
//TreeNode WksReportOperation::addCustomTableToReport(TreeNode& trOp, int nCustomIndex)
/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
//TreeNode WksReportOperation::addCustomTableToReport(TreeNode& trOp, int nCustomIndex, bool *pbEnabled)
/// Joesph/Iris 9/26/06 QA70-7120 MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
//TreeNode WksReportOperation::addCustomTableToReport(TreeNode& trOp, int nCustomIndex, bool *pbEnabled, int nAuxIndex, LPCSTR lpcszLabel, TreeNode &trParent)
bool WksReportOperation::AddCustomTableToReport(TreeNode& trOp, TreeNode &trCustom, int nCustomIndex)
///end MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
/// end CUSTOM_TABLES_FOR_FIND_XY
{
	/// Joesph/Iris 9/26/06 QA70-7120 MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
	/*
	/// ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
	//TreeNode	trCustom = getOrCreateCustomTable(trOp, nCustomIndex);
	/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
	//TreeNode	trCustom = getOrCreateCustomTable(trOp, nCustomIndex, pbEnabled, 0 == nCustomIndex);
	TreeNode	trCustom = getOrCreateCustomTable(trOp, nCustomIndex, pbEnabled, 0 == nCustomIndex, nAuxIndex, lpcszLabel, trParent);
	/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
	/// end CUSTOM_TABLES_FOR_FIND_XY
	*/
	if ( !trCustom.IsValid() )
		return false;	
	
	string strCustomNode = _get_custom_table_tag_name(nCustomIndex);
	///Iris 6/06/05 CENTRALIZE_GUI_STRUCTURE
	//TreeNode trCustomSettings = trOp.GUI.Output.Report.Create.GetNode(strCustomNode);
	///Joe 8/28/06  MOVE_GET_X_FROM_Y_OR_GET_Y_FROM_X_TO_CALIBRATION
	//TreeNode trCustomSettings = op_get_optional_tables(trOp.GUI).GetNode(strCustomNode);
	/// Iris 11/03/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trCustomSettings = op_get_calibration_table(trOp.GUI).GetNode(strCustomNode);
	TreeNode trCalibration = op_get_calibration_table(trOp.GUI);
	if( !trCalibration )
	{
		ASSERT(false);
		return false;
	}
	TreeNode trCustomSettings = trCalibration.GetNode(strCustomNode);
	///end OP_DLG_NEW_STRUCTURE
	///End MOVE_GET_X_FROM_Y_OR_GET_Y_FROM_X_TO_CALIBRATION
	
	///Arvin 01/09/06 FIND_Z_FROM_XY
	//When current operation is "Find Z from X Y", trCalibration has not sub-branch trCustomSettings. 
	if(HasZ(trOp))
		trCustomSettings = op_get_calibration_table(trOp.GUI);
	///end FIND_Z_FROM_XY
	
	if( trCustomSettings.IsValid() )
	{
		/// Iris 03/09/2007 v8.0578 CHANGE_NUMOFCOLS_TO_NUMOFOUTCOLS
		//int nCols = trCustomSettings.Cols.nVal;
		int nCols = trCustomSettings.Cols.nVal + 1; //the number of trCustomSettings.Cols just means number of output columns now, add 1, means add input
		///Arvin 04/04/07 v8.0596 WRONG_NUMBER_COLS_FIND_Z_FROM_XY_TABLE
		if(HasZ(trOp))
			nCols = trCustomSettings.Cols.nVal + 2; //X + Y + number of Z
		///end WRONG_NUMBER_COLS_FIND_Z_FROM_XY_TABLE
		///end CHANGE_NUMOFCOLS_TO_NUMOFOUTCOLS
		
		///Joseph 09/27/06 FINDXY_TO_SEPERATE_SHEET
		//int nRows = trCustomSettings.Rows.nVal;
		///End FINDXY_TO_SEPERATE_SHEET
		int nColID;
		TreeNode trNode, trCol;
		
		///Joseph 09/27/06 FINDXY_TO_SEPERATE_SHEET
		//temp add Const num Rows 
		for(int ii = 0; ii < CONST_ROW_SIZE ; ii++)
		//for(int ii = 0; ii < nRows; ii++)
		///End FINDXY_TO_SEPERATE_SHEET
		{
			nColID = make_one_set_ID(IDE_CUSTOM_NODE_2, ii);
			trCol = check_add_enumerated_node(trCustom, "R", ii+1, nColID);
			for(int jj = 0; jj < nCols; jj++)
			{
				trNode = check_add_enumerated_node(trCol, "C", jj + 1, IDE_CUSTOM_NODE_1 + jj);
				trNode.strVal = "";
			}
		}
	}
	
	/// Joesph/Iris 9/26/06 QA70-7120 MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
	//return trCustom;
	return true;
	///end MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
}



static		bool	load_all_analyses_default_theme(Tree &tree)
{
	//--- CPY 10/17/05 ANALYSIS_THEME_USE_CENTRLIZED_FUNC
	/*	
	string	strPathName = GetAppPath(true);
	
	strPathName += "Themes\\AnalysisAndReportTable\\DefaultAnalysis.oth";
	
	return tree.Load(strPathName);
	*/
	return theme_load(tree, "DefaultAnalysis.oth", "AnalysisAndReportTable");
	//---
}

/// ML 10/13/2005 QA70-8157 SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS

BOOL	WksReportOperation::setThemeToResultsCurveSheet(Worksheet &wksFitCurves, DWORD dwResultCurvesReportID)
{
	Grid	grid;
	if ( !grid.Attach(wksFitCurves) )
			return error_report("Could not attach grid.");
	
	Tree	trTheme;
	
	make_result_curves_sheet_theme(trTheme, dwResultCurvesReportID);
	
	//trTheme.Root.ID = 1;
	int		nn = grid.UpdateThemeIDs(trTheme.Root);
	if ( nn != 0)
	{
		ASSERT(FALSE);		// bad tree
	}

	///// temp
	//string	strPathName = GetAppPath(true);
	//strPathName += "FlatTheme.xml";
	//if ( !trTheme.Save(strPathName) )
		//ASSERT(FALSE);
	///// end temp
	
	//----- CPY QA70-8615-5 7/12/06 REMOVE_COMMENTS_COL_FROM_REPORT
	//return grid.ApplyFormat(trTheme, TRUE, TRUE);
	grid.ApplyFormat(trTheme, TRUE, TRUE);
	/// ML 11/27/2006 ADDITIONAL_LABEL_ROWS_IN_CURVE_SHEETS
	//return wks_set_show_labels(wksFitCurves, RCLT_COMMENT, RCLT_LONG_NAME);
	return TRUE;			// the tree should decide which labels are shown
	/// end ADDITIONAL_LABEL_ROWS_IN_CURVE_SHEETS
	//-----

}
/// end SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS


/// ML 5/15/2006 SPECIAL_NLFITS_CUSTOM_TABLE
// virtual
string	WksReportOperation::getClassNameForCustomTableTheme()
{
	return GetClassName();
}
/// end SPECIAL_NLFITS_CUSTOM_TABLE


/// ML 4/28/2006 FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
#define		STR_CUSTOM_THEME_MAKER_EXT			".INI"
#define		STR_CUSTOM_THEME_MAKER_SUBFOLDER	"CUSTOMTABLE"
/// end FRIENDLY_CUSTOM_TABLE_THEME_GENERATION

/// ML 8/4/2006 REMOVING_CUSTOM_TABLE
/*
BOOL	WksReportOperation::setThemeToCustomTable(TreeNode &trCustom, DataRange& rReportSheet, TreeNode& trOp, int nCustomIndex)
{
	string			strThemeName;
	//if ( trCustom.IsValid() && getCustomTableThemeName(strThemeName, trOp, nCustomIndex) )
	if ( trCustom.IsValid() )
	{
		Grid		grid;
		if ( !grid.Attach(rReportSheet, trCustom.ID) )
			return error_report("Could not find table for graph.");
		
		/// ML 8/17/2005
		Tree		trAllAnalysesDef;
		if ( load_all_analyses_default_theme(trAllAnalysesDef) )
		{
			grid.ApplyFormat(trAllAnalysesDef, TRUE, TRUE);
			//return TRUE;
		}
		/// end ML 8/17/2005
		
		/// ML 6/27/2005 STYLE_LINKS_WITH_OFFSETS
		//string		strThemePathName = okutil_theme_get_theme_file_name(strThemeName);
		TreeNode	trCustTblTheme = get_custom_table_themes(trOp.GUI);
		string		strTheme = trCustTblTheme.strVal; 
		/// ML 4/28/2006 FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
		Tree		treeTh;
		int			nType = okutil_cvt_str_to_predefined_type(strTheme);
		if ( PDS_FACTORY_DEFAULT != nType )
		{
			if ( strTheme.IsEmpty() )
				/// ML 5/15/2006 SPECIAL_NLFITS_CUSTOM_TABLE
				//strTheme = GetClassName() + STR_CUSTOM_THEME_MAKER_EXT;
				strTheme = getClassNameForCustomTableTheme() + STR_CUSTOM_THEME_MAKER_EXT;
				/// end SPECIAL_NLFITS_CUSTOM_TABLE
			//string		strINIThemePathName = GetAppPath(false) + strTheme;
			StringArray	saPathNames;
			int			nCount = okutil_find_files(&saPathNames, strTheme, STR_CUSTOM_THEME_MAKER_SUBFOLDER, true);
			if ( saPathNames.GetSize() < 1 )
				return FALSE;
			string		strINIThemePathName = saPathNames[0];
			TreeNode	trCalc = trOp.Calculation;
			if ( MakeCustomTableTheme(&treeTh, strINIThemePathName, &trCalc) )
			{
				int			nn = grid.UpdateThemeIDs(treeTh.Root, "Error", "Unknown tag");
				if ( 0 < nn )
				{
					ASSERT(FALSE);		// bad tree
				}
				
				/// ML Just for debugging:
				string		strSave = strINIThemePathName + ".xml";
				//ASSERT( treeTh.Save(strSave) );
				ASSERT( treeTh.Save(strSave) );
			}
			else
				return FALSE;
		}
		else
		/// end FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
		{
			Tree		tr;
			//treeTh = tr;		// to resore iot because treeTh.Load() screws up the tree when it fails. 
			//if ( !GetCustomTableDefaultTheme(treeTh) )
			if ( !GetCustomTableDefaultTheme(tr) )
				return FALSE;

			//treeTh.Root.ID = 1;
			tr.Root.ID = 1;
			//int			nn = grid.UpdateThemeIDs(treeTh.Root, "Error", "Unknown tag");
			int			nn = grid.UpdateThemeIDs(tr.Root, "Error", "Unknown tag");
			if ( 0 < nn )
			{
				ASSERT(FALSE);		// bad tree
			}
			
			/// ML Just for debugging:
			string		strSave = okutil_theme_get_path() + "__DefaultAppliedTheme.oth";
			//ASSERT( treeTh.Save(strSave) );
			ASSERT( tr.Save(strSave) );
			///
			treeTh = tr;
		}

		if ( grid.ApplyFormat(treeTh, TRUE, TRUE) )
		{
			grid.AutoSize();
			return TRUE;
		}
	}
	
	return FALSE;
}
*/
/// end REMOVING_CUSTOM_TABLE

/// end CUSTOM_TABLE_TO_GRAPH

/// ML 4/28/2006 FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
//TreeNode WksReportOperation::getOrCreateCustomTable(TreeNode& trOp, int nCustomIndex)
/// ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
//TreeNode WksReportOperation::getOrCreateCustomTable(TreeNode& trOp, int nCustomIndex, bool *pbEnabled)
/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
//TreeNode WksReportOperation::getOrCreateCustomTable(TreeNode& trOp, int nCustomIndex, bool *pbEnabled, bool bHideColLabels)
//
// Returns true if the custom table needed.
bool	WksReportOperation::GetCustomTableProps(string *pstrTblDefLabel, TreeNode& trOp, int nCustomIndex, int nAuxIndex, bool *pbUse, LPCSTR lpcszLabel)
{
	string		strCustomNode = _get_custom_table_tag_name(nCustomIndex);
	/// Joe 8/28/06  MOVE_GET_X_FROM_Y_OR_GET_Y_FROM_X_TO_CALIBRATION
	//TreeNode	trCustomSettings = op_get_optional_tables(trOp.GUI).GetNode(strCustomNode);
	/// Iris 11/03/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode	trCustomSettings = op_get_calibration_table(trOp.GUI).GetNode(strCustomNode);
	TreeNode	trCalibration = op_get_calibration_table(trOp.GUI);
	ASSERT( trCalibration );
	if( !trCalibration )
		return false;
	TreeNode	trCustomSettings = trCalibration.GetNode(strCustomNode);
	///end OP_DLG_NEW_STRUCTURE
	///Arvin 01/09/06 FIND_Z_FROM_XY
	//When current operation is "Find Z from X Y", trCalibration has not sub-branch trCustomSettings. 
	if(HasZ(trOp))
		trCustomSettings = op_get_calibration_table(trOp.GUI);
	///end FIND_Z_FROM_XY
	///End MOVE_GET_X_FROM_Y_OR_GET_Y_FROM_X_TO_CALIBRATION
	if ( !trCustomSettings.IsValid() )
		return false;

	if ( pstrTblDefLabel )
	{
		if ( lpcszLabel )
		{
			/// Iris 02/03/2007 v8.0554 CHANGE_CUSTOM_TABLE_LABEL by Snow's suggestion
			//*pstrTblDefLabel = lpcszLabel;
			*pstrTblDefLabel = GetAnalysisName() + " of " + lpcszLabel;
			///end CHANGE_CUSTOM_TABLE_LABEL
		}
		else
			trCustomSettings.GetAttribute(STR_LABEL_ATTRIB, *pstrTblDefLabel);	// take the label in GUI
	}
	
	if ( pbUse )
		*pbUse = trCustomSettings.Use;
	
	return true;
}


TreeNode WksReportOperation::GetOrCreateCustomTable(TreeNode& trOp, int nCustomIndex, bool *pbEnabled, bool bHideColLabels, int nAuxIndex, LPCSTR lpcszLabel, TreeNode &trParent)
{
	if ( pbEnabled )
		*pbEnabled = false;
	//string	strCustomNode = _get_custom_table_tag_name(nCustomIndex);
	
	string		strTblLabel;
	TreeNode	trCustom;
	bool		bEnabled = true;
	if ( GetCustomTableProps(&strTblLabel, trOp, nCustomIndex, nAuxIndex, &bEnabled, lpcszLabel) )
	{
		TreeNode	trParentUse;
		if ( NULL == trParent || !trParent.IsValid() )
			trParentUse = trOp.Calculation;
		else
			trParentUse = trParent;
		trCustom = tree_check_get_node(trParentUse, _get_custom_table_tag_name(nCustomIndex, nAuxIndex), GetCustomTableID(nCustomIndex, nAuxIndex), STR_LABEL_ATTRIB, strTblLabel);
		
		DWORD		dwGetNBranchBits = GETNBRANCH_HIDE_ROW_HEADINGS | GETNBRANCH_WRITABLE | GETNBRANCH_HIDE_ROW_LABELS;
		if ( bHideColLabels )
			dwGetNBranchBits |= GETNBRANCH_HIDE_COL_LABELS;
		trCustom.SetAttribute(TREE_Table, GetTableStringSupport(false, false, true, dwGetNBranchBits));
		
		if ( pbEnabled )
			*pbEnabled = bEnabled;
		
		tree_check_set_hidden(trCustom, !bEnabled);
	}
	
	return trCustom;
}



/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
/*
TreeNode WksReportOperation::getOrCreateCustomTable(TreeNode& trOp, int nCustomIndex, bool *pbEnabled, bool bHideColLabels, int nAuxIndex, LPCSTR lpcszLabel, TreeNode &trParent)
/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
/// end CUSTOM_TABLES_FOR_FIND_XY
/// end FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
{
	/// ML 4/28/2006 FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
	if ( pbEnabled )
		*pbEnabled = false;
	/// end FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
	string strCustomNode = _get_custom_table_tag_name(nCustomIndex);
	///Iris 6/06/05 CENTRALIZE_GUI_STRUCTURE
	//TreeNode trCustomSettings = trOp.GUI.Output.Report.Create.GetNode(strCustomNode);
	TreeNode trCustomSettings = op_get_optional_tables(trOp.GUI).GetNode(strCustomNode);
	TreeNode trCustom;
	if(trCustomSettings.IsValid())
	{
		/// ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
		//trCustom = tree_check_get_node(trOp.Calculation, strCustomNode, getCustomTableID(nCustomIndex), STR_LABEL_ATTRIB, _L("Custom Table"));
		string			strTblLabel;
		/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
		if ( trCustomSettings.TblTitle.IsValid() && !trCustomSettings.TblTitle.strVal.IsEmpty() )
			strTblLabel = trCustomSettings.TblTitle.strVal;
		else
		{
			//strTblLabel = _L("Custom Table");
			trCustomSettings.GetAttribute(STR_LABEL_ATTRIB, strTblLabel);	// take the label in GUI
		}
		
		TreeNode	trParentUse;
		if ( NULL == trParent || !trParent.IsValid() )
			trParentUse = trOp.Calculation;
		else
			trParentUse = trParent;
		/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
		
		/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
		//trCustom = tree_check_get_node(trOp.Calculation, strCustomNode, getCustomTableID(nCustomIndex), STR_LABEL_ATTRIB, strTblLabel);
		trCustom = tree_check_get_node(trParentUse, _get_custom_table_tag_name(nCustomIndex, nAuxIndex), getCustomTableID(nCustomIndex, nAuxIndex), STR_LABEL_ATTRIB, strTblLabel);
		/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
		/// end CUSTOM_TABLES_FOR_FIND_XY
		/// ML 11/23/2004 QA70-6845 LINKS_CLIPBOARD_WORK
		//trCustom.SetAttribute(TREE_Table, GetTableStringMain(false));
		//trCustom.SetAttribute(TREE_Table, GetTableStringMain(false, false, true, true, true));
		/// ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
		//trCustom.SetAttribute(TREE_Table, GetTableStringSupport(false, false, true, GETNBRANCH_HIDE_ROW_HEADINGS | GETNBRANCH_WRITABLE | GETNBRANCH_HIDE_COL_LABELS | GETNBRANCH_HIDE_ROW_LABELS));
		DWORD		dwGetNBranchBits = GETNBRANCH_HIDE_ROW_HEADINGS | GETNBRANCH_WRITABLE | GETNBRANCH_HIDE_ROW_LABELS;
		if ( bHideColLabels )
			dwGetNBranchBits |= GETNBRANCH_HIDE_COL_LABELS;
		trCustom.SetAttribute(TREE_Table, GetTableStringSupport(false, false, true, dwGetNBranchBits));
		/// ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
		/// end LINKS_CLIPBOARD_WORK
		/// ML 4/28/2006 FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
		if ( pbEnabled )
			*pbEnabled = trCustomSettings.Use;
		/// end FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
		if(!trCustomSettings.Use)
			tree_check_set_hidden(trCustom, true);
		else
			tree_check_set_hidden(trCustom, false);
		

	}
	return trCustom;
}
//---
*/
/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA

//-------- CPY 12/31/04 PICTURE_IN_REPORT_IN_BASE_CLASS
void	WksReportOperation::prepareGraphNodes(TreeNode& trOp, int nGraphIndex)
{
	for(int ii = 0; ii < GetNumGraphs(); ii++)
	{
		/// Iris 12/22/05 ONLY_PREPARE_THE_SPECIAL_GRAPH
		if( nGraphIndex>=0 && nGraphIndex != ii)
			continue;
		///End ONLY_PREPARE_THE_SPECIAL_GRAPH

		///Iris 10/08/05 ADD_OUT_GRAPH_WHEN_PREPARE_GRAPH_NODES
		constructAddOutputGraph(trOp, ii);
		///end ADD_OUT_GRAPH_WHEN_PREPARE_GRAPH_NODES
		
		/// Iris 03/12/2007 v8.0579 NOT_CREATE_IMAGE_SUB_NODES_IF_NOT_OUTPUT_THIS_GRAPH
		// Stats on Columns will be very slow when stats on many columns, will not create
		//----- Iris 5/26/2008 QA80-11607 v8.0870 FIT_CURVE_NOT_PLOT_ON_SOURCE_IF_NOT_PLOT_IN_REPORT 
		//if( IsCreateReportGraph(trOp, ii) )
		if( IsCreateReportGraph(trOp, ii) || IsPlotOnSourceGraph(trOp, ii) )
		//-----
		///end NOT_CREATE_IMAGE_SUB_NODES_IF_NOT_OUTPUT_THIS_GRAPH
		{

			TreeNode trPict, trInfo;
			///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
			//if(CheckCreateImagSubNodes(trOp, ii, nDataIndex, trPict, trInfo, lpcszLabel))			
				//UpdateImageNodePlottingInfo(trOp, trPict, trInfo, ii, nDataIndex); 
			/// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT
			//CheckCreateImagSubNodes(trOp, ii, nDataIndex, trPict, trInfo);
			checkCreateImagSubNodes(trOp, ii, trPict, trInfo);
			///end REPORT_GRAPHS_ARRANGEMENT
			///end MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
		}
		
	}
}
//-------- end PICTURE_IN_REPORT_IN_BASE_CLASS

//virtual 
///Arvin 02/21/08 QA70-10929 NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW
//int WksReportOperation::Calculate(DWORD dwExecCntrl) // return 0 if no error
int WksReportOperation::Calculate(DWORD dwExecCntrl, DWORD dwOutputCntrl) // return 0 if no error
///END NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW
{
	///Arvin 02/21/08 QA70-10929 NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW
	//return executeWithRange(OEXEM_ON_CALCULATE_ONLY, dwExecCntrl)? 0:-1;
	//Execute without anything output
	if(!executeWithRange(OEXEM_ON_CALCULATE_ONLY, dwExecCntrl))
		return -1;
	
	if(!outputReportTablesWithoutGenerateReport(dwOutputCntrl))
		return -1;
	
	return 0;
	///end 	NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW
}

/// Iris 01/25/2007 v8.0547 CLEANUP_CHECK_TREE_TRUE_CODES
/*
static bool _tree_is_true(const TreeNode& tr, const string& strTag = NULL)
{
	/// Iris 6/06/05
	//TreeNode trN = tr.GetNode(strTag);
	//TreeNode trN = (NULL == strTag)? tr : tr.GetNode(strTag);
	TreeNode trN;
	if(NULL == strTag)
		trN = tr;
	else
		trN = tr.GetNode(strTag);
	//if(trN)
		//return trN.nVal;
	
	if(trN && trN.ID != TRGP_BRANCH)
		return trN.nVal;	
	if(trN && trN.ID == TRGP_BRANCH)
		return trN.Use;
	
	return false;
}
*/
///end CLEANUP_CHECK_TREE_TRUE_CODES

/// YuI 12/03/04 v7.5170 QA70-7226 MULTIPLE_PLOTS_OF_SAME_SERIES_IN_SAME_FRAME
//CPY 12/31/04, add -1 to see if ANY
bool		WksReportOperation::IsCreateReportGraph(TreeNode& trOp, int nGraphIndex) // = -1
{
	///Iris 06/06/05 MOVE_FITTED_CURVES_TO_ROOT_LEVEL
	/*
	string strGraphNodeName;
	TreeNode trCreate = trOp.GUI.Output.Report.Create;
	if(!trCreate)
		return false;
	
	if(nGraphIndex < 0)
	{
		int nGraphs = GetNumGraphs();
		for(int ii = 0; ii < nGraphs; ii++)
		{
			strGraphNodeName = op_get_graph_tag_name(ii);
			if(_tree_is_true(trCreate, strGraphNodeName))
				return true;
		}
		return false;
	}
	strGraphNodeName = op_get_graph_tag_name(nGraphIndex);
	return _tree_is_true(trCreate, strGraphNodeName);
	*/
	TreeNode trGraph = GetGUIGraphNodes(trOp, nGraphIndex);
	/// Iris 01/25/2007 v8.0547 CLEANUP_CHECK_TREE_TRUE_CODES
	//return _tree_is_true(trGraph);
	return tree_is_true(trGraph);
	///end CLEANUP_CHECK_TREE_TRUE_CODES
	///end MOVE_FITTED_CURVES_TO_ROOT_LEVEL
}

///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
//string _get_picture_tag_name(int nPictureIndex)
string _get_picture_tag_name(int nPictureIndex, bool bIsRow = true)
{
	string strPrefix = CALCULATION_GRAPH_NODE_PREIX;
	string str;
	
	/// Iris 01/15/2007 v8.0541 ADD_DATA_LABEL_FOR_EACH_REPORT_GRAPH
	/*
	///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	//str.Format("%s%d", strPrefix, nPictureIndex + 1);
	str.Format("%s%s%d", strPrefix, bIsRow?"" : "_Col", nPictureIndex + 1);
	///End MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	*/
	strPrefix += bIsRow? "" : "_Col";
	if(nPictureIndex > 0)
		str.Format("%s%d", strPrefix, nPictureIndex + 1);
	else
		str = strPrefix;
	///end ADD_DATA_LABEL_FOR_EACH_REPORT_GRAPH
	
	return str;
}

//virtual
int     WksReportOperation::GetTotalNumPictureForOneGraphType(TreeNode& trOp, int nGraphIndex)
{
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	//return GetTotalNumData(trOp);
	if( checkIfAlwaysOnlyOneGraph(trOp, nGraphIndex) )
		return 1;
	
	int nNumData = GetTotalNumData(trOp);
	if( IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) )
	{
		int nNumFactors = GetNumFactors(trOp);
		if( nNumFactors > 0 ) // input with grouping data
		{
			nNumData = nNumData / nNumFactors;
		}			
	}
	return nNumData;
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
}

///Kevin 08/29/05 ADD_GETCOLUMNDESIGNATION

/// Iris 9/04/06 
////virtual
//void WksReportOperation::GetColumnDesignation(TreeNode& trOp, int nColNum, vector<int> &vecDesignation, int nTableID)	// nTableID = 0
//{
	//vecDesignation.SetSize(nColNum);
//
	//vecDesignation = OKDATAOBJ_DESIGNATION_Y;
	//
	//vecDesignation[0] = OKDATAOBJ_DESIGNATION_X;
//}
/////End ADD_GETCOLUMNDESIGNATION

virtual bool	WksReportOperation::applyThemeToReportSheet(TreeNode& trOp, DataRange& rgReport, int nTotalNumData)
{
	// theme is not ready but I need to have column designations
	// so for now I just designate first column as X and other as Y
	DataRange		rngInput;
	if ( !GetInput(rngInput) )
		return false;
	
	for(int nGraphIndex=0; nGraphIndex < GetNumGraphs(); nGraphIndex++)	
	{
		int nPicNum = GetTotalNumPictureForOneGraphType(trOp, nGraphIndex);
		for( int nDataIndex = 0; nDataIndex < nPicNum; nDataIndex++ )
		{
			uint nTableID = GetResultCurveTableID(trOp, nDataIndex, nPicNum, nGraphIndex);
			if( nTableID > 0 )
			{
				/// Iris 9/14/05 SEPARATE_APPLY_THEME_TO_RESULT_CURVE_TABLE_CODES
				/*
				vector<uint> vnTemp;
				vnTemp.Add(nTableID);
				
				DataRange drTable;
				if(!rgReport.GetSubRange(vnTemp, drTable, false))
					//return false;
					break;
				if( drTable.IsValid() )
				{
					int c1;
					int c2;
					int r1;
					int r2;
					Worksheet wksTemp;
					drTable.GetRange(0, r1, c1, r2, c2, wksTemp);

					///Kevin 08/29/05 ADD_GETCOLUMNDESIGNATION
					vector<int> vecDesignation;
					GetColumnDesignation(trOp, c2 - c1 + 1, vecDesignation, nTableID);
					///End ADD_GETCOLUMNDESIGNATION

					for( int nCol = c1; nCol <= c2; nCol++ )
					{
						Column col(wksTemp, nCol);
						if( col )
						{
							///Kevin 08/29/05 ADD_GETCOLUMNDESIGNATION
							///use GetColumnDesignation to specify the form of Column, the default is XYYYYY..

							//if( nCol == c1 )
								//col.SetType(OKDATAOBJ_DESIGNATION_X);
							//else 
								//col.SetType(OKDATAOBJ_DESIGNATION_Y);

							switch(vecDesignation[nCol - c1]) 
							{
							case  OKDATAOBJ_DESIGNATION_X :
							   col.SetType(OKDATAOBJ_DESIGNATION_X);
								break;
							case  OKDATAOBJ_DESIGNATION_Y :
									   col.SetType(OKDATAOBJ_DESIGNATION_Y);
								break;
							case  OKDATAOBJ_DESIGNATION_NONE :
									   col.SetType(OKDATAOBJ_DESIGNATION_NONE);
								break;
							default:
								break;
							}
							///End ADD_GETCOLUMNDESIGNATION
						}
					}					
				}
				*/
				applyThemeToResultCurveTable(trOp, rgReport, nTableID);
				///End SEPARATE_APPLY_THEME_TO_RESULT_CURVE_TABLE_CODE
			}
		}
	}
	
	return true;
}

/// Iris 9/14/05 SEPARATE_APPLY_THEME_TO_RESULT_CURVE_TABLE_CODE
bool WksReportOperation::applyThemeToResultCurveTable(TreeNode& trOp, DataRange& rgReport, int nTableID)
{
	//---- CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
	// we should not do this anymore, all set be set via attribute in tree
	/*
	vector<uint> vnTemp;
	vnTemp.Add(nTableID);
	
	DataRange drTable;
	if(!rgReport.GetSubRange(vnTemp, drTable, false))
		return false;	
		
	if( drTable.IsValid() )
	{
		int 		r1, c1, r2, c2;
		Worksheet 	wksTemp;
		drTable.GetRange(0, r1, c1, r2, c2, wksTemp);
	
		///Kevin 08/29/05 ADD_GETCOLUMNDESIGNATION
		vector<int> vecDesignation;
		GetColumnDesignation(trOp, c2 - c1 + 1, vecDesignation, nTableID);
		///End ADD_GETCOLUMNDESIGNATION
	
		int index=0;
		for( int nCol = c1; nCol <= c2; nCol++ )
		{
			Column col(wksTemp, nCol);
			if( col )
			{			
				col.SetType(vecDesignation[index++]);
			}
		}
	}
	*/
	return true;
}
///End SEPARATE_APPLY_THEME_TO_RESULT_CURVE_TABLE_CODE


//----- CPY 1/3/04 NLSF_SOURCE_GRAPH_NOT_UPDATED
//virtaul
bool WksReportOperation::SetSourceDataPlot(TreeNode& trOp, vector& vY, vector& vX, int nDataIndex, int nTotalNumData, uint dwPlotUID)
{
	trOp.Temp.ID = 1;
	/// Hong 08/13/09 QA80-14138 REDUCE_OPERATION_SIZE_OF_STATS_ON_COLS
#ifdef		__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__
	if ( 0 == dwPlotUID )
	{
		TreeNode trDataPlotUIDTemp = get_enumerated_node(trOp.Temp, STR_PARENT_PLOT_UID_ATTRIB, nDataIndex);
		if ( trDataPlotUIDTemp )
			trDataPlotUIDTemp.Remove();
		return true;
	}
#endif		//__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__
	TreeNode trDataPlotUIDTemp = check_add_enumerated_node(trOp.Temp, STR_PARENT_PLOT_UID_ATTRIB, nDataIndex);
	if( trDataPlotUIDTemp )
	{
		trDataPlotUIDTemp.nVal = dwPlotUID;
		double dmin, dmax;
		vY.GetMinMax(dmin, dmax);
		trDataPlotUIDTemp.SetAttribute(STR_PARENT_PLOT_Y_RANGE_ATTRIB, range_to_str(dmin, dmax, 1));
		
		_DEBUG_PLOT_UID("SetSourceDataPlot ", dwPlotUID)
		
		return true;
	}
	return error_report("SaveSourceGraphInfo failed");
}
//-----

DataPlot WksReportOperation::GetSourceDataPlot(int index, TreeNode trOp, double* pMin, double* pMax)// = NULL = NULL);
{
	DataPlot dp;
	/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
	/*
	if(!trFit) return dp;//invalid
	string strTemp;
	if(!trFit.GetAttribute(STR_PARENT_PLOT_UID_ATTRIB, strTemp))
		return dp; // invalid
	*/
	//	DWORD dwPlotObjUID = atoi(strTemp);
	if( !trOp.Temp )
	{
		error_report("GetSourceDataPlot found trOp.Temp invalid");
		return dp;
	}
	TreeNode trPlotUID = get_enumerated_node(trOp.Temp, STR_PARENT_PLOT_UID_ATTRIB, index);
	if( !trPlotUID )
	{
		//error_report("GetSourceDataPlot found trOp.Temp without plot UID");
		return dp;
	}
	DWORD dwPlotObjUID = trPlotUID.nVal;
	/// end PICTURE_IN_REPORT_IMPROVEMENT	
			
	_DEBUG_PLOT_UID("GetSourceDataPlot ", dwPlotObjUID)
	
	if( 0== dwPlotObjUID ) 
		return dp;
	
	dp = (DataPlot)Project.GetObject(dwPlotObjUID);
	/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
	//	if(trFit.GetAttribute(STR_PARENT_PLOT_Y_RANGE_ATTRIB, strTemp))
	string strTemp;
	if( trPlotUID.GetAttribute(STR_PARENT_PLOT_Y_RANGE_ATTRIB, strTemp) )
	/// end PICTURE_IN_REPORT_IMPROVEMENT
	{
		double vMin, vMax;
		int nInc; // ignore this, it was just set to be 1 when saving
		if(str_to_range(strTemp, vMin, vMax, nInc))
		{
			if(pMin) *pMin = vMin;
			if(pMax) *pMax = vMax;
		}
	}
	return dp;
}
	

	/// end RANGE_BASED_REGRESSIONS

//-----

/// Iris 01/26/2007 v8.0548 REPORT_GRAPH_X_AXIS_TYPE_SAME_AS_SOURCE_GRAPH
/*
/// Iris 5/19/05 QA70-6365 SETUP_FITY_CONFID_PRODI_LINE_COLOR
bool	WksReportOperation::applyFormatFromReportToSourcePage(GraphLayer& gl, int nDataIndex, int nGraphIndex)
{
	GraphPage gp;
	gl.GetParent(gp);
	
	if(!gl || !gp)
		return false;	
	
	GraphPage gpReport(GetGraphName(nGraphIndex));
	if(!gpReport)
		return false;
	
	Tree tr;
	tr = gp.GetFormat(FPB_ALL, FOB_ALL, true, true);
	return gpReport.ApplyFormat(tr);
}
*/
bool	WksReportOperation::setFormatFromSourceGraphToReport(TreeNode& trOp, GraphLayer& glReport, int nGraphIndex, int nDataIndex)
{
	DataPlot 	dp;
	dp = GetSourceDataPlot(nDataIndex, trOp);
	if(dp)
	{
		GraphLayer 	glSource;
		dp.GetParent(glSource);
	
		///Jasmine 08/07/07 SET_LEGEND_MODE_FROM_SOURCE_GRAPH
		GraphPage gpSource = glSource.GetPage();
		GraphPage gpReport = glReport.GetPage();
		string strCustomFormat;
		int	nLegendMode = get_page_legend_mode(gpSource, strCustomFormat);		
		set_page_legend_mode(gpReport, nLegendMode, strCustomFormat);
		///End SET_LEGEND_MODE_FROM_SOURCE_GRAPH
		
		/// Iris 08/06/2007 v8.0674 ALWAYS_COPY_SOURCE_GRAPH_AXIS_TYPE
		// need to copy X & Y Axis type from source graph
		//if(glSource.LT_execute("Axis -pg X S axistype"))
		vector<string> 		vsAxisNames = {"X", "Y"};
		for(int ii = 0; ii < vsAxisNames.GetSize(); ii++)
		{
			string strLT;
			strLT.Format("Axis -pg %s S axistype", vsAxisNames[ii]);
			
			if(glSource.LT_execute(strLT))
		///end ALWAYS_COPY_SOURCE_GRAPH_AXIS_TYPE
			{
				double	dType;
				if(LT_get_var("axistype", &dType))
				{
					string str;
					/// Iris 08/06/2007 v8.0674 ALWAYS_COPY_SOURCE_GRAPH_AXIS_TYPE
					//str.Format("Axis -ps X S %.0f", dType);
					str.Format("Axis -ps %s S %.0f", vsAxisNames[ii], dType);
					///end ALWAYS_COPY_SOURCE_GRAPH_AXIS_TYPE
					glReport.LT_execute(str);
				}
			}
		}
	}
	return true;	
}
///end REPORT_GRAPH_X_AXIS_TYPE_SAME_AS_SOURCE_GRAPH

/// ML 8/4/2006 REMOVING_CUSTOM_TABLE
/*
/// ML 1/26/2005 CUSTOM_TABLE_TO_GRAPH
bool	WksReportOperation::addReportTableToGraph(TreeNode& trOp, GraphLayer& gl, DataRange& rReportSheet)
{
	/// Iris 8/16/05 QA70-7889 CONTROL_IF_ADD_RESULT_TABLE
	TreeNode trReport = trOp.GUI.Output.PasteResultTable;
	if(!trReport)
		return false;
	
	if(!trReport.nVal)
		return true; 
	///end CONTROL_IF_ADD_RESULT_TABLE
	
	string		strName;
	int		nTableID = getTableIdForGraph(&strName, trOp);
	if ( nTableID <= 0 )
		return true;		// none required
	
	Grid		grid;
	if ( !grid.Attach(rReportSheet, nTableID) )
		return error_report("Could not find table for graph.");

	Grid		gridInGraph;
	OriginObject obj;

	if ( gl.SetTable(strName, grid, gridInGraph, obj) )
	{
		autosize_rowcol(gridInGraph);
		obj.AutoSize();
		return true;
	}
	
	return false;
}
/// end CUSTOM_TABLE_TO_GRAPH

/// ML 1/31/2006 QA70-8141 UPDATING_TABLE_OBJECTS_IN_GRAPHS_FOR_ANALYSIS
bool 	WksReportOperation::UpdateGraphTableObjects(GraphLayer &gl, TreeNode& trOp, const DataRange &rReportSheetOutput)
{
	if ( !rReportSheetOutput.IsValid() )
		return false;

	Grid			gridInGraph;		// the one to be updated
	OriginObject	obj;
	DWORD			dwUID = rReportSheetOutput.GetUID(TRUE);
	if (0 == dwUID)
	{
		ASSERT(FALSE);
		return false;
	}

	string			str;
	str = (int)dwUID;
	if ( gl.SetTable(str, NULL, gridInGraph, obj) )
	{
		//autosize_rowcol(gridInGraph);
		//obj.AutoSize();
		return true;
	}
	
	return false;
}
/// end UPDATING_TABLE_OBJECTS_IN_GRAPHS_FOR_ANALYSIS
*/
/// end REMOVING_CUSTOM_TABLE

//------ CPY 8/3/06 FIT_LR_INSERTED_TABLE_SHOULD_NOT_HAVE_COL_TITLES
static int _remove_unused_cols(Worksheet& wks)
{
	int n1 = wks.FindFirstEmpty(1); //assume 1st col might be empty
	int nCount = 0;
	if(n1 > 0)
	{
		while(wks.GetNumCols() > n1)
		{
			wks.DeleteCol(n1);
			nCount++;
		}
	}
	return nCount;	
}
//------ end FIT_LR_INSERTED_TABLE_SHOULD_NOT_HAVE_COL_TITLES

///Arvin 12/11/07 SHOULD_DEL_OLD_TABLE_AND_PASTE_NEW_TABLE_WHEN_CHANGE_PARAM
static void _check_and_del_old_result_table(GraphLayer& gl, LPCSTR lpcsTableName)
{
	GraphObject goTemp;
	goTemp = gl.GraphObjects(lpcsTableName);
	if(goTemp)
	{
		Worksheet wksTable;
		if(goTemp.GetLinkTable(wksTable) && wksTable)
		{
			wksTable.Destroy();
		}
		else
		{
			WorksheetPage wpTable = Project.WorksheetPages(lpcsTableName);
			if(wpTable)
				wpTable.Destroy();
		}
		goTemp.Destroy();
	}	
}
///end SHOULD_DEL_OLD_TABLE_AND_PASTE_NEW_TABLE_WHEN_CHANGE_PARAM

/// ML 7/26/2006 QA70-8856 PASTING_THEME_WITH_LINKS_OUTSIDE_OF_REPORT
///------ Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
//bool 	WksReportOperation::addResultsTblToSourceGraph(TreeNode& trOp, GraphLayer &gl, const DataRange &rReportSheetOutput)
bool 	WksReportOperation::addResultsTblToSourceGraph(TreeNode& trOp, GraphLayer &gl, const DataRange &rReportSheetOutput, BOOL bUpdateOnlyIfNewTable)
///------ End CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
{
	//----- CPY 5/2/07 QA70-9687 TEMPLATE_FOR_TABLE_INSERT_TO_GRAPH
	//TreeNode	trReport = trOp.GUI.Output.PlotSettings.PasteResultTable;
	//if(!trReport)
	//	return false;
	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode	trPlotSettings = trOp.GUI.Output.PlotSettings;
	TreeNode	trPlotSettings = OP_GUI_GRAPH_ARRANGEMENT_NODE(trOp.GUI);
	///end OP_DLG_NEW_STRUCTURE
	if(!trPlotSettings)
		return error_report("trOp.GUI.Output.PlotSettings invalid");
	TreeNode	trReport = trPlotSettings.PasteResultTable;
	if(!trReport) return error_report("PasteResultTable invalid");
	//-----
	///Cheney 2007-8-31 QA70-10330 CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
	//if(!trReport.nVal)
	//	return true;		// not checked
	int nCheckReport = 0;
	trReport.GetAttribute( STR_USE_ATTRIB, nCheckReport );
	/// ML 9/11/2007 BAD_USE_TEST
	//if(nCheckReport)
	//	return true;
	if(!nCheckReport)
		return true;
	/// end BAD_USE_TEST
	///end CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE

	// Similar to the xf add_table_to_graph():
	Worksheet	wks;
	/// ML 8/7/2006 INTERMEDIATE_BOOK_BETTER_CREATION
	/*
	wks.Create("Table", CREATE_HIDDEN);
	WorksheetPage	wp = wks.GetPage();
	wp.Rename("Table1");
	//------ CPY 8/3/06 FIT_LR_INSERTED_TABLE_SHOULD_NOT_HAVE_COL_TITLES
	//wks.SetSize(1, 1);
	wks.SetSize(1, -1);// we should keep the cols from template
	wks_set_show_labels(wks, -1, -1);
	//------ end FIT_LR_INSERTED_TABLE_SHOULD_NOT_HAVE_COL_TITLES
	*/
	//-------------------- CPY 5/2/07 QA70-9687 TEMPLATE_FOR_TABLE_INSERT_TO_GRAPH
	//			GETN_STR(TableTemplate, _L("Template to Create Table"), "") GETN_ID(IDE_REOPRT_TABLE_TEMPLATE)
	//if ( !okoc_create_workbook(&wks, "Table1", "Table", CREATE_HIDDEN) )
	//	return false;
	string strWksTemplate;
	///Cheney 2007-8-31 QA70-10330 CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
	//if(trPlotSettings.TableTemplate) strWksTemplate = trPlotSettings.TableTemplate.strVal;
	if(trPlotSettings.PasteResultTable.TableTemplate) 
		strWksTemplate = trPlotSettings.PasteResultTable.TableTemplate.strVal;
	///end CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
	if(strWksTemplate.IsEmpty())
		strWksTemplate= GetClassName();
	///------ Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
	//char szSaveDefaultTemplate[MAXLINE];
	//DefaultTemplate(szSaveDefaultTemplate, EXIST_WKS);
	//DefaultTemplate("Table", EXIST_WKS, false);// change default template and save old		
	GraphObject		goTable;
	{
	DefaultTemplateTemporaryChange		tempChange("Table", EXIST_WKS);
	///------ End CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
	/// Hong 06/20/08 QA8011751 FIX_OLD_TABLE_FAIL_DEL_WHEN_NAME_ENUMERATED
	/*
	///Arvin 12/11/07 SHOULD_DEL_OLD_TABLE_AND_PASTE_NEW_TABLE_WHEN_CHANGE_PARAM		
	_check_and_del_old_result_table(gl, "Table1");	
	///end SHOULD_DEL_OLD_TABLE_AND_PASTE_NEW_TABLE_WHEN_CHANGE_PARAM
	BOOL bRet = okoc_create_workbook(&wks, "Table1", strWksTemplate, CREATE_HIDDEN);	
	*/
	const string	lpszDefaultTableBkName("Table1");
	string			strOldTblBkName(lpszDefaultTableBkName);
	int				nTblBkUID;
	/// Hong 05/07/09 QA80-11726 TRY_NOT_TO_REPLACE_TABLE_ALWAYS
	///------ Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
	//GraphObject		goTable;
	///------ End CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
	/// end TRY_NOT_TO_REPLACE_TABLE_ALWAYS
	if ( trReport.GetAttribute(TREE_UID, nTblBkUID) )
	{
		Worksheet	wksOldTable;
		wksOldTable = (Worksheet)Project.GetObject(nTblBkUID);
		///------ Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
		//if ( wksOldTable )		
		//{
		if ( wksOldTable && wks_has_cell_linkes(wksOldTable) )
		{
			if ( bUpdateOnlyIfNewTable )
				return true;
		///------ End CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
			strOldTblBkName = wksOldTable.GetPage().GetName();		
			/// Hong 05/07/09 QA80-11726 TRY_NOT_TO_REPLACE_TABLE_ALWAYS
			wks = wksOldTable;
			/// TD ML 07-24-2008 QA80-14008 SR6_FIX_CRASH_ON_SHRINKING_SERIES_WITH_LINKS
			//wks.SetSize(1, 1);	// Hong, code from ML--	// to make sure there no leftovers after applying the INI theme
			//Worksheet::SetSize(1,1) will shrink the first column to one cell, causing the remaining cell Ref info to crash Origin on exit.
			wks.SetSize(0, 0);
			/// end SR6_FIX_CRASH_ON_SHRINKING_SERIES_WITH_LINKS
			goTable = gl.GraphObjects(strOldTblBkName);
			/// end TRY_NOT_TO_REPLACE_TABLE_ALWAYS
		}
	}
	/// Hong 05/07/09 QA80-11726 TRY_NOT_TO_REPLACE_TABLE_ALWAYS
	//// Hong, to do, this remove mechanism should be changed to update after SR2
	//_check_and_del_old_result_table(gl, strOldTblBkName);
	
	//BOOL bRet = okoc_create_workbook(&wks, lpszDefaultTableBkName, strWksTemplate, CREATE_HIDDEN);
	//if ( !bRet )
	//	return error_report("failed to create table");
	if ( !wks.IsValid() )
	{
		BOOL bRet = okoc_create_workbook(&wks, lpszDefaultTableBkName, strWksTemplate, CREATE_HIDDEN);
		if ( !bRet )
			return error_report("failed to create table");
	}
	/// end TRY_NOT_TO_REPLACE_TABLE_ALWAYS
	
	nTblBkUID = wks.GetUID(TRUE);
	trReport.SetAttribute(TREE_UID, nTblBkUID);
	/// end FIX_OLD_TABLE_FAIL_DEL_WHEN_NAME_ENUMERATED
	
	//------ Folger 12/05/07 LOCALIZE_UPDATE_TABLE_GRAPH_OBJECT
	GraphObject go = wks.GraphObjects("Update");
	if (go)
		go.Text = GetLocalized(E_STR_UPDATE_TABLE);
	//------
	
	///------ Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
	//DefaultTemplate(szSaveDefaultTemplate, EXIST_WKS, false);// restore old default template
	}
	///------ End CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
	
	//--------------------
	WorksheetPage	wp = wks.GetPage();
	/// end INTERMEDIATE_BOOK_BETTER_CREATION
	
	//GraphObject grTable = gl.CreateLinkTable(wp.GetName(), wks, -1, CLTBL_NO_FIRE_EVENT);//|CLTBL_NO_AUTO_SIZE);
	Grid		grid;
	//grTable.GetGrid(grid);
	grid.Attach(wks);
	if(grid)
	{
		DWORD		uidRef = rReportSheetOutput.GetUID(true);
		Tree		trAllAnalysesDef;
		if ( load_all_analyses_default_theme(trAllAnalysesDef) )
		{
			trAllAnalysesDef.Root.ReportUID.nVal = uidRef;
			trAllAnalysesDef.Root.ReportUID.ID = 0x03e1;
			grid.ApplyFormat(trAllAnalysesDef, TRUE, TRUE);
		}
		
		/// ML 8/10/2006 REMOVING_CUSTOM_TABLE_FROM_GUI
		//TreeNode	trCustTblTheme = get_custom_table_themes(trOp.GUI);
		///Cheney 2007-8-31 QA70-10330 CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
		//TreeNode	trCustTblTheme = trPlotSettings.ThemeRsltTable;//trOp.GUI.Output.PlotSettings.ThemeRsltTable;
		TreeNode	trCustTblTheme = trPlotSettings.PasteResultTable.ThemeRsltTable;
		///end CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
		if(!trCustTblTheme)
			return false;
		/// end REMOVING_CUSTOM_TABLE_FROM_GUI
		string		strTheme = trCustTblTheme.strVal; 
		Tree		treeTh;
		///Sophy 10/17/2008 QA80-12397 FIX_SET_THEME_ERROR_FITTING_FROM_GRAPH roll back Sim's changes. strTheme is not dialog theme here, can not use theme_is_factory_default() .
		///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
		int			nType = okutil_cvt_str_to_predefined_type(strTheme);
		if ( PDS_FACTORY_DEFAULT != nType )
		//if ( !theme_is_factory_default(strTheme) )
		///---END CLEAN_DEFAULT_THEME
		///end FIX_SET_THEME_ERROR_FITTING_FROM_GRAPH
		{
			if ( strTheme.IsEmpty() )
				strTheme = getClassNameForCustomTableTheme() + STR_CUSTOM_THEME_MAKER_EXT;
			StringArray	saPathNames;
			int			nCount = okutil_find_files(&saPathNames, strTheme, STR_CUSTOM_THEME_MAKER_SUBFOLDER, true);
			if ( saPathNames.GetSize() < 1 )
				return false;
			string		strINIThemePathName = saPathNames[0];
			TreeNode	trCalc = trOp.Calculation;
			if ( MakeCustomTableTheme(&treeTh, strINIThemePathName, &trCalc) )
			{
				treeTh.Root.ReportUID.nVal = uidRef;
				int			nn = grid.UpdateThemeIDs(treeTh.Root);
				if (  nn != 0)
				{
					ASSERT(FALSE);		// bad tree
				}
				
				/// ML Just for debugging:
				string		strSave = strINIThemePathName + ".xml";
				ASSERT( treeTh.Save(strSave) );
			}
			else
				return FALSE;
		}
		else
		{
			Tree		tr;
			// Programmatic default:			
			if ( !GetCustomTableDefaultTheme(tr) )
				return FALSE;

			tr.Root.ID = 1;
			tr.Root.ReportUID.nVal = uidRef;
			int			nn = grid.UpdateThemeIDs(tr.Root);
			if ( nn != 0)
			{
				ASSERT(FALSE);		// bad tree
			}
			
			/// ML Just for debugging:
			string		strSave = okutil_theme_get_path() + "__DefaultAppliedTheme.oth";
			ASSERT( tr.Save(strSave) );
			///
			treeTh = tr;
		}

		if ( grid.ApplyFormat(treeTh, TRUE, TRUE) )
		{
			_remove_unused_cols(wks);		//------ CPY 8/3/06 FIT_LR_INSERTED_TABLE_SHOULD_NOT_HAVE_COL_TITLES

			/// ML 8/2/2007 COMPLAINT_ABOUT_TO_LONG_FITTING_FUNCTION_FORMULA_MAKING_COLUMN_TOO_WIDE
			//grid.AutoSize();
			autosize_rowcol(grid, 1.5, 13);
			/// end COMPLAINT_ABOUT_TO_LONG_FITTING_FUNCTION_FORMULA_MAKING_COLUMN_TOO_WIDE
			//return TRUE;
		}
	}
	/// Hong 05/07/09 QA80-11726 TRY_NOT_TO_REPLACE_TABLE_ALWAYS
	//GraphObject grTable = gl.CreateLinkTable(wp.GetName(), wks, -1, CLTBL_NO_FIRE_EVENT);//|CLTBL_NO_AUTO_SIZE);
	//if (!grTable.IsValid())
	//	return false;
	if ( !goTable.IsValid() )
	{
		goTable = gl.CreateLinkTable(wp.GetName(), wks, -1, CLTBL_NO_FIRE_EVENT);//|CLTBL_NO_AUTO_SIZE);
		if ( !goTable.IsValid() )
			return false;
	}
	else
		goTable.Invalidate();
	/// end TRY_NOT_TO_REPLACE_TABLE_ALWAYS
	
	/*
	Grid		gridTbl;
	grTable.GetGrid(gridTbl);
	if (!gridTbl.IsValid())
		return false;
	gridTbl.AutoSize();
	*/

	return true;
}
/// end PASTING_THEME_WITH_LINKS_OUTSIDE_OF_REPORT


//virtual
/// ML 7/25/2006 NEW_TABLE_ON_AUTOUPDATE_BUG
//bool 	WksReportOperation::UpdateSourceGraphFromReport(TreeNode& trOp, const DataRange &rReportSheetOutput, int nTotalNumData)
bool 	WksReportOperation::UpdateSourceGraphFromReport(TreeNode& trOp, const DataRange &rReportSheetOutput, int nTotalNumData, int nExecMode)
/// end NEW_TABLE_ON_AUTOUPDATE_BUG
{
	int nGraphIndex = 0; // CPY 12/31/04 PICTURE_IN_REPORT_IN_BASE_CLASS, assume 1st plot type will be used to update source graph
	GraphLayer 	gl; /// Iris 9/12/06 QA70-8593-13 v8.0479 PAST_CUSTOM_TABLE_AFTER_UPDATED_LAST_SOURCE
	
	/// Iris 01/24/2007 v8.0546 CONTROL_HOW_PLOT_FIT_CURVE_ON_SOURCE_GRAPH
	bool		bPlot = true;
	TreeNode 	trGUIGraph = GetGUIGraphNodes(trOp, nGraphIndex);
	if(trGUIGraph && trGUIGraph.GetNodeCount() > 0)
	{
		TreeNode	trHowPlot = trGUIGraph.PlotFit;
		if(trHowPlot && 0 == trHowPlot.nVal || trHowPlot && !trHowPlot.Enable) //0 means None plot
		{
			bPlot = false;
		}		
	}
	
	if(bPlot)
	///end CONTROL_HOW_PLOT_FIT_CURVE_ON_SOURCE_GRAPH
	{	
	
		/// Iris 01/18/2007 v8.0543 REPORT_GRAPHS_ARRANGEMENT
		//for( int nDataIndex = 0; nDataIndex < nTotalNumData; nDataIndex++ )
		//{
		int			nDataIndex = 0;
		TreeNode 	trGraph = trOp.Calculation.GetNode(op_get_graph_tag_name(nGraphIndex));
		///Arvin 02/20/08 QA70-11094-P2 ONLY_PLOT_ONE_FITTEDCURVE_TO_SOURCE_WHEN_PLOT_ALL_IN_ONE_GRAPH
		//Using wrong TreeNode to decide the number of fitted curve plots.
		TreeNode 	trGraphInfo = trOp.Calculation.GraphInfo;
		if(trGraphInfo)
			trGraph = trGraphInfo.GetNode(op_get_graph_tag_name(nGraphIndex));
		///END ONLY_PLOT_ONE_FITTEDCURVE_TO_SOURCE_WHEN_PLOT_ALL_IN_ONE_GRAPH
		if(!trGraph)
			return false;
			
		TreeNodeCollection 	trRows(trGraph, _get_picture_tag_name(-1, true));
		for(int nPicRow = 0; nPicRow < trRows.Count(); nPicRow++)
		{
			TreeNode			trRow = trGraph.GetNode(_get_picture_tag_name(nPicRow, true));
			if( !trRow )
			{
				error_report("Found invalid Report Grpah row treenode");
				continue;
			}
			
			TreeNodeCollection 	trCols(trRow, _get_picture_tag_name(-1, false));
			for(int nPicCol = 0; nPicCol < trCols.Count(); nPicCol++)
			{
			///end REPORT_GRAPHS_ARRANGEMENT
			DataPlot dp;
			dp = GetSourceDataPlot(nDataIndex, trOp);
			if(dp)
			{
				dp.GetParent(gl);
				if(gl)
				{
					//------ Iris 5/26/2008 QA80-11607 v8.0870 FIT_CURVE_NOT_PLOT_ON_SOURCE_IF_NOT_PLOT_IN_REPORT
					//bool bCreateGraph = IsCreateReportGraph(trOp, nGraphIndex);
					//if(bCreateGraph) /// Iris 7/12/06 NOT_UPDATE_SOURCE_GRAPH_FROM_REPORT_WHEN_NO_REPORT_GRAPH
					bool	bPlotOnSourceGraph = IsPlotOnSourceGraph(trOp, nGraphIndex);
					if( bPlotOnSourceGraph )
					//------ 
					{
						/// Hong 02/22/10 QA80-15137 FIX_FAIL_PLOT_ALL_FITTEDCURVE_TO_SOURCE_GRAPH_WHEN_PLOT_ALL_IN_ONE_GRAPH
						// See checkCreateImagInfoSubNodes for Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
						int			nNumPlots = GetNumPlotsInOneGraph(trOp, nGraphIndex);
						for ( int iPlotIndex; iPlotIndex < nNumPlots; iPlotIndex++ )
						{
						/// end FIX_FAIL_PLOT_ALL_FITTEDCURVE_TO_SOURCE_GRAPH_WHEN_PLOT_ALL_IN_ONE_GRAPH
							/// Iris 01/18/2007 v8.0543 REPORT_GRAPHS_ARRANGEMENT
							//int nPictureIndex = ReportGetPicureIndexFromDataIndex(nGraphIndex, nDataIndex);
							//TreeNode trPlotInfo = checkGetPlotInfoNode(trOp, nGraphIndex, nPictureIndex);
							//PlotResultInLayer(nDataIndex, trPlotInfo, trOp, gl, nGraphIndex);
							//applyFormatFromReportToSourcePage(gl, nGraphIndex, nDataIndex);   /// Iris 5/19/05 QA70-6365 SETUP_FITY_CONFID_PRODI_LINE_COLOR
							///Arvin 11/16/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
							//TreeNode trPlotInfo = checkGetPlotInfoNode(trOp, nGraphIndex, nPicRow, nPicCol);
							/// Hong 02/22/10 QA80-15137 FIX_FAIL_PLOT_ALL_FITTEDCURVE_TO_SOURCE_GRAPH_WHEN_PLOT_ALL_IN_ONE_GRAPH
							//TreeNode trPlotInfo = CheckGetPlotInfoNode(trOp, nGraphIndex, nPicRow, nPicCol);
							TreeNode trPlotInfo = CheckGetPlotInfoNode(trOp, nGraphIndex, nPicRow, nPicCol, iPlotIndex);
							/// end FIX_FAIL_PLOT_ALL_FITTEDCURVE_TO_SOURCE_GRAPH_WHEN_PLOT_ALL_IN_ONE_GRAPH
							///end NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
							///Sophy 1/19/2009 v8.0959 FIX_FITTED_CURVE_HAS_NO_CORRECT_COLOR_INCREMENT
							//plotResultInLayer(nDataIndex, trPlotInfo, trOp, gl, nGraphIndex, nPicRow, nPicCol, true);
							int nPictureIndex = nPicRow * GetReportGraphTableColNum(trOp, nGraphIndex) + nPicCol;
							plotResultInLayer(nDataIndex, trPlotInfo, trOp, gl, nGraphIndex, nPictureIndex, nPicCol, true);				
							///end FIX_FITTED_CURVE_HAS_NO_CORRECT_COLOR_INCREMENT
							/// Iris 01/26/2007 v8.0548 REPORT_GRAPH_X_AXIS_TYPE_SAME_AS_SOURCE_GRAPH
							//applyFormatFromReportToSourcePage(gl, nGraphIndex, nDataIndex);
							///end REPORT_GRAPH_X_AXIS_TYPE_SAME_AS_SOURCE_GRAPH
							///end REPORT_GRAPHS_ARRANGEMENT						
						/// Hong 02/22/10 QA80-15137 FIX_FAIL_PLOT_ALL_FITTEDCURVE_TO_SOURCE_GRAPH_WHEN_PLOT_ALL_IN_ONE_GRAPH
						}
						/// end FIX_FAIL_PLOT_ALL_FITTEDCURVE_TO_SOURCE_GRAPH_WHEN_PLOT_ALL_IN_ONE_GRAPH
					}	
	
				}
			}			
				nDataIndex++;/// Iris 01/18/2007 v8.0543 REPORT_GRAPHS_ARRANGEMENT
				
			}
		}
	}
	
	/// Iris 01/24/2007 v8.0546 CONTROL_HOW_PLOT_FIT_CURVE_ON_SOURCE_GRAPH
	if(!gl)
	{
		DataPlot dp = GetSourceDataPlot(0, trOp);
		if(dp)
			dp.GetParent(gl);
	}
	///end CONTROL_HOW_PLOT_FIT_CURVE_ON_SOURCE_GRAPH
		
	/// Iris 9/12/06 QA70-8593-13 v8.0479 PAST_CUSTOM_TABLE_AFTER_UPDATED_LAST_SOURCE
	/// Iris 02/27/2007 v8.0571 CHANGE_PARAM_TO_OPEN_DLG_FIT_BUTTON_IS_GRAY
	//if(rReportSheetOutput.IsValid() && gl.IsValid() && OEXEM_ON_CREATE == nExecMode)
	///Arvin 12/11/07 SHOULD_DEL_OLD_TABLE_AND_PASTE_NEW_TABLE_WHEN_CHANGE_PARAM
	//bool	bNewReport = (OEXEM_ON_CREATE_OPEN_GUI == nExecMode || OEXEM_ON_CREATE == nExecMode)? true : false;
	bool	bNewReport = (OEXEM_ON_CREATE_OPEN_GUI == nExecMode || OEXEM_ON_CREATE == nExecMode || nExecMode == OEXEM_ON_CHANGEPARAM)? true : false;
	///END SHOULD_DEL_OLD_TABLE_AND_PASTE_NEW_TABLE_WHEN_CHANGE_PARAM
	///------ Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
	//if(rReportSheetOutput.IsValid() && gl.IsValid() && bNewReport)
	/////end CHANGE_PARAM_TO_OPEN_DLG_FIT_BUTTON_IS_GRAY
		//addResultsTblToSourceGraph(trOp, gl, rReportSheetOutput);
	if ( rReportSheetOutput.IsValid() && gl.IsValid() )
		addResultsTblToSourceGraph(trOp, gl, rReportSheetOutput, !bNewReport);
	///------ End CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
	///End PAST_CUSTOM_TABLE_AFTER_UPDATED_LAST_SOURCE
	/// Hong 05/31/09 QA80-13647-P2A FIX_PASTED_TABLE_FAIL_REFRESH_WHEN_AUTO_UPDATE_FROM_EXCEL_DATA
	else if ( gl.IsValid() )
		gl.Invalidate(FALSE);
	/// end FIX_PASTED_TABLE_FAIL_REFRESH_WHEN_AUTO_UPDATE_FROM_EXCEL_DATA
	
	return true;
}
//virtual
///Iris 4/01/05 FIT_REGRESSION_PLOTS
//uint		WksReportOperation::GetResultCurveTableID(TreeNode& trOp, int nDataIndex, int nTotalNumData)
uint		WksReportOperation::GetResultCurveTableID(TreeNode& trOp, int nDataIndex, int nTotalNumData, int nGraphIndex)
{
	return 0;
}

/// Iris 12/09/2009 QA81-3224-P6 FIX_NOT_PLOT_ERR_COL_IN_LRXERR_REPORT_GRAPH_WHEN_OPEN_DLG_FROM_GRAPH
// Cannot check if one data range is err by column type, sometimes we assign Y column as YErr data or XErr data. 
/*
///Arvin 02/03/08 QA70-10970 ERORR_BAR_LOST_WHEN_FIT_FROM_GRAPH
//virtual
bool 		WksReportOperation::isSourceHasErrBar(const TreeNode& trOp, int nDataIndex)
{
	DataRange drInput;
	GetInput(drInput);
	if(!drInput)
		return false;
	DataRange 	drOneRange;
	DWORD dwDataRules = GetDataRules(trOp);
	drInput.GetSubRange(drOneRange, dwDataRules, nDataIndex);
	if(!drOneRange.IsValid())
		return false;
	
	for(int nRange=0; nRange < drOneRange.GetNumRanges(); nRange++)
	{
		int c1, c2, r1, r2;
		Worksheet wksTemp;
		drOneRange.GetRange(nRange, r1, c1, r2, c2, wksTemp);
		for( int nCol = c1; nCol <= c2; nCol++ )
		{
			Column col(wksTemp, nCol);
			if( col && col.GetType() == OKDATAOBJ_DESIGNATION_ERROR)
				return true;
		}
	}
	return false;
}
///end ERORR_BAR_LOST_WHEN_FIT_FROM_GRAPH
*/
//virtual
bool 		WksReportOperation::isSourceHasErrBar(const TreeNode& trOp, int nDataIndex, Column* pcolErr, bool bIsXErr)
{
	DataRange drInput;
	GetInput(drInput);
	if(!drInput)
		return false;
	
	DataRange 	drOneRange;
	DWORD dwDataRules = GetDataRules(trOp);
	drInput.GetSubRange(drOneRange, dwDataRules, nDataIndex);
	if(!drOneRange.IsValid())
		return false;
	
	Tree trRange;
	drOneRange.GetTree(trRange);
	/// Iris 6/12/2010 ORG-310 FIX_NLFIT_FROM_YERR_GRAPH_BUG
	//string strTagName = bIsXErr? "EI" : "ED";	
	string strTagName;
	if( bIsXErr )
		strTagName = "EI";
	else
	{
		strTagName = "ED";
		if( !trRange.GetNode(strTagName) )
			strTagName = "W";
	}
	
	///End FIX_NLFIT_FROM_YERR_GRAPH_BUG
	TreeNode trErr = trRange.GetNode(strTagName);
	if( trErr && !trErr.IsEmpty() )
	{
		if( pcolErr )
		{
			DataRange drOneCol;
			drOneCol.Add("Range1", trErr.strVal);
			range_get_col(drOneCol, 0, *pcolErr);
		}
		return true;
	}		
	return false;
}
///end FIX_NOT_PLOT_ERR_COL_IN_LRXERR_REPORT_GRAPH_WHEN_OPEN_DLG_FROM_GRAPH

/// Iris 08/01/2007 QA70-10133 ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
//bool	WksReportOperation::PlotSourceDataInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nXIndex, int nYIndex)
bool	WksReportOperation::PlotSourceDataInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nXIndex, int nYIndex)
///end ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
{
	int nPlot;
	DataPlot dp;
	dp = GetSourceDataPlot(nDataIndex, trOp);
	string strErr = "Error in adding Input data to report graph";
	/// Hong 05/30/08 QA80-11632 FIX_SURFACE_FIT_REPORT_FIT_CURVE_FAIL_CORRECT_RESCALE
	//if(dp)
	if( dp && IsFitCurveFollowSourcePlotType() )
	/// end FIX_SURFACE_FIT_REPORT_FIT_CURVE_FAIL_CORRECT_RESCALE
	{
		GraphLayer gldp;
		dp.GetParent(gldp);
		strErr.Format("Error in adding Input data from %s into report graph %s", gldp.GetPage().GetName(), gl.GetPage().GetName());
		/// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
		//nPlot = gl.AddPlot(dp);
		nPlot = gl.AddPlot(dp, ADDPLTPFROMPLT_FAIL_IF_DATASET_ALREADY_PRESENT);
		/// Iris 12/09/2009 QA81-3224-P6 FIX_NOT_PLOT_ERR_COL_IN_LRXERR_REPORT_GRAPH_WHEN_OPEN_DLG_FROM_GRAPH
		// Here always assume error bar is the next one of main plot. And no codes to handle X Err.
		/*
		///Arvin 02/03/08 QA70-10970 ERORR_BAR_LOST_WHEN_FIT_FROM_GRAPH
		//If source graph has error bar, we need add it to report graph too.
		if(isSourceHasErrBar(trOp, nDataIndex))
		{
			int nIndex = dp.GetIndex();
			if(nIndex >= 0)
			{
				DataPlot dpErr = gldp.DataPlots(nIndex+1);
				if(dpErr)
				{
					strErr.Format("Error in adding error bar from %s into report graph %s", gldp.GetPage().GetName(), gl.GetPage().GetName());
					nPlot = gl.AddPlot(dpErr, ADDPLTPFROMPLT_FAIL_IF_DATASET_ALREADY_PRESENT);
				}
			}	
		}
		///end ERORR_BAR_LOST_WHEN_FIT_FROM_GRAPH
		*/
		Curve crv(dp);
		ASSERT(crv);	
		
		Column colYErr;
		if( isSourceHasErrBar(trOp, nDataIndex, &colYErr, false) && colYErr )
		{
			gl.AddErrBar(crv, colYErr);
		}
		
		Column colXErr;
		if( isSourceHasErrBar(trOp, nDataIndex, &colXErr, true) && colXErr )
		{
			gl.AddXErrBar(crv, colXErr);
		}
		///end FIX_NOT_PLOT_ERR_COL_IN_LRXERR_REPORT_GRAPH_WHEN_OPEN_DLG_FROM_GRAPH
		
		///Arvin 02/14/08 QA70-11094-P3 FITTED_CURVES_COLOR_FOLLOW_SOURCE_GRAPH_IF_CHECK_SET_COLOR
		//return true; // directly return here want to avoid output error info below when dataplot already present, nPlot will be negative.
		///end FITTED_CURVES_COLOR_FOLLOW_SOURCE_GRAPH_IF_CHECK_SET_COLOR
		///end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	}
	else
		///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
		//nPlot = AddWksInputDataPlot(nDataIndex, gl, trOp, trPlotInfo.SourcePlotType.nVal);
		/// Iris 08/01/2007 QA70-10133 ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
		//nPlot = AddWksInputDataPlot(nDataIndex, gl, trOp, trPlotInfo.SourcePlotType.nVal, true, nXIndex, nYIndex);
		nPlot = addWksInputDataPlot(nDataIndex, gl, trOp, nGraphIndex, trPlotInfo.SourcePlotType.nVal, true, nXIndex, nYIndex);
		///end ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
		///end MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH

	if(nPlot >= 0)
	///Arvin 02/14/08 QA70-11094-P3 FITTED_CURVES_COLOR_FOLLOW_SOURCE_GRAPH_IF_CHECK_SET_COLOR
	//	return true;
	{
		//------ Folger 03/12/08 QA80-11244 SURFACE_FIT_REPORT_SHOULD_USE_CONTOUR_PLOTS
		/*
		dp = gl.DataPlots(nPlot);
		if ( dp )
			SetupSourceDataPlot(dp, NULL, 16);
		*/
		//------
		
		legend_append_plot(gl, nPlot, "@LG");
		return true;
	}
	///end 	FITTED_CURVES_COLOR_FOLLOW_SOURCE_GRAPH_IF_CHECK_SET_COLOR
	
	return error_report(strErr);
}

// this function is simplest implementation for now
// later will construct tree and call GraphLayer::AddPlots(TreeNode& tr)
void 	WksReportOperation::setDataPlotEventHandler(DataPlot& dp, int nDataIndex)
{
	if( dp )
	{
		string strGUID;
		int nUID = GetUID(TRUE, &strGUID);
		string strHandlerUID = nUID;
		strHandlerUID += " " + strGUID + " ";
		strHandlerUID += nDataIndex;
		dp.SetEventHandler(strHandlerUID);
	}
}
//virtual 
uint	WksReportOperation::reportPlotTypeGrouppingMethod(int nPlotType)
{
	//out_int("plot type = ", nPlotType);
	if(IDM_PLOT_BOX == nPlotType)
		return RP_GROUP_ALL_PLOTS;
	return 0;
}

//virtual 
int		WksReportOperation::ReportGraphGetRescaleOption(TreeNode& trOp, int nGraphIndex)
{
	return 0;
}

/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
//virtual 
int	 WksReportOperation::GetOutputRangeIndex(TreeNode& trOp, int nGraphIndex)
{
	return -1;
}


int	WksReportOperation::GetOneSetResultCurvesID(int nOutputRangeIndex)
{
	if(OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET == nOutputRangeIndex)
		return IDST_REPORT_FITDATA_ONE_SET;
	if(OUTPUT_RESULT_CURVE_RESIDUAL_SHEET == nOutputRangeIndex)
		return IDST_REPORT_RESIDUAL_DATA_ONE_SET;
	/// Joesph/Iris 9/26/06 QA70-7120 MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
	if(OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET == nOutputRangeIndex)
		return make_one_set_ID(IDST_REPORT_CUSTOM_ONE_SET, 1);
	if(OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET == nOutputRangeIndex)
		return make_one_set_ID(IDST_REPORT_CUSTOM_ONE_SET, 2);
	/// Hong 04/10/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	if ( OUTPUT_RESULT_PEAK_CHARACTER_SHEET == nOutputRangeIndex )
		return IDST_PFM_TABLE;
	/// end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	return -1;
	///end MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
}
///end REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET

/// Iris 08/09/2007 v8.0677 FIX_FAIL_REPORT_GRAPH_PLOTS_IN_ANOVA
virtual DWORD WksReportOperation::GetReportDataRules(TreeNode &trOp, int nGraphIndex)
{
	DWORD 	dwDataRules;
	
	switch(ReportGetPlotTypeFromGraphIndex(nGraphIndex))
	{		
	case IDM_PLOT_HISTOGRAM_TYPE:
	case IDM_PLOT_BOX:
		dwDataRules = DRR_NO_FACTORS;
		break;
	
	default:
		dwDataRules = DRR_GET_DEPENDENT|DRR_NO_FACTORS;
		break;
	}
	
	return dwDataRules;
}
///end FIX_FAIL_REPORT_GRAPH_PLOTS_IN_ANOVA

///Arvin 12/05/07 QA70-10624 SUPPORT_POLAR_SWAPED
bool WksReportOperation::isPolarSwappedSourcePlot(const TreeNode& trOp, int nDataIndex)
{
	DataPlot 	dp;
	dp = GetSourceDataPlot(nDataIndex, trOp);
	if(dp)
	{
		if(dp.IsPolarSwapped())
			return true;
	}
	
	return false;
}
///end SUPPORT_POLAR_SWAPED

///Arvin 12/02/06 MR_PLOT_RESULT_TABLE
///Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
//virtual int WksReportOperation::PlotOneResultsDataRange(TreeNode& trOp, GraphLayer& gl, DataRange drTable, int nPlotType, int nGraphIndex, int nPictureIndex, int nPicColIndex)
/// Iris 08/06/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
//virtual int WksReportOperation::PlotOneResultsDataRange(TreeNode& trOp, GraphLayer& gl, DataRange drTable, int nPlotType, int nGraphIndex, int nPictureIndex, int nPicColIndex, bool bIsSourceGraph)
///Arvin 08/15/07 QA70-10212-P3 ADD_NEW_PLOT_FOR_COLUMN_TYPE_CHANGED_AND_REMOVE_REDUNDANT_PLOTS
//virtual int WksReportOperation::PlotOneResultsDataRange(TreeNode& trOp, GraphLayer& gl, DataRange drTable, int nPlotType, int nGraphIndex, int nPictureIndex, int nPicColIndex, bool bIsSourceGraph, bool bCheckIfHasPlot)
virtual int WksReportOperation::PlotOneResultsDataRange(TreeNode& trOp, GraphLayer& gl, DataRange drTable, int nPlotType, int nGraphIndex, int nPictureIndex, int nPicColIndex, bool bIsSourceGraph, bool bCheckIfHasPlot, int* pStartPlotIndex)
///end ADD_NEW_PLOT_FOR_COLUMN_TYPE_CHANGED_AND_REMOVE_REDUNDANT_PLOTS
///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
///end FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
{
	int nPlot;
	/// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT
	//if( GetReportGraphTableColNum(trOp, nGraphIndex) > 1)
	///Arvin 04/17/07 v8.0602 CAN_NOT_PLOT_SURFACE_FIT_CURVE
	//if( GetNumX(trOp) > 1 || GetNumY(trOp) > 1)
	///Sophy 12/29/2008 v8.0991b QA80-12832 SUPPORT_PLOT_CONFIDENCE_AND_PREDICTION_BANDS_FOR_MULTI_INDEPS_AND_DEPS
	//this logic only for NLFit, should move to FitNL::PlotOneResultsDataRange
	//if(!HasZ(trOp) && (GetNumX(trOp) > 1 || GetNumY(trOp) > 1))
	/////end CAN_NOT_PLOT_SURFACE_FIT_CURVE
	/////end REPORT_GRAPHS_ARRANGEMENT
	//{
		//int		nXIndex = nPicColIndex;
		/////Sophy 12/23/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
		////int		nYIndex = nPictureIndex;
		//int		nYIndex = (nPictureIndex / GetReportGraphTableColNum(trOp, nGraphIndex)) % GetNumY(trOp); //(nPicturedIndex/GetReportGraphTableColNum(trOp, nGraphIndex) is row_index, row_index%GetNumY(trOp) is a specified Y index in a specified dataset
		/////end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
		//nPlot = plot_wks_one_xy_from_data_range(drTable, gl, nPlotType, nXIndex, nYIndex, bCheckIfHasPlot);		
	//}
	//else
	//{
	///end SUPPORT_PLOT_CONFIDENCE_AND_PREDICTION_BANDS_FOR_MULTI_INDEPS_AND_DEPS
		/// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
		//uint nCntrl = GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL;
		///Arvin 08/15/07 QA70-10212-P3 ADD_NEW_PLOT_FOR_COLUMN_TYPE_CHANGED_AND_REMOVE_REDUNDANT_PLOTS
		//uint nCntrl = GAP_USE_TEMPLATE; 
		uint nCntrl = GAP_USE_TEMPLATE |  GAP_ALLOW_DUPLICATE_COL;		
		///END ADD_NEW_PLOT_FOR_COLUMN_TYPE_CHANGED_AND_REMOVE_REDUNDANT_PLOTS
		///end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
		//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
		///// Hong 10/17/08 QA80-10624 NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT
		//nCntrl |= GetPlotCtrl();
		///// end NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT
		nCntrl |= GetPlotCtrl(trOp);
		//------ End SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
		///Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
		//delete average data when FitNL with Concatenate
		int nDelCol = GetDelColNum(trOp, nGraphIndex);
		/// Iris 08/06/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
		//nPlot = plot_data_range(drTable, gl, nPlotType, nCntrl, nDelCol != -1 && bIsSourceGraph? &nDelCol : NULL);
		/// Iris 08/09/2007 v8.0677 FIX_FAIL_REPORT_GRAPH_PLOTS_IN_ANOVA
		//DWORD 	dwDataRules = GetDataRules(trOp);
		DWORD 	dwDataRules = GetReportDataRules(trOp, nGraphIndex);
		///end FIX_FAIL_REPORT_GRAPH_PLOTS_IN_ANOVA
		///Arvin 08/15/07 QA70-10212-P3 NEED_REMOVE_REDUNDANT_PLOTS
		//nPlot = plot_data_range(drTable, gl, nPlotType, nCntrl, nDelCol != -1 && bIsSourceGraph? &nDelCol : NULL, bCheckIfHasPlot, &dwDataRules);
		nPlot = plot_data_range(drTable, gl, nPlotType, nCntrl, nDelCol != -1 && bIsSourceGraph? &nDelCol : NULL, bCheckIfHasPlot, &dwDataRules, pStartPlotIndex);
		///end NEED_REMOVE_REDUNDANT_PLOTS
		///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
		//nPlot = plot_data_range(drTable, gl, nPlotType, nCntrl);
		///end FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
	//}	///Sophy 12/29/2008 v8.0991b QA80-12832 SUPPORT_PLOT_CONFIDENCE_AND_PREDICTION_BANDS_FOR_MULTI_INDEPS_AND_DEPS
	
	return nPlot;
}
///end MR_PLOT_RESULT_TABLE

///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
bool WksReportOperation::AppendLegendForAddedPlot(TreeNode& trOp, GraphLayer& gl, int nPlotIndex, LPCSTR lpcszExtraFormat, int nGraphIndex, int nPictureIndex)
{
	return legend_append_plot(gl, nPlotIndex, lpcszExtraFormat);
}
///end UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO

///Arvin 11/02/06 MR_DOES_NOT_PLOT_SORUCE_DATA
//int	WksReportOperation::PlotResultsTableInLayer(TreeNode& trOp, GraphLayer& gl, DataPlot& dp, TreeNode& trPlotInfo, int nDataIndex, int* pnPlot, int* pnNumPlots, int nGraphIndex, int nPictureIndex, int nPicColIndex)
/// YuI 04/17/07 QA70-4589 IMPROVED_ANALYSIS_MARKERS
//	virtual int	WksReportOperation::PlotResultsTableInLayer(TreeNode& trOp, GraphLayer& gl, DataPlot& dp, TreeNode& trPlotInfo, int nDataIndex, int* pnPlot, int* pnNumPlots, int nGraphIndex, int nPictureIndex, int nPicColIndex)
/// Iris 08/06/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
//virtual int	WksReportOperation::PlotResultsTableInLayer(TreeNode& trOp, GraphLayer& gl, DataPlot& dp, TreeNode& trPlotInfo, int nDataIndex, int* pnPlot, int* pnNumPlots, int nGraphIndex, int nPictureIndex, int nPicColIndex, BOOL bSourceGraph)
virtual int	WksReportOperation::plotResultsTableInLayer(TreeNode& trOp, GraphLayer& gl, DataPlot& dp, TreeNode& trPlotInfo, int nDataIndex, int* pnPlot, int* pnNumPlots, int nGraphIndex, int nPictureIndex, int nPicColIndex, BOOL bSourceGraph, bool bCheckIfHasPlot)
///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
/// end IMPROVED_ANALYSIS_MARKERS
///end MR_DOES_NOT_PLOT_SORUCE_DATA
{
 	int nResultTableID = trPlotInfo.TableID.nVal;
 	///Arvin 10/24/06 FITTING_HISTOGRAM_PLOT
 	/*
	if( nResultTableID <= 0)
		return error_report("error, PlotResultsTableInLayer found bad nResultTableID");

	vector<uint> vnTemp;
	vnTemp.Add(nResultTableID);
			
	DataRange drTable;
//---- CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
//	if(!drReport.GetSubRange(vnTemp, drTable, false) || !drTable.IsValid())
//		return error_report("error, PlotResultsTableInLayer found bad report range");
	DataRange rgFitCurvesTable;
	//---- Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
	//if(!GetResultCurvesDataRange(trOp, rgFitCurvesTable, nDataIndex, nResultTableID, GetOutputRangeIndex(trOp, nGraphIndex) ))
	if(!GetResultCurvesDataRange(trOp, rgFitCurvesTable, nDataIndex, nGraphIndex, GetOutputRangeIndex(trOp, nGraphIndex) ))
	//----
		return error_report("error, PlotResultsTableInLayer found bad report range");
	if(!rgFitCurvesTable.GetSubRange(vnTemp, drTable, false) || !drTable.IsValid())
		return error_report("error, PlotResultsTableInLayer found bad sub table range");
//----
	*/
	DataRange drTable;
	/// YuI 04/17/07 QA70-4589 IMPROVED_ANALYSIS_MARKERS
	//	if(!GetResultTableData(trOp, nResultTableID, nDataIndex, nGraphIndex, drTable))
	DataRange drFitCurvesRange;
	if(!GetResultTableData(trOp, nResultTableID, nDataIndex, nGraphIndex, drTable, drFitCurvesRange))
	/// end IMPROVED_ANALYSIS_MARKERS
		return 0;
	///end FITTING_HISTOGRAM_PLOT
	
	int nStartPlotIndex = gl.DataPlots.Count();	
	_DBINT("Before nStartPlotIndex add plots, index = ", nStartPlotIndex);	
	
	int nPlot, nNumPlots;
	/// Iris 9/12/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
	/*
	int c1, c2, r1, r2;
	Worksheet wksTemp;
	drTable.GetRange(0, r1, c1, r2, c2, wksTemp);	
	
	DataRange       dr;
	for( int nCol = c1; nCol <= c2; nCol++ )
	{
		Curve cuv;
		Column col(wksTemp, nCol);
		if( col )
		{
			string strRange;
			switch( col.GetType() )
			{
			case OKDATAOBJ_DESIGNATION_X:
				strRange = "X";
				break;
				
			case OKDATAOBJ_DESIGNATION_Y:				
				strRange = "Y";
				break;
				
			case OKDATAOBJ_DESIGNATION_ERROR:				
				strRange = "ED";				
				break;			
			}
		
			if( !strRange.IsEmpty() )
				dr.Add(wksTemp, nCol, strRange);
			
			Column colNext(wksTemp, nCol+1);
			if( OKDATAOBJ_DESIGNATION_Y == col.GetType() && colNext && OKDATAOBJ_DESIGNATION_ERROR != colNext.GetType() )
				dr.Add(); //add separator
			
			if( OKDATAOBJ_DESIGNATION_ERROR == col.GetType())
				dr.Add(); //add separator
		}
	}
	
	/// Iris 1/12/06 QA70-6581 SUPPORT_PLOT_ERR_BAR
	uint nCntrl = GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL; ///Iris 5/26/06 The default value including Group bit, but do not group added plots here since will set plot detail with the special function
	nPlot = gl.AddPlot(dr, trPlotInfo.PlotType.nVal, nCntrl);
	if( nPlot<0 )
		return error_report("Fail to add plot");
	///End SUPPORT_PLOT_ERR_BAR
	*/
	///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	/*
	uint nCntrl = GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL;
	nPlot = plot_data_range(drTable, gl, trPlotInfo.PlotType.nVal, nCntrl);
	*/
	///Arvin 12/02/06 MR_PLOT_RESULT_TABLE
	/*
	if( GetReportGraphTableColNum(trOp, nGraphIndex) > 1)
	{
		int		nXIndex = nPicColIndex;
		int		nYIndex = nPictureIndex;
		nPlot = plot_wks_one_xy_from_data_range(drTable, gl, trPlotInfo.PlotType.nVal, nXIndex, nYIndex);		
	}
	else
	{
		uint nCntrl = GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL;
		nPlot = plot_data_range(drTable, gl, trPlotInfo.PlotType.nVal, nCntrl);
	}
	*/	
	///Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
	//nPlot = PlotOneResultsDataRange(trOp, gl, drTable, trPlotInfo.PlotType.nVal, nGraphIndex, nPictureIndex, nPicColIndex);
	/// Iris 08/06/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
	//nPlot = PlotOneResultsDataRange(trOp, gl, drTable, trPlotInfo.PlotType.nVal, nGraphIndex, nPictureIndex, nPicColIndex, bSourceGraph);
	///Arvin 08/15/07 QA70-10212-P3 ADD_NEW_PLOT_FOR_COLUMN_TYPE_CHANGED_AND_REMOVE_REDUNDANT_PLOTS
	//nPlot = PlotOneResultsDataRange(trOp, gl, drTable, trPlotInfo.PlotType.nVal, nGraphIndex, nPictureIndex, nPicColIndex, bSourceGraph, bCheckIfHasPlot);
	nPlot = PlotOneResultsDataRange(trOp, gl, drTable, trPlotInfo.PlotType.nVal, nGraphIndex, nPictureIndex, nPicColIndex, bSourceGraph, bCheckIfHasPlot, &nStartPlotIndex);
	///end ADD_NEW_PLOT_FOR_COLUMN_TYPE_CHANGED_AND_REMOVE_REDUNDANT_PLOTS
	///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
	///end FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
	///end MR_PLOT_RESULT_TABLE
	///end MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	
	/// Iris 08/13/2007 v8.0680 FIX_NEW_ADDED_PLOT_ARE_RED_AFTER_CHANGE_PARAM
	// if no newly added plotting in change parameter, nPlot will be -1, but for this case, still need to do rescale since input data may be changed.
	//if( nPlot<0 )
		//return error_report("Fail to add plot");
	///end FIX_NEW_ADDED_PLOT_ARE_RED_AFTER_CHANGE_PARAM
	
	///End SURFACE_FIT_REPORT_MAT_FIT_DATA
	
	int nPlotsAdded = gl.DataPlots.Count() - nStartPlotIndex;
	/// Iris 12/08/2008 V8.0982 QA80-12737 FIX_STATS_ON_COL_BOX_PLOT_ALL_IN_ONE_GRAPH_LEGEND_NOT_LIST_ALL_PLOTS
	//if(nPlot >= 0)
	//{
		//int nLegendUpdated = 0; //----- CPY 8/7/2007 QA70-10175 SET_LEGEND_TEXT_ALSO_MIGHT_NEED_TO_TURN_OFF_AUTO_UPDATE
		/////Arvin 11/29/07 CONTROL_UPDATE_OR_NOT_UPDATE_SOURCE_GRAPH_LEGEND_BY_CHECK_BOX
		//bool bUpdateLegend = true;
		//if(bSourceGraph)
		//{
			////to check if update Legend on Original Graph
			//TreeNode trUpdateLegend = trOp.GUI.Graph1.UpdateLegend;
			//if(trUpdateLegend)
			//{
				//if(!trUpdateLegend.Enable || !trUpdateLegend.Show || 0 == trUpdateLegend.nVal)
				//{
					//bUpdateLegend = false;
				//}
			//}
		//}
		/////END CONTROL_UPDATE_OR_NOT_UPDATE_SOURCE_GRAPH_LEGEND_BY_CHECK_BOX
		//for(int index = nStartPlotIndex; index < gl.DataPlots.Count(); index++)
		//{
			//dp = gl.DataPlots(index);
			//if(dp.IsValid())
			//{
				////------ Folger 03/12/08 QA80-11244 SURFACE_FIT_REPORT_SHOULD_USE_CONTOUR_PLOTS
				///*
				//if ( nGraphIndex == GRAPH_FIT_CURVE )
					//SetupFitCurvesPlot(dp, NULL, SYSCOLOR_RED);
				//
				//else if ( nGraphIndex == GRAPH_RESIDUALS_SCATTER )
				//{
					//TreeNode trGraph = GetGUIGraphNodes(trOp, nGraphIndex);
					//double	dIrl = 5, dOrl = 30;		//hard code default value, need to define later, see SurfaceFitPreviewCtrl.h
					//if ( trGraph )
					//{
						//if ( trGraph.Irl )
							//dIrl = trGraph.Irl.dVal;
						//if ( trGraph.Orl )
							//dOrl = trGraph.Orl.dVal;
					//}						
					//SetupResidualPlot(dp, NULL, dIrl, dOrl);
				//}
				//*/
				////------ End SURFACE_FIT_REPORT_SHOULD_USE_CONTOUR_PLOTS
				//
				//setDataPlotEventHandler(dp, nDataIndex);											
				///// YuI 04/17/07 QA70-4589 IMPROVED_ANALYSIS_MARKERS
				//if( bSourceGraph )
				//{
					//drFitCurvesRange.SetPlotUID(dp.GetUID(TRUE), nDataIndex);
				//}
				///// end IMPROVED_ANALYSIS_MARKERS
			//}
			////----- CPY 8/7/2007 QA70-10175 SET_LEGEND_TEXT_ALSO_MIGHT_NEED_TO_TURN_OFF_AUTO_UPDATE
			////legend_append_plot(gl, index, "@LG");///Jasmine 08/07/07 #10175 USE_LNAME_AS_FIT_CURVE_LEGEND
			/////Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
			////if(legend_append_plot(gl, index, "@LG"))
			//
			/////Arvin 11/29/07 CONTROL_UPDATE_OR_NOT_UPDATE_SOURCE_GRAPH_LEGEND_BY_CHECK_BOX
			////if(AppendLegendForAddedPlot(trOp, gl, index, "@LG", nGraphIndex, nPictureIndex))
			///////end 	UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
			////	nLegendUpdated++;
			//if(bUpdateLegend)
			//{
				//if(AppendLegendForAddedPlot(trOp, gl, index, "@LG", nGraphIndex, nPictureIndex))
					//nLegendUpdated++;
			//}
			/////end CONTROL_UPDATE_OR_NOT_UPDATE_SOURCE_GRAPH_LEGEND_BY_CHECK_BOX
			////-----
		//}
		////----- CPY 8/7/2007 QA70-10175 SET_LEGEND_TEXT_ALSO_MIGHT_NEED_TO_TURN_OFF_AUTO_UPDATE
		//if(nLegendUpdated) //if legend has been modified in any layer, we have to set page to no auto update
		//{
			//GraphPage gp = gl.GetPage();
			//set_page_legend_auto_update(gp, false);
		//}
		////-----
	//}
	//if(NULL != pnPlot)
		//*pnPlot = nPlot;
	//if(NULL != pnNumPlots)
		//*pnNumPlots = nPlotsAdded;
	//
	//if(nPlotsAdded)
	//{		
		//uint nn = reportPlotTypeGrouppingMethod(trPlotInfo.PlotType.nVal);
		//if(nPlotsAdded > 1 && (nn & RP_GROUP_TABLE))
			//gl.GroupPlots(nStartPlotIndex);
		//
		//return (nn | RP_NEED_RESCALE);
	//}
	//
	///// Iris 08/07/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
	///// Iris 08/13/2007 v8.0680 FIX_NEW_ADDED_PLOT_ARE_RED_AFTER_CHANGE_PARAM
	///*
	//if(nPlot >=0)
	//{
		//legend_update(gl); // to remove just legend string if uncheck plot check box to remove plot in report graph		
//
		//// nPlot will be -1 and nPlotsAdded will be 0 when do recalculation since not plot again just update data for plotting. 
		//// after recalculation, need to check if data is out of axis range, so need rescale.
		//return RP_NEED_RESCALE;
	//}	
	/////end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
	//
	//return 0;
	//*/
	//
	//// legend_update will remove invalid plot and add existed plot; 
	//// but here just need to update legend to remove invalid plot, add newly added plot have done above by legend_append_plot by plot index. 
	//legend_check_remove_invalid_plot(gl.GraphObjects(GO_LEGEND_NAME));
	//
	//// nPlot will be -1 and nPlotsAdded will be 0 when do recalculation since not plot again just update data for plotting. 
	//// after recalculation, need to check if data is out of axis range, so need rescale.
	//return RP_NEED_RESCALE;
	/////end FIX_NEW_ADDED_PLOT_ARE_RED_AFTER_CHANGE_PARAM	
	if(NULL != pnPlot)
		*pnPlot = nPlot;
	if(NULL != pnNumPlots)
		*pnNumPlots = nPlotsAdded;
	return afterPlotResultCurve(trOp, gl, nDataIndex, nGraphIndex, nPictureIndex, trPlotInfo.PlotType.nVal, nStartPlotIndex, gl.DataPlots.Count()-1, bSourceGraph, &drFitCurvesRange);
	///end FIX_STATS_ON_COL_BOX_PLOT_ALL_IN_ONE_GRAPH_LEGEND_NOT_LIST_ALL_PLOTS
}

/// Iris 12/08/2008 V8.0982 QA80-12737 FIX_STATS_ON_COL_BOX_PLOT_ALL_IN_ONE_GRAPH_LEGEND_NOT_LIST_ALL_PLOTS
int WksReportOperation::afterPlotResultCurve(TreeNode& trOp, GraphLayer& gl, int nDataIndex, int nGraphIndex, int nPictureIndex, int nPlotType, int nStartPlotIndex, int nEndPlotIndex, bool bSourceGraph, DataRange* pdrFitCurvesRange)
{
	if(-1 == nEndPlotIndex)
		nEndPlotIndex = nStartPlotIndex;
	int nPlotsAdded = nEndPlotIndex - nStartPlotIndex + 1;
	
	if(nStartPlotIndex>=0)
	{
		int nLegendUpdated = 0; //----- CPY 8/7/2007 QA70-10175 SET_LEGEND_TEXT_ALSO_MIGHT_NEED_TO_TURN_OFF_AUTO_UPDATE
	
		///Arvin 11/29/07 CONTROL_UPDATE_OR_NOT_UPDATE_SOURCE_GRAPH_LEGEND_BY_CHECK_BOX
		bool bUpdateLegend = true;
		if(bSourceGraph)
		{
			//to check if update Legend on Original Graph
			TreeNode trUpdateLegend = trOp.GUI.Graph1.UpdateLegend;
			if(trUpdateLegend)
			{
				if(!trUpdateLegend.Enable || !trUpdateLegend.Show || 0 == trUpdateLegend.nVal)
				{
					bUpdateLegend = false;
				}
			}
		}
		///END CONTROL_UPDATE_OR_NOT_UPDATE_SOURCE_GRAPH_LEGEND_BY_CHECK_BOX
		
		DataPlot dp;
		for(int index = nStartPlotIndex; index < gl.DataPlots.Count(); index++)
		{
			dp = gl.DataPlots(index);
			if(dp.IsValid())
			{				
				setDataPlotEventHandler(dp, nDataIndex);											
				/// YuI 04/17/07 QA70-4589 IMPROVED_ANALYSIS_MARKERS
				if( bSourceGraph && pdrFitCurvesRange)
				{
					pdrFitCurvesRange->SetPlotUID(dp.GetUID(TRUE), nDataIndex);
				}
				/// end IMPROVED_ANALYSIS_MARKERS
			}
			//----- CPY 8/7/2007 QA70-10175 SET_LEGEND_TEXT_ALSO_MIGHT_NEED_TO_TURN_OFF_AUTO_UPDATE
			//legend_append_plot(gl, index, "@LG");///Jasmine 08/07/07 #10175 USE_LNAME_AS_FIT_CURVE_LEGEND
			///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
			//if(legend_append_plot(gl, index, "@LG"))
			
			///Arvin 11/29/07 CONTROL_UPDATE_OR_NOT_UPDATE_SOURCE_GRAPH_LEGEND_BY_CHECK_BOX
			//if(AppendLegendForAddedPlot(trOp, gl, index, "@LG", nGraphIndex, nPictureIndex))
			/////end 	UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
			//	nLegendUpdated++;
			if(bUpdateLegend)
			{
				if(AppendLegendForAddedPlot(trOp, gl, index, "@LG", nGraphIndex, nPictureIndex))
					nLegendUpdated++;
			}
			///end CONTROL_UPDATE_OR_NOT_UPDATE_SOURCE_GRAPH_LEGEND_BY_CHECK_BOX
			//-----
		}
		
		//----- CPY 8/7/2007 QA70-10175 SET_LEGEND_TEXT_ALSO_MIGHT_NEED_TO_TURN_OFF_AUTO_UPDATE
		if(nLegendUpdated) //if legend has been modified in any layer, we have to set page to no auto update
		{
			GraphPage gp = gl.GetPage();
			set_page_legend_auto_update(gp, false);
		}
		//-----	
	}	
	
	if(nPlotsAdded)
	{		
		uint nn = reportPlotTypeGrouppingMethod(nPlotType);
		if(nPlotsAdded > 1 && (nn & RP_GROUP_TABLE))
			gl.GroupPlots(nStartPlotIndex);
		
		return (nn | RP_NEED_RESCALE);
	}
	
	// legend_update will remove invalid plot and add existed plot; 
	// but here just need to update legend to remove invalid plot, add newly added plot have done above by legend_append_plot by plot index. 
	legend_check_remove_invalid_plot(gl.GraphObjects(GO_LEGEND_NAME));
	
	// nPlot will be -1 and nPlotsAdded will be 0 when do recalculation since not plot again just update data for plotting. 
	// after recalculation, need to check if data is out of axis range, so need rescale.
	return RP_NEED_RESCALE;
	///end FIX_NEW_ADDED_PLOT_ARE_RED_AFTER_CHANGE_PARAM	
}
///end FIX_STATS_ON_COL_BOX_PLOT_ALL_IN_ONE_GRAPH_LEGEND_NOT_LIST_ALL_PLOTS

///Arvin    03/08/07 SHOULD_SET_AXIS_X_FROM_TO_AND_TITLE_WHEN_USE_DATARANGE_WITH_FACTOR_TO_PLOT_HISTOGRAM
bool WksReportOperation::GetDataAndFactorValues(const TreeNode& trOp, const DataRange& dr, int nDataIndex, vector& vData, vector<string>& vstrFactors)
{
	vector<int>		vFactorSizes;
	TreeNode		trAdditionalData = tree_check_get_node(trOp,TREE_INPUTRANGE_ADDITIONAL_DATA_NODE_NAME); 
	DWORD			dwRules = GetDataRules(trOp);
	int numSubRanges;
	int nNumData = GetNumData(trOp, dr, trAdditionalData, NULL, &vFactorSizes, &numSubRanges);
	if(nDataIndex >= nNumData)
		return false;
	
	DWORD			dwPlotUID;
	int				nColOrRowIndex = dr.GetData(dwRules, nDataIndex, &dwPlotUID, NULL, &vData, NULL, NULL, &vstrFactors);
	if(nColOrRowIndex < 0)
		return false;
	
	return true;
}

bool WksReportOperation::HasFactor(const TreeNode& trOp, int nDataIndex)
{
	DataRange dr;
	GetInput(dr);
	
	vector vData;
	vector<string> vstrFactors;
	bool bGetData = GetDataAndFactorValues(trOp, dr, nDataIndex, vData, vstrFactors);
	if( bGetData && vstrFactors.GetSize() > 0 )
		return true;
	
	return false;
}
///END SHOULD_SET_AXIS_X_FROM_TO_AND_TITLE_WHEN_USE_DATARANGE_WITH_FACTOR_TO_PLOT_HISTOGRAM

/// Iris 08/07/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
///Sophy 12/24/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
//bool	WksReportOperation::checkIfPlotAgain(TreeNode& trOp, const GraphLayer& gl, int nGraphIndex, int nDataIndex, bool bIsSourceGraph)
bool	WksReportOperation::checkIfPlotAgain(TreeNode& trOp, const GraphLayer& gl, int nGraphIndex, int nPicIndex, bool bIsSourceGraph)
///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
{
	if(bIsSourceGraph)
	{
		///------ Folger 12/18/09 QA81-14860 NLFIT_RECALCULATE_FAIL_TO_GET_SOURCE_GRAPH
		/// This special fix is for PA, operation tree of NLFit can be nicely reuid in COKOCOperation::ReUIDOperationTree
		/// For PA, needs more work and change the old logic, which will not be able to fix old opj, so something ugly happens here ...
		//return hasPlottedOnSourceGraph(trOp, nGraphIndex, nPicIndex)? true : false;
		return hasPlottedOnSourceGraph(trOp, nGraphIndex, nPicIndex, TRUE)? true : false;
		///------ End NLFIT_RECALCULATE_FAIL_TO_GET_SOURCE_GRAPH
	}
	
	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trPlotAllPlots = trOp.GUI.Output.PlotSettings.PlotInOneGraph;
	TreeNode trPlotAllPlots = OP_GUI_GRAPH_ARRANGEMENT_NODE(trOp.GUI).PlotInOneGraph;
	///end OP_DLG_NEW_STRUCTURE
	
	///Arvin 02/20/08 QA70-11094-P4 DISABLE_PLOT_ALL_IN_ONE_CHECKBOX_WHEN_CHANGE_PARAM
	//if( !trPlotAllPlots || 0 == trPlotAllPlots.Show || 0 == trPlotAllPlots.Enable)
	if( !trPlotAllPlots || 0 == trPlotAllPlots.Show)
	///END DISABLE_PLOT_ALL_IN_ONE_CHECKBOX_WHEN_CHANGE_PARAM	
	{
		return hasPlottedOnReportGraph(nGraphIndex, nPicIndex)? true : false;
	}
	
#ifndef BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION
	if(IDM_PLOT_HISTOGRAM_TYPE == ReportGetPlotTypeFromGraphIndex(nGraphIndex) )
	{
		///Arvin 02/20/08 QA70-11094-P4 DISABLE_PLOT_ALL_IN_ONE_CHECKBOX_WHEN_CHANGE_PARAM
		//if( trPlotAllPlots.nVal && 1 == gl.GetPage().Layers.Count() // update unchecked to checked in Change Parameter
		//	|| 0 == trPlotAllPlots.nVal && gl.GetPage().Layers.Count() > 1 ) // update checked to unchecked
		//	return false; //not check if plotted before, always do plotting again
		if(trPlotAllPlots && gl)
		{
			if(trPlotAllPlots.nVal && 1 == gl.GetPage().Layers.Count()
				|| 0 == trPlotAllPlots.nVal && gl.GetPage().Layers.Count() > 1) // update checked to unchecked
				return false; //not check if plotted before, always do plotting again
		}
		///END DISABLE_PLOT_ALL_IN_ONE_CHECKBOX_WHEN_CHANGE_PARAM			
	}
	
	if( IDM_PLOT_BOX == ReportGetPlotTypeFromGraphIndex(nGraphIndex) )
	{
		if( trPlotAllPlots.nVal && 1 == gl.DataPlots.Count() // update unchecked to checked in Change Parameter
			|| 0 == trPlotAllPlots.nVal && gl.DataPlots.Count() > 1 ) // update checked to unchecked
		  	return false; //not check if plotted before, always do plotting again
	}
#endif //BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION

	return true;
	
}
///Sophy 12/24/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
//void	WksReportOperation::setSourceGraphIdUIDtoMap(TreeNode &trOp, int nGraphIndex, int nDataIndex, DWORD dwGraphUID)
void	WksReportOperation::setSourceGraphIdUIDtoMap(TreeNode &trOp, int nGraphIndex, int nPicIndex, DWORD dwGraphUID)
///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
{
	DWORD	dwIDValue = make_graph_IDValue_for_uid_map(nGraphIndex, nPicIndex);
	
	TreeNode	trIDMap = trOp.Operation.SourceGraphIDMap;	
	TreeNode	trUID = trOp.Operation.SourceGraphUID;
	
	vector<int> 	vnIDs;
	vector<int> 	vnUIDs;
	if(trIDMap && trUID)
	{
		vnIDs = trIDMap.nVals;
		vnUIDs = trUID.nVals;
	}
	
	vector<uint> 	vnIndex;
	int nFindNum = vnIDs.Find(vnIndex, dwIDValue);
	/// Iris 08/22/2007 FIX_DUP_FITCURVE_ON_SOURCE_GRAPH_AFTER_RECALCULATE
	//if(nFindNum < 0)
	if(nFindNum <= 0)
	///end FIX_DUP_FITCURVE_ON_SOURCE_GRAPH_AFTER_RECALCULATE
	{
		vnIDs.Add(dwIDValue);
		vnUIDs.Add(dwGraphUID);
	}
	else
	{
		ASSERT(vnIndex.GetSize() >= 1);		
		int index = vnIndex[0]; 	
		
		vnIDs[index] = dwIDValue;
		vnUIDs[index] = dwGraphUID;			
	}
	
	trOp.Operation.SourceGraphIDMap.nVals = vnIDs;
	trOp.Operation.SourceGraphUID.nVals = vnUIDs;
	
}
///Sophy 12/24/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
//bool	WksReportOperation::getSourceGraphIdUIDtoMap(TreeNode &trOp, int nGraphIndex, int nDataIndex, DWORD &dwGraphUID)
bool	WksReportOperation::getSourceGraphIdUIDtoMap(TreeNode &trOp, int nGraphIndex, int nPicIndex, DWORD &dwGraphUID)
///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
{
	DWORD	dwIDValue = make_graph_IDValue_for_uid_map(nGraphIndex, nPicIndex);
	
	TreeNode	trIDMap = trOp.Operation.SourceGraphIDMap;	
	TreeNode	trUID = trOp.Operation.SourceGraphUID;
	if(trIDMap && trUID)
	{
		vector<int> 	vnIDs;
		vector<int> 	vnUIDs;
		vnIDs = trIDMap.nVals;
		vnUIDs = trUID.nVals;
		
		vector<uint> 	vnIndex;
		int index = vnIDs.Find(vnIndex, dwIDValue);
		if(index <= 0)
			return false;
		
		if( vnUIDs.GetSize() < vnIndex[0])
			return false;
		
		dwGraphUID = vnUIDs[vnIndex[0]];		
	}
	else
		return false;
	
	return true;
}
///Sophy 12/24/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING	
//bool	WksReportOperation::hasPlottedOnSourceGraph(TreeNode &trOp, int nGraphIndex, int nDataIndex)
///------ Folger 12/18/09 QA81-14860 NLFIT_RECALCULATE_FAIL_TO_GET_SOURCE_GRAPH
//bool	WksReportOperation::hasPlottedOnSourceGraph(TreeNode &trOp, int nGraphIndex, int nPicIndex)
bool	WksReportOperation::hasPlottedOnSourceGraph(TreeNode &trOp, int nGraphIndex, int nPicIndex, BOOL bCheckUIDOnly/* = FALSE*/)
///------ End NLFIT_RECALCULATE_FAIL_TO_GET_SOURCE_GRAPH
///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
{
	DWORD 	dwGraphUID;
	if( getSourceGraphIdUIDtoMap(trOp, nGraphIndex, nPicIndex, dwGraphUID) )
	{
		///------ Folger 12/18/09 QA81-14860 NLFIT_RECALCULATE_FAIL_TO_GET_SOURCE_GRAPH
		if ( bCheckUIDOnly )
			return TRUE;
		///------ End NLFIT_RECALCULATE_FAIL_TO_GET_SOURCE_GRAPH
		GraphPage gp;
		gp = Project.GetObject(dwGraphUID);
		return gp.IsValid();
	}
	return false;
}
///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH

/// Hong 08/12/08 QA80-11986 FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
//int 	WksReportOperation::plotResultInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPictureIndex, int nPicColIndex, bool bIsSourceGraph)
//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
//int 	WksReportOperation::plotResultInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPictureIndex, int nPicColIndex, bool bIsSourceGraph, int* pnFittedPlotIndex/* = NULL*/)
int 	WksReportOperation::plotResultInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPictureIndex, int nPicColIndex, bool bIsSourceGraph, int* pnFittedPlotIndex/* = NULL*/, bool bResetGraphs/* = false*/)
//------
/// end FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
{
	DataPlot dp;
	uint nResultTableID = trPlotInfo.TableID.nVal;
	int nRet = 0;
	int nPlot, nNumPlots;
	int nPlotType = trPlotInfo.PlotType.nVal;
	
	/// YuI 08/15/06 MORE_WORK_ON_STATISTICAL_PLOTS
	// for histogram we have to enforce inc to be 0 so that
	// later on it would get recalculated properly
	///Arvin 08/28/07 QA70-10073 ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID
	//if( nPlotType == IDM_PLOT_HISTOGRAM_TYPE )
	//{
	//	Scale sc(gl.X);
	//	sc.Inc = 0;
	//}
	///end ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID
	/// end MORE_WORK_ON_STATISTICAL_PLOTS
	
	
	/// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	// In Change Parameter, will not do AddPlot below, so no need to remove report plots again
	/*
	///Cheney 2007-4-28 AFTER_REMOVE_PLOT_WILL_OUT_OF_INDEX_IF_MULTI_DATASET_AND_CHANGE_PARAM
	////---- Iris 11/10/06 PLOT_MORE_ONE_RESULT_PLOTS_AFTER_CHANGE_PARAMS
	//foreach(DataPlot dpTemp in gl.DataPlots)
	//{
		//Tree 	tr;
		//if( dpTemp.GetBinaryStorage(STR_OP_RESULT_PLOT_STORAGE, tr) )
		//{
			//if( GetUID() == tr.OperationUID.nVal && nDataIndex == tr.DataIndex.nVal )
				//gl.RemovePlot(dpTemp);
		//}
	//}
	////----
	for(int ii = 0; ii < gl.DataPlots.Count(); ii++)
	{
		Tree 	tr;
		DataPlot dpTemp = gl.DataPlots(ii);
		if( dpTemp.GetBinaryStorage(STR_OP_RESULT_PLOT_STORAGE, tr) )
		{
			if( GetUID() == tr.OperationUID.nVal && nDataIndex == tr.DataIndex.nVal )
			{
				gl.RemovePlot(dpTemp);
				ii--;
			}
		}
	}
	///end AFTER_REMOVE_PLOT_WILL_OUT_OF_INDEX_IF_MULTI_DATASET_AND_CHANGE_PARAM
	*/
	///end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	
	/// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	/// Iris 08/01/2007 QA70-10133 ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
	//TreeNode 	trPicutre = getOnePictureNode(trOp, nGraphIndex, nDataIndex);
	//bool		bIsPlotExisted = trPicutre && !trPicutre.IsEmpty();
	/// Iris 08/01/2007 QA70-10073 FIND_BETTER_WAY_TO_CHECK_IF_GRAPH_EXISTS
	//bool		bIsPlotExisted = hasPlottedReportCurve(trOp, nGraphIndex, nDataIndex);
	/// Iris 08/02/2007 v8.0673 QA70-10073 FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
	//bool		bIsPlotExisted = isReportGraphExisted(trOp, nGraphIndex, nDataIndex);
	///Sophy 12/23/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
	//bool		bHasPlottedOnReportGraph = hasPlottedOnReportGraph(nGraphIndex, nDataIndex);
	bool		bHasPlottedOnReportGraph = hasPlottedOnReportGraph(nGraphIndex, nPictureIndex);
	///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
	///end FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
	///end FIND_BETTER_WAY_TO_CHECK_IF_GRAPH_EXISTS
	///end ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
	///end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	///Sophy 12/24/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
	//bool		bHasPlottedOnSourceGraph = hasPlottedOnSourceGraph(trOp, nGraphIndex, nDataIndex); /// Iris 08/07/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
	bool		bHasPlottedOnSourceGraph = hasPlottedOnSourceGraph(trOp, nGraphIndex, nPictureIndex); /// Iris 08/07/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
	///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
	/// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	/// Iris 08/03/2007 QA70-10073 ALWAYS_REPLOT_HISTRAM_BOX_REPORT_GRAPH
	//if( !bIsPlotExisted || bIsSourceGraph )
	/// Iris 08/07/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
	/*
	if( !bIsPlotExisted || bIsSourceGraph ||
		IDM_PLOT_HISTOGRAM_TYPE == ReportGetPlotTypeFromGraphIndex(nGraphIndex) ||
		IDM_PLOT_BOX == ReportGetPlotTypeFromGraphIndex(nGraphIndex) )
	*/
	///Sophy 12/24/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
	//bool	bCheckIfHasPlotted = checkIfPlotAgain(trOp, gl, nGraphIndex, nDataIndex, bIsSourceGraph);	
	bool	bCheckIfHasPlotted = checkIfPlotAgain(trOp, gl, nGraphIndex, nPictureIndex, bIsSourceGraph);	
	///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
	///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH	
	///end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	if( nResultTableID <= 0 )
	{
		// no result table ID means the
		// plot need to be made from source data
		DataRange dr;
		GetInput(dr);
		DWORD dwRules = GetDataRules(trOp);
		string strData;
		try
		{
			///Arvin 10/26/07 RUNTIME_ERROR_WHEN_COLUMN_TYPE_IS_NOT_DOUBLE
			DataRange 	drOneRange;
			DWORD dwRulesTemp = dwRules | DRR_NO_FACTORS;
			dr.GetSubRange(drOneRange, dwRulesTemp, nDataIndex);
			if(!drOneRange.IsValid())
				return error_report("plotFitCurve gets invalid data range.");
			///end RUNTIME_ERROR_WHEN_COLUMN_TYPE_IS_NOT_DOUBLE
			
			/// Iris 08/07/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
			//if( 0 <= dr.GetData(dwRules, nDataIndex, &strData) )
			if(bCheckIfHasPlotted)
			{
				///Arvin 10/26/07 RUNTIME_ERROR_WHEN_COLUMN_TYPE_IS_NOT_DOUBLE
				//DataRange 	drOneRange; 
				/////Arvin 08/29/07 QA70-10073-P1 NOT_PLOT_HISTOGRAM_BOXCHART_AGAIN_AFTER_RECALCULATE
				////As marko said, GetSubRange method requires the bit DRR_NO_FACTORS to be passed inside
				////dwRules, since with factors it is impossible to extract subranges
				////dr.GetSubRange(drOneRange, dwRules, nDataIndex);
				//DWORD dwRulesTemp = dwRules | DRR_NO_FACTORS;
				//dr.GetSubRange(drOneRange, dwRulesTemp, nDataIndex);
				///end RUNTIME_ERROR_WHEN_COLUMN_TYPE_IS_NOT_DOUBLE
				///end NOT_PLOT_HISTOGRAM_BOXCHART_AGAIN_AFTER_RECALCULATE
				
				vector<int> vnPlotIndex; 
				if(check_has_plotted_in_graph(drOneRange, gl, vnPlotIndex) > 0 && vnPlotIndex.GetSize() > 0)
					nRet = RP_JUST_UPDATE_PLOT | RP_NEED_RESCALE;
			}
			///Arvin 10/26/07 RUNTIME_ERROR_WHEN_COLUMN_TYPE_IS_NOT_DOUBLE
			//if( 0 == nRet && 0 <= dr.GetData(dwRules, nDataIndex, &strData) )
			if( 0 == nRet )
			///end RUNTIME_ERROR_WHEN_COLUMN_TYPE_IS_NOT_DOUBLE
			///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
			{
				///Arvin 10/26/07 RUNTIME_ERROR_WHEN_COLUMN_TYPE_IS_NOT_DOUBLE
				//Curve cuv(strData);
				//if( !cuv )
				//{
				//	return error_report("plotFitCurve found curve constructed but invalid");
				//}
				//
				//if(cuv.GetUpperIndex() > 1)
				//{
				///end 	RUNTIME_ERROR_WHEN_COLUMN_TYPE_IS_NOT_DOUBLE
					/// Iris 04/05/2007 v8.0596 FIX_ONLY_ONE_BOX_CHART_EVEN_CHECK_PLOT_ALL_PLOTS_IN_ONE_GRAPH
					//nPlot = gl.AddPlot(cuv, nPlotType);
					/// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
					//uint 	dwCntrl = GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL;
					/// ML 10/1/2007 QA70-10452 NO_COLUMN_SET_AS_CATEG_OPTIONALLY_OC
					//uint 	dwCntrl = GAP_USE_TEMPLATE;
					uint 	dwCntrl = GAP_USE_TEMPLATE | GAP_DO_NOT_MAKE_CATEGORICAL;
					/// end NO_COLUMN_SET_AS_CATEG_OPTIONALLY_OC
					///end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
					///Arvin 10/26/07 RUNTIME_ERROR_WHEN_COLUMN_TYPE_IS_NOT_DOUBLE
					//nPlot = gl.AddPlot(cuv, nPlotType, dwCntrl);
					nPlot = gl.AddPlot(drOneRange, nPlotType, dwCntrl);
					///end RUNTIME_ERROR_WHEN_COLUMN_TYPE_IS_NOT_DOUBLE
					///end FIX_ONLY_ONE_BOX_CHART_EVEN_CHECK_PLOT_ALL_PLOTS_IN_ONE_GRAPH
					
					/// Iris 12/08/2008 V8.0982 QA80-12737 QA80-12737 FIX_STATS_ON_COL_BOX_PLOT_ALL_IN_ONE_GRAPH_LEGEND_NOT_LIST_ALL_PLOTS	
					/*
					int nPlotRetInfo = reportPlotTypeGrouppingMethod(nPlotType) | RP_NEED_RESCALE;
					if(nPlot >= 0)
					{
						dp = gl.DataPlots(nPlot);
						setDataPlotEventHandler(dp, nDataIndex);
						nRet = dp.IsValid()?  nPlotRetInfo: 0;
					}	
					*/
					if(nPlot >= 0)
					{
						int nNumPlots = drOneRange.GetNumData(GetDataRules(trOp));
						nRet = afterPlotResultCurve(trOp, gl, nDataIndex, nGraphIndex, nPictureIndex, nPlotType, nPlot, nPlot+nNumPlots-1);
					}
					///end FIX_STATS_ON_COL_BOX_PLOT_ALL_IN_ONE_GRAPH_LEGEND_NOT_LIST_ALL_PLOTS					
				//}///Arvin 10/26/07 RUNTIME_ERROR_WHEN_COLUMN_TYPE_IS_NOT_DOUBLE
			}
		}
		catch(int nErr)
		{
			nRet = 0;
			error_report("error");
		}
	}
	else
	{
		/// YuI 04/17/07 QA70-4589 IMPROVED_ANALYSIS_MARKERS
		//	nRet = PlotResultsTableInLayer(trOp, gl, dp, trPlotInfo, nDataIndex, &nPlot, &nNumPlots, nGraphIndex, nPictureIndex, nPicColIndex);
		/// Iris 08/07/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
		//nRet = PlotResultsTableInLayer(trOp, gl, dp, trPlotInfo, nDataIndex, &nPlot, &nNumPlots, nGraphIndex, nPictureIndex, nPicColIndex, bIsSourceGraph);
		nRet = plotResultsTableInLayer(trOp, gl, dp, trPlotInfo, nDataIndex, &nPlot, &nNumPlots, nGraphIndex, nPictureIndex, nPicColIndex, bIsSourceGraph, bCheckIfHasPlotted);
		///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
		/// end IMPROVED_ANALYSIS_MARKERS
		
	}	
	/// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	/// Iris 08/07/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
	//else
	//	nRet = RP_NEED_RESCALE; //if plot successfully, will always contain this bit, so assign it as default to avoid nRet is 0. If nRet is 0 will effect return value of this function to say fail to plot.
	///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
	///end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH	
	
	if(nRet)
	{
		/// Iris 08/07/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
		if(bIsSourceGraph && !bHasPlottedOnSourceGraph)
		{
			///Sophy 12/24/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
			//setSourceGraphIdUIDtoMap(trOp, nGraphIndex, nDataIndex, gl.GetPage().GetUID(true));
			setSourceGraphIdUIDtoMap(trOp, nGraphIndex, nPictureIndex, gl.GetPage().GetUID(true));
			///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
		}
		///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
		
		/// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
		/// Iris 08/03/2007 QA70-10073 ALWAYS_REPLOT_HISTRAM_BOX_REPORT_GRAPH
		//if(!bIsPlotExisted || bIsSourceGraph)
		/// Iris 08/07/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
		/*
		if(!bIsPlotExisted || bIsSourceGraph ||
			IDM_PLOT_HISTOGRAM_TYPE == ReportGetPlotTypeFromGraphIndex(nGraphIndex) ||
			IDM_PLOT_BOX == ReportGetPlotTypeFromGraphIndex(nGraphIndex) )
		*/
		
		/// Iris 08/13/2007 v8.0680 FIX_NEW_ADDED_PLOT_ARE_RED_AFTER_CHANGE_PARAM
		/*
		if( bIsSourceGraph && !bHasPlottedOnSourceGraph || !bIsSourceGraph && !bHasPlottedOnReportGraph)
		///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
		///end ALWAYS_REPLOT_HISTRAM_BOX_REPORT_GRAPH
		///end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
			SetupPlotDetails(trOp, gl, nPlot, nNumPlots, nGraphIndex, nDataIndex, bIsSourceGraph);
		/// Iris 08/08/2007 v8.0677 COPY_FROM_SOURCE_GRAPH_ONLY_WHEN_FIRSTLY_CREATE_REPORT
		else
			nRet |= RP_JUST_UPDATE_PLOT;
		*/
		bool	bUpdateExistedReportGraph = true;
		//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
		//if( bIsSourceGraph && !bHasPlottedOnSourceGraph || !bIsSourceGraph && !bHasPlottedOnReportGraph)
		if( bResetGraphs || bIsSourceGraph && !bHasPlottedOnSourceGraph || !bIsSourceGraph && !bHasPlottedOnReportGraph)
		//------
			bUpdateExistedReportGraph = false; //create new report graph or plot all again
		else
			nRet |= RP_JUST_UPDATE_PLOT;
		
		/// Hong 03/01/10 QA80-10136 GROUP_FITTED_CURVE_IN_SRC_GRAPH_AS_SRC_PLOT
	#ifdef		__FITTED_CURVE_SUPPORT_GROUP_AS_SRC__
		setupDataPlotGroup(trOp, gl, nPlot, nDataIndex);
	#endif		//__FITTED_CURVE_SUPPORT_GROUP_AS_SRC__
		/// end GROUP_FITTED_CURVE_IN_SRC_GRAPH_AS_SRC_PLOT
		
		
		SetupPlotDetails(trOp, gl, nPlot, nNumPlots, nGraphIndex, nDataIndex, bIsSourceGraph, bUpdateExistedReportGraph);
		///end FIX_NEW_ADDED_PLOT_ARE_RED_AFTER_CHANGE_PARAM
		///end COPY_FROM_SOURCE_GRAPH_ONLY_WHEN_FIRSTLY_CREATE_REPORT
		/// Hong 08/12/08 QA80-11986 FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
		if ( pnFittedPlotIndex )
		{
			*pnFittedPlotIndex = nPlot; //? is this the first/last plot
		}
		/// end FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
	}	
			
	return nRet;
}

/// Hong 03/01/10 QA80-10136 GROUP_FITTED_CURVE_IN_SRC_GRAPH_AS_SRC_PLOT
#ifdef		__FITTED_CURVE_SUPPORT_GROUP_AS_SRC__
void	WksReportOperation::initGroupPlotAndIndex()
{
	m_nFirstPlotIndexInGroup = -1;
	m_nFirstFittedPlot = -1;
}

bool	WksReportOperation::setupDataPlotGroup(const TreeNode& trOp, GraphLayer& gl, int nFittedPlot, int nDataIndex)
{
	DataPlot 		dpSrc = GetSourceDataPlot(nDataIndex, trOp);
	if ( !dpSrc )
		return false;
	
	GraphLayer		glSrc;
	dpSrc.GetParent(glSrc);
	if ( glSrc != gl )
		return false;
	
	int				nIndex;
	GroupPlot		grpplt = dpSrc.GetGroupPlot(&nIndex);
	if ( !grpplt )
	{
		initGroupPlotAndIndex();
		return false;
	}
	
	if ( -1 == m_nFirstPlotIndexInGroup )
	{
		DataPlot		dp = grpplt.GetDataPlot(0);
		m_nFirstPlotIndexInGroup = dp.GetIndex();
	}
	else
	{
		DataPlot		dp = grpplt.GetDataPlot(0);
		if ( m_nFirstPlotIndexInGroup != dp.GetIndex() )
		{
			initGroupPlotAndIndex();
			m_nFirstPlotIndexInGroup = dp.GetIndex();
		}
	}

	if ( -1 == m_nFirstFittedPlot )
		m_nFirstFittedPlot = nFittedPlot;
	else
	{
		gl.GroupPlots(m_nFirstFittedPlot, nFittedPlot);
		return true;
	}

	return false;
}
#endif		//__FITTED_CURVE_SUPPORT_GROUP_AS_SRC__
/// end GROUP_FITTED_CURVE_IN_SRC_GRAPH_AS_SRC_PLOT

bool WksReportOperation::SetupPlotDetails(const TreeNode& trOp, GraphLayer& gl, int nFittedPlot, int nNumPlots, int nGraphIndex, int nDataIndex, bool bIsSourceGraph, bool bUpdateExistedReportGraph)
{
	if( !gl )
		return false;
	
	/// Iris 10/16/2009 QA80-14484 BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION
#ifdef BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION
	// Since not always LoadTemplate for Histogram graph to keep customization settings, before rescale need to cancel linkto property,
	// or less Recale dependent on linked parent layer, will get bad rescale result.
	if( ReportGetPlotTypeFromGraphIndex(nGraphIndex) == IDM_PLOT_HISTOGRAM_TYPE )
	{
		int nParentLinkLayerIndex = 0;
		if( gl.GetIndex() != nParentLinkLayerIndex )
		{
			/// Folger 11/05/09 Must use FindFunction here to avoid linking error
			//layer_set_link(gl, nParentLinkLayerIndex);
			FUNC_LAYER_SET_LINK		pfn = Project.FindFunction("layer_set_link", "OriginLab\\Graph_utils", TRUE);
			if ( pfn )
			{
				pfn(gl, nParentLinkLayerIndex);
			}
		}			
	}
#endif //BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION
	///end BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION
	
	/// Iris 10/16/2009 QA80-14482 FIX_TICK_LABEL_OVERLAPPED_WHEN_PLOT_MULTI_IN_ONE_GRAPH
	// Fix if plot too many in one graph, x axes tick label will be overlapped.
	if( IsPlotAllPlotsInOneGraph(trOp) && ReportGetPlotTypeFromGraphIndex(nGraphIndex) == IDM_PLOT_BOX && gl.DataPlots.Count() > 6 )
	{
		/// Iris 11/05/2009 QA81-14599 FIX_STATS_ON_COLS_PLOT_REPORT_GRAPHS_VERY_SLOW
		/*
		Tree trFormat;
		trFormat = gl.GetFormat(FPB_ALL, FOB_ALL, true, true);
		//if( 0 == trFormat.Root.Axes.X.Labels.BottomLabels.Angle.nVal )
		TreeNode	trAngle = trFormat.Root.Axes.X.Labels.BottomLabels.Angle;
		if ( trAngle && 0 == trAngle.nVal )
		{
			//trFormat.Root.Axes.X.Labels.BottomLabels.Angle.nVal = 45;
			trAngle.nVal = 45;
			gl.ApplyFormat(trFormat, true, true);
		}
		*/
		if( nFittedPlot == GetNumPlotsInOneGraph(trOp, nGraphIndex) - 1 ) // the last plot
		{
			Tree trFormat;
			trFormat.Root.Axes.X.Labels.BottomLabels.Angle.nVal = 45;
			/// Iris 11/10/2009 QA81-14482-P2 SET_BOX_PLOT_TICK_LABEL_POSITION_BY_CODE_REPLACE_TEMPLATE
			// rotate tick label cause tick label a little far from X axis, so adjust position.
			trFormat.Root.Axes.X.Labels.BottomLabels.YOffset.nVal = 40;
			///end SET_BOX_PLOT_TICK_LABEL_POSITION_BY_CODE_REPLACE_TEMPLATE
			if( 0 == gl.UpdateThemeIDs(trFormat.Root) )
			{
				gl.ApplyFormat(trFormat, true, true);
			}	
		}
		///end FIX_STATS_ON_COLS_PLOT_REPORT_GRAPHS_VERY_SLOW
	}
	///end FIX_TICK_LABEL_OVERLAPPED_WHEN_PLOT_MULTI_IN_ONE_GRAPH
	
	//---- Iris 11/10/06 PLOT_MORE_ONE_RESULT_PLOTS_AFTER_CHANGE_PARAMS
	Tree 	trTemp;
	trTemp.OperationUID.nVal = GetUID(true);
	trTemp.DataIndex.nVal = nDataIndex;
	
	for(int nPlot = 0; nPlot < nNumPlots; nPlot++)
	{
		DataPlot dp = gl.DataPlots(nPlot + nFittedPlot);
		if(dp)
			dp.PutBinaryStorage(STR_OP_RESULT_PLOT_STORAGE, trTemp);
	}
	return true;
	//---- 
	
}
	
bool WksReportOperation::insertUpdateLabelToReportGraph(TreeNode& trOp, GraphLayer& gl, const string& strLabel, LPCSTR lpcszName)// = NULL);
{
	string strName = lpcszName;
	if(strName.IsEmpty())
		strName = GetClassName();
	return page_insert_label(gl, strLabel, strName);
}

///Iris 4/01/05 ADD_GRAPH_INDEX
//bool 	WksReportOperation::IsSourceDataPlotInReport()
bool 	WksReportOperation::IsSourceDataPlotInReport(int nGraphIndex)
{
	return false;
}

///Iris 4/01/05 ADD_GRAPH_INDEX
//bool 	WksReportOperation::IsResultsPlotInReport()
bool 	WksReportOperation::IsResultsPlotInReport(int nGraphIndex)
{
	return true;
}

/// Iris 08/13/2007 v8.0680 QA70-10212-P2 FAIL_TO_REMOVE_ORIGINAL_SOURCE_DATAPLOT
bool	WksReportOperation::isSourceDataPlot(DataPlot &dp)
{
	if(dp)
	{	
		string str = dp.GetEventHandler();
		return str.IsEmpty()? true : false;
	}
	return false;
}

/// Hong 11/15/08 QA80-12584 v8.0972 SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
//void	WksReportOperation::beforePlotReportGraph(TreeNode& trOp, GraphLayer &gl)
void	WksReportOperation::beforePlotReportGraph(TreeNode& trOp, GraphLayer &gl, int nDataIndex)
/// end SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
{
	//in change parameter might change data, so need to remove the original source data plot before plotting new source data	
	DataRange		drInput;
	if ( GetInput(drInput) )
	{
		/// Hong 11/15/08 QA80-12584 v8.0972 SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
		///Sophy 3/5/2009 QA80-12584 v8.0992 FIX_LOSE_SOURCE_CURVE_WHEN_FIT_FROM_GRAPH_ARRANGE_SAME_PLOTS_ON_ONE_GRAPH
		//Sophy, this logic is only for pa, so virtual it and implemented in FitPeak.h/cpp
		//DataPlot		dpSrc = GetSourceDataPlot(nDataIndex, trOp);		
		//if ( dpSrc )
		//{ //Hong, we allow using fit source dataplot instead of raw source dataplot in report graph, can refer to CheckReplaceSourceDataPlot
			//DataRange		drSrc;
			//if ( dpSrc.GetDataRange(drSrc) )
				//drInput = drSrc;
		//}
		CheckReplaceSourceRange(trOp, drInput, nDataIndex);
		///end FIX_LOSE_SOURCE_CURVE_WHEN_FIT_FROM_GRAPH_ARRANGE_SAME_PLOTS_ON_ONE_GRAPH
		/// end SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
	
		int nOriginalDataPlot = -1;
		foreach(DataPlot dp in gl.DataPlots)
		{
			if( isSourceDataPlot(dp) )
			{			
				///Sophy 12/23/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
				//if( !check_plot_in_range(drInput, dp, GetDataRules(trOp)) )
					//nOriginalDataPlot = dp.GetIndex();	
				DWORD dwDataRules = GetDataRules(trOp);
				FilterDataRulesForPlot(dwDataRules);
				
				/// Hong 03/25/09 QA80-12551 RESET_PLOT_ROW_RANGE_IF_USER_UPDATE_INPUT_DATARANGE_WHEN_CHANGE_PARAMETER
				//if ( !check_plot_in_range(drInput, dp, dwDataRules) )
				if ( !check_plot_in_range(drInput, dp, dwDataRules, NTYPE_BOOKSHEET_XY_RANGE) )
				/// end RESET_PLOT_ROW_RANGE_IF_USER_UPDATE_INPUT_DATARANGE_WHEN_CHANGE_PARAMETER
					nOriginalDataPlot = dp.GetIndex();
				///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
			}
		}
		if(nOriginalDataPlot >= 0)
			gl.RemovePlot(nOriginalDataPlot);
	}
	else
		error_report("fail to get input data range in beforePlotReportGraph");
	
}
///end FAIL_TO_REMOVE_ORIGINAL_SOURCE_DATAPLOT

/// Hong 08/12/08 QA80-11986 FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
//int 	WksReportOperation::plotReportGraph(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPictureIndex, int nPicColIndex)
//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
//int 	WksReportOperation::plotReportGraph(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPictureIndex, int nPicColIndex, int* pnFittedPlotIndex/* = NULL*/)
int 	WksReportOperation::plotReportGraph(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPictureIndex, int nPicColIndex, int* pnFittedPlotIndex/* = NULL*/, bool bResetGraphs/* = false*/)
//------
/// end FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
{
	/// Hong 11/15/08 QA80-12584 v8.0972 SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
	//beforePlotReportGraph(trOp, gl); /// Iris 08/13/2007 v8.0680 QA70-10212-P2 FAIL_TO_REMOVE_ORIGINAL_SOURCE_DATAPLOT
	beforePlotReportGraph(trOp, gl, nDataIndex);
	/// end SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
	
	int nRet = 0;
	if( trPlotInfo.SourcePlotType.IsValid() )
	{
		//nRet = PlotSourceDataInLayer(nDataIndex, trPlotInfo, trOp, gl)? RP_NEED_RESCALE : 0;
		int nXIndex = nPicColIndex;
		
		///Sophy 12/23/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
		//int nYIndex = nPictureIndex;
		int nYIndex = (nPictureIndex / GetReportGraphTableColNum(trOp, nGraphIndex)) % GetNumY(trOp);
		///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
		/// Iris 08/01/2007 QA70-10133 ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
		//nRet = PlotSourceDataInLayer(nDataIndex, trPlotInfo, trOp, gl, nXIndex, nYIndex)? RP_NEED_RESCALE : 0;
		nRet = PlotSourceDataInLayer(nDataIndex, trPlotInfo, trOp, gl, nGraphIndex, nXIndex, nYIndex)? RP_NEED_RESCALE : 0;
		///end ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
	}
		
	if( trPlotInfo.PlotType.IsValid() )
		/// Hong 08/12/08 QA80-11986 FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
		//nRet = plotResultInLayer(nDataIndex, trPlotInfo, trOp, gl, nGraphIndex, nPictureIndex, nPicColIndex) | nRet;	
		//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
		//nRet = plotResultInLayer(nDataIndex, trPlotInfo, trOp, gl, nGraphIndex, nPictureIndex, nPicColIndex, false, pnFittedPlotIndex) | nRet;
		nRet = plotResultInLayer(nDataIndex, trPlotInfo, trOp, gl, nGraphIndex, nPictureIndex, nPicColIndex, false, pnFittedPlotIndex, bResetGraphs) | nRet;
		//------
		/// end FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
			
	return nRet;
}

///Arvin 11/09/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
/// Hong 08/12/08 QA80-11986 FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
//void 	WksReportOperation::RescaleReportGraph(TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPicRowIndex, int nPicColIndex)
void 	WksReportOperation::RescaleReportGraph(TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPicRowIndex, int nPicColIndex, int nFirstFittedPlotIndex)
/// end FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
{
	/// Iris 11/21/06 CORRECT_SPAN_AXIS_AS_FITX_WHEN_GET_INPUT_FROM_WKS
	//gl.Rescale();
	int nRescaleOption = ReportGraphGetRescaleOption(trOp, nGraphIndex);
	///Arvin    03/08/07 SHOULD_NOT_RESCALE_IF_NOT_PLOT_ALL_HISTOGRAMS_IN_ONE_GRAPH_WHEN_HAS_FACTOR by max's suggestion
	//gl.Rescale(nRescaleOption);
	if(nRescaleOption >= 0)
	{
		/// Iris 07/31/2007 QA70-10133 CHECK_DO_RESCALE_IF_DATA_OUTSIDE
		//gl.Rescale(nRescaleOption);
		/// Iris 08/01/2007 QA70-10133 ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
		/// Iris 08/01/2007 QA70-10073 FIND_BETTER_WAY_TO_CHECK_IF_GRAPH_EXISTS
		//if( hasPlottedReportCurve(trOp, nGraphIndex, nDataIndex) )
		/// Iris 08/02/2007 v8.0673 QA70-10073 FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
		//if( isReportGraphExisted(nGraphIndex, nPicRowIndex, nPicColIndex) )
		
		///Sophy 12/24/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
		//int nDataIndex = nPicRowIndex * GetReportGraphTableColNum(trOp, nGraphIndex) + nPicColIndex;
		///// Iris 08/03/2007 QA70-10073 ALWAYS_REPLOT_HISTRAM_BOX_REPORT_GRAPH
		////if( isReportGraphExisted(nGraphIndex, nDataIndex) )
		/////Arvin 08/28/07 QA70-10073 ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID as max said
		////if( hasPlottedOnReportGraph(nGraphIndex, nDataIndex) &&
		////		(IDM_PLOT_HISTOGRAM_TYPE != ReportGetPlotTypeFromGraphIndex(nGraphIndex) &&
		////		IDM_PLOT_BOX != ReportGetPlotTypeFromGraphIndex(nGraphIndex) ) )
		//if( hasPlottedOnReportGraph(nGraphIndex, nDataIndex) &&
			//((IDM_PLOT_HISTOGRAM_TYPE != ReportGetPlotTypeFromGraphIndex(nGraphIndex) && 
			 //IDM_PLOT_BOX != ReportGetPlotTypeFromGraphIndex(nGraphIndex)) || !isTreeNodePlotInOneGraphValid(trOp)) )
		/////end ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID
		/////end ALWAYS_REPLOT_HISTRAM_BOX_REPORT_GRAPH
		/////end FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
		/////end FIND_BETTER_WAY_TO_CHECK_IF_GRAPH_EXISTS
			//nRescaleOption |= ANL_CHK_DATA_OUTSIDE;
		/////end ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
		int nPictureIndex = nPicRowIndex * GetReportGraphTableColNum(trOp, nGraphIndex) + nPicColIndex;
		if( hasPlottedOnReportGraph(nGraphIndex, nPictureIndex) &&
			((IDM_PLOT_HISTOGRAM_TYPE != ReportGetPlotTypeFromGraphIndex(nGraphIndex) && 
			 IDM_PLOT_BOX != ReportGetPlotTypeFromGraphIndex(nGraphIndex)) || !isTreeNodePlotInOneGraphValid(trOp)) )
			nRescaleOption |= ANL_CHK_DATA_OUTSIDE;
		///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
		int 	nOutcome;
		gl.Rescale(nRescaleOption, &nOutcome);
		///end CHECK_DO_RESCALE_IF_DATA_OUTSIDE
	}
	///end SHOULD_NOT_RESCALE_WHEN_NOT_PLOT_ALL_PLOTS_IN_ONE_GRAPH
	//end CORRECT_SPAN_AXIS_AS_FITX_WHEN_GET_INPUT_FROM_WKS
}
///end NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT

//bool		WksReportOperation::PlotReportGraphs(TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex)  ///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
//bool		WksReportOperation::plotReportGraphs(TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPicRowIndex, int nPicColIndex)
bool		WksReportOperation::plotReportGraphs(TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPicRowIndex, int nPicColIndex, bool bResetGraphs/* = false*/)
//------
{
	if( !trPlotInfo )
		return FALSE;
	
	/// Hong 03/01/10 QA80-10136 GROUP_FITTED_CURVE_IN_SRC_GRAPH_AS_SRC_PLOT
#ifdef		__FITTED_CURVE_SUPPORT_GROUP_AS_SRC__
	initGroupPlotAndIndex();
#endif		//__FITTED_CURVE_SUPPORT_GROUP_AS_SRC__

	int nRet = 0;
	int nIndexBegin = trPlotInfo.DataIndex.From.nVal;
	int nIndexEnd = trPlotInfo.DataIndex.To.nVal;
	/// Hong 08/12/08 QA80-11986 FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
	int		nFirstFittedPlotIndex = -1;
	bool	bFirstFittedPlot = true;
	/// end FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
	int nPictureIndex = nPicRowIndex * GetReportGraphTableColNum(trOp, nGraphIndex) + nPicColIndex;		///Sophy 1/19/2009 v8.0959 CENTRALIZE_CODE_OF_GET_PIC_INDEX
	for( int nDataIndex = nIndexBegin; nDataIndex <= nIndexEnd; nDataIndex++ )
	{
		///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
		//nRet = PlotReportGraph(nDataIndex, trPlotInfo, trOp, gl, nGraphIndex) | nRet;
		/// Hong 08/12/08 QA80-11986 FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
		//nRet = plotReportGraph(nDataIndex, trPlotInfo, trOp, gl, nGraphIndex, nPicRowIndex, nPicColIndex) | nRet;
		int		nFittedPlotIndex = -1;
		//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
		//nRet = plotReportGraph(nDataIndex, trPlotInfo, trOp, gl, nGraphIndex, nPicRowIndex, nPicColIndex, &nFittedPlotIndex) | nRet;
		///Sophy 12/23/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
		//nRet = plotReportGraph(nDataIndex, trPlotInfo, trOp, gl, nGraphIndex, nPicRowIndex, nPicColIndex, &nFittedPlotIndex, bResetGraphs) | nRet;
		//int nPictureIndex = nPicRowIndex * GetReportGraphTableColNum(trOp, nGraphIndex) + nPicColIndex;		///Sophy 1/19/2009 v8.0959 CENTRALIZE_CODE_OF_GET_PIC_INDEX
		nRet = plotReportGraph(nDataIndex, trPlotInfo, trOp, gl, nGraphIndex, nPictureIndex, nPicColIndex, &nFittedPlotIndex, bResetGraphs) | nRet;
		///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
		//------
		if ( bFirstFittedPlot )
		{
			nFirstFittedPlotIndex = nFittedPlotIndex;
			bFirstFittedPlot = false;
		}
		/// end FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
		///end MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	}
	/// Iris 08/06/2007 v8.0674 ALWAYS_COPY_SOURCE_GRAPH_AXIS_TYPE, from Ryan's mail
	//TreeNode	trXDataType = trOp.GUI.Graph1.XDataType;
	//if( nRet && GRAPH_FIT_CURVE == nGraphIndex && trXDataType && FIT_CURVE_SAME_AS_DATA == trXDataType.Use)
	if( nRet && GRAPH_FIT_CURVE == nGraphIndex )
	///end ALWAYS_COPY_SOURCE_GRAPH_AXIS_TYPE
	{
		/// Iris 08/08/2007 v8.0677 COPY_FROM_SOURCE_GRAPH_ONLY_WHEN_FIRSTLY_CREATE_REPORT
		if( nRet & RP_JUST_UPDATE_PLOT)
		{
			//do nothing...
		}
		else
		{
		///end COPY_FROM_SOURCE_GRAPH_ONLY_WHEN_FIRSTLY_CREATE_REPORT
			/// Iris 01/26/2007 v8.0548 REPORT_GRAPH_X_AXIS_TYPE_SAME_AS_SOURCE_GRAPH
			//int nPicIndex = nPicRowIndex * GetReportGraphTableColNum(trOp, nGraphIndex) + nPicColIndex;///Sophy 1/19/2009 v8.0959 CENTRALIZE_CODE_OF_GET_PIC_INDEX
			setFormatFromSourceGraphToReport(trOp, gl, nGraphIndex, nPictureIndex);
			///end REPORT_GRAPH_X_AXIS_TYPE_SAME_AS_SOURCE_GRAPH
		} 
	}
	
	if( nRet & RP_GROUP_ALL_PLOTS)
		gl.GroupPlots(0);
	
	if( nRet & RP_NEED_RESCALE )
	{
		///Arvin 11/09/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
		/*
		/// Iris 11/21/06 CORRECT_SPAN_AXIS_AS_FITX_WHEN_GET_INPUT_FROM_WKS
		//gl.Rescale();
		int nRescaleOption = ReportGraphGetRescaleOption(trOp, nGraphIndex);
		///Arvin    03/08/07 SHOULD_NOT_RESCALE_IF_NOT_PLOT_ALL_HISTOGRAMS_IN_ONE_GRAPH_WHEN_HAS_FACTOR by max's suggestion
		//gl.Rescale(nRescaleOption);
		if(nRescaleOption >= 0)
		{
			/// Iris 07/31/2007 QA70-10133 CHECK_DO_RESCALE_IF_DATA_OUTSIDE
			//gl.Rescale(nRescaleOption);
			/// Iris 08/01/2007 QA70-10133 ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
			/// Iris 08/01/2007 QA70-10073 FIND_BETTER_WAY_TO_CHECK_IF_GRAPH_EXISTS
			//if( hasPlottedReportCurve(trOp, nGraphIndex, nDataIndex) )
			/// Iris 08/02/2007 v8.0673 QA70-10073 FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
			//if( isReportGraphExisted(nGraphIndex, nPicRowIndex, nPicColIndex) )
			int nDataIndex = nPicRowIndex * GetReportGraphTableColNum(trOp, nGraphIndex) + nPicColIndex;
			/// Iris 08/03/2007 QA70-10073 ALWAYS_REPLOT_HISTRAM_BOX_REPORT_GRAPH
			//if( isReportGraphExisted(nGraphIndex, nDataIndex) )
			///Arvin 08/28/07 QA70-10073 ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID as max said
			//if( hasPlottedOnReportGraph(nGraphIndex, nDataIndex) &&
			//		(IDM_PLOT_HISTOGRAM_TYPE != ReportGetPlotTypeFromGraphIndex(nGraphIndex) &&
			//		IDM_PLOT_BOX != ReportGetPlotTypeFromGraphIndex(nGraphIndex) ) )
			if( hasPlottedOnReportGraph(nGraphIndex, nDataIndex) &&
					((IDM_PLOT_HISTOGRAM_TYPE != ReportGetPlotTypeFromGraphIndex(nGraphIndex) && 
					  IDM_PLOT_BOX != ReportGetPlotTypeFromGraphIndex(nGraphIndex)) || !IsTreeNodePlotInOneGraphValid(trOp)) )
			///end ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID
			///end ALWAYS_REPLOT_HISTRAM_BOX_REPORT_GRAPH
			///end FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
			///end FIND_BETTER_WAY_TO_CHECK_IF_GRAPH_EXISTS
				nRescaleOption |= ANL_CHK_DATA_OUTSIDE;
			///end ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
			int 	nOutcome;
			gl.Rescale(nRescaleOption, &nOutcome);
			///end CHECK_DO_RESCALE_IF_DATA_OUTSIDE
		}
		///end SHOULD_NOT_RESCALE_WHEN_NOT_PLOT_ALL_PLOTS_IN_ONE_GRAPH
		//end CORRECT_SPAN_AXIS_AS_FITX_WHEN_GET_INPUT_FROM_WKS
		*/
		/// Hong 08/12/08 QA80-11986 FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
		//RescaleReportGraph(trOp, gl, nGraphIndex, nPicRowIndex, nPicColIndex);
		RescaleReportGraph(trOp, gl, nGraphIndex, nPicRowIndex, nPicColIndex, nFirstFittedPlotIndex);
		/// end FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
		///end NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
	}
	
	//------ Folger 03/12/08 QA80-11244 SURFACE_FIT_REPORT_SHOULD_USE_CONTOUR_PLOTS
	///Kyle 04/27/2009 QA80-13488 KEEP_CUSTOMIZE_COLOR_WHEN_CHANGE_PARAMETER_IN_SURFACE_FIT
	if( bResetGraphs || !hasPlottedOnReportGraph(nGraphIndex, nPictureIndex) )
	///End KEEP_CUSTOMIZE_COLOR_WHEN_CHANGE_PARAMETER_IN_SURFACE_FIT
		SetupPlotsAfterRescale(gl, nGraphIndex);
	/// Iris 7/29/2009 QA80-14029 FAIL_CHANGE_INNER_OUTTER_RESIDUAL_LIMIT_ON_CHANGE_PARAM
	else
		SetupPlotsOnRecalculate(gl, nGraphIndex);
	///end FAIL_CHANGE_INNER_OUTTER_RESIDUAL_LIMIT_ON_CHANGE_PARAM
	//------
	
	return nRet? true:false;
}
/// end MULTIPLE_PLOTS_OF_SAME_SERIES_IN_SAME_FRAME

/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
/*
bool	WksReportOperation::addOneGraphPicture(int nCreateType, TreeNode& trOp, TreeNode& trImage, int nGraphIndex, int nPictureIndex, int nTotalNumData, Worksheet& wksData, DataRange& rReport)
{
	int nMinDataIndex = 0;
	int nMaxDataIndex = -1;
	string strDataIndexRange;
	if( trImage.GetAttribute(STR_DATA_INDEX_RANGE_PICUTRE_ATTRIBUTE, strDataIndexRange) )
	{
		string strTemp = strDataIndexRange.GetToken(0);
		nMinDataIndex = atoi(strTemp);
		strTemp = strDataIndexRange.GetToken(1);
		nMaxDataIndex = atoi(strTemp);
	}

	BOOL bAddPlotSuccess = TRUE;
	

	ReportCreateGraphHelper	crtGraph(nCreateType, trOp, nMinDataIndex, nGraphIndex, NULL, NULL, nPictureIndex);
	if( crtGraph.IsCreate() )
	{
		GraphPage gp = crtGraph.GetTempGraph(GetGraphName(nGraphIndex), GetGraphTemplate(nGraphIndex));
		if(!gp)
			return error_report("Failed to get temp graph");
		GraphLayer gl = gp.Layers(0); // assume report graph is always just one layer
		bAddPlotSuccess = PlotReportGraphs(nMinDataIndex, nMaxDataIndex, trOp, gl, rReport, nTotalNumData, nGraphIndex);
	}
	
	if( bAddPlotSuccess )
	{
		if( CREATE_GRAPH_CREATE_FOR_REPORT == nCreateType )
			crtGraph.AddGraphToTreeNode();
	}
	else
	{
		crtGraph.DestroyGraph();
		error_report("Failed PlotReportGraph");
	}
			
	
	return bAddPlotSuccess;
}
*/

///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
//TreeNode	WksReportOperation::checkGetPlotInfoNode(TreeNode& trOp, int nGraphIndex, int nPictureIndex, int nPlotIndex, bool bCreate)//=0,  = true);
///Arvin 11/16/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
//TreeNode	WksReportOperation::checkGetPlotInfoNode(TreeNode& trOp, int nGraphIndex, int nPictureRowIndex, int nPicColIndex, int nPlotIndex, bool bCreate)//=0,  =0,  = true);
TreeNode	WksReportOperation::CheckGetPlotInfoNode(TreeNode& trOp, int nGraphIndex, int nPictureRowIndex, int nPicColIndex, int nPlotIndex, bool bCreate)//=0,  =0,  = false);
///end NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
{
	string strGraphNodeName = op_get_graph_tag_name(nGraphIndex);
	/// Iris 02/13/2007 v8.0560 NEED_TO_REMOVE_THIS_NODE_AFTER_CREATE_REPORT
	//trOp.GraphInfo.ID = 1; // this is the branch for all graphing control infos
	TreeNode trGraphInfoRoot = tree_check_get_node(trOp.Calculation, "GraphInfo", 1);
	trGraphInfoRoot.Show = false;
	///end NEED_TO_REMOVE_THIS_NODE_AFTER_CREATE_REPORT
	
	TreeNode trGraphInfo = tree_check_get_node(trGraphInfoRoot, strGraphNodeName, IDE_RESULT_GRAPHS + nGraphIndex);
	
	string strPictRowName = _get_picture_tag_name(nPictureRowIndex, true);
	TreeNode trPicRow = trGraphInfo.GetNode(strPictRowName);
	if( !trPicRow && bCreate )
	{
		trPicRow = trGraphInfo.AddNode(strPictRowName);
	}
	
	string strPicCol = _get_picture_tag_name(nPicColIndex, false);
	TreeNode trPicCol = trPicRow.GetNode( strPicCol );
	if( !trPicCol && bCreate )
	{
		trPicCol = trPicRow.AddNode(strPicCol);
	}
	
	TreeNode trPlot;
	string strPlotName = "Plot" + (++nPlotIndex);
	if(trPicCol)
	{
		trPlot = trPicCol.GetNode(strPlotName);
		if( !trPlot )
			trPlot = trPicCol.AddNode(strPlotName);
	}
	return trPlot;
}

/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
//vitual
int  	WksReportOperation::GetNumPlotsInOneGraph(TreeNode& trOp, int nGraphIndex)
{
	int nNumPlots = 1;
	
	if( IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) )
	{
		int nNumFactors = GetNumFactors(trOp);
		if( nNumFactors > 0 )
			nNumPlots = nNumFactors;
		else
			nNumPlots = GetTotalNumData(trOp);
	}
	return nNumPlots;
}
///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA

//bool	WksReportOperation::CheckCreateImagSubNodes(TreeNode& trOp, int nGraphIndex, int nDataIndex, TreeNode& trPict, TreeNode& trPlotInfo, LPCSTR lpcszLabel)
bool	WksReportOperation::checkCreateImagSubNodes(TreeNode& trOp, int nGraphIndex, TreeNode& trPict, TreeNode& trPlotInfo)
{
	/// Iris 03/12/2007 v8.0579 NOT_CREATE_IMAGE_SUB_NODES_IF_NOT_OUTPUT_THIS_GRAPH
	//bool 	bCreateGraph = IsCreateReportGraph(trOp, nGraphIndex);
	///end NOT_CREATE_IMAGE_SUB_NODES_IF_NOT_OUTPUT_THIS_GRAPH
	string 	strGraphNodeName = op_get_graph_tag_name(nGraphIndex);
	
	// get and setup graph node
	TreeNode trGraph = tree_check_get_node(trOp.Calculation, strGraphNodeName, IDST_RESULT_GRAPHS + nGraphIndex);	
	/// Iris 03/12/2007 v8.0579 NOT_CREATE_IMAGE_SUB_NODES_IF_NOT_OUTPUT_THIS_GRAPH
	//tree_check_set_hidden(trGraph, !bCreateGraph);
	//trGraph.SetAttribute(TREE_Table, GetTableStringGraphs());
	///end NOT_CREATE_IMAGE_SUB_NODES_IF_NOT_OUTPUT_THIS_GRAPH
	resetOneGraph(trGraph);///Sophy 3/26/2009 QA80-13351 SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU
	///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
	//int 	nNumPicRows = IsPlotAllPlotsInOneGraph(trOp)? 1 : GetReportGraphTableRowNum(trOp, nGraphIndex, false);
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	//int 	nNumPicRows = IsPlotAllPlotsInOneGraph(trOp, nGraphIndex)? 1 : GetReportGraphTableRowNum(trOp, nGraphIndex, false);
	int 	nNumPicRows = GetReportGraphTableRowNum(trOp, nGraphIndex, false);
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	///end UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
	for(int nPicRow=0; nPicRow < nNumPicRows; nPicRow++)
	{
		///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
		//int		nNumPicCols = IsPlotAllPlotsInOneGraph(trOp)? 1 : GetReportGraphTableColNum(trOp, nGraphIndex, false);
		/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
		//int		nNumPicCols = IsPlotAllPlotsInOneGraph(trOp, nGraphIndex)? 1 : GetReportGraphTableColNum(trOp, nGraphIndex, false);
		int		nNumPicCols = GetReportGraphTableColNum(trOp, nGraphIndex, false);
		///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
		///end UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
		///Arvin 05/24/07 v8.0624 GRAPH_LABEL_BECOME_VERY_WIDE_WHILE_CHANGE_PARAMETER
		//if( nNumPicRows > 1 || nNumPicCols > 1) // no need to show Data Label if there is only ONE picture
		//{
		///END GRAPH_LABEL_BECOME_VERY_WIDE_WHILE_CHANGE_PARAMETER
		///Arvin 06/08/07 CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
		//If IsPlotAllPlotsInOneGraph, should not has label node
		///Arvin 08/06/07 QA70-10024 ADD_EMPTY_LABEL_ROW_FOR_PLOT_ALL_IN_ONE_GRAPH 
		//In order to avoid label row becomes vary wide while uncheck "Plot All in One Graph" after Change Parameters 
		/// Iris 9/14/2009 QA80-11710-S1 PUT_REPORT_GRAPH_LABEL_AS_Y_AXES_TITLE
		//TreeNode 	trLabelRow = tree_check_get_node(trGraph, "Label_Row" + (nPicRow+1), make_one_set_ID(IDST_RESULT_GRAPH_TABLE_LABEL_ROW, nPicRow));
		TreeNode	trLabelRow = getReportGraphRowLabelNode(trGraph, nPicRow, true);
		///end PUT_REPORT_GRAPH_LABEL_AS_Y_AXES_TITLE
		///END CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
		///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
		//if(!IsPlotAllPlotsInOneGraph(trOp))
		//if(!IsPlotAllPlotsInOneGraph(trOp, nGraphIndex)) /// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA, comment it out
		///end 	UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
		{
		///end CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
			///Arvin 08/06/07 QA70-10024 ADD_EMPTY_LABEL_ROW_FOR_PLOT_ALL_IN_ONE_GRAPH
			//TreeNode 	trLabelRow = tree_check_get_node(trGraph, "Label_Row" + (nPicRow+1), make_one_set_ID(IDST_RESULT_GRAPH_TABLE_LABEL_ROW, nPicRow));
			///END ADD_EMPTY_LABEL_ROW_FOR_PLOT_ALL_IN_ONE_GRAPH
			for(int nPicCol=0; nPicCol < nNumPicCols; nPicCol++)
			{
				/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
				int			nPicIndex = nPicRow * nNumPicCols + nPicCol;	
				if(nPicIndex >= GetTotalNumPictureForOneGraphType(trOp, nGraphIndex))
					break;
				///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA

				string		strLabel = GetReportGraphLabel(trOp, nGraphIndex, nPicRow, nPicCol);
				if( !strLabel.IsEmpty() )
				{
					/// Iris 9/14/2009 QA80-11710-S1 PUT_REPORT_GRAPH_LABEL_AS_Y_AXES_TITLE
					//TreeNode	trLabelCol = tree_check_get_node(trLabelRow, "Label_Col" + (nPicCol+1), make_one_set_ID(IDST_RESULT_GRAPH_TABLE_COL, nPicCol));		
					TreeNode	trLabelCol = getReportGraphColLabelNode(trLabelRow, nPicCol, true);
					///end PUT_REPORT_GRAPH_LABEL_AS_Y_AXES_TITLE
					trLabelCol.strVal = strLabel;
					///Sophy 1/5/2009 v8.0993d QA80-12858 GIVE_USEFUL_INFO_ON_REPORT_GRAPH_WITH_FACTOR_VALUE_FOR_STATS_COLUMN
					UpdateReportGraphLabel(trOp, trLabelCol, nGraphIndex, nPicRow, nPicCol, nNumPicCols);
					///end GIVE_USEFUL_INFO_ON_REPORT_GRAPH_WITH_FACTOR_VALUE_FOR_STATS_COLUMN
				}
			}
		}///Arvin 06/08/07 CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
		//} ///Arvin 05/24/07 v8.0624 GRAPH_LABEL_BECOME_VERY_WIDE_WHILE_CHANGE_PARAMETER
		trPict = tree_check_get_node(trGraph, _get_picture_tag_name(nPicRow, true), make_one_set_ID(IDST_RESULT_GRAPH_TABLE_ROW, nPicRow));
		for(int nPicCol=0; nPicCol < nNumPicCols; nPicCol++)
		{
			int			nPicIndex = nPicRow * nNumPicCols + nPicCol;	
			if(nPicIndex >= GetTotalNumPictureForOneGraphType(trOp, nGraphIndex))
				break;
			
			TreeNode	trPictCol = tree_check_get_node(trPict, _get_picture_tag_name(nPicCol, false), make_one_set_ID(IDST_RESULT_GRAPH_TABLE_COL, nPicCol));		
			/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
			// If Plot All Plots in One Graph is checked, still need to create multiple nodes in trPlotInfo even only one report graph since will many plots in this one graph
			/*
			int 		nPlotIndex = ReportGetPlotIndex(nGraphIndex, nPicRow);
			trPlotInfo = checkGetPlotInfoNode(trOp, nGraphIndex, nPicRow, nPicCol, nPlotIndex, true);
			if(trPlotInfo)
			{
				UpdateImageNodePlottingInfo(trOp, trPict, trPlotInfo, nGraphIndex, nPicIndex);
			}	
			*/
			///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
		}
	}
	
	/// Iris 9/27/2009 FIX_RESET_ALL_GRAPHS_WORK_FAILED
	/* 
	/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	nNumPicRows = GetReportGraphTableRowNum(trOp, nGraphIndex);
	for(nPicRow=0; nPicRow < nNumPicRows; nPicRow++)
	{
		int		nNumPicCols = GetReportGraphTableColNum(trOp, nGraphIndex);
		for(int nPicCol=0; nPicCol < nNumPicCols; nPicCol++)
		{			
			int			nPicIndex = nPicRow * nNumPicCols + nPicCol;
			if(nPicIndex >= GetTotalNumPictureForOneGraphType(trOp, nGraphIndex)) 
				break;			
			/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA			
			//int 		nPlotIndex = ReportGetPlotIndex(nGraphIndex, nPicRow);
			
			int			nNumPlots = GetNumPlotsInOneGraph(trOp, nGraphIndex);
			for( int nPlotIndex = 0; nPlotIndex < nNumPlots; nPlotIndex++)
			///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
			{
				///Arvin 11/16/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
				//trPlotInfo = checkGetPlotInfoNode(trOp, nGraphIndex, nPicRow, nPicCol, nPlotIndex, true);
				trPlotInfo = CheckGetPlotInfoNode(trOp, nGraphIndex, nPicRow, nPicCol, nPlotIndex, true);
				///end NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
				if(trPlotInfo)
				{
					///Sophy 12/24/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
					//UpdateImageNodePlottingInfo(trOp, trPlotInfo, nGraphIndex, nPicIndex);
					/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
					//int nDataIndex = nPicIndex/( GetNumX(trOp) * GetNumY(trOp) ); // nDataIndex != nPicIndex in Multi Indep/Multi Dep function, for example fit curve report graph, one data has (numer of Xs * number Ys) graphs.
					int nDataIndex = (nPicIndex * nNumPlots + nPlotIndex) / ( GetNumX(trOp) * GetNumY(trOp) );
					///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
					//--- Iris 3/18/2009 QA80-13304 FIX_MR_RESIDUAL_PLOTS_ALL_PLOTTED_ON_FIRST_X_WITH_RESIDUAL	
					//UpdateImageNodePlottingInfo(trOp, trPlotInfo, nGraphIndex, nDataIndex);
					UpdateImageNodePlottingInfo(trOp, trPlotInfo, nGraphIndex, nDataIndex, nPicIndex);
					//---end FIX_MR_RESIDUAL_PLOTS_ALL_PLOTTED_ON_FIRST_X_WITH_RESIDUAL
					///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING					
				}
			}
		}
	}
	///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	*/
	checkCreateImagInfoSubNodes(trOp, nGraphIndex, trPlotInfo);
	///end FIX_RESET_ALL_GRAPHS_WORK_FAILED
	
	if(trPict.IsValid() && trPlotInfo.IsValid())
		return true;
	else
		return error_report("picture or info nodes not properly created in checkCreateImageNode");
}

/// Iris 9/27/2009 FIX_RESET_ALL_GRAPHS_WORK_FAILED
//virtual
bool	WksReportOperation::checkCreateImagInfoSubNodes(TreeNode& trOp, int nGraphIndex, TreeNode& trPlotInfo)
{
	/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	int nNumPicRows = GetReportGraphTableRowNum(trOp, nGraphIndex);
	for(int nPicRow=0; nPicRow < nNumPicRows; nPicRow++)
	{
		int		nNumPicCols = GetReportGraphTableColNum(trOp, nGraphIndex);
		for(int nPicCol=0; nPicCol < nNumPicCols; nPicCol++)
		{			
			int			nPicIndex = nPicRow * nNumPicCols + nPicCol;
			if(nPicIndex >= GetTotalNumPictureForOneGraphType(trOp, nGraphIndex)) 
				break;			
			/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA			
			//int 		nPlotIndex = ReportGetPlotIndex(nGraphIndex, nPicRow);
			
			int			nNumPlots = GetNumPlotsInOneGraph(trOp, nGraphIndex);
			for( int nPlotIndex = 0; nPlotIndex < nNumPlots; nPlotIndex++)
			///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
			{
				///Arvin 11/16/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
				//trPlotInfo = checkGetPlotInfoNode(trOp, nGraphIndex, nPicRow, nPicCol, nPlotIndex, true);
				trPlotInfo = CheckGetPlotInfoNode(trOp, nGraphIndex, nPicRow, nPicCol, nPlotIndex, true);
				///end NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
				if(trPlotInfo)
				{
					///Sophy 12/24/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
					//UpdateImageNodePlottingInfo(trOp, trPlotInfo, nGraphIndex, nPicIndex);
					/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
					//int nDataIndex = nPicIndex/( GetNumX(trOp) * GetNumY(trOp) ); // nDataIndex != nPicIndex in Multi Indep/Multi Dep function, for example fit curve report graph, one data has (numer of Xs * number Ys) graphs.
					int nDataIndex = (nPicIndex * nNumPlots + nPlotIndex) / ( GetNumX(trOp) * GetNumY(trOp) );
					///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
					//--- Iris 3/18/2009 QA80-13304 FIX_MR_RESIDUAL_PLOTS_ALL_PLOTTED_ON_FIRST_X_WITH_RESIDUAL	
					//UpdateImageNodePlottingInfo(trOp, trPlotInfo, nGraphIndex, nDataIndex);
					UpdateImageNodePlottingInfo(trOp, trPlotInfo, nGraphIndex, nDataIndex, nPicIndex);
					//---end FIX_MR_RESIDUAL_PLOTS_ALL_PLOTTED_ON_FIRST_X_WITH_RESIDUAL
					///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING					
				}
			}
		}
	}
	///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	return true;
}
///end FIX_RESET_ALL_GRAPHS_WORK_FAILED

///Sophy 3/26/2009 QA80-13351 SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU
bool	WksReportOperation::resetOneGraph(TreeNode trGraph)
{
	if ( !trGraph )
		return false;
	
	foreach ( TreeNode trNode in trGraph.Children )
	{
		string strTagName = trNode.tagName;
		if ( strTagName.Find(CALCULATION_GRAPH_NODE_PREIX) == 0 )
		{
			foreach ( TreeNode trOnePic in trNode.Children )
			{
				GraphPage gp;
				DWORD dwGraphUID = trOnePic.nVal;
				gp = Project.GetObject(dwGraphUID);
				if ( gp )
					gp.Destroy();
			}
		}
		trNode.Remove();
	}
	return true;
}
///end SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU

//--- Iris 3/18/2009 QA80-13304 FIX_MR_RESIDUAL_PLOTS_ALL_PLOTTED_ON_FIRST_X_WITH_RESIDUAL
//void	WksReportOperation::UpdateImageNodePlottingInfo(TreeNode& trOp, TreeNode& trPlotInfo, int nGraphIndex, int nDataIndex)
void	WksReportOperation::UpdateImageNodePlottingInfo(TreeNode& trOp, TreeNode& trPlotInfo, int nGraphIndex, int nDataIndex, int nPicIndex)
//---
{	
	if(trPlotInfo.DataIndex)
	{
		int nOldVal = trPlotInfo.DataIndex.To.nVal;
		if(nDataIndex > nOldVal)
			trPlotInfo.DataIndex.To.nVal = nDataIndex;
		nOldVal = trPlotInfo.DataIndex.From.nVal;
		if(nDataIndex < nOldVal)
			trPlotInfo.DataIndex.From.nVal = nDataIndex;
	}
	else // 1st time
	{
		trPlotInfo.DataIndex.From.nVal = nDataIndex;
		trPlotInfo.DataIndex.To.nVal = nDataIndex;
	}
	
	///Iris 4/01/05 ADD_GRAPH_INDEX
	/*
	trPlotInfo.TableID.nVal = GetResultCurveTableID(trOp, nDataIndex);
	if( IsSourceDataPlotInReport() )	
		trPlotInfo.SourcePlotType.nVal = GetDataSourcePlotType(nGraphIndex);
	
	if( IsResultsPlotInReport() )
	{
		trPlotInfo.PlotType.nVal = ReportGetPlotTypeFromGraphIndex(nGraphIndex);
	}
	*/
	//--- Iris 3/18/2009 QA80-13304 FIX_MR_RESIDUAL_PLOTS_ALL_PLOTTED_ON_FIRST_X_WITH_RESIDUAL
	// Should pass picture index here because one picture according to one report data table EXCEPT Multi Indep/Multi Dep case 
	// multiple pictures according to one report XXYY data table , has overload this function in FitNL for this case.
	//trPlotInfo.TableID.nVal = GetResultCurveTableID(trOp, nDataIndex, -1, nGraphIndex);
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	//trPlotInfo.TableID.nVal = GetResultCurveTableID(trOp, nPicIndex, -1, nGraphIndex);
	int index = nPicIndex;
	if( GetNumPlotsInOneGraph(trOp, nGraphIndex) > 1 ) // for plot all plotting in one graph is checked
		index = nDataIndex;
	trPlotInfo.TableID.nVal = GetResultCurveTableID(trOp, index, -1, nGraphIndex);
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	//---end FIX_MR_RESIDUAL_PLOTS_ALL_PLOTTED_ON_FIRST_X_WITH_RESIDUAL
	if( IsSourceDataPlotInReport(nGraphIndex) )	
		trPlotInfo.SourcePlotType.nVal = GetDataSourcePlotType(nGraphIndex);
	
	if( IsResultsPlotInReport(nGraphIndex) )
	{
		trPlotInfo.PlotType.nVal = ReportGetPlotTypeFromGraphIndex(nGraphIndex);
	}
	///end ADD_GRAPH_INDEX	
}

int		WksReportOperation::GetDataSourcePlotType(int nGraphIndex)
{
	return IDM_PLOT_SCATTER;
}

//---- Iris 11/17/06 CORRECT_REPORT_PAGE_NAME_AND_LONGNAME
//static bool _create_graph(GraphPage& pg, const string& strTemplate, const string& strName)
static bool _create_graph(GraphPage& pg, const string& strTemplate, const string& strName, LPCSTR lpcszLongName = NULL)
//----
{
	pg.Create(strTemplate, CREATE_HIDDEN);
	if(pg)
	{
		//---- Iris 11/17/06 CORRECT_REPORT_PAGE_NAME_AND_LONGNAME
		//pg.Rename(strName, false, true);
		pg.Rename(strName, false, false);
		
		string	strLongName(lpcszLongName);
		if( !strLongName.IsEmpty() )
		{
			pg.SetLongName(strLongName, false, true);
			pg.TitleShow = WIN_TITLE_SHOW_BOTH;
		}
		//----
		_DEBUG_STR2("Created temp graph %s using template %s", strName, strTemplate)
			
		return true;
	}
	return false;
}


/// ML 7/10/2006 QA70-8768 KEEPING_TRACK_OF_GRAPHS_CREATED_FROM_OPERATION
//static	DWORD	make_graph_IDValue_for_uid_map(int nGraphIndex, int nPictureIndex)
/// Iris 08/02/2007 v8.0673 QA70-10073 FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
//static	DWORD	make_graph_IDValue_for_uid_map(int nGraphIndex, int nPicRowIndex, int nPicColIndex = 0)
static	DWORD	make_graph_IDValue_for_uid_map(int nGraphIndex, int nPictureIndex)
{
	/*
	DWORD			dw = nGraphIndex << 16;
	nPictureIndex &= 0xffff;
	dw |= nPictureIndex;
	*/
	
	/// Iris 08/02/2007 v8.0673 QA70-10073 FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
	// the original logic is right
	/*
	DWORD			dw = nGraphIndex << 16;
	nPicRowIndex &= 0xff;
	nPicRowIndex = nPicRowIndex << 8;
	dw |= nPicRowIndex;
	
	nPicColIndex &= 0xff;
	dw |= nPicColIndex;
	*/	
	DWORD			dw = nGraphIndex << 16;
	nPictureIndex &= 0xffff;
	dw |= nPictureIndex;
	///end FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
	
	return dw;
}
/// end KEEPING_TRACK_OF_GRAPHS_CREATED_FROM_OPERATION


/// TD 8-8-06 QA70-8882 ATTACH_GRAPH_TO_WKS_CELLS
#ifdef _USE_OLD_MECHANISM
/// end ATTACH_GRAPH_TO_WKS_CELLS

bool	WksReportOperation::addOneGraphPicture(int nCreateType, TreeNode& trOp, TreeNode& trImage, int nGraphIndex, int nPicRow, int nPicCol, DataRange& rgReportSheetOutput)
{
	BOOL bAddPlotSuccess = TRUE;

	if( IsCreateReportGraph(trOp, nGraphIndex) )
	{
/// ML 6/30/2006 QA70-8768 BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
#ifndef		__BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
/// end BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
		///Arvin 11/16/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
		//TreeNode trPlotInfo = checkGetPlotInfoNode(trOp, nGraphIndex, nNumPicRows, nNumPicCols);
		TreeNode trPlotInfo = CheckGetPlotInfoNode(trOp, nGraphIndex, nNumPicRows, nNumPicCols);
		///end NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
		
		GraphPage pg;
		//---- Iris 11/17/06 CORRECT_REPORT_PAGE_NAME_AND_LONGNAME
		//if(!_create_graph(pg, GetGraphTemplate(nGraphIndex), GetGraphName(nGraphIndex)))
		if(!_create_graph(pg, GetGraphTemplate(nGraphIndex), GetGraphName(nGraphIndex), GetGraphName(nGraphIndex, true)))
		//----
			return error_report("addOneGraphPicture failed to create temp graph");
			
		GraphLayer gl = pg.Layers(0);
		
	 	bAddPlotSuccess = plotReportGraphs(trPlotInfo, trOp, gl, nGraphIndex);	
	 	/// Iris 9/28/05 adding custom table into hidden fitted curve graph will cause runtime error, so commneted temporary
	 	//if(bAddPlotSuccess && IsPasteCustomTableToReportGraph(nGraphIndex) )
	 	//	addReportTableToGraph(trOp, gl, rgReportSheetOutput);
		
	 	
	 	//////////
/// ML 6/30/2006 QA70-8768 BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
#else		// __BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
/// end BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
		GraphPage pg;
		if( CREATE_GRAPH_CREATE_FOR_REPORT != nCreateType )
		{
			/// ML 7/10/2006 QA70-8768 KEEPING_TRACK_OF_GRAPHS_CREATED_FROM_OPERATION
			/*
			TreeNode trPlotInfo = checkGetPlotInfoNode(trOp, nGraphIndex, nPictureIndex);
			
			if(!_create_graph(pg, GetGraphTemplate(nGraphIndex), GetGraphName(nGraphIndex)))
				return error_report("addOneGraphPicture failed to create temp graph");
				
			GraphLayer gl = pg.Layers(0);
			
		 	bAddPlotSuccess = PlotReportGraphs(trPlotInfo, trOp, gl, nGraphIndex);
			*/		 	
		 	////////
			DWORD	dwIDValue = make_graph_IDValue_for_uid_map(nGraphIndex, nPictureIndex);
			DWORD	dwGraphUID;
			BOOL	bGraphExists = GetUIDFromIdMap(OPERIDTOUIDTYPE_GRAPH, dwIDValue, dwGraphUID);
			if ( bGraphExists )
			{
				pg = Project.GetObject(dwGraphUID);
				if ( !pg )
					bGraphExists = FALSE;
			}
			
			if ( !bGraphExists )
			{
				///Arvin 11/16/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
				//TreeNode trPlotInfo = checkGetPlotInfoNode(trOp, nGraphIndex, nNumPicRows, nNumPicCols);
				TreeNode trPlotInfo = CheckGetPlotInfoNode(trOp, nGraphIndex, nNumPicRows, nNumPicCols);
				///end NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
				
				//---- Iris 11/17/06 CORRECT_REPORT_PAGE_NAME_AND_LONGNAME
				//if(!_create_graph(pg, GetGraphTemplate(nGraphIndex), GetGraphName(nGraphIndex)))
				if(!_create_graph(pg, GetGraphTemplate(nGraphIndex), GetGraphName(nGraphIndex), GetGraphName(nGraphIndex, true)))
				//----
					return error_report("addOneGraphPicture failed to create temp graph");
					
				GraphLayer gl = pg.Layers(0);
				
			 	bAddPlotSuccess = plotReportGraphs(trPlotInfo, trOp, gl, nGraphIndex);
				dwGraphUID = pg.GetUID(true);			 	
			 	SetIdUIDtoMap(OPERIDTOUIDTYPE_GRAPH, dwIDValue, dwGraphUID);
			}
		 	
			/// end KEEPING_TRACK_OF_GRAPHS_CREATED_FROM_OPERATION
		}		
/// ML 6/30/2006 QA70-8768 BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
#endif		// __BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
/// end BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
		// now export it to tree or show
		if( CREATE_GRAPH_CREATE_FOR_REPORT == nCreateType )
		{
/// ML 6/30/2006 QA70-8768 BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
#ifdef		__BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
			trImage.Reset(true);
			//trImage.SetAttribute(STR_LABEL_ATTRIB, _L("Click to open graph"));
			trImage.strVal = _L("Click to open graph");
			trImage.SetAttribute(TREE_Control, ONODETYPE_BUTTON);
#else		// !__BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
/// end BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
			PictureHolder pictHolder;
			if( !page_get_picture(pg, pictHolder, "EMF", 72, false) )
				return error_report("failed to create EMF from graph");
		
			trImage.pict = pictHolder;
			
			int		nPictureIndex = (nNumPicRows * GetReportGraphTableRowNum(trOp, nGraphIndex)) + nNumPicCols;
			string strImageNodeName;
			strImageNodeName.Format("%s%d", CALCULATION_GRAPH_NODE_PREIX, nPictureIndex + 1);
			trImage.SetAttribute(TREE_Key, strImageNodeName);
			/// Iris 5/19/05 QA70-6365 SETUP_FITY_CONFID_PRODI_LINE_COLOR
			//pg.Destroy();
			TreeNode 	trTempGraph = tree_check_get_node(trOp.Temp, op_get_graph_tag_name(nGraphIndex), IDST_FIT_TEMP_GRAPHS + nGraphIndex + nPictureIndex);
			/// Iris 07/04/05 UPDATE_DESTROY_GRAPH_NODE_FOR_MR
			string 		strPrefix = CALCULATION_GRAPH_NODE_PREIX;

			TreeNode 	trTempPic = check_add_enumerated_node(trTempGraph, strPrefix, nPictureIndex, IDST_FIT_TEMP_ONE_PICTURE + nPictureIndex);
			trTempPic.strVal = pg.GetName();
			///end UPDATE_DESTROY_GRAPH_NODE_FOR_MR
			///end SETUP_FITY_CONFID_PRODI_LINE_COLOR
/// ML 6/30/2006 QA70-8768 BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
#endif		// !__BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
/// end BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
		}
		else
		{
			pg.SetShow();
			pg.Refresh(true);  ///Iris 11/03/05 QA70-7105-P3 FIX_NO_AXIS_IN_FITTED_CURVE_FOR_PR
		}		
	}
	
	return bAddPlotSuccess;
}
/// end PICTURE_IN_REPORT_IMPROVEMENT
/// TD 8-8-06 QA70-8882 ATTACH_GRAPH_TO_WKS_CELLS
#else //_USE_OLD_MECHANISM


/// YuI 02/18/08 QA70-10453 BIN_WORKSHEET_FOR_OPERATION_BASED_ANALYSES_BUG
// need to move it to some .h file later
#define		PLOT2BIN_XFUNCTION_NAME	"Plot2Bin"
static void	_destroy_bin_worksheets(GraphPage& pg)
{
	if( !pg )
		return;
	
	foreach( GraphLayer gl in pg.Layers )
	{
		foreach( DataPlot dp in gl.DataPlots )
		{
			XYRange rg;
			if( dp.GetDataRange(rg) )
			{
				OperationBase& opBase = Project.Operations.FindOutgoingOperation(rg, PLOT2BIN_XFUNCTION_NAME);
				if( opBase )
				{
					Operation& op = (Operation&) opBase;
					DataRange dr;
					Datasheet ds;
					op.GetOutput(dr, ds, 1);
					op_destroy_on_cancel(op);
					
					if( ds )
						ds.Destroy();
				}
			}
		}
	}
}
/// end BIN_WORKSHEET_FOR_OPERATION_BASED_ANALYSES_BUG
		
///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
//DWORD	 WksReportOperation::oneGraph(TreeNode& trOp, int nGraphIndex, int nPictureIndex)
//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
//DWORD	 WksReportOperation::oneGraph(TreeNode& trOp, int nGraphIndex, int nPicRowIndex, int nPicColIndex)
/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
//DWORD	 WksReportOperation::oneGraph(TreeNode& trOp, int nGraphIndex, int nPicRowIndex, int nPicColIndex, bool bResetGraphs/* = false*/)
DWORD	 WksReportOperation::oneGraph(TreeNode& trOp, int nGraphIndex, int nPicRowIndex, int nPicColIndex, int nPlotIndex, bool bResetGraphs/* = false*/)
///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
//------
{
	GraphPage pg;
	/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	/*
	///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	//DWORD	dwIDValue = make_graph_IDValue_for_uid_map(nGraphIndex, nPicRowIndex);
	DWORD	dwIDValue = make_graph_IDValue_for_uid_map(nGraphIndex, nPicRowIndex, nPicColIndex);
	///End MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	*/
	DWORD	dwIDValue;
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	/*
	///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
	//if( IsPlotAllPlotsInOneGraph(trOp) )
	if( IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) )
	///end 	UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
	{
		/// Iris 08/02/2007 v8.0673 QA70-10073 FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
		//dwIDValue = make_graph_IDValue_for_uid_map(nGraphIndex, 0, 0); //Only one Graph for the case
		dwIDValue = make_graph_IDValue_for_uid_map(nGraphIndex, 0);
		///end FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
	}
	else
	*/	
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	{
		/// Iris 08/02/2007 v8.0673 QA70-10073 FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
		//dwIDValue = make_graph_IDValue_for_uid_map(nGraphIndex, nPicRowIndex, nPicColIndex);
		int nPictureIndex = nPicRowIndex * GetReportGraphTableColNum(trOp, nGraphIndex) + nPicColIndex;
		dwIDValue = make_graph_IDValue_for_uid_map(nGraphIndex, nPictureIndex);
		///end FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
	}
	///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	
	DWORD	dwGraphUID = 0;
	BOOL	bGraphExists = GetUIDFromIdMap(OPERIDTOUIDTYPE_GRAPH, dwIDValue, dwGraphUID);
	if ( bGraphExists )
	{
		pg = Project.GetObject(dwGraphUID);
		/// ML 11/14/2006 OLD_GRAPH_PAGES_MUST_BE_PRESERVED
		/////Cheney 2006-9-24 IF_RECACULATE_SHOULD_PLOT_GRAPH_AGAIN_ALTHOUGH_PAGE_EXIST
		//pg.Destroy(); //I tried to plot grapg in existed pg, but still cannot plot source and result graph.
		/////end IF_RECACULATE_SHOULD_PLOT_GRAPH_AGAIN_ALTHOUGH_PAGE_EXIST
		/// end OLD_GRAPH_PAGES_MUST_BE_PRESERVED
		if ( !pg )
			bGraphExists = FALSE;
		//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
		//------ Folger 12/09/08 v8.0984 SHOULD_ONLY_RESET_REPORT_GRAPH_PAGE_WHEN_PLOT_FIRST_LAYER
		//if ( bGraphExists && bResetGraphs )
		//if ( bGraphExists && bResetGraphs && (!IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) || (nPicColIndex == 0 && nPicRowIndex == 0)) )
		if ( bGraphExists && bResetGraphs && 0 == nPlotIndex )
		//------ End SHOULD_ONLY_RESET_REPORT_GRAPH_PAGE_WHEN_PLOT_FIRST_LAYER
			pg.LoadTemplate(GetGraphTemplate(nGraphIndex));
		//------
	}

	/// Iris 08/03/2007 QA70-10073 ALWAYS_REPLOT_HISTRAM_BOX_REPORT_GRAPH
	///Arvin 08/28/07 QA70-10073 ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID as max said
	//if( IDM_PLOT_HISTOGRAM_TYPE == ReportGetPlotTypeFromGraphIndex(nGraphIndex) || IDM_PLOT_BOX == ReportGetPlotTypeFromGraphIndex(nGraphIndex) )
	if( isTreeNodePlotInOneGraphValid(trOp) && (IDM_PLOT_HISTOGRAM_TYPE == ReportGetPlotTypeFromGraphIndex(nGraphIndex) || IDM_PLOT_BOX == ReportGetPlotTypeFromGraphIndex(nGraphIndex)) )
	///end ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID
	{
		/// YuI 02/18/08 QA70-10453 BIN_WORKSHEET_FOR_OPERATION_BASED_ANALYSES_BUG
		_destroy_bin_worksheets(pg);
		/// end BIN_WORKSHEET_FOR_OPERATION_BASED_ANALYSES_BUG
		/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA		
		/*
		///Arvin 09/29/07 QA70-10073 ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID as max said
		//if( bGraphExists && 0 == nPicRowIndex && 0 == nPicColIndex )
		bool bNeedRePlot = true;
		///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
		//if(IsPlotAllPlotsInOneGraph(trOp) && (nPicRowIndex > 0 || nPicColIndex > 0))
		if(IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) && (nPicRowIndex > 0 || nPicColIndex > 0))
		///end UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO	
			bNeedRePlot = false;
		*/	
#ifndef BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION
		bool bNeedRePlot = (0 == nPlotIndex); // if plot all in one graph, will plot multiple times in one graph, so when plot 2nd and later plotting, not want to do LoadTemplate on graph.
		///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
		if( bGraphExists && bNeedRePlot)
		///end ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID
		{
			//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
			//pg.Destroy();
			//bGraphExists = FALSE;
			pg.LoadTemplate(GetGraphTemplate(nGraphIndex));
			//------
		}		
#endif //BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION	
	}
	///end ALWAYS_REPLOT_HISTRAM_BOX_REPORT_GRAPH
	
	///Cheney 2006-11-21 SHOULD_REPLOT_SOURCE_CURVE_WHEN_CHANGE_PARAMETER
	///Arvin 11/16/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT	
	//TreeNode trPlotInfo = checkGetPlotInfoNode(trOp, nGraphIndex, nPicRowIndex, nPicColIndex); 
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	//TreeNode trPlotInfo = CheckGetPlotInfoNode(trOp, nGraphIndex, nPicRowIndex, nPicColIndex); 
	TreeNode trPlotInfo = CheckGetPlotInfoNode(trOp, nGraphIndex, nPicRowIndex, nPicColIndex, nPlotIndex); 
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	///end NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
	///end SHOULD_REPLOT_SOURCE_CURVE_WHEN_CHANGE_PARAMETER
	if ( !bGraphExists )
	{
		///Cheney 2006-11-21 SHOULD_REPLOT_SOURCE_CURVE_WHEN_CHANGE_PARAMETER
		//TreeNode trPlotInfo = checkGetPlotInfoNode(trOp, nGraphIndex, nPicRowIndex, nPicColIndex);
		///end SHOULD_REPLOT_SOURCE_CURVE_WHEN_CHANGE_PARAMETER
		//---- Iris 11/17/06 CORRECT_REPORT_PAGE_NAME_AND_LONGNAME
		//if(!_create_graph(pg, GetGraphTemplate(nGraphIndex), GetGraphName(nGraphIndex)))
		if(!_create_graph(pg, GetGraphTemplate(nGraphIndex), GetGraphName(nGraphIndex), GetGraphName(nGraphIndex, true) ))
		//----
			return error_report("addOneGraphPicture failed to create temp graph");	
		
		/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
		///Arvin 06/08/07 CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR	
		//afterCreateReportGraph(trOp, nGraphIndex, pg);
		///end CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
		///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
		
	}///Cheney 2006-11-21 SHOULD_REPLOT_SOURCE_CURVE_WHEN_CHANGE_PARAMETER
	
	///Arvin 06/08/07 CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
	///Arvin 11/09/07 KEEP_USER_INSERTED_LAYER_IN_REPORT_GRAPH_IN_FITTING
	//afterGetReportGraphPage(trOp, nGraphIndex, pg, nPicRowIndex, nPicColIndex);
	if(isTreeNodePlotInOneGraphValid(trOp))
		checkAndArrangeReportGraphLayers(trOp, nGraphIndex, pg, nPicRowIndex, nPicColIndex);
	///END KEEP_USER_INSERTED_LAYER_IN_REPORT_GRAPH_IN_FITTING
	///end CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
	
	/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	//gl = pg.Layers(0);	
	//while(gl.RemovePlot(0));	
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	/*
	int 	nPlotIndex = 0;
	if(GetNumberLayersInOneGraph(trOp, nGraphIndex) > 1)
	{
		nPlotIndex = nPicRowIndex * GetReportGraphTableColNum(trOp, nGraphIndex) + nPicColIndex;
	}
	GraphLayer 	gl = pg.Layers(nPlotIndex);
	*/
	int 	nLayerIndex = 0;
	if(GetNumberLayersInOneGraph(trOp, nGraphIndex) > 1)
	{
		nLayerIndex = nPlotIndex; // assume when multiple layers in one graph, then there is only one plot in one layer
	}
	GraphLayer 	gl = pg.Layers(nLayerIndex);
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	
	///Arvin 06/08/07 CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
	/// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	/*
	if(IsPlotAllPlotsInOneGraph(trOp) && nPicColIndex == 0 && nPicRowIndex == 0)
		while(gl.RemovePlot(0));
	///end CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
	if( !IsPlotAllPlotsInOneGraph(trOp) )// for Box chart, there are two plots in one layer		
		while(gl.RemovePlot(0));
	*/
	///end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH	

	//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	/// This code is aimed for passing checking inside hasPlottedOnReportGraph() and bHasPlottedOnSourceGraph(),
	/// though is not good, should be enough for now, will be cleaned up when rewrite operation
	if ( bResetGraphs )
		removeGraphUID(dwIDValue);
	//------
	
	///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	//BOOL bSuccess = PlotReportGraphs(trPlotInfo, trOp, gl, nGraphIndex);
	//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	//BOOL bSuccess = plotReportGraphs(trPlotInfo, trOp, gl, nGraphIndex, nPicRowIndex, nPicColIndex);
	BOOL bSuccess = plotReportGraphs(trPlotInfo, trOp, gl, nGraphIndex, nPicRowIndex, nPicColIndex, bResetGraphs);
	//------
	///end MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH	
	
	dwGraphUID = pg.GetUID(true);			 	
	SetIdUIDtoMap(OPERIDTOUIDTYPE_GRAPH, dwIDValue, dwGraphUID);
	if(!bSuccess)
	{
		pg.Destroy(); /// Iris 7/02/2008 FIX_SHOW_HIDDEN_GRAPH_WHEN_ANOVA_1WAY_FAIL_TO_CLAC_MEANS_COMP
		return 0;
	}
	
	return dwGraphUID;
}

//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
/// maybe this should a OperationBase function ...
void	WksReportOperation::removeGraphUID(DWORD dwIDValue)
{
	vector<uint>		vnMap;
	GetIdsToUIDsMap(vnMap);
	
	const	int			nStep = 3;
	
	for ( int ii=0; ii<vnMap.GetSize(); ii+=nStep )
	{
		if ( vnMap[ii] == OPERIDTOUIDTYPE_GRAPH && vnMap[ii+1] == dwIDValue )
		{
			for ( int jj=0; jj<nStep; ++jj )
				vnMap.RemoveAt(ii);
			break;
		}
	}
	
	SetIdsToUIDsMap(vnMap);
}
//------ End SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET

void 	WksReportOperation::putGraphUIDToReportTree(TreeNode& trOnePic, DWORD dwGraphUID)
{
	if(trOnePic)
	{
		trOnePic.Reset(true);
		trOnePic.strVal = dwGraphUID;
		trOnePic.SetAttribute(TREE_Control, ONODETYPE_EMBED_GRAPH);		
	}
}

/// Iris 9/14/2009 QA80-11710-S1 PUT_REPORT_GRAPH_LABEL_AS_Y_AXES_TITLE
TreeNode	WksReportOperation::getReportGraphRowLabelNode(TreeNode& trGraph, int nIndex, bool bCreate)
{
	string 		strName = "Label_Row";
	int			nBaseID = IDST_RESULT_GRAPH_TABLE_LABEL_ROW ;

	TreeNode 	trNode;	
	if( bCreate )
		trNode = tree_check_get_node(trGraph, strName + (nIndex+1), make_one_set_ID(nBaseID, nIndex));
	else
		trNode = trGraph.GetNode(strName + (nIndex+1));
	return trNode;
	
}
TreeNode	WksReportOperation::getReportGraphColLabelNode(TreeNode& trRowNode, int nIndex, bool bCreate)
{
	string 		strName = "Label_Col";
	int			nBaseID = IDST_RESULT_GRAPH_TABLE_COL;

	TreeNode 	trNode;	
	if( bCreate )
		trNode = tree_check_get_node(trRowNode, strName + (nIndex+1), make_one_set_ID(nBaseID, nIndex));
	else
		trNode = trRowNode.GetNode(strName + (nIndex+1));
	return trNode;
	
}

void	WksReportOperation::updateAxesTitleOnReportGraphLabel(TreeNode& trOp, int nGraphIndex, TreeNode& trGraph, int nRowIndex, int nColIndex, int nPlotIndex, DWORD dwGraphUID)
{
	/// Iris 9/22/2009 STATS_ON_COLS_REPORT_GRAPH_BAD_Y_AXIS_LABEL_WHEN_ONE_DATA_NOT_GROUPING_DATA
	if( !HasFactor(trOp, 0) )
		return;
	///end STATS_ON_COLS_REPORT_GRAPH_BAD_Y_AXIS_LABEL_WHEN_ONE_DATA_NOT_GROUPING_DATA
	
	int nPlotType = ReportGetPlotTypeFromGraphIndex(nGraphIndex);
	if( nPlotType == IDM_PLOT_BOX || nPlotType == IDM_PLOT_HISTOGRAM_TYPE )
	{
		GraphPage gp;
		gp = Project.GetObject(dwGraphUID);
		if( gp )
		{	
			TreeNode 	trRow = getReportGraphRowLabelNode(trGraph, nRowIndex, false);
			if( !trRow )
				return;
			
			TreeNode	trLabelCol = getReportGraphColLabelNode(trRow, nColIndex, false);
			if( !trLabelCol )
				return;
			
			int 		nLayerIndex = 0;		
			if( GetNumberLayersInOneGraph(trOp, nGraphIndex) > 1 )
				nLayerIndex = nPlotIndex;
				
			GraphLayer gl = gp.Layers(nLayerIndex);
			ASSERT(gl);
			if( !gl )
				return;
			
			AxisObject aoY;
			aoY = gl.YAxis.AxisObjects(AXISOBJPOS_AXIS_FIRST);
			ASSERT(aoY);
			if( !aoY )
				return;
			
			GraphObject goYL;
			goYL = aoY.GetTitleObject();
			ASSERT(goYL);
			if( !goYL )
				return;
			
			if( !trLabelCol.strVal.IsEmpty() )
				goYL.Text = trLabelCol.strVal;
		}
	}
}
///end PUT_REPORT_GRAPH_LABEL_AS_Y_AXES_TITLE

///Arvin 06/08/07 CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
//void	WksReportOperation::afterCreateReportGraph(TreeNode &trOp, int nGraphIndex, GraphPage & gp)
///Arvin 11/09/07 KEEP_USER_INSERTED_LAYER_IN_REPORT_GRAPH_IN_FITTING
//void	WksReportOperation::afterGetReportGraphPage(TreeNode &trOp, int nGraphIndex, GraphPage & gp, int nPicRowIndex, int nPicColIndex)
void	WksReportOperation::checkAndArrangeReportGraphLayers(TreeNode &trOp, int nGraphIndex, GraphPage & gp, int nPicRowIndex, int nPicColIndex)
///END KEEP_USER_INSERTED_LAYER_IN_REPORT_GRAPH_IN_FITTING
///end CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
{
	//arrange layers for the graph if needed
	int		nNumLayers = GetNumberLayersInOneGraph(trOp, nGraphIndex);
	///Arvin 06/11/07 CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
	//if( nNumLayers > 1 && gp) //need arrangement
	//{
		//while(gp.Layers.Count() < nNumLayers)
		//	///Arvin 03/07/07 USE_SAME_TEMPLATE_FOR_ALL_PLOTS_IN_ONE_GRAPH
		//	//gp.AddLayer();
		//	gp.AddLayer(NULL, 0, GetGraphTemplate(nGraphIndex));
		//	///end USE_SAME_TEMPLATE_FOR_ALL_PLOTS_IN_ONE_GRAPH
			
		//int		nRows = GetReportGraphTableRowNum(trOp, nGraphIndex);
		//int		nCols = GetReportGraphTableColNum(trOp, nGraphIndex);
		//page_arrange_layers(gp, nRows, nCols);
	 //}
	 if(gp)
	 {
		bool bChanged = false;
	 	if(gp.Layers.Count() != nNumLayers)
		{
			while(gp.Layers.Count() < nNumLayers)
			{
				gp.AddLayer(NULL, 0, GetGraphTemplate(nGraphIndex));
				bChanged = true; /// Hong QA80-11606 FIX_LAYER_ARRAMGEMENT_CHANGED_WHEN_RECALCULATE_IF_USER_ADD_NEW_LAYER
			}
						
			/// Hong 07/21/08 QA80-11606 FIX_RECALCULATE_LOST_NEW_ADDED_LAYER_IN_FITTED_CURVE
			/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
			//ASSERT(trOp.GUI.Output.PlotSettings);
			//TreeNode	trPlotOneGraph = trOp.GUI.Output.PlotSettings.PlotInOneGraph;
			TreeNode	trPlotOneGraph = OP_GUI_GRAPH_ARRANGEMENT_NODE(trOp.GUI).PlotInOneGraph;
			///end OP_DLG_NEW_STRUCTURE
			int			nOldValue = -1;
			bool		bPlotOneGraphChanged = false;
			if ( trPlotOneGraph && trPlotOneGraph.GetAttribute(STR_CHANGED_ATTRIB, nOldValue) )
				bPlotOneGraphChanged = true;
			
			if ( bPlotOneGraphChanged )			
			{
			/// end FIX_RECALCULATE_LOST_NEW_ADDED_LAYER_IN_FITTED_CURVE
				//When change PlotAllPlotsInOneGraph to normal, need remove surpus graphlayers
				while(gp.Layers.Count() > nNumLayers)
				{
					GraphLayer gl = gp.Layers(nNumLayers);
					gl.Destroy();
					bChanged = true;
				}
			} /// Hong 07/21/08 QA80-11606 FIX_RECALCULATE_LOST_NEW_ADDED_LAYER_IN_FITTED_CURVE
			/// Hong QA80-11606 FIX_LAYER_ARRAMGEMENT_CHANGED_WHEN_RECALCULATE_IF_USER_ADD_NEW_LAYER
			//bChanged = true;
			/// end FIX_LAYER_ARRAMGEMENT_CHANGED_WHEN_RECALCULATE_IF_USER_ADD_NEW_LAYER
		}
		/// Hong QA80-11606 FIX_LAYER_ARRAMGEMENT_CHANGED_WHEN_RECALCULATE_IF_USER_ADD_NEW_LAYER
		//if(nNumLayers > 1 || bChanged)
		if ( bChanged )
		/// end FIX_LAYER_ARRAMGEMENT_CHANGED_WHEN_RECALCULATE_IF_USER_ADD_NEW_LAYER
		{
			/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
			//int		nRows = GetReportGraphTableRowNum(trOp, nGraphIndex);
			//int		nCols = GetReportGraphTableColNum(trOp, nGraphIndex);
			//page_arrange_layers(gp, nRows, nCols);
			arrangeReportGraphLayers(trOp, nGraphIndex, gp, nNumLayers);
			///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
		}
	}
	///end CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
}

//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
//bool	WksReportOperation::addOneGraphPicture(int nCreateType, TreeNode& trOp, TreeNode& trImage, int nGraphIndex, int nPicRow, int nPicCol, DataRange& rgReportSheetOutput, DWORD *pdwGraphUID)
/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
//bool	WksReportOperation::addOneGraphPicture(int nCreateType, TreeNode& trOp, TreeNode& trImage, int nGraphIndex, int nPicRow, int nPicCol, DataRange& rgReportSheetOutput, DWORD *pdwGraphUID, bool bResetGraphs/* = false*/)
bool	WksReportOperation::addOneGraphPicture(int nCreateType, TreeNode& trOp, TreeNode& trImage, int nGraphIndex, int nPicRow, int nPicCol, int nPlotIndex, DataRange& rgReportSheetOutput, DWORD *pdwGraphUID, bool bResetGraphs/* = false*/)
///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
//------
{
	if( IsCreateReportGraph(trOp, nGraphIndex) )
	{
		int			nPicIndex = nPicRow * GetReportGraphTableColNum(trOp, nGraphIndex) + nPicCol;	
		if(nPicIndex < GetTotalNumPictureForOneGraphType(trOp, nGraphIndex))
		{			
			//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
			//DWORD dwGraphUID = oneGraph(trOp, nGraphIndex, nPicRow, nPicCol);
			/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
			//DWORD dwGraphUID = oneGraph(trOp, nGraphIndex, nPicRow, nPicCol, bResetGraphs);
			DWORD dwGraphUID = oneGraph(trOp, nGraphIndex, nPicRow, nPicCol, nPlotIndex, bResetGraphs);
			///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
			//------
			if(dwGraphUID)
			{
				/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
				/*
				TreeNode trOnePic = trImage.GetNode( _get_picture_tag_name(nPicCol, false) );
				if(trOnePic)
				{
					trOnePic.Reset(true);
					trOnePic.strVal = dwGraphUID;
					trOnePic.SetAttribute(TREE_Control, ONODETYPE_EMBED_GRAPH);
				}				
				*/
				if(NULL != pdwGraphUID)
					*pdwGraphUID = dwGraphUID;
				///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
			}
			else
				return error_report("fail to add one graph in addOneGraphPicture");
		}
		///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	}
	return true;
}
#endif //_USE_OLD_MECHANISM
/// end ATTACH_GRAPH_TO_WKS_CELLS

/// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
/// Iris 08/01/2007 QA70-10073 FIND_BETTER_WAY_TO_CHECK_IF_GRAPH_EXISTS
/*
TreeNode WksReportOperation::getOnePictureNode(TreeNode& trOp, int nGraphIndex, int nDataIndex)
{
	TreeNode 	trPicutre;
	TreeNode 	trGraph = trOp.Calculation.GetNode(op_get_graph_tag_name(nGraphIndex));
	if(!trGraph)
		return trPicutre;
	
	int			nNumCols = GetReportGraphTableColNum(trOp, nGraphIndex, false);
	int			nPicRow = nDataIndex / nNumCols;
	int			nPicCol = nDataIndex % nNumCols;
	
	TreeNode	trPictures = trGraph.GetNode( _get_picture_tag_name(nPicRow, true) );
	if(trPictures)
		trPicutre = trPictures.GetNode( _get_picture_tag_name(nPicCol, false) );
	
	return trPicutre;
}


bool	WksReportOperation::hasPlottedReportCurve(TreeNode& trOp, int nGraphIndex, int nDataIndex)
{
	TreeNode 	trPicutre = getOnePictureNode(trOp, nGraphIndex, nDataIndex);
	bool		bIsPlotExisted = trPicutre && !trPicutre.IsEmpty();
	return bIsPlotExisted;
}
*/

/// Iris 08/02/2007 v8.0673 QA70-10073 FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
/*
bool	WksReportOperation::isReportGraphExisted(TreeNode& trOp, int nGraphIndex, int nDataIndex)
{
	int			nNumCols = GetReportGraphTableColNum(trOp, nGraphIndex, false);
	int			nPicRowIndex = 0, nPicColIndex = 0;
	//if( !IsPlotAllPlotsInOneGraph(trOp) ) /// Iris 08/02/2007 v8.0672 FIX_PLOT_ALL_PLOTS_IN_ONE_GRAPH_FAIL_PLOT_ALL_PLOTS
	{
		nPicRowIndex = nDataIndex / nNumCols;
		nPicColIndex = nDataIndex % nNumCols;
	}
	return isReportGraphExisted(nGraphIndex, nPicRowIndex, nPicColIndex);
}
bool	WksReportOperation::isReportGraphExisted(int nGraphIndex, int nPicRowIndex, int nPicColIndex)
{	
	DWORD	dwIDValue = make_graph_IDValue_for_uid_map(nGraphIndex, nPicRowIndex, nPicColIndex);
	
	DWORD	dwGraphUID = 0;
	BOOL	bGraphExists = GetUIDFromIdMap(OPERIDTOUIDTYPE_GRAPH, dwIDValue, dwGraphUID);
	return bGraphExists;	
}
*/	
///Sophy 12/24/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
//bool	WksReportOperation::hasPlottedOnReportGraph(int nGraphIndex, int nDataIndex)
bool	WksReportOperation::hasPlottedOnReportGraph(int nGraphIndex, int nPicIndex) //on muiltiple dataset with multi-indeps&deps, dataset index is not always the same as picture index
///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
{
	DWORD	dwIDValue = make_graph_IDValue_for_uid_map(nGraphIndex, nPicIndex);
	
	DWORD	dwGraphUID = 0;
	BOOL	bGraphExists = GetUIDFromIdMap(OPERIDTOUIDTYPE_GRAPH, dwIDValue, dwGraphUID);
	/// Iris 08/03/2007 v8.0673 FIX_NO_REPORT_GRAPH_AFTER_RECALC_IN_OTW
	if(bGraphExists)
	{
		OriginObject object;
		object = Project.GetObject(dwGraphUID);
		return object.IsValid();
	}
	///end FIX_NO_REPORT_GRAPH_AFTER_RECALC_IN_OTW
	return bGraphExists;	
}	
///end FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
///end FIND_BETTER_WAY_TO_CHECK_IF_GRAPH_EXISTS
///end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH

//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
//bool WksReportOperation::addOneGraphTypeToReport(Worksheet& wksReport, DataRange& rgReportSheetOutput, TreeNode& trOp, int nGraphIndex)
bool WksReportOperation::addOneGraphTypeToReport(Worksheet& wksReport, DataRange& rgReportSheetOutput, TreeNode& trOp, int nGraphIndex, bool bResetGraphs/* = false*/)
//------
{
	TreeNode trGraph = trOp.Calculation.GetNode(op_get_graph_tag_name(nGraphIndex));
	if(!trGraph)
		/// Iris 10/19/05 NOT_RETURN_FALSE_WHEN_RESULT_GRAPH_NODE_MISS
		//Sometimes we let graph node exist but not show, but FilterReport will remove all hidden nodes. So not return false even though graph node is missing
		//return error_report("addOneGraphToReport found graph node missing");
		return true;
		///End NOT_RETURN_FALSE_WHEN_RESULT_GRAPH_NODE_MISS
	
	DWORD	dwGraphUID;
	
	int nHistOrBoxIndex = 0; ///Arvin 10/24/06 FITTING_HISTOGRAM_PLOT	
	//foreach(TreeNode trImage in trImageColl)  /// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT
	/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	//for(int nPicRow = 0; nPicRow < trGraph.GetNodeCount(); nPicRow++)  
	int 	nNumPicRows = GetReportGraphTableRowNum(trOp, nGraphIndex);
	for(int nPicRow=0; nPicRow < nNumPicRows; nPicRow++)
	///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	{	
		TreeNode	trImage = trGraph.GetNode( _get_picture_tag_name(nPicRow, true) );
		/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
		/*
		/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
		///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
		//if(IsPlotAllPlotsInOneGraph(trOp))
		if(IsPlotAllPlotsInOneGraph(trOp, nGraphIndex))
		///end 	UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
			///Arvin 08/06/07 QA70-10024  ADD_EMPTY_LABEL_ROW_FOR_PLOT_ALL_IN_ONE_GRAPH
			//trImage = trGraph.FirstNode;
			trImage = trGraph.LastNode;
			///end ADD_EMPTY_LABEL_ROW_FOR_PLOT_ALL_IN_ONE_GRAPH
		///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
		*/
		///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
		
		/// Iris 01/15/2007 v8.0541 ADD_DATA_LABEL_FOR_EACH_REPORT_GRAPH
		if( !trImage )
			continue;		
		///end ADD_DATA_LABEL_FOR_EACH_REPORT_GRAPH
		
		/// Iris 01/15/2007 v8.0541 ADD_DATA_LABEL_FOR_EACH_REPORT_GRAPH
		//for(int nPicCol = 0; nPicCol < trImage.GetNodeCount(); nPicCol++)
		/*
		string		strPicPrefix = _get_picture_tag_name(-1, false);
		TreeNodeCollection trPicColl(trImage, strPicPrefix);
		for(int nPicCol = 0; nPicCol < trPicColl.Count(); nPicCol++)
		///end ADD_DATA_LABEL_FOR_EACH_REPORT_GRAPH
		*/
		int 	nNumPicCols = GetReportGraphTableColNum(trOp, nGraphIndex);
		for(int nPicCol = 0; nPicCol < nNumPicCols; nPicCol++)
		{
			/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
			int nNumPlots = GetNumPlotsInOneGraph(trOp, nGraphIndex);			
			for( int nPlotIndex = 0; nPlotIndex < nNumPlots; nPlotIndex++)
			{
			///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
				///Arvin 10/24/06 FITTING_HISTOGRAM_PLOT
				///Arvin 11/16/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
				//TreeNode trPlotInfo = checkGetPlotInfoNode(trOp, nGraphIndex, nPicRow, nPicCol);
				/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
				//TreeNode trPlotInfo = CheckGetPlotInfoNode(trOp, nGraphIndex, nPicRow, nPicCol);
				TreeNode trPlotInfo = CheckGetPlotInfoNode(trOp, nGraphIndex, nPicRow, nPicCol, nPlotIndex);
				///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
				///end NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
				if(trPlotInfo)
				{
					int nResultTableID = trPlotInfo.TableID.nVal;
					if( nResultTableID > 0 )
					{
						int nPlotType = trPlotInfo.PlotType.nVal;
						int nIndexBegin = trPlotInfo.DataIndex.From.nVal;
						int nIndexEnd = trPlotInfo.DataIndex.To.nVal;
						if(nPlotType == IDM_PLOT_HISTOGRAM_TYPE || nPlotType == IDM_PLOT_BOX)
						{
							for( int nDataIndex = nIndexBegin; nDataIndex <= nIndexEnd; nDataIndex++ )
							{	
								nHistOrBoxIndex++;
								DataRange drTable;
								if(!GetResultTableData(trOp, nResultTableID, nDataIndex, nGraphIndex, drTable))
									return false;
									
								PutTempStatsTreeNode(trOp, drTable, nHistOrBoxIndex, nGraphIndex);
							}
						}
					}
				}
				///end FITTING_HISTOGRAM_PLOT
				
				/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
				//addOneGraphPicture(CREATE_GRAPH_CREATE_FOR_REPORT, trOp, trImage, nGraphIndex, nPicRow, nPicCol, rgReportSheetOutput);
				//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
				//if( addOneGraphPicture(CREATE_GRAPH_CREATE_FOR_REPORT, trOp, trImage, nGraphIndex, nPicRow, nPicCol, rgReportSheetOutput, &dwGraphUID) )
				/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
				//if( addOneGraphPicture(CREATE_GRAPH_CREATE_FOR_REPORT, trOp, trImage, nGraphIndex, nPicRow, nPicCol, rgReportSheetOutput, &dwGraphUID, bResetGraphs) )
				if( addOneGraphPicture(CREATE_GRAPH_CREATE_FOR_REPORT, trOp, trImage, nGraphIndex, nPicRow, nPicCol, nPlotIndex, rgReportSheetOutput, &dwGraphUID, bResetGraphs) )
				///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
				//------
				{
					///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
					//if( !IsPlotAllPlotsInOneGraph(trOp) && dwGraphUID )
					/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
					//if( !IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) && dwGraphUID )
					if( dwGraphUID && (!IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) || IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) && 0 == nPlotIndex) )
					///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
					///end 	UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
					{
						TreeNode 	trOnePic = trImage.GetNode( _get_picture_tag_name(nPicCol, false) );
						if(trOnePic)
						{
							putGraphUIDToReportTree(trOnePic, dwGraphUID);
							updateAxesTitleOnReportGraphLabel(trOp, nGraphIndex, trGraph, nPicRow, nPicCol, nPlotIndex, dwGraphUID); /// Iris 9/14/2009 QA80-11710-S1 PUT_REPORT_GRAPH_LABEL_AS_Y_AXES_TITLE
						}						
					}
				}
				else
				{
					/// Iris 7/02/2008 FIX_SHOW_HIDDEN_GRAPH_WHEN_ANOVA_1WAY_FAIL_TO_CLAC_MEANS_COMP
					TreeNode 	trPic = trImage.GetNode( _get_picture_tag_name(nPicCol, false) );
					if( trPic )
						trPic.strVal = STR_ERRINFO_OF_REPORT_GRAPH_FAILURE;	
					///end FIX_SHOW_HIDDEN_GRAPH_WHEN_ANOVA_1WAY_FAIL_TO_CLAC_MEANS_COMP
				}
				///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
			} /// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA			
	
			///Arvin 02/05/07 SET_BIN_DATA_WITH_SAME_MIN_MAX_AND_BINSIZE_WHEN_PLOT_ALL_HISTOGRAM_IN_ONE_GRAPH
			//Link layers' x to one of the first layer
			///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
			//if(IsPlotAllPlotsInOneGraph(trOp) && dwGraphUID >= 0)  
			if(IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) && dwGraphUID >= 0)  
			///end 	UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
			{				
				GraphPage gp;
				gp = Project.GetObject(dwGraphUID);
				//Link layers' x to one of the first layer
				int		nNumLayers = GetNumberLayersInOneGraph(trOp, nGraphIndex);
				if(nNumLayers > 1)
				{
					double dMin, dMax, dBinSize;
					///Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
					//GetCombinedMinMaxAndBinNumber(trOp, dMin, dMax);
					_get_all_layers_X_min_max(gp, nNumLayers, dMin, dMax);
					///end SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
					RoundLimits(&dMin, &dMax, &dBinSize);
					setGraphLayerXScale(gp, 0, dMin, dMax); 
					_link_x_to_base_layer(gp, nNumLayers, 0);
					/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
					//int		nRows = GetReportGraphTableRowNum(trOp, nGraphIndex);
					//int		nCols = GetReportGraphTableColNum(trOp, nGraphIndex);
					//page_arrange_layers(gp, nRows, nCols);
					arrangeReportGraphLayers(trOp, nGraphIndex, gp, nNumLayers);
					///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
				}
				///Arvin 06/21/07 WRONG_BORDER_AND_FILL_COLOR_FOR_BOX_CHART
				//Fill color of Box chart should be none, and border color should changes automaticly
				if(ReportGetPlotTypeFromGraphIndex(nGraphIndex) == IDM_PLOT_BOX)
				{
					GraphLayer gl = gp.Layers();
					gl.UngroupPlots();
					int iColor = 0;
					foreach(DataPlot dp in gl.DataPlots)
					{
						Tree tr;
						tr = dp.GetFormat(FPB_STYLE_COLOR, FOB_ALL, true, true);
						TreeNode trColor = tr.Root.Pattern.Border.Color;
						if(trColor)
						{
							trColor.nVal = iColor++;
							dp.ApplyFormat(tr, true, true);
		
						}
					}
				}
				///end WRONG_BORDER_AND_FILL_COLOR_FOR_BOX_CHART				
			}
			///end SET_BIN_DATA_WITH_SAME_MIN_MAX_AND_BINSIZE_WHEN_PLOT_ALL_HISTOGRAM_IN_ONE_GRAPH
		}
	}
	
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	/*
	/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
	//if( IsPlotAllPlotsInOneGraph(trOp) && dwGraphUID >= 0 )
	if( IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) && dwGraphUID >= 0 )
	///end 	UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
	{	
		///Arvin 08/06/07  QA70-10024  ADD_EMPTY_LABEL_ROW_FOR_PLOT_ALL_IN_ONE_GRAPH
		//TreeNode trPics = trGraph.FirstNode;
		TreeNode trPics = trGraph.LastNode;
		///end ADD_EMPTY_LABEL_ROW_FOR_PLOT_ALL_IN_ONE_GRAPH
		if(trPics)
		{
			TreeNode trOnePic = trPics.FirstNode;
			if(trOnePic)
			{
				putGraphUIDToReportTree(trOnePic, dwGraphUID);
			}
		}	
	}
	///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	*/
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	
	//---- CPY 8/25/05 REDUCE_NUMBER_OF_SET_REPORT_TREE_CALLS
	// moved to outside of loop
	/*
	tree_set_attribute_to_all_nodes(trOp.Calculation, STR_ENABLE_ATTRIB, "0", true);
	trGraph.RemoveAttribute(STR_ENABLE_ATTRIB);
	wksReport.SetReportTree(trOp.Calculation);
	tree_remove_attribute(trOp.Calculation, STR_ENABLE_ATTRIB);
	*/
	trGraph.RemoveAttribute(STR_ENABLE_ATTRIB);
	//----
	return true;
}

///Arvin 02/13/07 SET_BIN_DATA_WITH_SAME_MIN_MAX_AND_BINSIZE_WHEN_PLOT_ALL_HISTOGRAM_IN_ONE_GRAPH
void 	WksReportOperation::setGraphLayerXScale(GraphPage& gp, int nLayerIndex, double dxMin, double dxMax)
{
	GraphLayer gl = gp.Layers(nLayerIndex);
	if(gl)
	{
		gl.X.From = dxMin;
		gl.X.To = dxMax;
	}
}
///end SET_BIN_DATA_WITH_SAME_MIN_MAX_AND_BINSIZE_WHEN_PLOT_ALL_HISTOGRAM_IN_ONE_GRAPH

// reutrn false only if creation error
//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
//bool WksReportOperation::addGraphsToReport(TreeNode& trOp, Worksheet& wksReport, DataRange& rgReportSheetOutput)
/// virtual
bool WksReportOperation::addGraphsToReport(TreeNode& trOp, Worksheet& wksReport, DataRange& rgReportSheetOutput, bool bResetGraphs/* = false*/)
//------
{
	//---- CPY 8/25/05 REDUCE_NUMBER_OF_SET_REPORT_TREE_CALLS
	// moved from inside of loop
	int nErrGraph = -1;
	tree_set_attribute_to_all_nodes(trOp.Calculation, STR_ENABLE_ATTRIB, "0", true);
	//----
	
	for(int nGraph = 0; nGraph < GetNumGraphs(); nGraph++)
	{
		TreeNode trGraph = GetGUIGraphNodes(trOp, nGraph);
		bool bCreateGraph = IsCreateReportGraph(trOp, nGraph);  /// Iris 9/29/05 CHECK_CREATE_THIS_GRAPH_OR_NOT
		if(trGraph && bCreateGraph)
		{			
			//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
			//if(!addOneGraphTypeToReport(wksReport, rgReportSheetOutput, trOp, nGraph))
			if(!addOneGraphTypeToReport(wksReport, rgReportSheetOutput, trOp, nGraph, bResetGraphs))
			//------
			{
				nErrGraph = nGraph;
				break;
			}
		}			
	}
/// ML 6/30/2006 QA70-8768 BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
#ifndef		__BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
// Since the graphs are not any more in the report, there is no need to call SetReportTree() again.
/// end BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
	//---- CPY 8/25/05 REDUCE_NUMBER_OF_SET_REPORT_TREE_CALLS
	// moved from inside of loop
	if(nErrGraph < 0) // no err
	{
		/// RVD 9/21/2005 QA70-8105 v8.0310 REPLACE_REPORT_COMPLETELY
		trOp.Calculation.RemoveAttribute(TREE_REPLACE);
		/// end REPLACE_REPORT_COMPLETELY
		wksReport.SetReportTree(trOp.Calculation);
	}
/// ML 6/30/2006 QA70-8768 BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
#endif		//  !__BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
/// end BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS

	tree_remove_attribute(trOp.Calculation, STR_ENABLE_ATTRIB);
	if(nErrGraph >= 0)
	{
		string strErr = "addOneGraphTypeToReport failed for graph index = " + (nGraph+1);
		return error_report(strErr);
	}
	//----
	return true;
}

///Iris 4/01/05 FIT_REGRESSION_PLOTS
virtual int WksReportOperation::ConstructGraphNumber()
{
	return 0;
}

/// YuI 06/06/08 QA70-11619 MORE_CLEAR_WORKSHEET_PROBLEM
TreeNode WksReportOperation::GetGUIGraphNodesEx(const TreeNode& trGUI, int nGraphIndex)
{
	/// Iris 11/09/2009 QA81-14599 IMPROVE_STATS_ON_COLS_CALCULATION_SPEED
	// tree_get_node_by_id costs too many times to find graph nodes
	//int nID = IDE_RESULT_GRAPHS + nGraphIndex;
	//return tree_get_node_by_id(trGUI, nID, true);
	TreeNode	trGraph, trParent = OP_GUI_OUTPUT_TABLES_BRANCH(trGUI);
	if( trParent )
	{
		string 		strGraphName = op_get_graph_tag_name(nGraphIndex);
		trGraph = trParent.GetNode(strGraphName);
	}
	return trGraph;
	///END IMPROVE_STATS_ON_COLS_CALCULATION_SPEED	
}
/// end MORE_CLEAR_WORKSHEET_PROBLEM

///Iris 6/03/05 CENTRALIZE_TO_GET_GRAPH_GUI_NODE
TreeNode WksReportOperation::GetGUIGraphNodes(TreeNode& trOp, int nGraphIndex) //= 0
{	
	///Iris 1/18/06 CENTRALIZE_TO_GET_GRAPH_GUI_NODE
	//TreeNode trGraph;
	//if(nGraphIndex<0)
		//return trGraph;
	//
	//string 		strGraphName = op_get_graph_tag_name(nGraphIndex);
	//
	//TreeNode 	trCreate = op_get_optional_tables(trOp.GUI);	
	//trGraph = trCreate? trCreate.GetNode(strGraphName) : trGraph;	
	/// YuI 06/06/08 QA70-11619 MORE_CLEAR_WORKSHEET_PROBLEM
	//	int nID = IDE_RESULT_GRAPHS + nGraphIndex;
	//	TreeNode trGraph = tree_get_node_by_id(trOp.GUI, nID, true);
	TreeNode trGraph = GetGUIGraphNodesEx(trOp.GUI, nGraphIndex);
	/// end MORE_CLEAR_WORKSHEET_PROBLEM
	///End CENTRALIZE_TO_GET_GRAPH_GUI_NODE
	
	return trGraph;		

}

//Arvin 11/15/07 ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
//virtual int WksReportOperation::GetCurveLineColor(const TreeNode& trOp, int nCurveIndex) 
virtual int WksReportOperation::GetCurveLineColor(const TreeNode& trOp, int nCurveIndex, int nDataIndex, bool bIsSourceGraph)
///end ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
{
	TreeNode trCurves = GetGUIGraphNodes(trOp, nCurveIndex);
	///Arvin 10/22/07 ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
	TreeNode trSetColor = trCurves.SetColor;
	///Arvin 02/14/08 QA70-11094-P3 FITTED_CURVES_COLOR_FOLLOW_SOURCE_GRAPH_IF_CHECK_SET_COLOR
	//if(trSetColor && trSetColor.Show && trSetColor.nVal && bIsSourceGraph)
	if(trSetColor && trSetColor.Show && trSetColor.nVal && (bIsSourceGraph || IsPlotAllPlotsInOneGraph(trOp, nCurveIndex)))
	///END FITTED_CURVES_COLOR_FOLLOW_SOURCE_GRAPH_IF_CHECK_SET_COLOR	
	{
		DataPlot 	dp;
		dp = GetSourceDataPlot(nDataIndex, trOp);
		if(dp)
		{
			 BASIC_PLOT_SETTINGS stps;
			 int nType = dp.GetPlotType(NULL, &stps);
			 if(nType >= IDM_PLOT_LINE && nType <= IDM_PLOT_LINESYMB)
			 	return nType==IDM_PLOT_SCATTER? stps.nEdgeColor : stps.nLineColor; 		
       }
	}
	///end ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
	
	if(trCurves.IsValid() && trCurves.CurveColor.IsValid())
		return trCurves.CurveColor.nVal;
	
	///Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
	///Arvin 02/14/08 QA70-11094-P3 FITTED_CURVES_COLOR_FOLLOW_SOURCE_GRAPH_IF_CHECK_SET_COLOR
	//If from worksheet, all fitted curves are red as max said.
	//if(IsPlotAllPlotsInOneGraph(trOp, nCurveIndex))
	//	return SYSCOLOR_RED+nDataIndex;
	///end FITTED_CURVES_COLOR_FOLLOW_SOURCE_GRAPH_IF_CHECK_SET_COLOR
	///end SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL	
	
	/// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	//return -1;
	return SYSCOLOR_RED; //red for default
	///end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
}
///end CENTRALIZE_TO_GET_GRAPH_GUI_NODE

/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
//void WksReportOperation::SetOneOutputBookSheetDefaultName(TreeNode& trGUI, TreeNode& trBookSheetBranch, bool bIsBook, LPCSTR lpcszDefault)
void WksReportOperation::SetOneOutputBookSheetDefaultName(TreeNode& trGUI, TreeNode& trBookSheetBranch, bool bIsBook, LPCSTR lpcszDefault, int nIndex)
/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
{
	if( !trBookSheetBranch )
		return;
	
	TreeNode	trType = bIsBook? trBookSheetBranch.Book : trBookSheetBranch.Sheet;
	/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
	//TreeNode	trName = bIsBook? trBookSheetBranch.BookName : trBookSheetBranch.SheetName;	
	TreeNode	trName = bIsBook? trBookSheetBranch.BookName : GetSheetNameNode(trBookSheetBranch, nIndex);	
	/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
	if( !trName || ! trType)
		return;	
	
	string		strDefault(lpcszDefault);	
	trName.RemoveAttribute(	STR_DEFAULT_ATTRIB );	
	if( !strDefault.IsEmpty() )
	{
		trName.SetAttribute(STR_DEFAULT_ATTRIB, strDefault);
	}
	
	if( !trType.IsEmpty() && PDS_NEW == str_to_predefined_type(trType.strVal))
	{
		if( trName.IsEmpty() )
		{
			if( !strDefault.IsEmpty() )
				trName.strVal = strDefault;
		}
		else //from theme
		{
			// do nothing
		}					
	}	
}

//virtual
void WksReportOperation::SetOutputBookSheetDefaultName(TreeNode& trGUI)
{
	SetOneOutputBookSheetDefaultName(trGUI, trGUI.Output.Report, true, GetResultBookName(trGUI));	
	SetOneOutputBookSheetDefaultName(trGUI, trGUI.Output.Report, false, GetResultSheetName(trGUI));
	
	TreeNode	trOperation = trGUI.Parent();
	bool 		bSeparateSheetForDataset = IsSeparateSheetForDataset(trOperation);
	/// Iris 4/11/2008 SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
	//SetOneOutputBookSheetDefaultName(trGUI, trGUI.Output.Data, true, GetResultCurveBookFullName(trOperation, 0, OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, bSeparateSheetForDataset));
	//SetOneOutputBookSheetDefaultName(trGUI, trGUI.Output.Data, false, GetResultCurveSheetFullName(trOperation, 0, OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET));
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//SetOneOutputBookSheetDefaultName(trGUI, trGUI.Output.Data, true, GetResultCurveBookShortName(trOperation, 0, OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET));
	//SetOneOutputBookSheetDefaultName(trGUI, trGUI.Output.Data, false, GetResultCurveSheetFullName(trOperation, 0, OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET));
	TreeNode trData = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
	SetOneOutputBookSheetDefaultName(trGUI, trData, true, GetResultCurveBookShortName(trOperation, 0, OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET));
	SetOneOutputBookSheetDefaultName(trGUI, trData, false, GetResultCurveSheetFullName(trOperation, 0, OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET));
	///end OP_DLG_NEW_STRUCTURE
	///end SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK

}
///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME

#ifdef OP_DLG_TOTALLY_NEW_STRUCTURE
//virtual
void WksReportOperation::ConstructAddReportGraphsOptions(TreeNode& trOp, DWORD dwOptions)
{
	TreeNode trGUI = trOp.GUI;
	
	// Add Report Graph Settings node
	{
	GETN_USE(trGUI)
	
		GETN_BEGIN_BRANCH(Plots, _L("Plots"))
		
			GETN_BEGIN_BRANCH(GraphInResultSheet, STR_REPORT_GRAPH_SETTINGS)
			
		GETN_STR(Template, _L("Template"), "") GETN_ID(IDE_REPORT_GRAPH_TEMPLATE) // default keep empty to use build-in report template.
		
				GETN_BEGIN_BRANCH(GraphSettings, STR_OUTPUT_GRAPH_ARRANGMENT)
					tree_construct_add_plot_settings(_tmpSubNode, dwOptions);
				GETN_END_BRANCH(GraphSettings)
		
				if(trGUI.Plots.GraphInResultSheet.GraphSettings.GetNodeCount() == 0)
					trGUI.Plots.GraphInResultSheet.GraphSettings.Remove();
				
			GETN_END_BRANCH(GraphInResultSheet)			
		
		GETN_END_BRANCH(Plots)	
	}
	
	// Add Report Graph CheckBox Nodes
	tree_construct_add_graph_options(trGUI.Quantities, ConstructGraphNumber(), dwOptions);
	UpdateReportGraphsLabels(trOp);
}
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE

///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
void WksReportOperation::UpdateReportGraphsLabels(TreeNode& trOp)
{
	for(int nGraph = 0; nGraph<ConstructGraphNumber(); nGraph++)
	{
		TreeNode trGraph = GetGUIGraphNodes(trOp, nGraph);  
		if(trGraph)
		{
			string str;
			if ( GetCustomGraphTypeName(str, nGraph) )
				trGraph.SetAttribute(STR_LABEL_ATTRIB, GetLocalized(str));
		}
	}
}
///end OP_DLG_NEW_STRUCTURE

//virtual 
//void WksReportOperation::ConstructAddReportCommon(TreeNode& trGUI, DWORD dwOptions, int nID, bool bAddCommon)
void WksReportOperation::ConstructAddReportCommon(TreeNode& trOp, DWORD dwOptions, int nID, bool bAddCommon)
{
	if(bAddCommon)
	///Kevin 08/31/05 REMOVE_CUSTOM_TABLE_FROM_DEFAULT_REPORT_TABLE
	// /// ML 10/20/2004 QA70-7075 MASKED_DATA_REPORTING
	// //	dwOptions |= REPORT_NOTES | REPORT_INPUT | REPORT_MASKED_DATA | REPORT_CUSTOM_TABLE1;
	//	dwOptions |= REPORT_NOTES | REPORT_INPUT | REPORT_MASKED_DATA | REPORT_MISSING_DATA | REPORT_CUSTOM_TABLE1;
	// /// end MASKED_DATA_REPORTING
	dwOptions |= REPORT_NOTES | REPORT_INPUT | REPORT_MASKED_DATA | REPORT_MISSING_DATA;
	///End REMOVE_CUSTOM_TABLE_FROM_DEFAULT_REPORT_TABLE
	TreeNode trGUI = trOp.GUI;
	/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	//tree_construct_add_report_branch(trGUI, dwOptions, nID, GetResultCurvesID(), ConstructGraphNumber());
	///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH, add FindXY output branch 
	//_tree_construct_add_report_branch(trGUI, dwOptions, nID, GetResultCurvesID(), GetResidualCurvesID(), ConstructGraphNumber());
	_tree_construct_add_report_branch(trGUI, dwOptions, nID, GetResultCurvesID(), GetResidualCurvesID(), GetPartialCurvesID(), GetFindXYID(), ConstructGraphNumber());//temp
	///End MODIFICATION_OUTPUT_BRANCH
	///end REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET		

	///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	/*
	for(int nGraph = 0; nGraph<ConstructGraphNumber(); nGraph++)
	{
		TreeNode trGraph = GetGUIGraphNodes(trOp, nGraph);  
		if(trGraph)
		{
			string str;
			if(GetCustomGraphTypeName(str, nGraph))  
				//------ Folger 12/03/07 LOCALIZE_GRAPH_TYPE_STRING  
				//trGraph.SetAttribute(STR_LABEL_ATTRIB, str);
				trGraph.SetAttribute(STR_LABEL_ATTRIB, GetLocalized(str));
				//------
			
			///Iris 10/08/05 ADD_OUT_GRAPH_WHEN_PREPARE_GRAPH_NODES
			//move to PrepareGraphNodes fucntion since need call this again when click change parameter 
			//to open dailog to check or uncheck one special graph
			//constructAddOutputGraph(trOp, nGraph);  ///Iris 01/20/05 CLEANUP_CONSTRUCT_ADD_GRAPH
			///End ADD_OUT_GRAPH_WHEN_PREPARE_GRAPH_NODES
		}
	}
	*/
#ifndef OP_DLG_TOTALLY_NEW_STRUCTURE
	UpdateReportGraphsLabels(trOp);
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE
	///end OP_DLG_NEW_STRUCTURE
	/// Iris 4/16/2008 CENTRLIZE_SET_DEFAULT_VALUES_CODES
	// Logic moved to DescStatsOutputGUIManager::GetOutputDestinationDefaultSetting
	//int nOption = GetOptionIndex(trGUI);
	//if(IsEnableInsertResultColumnsToSourceData(nOption))
	//{
		////trGUI.Output.Report.InsertColsDataSheet.nVal = 1;
		//trGUI.Output.Report.Book.strVal = STR_SOURCE_BOOK;
		////---- Iris 10/30/06 STATS_ON_ROWS_FAIL_TO_REPORT_INTP_SOURCE
		////trGUI.Output.Report.Sheet.strVal = STR_NEW;//STR_INSERT_SOURCE_SHEET;///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH, remove <source>, for report table shouldn't add to datasheet
		//trGUI.Output.Report.Sheet.strVal = STR_INSERT_SOURCE_SHEET;
		////---- 
		//
	//}
	///end CENTRLIZE_SET_DEFAULT_VALUES_CODES
}

//------ end ADD_BOX_CHART_TO_DESC_STATS

//---- CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH

/// YuI 11/08/06 OPERATION_TREE_NEED_TO_BE_UPDATED_FROM_INPUT
void	WksReportOperation::GetTree(TreeNode& trOperation)
{
	Operation::GetTree(trOperation);
	TreeNode trGUI = trOperation.GUI;
	TreeNode trInputData;
	if( trGUI.IsValid() )
		trInputData = trGUI.InputData;
	
	if( trInputData )
	{			
		DataRange drInInputDataTree;
		uint uidInputDataRange;
		drInInputDataTree = get_data_range_from_input_data(trInputData, uidInputDataRange);
		/// ML 10/2/2007 QA70-10428 UPDATING_GUI_TREE_ANOVA_RM_PROPERLY
		//if( drInInputDataTree )
		TreeNode	trRelevant;
		GetRelevantInputDataTreeNode(trOperation, trRelevant, trInputData);
		if( drInInputDataTree && trRelevant.IsValid() )
		/// end UPDATING_GUI_TREE_ANOVA_RM_PROPERLY
		{

			Tree trRange;
			drInInputDataTree.GetTree(trRange, GetDRTreeOption(trOperation));
			/// ML 3/16/2007 WRONG_ORDER_OF_ARGS
			//octree_copy_values(&trRange, &trInputData, 0); 
			/// YuI 09/10/07 QA70-10358 ANOVA_RECALCULATE_FAILS_AFTER_RENAME
			// the mechanism of copying values by order and name works well for operations other than ANOVA
			// for anova inputData tree contains names such as "Factor", "Subject", while polyrange has "F" and "SU"
			// so copying by name naturally fails, we have to copy by order only
			// so virtual function GetDWCTRLForUpdateInputDataTree overriden in ANOVA operations is used
			//	octree_copy_values(&trRange, &trInputData, TREE_COPY_BY_NAME_AND_ORDER);
			/// ML 10/2/2007 QA70-10428 UPDATING_GUI_TREE_ANOVA_RM_PROPERLY
			//octree_copy_values(&trRange, &trInputData, GetDWCTRLForUpdateInputDataTree());
			octree_copy_values(&trRange, &trRelevant, GetDWCTRLForUpdateInputDataTree());
			/// end UPDATING_GUI_TREE_ANOVA_RM_PROPERLY
			/// end ANOVA_RECALCULATE_FAILS_AFTER_RENAME
			/// end WRONG_ORDER_OF_ARGS
		}
	}
}
/// end OPERATION_TREE_NEED_TO_BE_UPDATED_FROM_INPUT

//virtaul
///Arvin 10/16/06 MOVE_TO_OPERATION_FILE
void	WksReportOperation::SetTree(TreeNode& trOperation)
{
	TreeNode trGUI = trOperation.GUI;
	/// YuI 01/03/2005 v7.5183 QA70-7253 VECTORIAL_NUMERIC_FUNCTIONS
	//	TreeNode	trInputData = trGUI.InputData;
	TreeNode	trInputData;
	if( trGUI.IsValid() )
		trInputData = trGUI.InputData;
	/// end VECTORIAL_NUMERIC_FUNCTIONS
	if(trInputData)
	{			
		uint uidInputDataRange = 0;
		string strTemp;
		
		
		///YuI 11/11/04
		/*
		if(trInputData.GetAttribute(STR_DATARANGE_UID_ATTRIB, strTemp))
			uidInputDataRange = atoi(strTemp);
		*/
		/// YuI 08/14/06
		TreeNode trResolvedData;
		/// YuI 09/27/06 TWO_WAY_ANOVA_TREE_RESOLUTION_SCREWUP
		/*
		if( okxf_resolve_composite_range_tree(&trResolvedData, &trInputData) )
		{
			trInputData.Replace(trResolvedData, TRUE, TRUE, TRUE);
		}
		*/
		TreeNode trRelevant;
		GetRelevantInputDataTreeNode(trOperation, trRelevant, trInputData);
		if( okxf_resolve_composite_range_tree(&trResolvedData, &trRelevant) )
		{
			trRelevant.Replace(trResolvedData, TRUE, TRUE, TRUE);
		}
		/// end TWO_WAY_ANOVA_TREE_RESOLUTION_SCREWUP
		/// end YuI
		
		DataRange drInInputDataTree;
		drInInputDataTree = get_data_range_from_input_data(trInputData, uidInputDataRange);
		/// end YuI
		
		DataRange	irng;
		GetInput(irng);
		if( !irng )
		{
			/// YuI 11/11/04
			/*
			//---CPY 10/20/04 SAVE_SEL_RANGE_TO_INPUT_DATA
			//irng.Create(trInputData, FALSE);
			if(uidInputDataRange)
			{
				irng = (DataRange)Project.GetObject(uidInputDataRange);
				if(!irng)
					error_report("DataRange UID stored in InputData is bad");
			}
			//if(!irng)
			//	irng.Create(trInputData, FALSE);
			//----
			//	Project.AddDataRange(irng); 
			if( irng ) // YuI 10/27/04
				SetInput(irng, 0); // Only one input object:
			*/
			if( drInInputDataTree )
			{
				/// ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE
				//drInInputDataTree.SetTree(trInputData, FALSE);				
				drInInputDataTree.SetTree(trInputData, GetDRTreeOption(trOperation));				
				/// end ANOVA_INPUT_DATA_TO_DATARANGE
				SetInput(drInInputDataTree, 0);
			}
			/// end YuI
		}
		else
		{
			if(uidInputDataRange)
			{
				uint uidInputRange = irng.GetUID();
				if(uidInputDataRange != uidInputRange)
					error_report("Operation::SetTree found GetInput gives diff DataRange then InputData tree");
			}
			
			/// ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE
			//irng.SetTree(trInputData, FALSE);
			irng.SetTree(trInputData, GetDRTreeOption(trOperation));
			/// end ANOVA_INPUT_DATA_TO_DATARANGE
		}
	}
	///---- Arvin 10/16/06 MOVE_TO_OPERATION_FILE
	//trOperation.Operation.UID.nVal = GetUID(TRUE);
	//OperationBase::SetTree(trOperation);
	Operation::SetTree(trOperation);
	///----
}
///MOVE_TO_OPERATION_FILE

/// Iris 9/17/05 QA70-8015-P15 OUTPUT_RESULT_CURVE_TO_WKS
//bool	WksReportOperation::InsertReportToSourceWks(TreeNode& trOp, TreeNode& trReport, Worksheet& wksInput, int nInsertCol, DataRange& rngOutput)
bool	WksReportOperation::InsertReportToWks(TreeNode& trOp, TreeNode& trReport, Worksheet& wksInput, int nInsertCol, DataRange& rngOutput)
///End OUTPUT_RESULT_CURVE_TO_WKS
{
	Tree trTemp;
	trTemp = trReport;
	octree_delete_nodes_by_attribute(&trTemp, STR_SHOW_ATTRIB, false);
	
	int nTableBits;
	trTemp.GetAttribute(TREE_Table, nTableBits);
	nTableBits &= ~(GETNBRANCH_HIDE_COL_HEADINGS | GETNBRANCH_HIDE_ROW_HEADINGS | GETNBRANCH_HIDE_COL_LABELS | GETNBRANCH_HIDE_ROW_LABELS);
	trTemp.SetAttribute(TREE_Table, nTableBits);

	/// ML 10/19/2005 STATS_ON_ROWS_REPLACE
	int		dwCtrl2 = 0;
	if( trTemp.GetAttribute(TREE_UID, dwCtrl2) && dwCtrl2 > 0 )
		trTemp.SetAttribute(TREE_REPLACE, "1");
	/// end STATS_ON_ROWS_REPLACE		
	//------ CPY 11/02/08 QA70-12480-P4 STATS_ON_ROWS_PUT_LN_INTO_1ST_LABEL_ROW_WHICH_COULD_BE_UNITS
	//wksInput.SetReportTree(trTemp, nInsertCol);
	wksInput.SetReportTree(trTemp, nInsertCol, SETGRTR_USE_STATIC_LABEL_ROW_POS);// tell internal code that label row index should follow default type assignment
	//------
	
	AfterDoReport(wksInput, OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET);	//------ Folger 05/22/08 QA80-11574 SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
	
	/// ML 10/19/2005 STATS_ON_ROWS_REPLACE
	//int dwCtrl2;
	/// end STATS_ON_ROWS_REPLACE
	trTemp.GetAttribute(TREE_UID, dwCtrl2);
	OriginObject obj;// = Project.GetObject(dwCtrl2);
	obj = Project.GetObject(dwCtrl2);
	rngOutput = obj;
	if(obj)
	{
		trReport.SetAttribute(TREE_UID, dwCtrl2);
		return true;
	}
	return false;
}

/// ML 8/15/2006 ATTACHING_GRAPHS_TO_CELLS_IN_OPERATION
/// YuI 03/13/09 QA70-13281 TAGGING_AVECURVES_RESULTS_TO_EXCLUDE_THEM_FROM_FUTURE_AVERAGING
/*
static  void _TagDataObject(DataObject & dobj, LPCSTR lpcszTag)
{
	if(dobj)
	{
		DatasetObject ds(dobj);
		if(ds)
			ds.Info.SYSTEM.PARAMETERS.TAG$ = lpcszTag;
		
	}
}

static void _tagOutputCols(DataRange &rg, LPCSTR lpcszTag)
{
	if(!rg || !lpcszTag)
		return;
	Datasheet dsRange;
	int r1, r2, c1, c2;
	r1=r2=c1=c2=0;
	int nSubRanges = rg.GetNumData();
	for(int ii = 0; ii < nSubRanges; ii ++)
	{
		if(rg.GetRange(ii, r1, c1, r2, c2, dsRange))
		{
			Worksheet wks = dsRange;
			if(wks)
			{
				for(int nCol = c1; nCol <= c2; nCol++)
				{
					Column col(wks, nCol);
					_TagDataObject(col, lpcszTag);
				}
			}
			MatrixLayer mlayer = dsRange;
			if(mlayer)
			{
				for(int nCol = c1; nCol <= c2; nCol++)
				{
					MatrixObject mobj(mlayer, nCol);
					_TagDataObject(mobj, lpcszTag);
				}
			}
			
		}

	}
	
	
	
}
*/

static void _tagOutputCols(DataRange &rg, LPCSTR lpcszTag)
{
	tag_columns_in_data_range(rg, lpcszTag);
}
/// end TAGGING_AVECURVES_RESULTS_TO_EXCLUDE_THEM_FROM_FUTURE_AVERAGING

/// YuI 03/13/09 QA70-13281 TAGGING_AVECURVES_RESULTS_TO_EXCLUDE_THEM_FROM_FUTURE_AVERAGING
void	op_tag_output_cols(DataRange &rg, LPCSTR lpcszTag)
{
	_tagOutputCols(rg, lpcszTag);
}
/// end TAGGING_AVECURVES_RESULTS_TO_EXCLUDE_THEM_FROM_FUTURE_AVERAGING

/// YuI 10/11/06 USE_CLONE_OF_CALCULATIONS_TO_GENERATE_REPORT
///Arvin 02/09/07 SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
//DWORD 	WksReportOperation::FilterAndGenerateReport(Datasheet& ds, TreeNode& trReport, int nNumInHeading, BOOL bCheckIDRange)

/// Iris 2/02/2010 QA81-14994 FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
void 	WksReportOperation::filterReportEx(TreeNode& trReport, TreeNode& trReportClone, BOOL bCheckIDRange, BOOL bHierarchy)
{
	/// Hong 08/13/09 QA80-14138 REDUCE_OPERATION_SIZE_OF_STATS_ON_COLS
#ifdef		__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__
	/// Hong 12/11/09 QA80-14138-P2 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
	///// Iris 9/03/2009 QA80-14138 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_MISSING_TABLE
	///*
	//TreeNode trReportClone;
	//if ( isFilterNeedCloneTree() )
		//trReportClone = trReport.Clone();
	//else
		//trReportClone = trReport;
	//*/
	//if ( isResetHiddenTable() ) // need rename to isResetHiddenTable, default return false, but return true for stats on col.
	//{
		//foreach(TreeNode trTable in trReport.Children)
		//{
			//if( !trTable.Show )
				//trTable.Reset(true);
		//}
	//}
	//TreeNode trReportClone = trReport.Clone();
	/////end FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_MISSING_TABLE
	//TreeNode 	trReportClone;
	/// Hong 01/19/10 QA80-14988-P1 FIX_EMPTY_TABLE_SHOWN_WHEN_EXPAND_REPORT_SHEET
	//bool		bCloneTree = isFilterNeedCloneTree();
	//if ( bHierarchy && !bCloneTree )
	bool		bNoNeedCloneTree = bHierarchy && !isFilterNeedCloneTree();
	if ( bNoNeedCloneTree )
	/// end FIX_EMPTY_TABLE_SHOWN_WHEN_EXPAND_REPORT_SHEET
		trReportClone = trReport;
	else
		trReportClone = trReport.Clone();
	/// end FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
#else		//__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__
	/// end REDUCE_OPERATION_SIZE_OF_STATS_ON_COLS
	TreeNode trReportClone = trReport.Clone();
#endif		//__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__ /// Hong 08/13/09 QA80-14138 REDUCE_OPERATION_SIZE_OF_STATS_ON_COLS
	/// ML 12/5/2007 QA70-10780 DBG_TREES_IN_RELEASE
	if ( bHierarchy )
		okutil_dbg_tree_save(GLBDBG_GENERATEREPORT_FILTERING, NULL, &trReportClone, "FAGR_B.xml");
	/// end DBG_TREES_IN_RELEASE
	
	/// Iris 9/10/2009 QA80-14279 KEEP_MISSING_DATA_TABLE_EVENT_EMPTY
	//filterReport(trReportClone, bCheckIDRange);
	/// Hong 12/11/09 QA80-14138-P2 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
	//filterReport(trReportClone, bCheckIDRange, bHierarchy);
	/// Hong 01/19/10 QA80-14988-P1 FIX_EMPTY_TABLE_SHOWN_WHEN_EXPAND_REPORT_SHEET
	//filterReport(trReportClone, bCheckIDRange, bHierarchy, !bCloneTree);
	filterReport(trReportClone, bCheckIDRange, bHierarchy, bNoNeedCloneTree);
	/// end FIX_EMPTY_TABLE_SHOWN_WHEN_EXPAND_REPORT_SHEET
	/// end FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
	///end KEEP_MISSING_DATA_TABLE_EVENT_EMPTY
	
	/// Hong 01/19/10 QA80-14988-P1 FIX_EMPTY_TABLE_SHOWN_WHEN_EXPAND_REPORT_SHEET
#ifdef		__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__
	if ( bNoNeedCloneTree )
	{
		TreeNode		trClose = trReportClone.Clone();
		filterReport(trClose, bCheckIDRange, bHierarchy);
		trReportClone = trClose;
	}
#endif		//__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__
	/// end FIX_EMPTY_TABLE_SHOWN_WHEN_EXPAND_REPORT_SHEET
	
	/// ML 12/5/2007 QA70-10780 DBG_TREES_IN_RELEASE
	if ( bHierarchy )
		okutil_dbg_tree_save(GLBDBG_GENERATEREPORT_FILTERING, NULL, &trReportClone, "FAGR_A.xml");
	/// end DBG_TREES_IN_RELEASE	
}

DWORD WksReportOperation::generateReportEx(Datasheet& ds, TreeNode& trReport, TreeNode& trReportClone, int nNumInHeading, bool bHierarchy, int nOutputOption)
{
	///Arvin 02/09/07 SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
	//DWORD dwReportUID = GenerateReport(ds, trReportClone, nNumInHeading);
	//------ Folger 05/22/08 QA80-11574 SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
	//DWORD dwReportUID = GenerateReport(ds, trReportClone, nNumInHeading, bHierarchy);
	DWORD dwReportUID = generateReport(ds, trReportClone, nNumInHeading, bHierarchy, nOutputOption);
	//------
	///end  SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
	int nReportUID = dwReportUID;
	trReport.SetAttribute(TREE_UID, nReportUID);
	return dwReportUID;
}
///End FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET

//------ Folger 05/22/08 QA80-11574 SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
//DWORD 	WksReportOperation::FilterAndGenerateReport(Datasheet& ds, TreeNode& trReport, int nNumInHeading, BOOL bCheckIDRange,  BOOL bHierarchy)
DWORD 	WksReportOperation::filterAndGenerateReport(Datasheet& ds, TreeNode& trReport, int nNumInHeading, BOOL bCheckIDRange,  BOOL bHierarchy, int nOutputOption)
//------
///end SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
{
	/// Iris 2/02/2010 QA81-14994 FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
	/*
	/// Hong 08/13/09 QA80-14138 REDUCE_OPERATION_SIZE_OF_STATS_ON_COLS
#ifdef		__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__
	/// Hong 12/11/09 QA80-14138-P2 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
	///// Iris 9/03/2009 QA80-14138 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_MISSING_TABLE	
	//TreeNode trReportClone;
	//if ( isFilterNeedCloneTree() )
		//trReportClone = trReport.Clone();
	//else
		//trReportClone = trReport;	
	//if ( isResetHiddenTable() ) // need rename to isResetHiddenTable, default return false, but return true for stats on col.
	//{
		//foreach(TreeNode trTable in trReport.Children)
		//{
			//if( !trTable.Show )
				//trTable.Reset(true);
		//}
	//}
	//TreeNode trReportClone = trReport.Clone();
	/////end FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_MISSING_TABLE
	TreeNode 	trReportClone;
	/// Hong 01/19/10 QA80-14988-P1 FIX_EMPTY_TABLE_SHOWN_WHEN_EXPAND_REPORT_SHEET
	//bool		bCloneTree = isFilterNeedCloneTree();
	//if ( bHierarchy && !bCloneTree )
	bool		bNoNeedCloneTree = bHierarchy && !isFilterNeedCloneTree();
	if ( bNoNeedCloneTree )
	/// end FIX_EMPTY_TABLE_SHOWN_WHEN_EXPAND_REPORT_SHEET
		trReportClone = trReport;
	else
		trReportClone = trReport.Clone();
	/// end FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
#else		//__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__
	/// end REDUCE_OPERATION_SIZE_OF_STATS_ON_COLS
	TreeNode trReportClone = trReport.Clone();
#endif		//__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__ /// Hong 08/13/09 QA80-14138 REDUCE_OPERATION_SIZE_OF_STATS_ON_COLS
	/// ML 12/5/2007 QA70-10780 DBG_TREES_IN_RELEASE
	if ( bHierarchy )
		okutil_dbg_tree_save(GLBDBG_GENERATEREPORT_FILTERING, NULL, &trReportClone, "FAGR_B.xml");
	/// end DBG_TREES_IN_RELEASE
	
	/// Iris 9/10/2009 QA80-14279 KEEP_MISSING_DATA_TABLE_EVENT_EMPTY
	//filterReport(trReportClone, bCheckIDRange);
	/// Hong 12/11/09 QA80-14138-P2 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
	//filterReport(trReportClone, bCheckIDRange, bHierarchy);
	/// Hong 01/19/10 QA80-14988-P1 FIX_EMPTY_TABLE_SHOWN_WHEN_EXPAND_REPORT_SHEET
	//filterReport(trReportClone, bCheckIDRange, bHierarchy, !bCloneTree);
	filterReport(trReportClone, bCheckIDRange, bHierarchy, bNoNeedCloneTree);
	/// end FIX_EMPTY_TABLE_SHOWN_WHEN_EXPAND_REPORT_SHEET
	/// end FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
	///end KEEP_MISSING_DATA_TABLE_EVENT_EMPTY
	
	/// Hong 01/19/10 QA80-14988-P1 FIX_EMPTY_TABLE_SHOWN_WHEN_EXPAND_REPORT_SHEET
#ifdef		__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__
	if ( bNoNeedCloneTree )
	{
		TreeNode		trClose = trReportClone.Clone();
		filterReport(trClose, bCheckIDRange, bHierarchy);
		trReportClone = trClose;
	}
#endif		//__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__
	/// end FIX_EMPTY_TABLE_SHOWN_WHEN_EXPAND_REPORT_SHEET
	
	/// ML 12/5/2007 QA70-10780 DBG_TREES_IN_RELEASE
	if ( bHierarchy )
		okutil_dbg_tree_save(GLBDBG_GENERATEREPORT_FILTERING, NULL, &trReportClone, "FAGR_A.xml");
	/// end DBG_TREES_IN_RELEASE
	///Arvin 02/09/07 SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
	//DWORD dwReportUID = GenerateReport(ds, trReportClone, nNumInHeading);
	//------ Folger 05/22/08 QA80-11574 SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
	//DWORD dwReportUID = GenerateReport(ds, trReportClone, nNumInHeading, bHierarchy);
	DWORD dwReportUID = generateReport(ds, trReportClone, nNumInHeading, bHierarchy, nOutputOption);
	//------
	///end  SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
	int nReportUID = dwReportUID;
	trReport.SetAttribute(TREE_UID, nReportUID);
	*/	
	TreeNode trReportClone;
	filterReportEx(trReport, trReportClone, bCheckIDRange, bHierarchy);
	
	DWORD dwReportUID = generateReportEx(ds, trReport, trReportClone, nNumInHeading, bHierarchy, nOutputOption);
	///End FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
	
	return dwReportUID;
}
/// end USE_CLONE_OF_CALCULATIONS_TO_GENERATE_REPORT

bool	WksReportOperation::doResultsCurveSheet(TreeNode& trOperation,
TreeNode& trCurveBranch, // input /// Iris 9/11/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
//Worksheet& wksInput1stRange,	// input
const Datasheet& dsInput1stRange,	// input
///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
int nIndex,  // input
string& strSheetName,	// output /// Iris 9/11/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
string& strBookName, 	// output /// Iris 9/11/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
int nOption, 			// input /// Iris 9/11/06 SURFACE_FIT_REPORT_MAT_FIT_DATA, for now support OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, OUTPUT_RESULT_CURVE_RESIDUAL_SHEET, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET and OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET
bool bSeparateSheetForDataset, //input, = false /// Iris 01/19/2007 v8.0544 OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT
Worksheet* pwksReport,	// input
///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
//Worksheet* pwksFitCurve	//intput|output ///Jasmine 09/28/06 GET_FITCURVE_OUTPUT_BOOK_NAME
///Arvin 05/24/07 SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
//Datasheet* pdsFitCurve	//intput|output 
Datasheet* pdsFitCurve,	//intput|output 
///Cheney 2007-9-3 QA70-10331 SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
//int nExecMode  //Input
/////END SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
/////end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
int nExecMode,  //Input
bool bRemovePloyRange //input 
///end SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
, int nSheetNameIndex //Input, default value is 0
/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
)
{
	DataRange 	rgResultCurves;
	Worksheet 	wksResultCurves; 
	MatrixLayer mlResultCurves; 
	Datasheet*	pdsResultCurves;
	//----- CPY 10/15/07 XYZ_FITTING_CREATED_WKS_INSTEAD_OF_MAT_BOOK
	//int	nMatrixReport;
	//trCurveBranch.GetAttribute(STR_REPORT_MATRIX_DATA, nMatrixReport);
	int	nMatrixReport = 0;
	///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	//int nn = 0;trCurveBranch.GetAttribute(STR_REPORT_MATRIX_DATA, nn);
	int nOutputType = 0;
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	//trCurveBranch.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType);
	trCurveBranch.GetAttribute(STR_OPERATION_OUTPUT_WND_TYPE, nOutputType);
	///end CLEAN_OUTPUT_WND_TYPE_CODE
	
	//------ Folger 03/12/08 QA80-11244 SURFACE_FIT_REPORT_SHOULD_USE_CONTOUR_PLOTS
	//if(nOutputType)
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	//if ( nOutputType == NLFIT_MATRIX_FITTING )
	if ( nOutputType == EXIST_MATRIX )
	///end CLEAN_OUTPUT_WND_TYPE_CODE
	//------	
	
	///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		nMatrixReport = 1; // I see code making this 1 or 2
	//-----
	
	if(nMatrixReport)
	{
		pdsResultCurves = &mlResultCurves;
	}
	else
	{
		pdsResultCurves = &wksResultCurves;
	}
	
	bool bHasOutput = GetOutput(rgResultCurves, *pdsResultCurves, GetOutputSlot(nIndex, true, nOption));
	
	bool bRemoveColumnFormulaOperations = bRemovePloyRange && bHasOutput && (nOption == OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET || nOption == OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET); ///Cheney 2007-9-3 QA70-10331 SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
	
	if(!bHasOutput)// may already have output sheet
	{
		//GetResultCurveBookSheetName(trOperation, strBookName, strSheetName, nIndex, nOption);
		if(bSeparateSheetForDataset || 0 == nIndex)
			/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
			//GetResultCurveBookSheetName(trOperation, strBookName, strSheetName, nIndex, nOption, bSeparateSheetForDataset);
			GetResultCurveBookSheetName(trOperation, strBookName, strSheetName, nIndex, nOption, bSeparateSheetForDataset, nSheetNameIndex);
			/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
		string	strBookLongName = getResultCurveBookLongName(trOperation, nIndex, nOption, bSeparateSheetForDataset); /// Iris 4/11/2008 SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
		
		bool	bNewResultCurvesBookCreated;
		/// Iris 01/19/2007 v8.0544 OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT
		//if( !PrepareOutput(*pdsResultCurves, wksInput1stRange, trOperation, bNewResultCurvesBookCreated, strSheetName, strBookName, nOption, pwksReport, !nMatrixReport, pwksFitCurve) )	
		///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
		//if( !PrepareOutput(*pdsResultCurves, wksInput1stRange, trOperation, bNewResultCurvesBookCreated, strSheetName, strBookName, bSeparateSheetForDataset, nOption, pwksReport, !nMatrixReport, pwksFitCurve) )	
		/// Iris 4/11/2008 SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
		//if( !PrepareOutput(*pdsResultCurves, dsInput1stRange, trOperation, bNewResultCurvesBookCreated, strSheetName, strBookName, bSeparateSheetForDataset, nOption, pwksReport, !nMatrixReport, pdsFitCurve) )	
		if( !PrepareOutput(*pdsResultCurves, dsInput1stRange, trOperation, bNewResultCurvesBookCreated, strSheetName, strBookName, strBookLongName, bSeparateSheetForDataset, nOption, pwksReport, !nMatrixReport, pdsFitCurve) )	
		///end SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
		///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
		///end OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT
			return error_report("Failed in PrepareOutput for Curve");
		
		///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
		//if(NULL != pwksFitCurve && !pwksFitCurve->IsValid() && 0 == nMatrixReport)
		//{
			//*pwksFitCurve = (Worksheet)*pdsResultCurves; 
		//}
	//}
	//else
	//{
		//Page 	pg = pdsResultCurves->GetPage();
		//if( EXIST_WKS == pg.GetType())
			//pwksFitCurve->Attach(pg.GetName());//need to pass out the pointer of FitCurve sheet to outside
	//}
		///Jasmine 08/29/07 FIT_MAT_ALSO_NEED_GET_FITCURVE_OUTPUT
		//if(NULL != pdsFitCurve && !pdsFitCurve->IsValid() && 0 == nMatrixReport)
		//{
			//*pdsFitCurve = (Worksheet)*pdsResultCurves; 
		if(NULL != pdsFitCurve && !pdsFitCurve->IsValid())
		{
			*pdsFitCurve = *pdsResultCurves; 
		}
		///End FIT_MAT_ALSO_NEED_GET_FITCURVE_OUTPUT
	}
	else
	{
		Page 	pg = pdsResultCurves->GetPage();
		/// Iris 7/23/2009 QA80-14000-P3 FAIL_ADD_RESIDUAL_PLOT_IN_2D_FIT_CHANGE_PARAMETER
		//if( EXIST_WKS == pg.GetType() )
		if( EXIST_WKS == pg.GetType() || EXIST_MATRIX == pg.GetType() )
		///end FAIL_ADD_RESIDUAL_PLOT_IN_2D_FIT_CHANGE_PARAMETER
			pdsFitCurve->Attach(pg.GetName());//need to pass out the pointer of FitCurve sheet to outside
	}
	///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
	///Arvin 05/30/07 v8.0629 ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE 
	//TreeNode trRC = GetResultCurvesBranch(trOperation, nIndex, -1, nOption);
	int nBranchIndex = nIndex;//Get nIndex subnode of corresponding branch
	if(!bSeparateSheetForDataset && !nMatrixReport)
		nBranchIndex = -1; //Get whole corresponding branch 
	
	TreeNode trRC = GetResultCurvesBranch(trOperation, nBranchIndex, -1, nOption);
	///end ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE
	if(!trRC)
		return error_report("Failed to get the treenode of this Result Curve");	
	
	//------ Folger 11/13/08 QA80-12488 v8.970 PA_FITTING_AUTO_UPDATE_SUPPORT_USE_VECTOR_FOR_UIDS_STORAGE
	if ( rgResultCurves )
		trRC.SetAttribute(TREE_UID, (int)rgResultCurves.GetUID());
	//------
		
	///Arvin 02/09/07 SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
	//DWORD dwResultCurvesReportID = FilterAndGenerateReport(*pdsResultCurves, trRC, 0, FALSE);
	//------ Folger 05/22/08 QA80-11574 SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
	//DWORD dwResultCurvesReportID = FilterAndGenerateReport(*pdsResultCurves, trRC, 0, FALSE, FALSE);
	DWORD dwResultCurvesReportID = filterAndGenerateReport(*pdsResultCurves, trRC, 0, FALSE, FALSE, nOption);
	//------
	///end 	SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET	
	
	if(dwResultCurvesReportID)
	{
		// Set the DataRange into the operation:
		///Cheney 2007-9-3 QA70-10331 SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
		//if(!bHasOutput)
		if(!bHasOutput || bRemoveColumnFormulaOperations)
		///end SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
		{
			rgResultCurves = Project.GetObject(dwResultCurvesReportID);
			///Cheney 2007-9-3 QA70-10331 SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
			if(bRemoveColumnFormulaOperations)
				rgResultCurves.RemoveColumnFormulaOperations();
			///end SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
			_tagOutputCols(rgResultCurves, STR_DATASETOBJ_FITCURVE); /// TD 5-18-06 QA70-8664 DATASET_OBJECT_CLASS_IN_OC_MORE_WORK
			SetOutput(rgResultCurves, GetOutputSlot(nIndex, true, nOption));
		}
		
		Page pg;
		pdsResultCurves->GetParent(pg);
		if( EXIST_WKS == pg.GetType())
		{
			Worksheet wksResultCurves(*pdsResultCurves);
			setThemeToResultsCurveSheet(wksResultCurves, dwResultCurvesReportID);
		}
	}
	else
	///Cheney 2007-9-7 SHOULD_JUST_SET_SHOW_AS_FALSE_IF_NOT_CHECK_PLOT_FIT_CURVE
		//error_report("Failed in GenerateWksReport for Curves");
	{
		/// Iris 4/16/2008 QA80-11282 FIX_ANOVA_ONE_WAY_REPORT_EMPTY_CURVE_SHEET
		//error_report("Failed in GenerateWksReport for Curves");
		////should destroy created sheet
		//if(HasZ(trOperation))
		//	pdsResultCurves->Destroy();
		pdsResultCurves->Destroy();
		///END FIX_ANOVA_ONE_WAY_REPORT_EMPTY_CURVE_SHEET
	}
	///end SHOULD_JUST_SET_SHOW_AS_FALSE_IF_NOT_CHECK_PLOT_FIT_CURVE
	
	return true;
}

// Report sheet must be done in two phases:
//	Phase 1. Check/create hier. worksheet, but don't set the tree yet.
//	Phase 2. Finish the report tree (by adding graphs), and set it to the sheet created in phase 1.
// Between the two phases the caller must create the curves sheet.
bool	WksReportOperation::doReportSheet(TreeNode& trOperation,
bool bFirstPhase,
bool bSecondPhase,
int	nNumInHeading,
Worksheet& wksOutput,	// output
///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
//Worksheet& wksInput1stRange,	// input
const Datasheet& dsInput1stRange,	// input
///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
DataRange &rgReportSheetOutput,	// input/output
bool &bNewBookCreated			// output
)
{
	if (bFirstPhase)
	{	
		if(!GetOutput(rgReportSheetOutput, wksOutput))// may already have output sheet
		{
			///Jasmine 09/27/06 PREPARE_OUTPUT_FOR_RESIDUAL
			//if( !PrepareOutput(wksOutput, wksInput1stRange, trOperation, bNewBookCreated, GetResultSheetName(), "Analysis Report 1") )
			/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
			//string	strBookName = "Analysis Report 1";
			///Sophy 5/29/2008 QA80-10934-P10 CORRECT_STATS_ON_ROWS_RESULT_BOOK_NAME
			//string	strBookName = getResultBookNameFromGUI(trOperation.GUI);
			string	strBookName = GetResultBookNameFromGUI(trOperation.GUI);
			///end CORRECT_STATS_ON_ROWS_RESULT_BOOK_NAME
			///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
			
			/// Iris 05/08/2007 v8.0613 PROPER_REPORT_SHEET_NAME
			/////Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
			////if( !PrepareOutput(wksOutput, wksInput1stRange, trOperation, bNewBookCreated, GetResultSheetName(), strBookName) )
			//if( !PrepareOutput(wksOutput, dsInput1stRange, trOperation, bNewBookCreated, GetResultSheetName(), strBookName) )
			/////end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
			
			/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
			//string	strSheetName = GetResultSheetName(trOperation.GUI) + "1";
			///Sophy 5/29/2008 QA80-10934-P10 CORRECT_STATS_ON_ROWS_RESULT_BOOK_NAME
			//string	strSheetName = getResultSheetNameFromGUI(trOperation.GUI);
			string	strSheetName = GetResultSheetNameFromGUI(trOperation.GUI);
			///end CORRECT_STATS_ON_ROWS_RESULT_BOOK_NAME
			///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
			if( !PrepareOutput(wksOutput, dsInput1stRange, trOperation, bNewBookCreated, strSheetName, strBookName) )
			////end PROPER_REPORT_SHEET_NAME				
				
			///End PREPARE_OUTPUT_FOR_RESIDUAL
				return error_report("Failed in PrepareOutput");
		}
	}
	
	if (bSecondPhase)
	{
		if(!addGraphsToReport(trOperation, NULL, NULL))
			error_report("****** AddGraphsToReport failed!");
		
		/// YuI 10/11/06 USE_CLONE_OF_CALCULATIONS_TO_GENERATE_REPORT
		/*
		FilterReport(trOperation);
		
		/// Joesph/Iris 9/26/06 QA70-7120 MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
		//addAdditionalCustomTables(trOperation, nNumData);
		///end MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
		
		/// Iris 9/11/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
		//DWORD dwReportUID = GenerateWksReport(wksOutput, trOperation.Calculation, nNumInHeading);
		DWORD dwReportUID = GenerateReport(wksOutput, trOperation.Calculation, nNumInHeading);
		///end SURFACE_FIT_REPORT_MAT_FIT_DATA
		*/		
		///Arvin 10/20/06 INPUT_DATA_TABLE_GIBBERISH_WHEN_RECALCULATION_IS_NONE
		TreeNode trAutoUpdate = trOperation.Operation.AutoUpdate;
		if(trAutoUpdate)
		{
			/// ML 11/13/2006 ESCAPED_STRRINGS_TRANSLATED_FOR_AU_NONE_ONLY
			if(trAutoUpdate.nVal == AU_NONE)
			/// end ESCAPED_STRRINGS_TRANSLATED_FOR_AU_NONE_ONLY
				ConvertEscapedStrings(trOperation.Calculation);
		}
		///end INPUT_DATA_TABLE_GIBBERISH_WHEN_RECALCULATION_IS_NONE		
		///Arvin 02/09/07 SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
		//DWORD dwReportUID = FilterAndGenerateReport(wksOutput, trOperation.Calculation, nNumInHeading);		
		DWORD dwReportUID = filterAndGenerateReport(wksOutput, trOperation.Calculation, nNumInHeading, TRUE, TRUE);
		///end SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
		/// end YuI 
		
		if(0 == dwReportUID)
			return error_report("failed to generate report");

		/// Iris 2/02/2010 QA81-14994 FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
		// do a report sheet and fit curve sheet, change param to uncheck all table, will use SetOutput set report sheet range as empty range above.
		// but if change param to add back report sheet, need set newly created report sheet back to operation to replace that empty range.
		//if( !rgReportSheetOutput.IsValid() )
		///End FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
		{
			rgReportSheetOutput = Project.GetObject(dwReportUID);
				SetOutput(rgReportSheetOutput, OUTPUT_REPORT_SHEET_RNG_INDEX);
		}
	}
	
	return true;
}
/// end ATTACHING_GRAPHS_TO_CELLS_IN_OPERATION

bool WksReportOperation::doInsertedColumns(TreeNode& trOperation, int nIndex, int nTotalNumData, Range& rngInput, int nOutputIndex)
{
	DataRange		rngInsertedColumns;
	bool bHasOutput = GetOutput(rngInsertedColumns, GetOutputSlot(nIndex, false, nOutputIndex));		// at output position 1
	
	/// Iris 3/18/2009 FIX_STATS_ON_ROW_INPUT_DATA_GIBBERISH_IN_SCRIPT_WND
	// this logic already exist in doReportSheet, but not in doInsertedColumns
	TreeNode trAutoUpdate = trOperation.Operation.AutoUpdate;
	if(trAutoUpdate)
	{
		if(trAutoUpdate.nVal == AU_NONE)
			ConvertEscapedStrings(trOperation.Calculation);
	}
	///end FIX_STATS_ON_ROW_INPUT_DATA_GIBBERISH_IN_SCRIPT_WND
	
	bool bSuccess = UpdateInsertedColumns(trOperation, rngInput, nIndex, nTotalNumData, rngInsertedColumns, nOutputIndex);				
	if(!bSuccess)
		return error_report("Failed in UpdateInsertedColumns");
		
	// Set the DataRange into the operation:
	if(!bHasOutput)
	{					
		SetOutput(rngInsertedColumns, GetOutputSlot(nIndex, false, nOutputIndex));					
	}
	return true;
}

/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
//As max said, checkbox "Plot All Plots in One Graph" only work on Box Chart and Histogram
//bool WksReportOperation::IsPlotAllPlotsInOneGraph(TreeNode& trOperation)
bool WksReportOperation::IsPlotAllPlotsInOneGraph(TreeNode& trOperation, int nGraphIndex)
///end UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
{
	bool	bPlotInOneGraph = false;
	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode	trPlotOneGraph = trOperation.GUI.Output.PlotSettings.PlotInOneGraph;
	TreeNode	trPlotOneGraph = OP_GUI_GRAPH_ARRANGEMENT_NODE(trOperation.GUI).PlotInOneGraph;
	///end OP_DLG_NEW_STRUCTURE
	///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
	//if(trPlotOneGraph)
	//	bPlotInOneGraph = trPlotOneGraph.nVal;
	///Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
	//int nPlotType = ReportGetPlotTypeFromGraphIndex(nGraphIndex);
	//if(trPlotOneGraph && ( (nGraphIndex < 0) || (nPlotType == IDM_PLOT_HISTOGRAM_TYPE || nPlotType == IDM_PLOT_BOX) ))
	if(trPlotOneGraph && trPlotOneGraph.Show)
	///end SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL	
	///end 	UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
		bPlotInOneGraph = trPlotOneGraph.nVal;
	
	return bPlotInOneGraph;
}
///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH

///Arvin 08/28/07 QA70-10073 ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID
bool WksReportOperation::isTreeNodePlotInOneGraphValid(TreeNode& trOperation)
{
	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode	trPlotInOneGraph = trOperation.GUI.Output.PlotSettings.PlotInOneGraph;
	TreeNode	trPlotInOneGraph = OP_GUI_GRAPH_ARRANGEMENT_NODE(trOperation.GUI).PlotInOneGraph;
	///end TreeNode	trPlotInOneGraph = trOperation.GUI.Output.PlotSettings.PlotInOneGraph;
	
	///Arvin 02/20/08 QA70-11094-P4 DISABLE_PLOT_ALL_IN_ONE_CHECKBOX_WHEN_CHANGE_PARAM
	//if(trPlotInOneGraph.IsValid() && trPlotInOneGraph.Enable && trPlotInOneGraph.Show)
	if(trPlotInOneGraph.IsValid() && trPlotInOneGraph.Show)
	///end 	DISABLE_PLOT_ALL_IN_ONE_CHECKBOX_WHEN_CHANGE_PARAM
		return true;
	
	return false;
}
///end ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID

/// Iris 9/30/06 MOVE_FROM_H_TO_C_AVOLID_COMPILE_PCH
/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
//void GetResultCurveBookSheetName(TreeNode& trOperation, string& strBookName, string& strSheetName, int nIndex = 0);
//virtual 
/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
//void WksReportOperation::GetResultCurveBookSheetName(TreeNode& trOperation, string& strBookName, string& strSheetName, int nIndex, int nOption, bool bSeparateSheetForDataset)
void WksReportOperation::GetResultCurveBookSheetName(TreeNode& trOperation, string& strBookName, string& strSheetName, int nIndex, int nOption, bool bSeparateSheetForDataset, int nSheetNameIndex)
/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
{
	/// Iris 4/01/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES	
	///// Iris 05/08/2007 v8.0613 PROPER_REPORT_SHEET_NAME
	////strSheetName = GetResultCurveSheetName(trOperation, nIndex, nOption);
	//strSheetName = GetResultCurveSheetFullName(trOperation, nIndex, nOption);
	/////end PROPER_REPORT_SHEET_NAME
	
	//strBookName =  GetAnalysisName();
	//string strCurveBook = GetResultCurveBookName(trOperation, nIndex, nOption, bSeparateSheetForDataset);
	//if(!strCurveBook.IsEmpty())
		//strBookName += " - " + strCurveBook;
	/// Hong 04/10/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET	
	/*
	TreeNode	trOutput = 	trOperation.GUI.Output;
	TreeNode	trBookSheetBranch;
	switch(nOption)
	{
	case OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET:
		trBookSheetBranch = trOutput.Data;
		break;
		
	case OUTPUT_RESULT_CURVE_RESIDUAL_SHEET:		
		trBookSheetBranch = trOutput.Residual;
		break;
		
	case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET:
	case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET:
		trBookSheetBranch = trOutput.FindXY;
		break;

	default:
		break;
	}
	*/
	TreeNode	trBookSheetBranch;
	getGUIResultCurveNode(trOperation.GUI, trBookSheetBranch, nOption);
	/// end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET	
	if(trBookSheetBranch)
	{
		if(trBookSheetBranch.BookName)
			strBookName = trBookSheetBranch.BookName.strVal;
		/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
		//if(trBookSheetBranch.SheetName)
		//    strSheetName = trBookSheetBranch.SheetName.strVal;
		if(trBookSheetBranch.SheetName)
			///Sophy 8/15/2008 QA80-12025 RECALCULATE_RUNTIME_ERROR_WHEN_DO_NLFIT_SIGMOIDAL only DoseResp selected as function, needed to be checked later
			//strSheetName = GetSheetNameNode(trBookSheetBranch,nSheetNameIndex).strVal;
		{
			TreeNode trSheetName = GetSheetNameNode( trBookSheetBranch, nSheetNameIndex );
			ASSERT( trSheetName );
			if( trSheetName )
				strSheetName = trSheetName.strVal;
			else
				strSheetName = "InvalidName";
		}
			///end RECALCULATE_RUNTIME_ERROR_WHEN_DO_NLFIT_SIGMOIDAL
		/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
	}
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES	
}	
///end REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET

/// Iris 05/08/2007 v8.0613 PROPER_REPORT_SHEET_NAME
//virtual
string	WksReportOperation::GetResultCurveSheetFullName(TreeNode& trOperation, int nIndex, int nOption)				
{
	return GetClassName() + GetResultCurveSheetName(trOperation, nIndex, nOption) + "1";
}
///end PROPER_REPORT_SHEET_NAME

/// Iris 4/01/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
/// Iris 4/11/2008 SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
//string	WksReportOperation::GetResultCurveBookFullName(TreeNode& trOperation, int nIndex, int nOption, bool bSeparateSheetForDataset)
string	WksReportOperation::getResultCurveBookLongName(TreeNode& trOperation, int nIndex, int nOption, bool bSeparateSheetForDataset)
///end SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
{
	string	strBookName =  GetAnalysisName();
	string strCurveBook = GetResultCurveBookName(trOperation, nIndex, nOption, bSeparateSheetForDataset);
	if(!strCurveBook.IsEmpty())
		strBookName += " - " + strCurveBook;
	return strBookName;
}
///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES

/// Iris 4/11/2008 SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
string	WksReportOperation::GetResultCurveBookShortName(TreeNode& trOperation, int nIndex, int nOption)
{
	string		strBookName;
	switch(nOption)
	{
	case OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET:
		strBookName = _LE(E_STR_RESULT_CURVE_BOOK_SHORT_NAME);
		break;
	case OUTPUT_RESULT_CURVE_RESIDUAL_SHEET:
		strBookName = _LE(E_STR_RESIDUAL_CURVE_BOOK_SHORT_NAME);
		break;
	case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET:
		strBookName = _LE(E_STR_FIND_X_CURVE_BOOK_SHORT_NAME);
		break;
	case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET:
		strBookName = _LE(E_STR_FIND_Y_CURVE_BOOK_SHORT_NAME);
		break;
	default:
		///Kyle 09/24/08 SET_NO_NEED_TO_LOCALIZE 
		//strBookName = _LE("Curve1");
		strBookName = "Curve1";
		///End SET_NO_NEED_TO_LOCALIZE
		break;
	}
	return strBookName;	
}
///end SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK

//virtual 	
string	WksReportOperation::GetResultCurveSheetName(TreeNode& trOperation, int nIndex, int nOption)				
{		
	//string 	strData;
	//GetEscapedMainDataString(trOperation, strData, nIndex+1); //+1 mean LT index, offset is 1
	//ConvertEscapedString(strData);	
	
	//string strSheetName = GetResultCurveSheetPrefix(nOption) + strData;
	
	//if( strSheetName.IsEmpty() )
	//{		
		//strSheetName = "Curve Data" + (nOption+1);
	//}	
	string strSheetName;
	switch(nOption)
	{
	case OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET:
		/// Iris 05/08/2007 v8.0613 PROPER_REPORT_SHEET_NAME
		//strSheetName = /*"FitCurves"*/ "FittedValues"; ///Arvin 01/08/06 CHANGED_AS_MAX_SUGGESTION
		///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS
		//strSheetName = "Curves";
		strSheetName = _LE(E_STR_RESULT_CURVE_SHEET_NAME);
		///end CLEAN_UP_LOCALIZATION_THINGS
		///end PROPER_REPORT_SHEET_NAME
		break;
	case OUTPUT_RESULT_CURVE_RESIDUAL_SHEET:
		///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS
		//strSheetName = "Residuals";
		strSheetName = _LE(E_STR_RESIDUAL_CURVE_SHEET_NAME);
		///end CLEAN_UP_LOCALIZATION_THINGS
		break;
	case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET:
		///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS
		//strSheetName = "FindXfromY";
		strSheetName = _LE(E_STR_FINDX_CURVE_SHEET_NAME);
		///end CLEAN_UP_LOCALIZATION_THINGS
		break;
	case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET:
		///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS
		//strSheetName = "FindYfromX";
		strSheetName = _LE(E_STR_FINDY_CURVE_SHEET_NAME);
		///end CLEAN_UP_LOCALIZATION_THINGS
		break;
	/// Hong 04/10/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	case OUTPUT_RESULT_PEAK_CHARACTER_SHEET:
		strSheetName = _LE(STR_PEAK_CHARACTER_SHEET); //_LE("PeakCharacterisation");
		break;
	/// end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	default:
		///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS
		//strSheetName = "Curves";
		strSheetName = _LE("Curves");
		///end CLEAN_UP_LOCALIZATION_THINGS
		break;
	}
	return strSheetName;
}
///End MOVE_FROM_H_TO_C_AVOLID_COMPILE_PCH

///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
int		WksReportOperation::GetReportOutPutDestination(const TreeNode& trInput)
{
	if(!is_range_from_normal_book(trInput))
		return PDS_NEW;
	return PDS_SOURCE;
}

/// Hong 04/15/08 v8.0843 FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
//int		WksReportOperation::GetDataOutPutDestination(const TreeNode& trOutput, string& strReportBook, Worksheet* pwksReport)
///Sophy 6/2/2008 ADD_SOURCE_BOOK_FOR_PLOT_DATA_REDISUAL_ON_MATRIX_FIT
//int		WksReportOperation::GetDataOutPutDestination(const TreeNode& trOutput, const TreeNode& trInput, string& strReportBook, Worksheet* pwksReport)
int		WksReportOperation::GetDataOutPutDestination( TreeNode& trOp, const TreeNode& trOutput, const TreeNode& trInput, string& strReportBook, Worksheet* pwksReport)
///end ADD_SOURCE_BOOK_FOR_PLOT_DATA_REDISUAL_ON_MATRIX_FIT
/// end FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
{
	strReportBook.Empty();
	/// Hong 04/15/08 v8.0843 FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
	int 	nNoneReportDef = GetReportOutPutDestination(trInput);	
	/// end FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
	if(!trOutput)
		/// Hong 04/15/08 v8.0843 FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
		//return PDS_NEW;
		return nNoneReportDef;
		/// end FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
	
	TreeNode trReportBook = trOutput.Report.Book;
	if(!trReportBook)
		/// Hong 04/15/08 v8.0843 FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
		//return PDS_NEW;	
		return nNoneReportDef;
		/// end FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW

#ifndef OP_DLG_TOTALLY_NEW_STRUCTURE
	/// Iris 2/02/2010 QA81-14994 FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
	//if(PDS_NONE == str_to_predefined_type(trReportBook.strVal))	
	if(PDS_NONE == str_to_predefined_type(trReportBook.strVal) || m_bNoReportTable )	
	///End FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
		/// Hong 04/15/08 v8.0843 FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
		//return PDS_NEW;	
		return nNoneReportDef;
		/// end FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
#else //OP_DLG_TOTALLY_NEW_STRUCTURE
	if( !isOutputReportSheet(trOp.GUI) )
		return nNoneReportDef;
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE

	/// Hong 04/14/08 v8.0842 GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
	if ( pwksReport )
	/// end GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
		strReportBook = pwksReport->GetPage().GetName();
	
	return PDS_REPORT;
}
///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING

/// Hong 02/02/10 QA80-14801 FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION
static void		arg_copy_with_sheet_active(string& str, LPCSTR lpcszWinName)
{
	//--CPY 2010-0208 QA81-14801 OC_NEEDS_ARG_CPY_WITH_PAGE_CONTEXT_OPTN
/*	LT_set_str("strArgCopyJunk", str);
	string		strScript;
	strScript.Format("win -o %s { arg_copy_oc_wrapper(strArgCopyJunk$); }", lpcszWinName);
	LT_execute(strScript);
	int			nBufferSize = MAXLINE*4;
	LPSTR		lpStr = str.GetBuffer(nBufferSize);
	LT_get_str("strArgCopyJunk", lpStr, nBufferSize);
*/
	
	okutil_arg_copy(&str, lpcszWinName);
	//--
	
}
/// end FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION
	
///Jasmine 09/27/06 PREPARE_OUTPUT_FOR_RESIDUAL
/// Iris 9/06/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
//bool	WksReportOperation::PrepareOutput(Worksheet& wksOutput, Worksheet& wksInput1stRange, TreeNode& trOperation, bool& bNewBookCreated, LPCSTR lpcszDefaultSheetName, LPCSTR lpcszDefaultBookName, Worksheet* pwksReport)//= NULL, NULL, NULL
//bool	WksReportOperation::PrepareOutput(Datasheet& wksMatLayer, Worksheet& wksInput1stRange, TreeNode& trOperation, bool& bNewBookCreated, LPCSTR lpcszDefaultSheetName, LPCSTR lpcszDefaultBookName, Worksheet* pwksReport, bool bWksLayer)//= NULL, NULL, NULL, true
//bool	WksReportOperation::PrepareOutput(Datasheet& wksMatLayer, Worksheet& wksInput1stRange, TreeNode& trOperation, bool& bNewBookCreated, int nOutputIndex, LPCSTR lpcszDefaultSheetName, LPCSTR lpcszDefaultBookName, Worksheet* pwksReport, bool bWksLayer)//= NULL, NULL, NULL, true
///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
//bool	WksReportOperation::PrepareOutput(Datasheet& wksMatLayer, Worksheet& wksInput1stRange, TreeNode& trOperation, bool& bNewBookCreated, string& strSheetName, string& strBookName, bool bSeparateSheetForDataset, int nOutputIndex, Worksheet* pwksReport, bool bWksLayer, Worksheet* pWksFitCurve)//= NULL, NULL, NULL, true, NULL
/// Iris 4/11/2008 SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
//bool	WksReportOperation::PrepareOutput(Datasheet& wksMatLayer, Datasheet& dsInput1stRange, TreeNode& trOperation, bool& bNewBookCreated, string& strSheetName, string& strBookName, bool bSeparateSheetForDataset, int nOutputIndex, Worksheet* pwksReport, bool bWksLayer, Datasheet* pdsFitCurve)//= NULL, NULL, NULL, true, NULL
bool	WksReportOperation::PrepareOutput(Datasheet& wksMatLayer, Datasheet& dsInput1stRange, TreeNode& trOperation, bool& bNewBookCreated, string& strSheetName, string& strBookName, LPCSTR lpcszBookLongName, bool bSeparateSheetForDataset, int nOutputIndex, Worksheet* pwksReport, bool bWksLayer, Datasheet* pdsFitCurve)//= NULL, NULL, NULL, true, NULL 
///end SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
///End SURFACE_FIT_REPORT_MAT_FIT_DATA
{	
	/// Hong 02/02/10 QA80-14801 FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION
	string			strPageName = GetSourcePageName(trOperation);
	DataPlot		dp = GetSourceDataPlot(0, trOperation);
	if ( dp )
	{
		GraphLayer	gl;
		dp.GetParent(gl);
		GraphPage	gp;
		gl.GetParent(gp);
		gp.GetName(strPageName);
	}
	arg_copy_with_sheet_active(strBookName, strPageName);
	arg_copy_with_sheet_active(strSheetName, strPageName);
	/// end FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION
	string strReportBook;
	bool bOutputCurve = false;
	bool bHierachySheet = true;
		if(pwksReport != NULL)
		{
			bOutputCurve = true;
			// CPY 9/23/05, this is not ready yet
			bHierachySheet = false;		/// ML 9/27/2005 
			
		}
	
	/// Iris 4/11/2008 SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
	//Book short name will be auto enum, the strBookName may be not the final real book name
	//if(bOutputCurve && !bSeparateSheetForDataset)
	//{
		//bNewBookCreated = false;
		//Page 	pg(strBookName);
		//if(pg)
		//{
			//wksMatLayer = pg.Layers(strSheetName);
			//if(wksMatLayer.IsValid())
				//return true;
		//}
	//}
	///end SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
	
	int nSpecialType = PDS_NEW, nSheetSpecialType = PDS_NEW;///Jasmine 09/28/06 GET_FITCURVE_OUTPUT_BOOK_NAME
	///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
	//if (wksInput1stRange)
	if (dsInput1stRange)
	///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
	{
		if(bOutputCurve)
			///Jasmine 09/27/06 PREPARE_OUTPUT_FOR_RESIDUAL
			//strReportBook = GetCurveOutputBookName(trOperation.GUI, &nSpecialType, pwksReport);  ///Iris 11/12/04 FIX_CURVE_SHEET_ALWAYS_SAME_AS_REPORT_SHEET
			strReportBook = GetCurveOutputBookName(trOperation.GUI, nOutputIndex, &nSpecialType, pwksReport); 
			///End PREPARE_OUTPUT_FOR_RESIDUAL
		else
			strReportBook = getReportOutputBookName(trOperation.GUI, &nSpecialType);
		
		///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
		if(nSpecialType == PDS_AUTO)
		{
			if(pdsFitCurve)
				/// Hong 04/15/08 v8.0843 FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW				
				//nSpecialType = GetDataOutPutDestination(trOperation.GUI.Output, strReportBook, pwksReport);
				///Sophy 6/2/2008 ADD_SOURCE_BOOK_FOR_PLOT_DATA_REDISUAL_ON_MATRIX_FIT
				//nSpecialType = GetDataOutPutDestination(trOperation.GUI.Output, trOperation.GUI.InputData, strReportBook, pwksReport);
				nSpecialType = GetDataOutPutDestination( trOperation, trOperation.GUI.Output, trOperation.GUI.InputData, strReportBook, pwksReport);
				///end ADD_SOURCE_BOOK_FOR_PLOT_DATA_REDISUAL_ON_MATRIX_FIT
				/// end FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
			else
				nSpecialType = GetReportOutPutDestination(trOperation.GUI.InputData);
		}
		///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
		
		bNewBookCreated = (PDS_NEW == nSpecialType && strReportBook.IsEmpty())? true:false;			
	}
	else
		bNewBookCreated = true;//--- CPY 10/10/04 QA70-7025 v8.0148 LOOSE_DATASET_SUPPORT_IN_AUTO_UPDATE_ANALYSIS
	
	string strReportSheet;
	if(bOutputCurve)
		///Jasmine 09/27/06 PREPARE_OUTPUT_FOR_RESIDUAL
		//strReportSheet = GetCurveOutputSheetName(trOperation.GUI);
		//strReportSheet = GetCurveOutputSheetName(trOperation.GUI, nOutputIndex);
		strReportSheet = getCurveOutputSheetName(trOperation.GUI, nOutputIndex, &nSheetSpecialType);
		///End PREPARE_OUTPUT_FOR_RESIDUAL
	else
		//strReportSheet = GetReportOutputSheetName(trOperation.GUI);
		strReportSheet = getReportOutputSheetName(trOperation.GUI, &nSheetSpecialType);
	/// Iris 9/06/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
	///// Iris 11/21/05 SAVE_RESULT_CURVE_DATAS_IN_SAME_PAGE_MULTI_LAYER
	////WorksheetPage		wp(strReportBook);
	//WorksheetPage		wp;
	//if(wksOutput)
	//{
		//wksOutput.GetParent(wp);
		//bNewBookCreated = false;
	//}
	//if(!wp)
		//wp = Project.WorksheetPages(strReportBook);
	/////End SAVE_RESULT_CURVE_DATAS_IN_SAME_PAGE_MULTI_LAYER
	Page		pg;
	if(wksMatLayer.IsValid())
	{
		wksMatLayer.GetParent(pg);
		bNewBookCreated = false;
	}
	if(!pg)
		pg = Project.Pages(strReportBook);
	///end SURFACE_FIT_REPORT_MAT_FIT_DATA
	
	//wksInput1stRange.GetParent(wp);
	//if( !wp )
	//	return error_report("PrepareOutput found no workbook to be used");
	if( !pg )
	{
		if(PDS_SOURCE == nSpecialType && FALSE == bNewBookCreated) // auto
		{
			///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
			//wksInput1stRange.GetParent(pg);
			dsInput1stRange.GetParent(pg);
			///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
			if( !pg )
				return error_report("PrepareOutput found no workbook to be used");
		}
		else if(PDS_FIT_CURVE == nSpecialType && FALSE == bNewBookCreated) // auto
		{
			/// Iris 9/30/06 USE_SHORT_SHEET_NAME_FOR_RESULT_CURVE_SHEET
			/*
			///Jasmine 09/28/06 GET_FITCURVE_OUTPUT_BOOK_NAME
			string strPageName;
			if(pstrFirstOutputBookSheet)
			{
				strPageName = *pstrFirstOutputBookSheet;
				if(PDS_FIT_CURVE == nSheetSpecialType)
					strReportSheet = strPageName.GetToken(1, '|');
				strPageName = strPageName.GetToken(0, '|');
			}
			else
				strPageName = get_fitcurve_page_name(trOperation);
			Page pgFitcurve(strPageName);
			if(pgFitcurve)
				pg = pgFitcurve;
			///End GET_FITCURVE_OUTPUT_BOOK_NAME
			*/
			///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
			//if(pWksFitCurve && pWksFitCurve->IsValid())
			//{
				//pg = pWksFitCurve->GetPage();
				//if(PDS_FIT_CURVE == nSheetSpecialType)
					//strReportSheet = pWksFitCurve->GetName();
			//}
			if(pdsFitCurve && pdsFitCurve->IsValid())
			{
				pg = pdsFitCurve->GetPage();
				if(PDS_FIT_CURVE == nSheetSpecialType)
					strReportSheet = pdsFitCurve->GetName();
			}
			///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
			///end USE_SHORT_SHEET_NAME_FOR_RESULT_CURVE_SHEET
			if( !pg )
				return error_report("PrepareOutput found no workbook to be used");
		}
		else
		{
			bNewBookCreated = true;		
			if(bWksLayer)
			{
				WorksheetPage wp;
				//---Iris 01/26/2007 v8.0548 SHOW_NEWLY_CREATED_REPORT_BOOK, from Max's suggestion
				//wp.Create(NULL, CREATE_HIDDEN);
				/// Iris 7/17/2008 v8.0902 QA80-11856 FAIL_SET_REPORT_SHEET_NAME_TO_SHEET1
				//wp.Create();
				/// Iris 3/20/2009 QA80-13285-P2 WANT_MERGE_PARAMETERS_LABEL_IN_REPORT_SHEET
				//wp.Create(NULL, CREATE_VISIBLE | CREATE_EMPTY);
				wp.Create(STR_REPORT_SHEET_TEMPLATE, CREATE_VISIBLE | CREATE_EMPTY);
				///end WANT_MERGE_PARAMETERS_LABEL_IN_REPORT_SHEET
				///end FAIL_SET_REPORT_SHEET_NAME_TO_SHEET1
				//---
				pg = wp;
			}
			else
			{
				MatrixPage mp;
				//---Iris 01/26/2007 v8.0548 SHOW_NEWLY_CREATED_REPORT_BOOK
				//mp.Create(NULL, CREATE_HIDDEN);
				/// Iris 7/17/2008 v8.0902 QA80-11856 FAIL_SET_REPORT_SHEET_NAME_TO_SHEET1
				//mp.Create();
				mp.Create(NULL, CREATE_VISIBLE | CREATE_EMPTY);
				///end FAIL_SET_REPORT_SHEET_NAME_TO_SHEET1
				//---
				pg = mp;
			}
			
			if(strReportBook.IsEmpty())
				strReportBook = strBookName;
			
			if(!strReportBook.IsEmpty())
			{				
				//pg.Rename(strReportBook, false, true);
				/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
				/*
				pg.SetLongName(strReportBook, false);
				pg.TitleShow = WIN_TITLE_SHOW_BOTH;
				*/
				pg.Rename(strReportBook, false, true);
				/// Iris 4/11/2008 SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
				if( NULL != lpcszBookLongName)
				{
					pg.SetLongName(lpcszBookLongName, false, true); 
					pg.TitleShow = WIN_TITLE_SHOW_BOTH;
				}
				///end SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
				///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
			}
		}
	}
	if(!pg)
		return error_report("Fail to create Report Book in PrepareOutput");
	strBookName = pg.GetName();/// Iris 01/19/2007 v8.0544 OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT
		
	/// Iris 4/11/2008 SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
	// if sheet type is <new> no need to check sheet named strReportSheet if already existed since must always to new one even existed.
	//if(!strReportSheet.IsEmpty())
	if(!strReportSheet.IsEmpty() && PDS_NEW != nSheetSpecialType)
	///end SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
	{
		wksMatLayer = pg.Layers(strReportSheet);
		if(wksMatLayer)
		{
			strSheetName = wksMatLayer.GetName();/// Iris 01/19/2007 v8.0544 OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT
			return true; // found corret sheet
		}
		// not a valid sheet name, so user is intending to create a new sheet with specified name
		// we let it pass through here
	}
	else // empty sheet name means create new with class determined default
	{
		strReportSheet = strSheetName;
		//--- CPY 10/31/05 FIT_CUREVES_USE_SRC_DATA_COL_LONG_NAME_AS_SHEET_NAME
		// do not add one
		//strReportSheet += "1";// Fit1 instead of Fit, AddLayer will automatically increment if Fit1 is already there
		//---
	}
	
	// New Sheet
	DWORD dwOptions = 0;//GETNBRANCH_HIDE_COL_LABELS;// | GETNBRANCH_HIDE_ROW_LABELS; we do want to show Row labels, but no Row headings
	//CPY 7/28/04, show row heading to allow resizeing of report
	//dwOptions |= GETNBRANCH_HIDE_ROW_HEADINGS | GETNBRANCH_HIDE_COL_HEADINGS;
	
	//---- CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
	//DWORD dwCntrl = WP_SHEET_HIERARCHY | CREATE_NO_DEFAULT_TEMPLATE | WP_SHEET_THIN_COL_HEADERS | WP_SHEET_MAIN_NAN_AS_BLANK;
	DWORD dwCntrl = 0;
	///Arvin 11/07/06 STATS_ON_ROW_OUTPUT_RESULTS_TO_SHEET
	//if(bHierachySheet)
	bool bInsertResultsToNewSheet = IsOutputDataResultsToNewSheet(trOperation.GUI);
	if(bHierachySheet&& !bInsertResultsToNewSheet)
	///end STATS_ON_ROW_OUTPUT_RESULTS_TO_SHEET
	{
		dwCntrl |= WP_SHEET_HIERARCHY | CREATE_NO_DEFAULT_TEMPLATE | WP_SHEET_THIN_COL_HEADERS | WP_SHEET_MAIN_NAN_AS_BLANK;
		dwOptions |= GETNBRANCH_HIDE_COL_LABELS | GETNBRANCH_FIT_COL_WIDTH | GETNBRANCH_FIT_ROW_HEIGHT;
	}
	//----
		
	/// Iris 3/20/2009 QA80-13285-P2 WANT_MERGE_PARAMETERS_LABEL_IN_REPORT_SHEET
	//int nn = pg.AddLayer(strReportSheet, dwCntrl, NULL, dwOptions );
	LPCSTR lpcszTemplate = NULL;
	if(!bHierachySheet)
		lpcszTemplate = STR_REPORT_SHEET_TEMPLATE;
	int nn = pg.AddLayer(strReportSheet, dwCntrl, lpcszTemplate, dwOptions );
	///END WANT_MERGE_PARAMETERS_LABEL_IN_REPORT_SHEET

	wksMatLayer = pg.Layers(nn);
	strSheetName = wksMatLayer.GetName();/// Iris 01/19/2007 v8.0544 OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT
	/// Iris 9/30/06 USE_SHORT_SHEET_NAME_FOR_RESULT_CURVE_SHEET
	///Jasmine 09/28/06 GET_FITCURVE_OUTPUT_BOOK_NAME
	//if(OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET == nOutputIndex && pstrFirstOutputBookSheet)
	//	*pstrFirstOutputBookSheet = pg.GetName() + "|" + strReportSheet;
	///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
	//if(OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET == nOutputIndex && pWksFitCurve)
	//	*pWksFitCurve = wksMatLayer;
	if(OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET == nOutputIndex && pdsFitCurve)
		*pdsFitCurve = wksMatLayer;
	///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
	///end USE_SHORT_SHEET_NAME_FOR_RESULT_CURVE_SHEET
	
	///BOOL bTemp = bNewBookCreated;
	if( TRUE == bNewBookCreated && nn > 0) // there was already another sheet, 
	{
		/// Iris 9/06/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
		//Worksheet wksJunk = wp.Layers(0);
		//wksJunk.Destroy();
		Layer layJunk = pg.Layers(0);
		layJunk.Destroy();
		///End SURFACE_FIT_REPORT_MAT_FIT_DATA
	}
	//else if(nn > 0 && page_is_active(wp))
	//	page_set_active_layer(wp, nn);
		
	// no longer need this if layer creation does not use tempalte, so always empty
	if(wksMatLayer.GetNumCols() > 0)
	{
		//wksMatLayer.SetSize(-1, 0);
		wksMatLayer.SetNumRows(0);
		//error_report("Report worksheet not empty when inserted"); /// Iris 9/19/06 not show this err since FitCurve/Residual result book is not bHierachySheet so not empty when create
	}
	if(bHierachySheet)
	{
		// report sheet has one col on the main sheet and all other info
		// are in tables with their own cols
		//----- CPY QA70-8615-5 7/12/06 REMOVE_COMMENTS_COL_FROM_REPORT
		/*
		int nCol = wksOutput.AddCol("comments");
		Column cc(wksOutput, nCol);
		cc.SetWidth(40);// make the main col wide enough to show info
		cc.SetJustify(COL_JUSTIFY_LEFT);
		cc.SetType(OKDATAOBJ_DESIGNATION_NONE);
		*/
	}
	///------ Folger 12/14/09 PAMULTIY_FAILS_TO_REMOVE_PEAK_PROPERTIES_SHEET_IF_ONLY_HAS_ONE_COLUMN_OUTPUT
	else
	{
		if ( pg.GetType() == EXIST_WKS )
		{
			Worksheet	wks(wksMatLayer);
			wks.SetSize(-1, 0);
		}
	}
	///------ End PAMULTIY_FAILS_TO_REMOVE_PEAK_PROPERTIES_SHEET_IF_ONLY_HAS_ONE_COLUMN_OUTPUT
		//--- CPY 6/11/04 APPEND_REPORT_SHEET
		//---
		// we need to make sure that during Construct, we set this to ""
		// and here we save this so that later we may need to reconnect to this worksheet
	//	trOperation.Output.Result1.WksName.strVal = wks.GetName();
	
	return true;
}


//------------------------------------------------------------------------------

/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
int		WksReportOperation::GetTotalNumData(TreeNode& trOp)
{
	DataRange dr;
	GetInput(dr);
	if( !dr )
		return -1;
	
	return dr.GetNumData(GetDataRules(trOp));
}

int		WksReportOperation::ReportGetPicureIndexFromDataIndex(int nGraphIndex, int nDataIndex)
{
	return nDataIndex;
}

///Iris 8/31/05 SUPPORT_MULTI_LAYERS_IN_ONE_GRAPH
int		WksReportOperation::ReportGetPlotIndex(int nGraphIndex, int nPictureIndex, int nDataIndex)
{
	return 0;
}
///End SUPPORT_MULTI_LAYERS_IN_ONE_GRAPH

int		WksReportOperation::ReportGetPlotTypeFromGraphIndex(int nGraphIndex)
{
	return IDM_PLOT_LINE; // generic plot
}

bool	WksReportOperation::ReportHasGraph(TreeNode& trOp, int nPlotType, bool& bVisible)
{
	//--- CPY 2/31/04
	/*
	TreeNode tr = trOp.trGUI.Output.Report.Create;
	for( int nGraphIndex = 0; nGraphIndex < 5; nGraphIndex++ ) //ok for now
	{
		if( ReportGetPlotTypeFromGraphIndex(nGraphIndex) == nPlotType )
		{ 
			string strTemp = op_get_graph_tag_name(nGraphIndex);
			TreeNode trTemp = trOp.GUI.Output.Report.Create.GetNode(strTemp);
			if( trTemp && trTemp.nVal )
				bVisible = true;
			else
				bVisible = false;
			
			return true;
		}
	}
	*/
	int nGraphs = GetNumGraphs();
	for(int ii = 0 ; ii < nGraphs; ii++)
	{
		if(ReportGetPlotTypeFromGraphIndex(ii) == nPlotType)
		{
			bVisible = IsCreateReportGraph(trOp, ii);
			return true;
		}
	}
	return false;
}

bool WksReportOperation::GetCustomGraphTypeName(string& strName, int nIndex)
{
	int nPlotType = ReportGetPlotTypeFromGraphIndex(nIndex);
	switch( nPlotType )
	{
	case IDM_PLOT_BOX:
		///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS
		//strName = "Box Charts";
		strName = _L("Box Charts");
		///end CLEAN_UP_LOCALIZATION_THINGS
		break;
	
	case IDM_PLOT_HISTOGRAM_TYPE:
		///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS
		//strName = "Histograms";
		strName = _L("Histograms");
		///end CLEAN_UP_LOCALIZATION_THINGS
		break;
		
	default:
		return false;
	}
	
	return true;
}
/// end PICTURE_IN_REPORT_IMPROVEMENT

int WksReportOperation::GetOneResultCurvesTableID(int nBaseID, int nDataIndex)
{
	return make_one_set_ID(nBaseID, nDataIndex+1);
}

/// Iris 10/20/05 MOVE_REPORT_GRAPH_CODES_TO_BASE_CLASS
///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
//TreeNode WksReportOperation::CheckCreateOneResultCurvesTable(TreeNode& trOp, int nDataIndex, int nTotalNumData, int nGraphIndex, LPCSTR lpcszTableName, int nTableID, LPCSTR lpcszTableLabel, LPCSTR lpcszDataLabel)
TreeNode WksReportOperation::CheckCreateOneResultCurvesTable(TreeNode& trOp, int nDataIndex, int nTotalNumData, int nGraphIndex, LPCSTR lpcszTableName, int nTableID, LPCSTR lpcszTableLabel, LPCSTR lpcszMainTableLabel, bool bNeedMakeID)
///end UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
{
	TreeNode trRC = GetResultCurvesBranch(trOp, nDataIndex, nTotalNumData, GetOutputRangeIndex(trOp, nGraphIndex), lpcszMainTableLabel);
	if(!trRC)
		return trRC;
 	///Arvin 05/30/07 v8.0629 ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE 
 	///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
 	//nTableID = make_one_set_ID(nTableID, nDataIndex+1); 
 	if(bNeedMakeID)
 	{
 		//--- Iris 3/16/2009 QA80-13285-P1 FIX_DUPLICATE_RESIDUAL_DATA_REPORT_FOR_DIFF_RESIDUAL_REPORT_AND_PLOT
 		//nTableID = make_one_set_ID(nTableID, nDataIndex+1);
 		nTableID = GetOneResultCurvesTableID(nTableID, nDataIndex);
 		//---FIX_DUPLICATE_RESIDUAL_DATA_REPORT_FOR_DIFF_RESIDUAL_REPORT_AND_PLOT
 	}
 		
 	///end UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
 	///end ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE
 	
	TreeNode 	trOneTable = tree_check_get_node(trRC, lpcszTableName, nTableID, STR_LABEL_ATTRIB, lpcszTableLabel);
	
	//bool bCreateGraph = IsCreateReportGraph(trOp, nGraphIndex); /// Iris 5/26/2008 QA80-11607 v8.0870 FIT_CURVE_NOT_PLOT_ON_SOURCE_IF_NOT_PLOT_IN_REPORT no place use bCreateGraph, so comment out 
	//tree_check_set_hidden(trOneTable, !bCreateGraph); ///Arvin 12/01/06 ALWAYS_OUTPUT_RESULTS_DATA

	int nSingleTable = GetTableStringDatasets();
	trOneTable.SetAttribute(TREE_Table, nSingleTable);
	return trOneTable;
}


TreeNode WksReportOperation::GetResultCurvesBranch(TreeNode& trOp, int nDataIndex, int nTotalNumData, int nOutputRangeIndex, LPCSTR lpcszDataLabel)
{
	TreeNode trSubTable;
	/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	//TreeNode trRC = RESULT_CURVE_BRANCH(trOp);
	TreeNode 	trRC;
	switch(nOutputRangeIndex)
	{
	case OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET:		
		trRC = RESULT_CURVE_BRANCH(trOp);
		break;
	case OUTPUT_RESULT_CURVE_RESIDUAL_SHEET:
		trRC = RESIDUAL_CURVE_BRANCH(trOp);
		break;
	/// Joesph/Iris 9/26/06 QA70-7120 MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
	case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET:
		trRC = CALIBRATION_CURVE_BRANCH_1(trOp);	
		break;
	case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET:
		trRC = CALIBRATION_CURVE_BRANCH_2(trOp);		
		break;
	///end MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET	
	/// Hong 04/10/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	case OUTPUT_RESULT_PEAK_CHARACTER_SHEET:
		trRC = PEAK_CHARACTER_CURVE_BRANCH(trOp);
		break;
	/// end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	case OUTPUT_RESULT_SUBTRACTED_DATA_SHEET:
		trRC = SUBTRACTED_DATA_CURVE_BRANCH(trOp);
		break;
	case OUTPUT_RESULT_BASELINE_DATA_SHEET:
		trRC = BASELINE_DATA_CURVE_BRANCH(trOp);
		break;
	///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP	
	default:
		break;
	}
	///end REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET		
	if( !trRC )
	{
		/// ML 8/6/2007 SEEMS_LEGAL
		//error_report("Fail to get ResultCurves node");
		/// end SEEMS_LEGAL
		return trSubTable;
	}
	/// Iris 12/22/05 THE_SAME_FORMAT_FOR_ONE_DATA_AND_MULTIP_DATA
	//in anove one way, Box char report graph have multiple pictures, but bar chart, mean sd...graph only have one picture.
	// so must keep the same format event though the input data is one data or multiple data	
	//if( nTotalNumData <= 0 )
		///// Iris 11/21/05 GET_PICTURE_NUM_TO_REPLACE_TOTAL_NUM
		////nTotalNumData = GetTotalNumData(trOp);
		//nTotalNumData = GetPictureNum(trOp, nTotalNumData, nGraphIndex);
		/////End GET_PICTURE_NUM_TO_REPLACE_TOTAL_NUM
	//if( nTotalNumData <= 0 )
	//{
		//error_report("nTotalNumData is less and equal 0 in GetResultCurvesBranch");
		//return trSubTable;
	//}
		//
	//bool bHaveSubLevel = (1 < nTotalNumData);
	//if (bHaveSubLevel)
	//{
	///End THE_SAME_FORMAT_FOR_ONE_DATA_AND_MULTIP_DATA
		if(lpcszDataLabel) // to indicate to create
		{
			/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
			//int nGroupID = IDST_REPORT_FITDATA_ONE_SET;
			int nGroupID = GetOneSetResultCurvesID(nOutputRangeIndex);
			///end REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
			trSubTable = check_add_enumerated_node(trRC, RESULT_CURVE_DATA_SET_PREFIX, nDataIndex + 1, make_one_set_ID(nGroupID, nDataIndex), STR_LABEL_ATTRIB, lpcszDataLabel);
			int nSingleTable = GetTableStringSupport(false);
			nSingleTable |= GETNBRANCH_CHANGE_LABEL_TYPES_IN_FLAT;
			trSubTable.SetAttribute(TREE_Table, nSingleTable);
		}
		else
		{
			///Arvin 05/30/07 v8.0629 ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE 
			//string strCuvTable;
			//strCuvTable.Format("%s%d", RESULT_CURVE_DATA_SET_PREFIX, nDataIndex + 1);
			//trSubTable = trRC.GetNode(strCuvTable);
			if(nDataIndex < 0) //Get the whole branch
				trSubTable = trRC;
			else
			{
				string strCuvTable;
			 	strCuvTable.Format("%s%d", RESULT_CURVE_DATA_SET_PREFIX, nDataIndex + 1);
				trSubTable = trRC.GetNode(strCuvTable);
			}
			///end ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE
		}
	/// Iris 12/22/05 THE_SAME_FORMAT_FOR_ONE_DATA_AND_MULTIP_DATA
	//}
	//else
	//{
		//ASSERT(0 == nDataIndex);
		//trSubTable = trRC;
	//}
	///End THE_SAME_FORMAT_FOR_ONE_DATA_AND_MULTIP_DATA
	
	return trSubTable;  
}
/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
//virtual
TreeNode WksReportOperation::GetSheetNameNode( TreeNode& trBookSheetBranch, int nIndex)
{
	return trBookSheetBranch.SheetName;
}
/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
TreeNode WksReportOperation::GetOneResultCurvesTable(const TreeNode& trOp, int nDataIndex, int nTotalNumData, int nGraphIndex)
{
	TreeNode trRC = GetResultCurvesBranch(trOp, nDataIndex, nTotalNumData, GetOutputRangeIndex(trOp, nGraphIndex));
	if(!trRC)
		return trRC;
	
	TreeNode trTable;
	string strTable = GetOneResultCurvesTableTagName(nGraphIndex);
	if(strTable.IsEmpty())
	{
		error_report("getOneResultCurvesTable found invalid graph index");
		return trTable;
	}	
	trTable = trRC.GetNode(strTable);		
	return trTable;
}
///End MOVE_REPORT_GRAPH_CODES_TO_BASE_CLASS

///Arvin 10/17/06 DELETE_FUNCTIONS_ABOUT_STATS
/*
///Arvin 10/13/06 FITTING_RESIDUALS_HISTOGRAM_PLOT
virtual void	WksReportOperation::PutTempStatsTreeNode(TreeNode& trOp, int nTotalNumData)
{			
	DWORD dwRules = GetDataRules(trOp);
	for( int ii = 0; ii < nTotalNumData; ii++ )
	{
		DataRange dr;
		if( GetHistSourceData(trOp, dr, ii) )			
		{		
			string strData; 
			if( 0 <= dr.GetData(dwRules, ii, &strData) )
			{
				DatasetObject dsObj(strData);
				TreeNode trStats = getTempStatsTreeNode(trOp, ii);
				string strTag;
				GetDataPlotEventHandlerName(strTag, ii);
				okutil_make_valid_c_name(&strTag);
				dsObj.PutBinaryStorage(strTag, trStats);
			}
		}
	}
	
	if( trOp.Temp )
		trOp.Temp.RemoveChildrenWithPrefix(STATS_TREE_NODE_PREFIX);
}
///end FITTING_RESIDUALS_HISTOGRAM_PLOT	
*/
///end DELETE_FUNCTIONS_ABOUT_STATS

/// end PICTURE_IN_REPORT_IMPROVEMENT

#ifdef _MEASUER_GRID_RESIZE_TIME
static void resize_grid(Worksheet& wksReport)
{
	double t1 = GetTickCount();
	wksReport.AutoSize(0);
	printf("grid AutoSize time = %f secs\n", (GetTickCount() - t1)/1000.0);
}
#endif

/// ML 11/13/2006 THEME_DIGITS_PARAMETERS_TBL
//void	WksReportOperation::OnAfterCreateReport(TreeNode &trOp, Worksheet& wksReport, DataRange& rngInput, bool bNewResultBookCreatedHidden, int nTotalNumData)
void	WksReportOperation::OnAfterCreateReport(TreeNode &trOp, Worksheet& wksReport, DataRange& rngInput, DataRange &rgReportSheetOutput, int nExecMode, bool bNewResultBookCreatedHidden, int nTotalNumData)
/// end THEME_DIGITS_PARAMETERS_TBL
{
	
	WorksheetPage wpReport; 
	//--- CPY 6/24/04 moved here to allow derived class to modify
	if(wksReport)
	{
#ifdef _MEASUER_GRID_RESIZE_TIME
		resize_grid(wksReport);
#else
		//---- CPY RVD 8/9/05 LIMIT_AUTOSIZ_ROWCOL
		//wksReport.AutoSize(0);/// RVD 6/23/2004 QA70-6388 v7.5895 NEW_WORKBOOK_AUTOSIZE
		autosize_rowcol(wksReport);
		//----
#endif
		wksReport.GetParent(wpReport);
	}
	//---	
	
	cleanUpTempWksGraphs(trOp);
	if(!wpReport)
		return;
	
	if(bNewResultBookCreatedHidden)
		wpReport.SetShow();
	else
	{
		/// Iris 12/12/2006 v8.0523 ASK_USER_IF_ACTIVE_REPORT_SHEET, before, if the active page is graph page, will not switch to report sheet
		/*
		if(page_is_active(wpReport))
		{			
			Worksheet wks = wpReport.Layers();
			if(!worksheets_are_same(wks, wksReport))
			{
				int nn = wksReport.GetIndex();
				page_set_active_layer(wpReport, nn);
			}
		}
		*/
		//----- CPY 1/15/07 FIT_GRAPH_KEEP_ACTIVE_LEAD_TO_WKBOOK_WRONG_ACTIVE_TAB
		/*
		if(!page_is_active(wpReport))
		{
			if(_ask_if_active_report_sheet())
			{
				wpReport.SetShow();
			}
		}
		_active_report_sheet(wpReport, wksReport);
		*/
		
		/// YuI 02/28/08 QA70-11145 NEED_OPTION_NOT_TO_SWITCH_TO_REPORT_EVEN_IN_WORKSHEET
		/*
		_active_report_sheet(wpReport, wksReport);
		if(!page_is_active(wpReport))
		{
			if(_ask_if_active_report_sheet())
			{
				wpReport.SetShow();
			}
		}
		*/
		
		Worksheet wks = wpReport.Layers();
		if( !worksheets_are_same(wks, wksReport) || !page_is_active(wpReport) )
		{
			///------ Folger 03/16/09 QA80-13279 REMINDER_MESSAGE_FOR_SWITCH_TO_REPORT_SHEET_SHOULD_NOT_BE_SHOWN_DURING_AUTO_UPDATE
			//if(_ask_if_active_report_sheet())
			if( (OEXEM_ON_CREATE_OPEN_GUI == nExecMode || OEXEM_ON_CREATE == nExecMode) && _ask_if_active_report_sheet() )
			///------ End REMINDER_MESSAGE_FOR_SWITCH_TO_REPORT_SHEET_SHOULD_NOT_BE_SHOWN_DURING_AUTO_UPDATE
			{
				_active_report_sheet(wpReport, wksReport);
				wpReport.SetShow();
			}
		}
		/// end NEED_OPTION_NOT_TO_SWITCH_TO_REPORT_EVEN_IN_WORKSHEET
		//-----		
		///end ASK_USER_IF_ACTIVE_REPORT_SHEET
	}	
}

/// Iris 12/12/2006 v8.0523 ASK_USER_IF_ACTIVE_REPORT_SHEET
static void _active_report_sheet(WorksheetPage& wpReport, Worksheet& wksReport)
{
	Worksheet wks = wpReport.Layers();
	if(!worksheets_are_same(wks, wksReport))
	{
		int nn = wksReport.GetIndex();
		//----- CPY 1/15/07 FIT_GRAPH_KEEP_ACTIVE_LEAD_TO_WKBOOK_WRONG_ACTIVE_TAB
		//wpReport.SetShow();
		//-----
		page_set_active_layer(wpReport, nn, false);
	}	
}

static bool _ask_if_active_report_sheet()
{
	bool 	bActive = false;
	if ( OM_RETURN_OK == OptionalMessage( "SwitchToReportSheet", MB_YESNO ) ) 
		bActive = true;
	return bActive;
}
///end ASK_USER_IF_ACTIVE_REPORT_SHEET

/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
/*
int WksReportOperation::GetOutputSlot(int nDataIndex, bool bTableMustBeOutside)
{
	if(bTableMustBeOutside)
		return OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX + 2*nDataIndex + 1;
	else // fit curves
		return OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX + 2*nDataIndex;	
}
*/
int WksReportOperation::GetOutputSlot(int nDataIndex, bool bTableMustBeOutside, int nOutputIndex)
{
	/// YuI 11/27/07 QA70-10542 FIND_X_FROM_Y_SHOULD_ALLOW_OUTPUT_COLLISIONS
	/*
	int	nRangeIndex;  //the range index of columns of the output data table
	if(bTableMustBeOutside)
	{
		switch(nOutputIndex)
		{
		/// Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
		/*
		case OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET:
			nRangeIndex = OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX_1; // fit curves
			break;
		case OUTPUT_RESULT_CURVE_RESIDUAL_SHEET:
			nRangeIndex = OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX_2; // residual curves
			break;
		/// Joesph/Iris 9/26/06 QA70-7120 MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
		case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET:
			nRangeIndex = OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX_3; // Calibration table, Find X from Y
			break;
		case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET:
			nRangeIndex = OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX_4; // Calibration table, Find Y from X
			break;
		default:
			break;
		}
		///end MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
		*/
		/*
		case OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET:
			nRangeIndex = OUTPUT_RESULT_CURVE_SHEET_RNG_INDEX;
			break;
		case OUTPUT_RESULT_CURVE_RESIDUAL_SHEET:
			nRangeIndex = OUTPUT_RESIDUAL_CURVE_SHEET_RNG_INDEX;
			break;		
		case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET:
			nRangeIndex = OUTPUT_CALIBRATION_CURVE_SHEET_1_RNG_INDEX;
			break;
		case OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET:
			nRangeIndex = OUTPUT_CALIBRATION_CURVE_SHEET_2_RNG_INDEX;
			break;
		}
		///end OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
	}
	else
	{
		/// Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
		//nRangeIndex = OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX;
		switch(nOutputIndex)
		{
		case OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET:
			nRangeIndex = OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX_1; // fit curves
			break;
		case OUTPUT_RESULT_CURVE_RESIDUAL_SHEET:
			nRangeIndex = OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX_2; // residual curves
			break;
		default:
			nRangeIndex = OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX;
			break;
		}
		///end OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
	}
	
	/// Joesph/Iris 9/26/06 QA70-7120 MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
	//int nOutputCount = 3; //the count of output is 3 now, fit curves, residual cruves, the last may be result table in source wks.
	int nOutputCount = 5;  //one fit curves table + one residual curve table + two calibration tables + one result table in source wks
	///end MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
	nRangeIndex += nOutputCount * nDataIndex; 	
	
	return nRangeIndex;	
	*/
	
	return okutil_get_wks_report_operation_output_slot(nDataIndex, bTableMustBeOutside, nOutputIndex);
	/// end FIND_X_FROM_Y_SHOULD_ALLOW_OUTPUT_COLLISIONS
}
///end REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET

/// Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
///// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
////bool WksReportOperation::GetResultCurvesDataRange(TreeNode& trOp, DataRange& dr, int nDataIndex, int nGraphTableID)
//bool WksReportOperation::GetResultCurvesDataRange(TreeNode& trOp, DataRange& dr, int nDataIndex, int nGraphTableID, int nOutputIndex)
bool WksReportOperation::GetResultCurvesDataRange(TreeNode& trOp, DataRange& dr, int nDataIndex, int nGraphIndex, int nOutputIndex)
{
	bool bTableMustBeOutside = true;
	///---- Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
	//if(IsGraphTableInsertBackToSourceType(nGraphTableID))
	if(IsGraphTableInsertBackToSourceType(nGraphIndex))
	///----
	{
		TreeNode		trGUI = trOp.GUI;
		bool bInsertCurves = false;
		//---- Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
		//bool bInsertResultsToSrcWks = IsOutputInsertColsToDataSheet(trGUI, bInsertCurves);
		///Arvin 10/19/07 QA70-10559 RESIDUAL_PLOTS_FAILED_FOR_EXSITING
		//int  nOutputIndex = nGraphIndex; //For now Result sheet output index is same as the order of Graph
		///END RESIDUAL_PLOTS_FAILED_FOR_EXSITING
		bool bInsertResultsToSrcWks = isOutputInsertColsToDataSheet(trGUI, bInsertCurves, nOutputIndex);
		//----
		if(bInsertCurves && bInsertResultsToSrcWks)
			bTableMustBeOutside = false;
	}
	/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	//return GetOutput(dr, GetOutputSlot(nDataIndex, bTableMustBeOutside));
	///Arvin 05/30/07 v8.0629 ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE 
	//return GetOutput(dr, GetOutputSlot(nDataIndex, bTableMustBeOutside, nOutputIndex));
	int nIndex = nDataIndex;
	///Arvin 10/25/07 QA70-10559 RESIDUAL_PLOTS_FAILED_FOR_EXSITING
	//if(!IsSeparateSheetForDataset(trOp))
	if(!IsSeparateSheetForDataset(trOp) && bTableMustBeOutside)
	///END 	RESIDUAL_PLOTS_FAILED_FOR_EXSITING
		nIndex = 0;
	
	return GetOutput(dr, GetOutputSlot(nIndex, bTableMustBeOutside, nOutputIndex));
	///end ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE
	///end REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
}
//--- end USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
/// TD 5-18-06 QA70-8664 DATASET_OBJECT_CLASS_IN_OC_MORE_WORK
/// ML 8/15/2006 ATTACHING_GRAPHS_TO_CELLS_IN_OPERATION
/*
static  void _TagDataObject(DataObject & dobj, LPCSTR lpcszTag)
{
	if(dobj)
	{
		DatasetObject ds(dobj);
		if(ds)
			ds.Info.SYSTEM.PARAMETERS.TAG$ = lpcszTag;
		
	}
}
static void _tagOutputCols(DataRange &rg, LPCSTR lpcszTag)
{
	if(!rg || !lpcszTag)
		return;
	Datasheet dsRange;
	int r1, r2, c1, c2;
	r1=r2=c1=c2=0;
	int nSubRanges = rg.GetNumData();
	for(int ii = 0; ii < nSubRanges; ii ++)
	{
		if(rg.GetRange(ii, r1, c1, r2, c2, dsRange))
		{
			Worksheet wks = dsRange;
			if(wks)
			{
				for(int nCol = c1; nCol <= c2; nCol++)
				{
					Column col(wks, nCol);
					_TagDataObject(col, lpcszTag);
				}
			}
			MatrixLayer mlayer = dsRange;
			if(mlayer)
			{
				for(int nCol = c1; nCol <= c2; nCol++)
				{
					MatrixObject mobj(mlayer, nCol);
					_TagDataObject(mobj, lpcszTag);
				}
			}
			
		}

	}
}
*/
/// end ATTACHING_GRAPHS_TO_CELLS_IN_OPERATION
/// end DATASET_OBJECT_CLASS_IN_OC_MORE_WORK

///Arvin 05/31/07 CLEAR_REPORT_DATA_BEFOR_CALC_WHEN_DO_CHANGE_PARAMS
void 	WksReportOperation::CheckRemoveAndDestroyOutput(TreeNode& trOperation)
{
	bool		bKeepAttrib = true;
	int nNumData = GetTotalNumData(trOperation);
	vector<int>    vnIDs = {OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, OUTPUT_RESULT_CURVE_RESIDUAL_SHEET, 
							OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET, 
							/// Hong 04/10/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET							
							//OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET};
							OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET, OUTPUT_RESULT_PEAK_CHARACTER_SHEET,
							/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
							OUTPUT_RESULT_SUBTRACTED_DATA_SHEET,
							OUTPUT_RESULT_BASELINE_DATA_SHEET
							///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
							};
							/// end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
							
	for(int ii = 0; ii < vnIDs.GetSize(); ii++)
	{
		int nChildIndex = nNumData;
		TreeNode trRC = GetResultCurvesBranch(trOperation, nChildIndex, -1, vnIDs[ii]);
		while(trRC)
		{
			int nUID = 0;
			//If nUID isn't 0, it means that there was separate SetReportTree call with trRC,
			//and now, for one wks, we only call SetReportTree once, so this wks will be unused after change parameter
			if( trRC.GetAttribute(TREE_UID, nUID) && nUID != 0 )
			{
				DataRange drOutput;
				drOutput = Project.GetObject(nUID);
				if( drOutput )
				{
					RemoveOutput(drOutput);
					Worksheet wks;
					int c1, c2;
					drOutput.GetRange(wks, c1, c2);
					if( wks )
						wks.Destroy();
				}
			}
			trRC.Remove();
			nChildIndex++;
			trRC = GetResultCurvesBranch(trOperation, nChildIndex, -1, vnIDs[ii]);
		}
	}
}

void	WksReportOperation::ClearOutputTables(TreeNode& trOperation)
{
	Operation::ClearOutputTables(trOperation);
	
	/// Iris 08/02/2007 v8.0673 QA70-10073 FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
	/*
	/// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	int		nNumGraphs = GetNumGraphs();
	int 	nNumData = GetTotalNumData(trOperation);
	for(int nGraphIndex = 0; nGraphIndex < nNumGraphs; nGraphIndex++)
	{
		int			nCount = 0;
		TreeNode 	trGraph = trOperation.Calculation.GetNode(op_get_graph_tag_name(nGraphIndex));
		
		bool				bIsRow = true;
		TreeNodeCollection 	trCollPicRows(trGraph, _get_picture_tag_name(-1, bIsRow) );
		foreach(TreeNode trOneRow in trCollPicRows)
		{
			bIsRow = false;
			TreeNodeCollection 	trCollPicCols(trOneRow, _get_picture_tag_name(-1, bIsRow) );
			foreach(TreeNode trOnePic in trCollPicCols)
			{
				nCount++;
				
				// remove the unwanted picture nodes if remove input data in Change Parameter.
				if(nCount > nNumData)
					trOnePic.Remove();
			}
			
			if(trOneRow.IsEmpty())
			{
				TreeNode trLabel = trOneRow.PrevNode;
				if(trLabel)
					trLabel.Remove();
				trOneRow.Remove();
			}
		}
		
	}
	//end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	*/
	///end FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
	
	CheckRemoveAndDestroyOutput(trOperation);	
}
///end CLEAR_REPORT_DATA_BEFOR_CALC_WHEN_DO_CHANGE_PARAMS
///Arvin 10/16/06 MOVE_TO_OPERATION_FILE
void	WksReportOperation::UpdateDataSourceInReportingHeader(TreeNode &trInputTable, const vector<string> &vstrFactors, int ii, LPCSTR lpcszXLabel, int numSubRanges, DWORD dwRules )
{
	string		strLabel = _L("Data");
	if ( 1 < numSubRanges )
	{
		AddCombinedDataSourcesToReportInputTable(trInputTable, vstrFactors, ii, strLabel, numSubRanges, dwRules);
		return;
	}
	
	///Cheney 2007-4-3 REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
	TreeNode	trRow = AddReportInputTable(trInputTable, vstrFactors, ii);
	trRow = AddXDataSourceToReportInputTable(trRow, ii, strLabel, 0, numSubRanges, dwRules);
	//TreeNode	trRow = AddXDataSourceToReportInputTable(trInputTable, vstrFactors, ii, strLabel, 0, numSubRanges, dwRules);
	///end REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
	// The Range column:
	AddOneInputDataTableCell(trRow, WKSH_OPERATION_INFO_DATA_SOURCE_RANGE, ii + 1, FALSE, 'G', 'R');
}
///end MOVE_TO_OPERATION_FILE
//virtual
string	WksReportOperation::GetReportGraphLabel(TreeNode& trOp, int nGraphIndex, int nPicRow, int nPicCol)
{
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	// keep the logic same as in 80 SR6
	if( checkIfAlwaysOnlyOneGraph(trOp, nGraphIndex) )
		return "";
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	
	int			nPicIndex = nPicRow * GetReportGraphTableColNum(trOp, nGraphIndex) + nPicCol;
	if(nPicIndex >= GetTotalNumPictureForOneGraphType(trOp, nGraphIndex))
		return ""; //return error
	
	string 		strDataLabel;
	GetEscapedMainDataString(trOp, strDataLabel, nPicIndex + 1);
	return strDataLabel;
}

bool WksReportOperation::checkIfAlwaysOnlyOneGraph(TreeNode& trOp, int nGraphIndex)
{
	if( IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) )
	{
		int nNumFactors = GetNumFactors(trOp); 
		if( nNumFactors <= 0 // no grouping data
			|| nNumFactors > 0 && GetTotalNumData(trOp) / nNumFactors == 1)
		{
			return true;
		}
	}
	return false;
}
/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
int 	WksReportOperation::GetNumFactors(TreeNode& trOp, int* pn2ndGroupNumFactors)
{
	/// Iris 11/05/2009 QA81-14599 FIX_STATS_ON_COLS_PLOT_REPORT_GRAPHS_VERY_SLOW
	/*
	DataRange 		drInput;
	if( GetInput(drInput) )
	{		
		vector<int> 	vFactorSizes;
		drInput.GetNumData(GetDataRules(trOp), NULL, NULL, &vFactorSizes);
		
		if( vFactorSizes.GetSize() )
		{
			if( pn2ndGroupNumFactors && vFactorSizes.GetSize() > 1 )
				*pn2ndGroupNumFactors = vFactorSizes[1];
			
			return vFactorSizes[0];
		}
	}
	return 0;
	*/		
	if( -1 == m_nNumFactors )
	{
		DataRange 		drInput;
		if( GetInput(drInput) )
		{		
			vector<int> 	vFactorSizes;
			drInput.GetNumData(GetDataRules(trOp), NULL, NULL, &vFactorSizes);
			
			if( vFactorSizes.GetSize() )
			{
				if( vFactorSizes.GetSize() > 1 )
				{
					m_n2ndGroupNumFactors = vFactorSizes[1];
				}				
				m_nNumFactors = vFactorSizes[0];
			}
			else
			{
				m_nNumFactors = 0;
				m_n2ndGroupNumFactors = 0;
			}
			return m_nNumFactors;
		}
	}
	else
	{
		if(pn2ndGroupNumFactors)
			*pn2ndGroupNumFactors = m_n2ndGroupNumFactors;
		return m_nNumFactors;
	}
	return 0;
	///end FIX_STATS_ON_COLS_PLOT_REPORT_GRAPHS_VERY_SLOW
}
void 	WksReportOperation::arrangeReportGraphLayers(TreeNode& trOp, int nGraphIndex, GraphPage& gp, int nNumLayers)
{	
	ASSERT(gp && nNumLayers > 0);
	
	int nRows = 1, nCols = 1;
	int nPlotType = ReportGetPlotTypeFromGraphIndex(nGraphIndex);
	/// Iris 9/18/2009 QA80-11710-P2 IMPROVE_HISTOGRAM_PLOT_IN_ONE_GRAPH
	//if( IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) && IDM_PLOT_HISTOGRAM_TYPE == nPlotType )
	if( IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) && IDM_PLOT_HISTOGRAM_TYPE == nPlotType && nNumLayers <= 5 )
	///end IMPROVE_HISTOGRAM_PLOT_IN_ONE_GRAPH
	{
		nRows = nNumLayers;
		nCols = 1;
		
	}
	else
	{
		nRows = 1;
		nCols = get_report_graph_num_cols(nNumLayers, GetNumFactors(trOp), IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) );
		while( nRows * nCols < nNumLayers )
		{
			if( nRows < nCols )
				nRows++;
			else
				nCols++;
		}		
	}
	
	/// Iris 9/18/2009 QA80-11710-P2 IMPROVE_HISTOGRAM_PLOT_IN_ONE_GRAPH
	//page_arrange_layers(gp, nRows, nCols);
	stLayersGridFormat stFormat;	
	stFormat.nXGap = 2;		
	stFormat.nYGap = 2;			
	stFormat.nLeftMg = 5;			
	stFormat.nRightMg = 5;			
	stFormat.nTopMg = 5;			
	stFormat.nBottomMg = 5;	
	page_arrange_layers(gp, nRows, nCols, &stFormat);
	///end IMPROVE_HISTOGRAM_PLOT_IN_ONE_GRAPH
}
///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA

/// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT
//virtual int GetReportGraphTableColNum(TreeNode& trOp, int nGraphIndex = 0) { return 1; }  
//virtual
int	WksReportOperation::GetReportGraphTableColNum(TreeNode& trOp, int nGraphIndex, bool bSkipPlotInOneGraphNode) 
{
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	/*
	/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
	//if( !bSkipPlotInOneGraphNode && IsPlotAllPlotsInOneGraph(trOp) )
	if( !bSkipPlotInOneGraphNode && IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) )
	///end 	UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
		return 1;
	///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	*/
	if( checkIfAlwaysOnlyOneGraph(trOp, nGraphIndex) )
	{
		return 1;		
	}
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA	

	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode 	trNumCols = trOp.GUI.Output.PlotSettings.GraphNumCols;
	TreeNode 	trNumCols = OP_GUI_GRAPH_ARRANGEMENT_NODE(trOp.GUI).GraphNumCols;
	///end OP_DLG_NEW_STRUCTURE
	if(trNumCols) 
		return trNumCols.nVal;
	return 1;
} 
///end REPORT_GRAPHS_ARRANGEMENT

//virtual
int    	WksReportOperation::GetReportGraphTableRowNum(TreeNode& trOp, int nGraphIndex, bool bSkipPlotInOneGraphNode )
{
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	/*
	/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
	//if( !bSkipPlotInOneGraphNode && IsPlotAllPlotsInOneGraph(trOp) )
	if( !bSkipPlotInOneGraphNode && IsPlotAllPlotsInOneGraph(trOp, nGraphIndex) )
	///end 	UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
		return 1;
	///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	*/
	if( checkIfAlwaysOnlyOneGraph(trOp, nGraphIndex) )
	{
		return 1;		
	}
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	
	int		nNumCols = GetReportGraphTableColNum(trOp, nGraphIndex, bSkipPlotInOneGraphNode);
	if(0 == nNumCols)
	{
		error_report("The number of columns of report graph is 0 in GetReportGraphTableRowNum");
		return 1;
	}	
	double 	dNumRows = GetTotalNumPictureForOneGraphType(trOp, nGraphIndex) / (double)nNumCols;
	int		nNumRows = (int)dNumRows;
	if(dNumRows > nNumRows)
		nNumRows++;
	return nNumRows;
}

/// YuI 03/05/09 QA70-13220 WHOLE_WORKSHEET_INPUT_XYRANGE
/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
//void	WksReportOperation::CheckUpdateReportGraphArrangement(TreeNode& trGUI, int nNumData)
void	WksReportOperation::CheckUpdateReportGraphArrangement(TreeNode& trOp, int nNumData)
///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
{
	TreeNode trGUI = trOp.GUI; /// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	if( !trGUI )
		return;

	TreeNode trInputData = GetInputDataNode(trGUI);
	if( !trInputData || 1 != octree_composite_range_get_entire_worksheet_support(&trInputData) )
		return;
	
	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode 	trNumCols = trGUI.Output.PlotSettings.GraphNumCols;
	TreeNode 	trNumCols = OP_GUI_GRAPH_ARRANGEMENT_NODE(trGUI).GraphNumCols;
	///end OP_DLG_NEW_STRUCTURE
	if( !trNumCols ) 
		return;

	if( 1 == octree_get_auto_support(&trNumCols) )
	{
		/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
		//trNumCols.nVal = get_report_graph_num_cols(nNumData);
		trNumCols.nVal = get_report_graph_num_cols(nNumData, GetNumFactors(trOp), IsPlotAllPlotsInOneGraph(trOp));
		///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	}
}
/// end WHOLE_WORKSHEET_INPUT_XYRANGE

int		WksReportOperation::GetWksCol(DataRange rReport, uint unTableID, uint unColID, Worksheet *pwks)
{
	vector<uint> vnTemp;
	vnTemp.Add(unTableID);
	vnTemp.Add(unColID);
	DataRange rCol;
	if(!rReport.GetSubRange(vnTemp, rCol))
		return -1;
	int nRanges = rCol.GetNumRanges();
	if(nRanges < 1)
		return -1;
	int c1, c2, r1, r2;
	Worksheet wks;
	if(	rCol.GetRange(0, r1, c1, r2, c2, wks ) )
	{
		if(pwks)
			*pwks = wks;
		
		return c1;
	}
	return -1;
}
// This is just a temporary helper function:
bool	WksReportOperation::DestroyUnusedOutputColumns(Worksheet& wks)
{
	Column	col;
start_over:
	foreach(col in wks.Columns)
	{
		if (FALSE == IsOutputUsed(col))
		{
			int		nCol = col.GetIndex();
			
			if (wks.DeleteCol(nCol))
				goto start_over;
			else
			{
				ASSERT(FALSE);	// something wrong, must break out
				break;
			}
		}
	}
	
	return true;
}

//------ Folger 05/22/08 QA80-11574 SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
/*
/// Iris 3/26/2008 v8.0832 ROC_RESULT_DATA_COL_NEED_MORE_LABEL
virtual void AfterDoReport(Datasheet& ds, bool bHierarchy)
//------ End SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES	
{
	//------ Folger 01/02/08 QA70-10890 SAVING_REPORT_SHEET_NAME_AFTER_FITTING
	if ( bHierarchy )
		LT_set_str(LTVAR_LAST_REPORT, ds.m_strBookSheet);
	//------
	
	ds.AutoSize(); ///Iris 02/02/2007 v8.0553 NOT_DO_AUTO_SIZE_ON_FITTED_VALUES_SHEET
}
///end ROC_RESULT_DATA_COL_NEED_MORE_LABEL
*/
//virtual
void	WksReportOperation::AfterDoReport(Datasheet& ds, int nOutputOption )
{
	/// Iris 5/29/2008 STATS_ON_ROWS_2ND_REPORT_WILL_RESIZE_RESULT_COLS
	Tree trOp;
	GetTree(trOp);
	///end STATS_ON_ROWS_2ND_REPORT_WILL_RESIZE_RESULT_COLS
	
	static vector<string> l_vsGlobalString = {
		"",
		LTVAR_FIT_CURVE_SHEET,					//OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET
		LTVAR_FIT_RESIDUAL_SHEET,				//OUTPUT_RESULT_CURVE_RESIDUAL_SHEET
		LTVAR_FIT_FIND_INDEP,					//OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET
		LTVAR_FIT_FIND_DEP,						//OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET
		LTVAR_LAST_REPORT,						//OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET
		LTVAR_PEAK_CHARACTERISTIC_REPORT		//OUTPUT_RESULT_PEAK_CHARACTER_SHEET
		///------ Folger 08/07/09 QA80-13998-P2 BASELINE_DATA_OUTPUT_LT_STRING_NOT_UPDATED_AFTER_DOING_PA_FITTING
		, LTVAR_PA_SUBTRACTED_DATA
		, LTVAR_PA_BASELINE
		///------ End BASELINE_DATA_OUTPUT_LT_STRING_NOT_UPDATED_AFTER_DOING_PA_FITTING
	};
	
	///------ Folger 08/07/09 QA80-13998-P2 BASELINE_DATA_OUTPUT_LT_STRING_NOT_UPDATED_AFTER_DOING_PA_FITTING
	//if ( nOutputOption >= OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET && nOutputOption <= OUTPUT_RESULT_PEAK_CHARACTER_SHEET )
	if ( nOutputOption >= OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET && nOutputOption < OUTPUT_RESULT_END )
	///------ End BASELINE_DATA_OUTPUT_LT_STRING_NOT_UPDATED_AFTER_DOING_PA_FITTING
	{
		///------ Folger 03/26/09 ANALYSIS_OUTPUT_REPORT_SHEET_NAME_SHOULD_BE_EXCLAMATION_CHAR_ENDING
		//LT_set_str(l_vsGlobalString[nOutputOption], ds.m_strBookSheet);
		LT_set_str(l_vsGlobalString[nOutputOption], convert_str_with_exclamation_char_endding(ds.m_strBookSheet));
		///------ End ANALYSIS_OUTPUT_REPORT_SHEET_NAME_SHOULD_BE_EXCLAMATION_CHAR_ENDING
	}
	//special handling for Residual output with sheet:<fittedcurve>, so be cleaned up later
	if ( nOutputOption == OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET )
	{
		/// Iris 5/29/2008 STATS_ON_ROWS_2ND_REPORT_WILL_RESIZE_RESULT_COLS
		//Tree trOp;
		//GetTree(trOp);
		///end STATS_ON_ROWS_2ND_REPORT_WILL_RESIZE_RESULT_COLS
		///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//if (trOp.GUI.Output.Residual && str_to_predefined_type(trOp.GUI.Output.Residual.Sheet.strVal) == PDS_FIT_CURVE )
		TreeNode trResidual = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trOp.GUI);
		if (trResidual && str_to_predefined_type(trResidual.Sheet.strVal) == PDS_FIT_CURVE )
		///end OP_DLG_NEW_STRUCTURE
			///------ Folger 03/26/09 ANALYSIS_OUTPUT_REPORT_SHEET_NAME_SHOULD_BE_EXCLAMATION_CHAR_ENDING
			//LT_set_str(l_vsGlobalString[OUTPUT_RESULT_CURVE_RESIDUAL_SHEET], ds.m_strBookSheet);
			LT_set_str(l_vsGlobalString[OUTPUT_RESULT_CURVE_RESIDUAL_SHEET], convert_str_with_exclamation_char_endding(ds.m_strBookSheet));
			///------ End ANALYSIS_OUTPUT_REPORT_SHEET_NAME_SHOULD_BE_EXCLAMATION_CHAR_ENDING
	}	
	//-----CPY 5/27/08 QA70-11609 CHANGE_PARAM_SHOULD_NOT_AUTO_SIZE_COL_WIDTH
	// just a quick fix for now as this area of code will need rewritten later anyway
	// at this point, commments has not been set so col width is ok, later, in DescStats, Arvin added code
	// to SetOuputColComments, so that was why ChangeParam lead to too wide col width and not the first create
	// so the whole thing is messy so this fix is generally good anyway that we should not resize col width on change param
	//ds.AutoSize();
	/// Iris 5/29/2008 STATS_ON_ROWS_2ND_REPORT_WILL_RESIZE_RESULT_COLS
	//if(getExecMode() <= OEXEM_ON_CREATE)
	if(getExecMode() <= OEXEM_ON_CREATE && IsAutoSizeReport(trOp.GUI) )
	///end STATS_ON_ROWS_2ND_REPORT_WILL_RESIZE_RESULT_COLS
	{
		///Jasmine 08/24/09 QA81-14194 AUTO_SIZE_TO_FIT_DADA
		//ds.AutoSize();//autosize_rowcol(ds, 6, 13, -1, -1, AS_NOHEIGHT);
		autosize_rowcol(ds, 10, -1, -1, -1, 0, 0, 0, -1);
		///End AUTO_SIZE_TO_FIT_DADA
	}
	//-----
}
//------ End SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
//------ Folger 05/22/08 QA80-11574 SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
//virtual	DWORD	GenerateReport(Datasheet& ds, TreeNode& trResult, int nNumInHeading = 0, BOOL bHierarchy = FALSE)
//virtual
DWORD	WksReportOperation::generateReport(Datasheet& ds, TreeNode& trResult, int nNumInHeading, BOOL bHierarchy, int nOutputOption )
//------ End SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES	

///-------
{
	/// Iris 08/20/2007 v8.0685 QA70-10256-P2 FIX_RUNTIME_ERR_AFTER_CHANGE_LASTUSED_THEME_TO_FACTORY_DEFAULT
	if(!ds)
	{
		error_report("Found invalud data sheet in generateReport");
		return 0;
	}
	///end FIX_RUNTIME_ERR_AFTER_CHANGE_LASTUSED_THEME_TO_FACTORY_DEFAULT
	
	if (trResult.IsValid())
	{
		string strTemp;
		
		/// ML 10/19/2005 STATS_ON_ROWS_REPLACE
		///// RVD 9/21/2005 QA70-8105 v8.0310 REPLACE_REPORT_COMPLETELY
		//if( trResult.GetAttribute(TREE_UID, strTemp) && strTemp.GetLength() > 0 )
		//	trResult.SetAttribute(TREE_REPLACE, "1");
		///// end REPLACE_REPORT_COMPLETELY
		int		dwCtrl2 = 0;
		if( trResult.GetAttribute(TREE_UID, dwCtrl2) && dwCtrl2 > 0 )
			trResult.SetAttribute(TREE_REPLACE, "1");
		/// end STATS_ON_ROWS_REPLACE
		
		/// Iris 9/11/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
		//wks.SetReportTree(trResult);
		//ds.SetReportTree(trResult); /// Iris 9/11/06 compiling error, has reported, but now used the codes below to implement
		Page pg;
		ds.GetParent(pg);
		switch(pg.GetType())
		{
		case EXIST_MATRIX:
			//------ CPY Folger 01/02/08 QA70-10890 SAVING_REPORT_SHEET_NAME_AFTER_FITTING
			ASSERT(!bHierarchy);
			bHierarchy = false;
			//------
			MatrixLayer ml(ds);
			ml.SetReportTree(trResult);
			///Arvin 11/20/06 SURFACE_FIT_SET_XY_MAP
			int nRows, nCols;
			double xmin, ymin, xmax, ymax;
			///Cheney 2007-3-29 SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG
			//TreeNode trFC = trResult.FitCurves;
			///Cheney 2007-9-7 SHOULD_JUST_SET_SHOW_AS_FALSE_IF_NOT_CHECK_PLOT_FIT_CURVE
			//TreeNode trFC = trResult.Children.Item(0);
			if(trResult.Children.Count() == 0)
				break;
			TreeNode trFC = trResult.Children.Item(0);
			///end SHOULD_JUST_SET_SHOW_AS_FALSE_IF_NOT_CHECK_PLOT_FIT_CURVE
			///end SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG
			if(!trFC)
				break;
			getXYMap(trFC, nRows, nCols, xmin, xmax, ymin, ymax);
			ml.SetSize(-1, nRows, nCols);
			MatrixObject mo =ml.MatrixObjects(); 
			mo.SetXY(xmin, ymin, xmax, ymax);
			///end SURFACE_FIT_SET_XY_MAP
			break;
		case EXIST_WKS:
			Worksheet wks(ds);
			///Arvin 02/09/07 SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
			//wks.SetReportTree(trResult);
			int nColBegin = 0;
			if(!bHierarchy)
				nColBegin = -1;
			/// Iris 07/13/2007 v8.0659 SUPPRESS_SET_COL_NAME_TO_TAGNAME
			//wks.SetReportTree(trResult, nColBegin);				
			if( trResult && !trResult.IsEmpty() )  /// Iris 4/16/2008 QA80-11282 FIX_ANOVA_ONE_WAY_REPORT_EMPTY_CURVE_SHEET
			{
				/// Iris 12/08/2009 QA81-14813 RECALCULATE_NOT_UPDATE_REPORT_DATA_LABEL
				//wks.SetReportTree(trResult, nColBegin, SETGRTR_NO_SET_COLUMN_NAME_IN_FLAT_FOR_VECTOR);
				DWORD dwOptions = SETGRTR_NO_SET_COLUMN_NAME_IN_FLAT_FOR_VECTOR | SETGRTR_ALWAYS_UPDATE_COLUMN_LABELS;
				wks.SetReportTree(trResult, nColBegin, dwOptions);
				///end RECALCULATE_NOT_UPDATE_REPORT_DATA_LABEL
			}
			///end SUPPRESS_SET_COL_NAME_TO_TAGNAME
			break;
		default:
			return 0;
		}			
		///end SURFACE_FIT_REPORT_MAT_FIT_DATA
		
		/// Iris 3/26/2008 v8.0832 ROC_RESULT_DATA_COL_NEED_MORE_LABEL
		/*
		//------ Folger 01/02/08 QA70-10890 SAVING_REPORT_SHEET_NAME_AFTER_FITTING
		if ( bHierarchy )
			LT_set_str(LTVAR_LAST_REPORT, ds.m_strBookSheet);
		//------
		
		ds.AutoSize(); ///Iris 02/02/2007 v8.0553 NOT_DO_AUTO_SIZE_ON_FITTED_VALUES_SHEET
		*/
		
		//------ Folger 05/22/08 QA80-11574 SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
		//AfterDoReport(ds, bHierarchy);
		AfterDoReport(ds, nOutputOption);
		//------
		///end ROC_RESULT_DATA_COL_NEED_MORE_LABEL
		
		if(trResult.GetAttribute(TREE_UID, strTemp) && strTemp.GetLength() > 0);
			return atoi(strTemp);
	}
	//------
	return 0;
}
///Arvin 11/20/06 SURFACE_FIT_SET_XY_MAP
//virtual
void	WksReportOperation::getXYMap(TreeNode& trResult, int& nRows, int& nCols, double& xMin, double& xMax, double& yMin, double& yMax)
{
	string xyMap; 
	trResult.GetAttribute(STR_XYMAP_ATTRIB, xyMap);
	StringArray strTokens, strNumber;
	strTokens.SetSize(6);
	strNumber.SetSize(6);
	xyMap.GetTokens(strTokens, ';');
	for(int ii = 0; ii < 6; ii++)
	{
		StringArray strTemp;
		strTokens[ii].GetTokens(strTemp, '=');
		strNumber[ii] = strTemp[1];
	}
	
	nRows = atof(strNumber[0]);
	nCols = atof(strNumber[1]);
	xMin = atof(strNumber[2]);
	xMax = atof(strNumber[3]);
	yMin = atof(strNumber[4]);
	yMax = atof(strNumber[5]);
		
}
///end SURFACE_FIT_SET_XY_MAP

//virtual
bool	WksReportOperation::GetOneDataLabel(TreeNode &trOp, int index, int nRowColIndex, string& strDataLabel)
{
	int indexLT = index + 1;
	int nRowColLT = nRowColIndex + 1;
	if(GetDataRules(trOp) & DRR_BY_ROWS)
		strDataLabel = nRowColLT;
	else	
		GetEscapedMainDataString(trOp, strDataLabel, indexLT);
	return true;
}
/// Iris 9/14/04 MOVE_INPUT_DATAPLOT_TO_BASE_CLASS
//---Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
//virtual int AddWksInputDataPlot(int index, GraphLayer& gl, const TreeNode& trOp, 
//		int PlotType = IDM_PLOT_SCATTER, bool bRescale = true)
/// Iris 08/01/2007 QA70-10133 ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
//virtual int AddWksInputDataPlot(int index, GraphLayer& gl, const TreeNode& trOp, 
//		int nPlotType = IDM_PLOT_SCATTER, bool bRescale = true, int nXIndex = 0, int nYIndex = 0)
//virtual
int	WksReportOperation::addWksInputDataPlot(int index, GraphLayer& gl, const TreeNode& trOp, int nGraphIndex,
		int nPlotType, bool bRescale, int nXIndex, int nYIndex )
///end ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
//---
{
	
	DataRange rngInput;
	bool bRet = GetInput(rngInput);
	if(!rngInput)
		return -1;
	
	///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	/*
	DataRange dpRange;
	rngInput.GetSubRange(dpRange, GetDataRules(trOp), index);
	if(!dpRange)
		return error_report("Error in adding Input data to report graph");
	int nPlot = gl.AddPlot(dpRange, PlotType);
	*/
	/// ML 10/2/2006 NLFIT_CURVES_CLEANUP
	/*
	int 	nPlot;
	if(GetReportGraphTableColNum(trOp) > 1)
	{
		nPlot = plot_wks_one_xy_from_data_range(rngInput, gl, PlotType, nXIndex, YIndex);			
	}
	else
	{
		DataRange dpRange;
		rngInput.GetSubRange(dpRange, GetDataRules(trOp), index);
		if(!dpRange)
		{
			error_report("Error in adding Input data to report graph");
			return -1;
			
		}			
		nPlot = gl.AddPlot(dpRange, PlotType);
	}
	*/
	int nPlot = PlotInputData(rngInput, trOp, gl, index, nPlotType, nXIndex, nYIndex);
	/// end NLFIT_CURVES_CLEANUP
	
	///Arvin 02/14/08 QA70-11094-P3 FITTED_CURVES_COLOR_FOLLOW_SOURCE_GRAPH_IF_CHECK_SET_COLOR
	//As max said, we should increment colors of source data plots by dataset index.
	if(IsPlotAllPlotsInOneGraph(trOp, nGraphIndex))
	{
		DataPlot dp = gl.DataPlots(nPlot);
		if(dp)
		{
			dp.SetColor(SYSCOLOR_BLACK + index);
		}
	}
	///end 	FITTED_CURVES_COLOR_FOLLOW_SOURCE_GRAPH_IF_CHECK_SET_COLOR
	
	///end MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	if(nPlot>=0)
	{
		if(bRescale)
		{
			/// Iris 07/31/2007 QA70-10133 CHECK_DO_RESCALE_IF_DATA_OUTSIDE
			//gl.Rescale();		
			/// Iris 08/01/2007 QA70-10133 ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
			//int		nOutcome;
			//gl.Rescale(ANL_CHK_DATA_OUTSIDE, &nOutcome);
			int	nRescalOption = 0;
			/// Iris 08/01/2007 QA70-10073 FIND_BETTER_WAY_TO_CHECK_IF_GRAPH_EXISTS
			//if( hasPlottedReportCurve(trOp, nGraphIndex, index) )
			/// Iris 08/02/2007 v8.0673 QA70-10073 FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
			//if( isReportGraphExisted(trOp, nGraphIndex, index) )
			if( hasPlottedOnReportGraph(nGraphIndex, index) )
			///end FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
			///end FIND_BETTER_WAY_TO_CHECK_IF_GRAPH_EXISTS
				nRescalOption |= ANL_CHK_DATA_OUTSIDE;
			
			int		nOutcome;
			gl.Rescale(nRescalOption, &nOutcome);
			///end ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
			///end CHECK_DO_RESCALE_IF_DATA_OUTSIDE
		}
	}
	
	return nPlot;
}	
///End MOVE_INPUT_DATAPLOT_TO_BASE_CLASS

/// ML 10/2/2006 NLFIT_CURVES_CLEANUP
//virtual
int	WksReportOperation::PlotInputData(DataRange &rngInput, const TreeNode& trOp, GraphLayer& gl, int index, int nPlotType, int iIndep, int iDep)
{
	DataRange	dpRange;
	rngInput.GetSubRange(dpRange, GetDataRules(trOp), index);
	if(!dpRange)
	{
		error_report("Error in adding Input data to report graph");
		return -1;
		
	}	
	/// Iris 08/13/2007 QA70-10212-P1 TO_KEEP_SOURCE_DATA_PLOT_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	//int			nPlot = gl.AddPlot(dpRange, nPlotType);
	int			nPlot = -1;
	vector<int> 	vnPlotIndices;
	/// Hong 03/25/09 QA80-12551 RESET_PLOT_ROW_RANGE_IF_USER_UPDATE_INPUT_DATARANGE_WHEN_CHANGE_PARAMETER
	//if( check_has_plotted_in_graph(dpRange, gl, vnPlotIndices) > 0 && vnPlotIndices.GetSize() >0 )
	if( check_has_plotted_in_graph(dpRange, gl, vnPlotIndices, NTYPE_BOOKSHEET_XY_RANGE, true) > 0 && vnPlotIndices.GetSize() >0 )
	/// end RESET_PLOT_ROW_RANGE_IF_USER_UPDATE_INPUT_DATARANGE_WHEN_CHANGE_PARAMETER
		nPlot = vnPlotIndices[0];
	else
	{
		uint 	dwCntrl = GAP_USE_TEMPLATE;
		nPlot = gl.AddPlot(dpRange, nPlotType, dwCntrl);
	}
	///end TO_KEEP_SOURCE_DATA_PLOT_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	return nPlot;
}
/// end NLFIT_CURVES_CLEANUP
//------ Folger 03/19/08 QA80-10598 NEW_GETN_LOCALIZAED_CHECK_MACRO
void WksReportOperation::FilterStatsReport(const TreeNode &trQuantities, const TreeNode &trCalculation)
{
	/// Iris 2/02/2010 QA81-14994 FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
	// uncheck all output options in stats on col, click ok, still report with an empty table.
	// so if there is no any option checked, need set stats table as hidden.
	if( trQuantities )
	{
		bool bIsEmpty = true;
		foreach(TreeNode trN in trQuantities.Children)
		{
			TreeNode trOneCheck = trN.FirstNode? trN.FirstNode : trN;
			while( trOneCheck )
			{
				if( trOneCheck.ID == TRGP_CHECK && tree_is_true(trOneCheck) )
				{
					bIsEmpty = false;
					break;
				}
				trOneCheck = trOneCheck.NextNode;			
			}
		}
		TreeNode trStatsTable = trCalculation.Statistics;
		if( trStatsTable )
		{
			trStatsTable.Show = !bIsEmpty;
		}
	}
	///End FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
	
	double dRLS = 0;
	LT_get_var("@RLS", &dRLS);
	if ( dRLS == 0 )
	{
		tree_copy_values_to_attributes(trQuantities, trCalculation, STR_LABEL_ATTRIB);
	}
	else
	{
		tree_copy_values_to_attributes(trQuantities, trCalculation);
		octree_copy_atts_by_id(&trQuantities, &trCalculation, STR_LABEL_E_ATTRIB, NULL, NULL, STR_LABEL_ATTRIB, true);
	}
	/// Iris 2/12/2010 TO_FIX_PEARSONS_R_VALUE_APPEAR_IN_REPORT_TABLE_IN_PR_AS_DEFAULT
	// Pearson'r should only show in Linear Fit, and default checked. 
	octree_copy_atts_by_id(&trQuantities, &trCalculation, STR_SHOW_ATTRIB);
	///End TO_FIX_PEARSONS_R_VALUE_APPEAR_IN_REPORT_TABLE_IN_PR_AS_DEFAULT
	
	/// Iris 4/30/2008 QA80-11303 KEEP_GUI_SIMPLE_JUST_CHANGE_REPORT_TABLE_TITLE
	if(trCalculation.Parameters && trQuantities.Parameters.Confidence)
	{
		string	strPrefix = ftoa(trQuantities.Parameters.Confidence.dVal);
		strPrefix.TrimRight('.'); //always has . after number in getn
		strPrefix += "% ";
		foreach(TreeNode trOneParam in trCalculation.Parameters.Children)
		{
			if(trOneParam.LCL)
				trOneParam.LCL.SetAttribute(STR_LABEL_ATTRIB, strPrefix + "LCL");
			if(trOneParam.UCL)
				trOneParam.UCL.SetAttribute(STR_LABEL_ATTRIB, strPrefix + "UCL");
		}
		//------ Folger 08/18/08 QA80-11303 ADD_PERCENTAGE_PREFIX_FOR_LCL_UCL_IN_SUMMARY_TABLE
		if ( trCalculation.Summary )
		{
			foreach(TreeNode trRow in trCalculation.Summary.Children)
			{
				foreach(TreeNode trCol in trRow.Children)
				{
					LPCSTR lpcszSubHeader = "SubHeader0";
					if ( trCol.tagName.Find("_LCL") >= 0 )
						trCol.SetAttribute(lpcszSubHeader, strPrefix + "LCL");
					else if ( trCol.tagName.Find("_UCL") >= 0 )
						trCol.SetAttribute(lpcszSubHeader, strPrefix + "UCL");				
				}
			}
		}
		//------ End ADD_PERCENTAGE_PREFIX_FOR_LCL_UCL_IN_SUMMARY_TABLE
	}
	///end KEEP_GUI_SIMPLE_JUST_CHANGE_REPORT_TABLE_TITLE
}
//------

#define OUTPUT_RESULT_CURVE_SHEET_RNG_INDEX_NEW				OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX+1000

BOOL	WksReportOperation::executeWithRange(int nExecMode, DWORD dwExecCntrl)
{
	PROFILE_HRGLASS
	bool bBatchProcessing = false;

	m_nExecMode = nExecMode; //---- CPY 5/27/08 QA70-11609 CHANGE_PARAM_SHOULD_NOT_AUTO_SIZE_COL_WIDTH
	
	/// Iris 11/05/2009 QA81-14599 FIX_STATS_ON_COLS_PLOT_REPORT_GRAPHS_VERY_SLOW
	m_nNumFactors = -1;
	m_n2ndGroupNumFactors = -1;
	///end FIX_STATS_ON_COLS_PLOT_REPORT_GRAPHS_VERY_SLOW	

	Tree			trOperation;
	GetTree(trOperation);
	
	// This is not used directly in this function, just check to make sure it's present:		
	TreeNode		trGUI = trOperation.GUI;
	if( !trGUI.IsValid() )
		return FALSE;
		
	////////////////////////
	// Input data:
	DataRange		rngInput;
	if ( !GetInput(rngInput) )
	{
		return error_report("executeWithRange found no input range");
	}
	
	/// ML 9/12/2005 CLEANING_UP_FACTORS_MAP_IN_DATARANGE
	// Must force recreation of auxiliary factor maps:
	rngInput.CleanupAuxData();
	/// end CLEANING_UP_FACTORS_MAP_IN_DATARANGE


	
	DWORD dwRules = GetDataRules(trOperation);
	
	/// YuI 12/22/06 WANT_GUI_TO_SHOW_OPERATION_INFO
	/// YuI 11/12/08 ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
	//	OperationBase::OnBeforeExecute();
	/// Hong 01/04/10 QA80-14907-P1 TAKE_BACK_SCRIPT_BEFORE_FITTING
	//OperationBase::OnBeforeExecute(nExecMode);
	OnBeforeExecute(nExecMode);
	/// end TAKE_BACK_SCRIPT_BEFORE_FITTING
	/// end ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
	/// end WANT_GUI_TO_SHOW_OPERATION_INFO
	
	/// Iris 11/16/06 CLEAR_OUT_TABLES_BEFORE_CALC_WHEN_DO_CHANGE_PARAMS
	//OnBeforeCalculations(trOperation);
	OnBeforeCalculations(trOperation, nExecMode);
	///end CLEAR_OUT_TABLES_BEFORE_CALC_WHEN_DO_CHANGE_PARAMS
	
	/// YuI 07/10/08 unnecesary call. the function does nothing. So I commented it out
	/*
	/// Iris 9/30/04 BASE_CLASS_CHECK_INPUT_DATA
	/// YuI 06/07/06 INPUT_DATA_HAS_TO_BE_RESOLVED_BEFORE_USE
	//	if(!CheckInputData(trGUI))
	if( !checkResolveInputData(trGUI) )
	/// end INPUT_DATA_HAS_TO_BE_RESOLVED_BEFORE_USE
		return error_report("Operation Execute failed at CheckInputData");
	///End BASE_CLASS_CHECK_INPUT_DATA
	*/
	/// end YuI
	int		nTotalNumData = 0;
	///Arvin 01/29/08 GENERATE_REPORT_FOR_LT_NLFit
	/// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	/*
	TreeNode trFitWorkArea = trOperation.FitWorkArea;
	if(trFitWorkArea)
	{
		GetExecuteCtrl(trFitWorkArea, dwExecCntrl);
	}	
	*/
	GetExecuteCtrl(trOperation, dwExecCntrl);
	/// end NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	///end 	GENERATE_REPORT_FOR_LT_NLFit
	if(!CalcMultiData(trOperation, rngInput, nTotalNumData, nExecMode, dwExecCntrl))
		return error_report("Operation Execute failed at CalcMultiData");
	
	/// YuI 03/05/09 QA70-13220 WHOLE_WORKSHEET_INPUT_XYRANGE
	if( OEXEM_ON_AUTOUPDATE_MANUAL == nExecMode || OEXEM_ON_AUTOUPDATE_TASK == nExecMode )
	{
		/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
		//CheckUpdateReportGraphArrangement(trGUI, nTotalNumData);
		CheckUpdateReportGraphArrangement(trOperation, nTotalNumData);
		///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	}
	/// end WHOLE_WORKSHEET_INPUT_XYRANGE

	///Cheney 2007-4-12 ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA
	AddHintsForMissingAndMasked(trOperation);
	///end ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA
	
	/// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT
	prepareGraphNodes(trOperation); 
	///end REPORT_GRAPHS_ARRANGEMENT

	/// ML 10/17/2005 QA70-8118 OUTPUT_LOG_VIA_PAGENAME
	Page			pgFirstInput;
	/// end OUTPUT_LOG_VIA_PAGENAME
	
	//--------- CPY 7/6/04 ADD_SUPPORT_FOR_BY_ROWS
	if((DRR_BY_ROWS & dwRules) && OEXEM_ON_CALCULATE_ONLY != nExecMode)
	{
		dwRules &= ~DRR_BY_ROWS;
		vector<string> vsTemp; // NULL ref is not working for some reason
		Worksheet	wksInput1;// better not use wksInputFirstRange above, as it might not be ok to reattach another time
		int nNumData = rngInput.GetNumData(dwRules, NULL, &wksInput1);
		for (int ii = 0; ii < nNumData; ii++)
		{
			UpdateDataSourceInReportingHeader(trOperation.Calculation.Input, vsTemp, ii); // if by row, cannot have factors			
		}

		/// ML 10/17/2005 QA70-8118 OUTPUT_LOG_VIA_PAGENAME
		if (wksInput1)
			wksInput1.GetParent(pgFirstInput);
		/// end OUTPUT_LOG_VIA_PAGENAME
	}
	//---------
	OnAfterCalculations(trOperation);
	
	//--- CPY 3/24/04
	/// ML 3/13/2007 QA70-9477 PROPER_OCOPERATION_CLEANUP_AFTER_EXEC    
	//OperationBase::OnAfterExecute();
	// See the comment in WksReportOperation::Execute().
	/// end PROPER_OCOPERATION_CLEANUP_AFTER_EXEC
	/// ML 3/15/2007 PROPER_CALLING_TO_UPDATE_EXE_INFO
	UpdateExecutionInfo();	// needed here so that UpdateReportingTables() can build proper Notes table. 
	/// end PROPER_CALLING_TO_UPDATE_EXE_INFO
	UpdateReportingTables(trOperation, nTotalNumData, nExecMode);
	//---
	/// ML 3/30/2007 NO_LABELS_IN_PARAMETERS_TABLE_WHEN_EXECUTE_SIMPLE_OC
	
	//------ Folger 03/19/08 QA80-10598 NEW_GETN_LOCALIZAED_CHECK_MACRO
	//tree_copy_values_to_attributes(trGUI.Quantities, trOperation.Calculation, STR_LABEL_ATTRIB);///Danice 5/5/04 QA70-6341 v8.0865 SETREPORTTREE_ENABLE_CONTROL
	FilterStatsReport(trGUI.Quantities, trOperation.Calculation);
	//------ End NEW_GETN_LOCALIZAED_CHECK_MACRO
	
	/// end NO_LABELS_IN_PARAMETERS_TABLE_WHEN_EXECUTE_SIMPLE_OC
	
	if(OEXEM_ON_CALCULATE_ONLY == nExecMode)
	{
		ConvertEscapedStrings(trOperation.Calculation);
		SetTree(trOperation);
		return true;
	}
	

	/// ML 3/30/2007 NO_LABELS_IN_PARAMETERS_TABLE_WHEN_EXECUTE_SIMPLE_OC
	//tree_copy_values_to_attributes(trGUI.Quantities, trOperation.Calculation, STR_LABEL_ATTRIB);///Danice 5/5/04 QA70-6341 v8.0865 SETREPORTTREE_ENABLE_CONTROL
	/// end NO_LABELS_IN_PARAMETERS_TABLE_WHEN_EXECUTE_SIMPLE_OC

	/// Iris 2/02/2010 QA81-14994 FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET	
	m_bNoReportTable = checkIfNoReportTable(trOperation); 
	///End FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET

	//////////////////////////
	// Report:	
	bool bCreateReportSheet = isOutputReportSheet(trGUI);
	bool bInsertCurves = false;
	//bool bInsertResultsToSrcWks = IsOutputInsertColsToDataSheet(trGUI, bInsertCurves); /// Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
	bool bToResultsLog = IsOutputToResultsLog(trGUI);	/// ML 7/27/2004 QA70-6667 RESULTS_LOG_AS_GRID
	/// Iris 7/10/06 v8.0440 QA70-7001-P14 NOT_CREATE_RESULT_CURVE_SHEET_IF_NO_REPORT_GRAPH 
	//bool bCreateResultsCurveSheet = IsOutputSeparateResultCurveSheet(trGUI);
	bool bCreateResultsCurveSheet = IsOutputSeparateResultCurveSheet(trOperation); 
	///end NOT_CREATE_RESULT_CURVE_SHEET_IF_NO_REPORT_GRAPH	
	bool bCreateResidualCurveSheet = IsOutputSeparateResidualCurveSheet(trOperation);/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	bool bCreateClibrationSheet = IsOutputSeparateCalibrationSheet(trOperation);
	
	/// Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
	bool bInsertResultsToSrcWks = isOutputInsertColsToDataSheet(trGUI, bInsertCurves);
	///end OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
	
	/// Hong 04/14/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	bool bCreatePeakCharacterSheet = IsOutputPeakCharacterSheet(trOperation);
	/// end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET

	/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	/// YuI 06/23/09 QA70-13835 ORIGIN_FREEZE_AFTER_DESCRIPTIVE_STATISTICS
	//	bool bCreateSubtractedDataSheet = IsOutputSubtractedDataSheet(trOperation);
	//	bool bCreateBaselineDataSheet = IsOutputBaselineDataSheet(trOperation);
	bool bCreateSubtractedDataSheet = (IsOutputSubtractedDataSheet(trOperation) == REPORT_CREATE);
	bool bCreateBaselineDataSheet = (IsOutputBaselineDataSheet(trOperation) == REPORT_CREATE);
	/// end ORIGIN_FREEZE_AFTER_DESCRIPTIVE_STATISTICS
	///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	
	bool bInsertResultsToNewSheet = IsOutputDataResultsToNewSheet(trGUI);
	if(bInsertResultsToSrcWks || bInsertResultsToNewSheet && bCreateReportSheet)
	{
		if(bInsertResultsToSrcWks)
		{
			if(!bInsertCurves)
			{
				doInsertedColumns(trOperation, 0, nTotalNumData, rngInput);
				bCreateReportSheet = false;// CPY 11/30/04, if we support putting results into source, then no report should be created
			}
			else
			{			
				if(bInsertCurves)
				{
					bCreateResultsCurveSheet = false;
					for(int nIndex = 0; nIndex < GetTotalNumPictureForOneGraphType(trOperation); nIndex++)
					{
						doInsertedColumns(trOperation, nIndex, nTotalNumData, rngInput, GetOutputRangeIndex(trOperation, GRAPH_FIT_CURVE));				
					}
				}

			}
		}
		else
		{
			InsertResultToNewSheet(trOperation, rngInput, 0, nTotalNumData);
			bCreateReportSheet = false;
		}
	}
	///end STATS_ON_ROW_OUTPUT_RESULTS_TO_SHEET
	
	/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	//if(bCreateReportSheet || bCreateResultsCurveSheet)
	/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	//if(bCreateReportSheet || bCreateResultsCurveSheet || bCreateResidualCurveSheet || bCreateClibrationSheet)
	if(bCreateReportSheet || bCreateResultsCurveSheet || bCreateResidualCurveSheet || bCreateClibrationSheet
		|| bCreatePeakCharacterSheet
		|| bCreateSubtractedDataSheet
		|| bCreateBaselineDataSheet
		)
	///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	///End REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	{
			
		/// YuI 8/13/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
		///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
		//Worksheet	wksInputFirstRange;
		Datasheet	dsInputFirstRange; 
		///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
		vector<int>	vFactorSizes;
		///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
		//int nNumData = rngInput.GetNumData(dwRules, NULL, &wksInputFirstRange, &vFactorSizes);
		int nNumData = rngInput.GetNumData(dwRules, NULL, &dsInputFirstRange, &vFactorSizes);
		///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
		/// end NLFITTER_OPERATION_IMPLEMENTATION
		/// ML 10/17/2005 QA70-8118 OUTPUT_LOG_VIA_PAGENAME
		///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
		//if (wksInputFirstRange)
			//wksInputFirstRange.GetParent(pgFirstInput);
		rngInput.GetParent(dsInputFirstRange); // DataRange::GetNumData only support wks
		if (dsInputFirstRange)
			dsInputFirstRange.GetParent(pgFirstInput);
		///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
		/// end OUTPUT_LOG_VIA_PAGENAME
		
		bool		bNewBookCreated = false, bNewResultCurvesBookCreated = false;
		DataRange 	rgReportSheetOutput;//, rgResultCurveSheet;
		Worksheet	wksOutput;//, wksResultCurves;
		int			numFactors = vFactorSizes.GetSize();
		int			nNumInHeading = GetNumberAdditionalRowsOrColumnsInHeading(nNumData, numFactors);
		
		/// Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
		///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
		//Worksheet	wksFitCurve;
		//if( !bCreateResultsCurveSheet )
			//wksFitCurve = wksInputFirstRange;
		Datasheet	dsFitCurve;
		if( !bCreateResultsCurveSheet )
			dsFitCurve = dsInputFirstRange;
		///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
		///end OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK		

		if(bCreateReportSheet)
		{
			///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
			//if (!doReportSheet(trOperation, true, false, nNumInHeading, wksOutput, wksInputFirstRange, rgReportSheetOutput, bNewBookCreated))
			if (!doReportSheet(trOperation, true, false, nNumInHeading, wksOutput, dsInputFirstRange, rgReportSheetOutput, bNewBookCreated))
			///end 	FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
				return false;
		}
		/// Iris 2/02/2010 QA81-14994 FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET	
		else
		{
			// If output report table sheet and fit curve sheet in first time, then change param to uncheck all tables, 
			// need remove the output of the report table sheet. RemoveOutput will change the order of output, so use
			// the following way same as PA to set an empty data range.
			for(int nDataIndex = 0; nDataIndex < nTotalNumData; nDataIndex++)
			{
				DataRange dr;
				dr.Create();
				dr.GetUID(true);
				Project.AddDataRange(dr);
				
				int nOutIndex = GetOutputSlot(nDataIndex, true, OUTPUT_REPORT_SHEET_RNG_INDEX);
				SetOutput(dr, nOutIndex);
			}
		}
		///End FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
		
		///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
		//DoAllResultsCurveSheet(trOperation, nTotalNumData, wksInputFirstRange, wksOutput, wksFitCurve, bCreateResultsCurveSheet, bCreateResidualCurveSheet);
		///Arvin 05/24/07 SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
		//DoAllResultsCurveSheet(trOperation, nTotalNumData, dsInputFirstRange, wksOutput, dsFitCurve, bCreateResultsCurveSheet, bCreateResidualCurveSheet);
		/// Hong 04/14/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
		//DoAllResultsCurveSheet(trOperation, nTotalNumData, dsInputFirstRange, wksOutput, dsFitCurve, bCreateResultsCurveSheet, bCreateResidualCurveSheet, nExecMode);
		doAllResultsCurveSheet(trOperation, nTotalNumData, dsInputFirstRange, wksOutput, dsFitCurve, bCreateResultsCurveSheet, bCreateResidualCurveSheet, bCreatePeakCharacterSheet, nExecMode);
		/// end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
		///END SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
		///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
		///end CLEAN_ALL_RESULTS_CURVES_SHEETSCODE		
		
		/// Hong 11/15/08 QA80-12584 v8.0972 SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
		// Hong, here we have the chance to place raw src dataplot with fit source dataplot, because only comes here that report sheets are ready,
		// like PA to use subtracted data as source dataplot if have
		CheckReplaceSourceDataPlot(trOperation, nTotalNumData);
		/// end SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
		
		//if(bCreateResultsCurveSheet || bCreateResidualCurveSheet)  /// Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
		if(bCreateReportSheet)		//---- Iris 11/23/06 FIX_IF_NOT_REPORT_WKS_RESULT_FAIL_OUTPUT_IN_LOG 
		{
			///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
			//if (!doReportSheet(trOperation, false, true, nNumInHeading, wksOutput, wksInputFirstRange, rgReportSheetOutput, bNewBookCreated))
			if (!doReportSheet(trOperation, false, true, nNumInHeading, wksOutput, dsInputFirstRange, rgReportSheetOutput, bNewBookCreated))
			///end 	FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT			
				return false;			
		}
		
		applyThemeToReportSheet(trOperation, rgReportSheetOutput, nTotalNumData);		
		
		
/// ML 6/30/2006 QA70-8768 BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
#ifndef		__BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
// Since the graphs are not any more in the report, addGraphsToReport() (which now only sets up buttons for opening
// of graphs) needs to be called before GenerateWksReport() (see above).
/// end BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
		if(bCreateReportSheet)
		{
			if(!addGraphsToReport(trOperation, wksOutput, rgReportSheetOutput))
				return error_report("****** AddGraphsToReport failed!");
		}
/// ML 6/30/2006 QA70-8768 BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
#endif		// !__BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
/// end BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
//---- CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
		// it seems to me that we can always keep the fit curves hidden in the calculation branch
/*
		///Iris 4/01/05 FIT_REGRESSION_PLOTS
		//if(trOperation.Calculation.FitCurves.Show != nOldFitCurvesShow)
		//	trOperation.Calculation.FitCurves.Show = nOldFitCurvesShow;// need to do this after addGraphsToReport as it will call SetReportTree again with .Enable to update graphs
		int index = 0;
		foreach(TreeNode trSubNode in trOperation.Calculation.Children)
		{
			if(is_in_ids_range(trSubNode, IDST_FIT_CURVES, IDST_FIT_PARTIAL_REGRESSION_DATA, nTotalNumData) && index<vnFitCurvesShow.GetSize())
				trSubNode.Show = vnFitCurvesShow[index++];
		}
		///end FIT_REGRESSION_PLOTS
*/		
		
		/// ML 7/25/2006 NEW_TABLE_ON_AUTOUPDATE_BUG
		//UpdateSourceGraphFromReport(trOperation, rgReportSheetOutput, nTotalNumData);
		UpdateSourceGraphFromReport(trOperation, rgReportSheetOutput, nTotalNumData, nExecMode);
		/// end NEW_TABLE_ON_AUTOUPDATE_BUG
		
		/// ML 11/13/2006 THEME_DIGITS_PARAMETERS_TBL
		//OnAfterCreateReport(trOperation, wksOutput, rngInput, bNewBookCreated, nTotalNumData);
		OnAfterCreateReport(trOperation, wksOutput, rngInput, rgReportSheetOutput, nExecMode, bNewBookCreated, nTotalNumData);
		/// end THEME_DIGITS_PARAMETERS_TBL
	}

	
/// ML 9/19/2005 QA70-8118 REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
#ifdef		__OC_GRID_RLOG
/// end REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
	//ML 7/27/2004 QA70-6667 RESULTS_LOG_AS_GRID
	TreeNode		trResult = trOperation.Calculation;
	if (trResult)
	{
		filterReportForResultsLog(trOperation);//---- CPY 8/4/04 

		if ( bToResultsLog )
			SetReportTreeToResultsLog(trOperation.Calculation);
		else
		{		//--------- CPY 8/13/04 ONE_LINE_REPORT_IF_NOT_APPEND_TO_LOG
			Tree trTemp;
			//CPY 10/22/04 Roman suggested single line to results log should not show as tree
			trTemp.AddNode(trOperation.Calculation.Clone(false));
			SetReportTreeToResultsLog(trTemp.Calculation);
				//---------
		}
	}
	else
		out_str("err:Should never happen, Calculation branch missing in operation tree");
/// ML 9/19/2005 QA70-8118 REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
#endif		// __OC_GRID_RLOG
/// end REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
	
	/// end REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
	
	//--- CPY 9/2/04
	bool bDumpScriptWin = IsOutputScriptWindow(trGUI);
	string strNote;
	bool bDumpNotesWin = IsOutputNotesWindow(trGUI, strNote);
/// ML 9/19/2005 QA70-8118 REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
#ifndef		__OC_GRID_RLOG
	if(bDumpScriptWin || bDumpNotesWin || bToResultsLog)
#else		// !__OC_GRID_RLOG
/// end REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
	if(bDumpScriptWin || bDumpNotesWin)
/// ML 9/19/2005 QA70-8118 REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
#endif		// __OC_GRID_RLOG
/// end REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
	{
		
		string strOut;
		convertReportTableToDumpString(trOperation, nTotalNumData, strOut);
		if(bDumpScriptWin)
		{
			outputDumpStringToScriptWindow(strOut);
		}
		
		if(bDumpNotesWin)
		{
			outputDumpStringToNotesWindow(trOperation.GUI, strOut);
		}
		///end NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW
		
		/// ML 9/19/2005 QA70-8118 REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
		#ifndef		__OC_GRID_RLOG
		if ( bToResultsLog )
		{
			outputDumpStringToResultLog(trOperation, strOut, rngInput);
		}
		///end NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW
		#endif		// __OC_GRID_RLOG
		/// end REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG

	}
	//---
	SetTree(trOperation);
	
	//------ Folger 01/04/08 QA70-10890 ALWAYS_RUN_AFTER_FIT_SCRIPT_AFTER_EXECUTE
	//OperationBase::OnAfterExecute();
	/// YuI 11/12/08 ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
	//	OnAfterExecute();
	OnAfterExecute(nExecMode);
	/// end ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
	//------
	
	return true;
}

///Arvin 02/21/08 QA70-10929 NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW
//Clean code and add independent method to output report tables to script window, result log and notes window
void 	WksReportOperation::convertReportTableToDumpString(const TreeNode& trOperation, int nTotalNumData, string& strOut)
{	
	filterReportForStrDump(trOperation, nTotalNumData);

	///Frank 9/15/04 QA70-6903	ADD_OUTPUT_TREE_TO_TABLE_STRING	
	//tree_to_str(trOperation.Calculation, strOut);
	/// Hong 11/05/09 QA80-14547 DUMP_RESULT_TABLE_DEFAULT_USE_LEFT_JUSTIFIED
	//vector<int> vnTableDisplayFormat = { DISPLAY_CENTER, DISPLAY_RIGHT, DISPLAY_RIGHT};
	vector<int> vnTableDisplayFormat = { DISPLAY_CENTER, DISPLAY_LEFT, DISPLAY_LEFT};
	/// end DUMP_RESULT_TABLE_DEFAULT_USE_LEFT_JUSTIFIED
	///Cheney 2007-5-23 QA70-9805 SPEED_UP_STATISTIC_ON_ROW
	//tree_to_str(trOperation.Calculation, strOut,vnTableDisplayFormat);
	TreeNode trReultLog = GetResultLogTree(trOperation);
	tree_to_str(trReultLog, strOut,vnTableDisplayFormat);
	///End	ADD_OUTPUT_TREE_TO_TABLE_STRING	
}
//Output report tables to notes window
bool 	WksReportOperation::outputDumpStringToNotesWindow(const TreeNode& trGUI, const string& strOut)
{
	if(!trGUI)
		return error_report("Invalid GUI tree");;
	
	string strNote;
	bool bDumpNotesWin = IsOutputNotesWindow(trGUI, strNote);
	
	if(strOut.IsEmpty())
	{
		return error_report("Dumping empty string");
	}
	
	if(!strNote.IsEmpty() && str_to_predefined_type(strNote) != PDS_NEW && str_to_predefined_type(strNote) != PDS_NONE)
	{
		Note pgn(strNote);
		if(!pgn)
		{
			pgn.Create();
			pgn.Rename(strNote);
		}
		pgn.Text += strOut;
	}
	else
	{
		Note pgn;
		pgn.Create();
		pgn.Text = strOut;
		///Iris 4/13/05 RENAME_NEW_REPORT_NOTES
		strNote = "Report";
		pgn.Rename(strNote);
		///end RENAME_NEW_REPORT_NOTES
	}
	
	return true;
}

//Output report tables to script window
bool 	WksReportOperation::outputDumpStringToScriptWindow(const string& strOut)
{
	if(strOut.IsEmpty())
	{
		return error_report("Dumping empty string");
	}
	
	LT_execute("type -a");
	out_str(strOut);
	return true;
}

//Output report tables to result log
bool 	WksReportOperation::outputDumpStringToResultLog(const TreeNode& trOperation, const string& strOut, const DataRange& drInput)
{
	if(strOut.IsEmpty())
	{
		return error_report("Dumping empty string");
	}
	
	if (!drInput )
	{
		return error_report("Invalid input data range");
	}
	
	Datasheet dsInputFirstRange;
	drInput.GetParent(dsInputFirstRange); // DataRange::GetNumData only support wks
	Page			pgFirstInput;
	if (dsInputFirstRange)
		dsInputFirstRange.GetParent(pgFirstInput);
	
	string		strName;
	if(!pgFirstInput)
	{
		Worksheet	wksInputFirst;
		DWORD		dwRules = GetDataRules(trOperation);
		int			nNumData = drInput.GetNumData(dwRules, NULL, &wksInputFirst);
		if (wksInputFirst)
			wksInputFirst.GetParent(pgFirstInput);
	}

	if (pgFirstInput)
		strName = pgFirstInput.GetName();
	Project.OutStringToResultsLog("", false, strName);
	strOut.WriteLine(WRITE_OUTPUT_LOG);
	return true;
}

bool 	WksReportOperation::outputReportTablesWithoutGenerateReport(DWORD dwOutputCntrl)
{
	bool bOuputToNotesWin = false;
	bool bOutputToScriptWin = false;
	bool bOuputToResultLog = false;
	if(dwOutputCntrl&OP_OUTPUT_REPORT_TABLES_TO_NOTES_WIN)
		bOuputToNotesWin = true;
	if(dwOutputCntrl&OP_OUTPUT_REPORT_TABLES_TO_SCRIPT_WIN)
		bOutputToScriptWin = true;
	if(dwOutputCntrl&OP_OUTPUT_REPORT_TABLES_TO_RESULT_LOG)
		bOuputToResultLog = true;
	
	if(!bOuputToNotesWin && !bOutputToScriptWin && !bOuputToResultLog)
		return true;
	
	Tree			trOperation;
	GetTree(trOperation);
	//IF not do this, long name of input data columns will keeps escaped strings in dumping string
	ConvertEscapedStrings(trOperation.Calculation);
	DataRange		rngInput;
	if ( !GetInput(rngInput) )
	{
		return error_report("OutputReportTablesWithoutGenerateReport found no input range");
	}
	bool			bRet;
	string			strOut;
	DWORD			dwRules = GetDataRules(trOperation);
	TreeNode		trAdditionalData = tree_check_get_node(trOperation,TREE_INPUTRANGE_ADDITIONAL_DATA_NODE_NAME); 
	int 			nTotalNumData = rngInput.GetNumData(dwRules, trAdditionalData);
	convertReportTableToDumpString(trOperation, nTotalNumData, strOut);
	if(bOutputToScriptWin)
	{
		bRet = outputDumpStringToScriptWindow(strOut);
		if(!bRet)
			error_report("outputDumpStringToScriptWindow failed");
	}
		
	if(bOuputToNotesWin)
	{
		bRet = outputDumpStringToNotesWindow(trOperation.GUI, strOut);
		if(!bRet)
			error_report("outputDumpStringToScriptWindow failed");
	}
	
	if(bOuputToResultLog)
	{
		bRet = outputDumpStringToResultLog(trOperation, strOut, rngInput);
		if(!bRet)
			error_report("outputDumpStringToScriptWindow failed");
	}
	
	return bRet;
}
///end NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW

/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME	
///Sophy 5/29/2008 QA80-10931-P10 CORRECT_STATS_ON_ROWS_RESULT_BOOK_NAME moved from private
//string	WksReportOperation::getResultBookNameFromGUI(const TreeNode& trGUI)
string	WksReportOperation::GetResultBookNameFromGUI(const TreeNode& trGUI)
///end CORRECT_STATS_ON_ROWS_RESULT_BOOK_NAME
{
	string 	strDefault = GetResultBookName(trGUI);
	TreeNode trBookName = trGUI.Output.Report.BookName;
	if(!trBookName)
		return strDefault;
	
	string strName = trBookName.strVal;
	if(strName.IsEmpty())
		return strDefault;
	
	return strName;
}

///Sophy 5/29/2008 QA80-10934-P10 CORRECT_STATS_ON_ROWS_RESULT_BOOK_NAME moved from private
//string	WksReportOperation::getResultSheetNameFromGUI(const TreeNode& trGUI)
string	WksReportOperation::GetResultSheetNameFromGUI(const TreeNode& trGUI)
///end CORRECT_STATS_ON_ROWS_RESULT_BOOK_NAME
{
	string 	strDefault = GetResultSheetName(trGUI);
	TreeNode trSheetName = trGUI.Output.Report.SheetName;
	if(!trSheetName)
		return strDefault;
	
	string strName = trSheetName.strVal;
	if(strName.IsEmpty())
		return strDefault;
	
	return strName;
}
///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME

///Arvin 05/30/07 v8.0629 ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE 
bool 	WksReportOperation::IsSeparateSheetForDataset(const TreeNode& trOp)
{
	bool		bSeparateSheetForDataset = false;
	TreeNode	trRC = trOp.GUI.Output.RCSheet;
	if(trRC)
		bSeparateSheetForDataset = 1 == trRC.nVal? true : false;
	
	return bSeparateSheetForDataset;
}

int 	WksReportOperation::getTotalNumSeparateSheet(const TreeNode& trOp)
{
	if(IsSeparateSheetForDataset(trOp))
		return GetTotalNumData(trOp);
	else
		return 1;
}
///end ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE

///Cheney 2007-9-3 QA70-10331 SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
bool	WksReportOperation::isCalibrationPolyRangeExist(int nIndex,  bool bFindX)
{
	DataRange 	rgResultCurves;
	Worksheet 	wksResultCurves; 	
	return GetOutput(rgResultCurves, wksResultCurves, GetOutputSlot(nIndex, true, bFindX? OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET : OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET));
}
///end SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM

///Arvin 06/15/07 WRONG_HISTOGRAM_AND_BOXCHART_PLOTS_WHILE_DATA_HAVE_FACTORS
//virtual
TreeNode WksReportOperation::GetResultCuveOutputBranch(const TreeNode& trOp)
{
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode 	trCurveBranch = trOp.GUI.Output.Data;
	TreeNode 	trCurveBranch = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trOp.GUI);
	///end OP_DLG_NEW_STRUCTURE
	return 		trCurveBranch;
}
///end WRONG_HISTOGRAM_AND_BOXCHART_PLOTS_WHILE_DATA_HAVE_FACTORS
///Arvin 11/30/06 CLEAN_ALL_RESULTS_CURVES_SHEETSCODE
///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
//void  	WksReportOperation::DoAllResultsCurveSheet(TreeNode& trOperation, int nTotalNumData, Worksheet& wksInputFirstRange, Worksheet& wksOutput,Worksheet& wksFitCurve, bool bCreateResultsCurveSheet, bool bCreateResidualCurveSheet)
///Arvin 05/24/07 SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
//void  	WksReportOperation::DoAllResultsCurveSheet(TreeNode& trOperation, int nTotalNumData, Datasheet& dsInputFirstRange, Worksheet& wksOutput, Datasheet& dsFitCurve, bool bCreateResultsCurveSheet, bool bCreateResidualCurveSheet)
/// Hong 04/14/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
//void  	WksReportOperation::DoAllResultsCurveSheet(TreeNode& trOperation, int nTotalNumData, Datasheet& dsInputFirstRange, Worksheet& wksOutput, Datasheet& dsFitCurve, bool bCreateResultsCurveSheet, bool bCreateResidualCurveSheet, int nExecMode)
void  	WksReportOperation::doAllResultsCurveSheet(TreeNode& trOperation, int nTotalNumData, Datasheet& dsInputFirstRange, Worksheet& wksOutput, Datasheet& dsFitCurve, bool bCreateResultsCurveSheet, bool bCreateResidualCurveSheet, bool bCreatePeakCharacterSheet, int nExecMode)
/// end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
///END SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
{
	//---- Iris 05/28/2007 v8.0628 Got runtime error below for no report graph tools
	if(ConstructGraphNumber() <= 0)
		return;
	//---- 
	
	/// Iris 01/19/2007 v8.0544 OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT
	///Arvin 05/30/07 v8.0629 ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE 
	//bool		bSeparateSheetForDataset = false;
	//TreeNode	trRC = trOperation.GUI.Output.RCSheet;
	//if(trRC)
		//bSeparateSheetForDataset = 1 == trRC.nVal? true : false; //1: Separate, 0: Combined
	bool bSeparateSheetForDataset = IsSeparateSheetForDataset(trOperation);
	///end ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE
	///end OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT
	
	string		strFitCurveBook, strFitCurveSheet;
	string		strResidualCurveBook, strResidualCurveSheet;
	string		strPartialCurveBook, strPartialCurveSheet;
 	string		strFindXBook, strFindXSheet;
 	string		strFindYBook, strFindYSheet;
 	string		strPeakCharacterBook, strPeakCharacterSheet; /// Hong 04/10/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET 	
 	string 		strSubtractedDataBook, strSubtractedDataSheet, strBaselineDataBook, strBaselineDataSheet; /// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP 
 	///Arvin 05/30/07 v8.0629 ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE
	//for(int nDataIndex = 0; nDataIndex < GetTotalNumPictureForOneGraphType(trOperation); nDataIndex++)  /// Iris 9/30/06 ONE_DATA_ONE_REPORT_BOOK
	for(int nDataIndex = 0; nDataIndex < getTotalNumSeparateSheet(trOperation); nDataIndex++)  /// Iris 9/30/06 ONE_DATA_ONE_REPORT_BOOK
	///end ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE
	{			
		//string		strResultsCurveBook, strResultsCurveSheet;
		//Worksheet	wksFitCurve;	/// Iris 10/13/06 v8.0495 OUTPUT_FITCURVE_RESIDUAL_TO_SOURCE_NOT_WORK
		if(bCreateResultsCurveSheet)
		{				
			///Arvin 06/15/07 WRONG_HISTOGRAM_AND_BOXCHART_PLOTS_WHILE_DATA_HAVE_FACTORS
			//TreeNode 	trCurveBranch = trOperation.GUI.Output.Data;
			TreeNode 	trCurveBranch = GetResultCuveOutputBranch(trOperation);
			///end WRONG_HISTOGRAM_AND_BOXCHART_PLOTS_WHILE_DATA_HAVE_FACTORS
			///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
			//if ( !doResultsCurveSheet(trOperation, trCurveBranch, wksInputFirstRange, nDataIndex, strFitCurveSheet, strFitCurveBook, OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, bSeparateSheetForDataset, &wksOutput, &wksFitCurve) )
			///Arvin 05/24/07 SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
			//if ( !doResultsCurveSheet(trOperation, trCurveBranch, dsInputFirstRange, nDataIndex, strFitCurveSheet, strFitCurveBook, OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve) )
			if ( !doResultsCurveSheet(trOperation, trCurveBranch, dsInputFirstRange, nDataIndex, strFitCurveSheet, strFitCurveBook, OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve, nExecMode) )
			///end SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
			///end 	FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
				error_report("Fail to report result curve sheet");
				
		}
			
		/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
		if(bCreateResidualCurveSheet)
		{
			///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE 
			//TreeNode 	trCurveBranch = trOperation.GUI.Output.Residual;
			TreeNode 	trCurveBranch = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trOperation.GUI);
			///end OP_DLG_NEW_STRUCTURE
			///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
			//if ( !doResultsCurveSheet(trOperation, trCurveBranch, wksInputFirstRange, nDataIndex, strResidualCurveSheet, strResidualCurveBook, OUTPUT_RESULT_CURVE_RESIDUAL_SHEET, bSeparateSheetForDataset, &wksOutput, &wksFitCurve) )
			///Arvin 05/24/07 SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
			//if ( !doResultsCurveSheet(trOperation, trCurveBranch, dsInputFirstRange, nDataIndex, strResidualCurveSheet, strResidualCurveBook, OUTPUT_RESULT_CURVE_RESIDUAL_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve) )
			if ( !doResultsCurveSheet(trOperation, trCurveBranch, dsInputFirstRange, nDataIndex, strResidualCurveSheet, strResidualCurveBook, OUTPUT_RESULT_CURVE_RESIDUAL_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve, nExecMode) )
			///end SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
			///end 	FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
				error_report("Fail to report residual curve sheet");
		}
		
		/// Hong 04/14/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
		if ( bCreatePeakCharacterSheet )
		{
			/// Hong 04/10/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
			TreeNode	trPeakCharacter;
			getGUIResultCurveNode(trOperation.GUI, trPeakCharacter, OUTPUT_RESULT_PEAK_CHARACTER_SHEET);		
			if ( trPeakCharacter )				
			{
				if ( !doResultsCurveSheet(trOperation, trPeakCharacter, dsInputFirstRange, nDataIndex, strPeakCharacterSheet, strPeakCharacterBook, OUTPUT_RESULT_PEAK_CHARACTER_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve, nExecMode) )
					error_report("Fail to report peak characterisation sheet");
			}
			/// end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
		}
		/// end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
		
		/// Iris 01/26/2007 v8.0548 UPDATE_MR_DESIGN_BY_MAX
		///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//TreeNode 	trPartialBranch = trOperation.GUI.Output.PartialCurves;
		TreeNode trPartialBranch = OP_GUI_OUTPUT_TO_PARTIALCURVE_BRANCH(trOperation.GUI);
		///end OP_DLG_NEW_STRUCTURE
		///Arvin 04/06/07 v8.0596 SHOULD_NOT_OUTPUT_PARTIAL_DATA_WHEN_UNCHECK_PLOT_IT by olive's suggestion
		//if(trPartialBranch) 
		bool 		bPlot = false;
		///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//TreeNode    trPartialPlot = trOperation.GUI.Residuals.Graph7;
		TreeNode trPartialPlot = OP_GUI_BRANCH_OF_RESIDUAL_PLOTS_CHECKBOX(trOperation.GUI).Graph7;
		///end OP_DLG_NEW_STRUCTURE
		if(trPartialPlot)
			bPlot = trPartialPlot.nVal;

		if(trPartialBranch && bPlot) //ONLY valid in MR
		///end SHOULD_NOT_OUTPUT_PARTIAL_DATA_WHEN_UNCHECK_PLOT_IT
		{
			///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
			//if ( !doResultsCurveSheet(trOperation, trPartialBranch, wksInputFirstRange, nDataIndex, strPartialCurveSheet, strPartialCurveBook, OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET, bSeparateSheetForDataset, &wksOutput, &wksFitCurve) )
			///Arvin 05/24/07 SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
			//if ( !doResultsCurveSheet(trOperation, trPartialBranch, dsInputFirstRange, nDataIndex, strPartialCurveSheet, strPartialCurveBook, OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve) )
			if ( !doResultsCurveSheet(trOperation, trPartialBranch, dsInputFirstRange, nDataIndex, strPartialCurveSheet, strPartialCurveBook, OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve, nExecMode) )
			///end SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
			///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT	
				error_report("Fail to report residual curve sheet");
		}
		///end UPDATE_MR_DESIGN_BY_MAX
		
		/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
		/// Iris 3/24/2009 FIX_CREATE_NEW_NLFIT_FINDXY_REPORT_WHEN_RECALCULATE
		//if( IsOutputSubtractedDataSheet(trOperation) )
		int nReport = IsOutputSubtractedDataSheet(trOperation);
		if( REPORT_INVALID != nReport )
		{
			if( REPORT_CREATE == nReport )
			{
		///End FIX_CREATE_NEW_NLFIT_FINDXY_REPORT_WHEN_RECALCULATE				
				TreeNode	trSubtractedData;
				getGUIResultCurveNode(trOperation.GUI, trSubtractedData, OUTPUT_RESULT_SUBTRACTED_DATA_SHEET);		
				if ( trSubtractedData )				
				{
					if ( !doResultsCurveSheet(trOperation, trSubtractedData, dsInputFirstRange, nDataIndex, strSubtractedDataSheet, strSubtractedDataBook, OUTPUT_RESULT_SUBTRACTED_DATA_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve, nExecMode) )
						error_report("Fail to report subtracted data sheet");
				}
			}
			/// Hong 11/18/08 QA80-12584 v8.0974 PLOT_BASELINE_IN_SRC_GRAPH_IF_ADD_BACK
			else // Hong, This output is optional and can be changed when change parameter, so need check to remove it
			{			
				DataRange		drSubtractedData;
				Datasheet		dsSubtractedData;							
				if ( GetOutput(drSubtractedData, dsSubtractedData, GetOutputSlot(nDataIndex, true, OUTPUT_RESULT_SUBTRACTED_DATA_SHEET)) )
					RemoveOutput(drSubtractedData);
			}
		}/// Iris 3/24/2009 FIX_CREATE_NEW_NLFIT_FINDXY_REPORT_WHEN_RECALCULATE
		/// end PLOT_BASELINE_IN_SRC_GRAPH_IF_ADD_BACK
		
		/// Iris 3/24/2009 FIX_CREATE_NEW_NLFIT_FINDXY_REPORT_WHEN_RECALCULATE
		//if( IsOutputBaselineDataSheet(trOperation) )
		nReport = IsOutputBaselineDataSheet(trOperation);
		if( REPORT_INVALID != nReport )
		{
			if( REPORT_CREATE == nReport )
			{
		///End FIX_CREATE_NEW_NLFIT_FINDXY_REPORT_WHEN_RECALCULATE
				TreeNode	trBaselineData;
				getGUIResultCurveNode(trOperation.GUI, trBaselineData, OUTPUT_RESULT_BASELINE_DATA_SHEET);		
				if ( trBaselineData )				
				{
					if ( !doResultsCurveSheet(trOperation, trBaselineData, dsInputFirstRange, nDataIndex, strBaselineDataSheet, strBaselineDataBook, OUTPUT_RESULT_BASELINE_DATA_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve, nExecMode) )
						error_report("Fail to report baseline data sheet");
				}
			}		
			///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
			/// Hong 11/18/08 QA80-12584 v8.0974 PLOT_BASELINE_IN_SRC_GRAPH_IF_ADD_BACK
			else // Hong, This output is optional and can be changed when change parameter, so need check to remove it
			{ // REPORT_NOT_CREATE				
				DataRange		drBaselineData;
				Datasheet		dsBaselineData;							
				if ( GetOutput(drBaselineData, dsBaselineData, GetOutputSlot(nDataIndex, true, OUTPUT_RESULT_BASELINE_DATA_SHEET)) )
					RemoveOutput(drBaselineData);
			}
			
		} /// Iris 3/24/2009 FIX_CREATE_NEW_NLFIT_FINDXY_REPORT_WHEN_RECALCULATE
		/// end PLOT_BASELINE_IN_SRC_GRAPH_IF_ADD_BACK
			
		/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//TreeNode 	trCalibrationBranch = trOperation.GUI.Calibration;
		TreeNode 	trCalibrationBranch = OP_GUI_CALIBRATION_BRANCH(trOperation.GUI);
		///end OP_DLG_NEW_STRUCTURE
		if(trCalibrationBranch)
		{
			bool	bFindX = true;
			if( IsOutputSeparateCalibrationSheet(trOperation, bFindX) )
			{
				///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
				//if ( !doResultsCurveSheet(trOperation, trCalibrationBranch, wksInputFirstRange, nDataIndex, strFindXSheet, strFindXBook, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET, bSeparateSheetForDataset, &wksOutput, &wksFitCurve) )
				///Arvin 05/24/07 SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
				//if ( !doResultsCurveSheet(trOperation, trCalibrationBranch, dsInputFirstRange, nDataIndex, strFindXSheet, strFindXBook, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve) )
				/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
				//if ( !doResultsCurveSheet(trOperation, trCalibrationBranch, dsInputFirstRange, nDataIndex, strFindXSheet, strFindXBook, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve, nExecMode) )		
				if ( !doResultsCurveSheet(trOperation, trCalibrationBranch, dsInputFirstRange, nDataIndex, strFindXSheet, strFindXBook, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve, nExecMode, false, 0) )
				/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
				///end SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
				///end 	FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
					error_report("Fail to report Calibration curve sheet 1 ");
			}
			///Cheney 2007-9-3 QA70-10331 SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
			else if( isCalibrationPolyRangeExist(nDataIndex, bFindX))
			{
				/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
				//if ( !doResultsCurveSheet(trOperation, trCalibrationBranch, dsInputFirstRange, nDataIndex, strFindXSheet, strFindXBook, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve, nExecMode, true) )
				if ( !doResultsCurveSheet(trOperation, trCalibrationBranch, dsInputFirstRange, nDataIndex, strFindXSheet, strFindXBook, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve, nExecMode, true, 0) )
				/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
					error_report("Fail to report Calibration curve sheet 1 ");
			}
			///end SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
			
			bFindX = false;
			if( IsOutputSeparateCalibrationSheet(trOperation, bFindX) )
			{
				///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
				//if ( !doResultsCurveSheet(trOperation, trCalibrationBranch, wksInputFirstRange, nDataIndex, strFindYSheet, strFindYBook, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET, bSeparateSheetForDataset, &wksOutput, &wksFitCurve) )
				///Arvin 05/24/07 SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
				//if ( !doResultsCurveSheet(trOperation, trCalibrationBranch, dsInputFirstRange, nDataIndex, strFindYSheet, strFindYBook, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve) )
				/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
				//if ( !doResultsCurveSheet(trOperation, trCalibrationBranch, dsInputFirstRange, nDataIndex, strFindYSheet, strFindYBook, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve, nExecMode) )				
				if ( !doResultsCurveSheet(trOperation, trCalibrationBranch, dsInputFirstRange, nDataIndex, strFindYSheet, strFindYBook, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve, nExecMode, false, 1) )
				/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
				///end SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
				///end 	FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
					error_report("Fail to report Calibration curve sheet 2");
			}
			///Cheney 2007-9-3 QA70-10331 SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
			else if( isCalibrationPolyRangeExist(nDataIndex, bFindX))
			{
				/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
				//if ( !doResultsCurveSheet(trOperation, trCalibrationBranch, dsInputFirstRange, nDataIndex, strFindYSheet, strFindYBook, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve, nExecMode, true) )
				if ( !doResultsCurveSheet(trOperation, trCalibrationBranch, dsInputFirstRange, nDataIndex, strFindYSheet, strFindYBook, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET, bSeparateSheetForDataset, &wksOutput, &dsFitCurve, nExecMode, true, 1) )
				/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
					error_report("Fail to report Calibration curve sheet 2 ");
			}
			///end SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
		}			
		///end REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	}
	///Arvin 05/25/07 CLEAN_SURPLUS_REPORT_DATA_WHILE_CHANGE_PARAMETER_TO_LESS_DATASET
	//if(nExecMode == OEXEM_ON_CHANGEPARAM)
	//	CleanAllSurplusReportData(trOperation);
	///end CLEAN_SURPLUS_REPORT_DATA_WHILE_CHANGE_PARAMETER_TO_LESS_DATASET
}
///end CLEAN_ALL_RESULTS_CURVES_SHEETSCODE

///Arvin 05/25/07 CLEAN_SURPLUS_REPORT_DATA_WHILE_CHANGE_PARAMETER_TO_LESS_DATASET
static void _delete_all_range(Datasheet& ds, DataRange& dr)
{
	Page pg;
	ds.GetParent(pg);
	switch(pg.GetType())
	{
	case EXIST_MATRIX:
		MatrixLayer ml(ds);
		MatrixObject moMy(ml, 0);
		moMy.SetFormulaAutoUpdate(AU_NONE);
		ml.Destroy();
		break;
	case EXIST_WKS:
		Worksheet wks(ds);	
		for(int ii = 0; ii < dr.GetNumRanges(); ii++)
		{
			int c1, c2, r1, r2;
			get_range_span(dr, ii, r1, c1, r2, c2);
			for(int jj = c1; jj <= c2; jj++)
			{
				Column col(wks, jj);
				if(col)
				{
					col.SetFormulaAutoUpdate(AU_NONE);
					col.Destroy();
				}
			}
		}
		if(wks.GetNumCols() <= 0)
			wks.Destroy();	
		break;
	}
}

void	WksReportOperation::cleanSurplusReportData(TreeNode& trOp, int nOption)
{
	int nOutIndex = GetTotalNumPictureForOneGraphType(trOp);
	DataRange rgOutput;
	Datasheet dsOutput;
	while(GetOutput(rgOutput, dsOutput, GetOutputSlot(nOutIndex, true, nOption)))
	{
		_delete_all_range(dsOutput, rgOutput);
		nOutIndex++;
	}
}

void 	WksReportOperation::cleanAllSurplusReportData(TreeNode& trOp)
{
	cleanSurplusReportData(trOp, OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET);
	cleanSurplusReportData(trOp, OUTPUT_RESULT_CURVE_RESIDUAL_SHEET);
	cleanSurplusReportData(trOp, OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET);
	cleanSurplusReportData(trOp, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET);
	cleanSurplusReportData(trOp, OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET);
	cleanSurplusReportData(trOp, OUTPUT_RESULT_PEAK_CHARACTER_SHEET); /// Hong 04/10/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
}
///end CLEAN_SURPLUS_REPORT_DATA_WHILE_CHANGE_PARAMETER_TO_LESS_DATASET
/// YuI 08/15/06 MORE_WORK_ON_STATISTICAL_PLOTS
void	WksReportOperation::GetDataPlotEventHandlerName(string& strName, int nDataIndex)
{
	string strGUID;
	int nUID = GetUID(TRUE, &strGUID);
	strName = nUID;
	strName += " " + strGUID + " ";
	strName += nDataIndex;
}
/// end MORE_WORK_ON_STATISTICAL_PLOTS

///Arvin 10/24/06 FITTING_HISTOGRAM_PLOT
/// YuI 04/17/07 QA70-4589 IMPROVED_ANALYSIS_MARKERS
//	BOOL    WksReportOperation::GetResultTableData(TreeNode& trOp, int nResultTableID, int nDataIndex, int nGraphIndex, DataRange& drTable)
BOOL    WksReportOperation::GetResultTableData(TreeNode& trOp, int nResultTableID, int nDataIndex, int nGraphIndex, DataRange& drTable, DataRange& drFitCurvesRange)
/// end IMPROVED_ANALYSIS_MARKERS
{
	if( nResultTableID <= 0)
		return error_report("error, GetResultTableData found bad nResultTableID");
	
	vector<uint> vnTemp;
	vnTemp.Add(nResultTableID);
				
	DataRange rgFitCurvesTable;
	if(!GetResultCurvesDataRange(trOp, rgFitCurvesTable, nDataIndex, nGraphIndex, GetOutputRangeIndex(trOp, nGraphIndex) ))
		return error_report("error, GetResultTableData found bad report range");
		
	if(!rgFitCurvesTable.GetSubRange(vnTemp, drTable, false) || !drTable.IsValid())
		return error_report("error, GetResultTableData found bad sub table range");
	/// YuI 04/17/07 QA70-4589 IMPROVED_ANALYSIS_MARKERS
	if( NULL != drFitCurvesRange )
	{
		drFitCurvesRange = rgFitCurvesTable;
	}
	/// end IMPROVED_ANALYSIS_MARKERS
	
	return true;
}
///end FITTING_HISTOGRAM_PLOT

//////////////////////////////////////////////////////////////////////////////
//

/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
/*
bool WksReportOperation::OnOpenGraph(int nIndex, uint nRowID) // = 0, 0
{
	Tree trOp;
	GetTree(trOp);
	DataRange 	rgOutput;
	Worksheet	wksOutput;
	//if(!GetOutput(rgOutput, wksOutput))
	//	return false;
	if(!GetOutput(rgOutput, wksOutput, OUTPUT_RESULT_CURVE_SHEET_RNG_INDEX))
	{
		if(!GetOutput(rgOutput, wksOutput))
			return false;
	}
	
	DWORD		dwRules = GetDataRules(trOp);
	DataRange	rngInput;
	if ( !GetInput(rngInput) )
	{
		ASSERT(FALSE);
		return false;
	}

	TreeNode	trAdditionalData = tree_check_get_node(trOp,TREE_INPUTRANGE_ADDITIONAL_DATA_NODE_NAME); 
	int			nNumData = rngInput.GetNumData(dwRules, trAdditionalData);


	ReportCreateGraphHelper	crtGraph(CREATE_GRAPH_CREATE_FOR_EDIT, trOp, nIndex);
	if(crtGraph.IsCreate())
	{
		GraphPage gp = crtGraph.GetTempGraph(GetGraphName(), GetGraphTemplate());
		if(gp)
		{
			GraphLayer gl = gp.Layers(0); // assume report graph is always just one layer
			if(PlotReportGraph(nIndex, gl, wksOutput, rgOutput, trOp, nNumData))
				return true;
		}
		crtGraph.DestroyGraph();
	}
	return false
}
*/

bool WksReportOperation::OnOpenGraph(UINT nGraphNodeID, int nPictureIndex)
{
	Tree trOp;
	GetTree(trOp);
	DataRange 	rgOutput;
	Worksheet	wksOutput;
	if(!GetOutput(rgOutput, wksOutput, OUTPUT_RESULT_CURVE_SHEET_RNG_INDEX))
	{
		if(!GetOutput(rgOutput, wksOutput))
			return false;
	}
	
	DWORD		dwRules = GetDataRules(trOp);
	DataRange	rngInput;
	if ( !GetInput(rngInput) )
	{
		ASSERT(FALSE);
		return false;
	}

	// need to get image node from nGraphTableID and nPictureIndex
	TreeNode trGraph = trOp.Calculation.FindNodeByAttribute(STR_ID_ATTRIB, nGraphNodeID);
	if( !trGraph )
		return false;
	TreeNodeCollection	trImageColl(trGraph, CALCULATION_GRAPH_NODE_PREIX);
	int nIndexTemp = 0;
	TreeNode trImage;
	foreach( trImage in trImageColl )
	{
		if( nIndexTemp == nPictureIndex )
			break;
		
		nIndexTemp++;
	}
	int nGraphIndex = nGraphNodeID - IDST_RESULT_GRAPHS;
	
	/// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT
	//addOneGraphPicture(CREATE_GRAPH_CREATE_FOR_EDIT, trOp, trImage, nGraphIndex, nPictureIndex, rgOutput);
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	//addOneGraphPicture(CREATE_GRAPH_CREATE_FOR_EDIT, trOp, trImage, nGraphIndex, 0, nPictureIndex, rgOutput);
	addOneGraphPicture(CREATE_GRAPH_CREATE_FOR_EDIT, trOp, trImage, nGraphIndex, 0, nPictureIndex, 0, rgOutput);
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	///end REPORT_GRAPHS_ARRANGEMENT
	
	/*
	DataRange 	rgReportSheetOutput;
	Worksheet	wksReportSheetOutput;
	if( GetOutput(rgReportSheetOutput, wksReportSheetOutput, OUTPUT_REPORT_SHEET_RNG_INDEX) 
			&& IDST_RESULT_GRAPHS == nGraphNodeID ) //assume Fitted Curves Grpah table always is the first graph
		addOneGraphPicture(CREATE_GRAPH_CREATE_FOR_EDIT, trOp, trImage, nGraphIndex, nPictureIndex, rgReportSheetOutput);
	*/
	///End PASTE_CUSTOM_TABLE_TO_FIT_CURVE_GRAPH_TABLE
	return true;
}

///Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME	
//virtual
void	WksReportOperation::ThemeUpdateLastUsed(LPCSTR lpcszClassName, TreeNode& tr, bool bThemesTree)
{
	theme_update_last_used(lpcszClassName, tr, bThemesTree);

}
///end CORRECT_LOGIC_OF_LOADING_THEME
//////////////////////////////////////////////////////////////





//--------
/// end OPERATION_CREATION_CLEANUP


void	tree_set_oper_multidata_modes(TreeNode &trGUI, int modeMDInput, int modeMDOut)
{
	if ( modeMDInput != MDINPUT_INVALID)
		trGUI.InputData.Use = modeMDInput;
	
	if ( modeMDOut != MDOUT_INVALID)
		trGUI.Output.Use = modeMDInput;
}

/// Iris 4/28/2009 QA80-12784-P4 FIX_HITOGRAM_BIN_INFO_NOT_UPDATE_WHEN_CHANGE_DATA_MODE
//void	tree_oper_multidata_mode_update_rules(DWORD &dwRules, const TreeNode& trOp)
void	tree_oper_multidata_mode_update_rules(DWORD &dwRules, const TreeNode& trGUI)
///end FIX_HITOGRAM_BIN_INFO_NOT_UPDATE_WHEN_CHANGE_DATA_MODE
{
	/// Iris 4/28/2009 QA80-12784-P4 FIX_HITOGRAM_BIN_INFO_NOT_UPDATE_WHEN_CHANGE_DATA_MODE
	//if ( trOp.GUI.IsValid() )
	//{
		//int			modeMDInput = tree_get_oper_multidata_modes(trOp);
	if ( trGUI.IsValid() )
	{
		int			modeMDInput = tree_get_oper_multidata_modes(trGUI);
	///end FIX_HITOGRAM_BIN_INFO_NOT_UPDATE_WHEN_CHANGE_DATA_MODE
		DWORD	dw = ~DRR_COMBINED_MASK;
		dwRules &= dw;		// remove the bits in case there
		switch (modeMDInput)
		{
		case MDINPUT_INDEPENDENT:
			break;
			
		case MDINPUT_CMBND_SIMPLE:
			dwRules |= DRR_COMBINED_SIMPLE;
			break;
			
		case MDINPUT_CMBND_AVE_SE:
			dwRules |= DRR_COMBINED_AVE_SE;
			break;
			
		case MDINPUT_CMBND_AVE_SD:
			dwRules |= DRR_COMBINED_AVE_SD;
			break;			
		}
	}
}
/// end MULTIPLE_DATASET_OPER_TREATMENT 


//not used now, will delect this later.
//void	separate_output_for_multiple_data(TreeNode& trOperation)
//{
	//TreeNode	trInputData = trOperation.GUI.InputData;
	//DataRange	dr;
	//dr.Create(trInputData, false);
	//
	//DWORD		dwRules = DRR_GET_DEPENDENT | DRR_NO_FACTORS | DRR_RAW_ERR_WEIGHT; //just for Fit tools now, will update this later.	
	//int			nNumData = op_get_input_data_number(trOperation.GUI, dwRules);
	//int			nInMode = tree_get_oper_multidata_modes(trOperation.GUI);
	//if(MDINPUT_INDEPENDENT_SEPARATE != nInMode || nNumData<=1 )
		//return;
	//
	//// set out to separate 
	//tree_set_oper_multidata_modes(trOperation.GUI, nInMode, MDOUT_SEPARATE);
	//
	////separate one data range node
	//TreeNodeCollection 	trRanges(trInputData, TREE_Range);	
    //for( int nIndex = 0; nIndex < nNumData; nIndex++ )
    //{		
    	//DataRange 	drSub;
    	//dr.GetSubRange(drSub, dwRules, nIndex);
    	//if(!drSub)
    		//continue;
    	//
 		//Tree 		trSub;
		//drSub.GetTree(trSub, true);
   	//
		//TreeNode trRange;
		//if( nIndex >= trRanges.Count() )
		//{
			//trRange = check_add_enumerated_node(trInputData, "Range", nIndex+1);				
		//}
		//else
		//{
			//trRange = trRanges.Item(nIndex);
		//}		
		//foreach(TreeNode trN in trSub.Children)
		//{
			//TreeNode trItem = tree_check_get_node(trRange, trN.tagName);
			//trItem.strVal = trN.strVal;
		//}
    //}	
	//
//}
///End INDEP_DATA_CONSOLID_OR_SEP_REPORT

///Iris 12/31/04 IMPROVE_ACCESS_ADVANCED_IDS_FUNC
/*
///Iris 12/27/04 IMPROVE_ACCESS_ADVAN_IDS_THEME_FILE
static void _theme_apply_and_set_advanced_ids_attribute(TreeNode& trGUI, const string& strClassOption, string strThemeName)
{
	string strFullpathFile;
	string strThemeFile = theme_get_settings_file(strClassOption, strFullpathFile, strThemeName);
	if( !strThemeFile.IsEmpty() )
	{
		trGUI.SetAttribute(STR_ADVANCED_IDS_THEME_FILE_ATTRIB, strThemeFile);
		//apply, Show is unchecked.
		update_param_tree_advanced_ids(trGUI, 0);
	}
	else
		trGUI.SetAttribute(STR_ADVANCED_IDS_THEME_FILE_ATTRIB, strClassOption);
	update_param_tree_advanced_ids(trGUI, 0);
	
}
///End IMPROVE_ACCESS_ADVAN_IDS_THEME_FILE
*/
///end IMPROVE_ACCESS_ADVANCED_IDS_FUNC

/// Alex 03/27/06 QA70-8551 DEL_ERR_COL_IN_REPORT_TABLE_IF_NOT_INPUT_ERR
bool is_include_special_subrange(const DataRange &dr, string strSubRangeName)
{
	int  r1, c1, r2, c2;
	Worksheet WksTemp;
	if (dr.GetRange(strSubRangeName, r1, c1, r2, c2,WksTemp)>0)
		return true;
	return false;
}
///End DEL_ERR_COL_IN_REPORT_TABLE_IF_NOT_INPUT_ERR

/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
//int		get_report_graph_num_cols(int nNumData)
int		get_report_graph_num_cols(int nNumData, int nNumFactors, bool bIsPlotAllInOneGraph)
///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
{	
	if(nNumData <= 0)
		return 1;
	
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	if( nNumFactors > 0 && bIsPlotAllInOneGraph)
		nNumData = nNumData / nNumFactors;
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	
	double 	dNumCols = sqrt(nNumData);
	int		nNumCols = (int)dNumCols;
	if(dNumCols > nNumCols)
		nNumCols++;
	return nNumCols;
}


//--- Iris 01/16/2007 IMPLEMENT_SSR_DF_ON_COMBINED_DATA
///Arvin 07/18/07 v8.0662 FIT_COMPARISION_OF_DATASETS_INCONSISTENT_BETWEEN_NLFIT_AND_LR
//bool op_fit_on_data(LPCSTR lpcszClass, const XYRange& dr, TreeNode& trResult, LPCSTR lpcszModel, LPCSTR lpcszCateg)
///Echo 07/11/30 QA70-10589-P3 v8.0757	FITCMP_SUPPORT_POLY_ORDER
//bool op_fit_on_data(LPCSTR lpcszClass, const DataRange& dr, TreeNode& trResult, LPCSTR lpcszModel, LPCSTR lpcszCateg)
///------- Folger 07/01/09 QA80-13774-P1 COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
//bool op_fit_on_data(LPCSTR lpcszClass, const DataRange& dr, TreeNode& trResult, LPCSTR lpcszModel, LPCSTR lpcszCateg, int nOrder)
bool op_fit_on_data(LPCSTR lpcszClass, const DataRange& dr, TreeNode& trResult, LPCSTR lpcszModel, LPCSTR lpcszCateg, int nOrder, TreeNode& trOriginalInput/* = NULL*/)
///------- End COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
///end FITCMP_SUPPORT_POLY_ORDER
///end FIT_COMPARISION_OF_DATASETS_INCONSISTENT_BETWEEN_NLFIT_AND_LR
{
	bool 	bOK;
	int 	nOption = 0;
	Operation& op = (Operation &)op_create(lpcszClass, bOK, nOption); 
	if(op == NULL)
	   return false;
	
	Tree 	trOp;
	op.GetTree(trOp);
	///Arvin 03/27/07 QA70-9532 CALLING_SURFACE_FIT_FROM_OC_LT_AND_SUPPORT_MATRIX
	//if ( !op.OnInitDataFromOCLT(trOp, trOp.GUI.InputData, dr, lpcszModel, lpcszCateg) )
	///Arvin 07/18/07 v8.0662 FIT_COMPARISION_OF_DATASETS_INCONSISTENT_BETWEEN_NLFIT_AND_LR
	///------- Folger 07/01/09 QA80-13774-P1 COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
	//if (OP_NOERROR != op.OnInitDataFromOCLT(trOp, trOp.GUI.InputData, dr, lpcszModel, lpcszCateg) )
	if (OP_NOERROR != op.OnInitDataFromOCLT(trOp, trOp.GUI.InputData, dr, lpcszModel, lpcszCateg, true, trOriginalInput) )
	///------- End COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
	///END CALLING_SURFACE_FIT_FROM_OC_LT_AND_SUPPORT_MATRIX
	   	return false;
	
	int            nAutoUpdate = 0;
	///Echo 07/11/30 QA70-10589-P3 v8.0757	FITCMP_SUPPORT_POLY_ORDER
	if (trOp.GUI.Order)
		trOp.GUI.Order.nVal = nOrder;
	///end FITCMP_SUPPORT_POLY_ORDER
	
	op.SetTree(trOp);
	op.OnNoEdit(nOption, nAutoUpdate);
	
	op.Calculate();
	
	op.GetTree(trOp);
	trResult.Reset();
	///Echo 9/26/07 V8.0709 REPLACE_NOT_WORK_FOR_RESET_TREENODE
	//bool bRet = trResult.Replace(trOp.Calculation.Clone());	
	trResult = trOp.Calculation.Clone();
	///END REPLACE_NOT_WORK_FOR_RESET_TREENODE
	//trStatsResult.Replace(trOp.Calculation.RegStats.FirstNode.Clone());
	
	//----- Iris 05/18/2007 v8.0621 temp codes just to debug Replace method, will remove later
	Tree tr;
	bool bRet = tr.Replace(trOp.Calculation.Clone());
	//-----
	
	op_destroy_on_cancel(op);
	return true;

}
//---

///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
#ifdef SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
// virtual
bool WksReportOperation::ApplyTheme(LPCSTR lpcszClassName, TreeNode& trGUI, LPCSTR lpcszThemeName, bool bLoadFactDefault) // = true
{
	/*
	TreeNode trDS = get_external_settings_branch(trGUI);
	
	TreeNode trThemeFilter = tree_get_node_by_id(trDS, IDE_DS_THEME_FILTER, true);
	if ( trThemeFilter )
	{
		if ( !theme_apply_analysis_theme(lpcszClassName, trThemeFilter, lpcszThemeName, bLoadFactDefault) )
			return false;
		ApplyThemeFilterSetting(trGUI, trThemeFilter);
	}
	*/
	
	return theme_apply_analysis_theme(lpcszClassName, trGUI, lpcszThemeName, bLoadFactDefault);
}
#endif // SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
///---END QA80-11371 THEME_SAVING_OPTIONS

///Sophy 11/28/2008 v8.980d CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_ON_ROW_WHEN_CHANGE_PARAMETER
/*
bool		WksReportOperation::HasOutput(int nOutputRangeIndex, int nDataIndex) //0
{
	DataRange	drOutput;
	Datasheet	dsOutput;
	///Sophy 1/21/2009 v8.0962b FIX_FAIL_TO_GET_RESIDUAL_OUTPUT_WHEN_REPORT_TO_FITTEDCURVE_SHEET
	Tree trOperation;
	GetTree(trOperation);
	TreeNode trGUI = trOperation.GUI;
	///Sophy 2/2/2009 v8.0969 CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
	bool bReportToFittedCurveSheet = false;
	TreeNode trSheet;
	///end CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
	switch(nOutputRangeIndex)
	{
	case OUTPUT_RESULT_CURVE_SHEET_RNG_INDEX:
		if ( !IsOutputSeparateResultCurveSheet(trOperation) && isOutputReportSheet(trGUI) )
		{
			TreeNode trResultCurve = RESULT_CURVE_BRANCH(trOperation);
			if ( trResultCurve && _count_curve_tables_without_hidden_tables(trResultCurve) > 0 ) //whether report fitted curve data
				nOutputRangeIndex = OUTPUT_REPORT_SHEET_RNG_INDEX;
		}
		break;
		
	case OUTPUT_RESIDUAL_CURVE_SHEET_RNG_INDEX:
		///Sophy 2/2/2009 v8.0969 CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
		trSheet = trGUI.Output.Residual.Sheet;
		if ( trSheet )
			bReportToFittedCurveSheet = PDS_FIT_CURVE == str_to_predefined_type(trSheet.strVal);
		///end CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
		if ( !IsOutputSeparateResidualCurveSheet(trOperation) &&  ( IsOutputAnyTypeResidualData(trOperation) || IsOutputAnyTypeResidualGraph(trOperation) )&& bReportToFittedCurveSheet ) //residual data reported to fitted curve sheet
			nOutputRangeIndex = OUTPUT_RESULT_CURVE_SHEET_RNG_INDEX;
		break;
		
	case OUTPUT_CALIBRATION_CURVE_SHEET_1_RNG_INDEX:
	case OUTPUT_CALIBRATION_CURVE_SHEET_2_RNG_INDEX:
		///Sophy 2/2/2009 v8.0969 CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
		trSheet = trGUI.Output.FindXY.Sheet;
		if ( trSheet )
			bReportToFittedCurveSheet = PDS_FIT_CURVE == str_to_predefined_type(trSheet.strVal);
		
		bool bReportCalibration = false;
		TreeNode trCal = trOperation.GUI.Calibration;
		if ( HasZ(trOperation) && trCal )
			bReportCalibration = trCal.Use;
		else if ( trCal )
			bReportCalibration = trCal.FirstNode && trCal.FirstNode.Use || trCal.LastNode && trCal.LastNode.Use;
		///end CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
		if ( bReportCalibration && bReportToFittedCurveSheet )
			nOutputRangeIndex = OUTPUT_RESULT_CURVE_SHEET_RNG_INDEX;
		break;
		
	case OUTPUT_RESULT_PEAK_CHARACTER_RNG_INDEX:	
	case OUTPUT_RESULT_SUBTRACTED_RNG_INDEX:
	case OUTPUT_RESULT_BASELINE_RNG_INDEX:
		break;
	default:
		break;
	}
	///end FIX_FAIL_TO_GET_RESIDUAL_OUTPUT_WHEN_REPORT_TO_FITTEDCURVE_SHEET
	return GetOutput(drOutput, dsOutput, OUTPUT_REPORT_SHEET_RNG_INDEX == nOutputRangeIndex ? nOutputRangeIndex :GetOutputSlot(nDataIndex, true, nOutputRangeIndex));
}
*/
bool		WksReportOperation::HasOutput(int nOutputIndex, int nDataIndex) //0
{
	Tree trOperation;
	GetTree(trOperation);
	TreeNode trGUI = trOperation.GUI;
	
	DataRange	drOutput;
	Datasheet	dsOutput;
	bool bTableMustbeOutside = true;
	
	bool bInsertCurves = false;
	bool bInsertResultsToSrcWks = isOutputInsertColsToDataSheet(trGUI, bInsertCurves, nOutputIndex);
	if(bInsertResultsToSrcWks && !bInsertCurves)
	{
		bTableMustbeOutside = false;
	}
	else if (bInsertResultsToSrcWks && bInsertCurves )
	{
		bTableMustbeOutside = false;
		nOutputIndex = GetOutputRangeIndex(trOperation, GRAPH_FIT_CURVE); //logic is the same as in WksReportOperation::executeWithRange
	}
	else if ( IsOutputDataResultsToNewSheet(trGUI) && isOutputReportSheet(trGUI) )
		bTableMustbeOutside = false;
	
	if ( nOutputIndex == OUTPUT_RESULT_CURVE_RESIDUAL_SHEET )
	{
		if ( !IsOutputSeparateResidualCurveSheet(trOperation) && IsOutputAnyTypeResidualData(trOperation) )
			nOutputIndex = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET;
	}
	else if ( nOutputIndex == OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET )
	{
		bool bReportToFittedCurveSheet = false;
		TreeNode trSheet = trGUI.Output.FindXY.Sheet;
		if ( trSheet )
			bReportToFittedCurveSheet = PDS_FIT_CURVE == str_to_predefined_type(trSheet.strVal);
		
		if ( IsOutputSeparateCalibrationSheet(trOperation) && bReportToFittedCurveSheet )
			nOutputIndex = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET;
	}
	
	return GetOutput(drOutput, dsOutput, GetOutputSlot(nDataIndex, bTableMustbeOutside, nOutputIndex));
}
///end WRONG_SHEET_LEVEL_FOR_STATS_ON_ROW_WHEN_CHANGE_PARAMETER
///end CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE

///------ Folger 03/24/09 QA80-13331-P1 CUSTOMIZED_OUTPUT_COLUMN_LONGNAME_FORMAT_SUPPORT
/// Iris 3/23/2009 QA80-13331-P1 CENTRILIZE_REPORT_COL_LABEL_CODES
//#define STR_COLNAME_ANALYSIS_NAME_SEP "->"
//string WksReportOperation::ConstructReportDataColLabel(LPCSTR lpcszAnalysis, LPCSTR lpcszData)
//{	
	//string str;
	//str.Format("%s%s%s", lpcszData, STR_COLNAME_ANALYSIS_NAME_SEP, lpcszAnalysis);
	//return str;
//}
/////end CENTRILIZE_REPORT_COL_LABEL_CODES

string WksReportOperation::ConstructReportDataColLabel(LPCSTR lpcszAnalysis, LPCSTR lpcszData)
{
	string	strBook, strSheet, strCol;
	okutil_parse_complete_range_string(lpcszData, &strBook, &strSheet, &strCol);
	
	if ( strBook.IsEmpty() || strSheet.IsEmpty() || strCol.IsEmpty() )
	{
		string str;
		str.Format("%s of %s", lpcszAnalysis, lpcszData);
		return str;
	}
	
	string	strBookLN;
	Page	pg(strBook);
	if ( pg )
		strBookLN = pg.GetLongName();
	///------ Folger 09/23/09 PATH_INFO_OUTPUT_TO_SCRIPT_WINDOW_WHEN_DO_FITNL_ON_EXCEL_DATA_PLOT
	if ( strBookLN.IsEmpty() )
		strBookLN = "\"\"";
	///------ End PATH_INFO_OUTPUT_TO_SCRIPT_WINDOW_WHEN_DO_FITNL_ON_EXCEL_DATA_PLOT
	
	string str;
	str.Format("%%A=%s;%%W=%s;%%N=%s;%%B=%s;%%S=%s;", lpcszAnalysis, strSheet, strCol, strBookLN, strBook);
	return str;
}

BOOL	WksReportOperation::MakeFullRangeEscapeString(string& str)
{
	if ( !report_set_escaped_data_string_type(&str, 'P') )
		return FALSE;
	
	return ConvertEscapedString(str);
}
///------ End CUSTOMIZED_OUTPUT_COLUMN_LONGNAME_FORMAT_SUPPORT

///---Sim 06-17-2009 QA80-13786-P2-P4 SPEEP_UP_LINEAR_FIT_WITHOUT_REPORT_TABLE
#ifdef __SPEED_UP_FIT_WITHOUT_REPORT_TABLE__
//virtual
bool WksReportOperation::IsNeedReportTable(TreeNode& trOp)
{
	TreeNode trReport = tree_get_node_by_id(trOp, IDST_REPORT_SHEET_OPTIONS, true);
	if ( trReport )
	{
		TreeNode trBook = tree_get_node_by_id(trReport, IDE_REOPRT_BOOK, true);
		if ( trBook )
		{
			if ( PDS_NONE != cvt_str_to_predefined_type(trBook.strVal) )
				return true;
		}
		
		TreeNode trResultsLog = tree_get_node_by_id(trReport, IDE_REPORT_ADD_TO_RESULTS_LOG, true);
		if ( trResultsLog )
		{
			if ( trResultsLog.nVal )
				return true;
		}
		
		TreeNode trScriptWindow = tree_get_node_by_id(trReport, IDE_REPORT_DUMP_SCRIPTWIN, true);
		if ( trScriptWindow )
		{
			if ( trScriptWindow.nVal )
				return true;
		}
		
		TreeNode trNotesWindow = tree_get_node_by_id(trReport, IDE_REPORT_DUMP_NOTESWIN, true);
		if ( trNotesWindow )
		{
			if ( PDS_NONE != cvt_str_to_predefined_type(trNotesWindow.strVal) )
				return true;
		}
	}
		
	return false;
}
#endif //__SPEED_UP_FIT_WITHOUT_REPORT_TABLE__	
///---END QA80-13786-P2-P4 SPEEP_UP_LINEAR_FIT_WITHOUT_REPORT_TABLE

///------ Folger 10/28/09 QA81-14552 WRONG_REPORT_STATUS_WHEN_CHANGE_PARAM_IN_PA
/// virtual
string	WksReportOperation::GetAutoUpdateType(int nExecMode)
{
	return _get_auto_update_type(nExecMode);
}
///------ End WRONG_REPORT_STATUS_WHEN_CHANGE_PARAM_IN_PA

///---Sim 09-03-2008 QA80-12137 NEW_OPERATION_MECHANISM
/*
This is temporary solution.
These should be in OperationEx.cpp.
But in many place, it use Smart Loading "wksOperation.c", or Find Function "originlab\\wksOperation.c"
In further, we need to clean up this.
*/
#ifdef _OPERATION_EX_
////////////////////////////////////////////////
// OperationEx Class Implement 
////////////////////////////////////////////////
#endif
///---END QA80-12137 NEW_OPERATION_MECHANISM












//--CPY 2010-0208 QA81-14801 OC_NEEDS_ARG_CPY_WITH_PAGE_CONTEXT_OPTN
/*

/// Hong 02/02/10 QA80-14801 FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
#pragma labtalk(1)
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
void		arg_copy_oc_wrapper(string& str)
{
	okutil_arg_copy(&str);
}
/// end FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION
*/
//--
